/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.utils;

import fr.inria.tapenade.representation.NewSymbolHolder;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.utils.Operator;
import fr.inria.tapenade.utils.Phylum;
import fr.inria.tapenade.utils.TapPair;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class Tree {
    private Operator operator;
    private Tree parent;
    private Hashtable<String, Object> annotations;

    protected Tree(Operator operator) {
        this.operator = operator;
    }

    public void setOperator(Operator oper) {
        this.operator = oper;
    }

    public void addChild(Tree addedChild, int rank) {
        TapEnv.toolError("add child tree not allowed on " + this);
    }

    public void addChildren(Tree[] addedChildren, int rank) {
        TapEnv.toolError("add children trees not allowed on " + this);
    }

    public void addChildren(TapList<Tree> addedChildren, int rank) {
        TapEnv.toolError("add children trees not allowed on " + this);
    }

    public void setChild(Tree newChild, int rank) {
        TapEnv.toolError("change child tree not allowed on " + this);
    }

    public Tree cutChild(int rank) {
        TapEnv.toolError("cut child tree not allowed on " + this);
        return null;
    }

    public void removeChild(int rank) {
        TapEnv.toolError("remove child tree not allowed on " + this);
    }

    protected void connectNewChild(Tree newChild, Tree[] parentNewChildren, int index) {
        if (newChild.parent != null) {
            newChild.parent.cutChild(newChild.rankInParent());
        }
        if (parentNewChildren[index] != null) {
            parentNewChildren[index].parent = null;
        }
        parentNewChildren[index] = newChild;
        newChild.parent = this;
    }

    public void setValue(int value) {
        TapEnv.toolError("set int value of leaf tree not allowed on " + this);
    }

    public void setValue(String value) {
        TapEnv.toolError("set String value of leaf tree not allowed on " + this);
    }

    public <T> TapPair<String, T> setAnnotation(String name, T val) {
        TapPair<String, T> annot = this.getAnnotationPair(name);
        if (annot != null) {
            annot.second = val;
        } else {
            if (this.annotations == null) {
                this.annotations = new Hashtable();
            }
            annot = new TapPair<String, T>(name, val);
            this.annotations.put(name, annot);
        }
        return annot;
    }

    public void removeAnnotation(String name) {
        if (this.annotations != null) {
            this.annotations.remove(name);
        }
    }

    public <T> TapPair<String, T> getAnnotationPair(String name) {
        return this.annotations == null ? null : (TapPair)this.annotations.get(name);
    }

    public Enumeration<?> allAnnotations() {
        return this.annotations == null ? null : this.annotations.elements();
    }

    public <T> T getAnnotation(String name) {
        if (this.annotations == null) {
            return null;
        }
        TapPair annot = (TapPair)this.annotations.get(name);
        return annot == null ? null : (T)annot.second;
    }

    public <T> T getRemoveAnnotation(String name) {
        if (this.annotations == null) {
            return null;
        }
        TapPair annot = (TapPair)this.annotations.get(name);
        this.annotations.remove(name);
        return annot == null ? null : (T)annot.second;
    }

    public void copyAnnotations(Tree model) {
        NewSymbolHolder.copySymbolHolderAnnotation(model, this, null);
        if (model.annotations != null) {
            Enumeration<Object> e = model.annotations.elements();
            while (e.hasMoreElements()) {
                TapPair annot = (TapPair)e.nextElement();
                this.setAnnotation((String)annot.first, annot.second);
            }
        }
    }

    public abstract Tree copy();

    public boolean checkSyntax(String path) {
        return this.checkSyntax(null, path);
    }

    protected boolean checkSyntax(Phylum phylum, String path) {
        if (phylum == null) {
            return true;
        }
        boolean foundOp = false;
        for (int i = phylum.operators.length - 1; i >= 0 && !foundOp; --i) {
            foundOp = phylum.operators[i] == this.operator.code;
        }
        if (foundOp) {
            return true;
        }
        TapEnv.toolError("Checking Tree: operator " + this.operator.name + " not allowed at " + path + " .... " + this.parent());
        return false;
    }

    public Operator operator() {
        return this.operator;
    }

    public int opCode() {
        return this.operator.code;
    }

    public String opName() {
        return this.operator.name;
    }

    public abstract boolean isAtom();

    public abstract boolean isStringAtom();

    public abstract boolean isIntAtom();

    public abstract boolean isList();

    public abstract boolean isFixed();

    public Tree parent() {
        return this.parent;
    }

    public void setParent(Tree parent) {
        this.parent = parent;
    }

    public int rankInParent() {
        return this.parent == null ? -1 : this.parent.getRank(this);
    }

    public int length() {
        TapEnv.toolError("no length defined on " + this);
        return 0;
    }

    public Tree[] children() {
        TapEnv.toolError("no children defined on " + this);
        return new Tree[0];
    }

    public TapList<Tree> childrenList() {
        TapEnv.toolError("no children list defined on " + this);
        return null;
    }

    public Tree down(int rank) {
        TapEnv.toolError("Tree down not allowed on " + this);
        return null;
    }

    protected int getRank(Tree child) {
        TapEnv.toolError("getRank not allowed on " + this);
        return -1;
    }

    protected Tree right() {
        int rk = this.rankInParent();
        if (rk < 0 || rk >= this.parent.length()) {
            return null;
        }
        return this.parent.children()[rk];
    }

    public String stringValue() {
        TapEnv.toolError("no String value in " + this);
        return null;
    }

    public int intValue() {
        TapEnv.toolError("no integer value in " + this);
        return 0;
    }

    public abstract boolean equalsTree(Tree var1);

    protected abstract void writeToILFile(BufferedWriter var1) throws IOException;

    public String toString() {
        return "?";
    }
}

