/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.utils;

import fr.inria.tapenade.utils.Tree;

public class TopDownTreeWalk {
    private final Tree base;
    private Tree tree;

    public TopDownTreeWalk(Tree root) {
        this.tree = root;
        this.base = root;
    }

    public Tree get() {
        return this.tree;
    }

    public boolean atEnd() {
        return this.tree == null;
    }

    public void advance() {
        Tree[] sons;
        Tree next = null;
        if (!this.tree.isAtom() && (sons = this.tree.children()).length > 0) {
            next = sons[0];
        }
        if (next == null) {
            if (this.tree == this.base) {
                this.tree = null;
            } else {
                next = this.tree.right();
                if (next == null) {
                    boolean stop = false;
                    while (!stop) {
                        next = this.tree.parent();
                        if (next == null || next == this.base) {
                            stop = true;
                            this.tree = null;
                            continue;
                        }
                        Tree nextr = next.right();
                        if (nextr != null) {
                            this.tree = nextr;
                            stop = true;
                            continue;
                        }
                        this.tree = next;
                    }
                } else {
                    this.tree = next;
                }
            }
        } else {
            this.tree = next;
        }
    }
}

