/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.utils;

import fr.inria.tapenade.representation.TapEnv;
import java.io.IOException;

public final class TapIntList {
    public int head;
    public TapIntList tail;

    public TapIntList(int head, TapIntList tail) {
        this.head = head;
        this.tail = tail;
    }

    public static int length(TapIntList list) {
        int result = 0;
        while (list != null) {
            ++result;
            list = list.tail;
        }
        return result;
    }

    public static boolean contains(TapIntList list, int val) {
        boolean found = false;
        while (!found && list != null) {
            found = list.head == val;
            list = list.tail;
        }
        return found;
    }

    public static boolean contains(TapIntList list, TapIntList vals) {
        boolean result = true;
        while (vals != null && result) {
            result = TapIntList.contains(list, vals.head);
            vals = vals.tail;
        }
        return result;
    }

    public static boolean equalLists(TapIntList list1, TapIntList list2) {
        return TapIntList.contains(list1, list2) && TapIntList.contains(list2, list1);
    }

    public static TapIntList append(TapIntList list1, TapIntList list2) {
        TapIntList hdRes;
        if (list1 == null) {
            return list2;
        }
        TapIntList inRes = hdRes = new TapIntList(-1, null);
        while (list1 != null) {
            inRes = inRes.placdl(list1.head);
            list1 = list1.tail;
        }
        inRes.tail = list2;
        return hdRes.tail;
    }

    public static TapIntList addOffset(TapIntList list, int offset) {
        TapIntList hdResult;
        TapIntList tlResult = hdResult = new TapIntList(-1, null);
        while (list != null) {
            tlResult = tlResult.placdl(offset + list.head);
            list = list.tail;
        }
        return hdResult.tail;
    }

    private static TapIntList convertToSet(TapIntList list) {
        TapIntList resList = null;
        TapIntList tmpList = list;
        while (tmpList != null) {
            if (!TapIntList.contains(resList, tmpList.head)) {
                resList = new TapIntList(tmpList.head, resList);
            }
            tmpList = tmpList.tail;
        }
        return resList;
    }

    public static TapIntList quickUnion(TapIntList list1, TapIntList list2) {
        while (list2 != null) {
            if (!TapIntList.contains(list1, list2.head)) {
                list1 = new TapIntList(list2.head, list1);
            }
            list2 = list2.tail;
        }
        return list1;
    }

    public static TapIntList union(TapIntList list1, TapIntList list2) {
        return TapIntList.convertToSet(TapIntList.append(list1, list2));
    }

    public static TapIntList copy(TapIntList list) {
        TapIntList result;
        TapIntList tlResult = result = new TapIntList(-1, null);
        while (list != null) {
            tlResult = tlResult.placdl(list.head);
            list = list.tail;
        }
        return result.tail;
    }

    public static TapIntList sort(TapIntList list) {
        TapIntList sortedList = new TapIntList(-1, null);
        while (list != null) {
            int rank = list.head;
            TapIntList insortedList = sortedList;
            while (insortedList.tail != null && insortedList.tail.head < rank) {
                insortedList = insortedList.tail;
            }
            insortedList.placdl(list.head);
            list = list.tail;
        }
        return sortedList.tail;
    }

    public static TapIntList addIntoSorted(TapIntList list, int elem) {
        TapIntList toTail = list = new TapIntList(0, list);
        while (toTail != null) {
            if (toTail.tail == null || elem <= toTail.tail.head) {
                if (toTail.tail == null || elem < toTail.tail.head) {
                    toTail.tail = new TapIntList(elem, toTail.tail);
                }
                toTail = null;
                continue;
            }
            toTail = toTail.tail;
        }
        return list.tail;
    }

    public static boolean sortedContains(TapIntList list1, TapIntList list2) {
        boolean contains = true;
        while (contains && list2 != null) {
            while (list1 != null && list1.head < list2.head) {
                list1 = list1.tail;
            }
            if (list1 == null || list1.head != list2.head) {
                contains = false;
            }
            list2 = list2.tail;
        }
        return contains;
    }

    public static boolean sortedIntersects(TapIntList list1, TapIntList list2) {
        boolean intersects = false;
        while (!intersects && list1 != null && list2 != null) {
            while (list1 != null && list1.head < list2.head) {
                list1 = list1.tail;
            }
            if (list1 != null && list1.head == list2.head) {
                intersects = true;
            }
            list2 = list2.tail;
        }
        return intersects;
    }

    public static boolean intersects(TapIntList list1, TapIntList list2) {
        boolean intersect = false;
        while (list1 != null && !intersect) {
            intersect = TapIntList.contains(list2, list1.head);
            list1 = list1.tail;
        }
        return intersect;
    }

    public static TapIntList intersection(TapIntList list, TapIntList interList) {
        TapIntList toRes;
        TapIntList inRes = toRes = new TapIntList(-1, list);
        while (inRes.tail != null) {
            if (!TapIntList.contains(interList, inRes.tail.head)) {
                inRes.tail = inRes.tail.tail;
                continue;
            }
            inRes = inRes.tail;
        }
        return toRes.tail;
    }

    public static TapIntList minus(TapIntList list, TapIntList minusList) {
        TapIntList toRes;
        TapIntList inRes = toRes = new TapIntList(-1, list);
        while (inRes.tail != null) {
            if (TapIntList.contains(minusList, inRes.tail.head)) {
                inRes.tail = inRes.tail.tail;
                continue;
            }
            inRes = inRes.tail;
        }
        return toRes.tail;
    }

    public static TapIntList remove(TapIntList list, int value) {
        TapIntList toRes;
        TapIntList inRes = toRes = new TapIntList(-1, list);
        while (inRes.tail != null) {
            if (inRes.tail.head == value) {
                inRes.tail = inRes.tail.tail;
                continue;
            }
            inRes = inRes.tail;
        }
        return toRes.tail;
    }

    public static TapIntList add(TapIntList list, int value) {
        if (TapIntList.contains(list, value)) {
            return list;
        }
        return new TapIntList(value, list);
    }

    public static TapIntList reverse(TapIntList list) {
        TapIntList result = null;
        while (list != null) {
            result = new TapIntList(list.head, result);
            list = list.tail;
        }
        return result;
    }

    public static int minElem(TapIntList list) {
        if (list == null) {
            return -1;
        }
        int result = list.head;
        list = list.tail;
        while (list != null) {
            if (list.head < result) {
                result = list.head;
            }
            list = list.tail;
        }
        return result;
    }

    public static int maxElem(TapIntList list) {
        if (list == null) {
            return -1;
        }
        int result = list.head;
        list = list.tail;
        while (list != null) {
            if (list.head > result) {
                result = list.head;
            }
            list = list.tail;
        }
        return result;
    }

    public void newR(int val) {
        TapIntList inList = this;
        while (inList.tail != null) {
            inList = inList.tail;
        }
        inList.tail = new TapIntList(val, null);
    }

    public TapIntList placdl(int n) {
        this.tail = new TapIntList(n, this.tail);
        return this.tail;
    }

    public final void appendIfAbsent(int n) {
        TapIntList toList = this;
        while (toList.tail != null && toList.tail.head != n) {
            toList = toList.tail;
        }
        if (toList.tail == null) {
            toList.tail = new TapIntList(n, null);
        }
    }

    public void dump() throws IOException {
        TapEnv.print(this.toString());
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append('<');
        result.append(this.head);
        TapIntList inList = this.tail;
        while (inList != null) {
            result.append(' ').append(inList.head);
            inList = inList.tail;
        }
        return result + ">";
    }
}

