/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.utils;

import fr.inria.tapenade.utils.Operator;
import fr.inria.tapenade.utils.Tree;
import java.io.BufferedWriter;
import java.io.IOException;

class SAtomTree
extends Tree {
    private String value = null;

    protected SAtomTree(Operator operator) {
        super(operator);
    }

    @Override
    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public Tree copy() {
        SAtomTree newTree = (SAtomTree)this.operator().tree();
        newTree.value = this.value;
        newTree.copyAnnotations(this);
        return newTree;
    }

    @Override
    public boolean isAtom() {
        return true;
    }

    @Override
    public boolean isStringAtom() {
        return true;
    }

    @Override
    public boolean isIntAtom() {
        return false;
    }

    @Override
    public boolean isList() {
        return false;
    }

    @Override
    public boolean isFixed() {
        return false;
    }

    @Override
    public int length() {
        return 0;
    }

    @Override
    public Tree[] children() {
        return null;
    }

    @Override
    public String stringValue() {
        return this.value;
    }

    @Override
    public boolean equalsTree(Tree other) {
        if (other == null || this.operator() != other.operator()) {
            return false;
        }
        if (this.value == null) {
            return ((SAtomTree)other).value == null;
        }
        return this.value.equals(((SAtomTree)other).value);
    }

    @Override
    public void writeToILFile(BufferedWriter fileWriter) throws IOException {
        this.operator().writeToILFile(fileWriter);
        fileWriter.write(this.value + System.lineSeparator());
    }

    @Override
    public String toString() {
        return this.operator() + ":" + this.value;
    }
}

