/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.utils;

import fr.inria.tapenade.utils.FixedTree;
import fr.inria.tapenade.utils.IAtomTree;
import fr.inria.tapenade.utils.ListTree;
import fr.inria.tapenade.utils.SAtomTree;
import fr.inria.tapenade.utils.Tree;
import java.io.BufferedWriter;
import java.io.IOException;

public class Operator {
    public final String name;
    public final int code;
    public final int arity;
    public static final int LIST_ARITY = -1;
    public static final int ATOM_INT_ARITY = -2;
    public static final int ATOM_STRING_ARITY = -3;
    protected final int[] childrenPhyla;

    public Operator(String nameStr, int code, int arity, int[] phyla) {
        this.name = nameStr;
        this.code = code;
        this.arity = arity;
        this.childrenPhyla = phyla;
    }

    public Tree tree() {
        switch (this.arity) {
            case -3: {
                return new SAtomTree(this);
            }
            case -2: {
                return new IAtomTree(this);
            }
            case -1: {
                return new ListTree(this);
            }
        }
        return new FixedTree(this);
    }

    public boolean isFixed() {
        return this.arity > -1;
    }

    public boolean isList() {
        return this.arity == -1;
    }

    public boolean isAtom() {
        return this.arity < -1;
    }

    public boolean isStringAtom() {
        return this.arity == -3;
    }

    public boolean isIntAtom() {
        return this.arity == -2;
    }

    public void writeToILFile(BufferedWriter fileWriter) throws IOException {
        fileWriter.write(this.code + 58 + this.name + System.lineSeparator());
    }

    public String toString() {
        return this.name;
    }
}

