/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.utils;

import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.utils.ILLangOps;
import fr.inria.tapenade.utils.Operator;
import fr.inria.tapenade.utils.Phylum;
import fr.inria.tapenade.utils.Tree;
import java.io.BufferedWriter;
import java.io.IOException;

class ListTree
extends Tree {
    private Tree[] sons = new Tree[0];
    private int nbSons = 0;

    protected ListTree(Operator operator) {
        super(operator);
    }

    @Override
    public void addChild(Tree addedChild, int rank) {
        if (rank < 0) {
            rank = rank + 2 + this.nbSons;
        }
        if (0 < rank && rank <= this.nbSons + 1) {
            int i;
            ++this.nbSons;
            Tree[] newSons = new Tree[this.nbSons];
            for (i = 0; i < rank - 1; ++i) {
                newSons[i] = this.sons[i];
            }
            this.connectNewChild(addedChild, newSons, rank - 1);
            for (i = rank; i < this.nbSons; ++i) {
                newSons[i] = this.sons[i - 1];
            }
            this.sons = newSons;
        }
    }

    @Override
    public void addChildren(Tree[] addedChildren, int rank) {
        int nbNew = addedChildren.length;
        if (rank < 0) {
            rank = rank + 2 + this.nbSons;
        }
        if (0 < rank && rank <= this.nbSons + nbNew) {
            int index;
            Tree[] newSons = new Tree[this.nbSons + nbNew];
            for (index = rank - 2; index >= 0; --index) {
                newSons[index] = this.sons[index];
            }
            for (index = nbNew - 1; index >= 0; --index) {
                if (addedChildren[index] == null) continue;
                this.connectNewChild(addedChildren[index], newSons, index + rank - 1);
            }
            for (index = rank - 1; index < this.nbSons; ++index) {
                newSons[index + nbNew] = this.sons[index];
            }
            this.nbSons += nbNew;
            this.sons = newSons;
        }
    }

    @Override
    public void addChildren(TapList<Tree> addedChildren, int rank) {
        int nbNew = TapList.length(addedChildren);
        if (rank < 0) {
            rank = rank + 2 + this.nbSons;
        }
        if (0 < rank && rank <= this.nbSons + nbNew) {
            int index;
            Tree[] newSons = new Tree[this.nbSons + nbNew];
            for (index = rank - 2; index >= 0; --index) {
                newSons[index] = this.sons[index];
            }
            for (index = 0; index < nbNew; ++index) {
                if (addedChildren.head != null) {
                    this.connectNewChild((Tree)addedChildren.head, newSons, index + rank - 1);
                }
                addedChildren = addedChildren.tail;
            }
            for (index = rank - 1; index < this.nbSons; ++index) {
                newSons[index + nbNew] = this.sons[index];
            }
            this.nbSons += nbNew;
            this.sons = newSons;
        }
    }

    @Override
    public void setChild(Tree newChild, int rank) {
        if (rank <= this.nbSons) {
            this.connectNewChild(newChild, this.sons, rank - 1);
        } else {
            Tree[] newSons = new Tree[rank];
            for (int i = 0; i < this.nbSons; ++i) {
                newSons[i] = this.sons[i];
            }
            this.connectNewChild(newChild, newSons, rank - 1);
            this.nbSons = rank;
            this.sons = newSons;
        }
    }

    @Override
    public Tree cutChild(int rank) {
        Tree child = this.sons[rank - 1];
        if (child != null) {
            child.setParent(null);
            this.sons[rank - 1] = ILLangOps.ops(138).tree();
        }
        return child;
    }

    @Override
    public void removeChild(int rank) {
        if (0 < rank && rank <= this.nbSons) {
            int i;
            this.sons[rank - 1].setParent(null);
            Tree[] newSons = new Tree[this.nbSons - 1];
            for (i = this.nbSons - 1; i > rank - 1; --i) {
                newSons[i - 1] = this.sons[i];
            }
            for (i = rank - 2; i >= 0; --i) {
                newSons[i] = this.sons[i];
            }
            --this.nbSons;
            this.sons = newSons;
        }
    }

    @Override
    public Tree copy() {
        ListTree newTree = (ListTree)this.operator().tree();
        newTree.nbSons = this.nbSons;
        newTree.sons = new Tree[this.nbSons];
        for (int i = this.nbSons - 1; i >= 0; --i) {
            if (this.sons[i] != null) {
                newTree.connectNewChild(this.sons[i].copy(), newTree.sons, i);
                continue;
            }
            newTree.sons[i] = null;
        }
        newTree.copyAnnotations(this);
        return newTree;
    }

    @Override
    protected boolean checkSyntax(Phylum phylum, String path) {
        boolean correct = super.checkSyntax(phylum, path);
        int[] childrenPhyla = this.operator().childrenPhyla;
        Phylum childPhylum = childrenPhyla == null ? null : ILLangOps.phyla(childrenPhyla[0]);
        path = path + " " + this.operator().name + ":";
        for (int i = 0; i < this.nbSons; ++i) {
            if (this.sons[i] == null) {
                TapEnv.toolError("Checking Tree: null child at " + path + (i + 1) + "... " + this.parent());
                correct = false;
                continue;
            }
            if (this.sons[i].checkSyntax(childPhylum, path + (i + 1))) continue;
            correct = false;
        }
        return correct;
    }

    @Override
    public boolean isAtom() {
        return false;
    }

    @Override
    public boolean isStringAtom() {
        return false;
    }

    @Override
    public boolean isIntAtom() {
        return false;
    }

    @Override
    public boolean isList() {
        return true;
    }

    @Override
    public boolean isFixed() {
        return false;
    }

    @Override
    public int length() {
        return this.nbSons;
    }

    @Override
    public Tree[] children() {
        return this.sons;
    }

    @Override
    public TapList<Tree> childrenList() {
        TapList<Tree> list = null;
        for (int index = this.nbSons - 1; index >= 0; --index) {
            list = new TapList<Tree>(this.sons[index], list);
        }
        return list;
    }

    @Override
    public Tree down(int n) {
        if (n < 0) {
            n = this.nbSons + n + 1;
        }
        return 0 < n && n <= this.nbSons ? this.sons[n - 1] : null;
    }

    @Override
    public int getRank(Tree son) {
        for (int i = this.nbSons - 1; i >= 0; --i) {
            if (this.sons[i] != son) continue;
            return i + 1;
        }
        return -1;
    }

    @Override
    public boolean equalsTree(Tree other) {
        if (other == null || this.operator() != other.operator() || this.nbSons != ((ListTree)other).nbSons) {
            return false;
        }
        for (int i = this.nbSons - 1; i >= 0; --i) {
            if (!(this.sons[i] == null ? ((ListTree)other).sons[i] != null : !this.sons[i].equalsTree(((ListTree)other).sons[i]))) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void writeToILFile(BufferedWriter fileWriter) throws IOException {
        this.operator().writeToILFile(fileWriter);
        for (Tree son : this.sons) {
            if (son == null) {
                ILLangOps.ops(138).writeToILFile(fileWriter);
                continue;
            }
            son.writeToILFile(fileWriter);
        }
        ILLangOps.ops(65).writeToILFile(fileWriter);
    }

    @Override
    public String toString() {
        StringBuilder childrenStr = new StringBuilder();
        for (int i = this.sons.length - 1; i >= 0; --i) {
            childrenStr.insert(0, this.sons[i]);
            if (i <= 0) continue;
            childrenStr.insert(0, ", ");
        }
        return this.operator() + "[" + childrenStr + "]";
    }
}

