/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.utils;

import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.utils.TapIntList;
import java.io.IOException;

public class BoolVector {
    protected static final short B_SET_SIZE = 32;
    protected static final int B_SET_ONE = 1;
    protected static final int B_SET_ZERO = 0;
    protected static final int B_SET_ALL = -1;
    protected int[] bSets;
    private int length = -1;
    private TapIntList contents;

    public int grossLength() {
        return this.bSets.length * 32;
    }

    public final boolean isSparse() {
        return this.contents != null;
    }

    public BoolVector(int size) {
        int nbSet = (size - 1) / 32 + 1;
        this.bSets = new int[nbSet];
        this.setFalse();
    }

    public BoolVector(boolean sparse, int size) {
        if (sparse) {
            this.length = size;
            this.contents = new TapIntList(-1, null);
        } else {
            int nbSet = (size - 1) / 32 + 1;
            this.bSets = new int[nbSet];
            this.setFalse();
        }
    }

    protected static int getSubInt(int origInt, int fromBit, int toBit) {
        return origInt >>> fromBit & -1 >>> 32 - toBit + fromBit;
    }

    protected static int setSubInt(int origInt, int cpInt, int fromBit, int toBit) {
        int mask = 0;
        if (fromBit > 0) {
            mask |= -1 >>> 32 - fromBit;
        }
        if (toBit < 32) {
            mask |= -1 << toBit;
        }
        int result = origInt & mask;
        mask = cpInt << fromBit & -1 >>> 32 - toBit;
        return result |= mask;
    }

    private static int orSubInt(int origInt, int orInt, int fromBit, int toBit) {
        return origInt | orInt << fromBit & -1 << fromBit;
    }

    public final void setFalse() {
        if (this.isSparse()) {
            this.contents.tail = null;
        } else {
            for (int i = this.bSets.length - 1; i >= 0; --i) {
                this.bSets[i] = 0;
            }
        }
    }

    public final void setTrue() {
        if (this.isSparse()) {
            TapEnv.toolWarning(-1, "BoolVector.setTrue() on a sparse representation");
            this.contents.tail = null;
            for (int i = this.length - 1; i >= 0; --i) {
                this.contents.placdl(i);
            }
        } else {
            for (int i = this.bSets.length - 1; i >= 0; --i) {
                this.bSets[i] = -1;
            }
        }
    }

    public final void set(int rank, boolean val) {
        if (this.isSparse()) {
            TapIntList inContents = this.contents;
            while (inContents.tail != null && inContents.tail.head < rank) {
                inContents = inContents.tail;
            }
            if (val) {
                if (inContents.tail == null || inContents.tail.head != rank) {
                    inContents.placdl(rank);
                }
            } else if (inContents.tail != null && inContents.tail.head == rank) {
                inContents.tail = inContents.tail.tail;
            }
        } else if (rank >= 0) {
            int setRank = rank / 32;
            int mask = 1 << rank % 32;
            this.bSets[setRank] = val ? this.bSets[setRank] | mask : this.bSets[setRank] & ~mask;
        }
    }

    public final void set(TapIntList indexes, boolean val) {
        while (indexes != null) {
            this.set(indexes.head, val);
            indexes = indexes.tail;
        }
    }

    public final boolean get(int rank) {
        if (this.isSparse()) {
            return TapIntList.contains(this.contents.tail, rank);
        }
        int setRank = rank >= 0 ? rank / 32 : -1;
        int mask = 1 << rank % 32;
        return (this.bSets[setRank] & mask) != 0;
    }

    public final BoolVector copy() {
        BoolVector result = new BoolVector(this.isSparse(), this.isSparse() ? this.length : this.bSets.length * 32);
        result.setCopy(this);
        return result;
    }

    public final BoolVector copy(int len, int finalLen) {
        BoolVector result = new BoolVector(this.isSparse(), finalLen);
        result.setCopy(this, Math.min(len, finalLen));
        return result;
    }

    public final void setCopy(BoolVector model) {
        if (this.isSparse()) {
            this.contents.tail = TapIntList.copy(model.contents.tail);
        } else {
            int maxIdx = StrictMath.min(this.bSets.length, model.bSets.length);
            if (maxIdx >= 0) {
                System.arraycopy(model.bSets, 0, this.bSets, 0, maxIdx);
            }
        }
    }

    public final void setCopy(BoolVector model, int len) {
        if (this.isSparse()) {
            this.contents.tail = null;
            TapIntList inCopy = this.contents;
            TapIntList inContents = model.contents.tail;
            while (inContents != null) {
                if (inContents.head < len) {
                    inCopy = inCopy.placdl(inContents.head);
                    inContents = inContents.tail;
                    continue;
                }
                inContents = null;
            }
        } else {
            int maxk = len / 32;
            if (len % 32 != 0) {
                int mask = ~(-1 << len % 32);
                this.bSets[maxk] = model.bSets[maxk] & mask;
            }
            while (--maxk >= 0) {
                this.bSets[maxk] = model.bSets[maxk];
            }
        }
    }

    public final void cumulOr(BoolVector other) {
        if (this.isSparse()) {
            if (other.isSparse()) {
                TapIntList inContents = this.contents;
                TapIntList inOther = other.contents.tail;
                while (inOther != null) {
                    while (inContents.tail != null && inContents.tail.head < inOther.head) {
                        inContents = inContents.tail;
                    }
                    if (inContents.tail == null || inContents.tail.head > inOther.head) {
                        inContents = inContents.placdl(inOther.head);
                    }
                    inOther = inOther.tail;
                }
            } else {
                TapIntList inContents = this.contents;
                for (int i = 0; i < this.length; ++i) {
                    if (inContents.tail == null || inContents.tail.head > i) {
                        if (!other.get(i)) continue;
                        inContents = inContents.placdl(i);
                        continue;
                    }
                    inContents = inContents.tail;
                }
            }
        } else if (other.isSparse()) {
            TapIntList inOther = other.contents.tail;
            while (inOther != null) {
                this.set(inOther.head, true);
                inOther = inOther.tail;
            }
        } else {
            for (int i = this.bSets.length - 1; i >= 0; --i) {
                int n = i;
                this.bSets[n] = this.bSets[n] | other.bSets[i];
            }
        }
    }

    public final void cumulOr(BoolVector other, int len) {
        if (this.isSparse()) {
            if (other.isSparse()) {
                TapIntList inContents = this.contents;
                TapIntList inOther = other.contents.tail;
                while (inOther != null) {
                    if (inOther.head >= len) {
                        inOther = null;
                        continue;
                    }
                    while (inContents.tail != null && inContents.tail.head < inOther.head) {
                        inContents = inContents.tail;
                    }
                    if (inContents.tail == null || inContents.tail.head > inOther.head) {
                        inContents = inContents.placdl(inOther.head);
                    }
                    inOther = inOther.tail;
                }
            } else {
                TapIntList inContents = this.contents;
                for (int i = 0; i < len; ++i) {
                    if (inContents.tail == null || inContents.tail.head > i) {
                        if (!other.get(i)) continue;
                        inContents = inContents.placdl(i);
                        continue;
                    }
                    inContents = inContents.tail;
                }
            }
        } else if (other.isSparse()) {
            TapIntList inOther = other.contents.tail;
            while (inOther != null && inOther.head < len) {
                this.set(inOther.head, true);
                inOther = inOther.tail;
            }
        } else {
            int maxk = len / 32;
            if (len % 32 != 0) {
                int mask = ~(-1 << len % 32);
                int n = maxk;
                this.bSets[n] = this.bSets[n] | other.bSets[maxk] & mask;
            }
            while (--maxk >= 0) {
                int n = maxk;
                this.bSets[n] = this.bSets[n] | other.bSets[maxk];
            }
        }
    }

    public final void cumulOr(BoolVector newVect, int newStart, int start, int len) {
        if (this.isSparse()) {
            TapEnv.toolError("cumulOr() (with offset) not yet implemented on sparse Boolvector");
        } else {
            int maxlen;
            if (newVect.isSparse()) {
                TapEnv.toolError("dense.cumulOr(sparse) (with offset) not yet implemented");
            }
            if (len > (maxlen = this.bSets.length * 32 - start)) {
                len = maxlen;
            }
            if (len > (maxlen = newVect.bSets.length * 32 - newStart)) {
                len = maxlen;
            }
            while (len > 0) {
                int sz = 32 - start % 32;
                if (sz > 32 - newStart % 32) {
                    sz = 32 - newStart % 32;
                }
                if (sz > len) {
                    sz = len;
                }
                if (sz <= 0) continue;
                this.bSets[start / 32] = BoolVector.orSubInt(this.bSets[start / 32], BoolVector.getSubInt(newVect.bSets[newStart / 32], newStart % 32, newStart % 32 + sz), start % 32, start % 32 + sz);
                newStart += sz;
                start += sz;
                len -= sz;
            }
        }
    }

    public final boolean cumulOrGrows(BoolVector other) {
        boolean grows = false;
        if (this.isSparse()) {
            if (!other.isSparse()) {
                TapEnv.toolError("sparse.cumulOrGrows(dense) not yet implemented");
            }
            TapIntList inContents = this.contents;
            TapIntList inOther = other.contents.tail;
            while (inOther != null) {
                while (inContents.tail != null && inContents.tail.head < inOther.head) {
                    inContents = inContents.tail;
                }
                if (inContents.tail == null || inContents.tail.head > inOther.head) {
                    inContents = inContents.placdl(inOther.head);
                    grows = true;
                }
                inOther = inOther.tail;
            }
        } else {
            int i;
            if (other.isSparse()) {
                TapEnv.toolError("dense.cumulOrGrows(sparse) not yet implemented");
            }
            if ((i = other.bSets.length) > this.bSets.length) {
                i = this.bSets.length;
            }
            while (--i >= 0) {
                int oldVal = this.bSets[i];
                int n = i;
                this.bSets[n] = this.bSets[n] | other.bSets[i];
                if (this.bSets[i] == oldVal) continue;
                grows = true;
            }
        }
        return grows;
    }

    public final boolean cumulOrGrows(BoolVector other, int len) {
        boolean grows = false;
        if (this.isSparse()) {
            if (!other.isSparse()) {
                TapEnv.toolError("sparse.cumulOrGrows(dense, l) not yet implemented");
            }
            TapIntList inContents = this.contents;
            TapIntList inOther = other.contents.tail;
            while (inOther != null) {
                if (inOther.head >= len) {
                    inOther = null;
                    continue;
                }
                while (inContents.tail != null && inContents.tail.head < inOther.head) {
                    inContents = inContents.tail;
                }
                if (inContents.tail == null || inContents.tail.head > inOther.head) {
                    inContents = inContents.placdl(inOther.head);
                    grows = true;
                }
                inOther = inOther.tail;
            }
        } else {
            int oldVal;
            if (other.isSparse()) {
                TapEnv.toolError("dense.cumulOrGrows(sparse, l) not yet implemented");
            }
            int maxk = len / 32;
            if (len % 32 != 0) {
                int mask = ~(-1 << len % 32);
                oldVal = this.bSets[maxk] & mask;
                int n = maxk;
                this.bSets[n] = this.bSets[n] | other.bSets[maxk] & mask;
                if ((this.bSets[maxk] & mask) != oldVal) {
                    grows = true;
                }
            }
            while (--maxk >= 0) {
                oldVal = this.bSets[maxk];
                int n = maxk;
                this.bSets[n] = this.bSets[n] | other.bSets[maxk];
                if (this.bSets[maxk] == oldVal) continue;
                grows = true;
            }
        }
        return grows;
    }

    public final void cumulAnd(BoolVector other) {
        if (this.isSparse()) {
            if (!other.isSparse()) {
                TapEnv.toolError("sparse.cumulAnd(dense) not yet implemented");
            }
            TapIntList inContents = this.contents;
            TapIntList inOther = other.contents.tail;
            while (inOther != null) {
                while (inContents.tail != null && inContents.tail.head < inOther.head) {
                    inContents.tail = inContents.tail.tail;
                }
                if (inContents.tail == null) {
                    inOther = null;
                    continue;
                }
                if (inContents.tail.head == inOther.head) {
                    inContents = inContents.tail;
                } else {
                    inContents.tail = inContents.tail.tail;
                }
                inOther = inOther.tail;
            }
        } else {
            if (other.isSparse()) {
                TapEnv.toolError("dense.cumulAnd(sparse) not yet implemented");
            }
            for (int i = this.bSets.length - 1; i >= 0; --i) {
                int n = i;
                this.bSets[n] = this.bSets[n] & other.bSets[i];
            }
        }
    }

    public final void cumulAnd(BoolVector other, int len) {
        if (this.isSparse()) {
            if (!other.isSparse()) {
                TapEnv.toolError("sparse.cumulAnd(dense, l) not yet implemented");
            }
            TapIntList inContents = this.contents;
            TapIntList inOther = other.contents.tail;
            while (inOther != null) {
                if (inOther.head >= len) {
                    inOther = null;
                    continue;
                }
                while (inContents.tail != null && inContents.tail.head < inOther.head) {
                    inContents.tail = inContents.tail.tail;
                }
                if (inContents.tail == null) {
                    inOther = null;
                    continue;
                }
                if (inContents.tail.head == inOther.head) {
                    inContents = inContents.tail;
                } else {
                    inContents.tail = inContents.tail.tail;
                }
                inOther = inOther.tail;
            }
        } else {
            if (other.isSparse()) {
                TapEnv.toolError("dense.cumulAnd(sparse, l) not yet implemented");
            }
            int maxk = len / 32;
            if (len % 32 != 0) {
                int mask = -1 << len % 32;
                int n = maxk;
                this.bSets[n] = this.bSets[n] & (other.bSets[maxk] | mask);
            }
            while (--maxk >= 0) {
                int n = maxk;
                this.bSets[n] = this.bSets[n] & other.bSets[maxk];
            }
        }
    }

    public final void cumulMinus(BoolVector other) {
        if (this.isSparse()) {
            TapEnv.toolError("cumulMinus() not yet implemented on sparse BoolVector");
        } else {
            if (other.isSparse()) {
                TapEnv.toolError("dense.cumulMinus(sparse) not yet implemented");
            }
            for (int i = this.bSets.length - 1; i >= 0; --i) {
                int n = i;
                this.bSets[n] = this.bSets[n] & ~other.bSets[i];
            }
        }
    }

    public final void cumulMinus(BoolVector other, int len) {
        if (this.isSparse()) {
            TapEnv.toolError("cumulMinus() not yet implemented on sparse BoolVector");
        } else {
            if (other.isSparse()) {
                TapEnv.toolError("dense.cumulMinus(sparse, l) not yet implemented");
            }
            int maxk = len / 32;
            if (len % 32 != 0) {
                int mask = -1 << len % 32;
                int n = maxk;
                this.bSets[n] = this.bSets[n] & (~other.bSets[maxk] | mask);
            }
            while (--maxk >= 0) {
                int n = maxk;
                this.bSets[n] = this.bSets[n] & ~other.bSets[maxk];
            }
        }
    }

    public final BoolVector and(BoolVector other) {
        BoolVector resVector = new BoolVector(this.isSparse(), this.isSparse() ? this.length : 0);
        if (this.isSparse()) {
            if (!other.isSparse()) {
                TapEnv.toolError("sparse.and(dense) not yet implemented");
            }
            TapIntList inContents = this.contents.tail;
            TapIntList inOther = other.contents.tail;
            TapIntList inNewContents = resVector.contents;
            while (inContents != null && inOther != null) {
                while (inContents != null && inContents.head < inOther.head) {
                    inContents = inContents.tail;
                }
                if (inContents != null && inContents.head == inOther.head) {
                    inNewContents = inNewContents.placdl(inContents.head);
                    inContents = inContents.tail;
                }
                inOther = inOther.tail;
            }
        } else {
            if (other.isSparse()) {
                TapEnv.toolError("dense.and(sparse) not yet implemented");
            }
            resVector.bSets = new int[this.bSets.length];
            for (int i = this.bSets.length - 1; i >= 0; --i) {
                resVector.bSets[i] = this.bSets[i] & other.bSets[i];
            }
        }
        return resVector;
    }

    public final BoolVector or(BoolVector other) {
        BoolVector resVector = new BoolVector(this.isSparse(), this.isSparse() ? this.length : 0);
        if (this.isSparse()) {
            if (!other.isSparse()) {
                TapEnv.toolError("sparse.or(dense) not yet implemented");
            }
            TapIntList inContents = this.contents.tail;
            TapIntList inOther = other.contents.tail;
            TapIntList inNewContents = resVector.contents;
            while (inContents != null || inOther != null) {
                while (inContents != null && (inOther == null || inContents.head < inOther.head)) {
                    inNewContents = inNewContents.placdl(inContents.head);
                    inContents = inContents.tail;
                }
                if (inContents != null && inOther != null && inContents.head == inOther.head) {
                    inContents = inContents.tail;
                }
                if (inOther == null) continue;
                inNewContents = inNewContents.placdl(inOther.head);
                inOther = inOther.tail;
            }
        } else {
            if (other.isSparse()) {
                TapEnv.toolError("dense.or(sparse) not yet implemented");
            }
            resVector.bSets = new int[this.bSets.length];
            for (int i = this.bSets.length - 1; i >= 0; --i) {
                resVector.bSets[i] = this.bSets[i] | other.bSets[i];
            }
        }
        return resVector;
    }

    public final BoolVector minus(BoolVector other) {
        BoolVector resVector = new BoolVector(this.isSparse(), this.isSparse() ? this.length : 0);
        if (this.isSparse()) {
            TapEnv.toolError("minus() not yet implemented on sparse BoolVector");
        } else {
            if (other.isSparse()) {
                TapEnv.toolError("dense.minus(sparse) not yet implemented");
            }
            resVector.bSets = new int[this.bSets.length];
            for (int i = this.bSets.length - 1; i >= 0; --i) {
                resVector.bSets[i] = this.bSets[i] & ~other.bSets[i];
            }
        }
        return resVector;
    }

    public final BoolVector xor(BoolVector other) {
        BoolVector resVector = new BoolVector(this.isSparse(), this.isSparse() ? this.length : 0);
        if (this.isSparse()) {
            if (!other.isSparse()) {
                TapEnv.toolError("sparse.xor(dense) not yet implemented");
            }
            TapIntList inContents = this.contents.tail;
            TapIntList inOther = other.contents.tail;
            TapIntList inNewContents = resVector.contents;
            while (inContents != null || inOther != null) {
                while (inContents != null && (inOther == null || inContents.head < inOther.head)) {
                    inNewContents = inNewContents.placdl(inContents.head);
                    inContents = inContents.tail;
                }
                if (inContents == null || inOther == null) continue;
                if (inContents.head == inOther.head) {
                    inContents = inContents.tail;
                } else {
                    inNewContents = inNewContents.placdl(inOther.head);
                }
                inOther = inOther.tail;
            }
        } else {
            if (other.isSparse()) {
                TapEnv.toolError("dense.xor(sparse) not yet implemented");
            }
            resVector.bSets = new int[this.bSets.length];
            for (int i = this.bSets.length - 1; i >= 0; --i) {
                resVector.bSets[i] = this.bSets[i] ^ other.bSets[i];
            }
        }
        return resVector;
    }

    public final BoolVector not() {
        BoolVector resVector = new BoolVector(this.isSparse(), this.isSparse() ? this.length : 0);
        if (this.isSparse()) {
            TapEnv.toolError("not() not yet implemented on sparse BoolVector");
        } else {
            resVector.bSets = new int[this.bSets.length];
            for (int i = this.bSets.length - 1; i >= 0; --i) {
                resVector.bSets[i] = ~this.bSets[i];
            }
        }
        return resVector;
    }

    public final TapIntList trueIndexList(int size) {
        TapIntList result = null;
        if (this.isSparse()) {
            result = TapIntList.copy(this.contents.tail);
        } else {
            for (int i = size - 1; i >= 0; --i) {
                if (!this.get(i)) continue;
                result = new TapIntList(i, result);
            }
        }
        return result;
    }

    public final boolean contains(TapIntList indices) {
        if (this.isSparse()) {
            return TapIntList.sortedContains(this.contents.tail, indices);
        }
        boolean contains = true;
        while (contains && indices != null) {
            if (!this.get(indices.head)) {
                contains = false;
            }
            indices = indices.tail;
        }
        return contains;
    }

    public final boolean intersects(TapIntList indices) {
        if (this.isSparse()) {
            return TapIntList.sortedIntersects(this.contents.tail, indices);
        }
        boolean intersects = false;
        while (!intersects && indices != null) {
            if (this.get(indices.head)) {
                intersects = true;
            }
            indices = indices.tail;
        }
        return intersects;
    }

    public final boolean intersects(BoolVector other, int len) {
        boolean intersects = false;
        if (this.isSparse()) {
            if (other.isSparse()) {
                TapIntList inContents = this.contents.tail;
                TapIntList inOther = other.contents.tail;
                while (!intersects && inContents != null && inOther != null && inContents.head < len) {
                    while (inContents != null && inContents.head < inOther.head) {
                        inContents = inContents.tail;
                    }
                    if (inContents != null && inContents.head < len && inContents.head == inOther.head) {
                        intersects = true;
                    }
                    inOther = inOther.tail;
                }
            } else {
                TapIntList inContents = this.contents.tail;
                while (!intersects && inContents != null && inContents.head < len) {
                    intersects = other.get(inContents.head);
                    inContents = inContents.tail;
                }
            }
        } else {
            if (other.isSparse()) {
                TapEnv.toolError("dense.intersects(sparse, l) not yet implemented");
            }
            int lastBits = len % 32;
            int i = len / 32;
            if (lastBits != 0) {
                boolean bl = intersects = (this.bSets[i] & other.bSets[i]) << 32 - lastBits != 0;
            }
            while (!intersects && --i >= 0) {
                intersects = (this.bSets[i] & other.bSets[i]) != 0;
            }
        }
        return intersects;
    }

    public final boolean contains(BoolVector other, int len) {
        boolean contains = true;
        if (this.isSparse()) {
            if (!other.isSparse()) {
                TapEnv.toolError("sparse.contains(dense, l) not yet implemented");
            }
            TapIntList inContents = this.contents.tail;
            TapIntList inOther = other.contents.tail;
            while (contains && inOther != null && inOther.head < len) {
                while (inContents != null && inContents.head < inOther.head) {
                    inContents = inContents.tail;
                }
                if (inContents == null || inContents.head < len && inContents.head != inOther.head) {
                    contains = false;
                }
                inOther = inOther.tail;
            }
        } else {
            if (other.isSparse()) {
                TapEnv.toolError("dense.contains(sparse, l) not yet implemented");
            }
            int lastBits = len % 32;
            int i = len / 32;
            if (lastBits != 0) {
                boolean bl = contains = (this.bSets[i] & other.bSets[i]) << 32 - lastBits == other.bSets[i] << 32 - lastBits;
            }
            while (contains && --i >= 0) {
                contains = (this.bSets[i] & other.bSets[i]) == other.bSets[i];
            }
        }
        return contains;
    }

    public final int distance(BoolVector other, int len) {
        BoolVector diffVector = this.xor(other);
        int count = 0;
        if (this.isSparse()) {
            count = TapIntList.length(diffVector.contents.tail);
        } else {
            int maxk = len / 32;
            int reste = len % 32;
            if (reste != 0) {
                count += BoolVector.nbOnes(diffVector.bSets[maxk], reste);
            }
            while (--maxk >= 0) {
                count += BoolVector.nbOnes(diffVector.bSets[maxk], 32);
            }
        }
        return count;
    }

    private static int nbOnes(int boolInt, int len) {
        int count = 0;
        while (--len >= 0) {
            if ((boolInt & 1) != 0) {
                ++count;
            }
            boolInt >>= 1;
        }
        return count;
    }

    public final boolean equals(BoolVector other, int len) {
        boolean areEqual = true;
        if (this.isSparse()) {
            if (!other.isSparse()) {
                TapEnv.toolError("sparse.equals(dense, l) not yet implemented");
            }
            TapIntList inContents = this.contents.tail;
            TapIntList inOther = other.contents.tail;
            while (areEqual && (inContents != null && inContents.head < len || inOther != null && inOther.head < len)) {
                if (inContents == null || inContents.head >= len || inOther == null || inOther.head >= len || inContents.head != inOther.head) {
                    areEqual = false;
                    continue;
                }
                inContents = inContents.tail;
                inOther = inOther.tail;
            }
        } else {
            if (other.isSparse()) {
                TapEnv.toolError("dense.equals(sparse, l) not yet implemented");
            }
            int lastBits = len % 32;
            int i = len / 32;
            if (lastBits != 0) {
                boolean bl = areEqual = this.bSets[i] << 32 - lastBits == other.bSets[i] << 32 - lastBits;
            }
            while (areEqual && --i >= 0) {
                areEqual = this.bSets[i] == other.bSets[i];
            }
        }
        return areEqual;
    }

    public final boolean isFalse(int len) {
        boolean isEmpty = true;
        if (this.isSparse()) {
            isEmpty = this.contents.tail == null || this.contents.tail.head >= len;
        } else {
            int lastBits = len % 32;
            int i = len / 32;
            if (lastBits != 0) {
                boolean bl = isEmpty = this.bSets[i] << 32 - lastBits == 0;
            }
            while (isEmpty && --i >= 0) {
                isEmpty = this.bSets[i] == 0;
            }
        }
        return isEmpty;
    }

    public final int maxTrueRank(int len) {
        if (this.isSparse()) {
            TapEnv.toolError("maxTrueRank() not yet implemented on sparse BoolVector");
            return -1;
        }
        while (len > 0 && !this.get(len - 1)) {
            --len;
        }
        return len - 1;
    }

    public void setDeclared(int zone, int[] curBlockMap, boolean val) {
        if (zone < curBlockMap[3]) {
            this.set(zone, val);
        }
    }

    public void setDeclared(TapIntList zones, int[] curBlockMap, boolean val) {
        while (zones != null) {
            if (zones.head < curBlockMap[3]) {
                this.set(zones.head, val);
            }
            zones = zones.tail;
        }
    }

    public final int numberOfOnes(int length) {
        if (this.isSparse()) {
            return TapIntList.length(this.contents.tail);
        }
        int number = 0;
        for (int i = length - 1; i >= 0; --i) {
            if (!this.get(i)) continue;
            ++number;
        }
        return number;
    }

    public void dump() throws IOException {
        TapEnv.print(this.toString());
    }

    public void dump(int length) throws IOException {
        TapEnv.print(this.toString(length));
    }

    public void dump(int[] map) throws IOException {
        TapEnv.print(this.toString(map));
    }

    public final String toString(int[] map) {
        StringBuilder res = new StringBuilder("[");
        for (int k = 1; k < map.length; ++k) {
            if (k > 1) {
                res.append('|');
            }
            int offset = map[k - 1];
            int ksz = map[k] - offset;
            for (int i = 0; i < ksz; ++i) {
                if (!this.isSparse() && i > 0 && i % 10 == 0) {
                    res.append('(').append(i / 10 % 10).append(')');
                }
                if (this.isSparse()) {
                    if (!this.get(offset + i)) continue;
                    res.append(i).append(' ');
                    continue;
                }
                res.append(this.get(offset + i) ? (char)'X' : '.');
            }
        }
        return res + "]";
    }

    public final String toString(int size) {
        if (this.isSparse()) {
            return this.contents.tail.toString();
        }
        int len = size + 3 * (size / 10);
        StringBuilder res = new StringBuilder(len);
        for (int i = 0; i < size; ++i) {
            if (i > 0 && i % 10 == 0) {
                res.append('(');
                res.append(i / 10 % 10);
                res.append(')');
            }
            res.append(this.get(i) ? (char)'1' : '.');
        }
        return res.toString();
    }

    public final String toString() {
        return this.toString(this.isSparse() ? this.length : 32 * this.bSets.length);
    }
}

