/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.utils;

import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.utils.BoolVector;
import fr.inria.tapenade.utils.TapIntList;
import java.io.IOException;

public class BoolMatrix {
    public int nRows;
    public int nCols;
    public BoolVector[] rows;
    private boolean sparse;

    public BoolMatrix(int rowNumber, int colNumber) {
        this.nCols = colNumber;
        this.nRows = rowNumber;
        this.rows = null;
    }

    public BoolMatrix(boolean sparse, int rowNumber, int colNumber) {
        this.sparse = sparse;
        this.nCols = colNumber;
        this.nRows = rowNumber;
        this.rows = null;
    }

    private static void displaySepLine(int[] colMap) throws IOException {
        for (int cc = 1; cc < colMap.length; ++cc) {
            if (cc > 1) {
                TapEnv.print("+");
            }
            int cl = colMap[cc] - colMap[cc - 1];
            cl += 3 * ((cl - 1) / 10);
            while (cl > 0) {
                TapEnv.print("-");
                --cl;
            }
        }
    }

    private static void displayIdentLine(int mapClass, int inClass, int[] colMap) throws IOException {
        for (int cc = 1; cc < colMap.length; ++cc) {
            int ci;
            if (cc > 1) {
                TapEnv.print("|");
            }
            int cl = colMap[cc] - colMap[cc - 1];
            cl += 3 * ((cl - 1) / 10);
            if (cc == mapClass || cc == colMap.length - 1 && cc < mapClass) {
                for (ci = 0; ci < cl; ++ci) {
                    TapEnv.print(ci == inClass ? "i" : " ");
                }
                continue;
            }
            for (ci = 0; ci < cl; ++ci) {
                TapEnv.print(" ");
            }
        }
    }

    private static String implicitIdToString(int boolNumber, int index) {
        int len = boolNumber + 3 * (boolNumber / 10);
        StringBuilder res = new StringBuilder(len);
        for (int i = 0; i < boolNumber; ++i) {
            if (i > 0 && i % 10 == 0) {
                res.append('(');
                res.append(i / 10 % 10);
                res.append(')');
            }
            res.append(i == index ? (char)'i' : ' ');
        }
        return res.toString();
    }

    private static void displayZoneVector(BoolVector row, int[] colMap) throws IOException {
        for (int cc = 1; cc < colMap.length; ++cc) {
            if (cc > 1) {
                TapEnv.print("|");
            }
            int cl = colMap[cc] - colMap[cc - 1];
            for (int ci = 0; ci < cl; ++ci) {
                if (ci > 0 && ci % 10 == 0) {
                    TapEnv.print("(" + ci / 10 % 10 + ')');
                }
                TapEnv.print(row.get(ci + colMap[cc - 1]) ? "X" : ".");
            }
        }
    }

    public final int getNRows() {
        return this.nRows;
    }

    public final int getNCols() {
        return this.nCols;
    }

    public BoolMatrix copy() {
        BoolMatrix result = new BoolMatrix(this.sparse, this.nRows, this.nCols);
        if (this.rows == null) {
            return result;
        }
        result.rows = new BoolVector[this.nRows];
        for (int i = 0; i < this.nRows; ++i) {
            if (this.rows[i] == null) continue;
            result.rows[i] = this.rows[i].copy();
        }
        return result;
    }

    public final void setExplicitZero() {
        if (this.rows == null) {
            this.rows = new BoolVector[this.nRows];
        }
        for (int i = this.nRows - 1; i >= 0; --i) {
            this.rows[i] = new BoolVector(this.sparse, this.nCols);
        }
    }

    public final void setExplicitZeroRow(int i) {
        this.rows[i] = new BoolVector(this.sparse, this.nCols);
    }

    public final void setIdentity() {
        if (this.rows == null) {
            this.rows = new BoolVector[this.nRows];
        }
        for (int i = this.nRows - 1; i >= 0; --i) {
            this.rows[i] = null;
        }
    }

    final void setExplicitIdentity() {
        if (this.rows == null) {
            this.rows = new BoolVector[this.nRows];
        }
        for (int i = this.nRows - 1; i >= 0; --i) {
            this.rows[i] = new BoolVector(this.sparse, this.nCols);
            if (i >= this.nCols) continue;
            this.rows[i].set(i, true);
        }
    }

    public final void setIdentityRow(int i) {
        this.rows[i] = null;
    }

    public final void setExplicitIdentityRow(int i) {
        this.rows[i] = new BoolVector(this.sparse, this.nCols);
        if (i < this.nCols) {
            this.rows[i].set(i, true);
        }
    }

    public final void setRow(int i, BoolVector row) {
        if (this.isImplicitZero()) {
            this.setExplicitZero();
        }
        this.rows[i] = row;
    }

    public final void overwriteDeps(TapIntList rowIndices, BoolVector cumulZ, boolean total) {
        while (rowIndices != null) {
            int index = rowIndices.head;
            if (total) {
                this.setExplicitZeroRow(index);
            } else if (this.isImplicitIdentityRow(index)) {
                this.setExplicitIdentityRow(index);
            }
            if (cumulZ != null) {
                this.getRow(index).cumulOr(cumulZ);
            }
            rowIndices = rowIndices.tail;
        }
    }

    public final void set(int i, int j, boolean val) {
        if (i < this.nRows && this.rows[i] == null) {
            this.rows[i] = new BoolVector(this.sparse, this.nCols);
            if (i < this.nCols) {
                this.rows[i].set(i, true);
            }
        }
        if (i < this.nRows) {
            this.rows[i].set(j, val);
        }
    }

    public final boolean isImplicitZero() {
        return this.rows == null;
    }

    public final boolean isZero(int rowNumber) {
        if (this.rows == null) {
            return true;
        }
        BoolVector row = this.rows[rowNumber];
        return row != null && row.isFalse(this.nCols);
    }

    public final boolean isImplicitIdentityRow(int i) {
        return this.rows != null && this.rows[i] == null;
    }

    public final TapIntList getImplicitIdentityIndices() {
        TapIntList result = null;
        for (int i = this.nRows - 1; i >= 0; --i) {
            if (this.rows[i] != null) continue;
            result = new TapIntList(i, result);
        }
        return result;
    }

    public final BoolVector notImplicitRows() {
        BoolVector result = new BoolVector(this.nRows);
        for (int i = this.nRows - 1; i >= 0; --i) {
            if (this.rows[i] == null) continue;
            result.set(i, true);
        }
        return result;
    }

    public final BoolVector getRow(int i) {
        if (this.rows == null) {
            return new BoolVector(this.sparse, this.nCols);
        }
        return this.rows[i];
    }

    public final BoolVector getExplicitRow(int i) {
        BoolVector row = this.getRow(i);
        if (row == null) {
            row = new BoolVector(this.sparse, this.nCols);
            if (i < this.nCols) {
                row.set(i, true);
            }
        }
        return row;
    }

    public final boolean get(int i, int j) {
        if (this.rows == null) {
            return false;
        }
        if (this.rows[i] == null) {
            return i == j;
        }
        return this.rows[i].get(j);
    }

    public final void cumulRows(TapIntList rowIndices, BoolVector orVector) {
        while (rowIndices != null) {
            int i = rowIndices.head;
            if (this.rows[i] == null) {
                this.rows[i] = new BoolVector(this.sparse, this.nCols);
                if (i < this.nCols) {
                    this.rows[i].set(i, true);
                }
            }
            this.rows[i].cumulOr(orVector);
            rowIndices = rowIndices.tail;
        }
    }

    public final void cumulOr(BoolMatrix orMatrix, boolean explicitIdentities, int len) {
        if (!orMatrix.isImplicitZero()) {
            if (len == -1) {
                len = Math.min(this.nRows, orMatrix.nRows);
            }
            int numj = Math.min(this.nCols, orMatrix.nCols);
            boolean wasImplicitZero = this.isImplicitZero();
            if (wasImplicitZero) {
                this.setExplicitZero();
            }
            for (int i = len - 1; i >= 0; --i) {
                BoolVector thisRow = this.rows[i];
                BoolVector orRow = orMatrix.rows[i];
                if (orRow == null) {
                    if (wasImplicitZero) {
                        this.rows[i] = null;
                        continue;
                    }
                    if (thisRow == null || i >= numj || !explicitIdentities) continue;
                    thisRow.set(i, true);
                    continue;
                }
                if (thisRow == null) {
                    thisRow = this.rows[i] = new BoolVector(this.sparse, this.nCols);
                    if (i < numj && !wasImplicitZero && explicitIdentities) {
                        thisRow.set(i, true);
                    }
                }
                thisRow.cumulOr(orRow, numj);
            }
        }
    }

    protected void cumulOrTimes(BoolMatrix leftMatrix, BoolMatrix rightMatrix) {
        if (leftMatrix.rows != null && rightMatrix.rows != null) {
            boolean wasImplicitZero = this.isImplicitZero();
            int nColsLeft = leftMatrix.nCols;
            if (wasImplicitZero) {
                this.setExplicitZero();
            }
            int mulNRows = Math.min(leftMatrix.nRows, this.nRows);
            for (int i = mulNRows - 1; i >= 0; --i) {
                BoolVector thisRow = this.rows[i];
                BoolVector leftRow = leftMatrix.rows[i];
                if (leftRow == null) {
                    if (i >= rightMatrix.nRows || i >= nColsLeft) continue;
                    BoolVector orRow = rightMatrix.rows[i];
                    if (orRow == null) {
                        if (wasImplicitZero) {
                            this.rows[i] = null;
                            continue;
                        }
                        if (thisRow == null || i >= this.nCols) continue;
                        thisRow.set(i, true);
                        continue;
                    }
                    if (thisRow == null) {
                        thisRow = this.rows[i] = new BoolVector(this.sparse, this.nCols);
                        if (i < this.nCols) {
                            thisRow.set(i, true);
                        }
                    }
                    thisRow.cumulOr(orRow);
                    continue;
                }
                if (thisRow == null) {
                    thisRow = this.rows[i] = new BoolVector(this.sparse, this.nCols);
                    if (i < this.nCols) {
                        thisRow.set(i, true);
                    }
                }
                for (int j = 0; j < nColsLeft; ++j) {
                    if (!leftRow.get(j)) continue;
                    BoolVector rightRow = rightMatrix.rows[j];
                    if (rightRow == null) {
                        if (j >= rightMatrix.nCols) continue;
                        thisRow.set(j, true);
                        continue;
                    }
                    thisRow.cumulOr(rightRow);
                }
            }
        }
    }

    public final BoolMatrix times(BoolMatrix rightMatrix) {
        BoolMatrix product = new BoolMatrix(rightMatrix.sparse, this.nRows, rightMatrix.nCols);
        product.cumulOrTimes(this, rightMatrix);
        return product;
    }

    public final BoolVector times(BoolVector rightVector) {
        BoolVector product = new BoolVector(this.sparse, this.nRows);
        if (this.rows != null) {
            for (int i = 0; i < this.nRows; ++i) {
                BoolVector row = this.rows[i];
                boolean isTrue = row == null ? i < this.nCols && rightVector.get(i) : row.intersects(rightVector, this.nCols);
                if (!isTrue) continue;
                product.set(i, true);
            }
        }
        return product;
    }

    public final BoolVector leftTimes(BoolVector leftVector) {
        BoolVector result = new BoolVector(this.sparse, this.nCols);
        if (this.rows != null) {
            for (int j = 0; j < this.nRows; ++j) {
                if (!leftVector.get(j)) continue;
                BoolVector rightRow = this.rows[j];
                if (rightRow == null) {
                    if (j >= this.nCols) continue;
                    result.set(j, true);
                    continue;
                }
                result.cumulOr(rightRow);
            }
        }
        return result;
    }

    public final BoolMatrix timesTransposed(BoolMatrix rightMatrix) {
        BoolMatrix product = new BoolMatrix(this.sparse, this.nRows, rightMatrix.nRows);
        product.cumulOrTimesTransposed(this, rightMatrix);
        return product;
    }

    private void cumulOrTimesTransposed(BoolMatrix leftMatrix, BoolMatrix rightMatrix) {
        if (leftMatrix.rows != null && rightMatrix.rows != null) {
            if (this.isImplicitZero()) {
                this.setExplicitZero();
            }
            for (int i = leftMatrix.nRows - 1; i >= 0; --i) {
                BoolVector cumulRow = this.rows[i];
                if (cumulRow == null) {
                    cumulRow = this.rows[i] = new BoolVector(this.sparse, this.nCols);
                    if (i < this.nCols) {
                        this.rows[i].set(i, true);
                    }
                }
                for (int j = rightMatrix.nRows - 1; j >= 0; --j) {
                    boolean isTrue = rightMatrix.rows[j] == null ? j < leftMatrix.nCols && leftMatrix.rows[i].get(j) : leftMatrix.rows[i].intersects(rightMatrix.rows[j], leftMatrix.nCols);
                    if (!isTrue) continue;
                    cumulRow.set(j, true);
                }
            }
        }
    }

    public final boolean equalsBoolMatrix(BoolMatrix otherMatrix) {
        if (this.nRows == otherMatrix.nRows && this.nCols == otherMatrix.nCols) {
            return this.equalsBoolMatrix(otherMatrix, this.nRows, this.nCols);
        }
        return false;
    }

    public final boolean equalsBoolMatrix(BoolMatrix otherMatrix, int nrows, int ncols) {
        if (this.rows == null) {
            return otherMatrix.rows == null;
        }
        if (otherMatrix.rows == null) {
            return false;
        }
        boolean equals = true;
        int i = -1;
        while (equals && ++i < nrows) {
            if (this.rows[i] == null) {
                if (otherMatrix.rows[i] == null) continue;
                equals = false;
                continue;
            }
            if (otherMatrix.rows[i] == null) {
                equals = false;
                continue;
            }
            equals = this.rows[i].equals(otherMatrix.rows[i], ncols);
        }
        return equals;
    }

    public final int numberOfOnes() {
        int number = 0;
        if (this.rows != null) {
            for (int i = 0; i < this.nRows; ++i) {
                if (this.rows[i] == null) {
                    ++number;
                    continue;
                }
                number += this.rows[i].numberOfOnes(this.nCols);
            }
        }
        return number;
    }

    public void dump() throws IOException {
        if (this.rows == null) {
            for (int i = 0; i < this.nRows; ++i) {
                TapEnv.println("[" + TapEnv.str3(i) + "]: z");
            }
        } else {
            for (int i = 0; i < this.nRows; ++i) {
                TapEnv.println("[" + TapEnv.str3(i) + "]: " + (this.rows[i] == null ? BoolMatrix.implicitIdToString(this.nCols, i) : this.rows[i].toString(this.nCols)));
            }
        }
    }

    public void dump(int[] rowMap, int[] colMap) throws IOException {
        for (int rc = 1; rc < rowMap.length; ++rc) {
            if (rc > 1) {
                TapEnv.print("       ");
                BoolMatrix.displaySepLine(colMap);
                TapEnv.println();
            }
            for (int ri = rowMap[rc - 1]; ri < rowMap[rc]; ++ri) {
                TapEnv.print("[" + TapEnv.str3(ri - rowMap[rc - 1]) + "]: ");
                BoolVector row = this.getRow(ri);
                if (row == null) {
                    BoolMatrix.displayIdentLine(rc, ri - rowMap[rc - 1], colMap);
                } else {
                    BoolMatrix.displayZoneVector(row, colMap);
                }
                TapEnv.println();
            }
        }
    }
}

