/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.toplevel;

import fr.inria.tapenade.representation.DiffRoot;
import fr.inria.tapenade.representation.PositionAndMessage;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.servletutils.DataRecovery;
import fr.inria.tapenade.toplevel.Tapenade;
import fr.inria.tapenade.utils.Chrono;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class ADServlet
extends HttpServlet {
    private static final long serialVersionUID = 9876299994054L;

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException {
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException {
        long maxSIZE = 1000000L;
        boolean INTFILE = true;
        int INTTEXT = 2;
        int INTINCLUDE = 3;
        int INTREMOVE = 4;
        int INTDIFF = 5;
        HttpSession session = req.getSession(true);
        session.setMaxInactiveInterval(7200);
        LocalDateTime date = LocalDateTime.now();
        session.setAttribute("time", (Object)date.toString());
        System.out.println("");
        Chrono totalTapenadeTimer = new Chrono();
        String remoteHost = req.getRemoteHost();
        InetAddress addr = InetAddress.getByName(remoteHost);
        String hostName = addr.getHostName();
        System.out.println("START " + hostName + " " + session.getId() + " " + date);
        String webappRoot = this.getServletConfig().getServletContext().getRealPath("");
        System.out.println("WEBAPP_ROOT = " + webappRoot);
        System.out.println("JAVA_HOME = " + System.getProperty("java.home"));
        String servletDir = this.getServletDir();
        if (req.getCookies() == null) {
            String url = res.encodeRedirectURL(servletDir + "cookies.jsp");
            res.sendRedirect(url);
        } else {
            Long maxSize = (Long)session.getAttribute("maxsize");
            if (maxSize != null) {
                maxSIZE = maxSize;
            }
            long inputSize = session.getAttribute("size") != null ? (Long)session.getAttribute("size") : 0L;
            session.setAttribute("ServletDir", (Object)servletDir);
            String uploadedDirName = "UploadedFiles";
            String aliParser = webappRoot + File.separator + "WEB-INF" + File.separator + "lib" + File.separator;
            String clientDirName = "client" + session.getId();
            String clientDirPath = webappRoot + File.separator + uploadedDirName + File.separator + clientDirName + File.separator;
            String tapenadeLogFile = webappRoot + File.separator + uploadedDirName + File.separator + "tapenade_log_" + clientDirName;
            session.setAttribute("clientDirPath", (Object)clientDirPath);
            session.setAttribute("UploadedDirName", (Object)uploadedDirName);
            session.setAttribute("clientDirName", (Object)clientDirName);
            File clientDir = new File(clientDirPath);
            if (!clientDir.mkdir()) {
                System.out.println("DoPost: mkdir " + clientDirPath);
            }
            session.setAttribute("clientDir", (Object)clientDir);
            session.setAttribute("tmpDirToClean", (Object)clientDirPath);
            DataRecovery dataRecovery = new DataRecovery(req.getContentType(), req.getInputStream(), res.getWriter());
            String filename = "";
            String url = res.encodeRedirectURL(servletDir + "form.jsp");
            Tapenade aliServlet = null;
            try {
                dataRecovery.getData();
                int inputLanguage = dataRecovery.getFileType();
                System.out.println("inputLanguage " + inputLanguage);
                session.setAttribute("inputLanguage", (Object)inputLanguage);
                int buttonType = dataRecovery.getButtonType();
                dataRecovery.appendStringTapenadeLog(tapenadeLogFile, System.lineSeparator() + "---- Session: " + session.getId() + ", time: " + date + System.lineSeparator());
                dataRecovery.appendStringTapenadeLog(tapenadeLogFile, "Remote Host : " + req.getRemoteHost() + " : " + hostName + System.lineSeparator());
                dataRecovery.appendTapenadeLog(tapenadeLogFile);
                dataRecovery.appendStringTapenadeLog(tapenadeLogFile, System.lineSeparator());
                switch (buttonType) {
                    case 1: {
                        int fileSize = dataRecovery.saveFile(clientDirPath);
                        filename = dataRecovery.getFileName();
                        File file = new File(clientDirPath + filename);
                        if (filename == null || filename.isEmpty() || file.length() == 0L) break;
                        String extension = TapEnv.getExtension(filename);
                        Vector<String> names = (Vector<String>)session.getAttribute("inputFileNames");
                        if (names == null) {
                            names = new Vector<String>();
                        }
                        if ("jar".equals(extension) || "zip".equals(extension)) {
                            String[] jarNames;
                            for (String jarName : jarNames = Tapenade.extractFiles(clientDirPath, clientDirPath + filename)) {
                                if (names.contains(jarName)) continue;
                                names.add(jarName);
                            }
                            this.addSize(session, inputSize, fileSize);
                        } else if (!names.contains(filename)) {
                            names.add(filename);
                            this.addSize(session, inputSize, fileSize);
                        }
                        session.setAttribute("inputFileNames", names);
                        break;
                    }
                    case 3: {
                        int fileSize = dataRecovery.saveFile(clientDirPath);
                        filename = dataRecovery.getFileName();
                        File file = new File(clientDirPath + filename);
                        if (filename == null || filename.isEmpty() || file.length() == 0L) break;
                        String extension = TapEnv.getExtension(filename);
                        Vector<String> names = (Vector<String>)session.getAttribute("includeFileNames");
                        if (names == null) {
                            names = new Vector<String>();
                        }
                        if ("jar".equals(extension) || "zip".equals(extension)) {
                            String[] jarNames;
                            for (String jarName : jarNames = Tapenade.extractFiles(clientDirPath, clientDirPath + filename)) {
                                if (names.contains(jarName)) continue;
                                names.add(jarName);
                            }
                            this.addSize(session, inputSize, fileSize);
                        } else if (!names.contains(filename)) {
                            names.add(filename);
                            this.addSize(session, inputSize, fileSize);
                        }
                        session.setAttribute("includeFileNames", names);
                        break;
                    }
                    case 4: {
                        File file;
                        Vector files = dataRecovery.getFileToRemove();
                        Vector names = (Vector)session.getAttribute("inputFileNames");
                        while (files != null && !files.isEmpty()) {
                            file = new File(clientDirPath + (String)files.firstElement());
                            inputSize = this.subSize(session, inputSize, file.length());
                            if (!file.delete()) {
                                System.out.println("DoPost: delete file " + clientDirPath);
                            }
                            if (names != null) {
                                names.remove(files.firstElement());
                            }
                            files.remove(files.firstElement());
                        }
                        session.setAttribute("inputFileNames", (Object)names);
                        Vector includes = dataRecovery.getIncludeToRemove();
                        names = (Vector)session.getAttribute("includeFileNames");
                        while (includes != null && !includes.isEmpty()) {
                            file = new File(clientDirPath + (String)includes.firstElement());
                            inputSize = this.subSize(session, inputSize, file.length());
                            if (!file.delete()) {
                                System.out.println("DoPost: delete include file " + clientDirPath);
                            }
                            if (names != null) {
                                names.remove(includes.firstElement());
                            }
                            includes.remove(includes.firstElement());
                        }
                        session.setAttribute("includeFileNames", (Object)names);
                        break;
                    }
                    case 5: {
                        String[] ifiles;
                        int nbFiles;
                        session.setAttribute("diffMode", (Object)Integer.toString(dataRecovery.getDiffMode()));
                        Vector names = (Vector)session.getAttribute("inputFileNames");
                        int choice = dataRecovery.getChoice();
                        session.setAttribute("choice", (Object)choice);
                        boolean multiDirMode = dataRecovery.getMultiDirMode();
                        session.setAttribute("multiDirMode", (Object)Boolean.toString(multiDirMode));
                        if (names != null && (nbFiles = names.size()) > 0) {
                            Object[] ifilesobj = names.toArray();
                            ifiles = new String[nbFiles];
                            for (int k = 0; k < nbFiles; ++k) {
                                ifiles[k] = (String)ifilesobj[k];
                            }
                            filename = ifiles[0];
                        } else {
                            if (choice == 2) {
                                filename = "default.f90";
                                inputSize = this.addSize(session, inputSize, dataRecovery.saveFile(clientDirPath));
                            } else {
                                int fileSize = dataRecovery.saveFile(clientDirPath);
                                filename = dataRecovery.getFileName();
                                File file = new File(clientDirPath + filename);
                                if (filename != null && !filename.isEmpty() && file.length() != 0L) {
                                    inputSize = this.addSize(session, inputSize, fileSize);
                                    Vector<String> vfilename = new Vector<String>();
                                    vfilename.add(filename);
                                    session.setAttribute("inputFileNames", vfilename);
                                }
                            }
                            ifiles = new String[]{filename};
                        }
                        session.setAttribute("filename", (Object)filename);
                        System.out.println("inputSize " + inputSize);
                        if (inputSize > maxSIZE) {
                            System.out.println("Errorsize: inputSize " + inputSize);
                            dataRecovery.appendStringTapenadeLog(tapenadeLogFile, "Errorsize: inputSize " + inputSize + System.lineSeparator());
                            url = res.encodeRedirectURL(servletDir + "errorsize.jsp");
                            break;
                        }
                        aliServlet = new Tapenade(inputLanguage, aliParser, dataRecovery.getDiffMode(), webappRoot, clientDirPath, uploadedDirName + File.separator + clientDirName + File.separator, ifiles, webappRoot + File.separator + "WEB-INF" + File.separator + "lib" + File.separator, dataRecovery.getHeadFunction(), dataRecovery.getIndependentInputVariables(), dataRecovery.getDependentOutputVariables(), multiDirMode);
                        aliServlet.htmlMessageFileName = filename + "msg.html";
                        File genDir = new File(clientDirPath + "tapenadehtml");
                        if (!genDir.mkdir()) {
                            System.out.println("DoPost: mkdir " + clientDirPath + "tapenadehtml");
                        }
                        this.emptyDir(genDir);
                        session.setAttribute("tapenadeGenDir", (Object)"tapenadehtml");
                        File outputDir = new File(clientDirPath + "tapenadeoutput");
                        if (!outputDir.mkdir()) {
                            System.out.println("DoPost: mkdir " + clientDirPath + "tapenadeoutput");
                        }
                        this.emptyDir(outputDir);
                        session.setAttribute("tapenadeOutputDir", (Object)"tapenadeoutput");
                        boolean hasGlobalDecls = aliServlet.analyzeFile();
                        int lang = aliServlet.diffRoots != null ? ((DiffRoot)aliServlet.diffRoots.head).unit().language() : TapEnv.outputLanguage();
                        session.setAttribute("topLanguage", (Object)lang);
                        System.out.println("Saving error messages in " + clientDirPath + "tapenadehtml" + File.separator + "msg.html");
                        TapList<PositionAndMessage> msgs = TapEnv.getAllMessages(aliServlet.origCallGraph(), aliServlet.diffCallGraph(), aliServlet.getTransformedSourceUnits(aliServlet.diffCallGraph() == null ? null : aliServlet.diffCallGraph().backAssociations), true);
                        TapEnv.saveAllMessagesAsHTML(msgs, clientDirPath + "tapenadehtml" + File.separator + aliServlet.htmlMessageFileName, aliServlet.cssDir(), "", null, hasGlobalDecls, TapEnv.get().preprocessFileSuffix);
                        TapEnv.saveAllMessagesAsHTML(msgs, clientDirPath + "tapenadehtml" + File.separator + "msg.html", aliServlet.cssDir(), uploadedDirName + File.separator + clientDirName + File.separator + "tapenadehtml" + File.separator, null, hasGlobalDecls, TapEnv.get().preprocessFileSuffix);
                        TapEnv.saveAllMessagesAsText(msgs, clientDirPath + "tapenadeoutput" + File.separator + aliServlet.textMessageFileName);
                        if (!TapEnv.modeIsNoDiff() && aliServlet.diffCallGraph() != null) {
                            String outputDirectory = clientDirPath + "tapenadeoutput" + File.separator;
                            File directory = new File(outputDirectory);
                            String[] genFiles = directory.list();
                            String zipFileName = outputDirectory + "TapenadeResults.zip";
                            if (genFiles != null) {
                                this.createZipFile(aliServlet.getOutputDirectory(), zipFileName, genFiles);
                            }
                        }
                        url = res.encodeRedirectURL(servletDir + "result.html");
                        dataRecovery.appendStringTapenadeLog(tapenadeLogFile, "------------ Differentiation done " + LocalDateTime.now() + System.lineSeparator());
                        break;
                    }
                }
                res.sendRedirect(url);
                System.out.println("");
                System.out.println("STOP  " + hostName + " " + session.getId() + " " + date + " total time " + totalTapenadeTimer.elapsed() + " s");
                System.out.println("");
            }
            catch (Exception e) {
                Throwable throwable;
                if (aliServlet != null) {
                    TapList<PositionAndMessage> msgs = TapEnv.getAllMessages(aliServlet.origCallGraph(), aliServlet.diffCallGraph(), aliServlet.getTransformedSourceUnits(aliServlet.diffCallGraph() == null ? null : aliServlet.diffCallGraph().backAssociations), true);
                    TapEnv.saveAllMessagesAsText(msgs, clientDirPath + "tapenadehtml" + File.separator + aliServlet.textMessageFileName);
                }
                System.out.println("");
                System.out.println("---> Session num " + session.getId() + ", heure: " + date);
                System.out.println("");
                System.out.println("ERREUR : " + e.getMessage());
                dataRecovery.appendStringTapenadeLog(tapenadeLogFile, "ERROR " + e.getMessage() + System.lineSeparator());
                System.out.println(" Les valeurs utilisateurs sont :");
                System.out.println(" - Nom fichier : " + filename);
                System.out.println(" - Head : " + dataRecovery.getHeadFunction());
                String variables = dataRecovery.getIndependentInputVariables();
                System.out.println(" - Nom des independent input variables: " + variables);
                System.out.println("");
                variables = dataRecovery.getDependentOutputVariables();
                System.out.println(" - Nom des dependent output variables: " + variables);
                System.out.println("");
                System.out.println(" - Mode de differentiation : " + dataRecovery.getDiffMode());
                System.out.println("End   session " + session.getId() + " " + date + " total time: " + totalTapenadeTimer.elapsed() + " s");
                System.out.println("");
                try {
                    throwable = null;
                    try (PrintWriter errorPW = new PrintWriter(Files.newOutputStream(Paths.get(clientDirPath + "error.html", new String[0]), new OpenOption[0]));){
                        errorPW.println(e);
                        errorPW.flush();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                catch (IOException errorPW) {
                    // empty catch block
                }
                try {
                    throwable = null;
                    try (PrintWriter stackPW = new PrintWriter(Files.newOutputStream(Paths.get(clientDirPath + "stack.html", new String[0]), new OpenOption[0]));){
                        stackPW.println("<pre>");
                        e.printStackTrace(stackPW);
                        stackPW.println("</pre>");
                        stackPW.flush();
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (aliServlet != null) {
                    TapEnv.closeOutputStream();
                }
                url = res.encodeRedirectURL(servletDir + "error.jsp");
                res.sendRedirect(url);
            }
        }
    }

    protected final String getServletDir() {
        File webDir = new File(this.getServletConfig().getServletContext().getRealPath(""));
        return File.separator + webDir.getName() + File.separator;
    }

    private long addSize(HttpSession session, long inputSize, long size) {
        long result = inputSize + size;
        session.setAttribute("size", (Object)result);
        return result;
    }

    private long subSize(HttpSession session, long inputSize, long size) {
        long result = inputSize - size;
        session.setAttribute("size", (Object)result);
        return result;
    }

    private void emptyDir(File genDir) {
        File[] files = genDir.listFiles();
        for (File file : Objects.requireNonNull(files)) {
            if (file.delete()) continue;
            System.out.println("EmptyDir: delete " + file);
        }
    }

    private void createZipFile(String outputDirectory, String zipFileName, String[] files) {
        byte[] buf = new byte[1024];
        if (files.length > 0) {
            try (ZipOutputStream out = new ZipOutputStream(Files.newOutputStream(Paths.get(zipFileName, new String[0]), new OpenOption[0]));){
                for (String file : files) {
                    try (InputStream in = Files.newInputStream(Paths.get(outputDirectory + file, new String[0]), new OpenOption[0]);){
                        int len;
                        out.putNextEntry(new ZipEntry(file));
                        while ((len = in.read(buf)) > 0) {
                            out.write(buf, 0, len);
                        }
                        out.closeEntry();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            System.out.println("Creating " + zipFileName);
        }
    }

    protected void cleanSubDirectory(String subDirectory, HttpSession session, String tmpDirToClean) {
        String diffgenpath = tmpDirToClean + File.separator + session.getAttribute(subDirectory);
        File dir = new File(diffgenpath);
        if (dir.exists()) {
            String[] files = dir.list();
            for (int i = 0; i < Objects.requireNonNull(files).length; ++i) {
                File f = new File(diffgenpath + File.separator + files[i]);
                if (f.delete()) continue;
                System.out.println("Clean directory, delete: " + files[i]);
            }
        }
    }
}

