/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.representation;

import fr.inria.tapenade.representation.ArrayDim;
import fr.inria.tapenade.representation.ArrayTypeSpec;
import fr.inria.tapenade.representation.FieldDecl;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.PointerTypeSpec;
import fr.inria.tapenade.representation.SymbolDecl;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.utils.TapPair;
import fr.inria.tapenade.utils.Tree;

public final class ZoneInfoAccessElements {
    public SymbolDecl symbolDecl;
    public Tree accessTree;
    public SymbolTable symbolTable;
    public TapList<TapPair<Tree, Tree>> accessIndexes = null;
    public int startOffsetInArray = -1;
    public int baseSize = -1;

    public ZoneInfoAccessElements(SymbolDecl symbolDecl, Tree accessTree, SymbolTable symbolTable) {
        this.symbolDecl = symbolDecl;
        this.accessTree = accessTree;
        this.symbolTable = symbolTable;
    }

    public ZoneInfoAccessElements buildIndex(ArrayTypeSpec arrayType) {
        Tree indexedAccessTree;
        TapList<TapPair<Tree, Object>> indexedAccessIndexes = null;
        ArrayDim[] typeDimensions = arrayType.dimensions();
        if (this.accessTree != null && this.accessTree.opCode() == 9) {
            if (this.accessTree.down(2).children().length >= typeDimensions.length) {
                Tree[] indexTrees = this.accessTree.down(2).children();
                for (int i = indexTrees.length - 1; i >= 0; --i) {
                    TapList<Tree> arrayTriplets = ILUtils.arrayTripletsInside(indexTrees[i]);
                    if (arrayTriplets == null) continue;
                    indexedAccessIndexes = new TapList<TapPair<Tree, Object>>(new TapPair(arrayTriplets.head, null), indexedAccessIndexes);
                }
            }
            indexedAccessTree = this.accessTree;
        } else {
            TapList<Tree> arrayIndexes = null;
            for (int i = typeDimensions.length - 1; i >= 0; --i) {
                Tree indexTree = typeDimensions[i].tree();
                indexTree = ILUtils.build(12, ILUtils.copy(indexTree.down(1)), ILUtils.copy(indexTree.down(2)), ILUtils.build(138));
                arrayIndexes = new TapList<Tree>(indexTree, arrayIndexes);
                indexedAccessIndexes = new TapList<TapPair<Tree, Object>>(new TapPair<Tree, Object>(indexTree, null), indexedAccessIndexes);
            }
            boolean inAllocate = this.accessTree != null && this.accessTree.opCode() == 5;
            indexedAccessTree = inAllocate ? ILUtils.copy(this.accessTree) : ILUtils.build(9, ILUtils.copy(this.accessTree), ILUtils.build(71, arrayIndexes));
        }
        ZoneInfoAccessElements result = new ZoneInfoAccessElements(this.symbolDecl, indexedAccessTree, this.symbolTable);
        result.accessIndexes = indexedAccessIndexes;
        return result;
    }

    public ZoneInfoAccessElements buildField(FieldDecl field, int i) {
        Tree fieldAccessTree = null;
        TapList fieldAccessIndexes = this.accessIndexes;
        if (this.accessTree != null) {
            TapPair<Tree, TapList<TapPair<Tree, Tree>>> copyTreeIndexes = ILUtils.copyWatchingSubtrees(this.accessTree, fieldAccessIndexes);
            fieldAccessTree = (Tree)copyTreeIndexes.first;
            fieldAccessIndexes = (TapList)copyTreeIndexes.second;
        }
        fieldAccessTree = ILUtils.build(75, fieldAccessTree, ILUtils.build(96, field.symbol));
        ILUtils.setFieldRank(fieldAccessTree.down(2), i);
        ZoneInfoAccessElements result = new ZoneInfoAccessElements(this.symbolDecl, fieldAccessTree, this.symbolTable);
        result.accessIndexes = fieldAccessIndexes;
        return result;
    }

    public ZoneInfoAccessElements buildDeref(PointerTypeSpec pointerType) {
        Tree derefAccessTree = ILUtils.build(151, ILUtils.copy(this.accessTree), pointerType.offsetLength == null ? ILUtils.build(138) : ILUtils.copy(pointerType.offsetLength.tree()));
        TapList<TapPair<Tree, Tree>> derefAccessIndexes = this.accessIndexes;
        if (pointerType.offsetLength != null) {
            derefAccessIndexes = TapList.append(derefAccessIndexes, new TapList<TapPair<Tree, Object>>(new TapPair<Tree, Object>(pointerType.offsetLength.tree(), null), null));
        }
        ZoneInfoAccessElements result = new ZoneInfoAccessElements(this.symbolDecl, derefAccessTree, this.symbolTable);
        result.accessIndexes = derefAccessIndexes;
        return result;
    }

    public String toString() {
        return this.symbolDecl + " :: " + ILUtils.toString(this.accessTree) + " (" + this.startOffsetInArray + " " + this.baseSize + ") FOR ST:" + this.symbolTable;
    }
}

