/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.representation;

import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.PointerTypeSpec;
import fr.inria.tapenade.representation.SymbolDecl;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.representation.VariableDecl;
import fr.inria.tapenade.representation.WrapperTypeSpec;
import fr.inria.tapenade.utils.TapIntList;
import fr.inria.tapenade.utils.TapPair;
import fr.inria.tapenade.utils.ToBool;
import fr.inria.tapenade.utils.Tree;
import java.io.IOException;

public final class ZoneInfo {
    private int kind = 12;
    public int index;
    public int zoneNb = -1;
    public int realZoneNb = -1;
    public int intZoneNb = -1;
    public int ptrZoneNb = -1;
    public TapList targetZonesTree;
    public ZoneInfo targetZoneOf;
    public ZoneInfo from;
    public WrapperTypeSpec type;
    public int typeSizeModifier = -1;
    public boolean isAllocatable;
    public Tree accessTree = null;
    public String description = null;
    public boolean isHidden = false;
    public boolean isChannelOrIO = false;
    public WrapperTypeSpec rootAccessType;
    public TapList<TapPair<Tree, Tree>> accessIndexes;
    public int startOffset;
    public int endOffset;
    public boolean infiniteEndOffset;
    public String commonName;
    public boolean multiple;
    public boolean ambiguousWithoutIndices = false;
    public SymbolDecl ownerSymbolDecl;
    public Unit declarationUnit;
    public boolean relocated;
    public boolean relocatedDiff;
    public boolean rebased;
    public boolean rebasedDiff;
    private TapList<String> variableNames;
    private ToBool toOnceActive = new ToBool(false);

    public ZoneInfo(int startOffset, int endOffset, boolean infiniteEndOffset) {
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.infiniteEndOffset = infiniteEndOffset;
    }

    public static boolean eqOrCopyOfEq(ZoneInfo z1, ZoneInfo z2) {
        if (z1 == null || z2 == null) {
            return false;
        }
        if (z1.from != null) {
            z1 = z1.from;
        }
        if (z2.from != null) {
            z2 = z2.from;
        }
        return z1 == z2;
    }

    public static TapIntList listAllZones(TapList<?> zonesTree, boolean throughPointers) {
        TapIntList toCollector = new TapIntList(-1, null);
        ZoneInfo.listAllZonesRec(zonesTree, throughPointers, toCollector, new TapList<Object>(null, null));
        return toCollector.tail;
    }

    private static void listAllZonesRec(TapList<?> zonesTree, boolean throughPointers, TapIntList toCollector, TapList<TapList> dejaVu) {
        while (zonesTree != null && !TapList.contains(dejaVu.tail, zonesTree)) {
            dejaVu.placdl(zonesTree);
            if (zonesTree.head instanceof TapList) {
                ZoneInfo.listAllZonesRec((TapList)zonesTree.head, throughPointers, toCollector, dejaVu);
            } else {
                TapIntList newZones = (TapIntList)zonesTree.head;
                while (newZones != null) {
                    toCollector.appendIfAbsent(newZones.head);
                    newZones = newZones.tail;
                }
                if (!throughPointers) {
                    zonesTree = null;
                }
            }
            if (zonesTree == null) continue;
            zonesTree = zonesTree.tail;
        }
    }

    public ZoneInfo copy() {
        ZoneInfo copyZI = new ZoneInfo(this.startOffset, this.endOffset, this.infiniteEndOffset);
        copyZI.kind = this.kind;
        copyZI.index = this.index;
        copyZI.zoneNb = this.zoneNb;
        copyZI.realZoneNb = this.realZoneNb;
        copyZI.intZoneNb = this.intZoneNb;
        copyZI.ptrZoneNb = this.ptrZoneNb;
        copyZI.targetZonesTree = this.targetZonesTree;
        copyZI.from = this.from != null ? this.from : this;
        copyZI.type = this.type;
        copyZI.typeSizeModifier = this.typeSizeModifier;
        copyZI.accessTree = this.accessTree;
        copyZI.description = this.description;
        copyZI.isAllocatable = this.isAllocatable;
        copyZI.isChannelOrIO = this.isChannelOrIO;
        copyZI.isHidden = this.isHidden;
        copyZI.ambiguousWithoutIndices = this.ambiguousWithoutIndices;
        copyZI.multiple = this.multiple;
        copyZI.rootAccessType = this.rootAccessType;
        copyZI.accessIndexes = this.accessIndexes;
        copyZI.commonName = this.commonName;
        copyZI.variableNames = this.variableNames;
        copyZI.ownerSymbolDecl = this.ownerSymbolDecl;
        copyZI.declarationUnit = this.declarationUnit;
        return copyZI;
    }

    public boolean isCommon() {
        return this.kind == 13 && this.commonName != null;
    }

    public boolean isParameter() {
        return this.kind == 7;
    }

    public boolean isResult() {
        return this.kind == 10;
    }

    public boolean isGlobal() {
        return this.kind == 13;
    }

    public boolean isControl() {
        return this.kind == 11;
    }

    public boolean isRemanentLocal() {
        return this.commonName != null && this.commonName.startsWith("/Fortran_Save_");
    }

    public static boolean same(ZoneInfo zi1, ZoneInfo zi2) {
        return zi1.kind == zi2.kind && (zi1.accessTree == null ? zi2.accessTree == null : zi1.accessTree.equals(zi2.accessTree)) && (zi1.description == null ? zi2.description == null : zi1.description.equals(zi2.description)) && (zi1.commonName == null ? zi2.commonName == null : zi1.commonName.equals(zi2.commonName)) && zi1.startOffset == zi2.startOffset;
    }

    public int kind() {
        return this.kind;
    }

    public void setKind(int kind) {
        this.kind = kind;
    }

    public int kindZoneNb(int whichKind) {
        switch (whichKind) {
            case 1: {
                return this.realZoneNb;
            }
            case 2: {
                return this.intZoneNb;
            }
            case 3: {
                return this.ptrZoneNb;
            }
        }
        return this.zoneNb;
    }

    public void setOnceActive() {
        this.toOnceActive.set(true);
        if (this.targetZoneOf != null) {
            this.targetZoneOf.toOnceActive.set(true);
        }
    }

    public void shareActivity(ZoneInfo model) {
        this.toOnceActive = model.toOnceActive;
    }

    public boolean isOnceActive() {
        return this.toOnceActive.get();
    }

    public boolean isConstant() {
        return this.ownerSymbolDecl != null && this.ownerSymbolDecl.isCconst();
    }

    protected void addVariableName(String varName) {
        if (!TapList.containsEquals(this.variableNames, varName)) {
            this.variableNames = new TapList<String>(varName, this.variableNames);
        }
    }

    protected void setVariableNames(TapList<String> varNames) {
        this.variableNames = varNames;
    }

    public TapList<String> variableNames() {
        return this.variableNames;
    }

    public String bestVarName() {
        return this.accessTree == null ? null : ILUtils.baseName(this.accessTree);
    }

    public String publicName() {
        String accessTreeString = null;
        if (!(ILUtils.isNullOrNone(this.accessTree) || this.accessTree.opCode() == 9 && ILUtils.isNullOrNone(this.accessTree.down(1)) && (ILUtils.isNullOrNone(this.accessTree.down(2)) || this.allTreesNull(this.accessTree.down(2).children())))) {
            accessTreeString = ILUtils.toString(this.accessTree);
        }
        switch (this.kind) {
            case 7: {
                return "Arg" + this.index + (accessTreeString != null ? ":" + accessTreeString : "");
            }
            case 10: {
                return "Result" + (accessTreeString != null ? ":" + accessTreeString : "");
            }
            case 13: {
                return accessTreeString != null ? accessTreeString : this.description;
            }
        }
        return "??";
    }

    public boolean containsOffset(int testedOffset) {
        return this.startOffset <= testedOffset && (this.infiniteEndOffset || testedOffset < this.endOffset);
    }

    private boolean allTreesNull(Tree[] trees) {
        boolean result = true;
        for (int i = trees.length - 1; result && i >= 0; --i) {
            Tree tree = trees[i];
            result = ILUtils.isNullOrNone(tree) || tree.opCode() == 59 && ILUtils.isNullOrNone(tree.down(1)) && ILUtils.isNullOrNone(tree.down(2)) || tree.opCode() == 12 && ILUtils.isNullOrNone(tree.down(1)) && ILUtils.isNullOrNone(tree.down(2)) && ILUtils.isNullOrNone(tree.down(3));
        }
        return result;
    }

    public String accessTreePrint(int language) {
        return ILUtils.toString(this.accessTree, language, this.ambiguousWithoutIndices);
    }

    public void setMultiple() {
        this.multiple = true;
    }

    public void setAmbiguousWithoutIndices() {
        this.ambiguousWithoutIndices = true;
    }

    public boolean comesFromAllocate() {
        return this.accessTree != null && this.comesFromAllocateRec(this.accessTree);
    }

    private boolean comesFromAllocateRec(Tree inAccessTree) {
        switch (inAccessTree.opCode()) {
            case 5: {
                return true;
            }
            case 9: 
            case 75: 
            case 151: {
                return this.comesFromAllocateRec(inAccessTree.down(1));
            }
        }
        return false;
    }

    public WrapperTypeSpec pointerDestType() {
        if (this.ptrZoneNb == -1) {
            return null;
        }
        return ((PointerTypeSpec)this.type.wrappedType).destinationType;
    }

    public boolean passesByValue(Unit inUnit, int callerLanguage) {
        boolean result = false;
        if (this.isParameter() && (this.accessTree == null || !ILUtils.isAccessedThroughPointer(this.accessTree))) {
            int language = inUnit.language();
            switch (language) {
                case 1: 
                case 2: 
                case 3: {
                    result = this.ownerSymbolDecl instanceof VariableDecl && this.ownerSymbolDecl.hasModifier("value");
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    result = TapEnv.isC(callerLanguage) && (this.ownerSymbolDecl == null || this.ownerSymbolDecl instanceof VariableDecl && !this.ownerSymbolDecl.isReference());
                    break;
                }
                default: {
                    TapEnv.printlnOnTrace("(passesByValue) unknown language " + language);
                }
            }
        }
        return result;
    }

    public int knownSize(SymbolTable symbolTable) {
        int size = this.type == null ? -1 : this.type.size();
        Tree accTree = this.accessTree;
        block6: while (size > 0 && accTree != null) {
            switch (accTree.opCode()) {
                case 9: {
                    Tree[] dims = accTree.down(2).children();
                    for (int i = dims.length - 1; size > 0 && i >= 0; --i) {
                        int dimSize = this.knownSize(dims[i], symbolTable);
                        size = dimSize <= 0 ? -1 : size * dimSize;
                    }
                    accTree = accTree.down(1);
                    continue block6;
                }
                case 151: {
                    if (!ILUtils.isNullOrNone(accTree.down(2))) {
                        int dimSize = this.knownSize(accTree.down(2), symbolTable);
                        size = dimSize <= 0 ? -1 : size * dimSize;
                    }
                    accTree = accTree.down(1);
                    continue block6;
                }
                case 75: {
                    accTree = accTree.down(1);
                    continue block6;
                }
                case 96: {
                    accTree = null;
                    continue block6;
                }
            }
            accTree = null;
            size = -1;
        }
        return size;
    }

    private int knownSize(Tree arrayIndex, SymbolTable symbolTable) {
        if (arrayIndex.opCode() == 12) {
            Integer computed;
            int firstIndex = 1;
            if (!ILUtils.isNullOrNone(arrayIndex.down(1)) && (computed = symbolTable.computeIntConstant(arrayIndex.down(1))) != null) {
                firstIndex = computed;
            }
            int lastIndex = -1;
            if (!ILUtils.isNullOrNone(arrayIndex.down(2)) && (computed = symbolTable.computeIntConstant(arrayIndex.down(2))) != null) {
                lastIndex = computed;
            }
            int stride = 1;
            if (!ILUtils.isNullOrNone(arrayIndex.down(3)) && (computed = symbolTable.computeIntConstant(arrayIndex.down(3))) != null) {
                stride = computed;
            }
            if (stride == 1 && firstIndex != -1 && lastIndex != -1) {
                return lastIndex - firstIndex + 1;
            }
            return -1;
        }
        return 1;
    }

    public void dump() throws IOException {
        TapEnv.print(this.toString());
    }

    public String toString() {
        String kindStr;
        switch (this.kind) {
            case 7: {
                kindStr = "parameter #" + this.index + " ";
                break;
            }
            case 12: {
                kindStr = "local var ";
                break;
            }
            case 10: {
                kindStr = "function result ";
                break;
            }
            case 13: {
                kindStr = "global ";
                if (this.commonName == null) break;
                kindStr = kindStr + "(from common " + this.commonName + " [" + this.startOffset + "," + this.endOffset + "[)  ";
                break;
            }
            case 11: {
                kindStr = "local control ";
                break;
            }
            default: {
                kindStr = "unknown kind ";
            }
        }
        boolean passedByValue = false;
        if (this.isParameter() && this.declarationUnit != null && (this.accessTree == null || !ILUtils.isAccessedThroughPointer(this.accessTree))) {
            passedByValue = this.passesByValue(this.declarationUnit, this.declarationUnit.language());
        }
        return (this.isHidden ? "[HIDDEN] " : "") + (this.accessTree != null ? ILUtils.toString(this.accessTree) + " " : "") + (this.description != null ? "\"" + this.description + "\" " : "") + (this.isOnceActive() ? " @z:" : " z:") + this.zoneNb + (this.kindZoneNb(2) == -1 ? "" : "/i" + this.kindZoneNb(2)) + (this.kindZoneNb(3) == -1 ? "" : "/p" + this.kindZoneNb(3)) + (this.kindZoneNb(1) == -1 ? "" : "/r" + this.kindZoneNb(1)) + (this.targetZoneOf == null ? "" : " " + this.targetZoneOf.zoneNb + "-i>") + (this.targetZonesTree == null ? "" : " -i>" + this.targetZonesTree) + " " + kindStr + (this.variableNames == null ? "()" : this.variableNames.toString()) + ": " + (this.multiple ? "multi-" : "") + (this.type == null ? "null_type" : this.type) + (passedByValue ? ", passed by value" : "");
    }
}

