/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.representation;

import fr.inria.tapenade.representation.ArrayTypeSpec;
import fr.inria.tapenade.representation.CompositeTypeSpec;
import fr.inria.tapenade.representation.FieldDecl;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.ModifiedTypeSpec;
import fr.inria.tapenade.representation.PointerTypeSpec;
import fr.inria.tapenade.representation.PrimitiveTypeSpec;
import fr.inria.tapenade.representation.SubVariableDecl;
import fr.inria.tapenade.representation.SymbolDecl;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.TypeSpec;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.representation.VariableDecl;
import fr.inria.tapenade.representation.WrapperTypeSpec;
import fr.inria.tapenade.representation.ZoneInfo;
import fr.inria.tapenade.representation.ZoneInfoAccessElements;
import fr.inria.tapenade.utils.TapIntList;
import fr.inria.tapenade.utils.TapPair;
import fr.inria.tapenade.utils.Tree;

final class ZoneAllocator {
    public int nextZone;
    public TapList<ZoneInfo> zoneInfos;
    public int nextIntZone;
    public TapList<ZoneInfo> intZoneInfos;
    public int nextRealZone;
    public TapList<ZoneInfo> realZoneInfos;
    public int nextPtrZone;
    public TapList<ZoneInfo> ptrZoneInfos;
    public String commonName;
    public int startOffset;
    public int endOffset;
    public boolean infiniteEndOffset;
    private boolean possiblyMultiple = false;
    private boolean needsAccessTree = false;
    private boolean allocateZonesForPointed = false;
    public SymbolTable targetSymbolTable;
    public boolean ambiguousWithoutIndices = false;

    public ZoneAllocator(SymbolTable targetSymbolTable) {
        this.targetSymbolTable = targetSymbolTable;
        if (targetSymbolTable != null) {
            this.nextZone = targetSymbolTable.freeDeclaredZone(0);
            this.nextIntZone = targetSymbolTable.freeDeclaredZone(2);
            this.nextRealZone = targetSymbolTable.freeDeclaredZone(1);
            this.nextPtrZone = targetSymbolTable.freeDeclaredZone(3);
        } else {
            this.nextZone = 0;
            this.nextIntZone = 0;
            this.nextRealZone = 0;
            this.nextPtrZone = 0;
        }
        this.zoneInfos = null;
        this.intZoneInfos = null;
        this.realZoneInfos = null;
        this.ptrZoneInfos = null;
    }

    public void setZoneNumber4(int[] zoneNumber4) {
        this.nextZone = zoneNumber4[0];
        this.nextIntZone = zoneNumber4[1];
        this.nextRealZone = zoneNumber4[2];
        this.nextPtrZone = zoneNumber4[3];
    }

    public void setCommonName(String commonName) {
        this.commonName = commonName;
    }

    public void setOffsets(int startOffset, int endOffset, boolean infiniteEndOffset) {
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.infiniteEndOffset = infiniteEndOffset;
    }

    public void setPossiblyMultiple(boolean possiblyMultiple) {
        this.possiblyMultiple = possiblyMultiple;
    }

    public void setNeedsAccessTree(boolean needsAccessTree) {
        this.needsAccessTree = needsAccessTree;
    }

    public void setAllocateZonesForPointed(boolean allocateZonesForPointed) {
        this.allocateZonesForPointed = allocateZonesForPointed;
    }

    private boolean containsSomeCIOSymbol(TapList<ZoneInfoAccessElements> accesses) {
        boolean contains = false;
        while (accesses != null && !contains) {
            Tree accessTree = ((ZoneInfoAccessElements)accesses.head).accessTree;
            contains = accessTree != null && ILUtils.isACIOSymbol(accessTree);
            accesses = accesses.tail;
        }
        return contains;
    }

    private boolean thisIsIO(WrapperTypeSpec accessType, TapList<ZoneInfoAccessElements> accesses, SymbolTable declSymbolTable) {
        if (declSymbolTable == null && accesses != null) {
            declSymbolTable = ((ZoneInfoAccessElements)accesses.head).symbolTable;
        }
        return declSymbolTable != null && TapEnv.isC(declSymbolTable.language()) && (accessType.isAnIOTypeSpec(declSymbolTable) || this.containsSomeCIOSymbol(accesses));
    }

    public TapList allocateZones(WrapperTypeSpec type, int typeModifier, TapList<String> declExtraInfo, TapList<ZoneInfoAccessElements> accesses, WrapperTypeSpec rootType, int accessArgRankOrResultZero, boolean isInt, boolean isReal, boolean isPtr, ZoneInfo targetZoneOf, SymbolTable declSymbolTable, TapList<TapPair<CompositeTypeSpec, TapList>> dejaVu) {
        TapList zones;
        if (type == null || type.wrappedType == null) {
            zones = this.allocateOneZone(new WrapperTypeSpec(null), typeModifier, accesses, rootType, accessArgRankOrResultZero, isInt, isReal, isPtr, false, targetZoneOf);
        } else if (this.thisIsIO(type, accesses, declSymbolTable)) {
            zones = new TapList(new TapIntList(TapEnv.get().origCallGraph().zoneNbOfAllIOStreams, null), null);
        } else {
            switch (type.wrappedType.kind()) {
                case 2: {
                    TapList<Object> hdIndexedAccesses;
                    ArrayTypeSpec arrayTypeSpec = (ArrayTypeSpec)type.wrappedType;
                    TapList<Object> tlIndexedAccesses = hdIndexedAccesses = new TapList<Object>(null, null);
                    while (accesses != null) {
                        tlIndexedAccesses = tlIndexedAccesses.placdl(((ZoneInfoAccessElements)accesses.head).buildIndex(arrayTypeSpec));
                        accesses = accesses.tail;
                    }
                    zones = this.allocateZones(arrayTypeSpec.elementType(), typeModifier, declExtraInfo, hdIndexedAccesses.tail, rootType, accessArgRankOrResultZero, isInt, isReal, isPtr, targetZoneOf, declSymbolTable, dejaVu);
                    break;
                }
                case 21: {
                    TapList<ZoneInfo> zoneInfosBefore = this.zoneInfos;
                    CompositeTypeSpec recordTypeSpec = (CompositeTypeSpec)type.wrappedType;
                    zones = (TapList)TapList.cassq(recordTypeSpec, dejaVu);
                    if (zones != null) {
                        zones.head = Boolean.TRUE;
                    } else {
                        for (int listLength = recordTypeSpec.fields.length + 1; listLength > 0; --listLength) {
                            zones = new TapList<Object>(null, zones);
                        }
                        dejaVu = new TapList<TapPair<CompositeTypeSpec, TapList>>(new TapPair(recordTypeSpec, zones), dejaVu);
                        TapList inZones = zones.tail;
                        for (int i = 0; i < recordTypeSpec.fields.length; ++i) {
                            FieldDecl field = recordTypeSpec.fields[i];
                            if (field != null) {
                                TapList<Object> hdFieldedAccesses;
                                TapList<Object> tlFieldedAccesses = hdFieldedAccesses = new TapList<Object>(null, null);
                                TapList<ZoneInfoAccessElements> inAccesses = accesses;
                                while (inAccesses != null) {
                                    tlFieldedAccesses = tlFieldedAccesses.placdl(((ZoneInfoAccessElements)inAccesses.head).buildField(field, i));
                                    inAccesses = inAccesses.tail;
                                }
                                inZones.head = this.allocateZones(field.type(), typeModifier, field.extraInfo(), hdFieldedAccesses.tail, rootType, accessArgRankOrResultZero, isInt, isReal, isPtr, targetZoneOf, declSymbolTable, dejaVu);
                            }
                            inZones = inZones.tail;
                        }
                        if (zones.head != null) {
                            TapList<ZoneInfo> zoneInfosNow = this.zoneInfos;
                            while (zoneInfosNow != zoneInfosBefore) {
                                ((ZoneInfo)zoneInfosNow.head).setMultiple();
                                zoneInfosNow = zoneInfosNow.tail;
                            }
                        }
                    }
                    zones = zones.tail;
                    break;
                }
                case 5: {
                    ModifiedTypeSpec modifiedTypeSpec = (ModifiedTypeSpec)type.wrappedType;
                    if (declSymbolTable != null) {
                        modifiedTypeSpec.resolveSizeModifier(declSymbolTable);
                    }
                    int sizeModifier = modifiedTypeSpec.sizeModifierValue();
                    zones = this.allocateZones(modifiedTypeSpec.elementType(), sizeModifier == -1 ? typeModifier : sizeModifier, declExtraInfo, accesses, rootType, accessArgRankOrResultZero, isInt, isReal, isPtr, targetZoneOf, declSymbolTable, dejaVu);
                    break;
                }
                case 6: {
                    TapList<Object> hdDerefedAccesses;
                    zones = this.allocateOneZone(type, typeModifier, accesses, rootType, accessArgRankOrResultZero, isInt, isReal, true, TapList.containsEquals(declExtraInfo, "allocatable"), targetZoneOf);
                    ZoneInfo pointerZone = this.lastAllocated();
                    PointerTypeSpec pointerType = (PointerTypeSpec)type.wrappedType;
                    TapList<Object> tlDerefedAccesses = hdDerefedAccesses = new TapList<Object>(null, null);
                    while (accesses != null) {
                        tlDerefedAccesses = tlDerefedAccesses.placdl(((ZoneInfoAccessElements)accesses.head).buildDeref(pointerType));
                        accesses = accesses.tail;
                    }
                    pointerZone.targetZonesTree = this.allocateZones(pointerType.destinationType, -1, null, hdDerefedAccesses.tail, rootType, accessArgRankOrResultZero, false, false, false, pointerZone, declSymbolTable, dejaVu);
                    break;
                }
                case 9: {
                    zones = this.allocateOneZone(type, typeModifier, accesses, rootType, accessArgRankOrResultZero, isInt, true, isPtr, TapList.containsEquals(declExtraInfo, "allocatable"), targetZoneOf);
                    break;
                }
                case 7: 
                case 10: {
                    zones = this.allocateOneZone(type, typeModifier, accesses, rootType, accessArgRankOrResultZero, isInt, isReal, isPtr, TapList.containsEquals(declExtraInfo, "allocatable"), targetZoneOf);
                    break;
                }
                case 3: {
                    zones = this.allocateOneZone(type, typeModifier, accesses, rootType, accessArgRankOrResultZero, false, false, false, false, targetZoneOf);
                    break;
                }
                default: {
                    zones = null;
                }
            }
        }
        return zones;
    }

    public TapList allocateOneZone(WrapperTypeSpec type, int accessTypeModifier, TapList<ZoneInfoAccessElements> accesses, WrapperTypeSpec rootType, int accessArgRankOrResultZero, boolean isInt, boolean isReal, boolean isPtr, boolean isAllocatable, ZoneInfo targetZoneOf) {
        if (TypeSpec.isA(type, 10)) {
            isReal = true;
            isInt = true;
        }
        if (TypeSpec.isA(type, 7)) {
            String typeName = ((PrimitiveTypeSpec)type.wrappedType).name();
            if (typeName.equals("integer")) {
                isInt = true;
            }
            if (typeName.equals("float") || typeName.equals("complex")) {
                isReal = true;
            }
        }
        if (TypeSpec.isA(type, 6)) {
            isPtr = true;
        }
        ZoneInfo zoneInfo = targetZoneOf != null ? new ZoneInfo(-1, -1, false) : new ZoneInfo(this.startOffset, this.endOffset, this.infiniteEndOffset);
        if (this.possiblyMultiple) {
            zoneInfo.setMultiple();
        }
        if (this.ambiguousWithoutIndices) {
            zoneInfo.setAmbiguousWithoutIndices();
        }
        zoneInfo.commonName = this.commonName;
        if (this.targetSymbolTable.isGlobalSymbolTable() || this.targetSymbolTable.isTranslationUnitSymbolTable()) {
            zoneInfo.setKind(13);
            zoneInfo.index = this.nextZone;
        }
        if (this.targetSymbolTable.isGlobalSymbolTable()) {
            zoneInfo.isHidden = true;
        }
        zoneInfo.type = type;
        zoneInfo.rootAccessType = rootType;
        zoneInfo.typeSizeModifier = accessTypeModifier;
        zoneInfo.isAllocatable = isAllocatable;
        if (accessArgRankOrResultZero == 0) {
            zoneInfo.setKind(10);
            zoneInfo.index = 0;
            zoneInfo.isHidden = false;
        } else if (accessArgRankOrResultZero > 0) {
            zoneInfo.setKind(7);
            zoneInfo.index = accessArgRankOrResultZero;
            zoneInfo.isHidden = false;
        }
        if (isInt) {
            zoneInfo.intZoneNb = this.nextIntZone++;
            this.intZoneInfos = new TapList<ZoneInfo>(zoneInfo, this.intZoneInfos);
        } else {
            zoneInfo.intZoneNb = -1;
        }
        if (isReal) {
            zoneInfo.realZoneNb = this.nextRealZone++;
            this.realZoneInfos = new TapList<ZoneInfo>(zoneInfo, this.realZoneInfos);
        } else {
            zoneInfo.realZoneNb = -1;
        }
        if (isPtr) {
            zoneInfo.ptrZoneNb = this.nextPtrZone++;
            this.ptrZoneInfos = new TapList<ZoneInfo>(zoneInfo, this.ptrZoneInfos);
        } else {
            zoneInfo.ptrZoneNb = -1;
        }
        zoneInfo.targetZoneOf = targetZoneOf;
        zoneInfo.zoneNb = this.nextZone++;
        boolean hasUsedFormalParamName = false;
        while (accesses != null) {
            boolean accessThroughParameter;
            ZoneInfoAccessElements oneAccess = (ZoneInfoAccessElements)accesses.head;
            SymbolDecl rootSymbol = oneAccess.symbolDecl;
            if (rootSymbol instanceof SubVariableDecl) {
                rootSymbol = ((SubVariableDecl)rootSymbol).trueVariableDecl;
            }
            boolean bl = accessThroughParameter = rootSymbol instanceof VariableDecl && ((VariableDecl)rootSymbol).formalArgRank >= 0;
            if (this.targetSymbolTable.isGlobalSymbolTable() && oneAccess.symbolTable != null && oneAccess.symbolTable.unit != null) {
                ZoneInfo proxyZoneInfo = zoneInfo.copy();
                proxyZoneInfo.shareActivity(zoneInfo);
                proxyZoneInfo.from = null;
                proxyZoneInfo.declarationUnit = oneAccess.symbolTable.unit;
                proxyZoneInfo.isHidden = oneAccess.symbolTable.isGlobalSymbolTable();
                proxyZoneInfo.accessTree = oneAccess.accessTree;
                proxyZoneInfo.description = ILUtils.toString(proxyZoneInfo.accessTree, Unit.language(proxyZoneInfo.declarationUnit), this.ambiguousWithoutIndices);
                proxyZoneInfo.accessIndexes = oneAccess.accessIndexes;
                if (rootSymbol != null) {
                    if (rootSymbol.symbol != null) {
                        proxyZoneInfo.addVariableName(rootSymbol.symbol);
                    }
                    if (proxyZoneInfo.ownerSymbolDecl == null) {
                        proxyZoneInfo.ownerSymbolDecl = rootSymbol;
                    }
                }
                SymbolTable importsSymbolTable = TapEnv.isC(oneAccess.symbolTable.language()) ? oneAccess.symbolTable : oneAccess.symbolTable.unit.importsSymbolTable();
                if (zoneInfo.targetZoneOf != null) {
                    proxyZoneInfo.targetZoneOf = importsSymbolTable.retrieveWaitingPtrZoneInfo(zoneInfo.targetZoneOf.ptrZoneNb);
                }
                if (importsSymbolTable != null) {
                    importsSymbolTable.addWaitingZoneInfo(proxyZoneInfo);
                }
                if (zoneInfo.accessTree == null || accessThroughParameter) {
                    zoneInfo.accessTree = oneAccess.accessTree;
                    zoneInfo.declarationUnit = oneAccess.symbolTable.unit;
                    zoneInfo.description = ILUtils.toString(zoneInfo.accessTree, Unit.language(zoneInfo.declarationUnit), this.ambiguousWithoutIndices);
                }
                if (this.commonName != null) {
                    if (zoneInfo.isRemanentLocal()) {
                        zoneInfo.declarationUnit = proxyZoneInfo.declarationUnit;
                        zoneInfo.description = ILUtils.toString(zoneInfo.accessTree, Unit.language(zoneInfo.declarationUnit), false) + "[save in " + zoneInfo.declarationUnit.shortName() + "]";
                    } else {
                        zoneInfo.declarationUnit = proxyZoneInfo.declarationUnit;
                        zoneInfo.description = this.commonName + "[" + this.startOffset + "," + (this.infiniteEndOffset ? "+inf" : Integer.valueOf(this.endOffset)) + "[";
                    }
                } else if (zoneInfo.accessTree != null) {
                    if (zoneInfo.comesFromAllocate()) {
                        zoneInfo.declarationUnit = proxyZoneInfo.declarationUnit;
                        zoneInfo.description = ILUtils.toString(zoneInfo.accessTree, Unit.language(zoneInfo.declarationUnit), false);
                        proxyZoneInfo.isHidden = true;
                        proxyZoneInfo.description = zoneInfo.description;
                    } else {
                        zoneInfo.declarationUnit = proxyZoneInfo.declarationUnit;
                        zoneInfo.description = ILUtils.toString(zoneInfo.accessTree, Unit.language(zoneInfo.declarationUnit), this.ambiguousWithoutIndices);
                    }
                }
                if (zoneInfo.ownerSymbolDecl == null) {
                    zoneInfo.ownerSymbolDecl = rootSymbol;
                }
            } else {
                zoneInfo.declarationUnit = this.targetSymbolTable.unit;
                if (zoneInfo.accessTree == null || accessThroughParameter) {
                    zoneInfo.accessTree = oneAccess.accessTree;
                    zoneInfo.description = ILUtils.toString(zoneInfo.accessTree, Unit.language(zoneInfo.declarationUnit), this.ambiguousWithoutIndices);
                    zoneInfo.accessIndexes = oneAccess.accessIndexes;
                }
                if (rootSymbol != null) {
                    if (rootSymbol.symbol != null) {
                        zoneInfo.addVariableName(rootSymbol.symbol);
                    }
                    if (zoneInfo.ownerSymbolDecl == null) {
                        zoneInfo.ownerSymbolDecl = rootSymbol;
                    }
                }
                SymbolTable importsSymbolTable = null;
                importsSymbolTable = this.targetSymbolTable;
                if (importsSymbolTable.isTranslationUnitSymbolTable()) {
                    importsSymbolTable.addWaitingZoneInfo(zoneInfo);
                }
            }
            accesses = accesses.tail;
        }
        this.zoneInfos = new TapList<ZoneInfo>(zoneInfo, this.zoneInfos);
        return new TapList<TapIntList>(new TapIntList(zoneInfo.zoneNb, null), null);
    }

    public ZoneInfo lastAllocated() {
        if (this.zoneInfos == null) {
            return null;
        }
        return (ZoneInfo)this.zoneInfos.head;
    }

    public void addVarDecl(TapList zonesTree, SymbolDecl symbolDecl) {
        TapIntList zones = ZoneInfo.listAllZones(zonesTree, true);
        while (zones != null) {
            ZoneInfo zoneInfo = (ZoneInfo)TapList.nth(this.zoneInfos, this.nextZone - zones.head - 1);
            if (zoneInfo != null) {
                zoneInfo.ownerSymbolDecl = symbolDecl;
            }
            zones = zones.tail;
        }
    }

    public void addArgRank(TapList zonesTree, int argRank) {
        TapIntList zones = ZoneInfo.listAllZones(zonesTree, true);
        while (zones != null) {
            ZoneInfo zoneInfo = (ZoneInfo)TapList.nth(this.zoneInfos, this.nextZone - zones.head - 1);
            if (zoneInfo != null) {
                if (argRank == 0) {
                    zoneInfo.setKind(10);
                } else if (argRank > 0) {
                    zoneInfo.setKind(7);
                }
                zoneInfo.index = argRank;
            }
            zones = zones.tail;
        }
    }

    public void extractAllZoneInfosIntoTargetSymbolTable(TapList<ZoneInfo> toAllocatedZones) {
        ZoneInfo[] newZoneInfos = this.extractZoneInfos();
        this.targetSymbolTable.setDeclaredZoneInfos(newZoneInfos, 0);
        this.targetSymbolTable.setFreeDeclaredZone(this.nextZone, 0);
        if (toAllocatedZones != null) {
            for (int i = 0; i < newZoneInfos.length; ++i) {
                toAllocatedZones.placdl(newZoneInfos[i]);
            }
        }
        this.targetSymbolTable.setDeclaredZoneInfos(this.extractIntZoneInfos(), 2);
        this.targetSymbolTable.setFreeDeclaredZone(this.nextIntZone, 2);
        this.targetSymbolTable.setDeclaredZoneInfos(this.extractRealZoneInfos(), 1);
        this.targetSymbolTable.setFreeDeclaredZone(this.nextRealZone, 1);
        this.targetSymbolTable.setDeclaredZoneInfos(this.extractPtrZoneInfos(), 3);
        this.targetSymbolTable.setFreeDeclaredZone(this.nextPtrZone, 3);
    }

    public ZoneInfo[] extractAllZoneInfosAsExternalShape() {
        return this.extractZoneInfos();
    }

    private ZoneInfo[] extractZoneInfos() {
        int nbz = TapList.length(this.zoneInfos);
        ZoneInfo[] result = new ZoneInfo[nbz];
        for (int i = nbz - 1; i >= 0; --i) {
            result[i] = (ZoneInfo)this.zoneInfos.head;
            this.zoneInfos = this.zoneInfos.tail;
        }
        return result;
    }

    private ZoneInfo[] extractIntZoneInfos() {
        int nbz = TapList.length(this.intZoneInfos);
        ZoneInfo[] result = new ZoneInfo[nbz];
        for (int i = nbz - 1; i >= 0; --i) {
            result[i] = (ZoneInfo)this.intZoneInfos.head;
            this.intZoneInfos = this.intZoneInfos.tail;
        }
        return result;
    }

    private ZoneInfo[] extractRealZoneInfos() {
        int nbz = TapList.length(this.realZoneInfos);
        ZoneInfo[] result = new ZoneInfo[nbz];
        for (int i = nbz - 1; i >= 0; --i) {
            result[i] = (ZoneInfo)this.realZoneInfos.head;
            this.realZoneInfos = this.realZoneInfos.tail;
        }
        return result;
    }

    private ZoneInfo[] extractPtrZoneInfos() {
        int nbz = TapList.length(this.ptrZoneInfos);
        ZoneInfo[] result = new ZoneInfo[nbz];
        for (int i = nbz - 1; i >= 0; --i) {
            result[i] = (ZoneInfo)this.ptrZoneInfos.head;
            this.ptrZoneInfos = this.ptrZoneInfos.tail;
        }
        return result;
    }
}

