/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.representation;

import fr.inria.tapenade.representation.ArrayDim;
import fr.inria.tapenade.representation.ArrayTypeSpec;
import fr.inria.tapenade.representation.CompositeTypeSpec;
import fr.inria.tapenade.representation.FieldDecl;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.ModifiedTypeSpec;
import fr.inria.tapenade.representation.NewSymbolHolder;
import fr.inria.tapenade.representation.PointerTypeSpec;
import fr.inria.tapenade.representation.PrimitiveTypeSpec;
import fr.inria.tapenade.representation.SymbolDecl;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.TypeDecl;
import fr.inria.tapenade.representation.TypeSpec;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.utils.TapPair;
import fr.inria.tapenade.utils.TapTriplet;
import fr.inria.tapenade.utils.ToBool;
import fr.inria.tapenade.utils.ToObject;
import fr.inria.tapenade.utils.Tree;
import java.io.IOException;

public final class WrapperTypeSpec
extends TypeSpec {
    public TypeSpec wrappedType;

    public WrapperTypeSpec(TypeSpec wrappedType) {
        super(14);
        this.wrappedType = wrappedType;
    }

    public static boolean isFunctionOrPointerToFunction(WrapperTypeSpec typeSpec) {
        return WrapperTypeSpec.isA(typeSpec, 3) || WrapperTypeSpec.isA(typeSpec, 6) && WrapperTypeSpec.isA(((PointerTypeSpec)typeSpec.wrappedType).destinationType, 3);
    }

    public static boolean isPointerOrArrayOfPointer(WrapperTypeSpec typeSpec) {
        return WrapperTypeSpec.isA(typeSpec, 6) || WrapperTypeSpec.isA(typeSpec, 2) && WrapperTypeSpec.isA(typeSpec.wrappedType.elementType(), 6);
    }

    public static boolean canReceiveVectorialDim(WrapperTypeSpec typeSpec, boolean passedArray) {
        if (typeSpec == null || typeSpec.wrappedType == null) {
            return false;
        }
        if (WrapperTypeSpec.isA(typeSpec, 7)) {
            return true;
        }
        if (WrapperTypeSpec.isA(typeSpec, 2)) {
            if (passedArray) {
                return false;
            }
            return WrapperTypeSpec.canReceiveVectorialDim(typeSpec.wrappedType.elementType(), true);
        }
        if (WrapperTypeSpec.isA(typeSpec, 5)) {
            return WrapperTypeSpec.canReceiveVectorialDim(typeSpec.wrappedType.elementType(), passedArray);
        }
        return false;
    }

    public static boolean hasPointerOnTop(WrapperTypeSpec typeSpec) {
        if (typeSpec == null || typeSpec.wrappedType == null) {
            return false;
        }
        if (WrapperTypeSpec.isA(typeSpec, 6)) {
            return true;
        }
        if (WrapperTypeSpec.isA(typeSpec, 5)) {
            return WrapperTypeSpec.hasPointerOnTop(typeSpec.wrappedType.elementType());
        }
        return false;
    }

    protected static boolean hasAnArrayDimension(WrapperTypeSpec typeSpec) {
        if (WrapperTypeSpec.isA(typeSpec, 2)) {
            return true;
        }
        if (WrapperTypeSpec.isA(typeSpec, 6) && ((PointerTypeSpec)typeSpec.wrappedType).destinationType != null) {
            return WrapperTypeSpec.hasAnArrayDimension(((PointerTypeSpec)typeSpec.wrappedType).destinationType);
        }
        return false;
    }

    public static boolean isFree(WrapperTypeSpec typeSpec) {
        return typeSpec == null || typeSpec.wrappedType == null;
    }

    public static boolean isNullOrVoid(WrapperTypeSpec typeSpec) {
        return typeSpec == null || typeSpec.wrappedType == null || typeSpec.wrappedType.kind() == 9;
    }

    public static WrapperTypeSpec preciseDimensions(WrapperTypeSpec mainType, WrapperTypeSpec complementType, TapList<TapPair<TypeSpec, TypeSpec>> dejaVu, SymbolTable symbolTable) {
        if (mainType == null || complementType == null || mainType.wrappedType == null || complementType.wrappedType == null) {
            return mainType;
        }
        TypeSpec precisedActualType = mainType.wrappedType.preciseDimensions(complementType.wrappedType, dejaVu, symbolTable);
        if (precisedActualType == mainType.wrappedType || precisedActualType == null) {
            return mainType;
        }
        return new WrapperTypeSpec(precisedActualType);
    }

    public static WrapperTypeSpec intToReal(WrapperTypeSpec origType, TapList<TapPair<TypeSpec, TypeSpec>> dejaVu, SymbolTable symbolTable) {
        if (origType == null || origType.wrappedType == null) {
            return origType;
        }
        TypeSpec convertedActualType = origType.wrappedType.intToReal(dejaVu, symbolTable);
        if (convertedActualType == origType.wrappedType || convertedActualType == null) {
            return origType;
        }
        return new WrapperTypeSpec(convertedActualType);
    }

    public WrapperTypeSpec scalarTypeSpec(boolean stopOnPointer, SymbolTable symbolTable) {
        if (WrapperTypeSpec.isA(this, 2) && this.wrappedType.elementType() != null) {
            return this.wrappedType.elementType().scalarTypeSpec(stopOnPointer, symbolTable);
        }
        if (WrapperTypeSpec.isA(this, 5) && ((ModifiedTypeSpec)this.wrappedType).sizeModifierValue() == -1) {
            return this.wrappedType.elementType().scalarTypeSpec(stopOnPointer, symbolTable);
        }
        if (!stopOnPointer && WrapperTypeSpec.isA(this, 6)) {
            return ((PointerTypeSpec)this.wrappedType).destinationType.scalarTypeSpec(stopOnPointer, symbolTable);
        }
        return this;
    }

    protected boolean checkBoolean() {
        WrapperTypeSpec baseType = this.baseTypeSpec(true);
        if (baseType.wrappedType == null) {
            baseType.wrappedType = new PrimitiveTypeSpec("boolean");
            return true;
        }
        return WrapperTypeSpec.isA(baseType, 7) && (baseType.wrappedType.baseTypeName().equals("boolean") || TapEnv.inputLanguage() == 4 && baseType.wrappedType.baseTypeName().equals("integer")) || TapEnv.relatedLanguage() == 4 && WrapperTypeSpec.isA(baseType, 12);
    }

    protected boolean checkNumeric() {
        WrapperTypeSpec baseType = this.baseTypeSpec(true);
        if (baseType != null && baseType.wrappedType == null) {
            baseType.wrappedType = new PrimitiveTypeSpec("float");
            baseType.wrappedType.setUndefinedNumeric(true);
            return true;
        }
        if ((TapEnv.relatedLanguageIsC() || TapEnv.relatedLanguageIsCPLUSPLUS()) && (WrapperTypeSpec.isA(this.wrappedType, 6) || WrapperTypeSpec.isA(this.wrappedType, 12))) {
            return true;
        }
        return baseType != null && baseType.isNumericBase();
    }

    protected boolean checkNumericInt() {
        WrapperTypeSpec baseType = this.baseTypeSpec(true);
        if (baseType.wrappedType == null) {
            baseType.wrappedType = new PrimitiveTypeSpec("integer");
            return true;
        }
        return WrapperTypeSpec.isA(baseType, 7) && ((PrimitiveTypeSpec)baseType.wrappedType).isInteger() || WrapperTypeSpec.isA(baseType, 12) && TapEnv.relatedLanguageIsC();
    }

    protected boolean checkRecord() {
        if (this.wrappedType == null) {
            FieldDecl[] fieldDecls = null;
            this.wrappedType = new CompositeTypeSpec(null, fieldDecls, 8, null, null);
            return true;
        }
        return WrapperTypeSpec.isA(this.wrappedType, 21) || WrapperTypeSpec.isA(this.wrappedType, 23);
    }

    protected boolean checkPointer() {
        if (this.wrappedType == null) {
            this.wrappedType = new PointerTypeSpec(new WrapperTypeSpec(null), null);
            return true;
        }
        return WrapperTypeSpec.isA(this.wrappedType, 6);
    }

    protected boolean checkArray() {
        if (this.wrappedType == null) {
            this.wrappedType = new ArrayTypeSpec(new WrapperTypeSpec(null), null);
            return true;
        }
        return WrapperTypeSpec.isA(this.wrappedType, 2);
    }

    public boolean isPrimitiveTypeCharacter() {
        return this.baseTypeName() != null && this.baseTypeName().equals("character") && WrapperTypeSpec.isA(this, 7);
    }

    protected boolean isPrimitiveTypeFloat() {
        return this.baseTypeName() != null && this.baseTypeName().equals("float") && WrapperTypeSpec.isA(this, 7);
    }

    protected boolean isPrimitiveTypeInteger() {
        return this.baseTypeName() != null && this.baseTypeName().equals("integer") && WrapperTypeSpec.isA(this, 7);
    }

    protected boolean isMetaType() {
        boolean result = WrapperTypeSpec.isA(this, 10);
        if (!result && WrapperTypeSpec.isA(this, 2)) {
            result = WrapperTypeSpec.isA(this.wrappedType.elementType(), 10);
        }
        return result;
    }

    @Override
    public boolean isScalar() {
        WrapperTypeSpec typeSpec = this;
        while (WrapperTypeSpec.isA(typeSpec, 5)) {
            typeSpec = typeSpec.wrappedType.elementType();
        }
        return WrapperTypeSpec.isA(typeSpec, 7);
    }

    protected WrapperTypeSpec conformingTypeSpec(WrapperTypeSpec type1, WrapperTypeSpec type2) {
        WrapperTypeSpec resultType;
        TapList<ArrayDim> dims12;
        if ((type1 == null || type1.isCharacter() || type1.isString()) && (type2 == null || type2.isCharacter() || type2.isString())) {
            return this;
        }
        if (type1 != null && type2 != null && !WrapperTypeSpec.isA(type1, 10) && !WrapperTypeSpec.isA(type2, 10) && this.baseTypeName().equals(type1.baseTypeName()) && type1.equalsLiterally(type2)) {
            return type1;
        }
        WrapperTypeSpec elemType1 = null;
        WrapperTypeSpec elemType2 = null;
        TapList<ArrayDim> dims1 = null;
        TapList<ArrayDim> dims2 = null;
        if (type1 != null) {
            dims1 = type1.getAllDimensions();
        }
        if (type2 != null) {
            dims2 = type2.getAllDimensions();
        }
        if (dims1 == null) {
            dims12 = dims2;
            elemType1 = type1;
        } else if (dims2 == null) {
            dims12 = dims1;
            elemType2 = type2;
        } else {
            TapList<ArrayDim> tlDims12 = dims12 = new TapList<Object>(null, null);
            boolean conforms = true;
            while (conforms && dims1 != null && dims2 != null) {
                ArrayDim newDim = ArrayDim.testConformingAndChoose((ArrayDim)dims1.head, (ArrayDim)dims2.head);
                if (newDim == null) {
                    conforms = false;
                } else {
                    tlDims12 = tlDims12.placdl(newDim);
                }
                dims1 = dims1.tail;
                dims2 = dims2.tail;
            }
            if (!conforms || dims1 != null || dims2 != null) {
                WrapperTypeSpec resultType2 = null;
                return resultType2;
            }
            dims12 = dims12.tail;
        }
        if (dims12 == null) {
            if (WrapperTypeSpec.isA(this, 7) && (this.wrappedType.baseTypeName().equals("float") || this.wrappedType.baseTypeName().equals("complex"))) {
                if (WrapperTypeSpec.isA(type1, 5) && WrapperTypeSpec.isA(type2, 5)) {
                    resultType = this;
                    if (type1.equalsCompilDep(type2)) {
                        resultType = type1;
                    } else {
                        int size1 = ((ModifiedTypeSpec)type1.wrappedType).sizeModifierValue();
                        int size2 = ((ModifiedTypeSpec)type2.wrappedType).sizeModifierValue();
                        if (size1 > 0 && size1 > size2) {
                            resultType = new WrapperTypeSpec(new ModifiedTypeSpec(this, (ModifiedTypeSpec)type1.wrappedType));
                        } else if (size2 > 0) {
                            resultType = new WrapperTypeSpec(new ModifiedTypeSpec(this, (ModifiedTypeSpec)type2.wrappedType));
                        }
                    }
                } else if (WrapperTypeSpec.isA(type1, 5)) {
                    if (type1.hasUndefinedSize()) {
                        type2.receives(type1, null, null);
                    }
                    resultType = new WrapperTypeSpec(new ModifiedTypeSpec(this, (ModifiedTypeSpec)type1.wrappedType));
                } else if (WrapperTypeSpec.isA(type2, 5)) {
                    if (type2.hasUndefinedSize()) {
                        type1.receives(type2, null, null);
                    }
                    resultType = new WrapperTypeSpec(new ModifiedTypeSpec(this, (ModifiedTypeSpec)type2.wrappedType));
                } else {
                    resultType = this;
                }
            } else {
                resultType = this;
            }
            if (TapEnv.traceTypeCheckAnalysis()) {
                TapEnv.indentOnTrace(TapEnv.traceIndent());
                TapEnv.printlnOnTrace("ConformingTS of " + this + " :: " + type1 + " + " + type2 + " --> " + resultType);
            }
        } else {
            ArrayDim[] dimensions = new ArrayDim[TapList.length(dims12)];
            int i = 0;
            while (dims12 != null) {
                dimensions[i] = (ArrayDim)dims12.head;
                ++i;
                dims12 = dims12.tail;
            }
            if (WrapperTypeSpec.isA(type1, 2)) {
                elemType1 = type1.wrappedType.elementType();
            }
            if (WrapperTypeSpec.isA(type2, 2)) {
                elemType2 = type2.wrappedType.elementType();
            }
            WrapperTypeSpec elementType = this.conformingTypeSpec(elemType1, elemType2);
            resultType = new WrapperTypeSpec(new ArrayTypeSpec(elementType, dimensions));
            if (TapEnv.traceTypeCheckAnalysis()) {
                TapEnv.indentOnTrace(TapEnv.traceIndent());
                TapEnv.printlnOnTrace("ConformingTS of " + this + " :: " + type1 + " + " + type2 + " --> " + resultType);
            }
        }
        return resultType;
    }

    public WrapperTypeSpec combineWith(WrapperTypeSpec newTypeSpec, SymbolTable symbolTable) {
        if (this.wrappedType == null) {
            return newTypeSpec;
        }
        if (newTypeSpec.wrappedType != null) {
            TypeSpec sumActualTypeSpec = this.wrappedType.combineWith(newTypeSpec.wrappedType, symbolTable);
            if (sumActualTypeSpec == null) {
                return null;
            }
            return new WrapperTypeSpec(sumActualTypeSpec);
        }
        return this;
    }

    public WrapperTypeSpec addWith(WrapperTypeSpec type) {
        WrapperTypeSpec result = this;
        if (this.wrappedType == null || WrapperTypeSpec.isA(this, 9)) {
            result = type;
        } else if (type == null || type.wrappedType == null || WrapperTypeSpec.isA(type, 9)) {
            result = this;
        } else {
            int typeElemTypeSize;
            int thisElemTypeSize;
            ToObject<Object> toModified = new ToObject<Object>(null);
            WrapperTypeSpec thisElemType = this.elementType();
            WrapperTypeSpec thisBaseType = TypeSpec.peelSizeModifier(thisElemType, toModified);
            Tree thisModifier = null;
            if (toModified.obj() != null) {
                thisModifier = ((ModifiedTypeSpec)toModified.obj()).sizeModifier;
                thisElemTypeSize = ((ModifiedTypeSpec)toModified.obj()).sizeModifierValue();
                if (thisElemTypeSize != -1) {
                    thisElemTypeSize = ((ModifiedTypeSpec)toModified.obj()).computeSize();
                }
            } else {
                thisElemTypeSize = thisBaseType.computeSize();
            }
            WrapperTypeSpec typeElemType = type.elementType();
            WrapperTypeSpec typeBaseType = TypeSpec.peelSizeModifier(typeElemType, toModified);
            Tree typeModifier = null;
            if (toModified.obj() != null) {
                typeModifier = ((ModifiedTypeSpec)toModified.obj()).sizeModifier;
                typeElemTypeSize = ((ModifiedTypeSpec)toModified.obj()).sizeModifierValue();
                if (typeElemTypeSize != -1) {
                    typeElemTypeSize = ((ModifiedTypeSpec)toModified.obj()).computeSize();
                }
            } else {
                typeElemTypeSize = typeBaseType.computeSize();
            }
            if (WrapperTypeSpec.isA(thisBaseType, 6)) {
                result = thisBaseType.conformingTypeSpec(this, type);
            } else if (WrapperTypeSpec.isA(typeBaseType, 6)) {
                result = typeBaseType.conformingTypeSpec(this, type);
            } else if (WrapperTypeSpec.isA(thisBaseType, 12)) {
                result = typeBaseType.conformingTypeSpec(this, type);
            } else if (WrapperTypeSpec.isA(typeBaseType, 12)) {
                result = thisBaseType.conformingTypeSpec(this, type);
            } else if (WrapperTypeSpec.isA(thisBaseType, 7)) {
                result = new WrapperTypeSpec(((PrimitiveTypeSpec)thisBaseType.wrappedType).addWith(typeBaseType));
                String resultBaseTypeName = result.baseTypeName();
                if (resultBaseTypeName.equals(thisBaseType.baseTypeName())) {
                    result = resultBaseTypeName.equals(typeBaseType.baseTypeName()) ? (thisElemTypeSize == -1 ? thisElemType : (typeElemTypeSize == -1 ? typeElemType : (thisElemTypeSize >= typeElemTypeSize ? thisElemType : typeElemType))) : thisElemType;
                } else if (resultBaseTypeName.equals(typeBaseType.baseTypeName())) {
                    result = typeElemType;
                }
                result = result.conformingTypeSpec(this, type);
            }
        }
        return result;
    }

    public WrapperTypeSpec checkNoneDimensionsOfNewSH(String hintNameInText, String hintNameInIdent, Tree hintTreeInCallSize, SymbolTable symbolTable, NewSymbolHolder symbolHolder) {
        ArrayTypeSpec arrayTypeSpec;
        ArrayDim[] checkedDimensions;
        WrapperTypeSpec type = this;
        if (WrapperTypeSpec.isA(this, 2) && (checkedDimensions = (arrayTypeSpec = (ArrayTypeSpec)this.wrappedType).checkNoneDimensions(arrayTypeSpec.dimensions(), !symbolTable.isFormalParamsLevel(), false, null, hintNameInText, hintNameInIdent, hintTreeInCallSize, symbolHolder == null ? null : symbolHolder.hintRootTree, symbolTable, symbolHolder)) != null) {
            type = new WrapperTypeSpec(new ArrayTypeSpec(arrayTypeSpec.elementType(), checkedDimensions));
        }
        return type;
    }

    public boolean easilyDeclared() {
        if (this.wrappedType == null) {
            return false;
        }
        switch (this.wrappedType.kind()) {
            case 2: {
                WrapperTypeSpec basisTypeSpec = this.wrappedType.elementType();
                boolean easy = basisTypeSpec != null && basisTypeSpec.easilyDeclared();
                ArrayDim[] dimensions = ((ArrayTypeSpec)this.wrappedType).dimensions();
                for (int i = dimensions.length - 1; easy && i >= 0; --i) {
                    if (dimensions[i].lower != null && dimensions[i].upper != null) continue;
                    easy = false;
                }
                return easy;
            }
            case 5: {
                WrapperTypeSpec basisTypeSpec = this.wrappedType.elementType();
                return basisTypeSpec != null && basisTypeSpec.easilyDeclared();
            }
            case 6: 
            case 7: 
            case 9: {
                return true;
            }
        }
        return false;
    }

    public WrapperTypeSpec differentiateTypeSpecMemo(SymbolTable symbolTable, SymbolTable srcSymbolTable, int diffUnitSort, String fSuffix, boolean localDecl, boolean multiDirMode, ArrayDim multiDirDimensionMax, String hintArrayNameInText, String hintArrayNameInIdent, Tree hintArraySize, Tree nameTree) {
        if (this.wrappedType == null || symbolTable == null) {
            return null;
        }
        WrapperTypeSpec result = this.wrappedType.diffTypeSpec;
        if (TapEnv.associationByAddress() && !TapEnv.get().complexStep) {
            if (result == null) {
                WrapperTypeSpec equalsTypeSpec = TapEnv.relatedLanguageIsFortran() ? TapList.findTypeSpec(TapEnv.assocAddressDiffTypesUnit((int)3).publicSymbolTable().associationByAddressTypes, this) : TapList.findTypeSpec(symbolTable.getCallGraph().globalRootSymbolTable().associationByAddressTypes, this);
                if (equalsTypeSpec != null && equalsTypeSpec != this) {
                    result = equalsTypeSpec.differentiateTypeSpecMemo(symbolTable, srcSymbolTable, diffUnitSort, fSuffix, localDecl, multiDirMode, multiDirDimensionMax, hintArrayNameInText, hintArrayNameInIdent, hintArraySize, nameTree);
                    this.wrappedType.diffTypeSpec = equalsTypeSpec.wrappedType.diffTypeSpec;
                } else {
                    this.wrappedType.diffTypeSpec = result = this.wrappedType.differentiateTypeSpec(symbolTable, srcSymbolTable, diffUnitSort, fSuffix, localDecl, multiDirMode, multiDirDimensionMax, hintArrayNameInText, hintArrayNameInIdent, hintArraySize, nameTree);
                    if (this.isScalar()) {
                        if (TapEnv.relatedLanguageIsFortran()) {
                            TapEnv.assocAddressDiffTypesUnit((int)3).publicSymbolTable().associationByAddressTypes = new TapList<TypeSpec>(this, TapEnv.assocAddressDiffTypesUnit((int)3).publicSymbolTable().associationByAddressTypes);
                        } else {
                            symbolTable.getCallGraph().globalRootSymbolTable().associationByAddressTypes = new TapList<TypeSpec>(this, symbolTable.getCallGraph().globalRootSymbolTable().associationByAddressTypes);
                        }
                    }
                }
            } else {
                this.addRefDiffTypeSpec(symbolTable, srcSymbolTable);
            }
        } else {
            if (result == null) {
                result = this.wrappedType.differentiateTypeSpec(symbolTable, srcSymbolTable, diffUnitSort, fSuffix, localDecl, multiDirMode, multiDirDimensionMax, hintArrayNameInText, hintArrayNameInIdent, hintArraySize, nameTree);
                if (WrapperTypeSpec.isA(this, 21) || TapEnv.get().complexStep) {
                    this.wrappedType.diffTypeSpec = result;
                }
            } else {
                this.addRefDiffTypeSpec(symbolTable, srcSymbolTable);
            }
            if (this.wrappedType.diffTypeSpec != null && this.wrappedType.diffTypeSpec.equalsLiterally(this)) {
                this.wrappedType.diffTypeSpec = null;
                result = null;
            }
        }
        return result;
    }

    public WrapperTypeSpec equalsDiffTypeSpecAndTypeSpec() {
        if (this.wrappedType != null && this.wrappedType.diffFromTypeDecl != null && (this.wrappedType.diffFromTypeDecl.typeSpec.wrappedType.diffTypeSpec == null || WrapperTypeSpec.isA(this, 21) && ((CompositeTypeSpec)this.wrappedType.diffFromTypeDecl.typeSpec.wrappedType.diffTypeSpec.wrappedType).isEmpty() || this.equalsCompilDep(this.wrappedType.diffFromTypeDecl.typeSpec))) {
            return this.wrappedType.diffFromTypeDecl.typeSpec;
        }
        return this;
    }

    public boolean canMatchPointerTo(WrapperTypeSpec destTypeSpec) {
        TapList<ArrayDim> destdims;
        if (this == destTypeSpec) {
            return true;
        }
        TapList<ArrayDim> dims = this.getAllDimensions();
        if (dims == null == ((destdims = destTypeSpec.getAllDimensions()) != null)) {
            return false;
        }
        WrapperTypeSpec base = this.baseTypeSpec(true);
        WrapperTypeSpec destbase = destTypeSpec.baseTypeSpec(true);
        if (base == null || base.wrappedType == null) {
            return true;
        }
        if (destbase == null || destbase.wrappedType == null) {
            return false;
        }
        TypeSpec actualbase = base.wrappedType;
        TypeSpec destactualbase = destbase.wrappedType;
        if (WrapperTypeSpec.isA(actualbase, 7)) {
            if (WrapperTypeSpec.isA(destactualbase, 7)) {
                return ((PrimitiveTypeSpec)actualbase).name().equals(((PrimitiveTypeSpec)destactualbase).name());
            }
            return false;
        }
        if (WrapperTypeSpec.isA(actualbase, 3)) {
            return WrapperTypeSpec.isA(destactualbase, 3);
        }
        if (WrapperTypeSpec.isA(actualbase, 21)) {
            return actualbase == destactualbase;
        }
        return WrapperTypeSpec.isA(actualbase, 9);
    }

    public String buildTypeNameForProcName(TapList<Tree> toArraySize, SymbolTable symbolTable) {
        String tName;
        ToObject<Object> toModifiedType = new ToObject<Object>(null);
        WrapperTypeSpec bTypeSpec = WrapperTypeSpec.peelSizeModifier(this, toModifiedType);
        int modifier = toModifiedType.obj() == null ? -1 : ((ModifiedTypeSpec)toModifiedType.obj()).sizeModifierValue();
        String typeName = bTypeSpec.baseTypeName();
        if (typeName.equals("character")) {
            tName = "character";
            if (modifier != -1 && modifier != 1) {
                toArraySize.head = toArraySize.head == null ? ILUtils.build(103, modifier) : ILUtils.mulTree(ILUtils.build(103, modifier), (Tree)toArraySize.head);
            }
        } else {
            tName = typeName.equals("integer") ? (modifier > 0 ? "integer" + modifier : (modifier == -2 ? "integer" + 2 * TapEnv.get().integerSize : "integer" + TapEnv.get().integerSize)) : (typeName.equals("float") ? (modifier > 0 ? "real" + modifier : (modifier == -2 ? "real" + TapEnv.get().doubleRealSize : "real" + TapEnv.get().realSize)) : (typeName.equals("complex") ? (modifier > 0 ? "real" + 2 * modifier : (modifier == -2 ? "real" + 4 * TapEnv.get().doubleRealSize : "real" + 4 * TapEnv.get().realSize)) : (typeName.equals("Undefined") || typeName.isEmpty() ? "UNKNOWNTYPE" : typeName)));
        }
        if (toArraySize.head != null) {
            tName = tName + "ARRAY";
        }
        return tName;
    }

    protected WrapperTypeSpec pointerToArrayTypeSpec() {
        WrapperTypeSpec result = this;
        if (WrapperTypeSpec.isA(this.wrappedType, 6) && ((PointerTypeSpec)this.wrappedType).offsetLength != null) {
            result = new WrapperTypeSpec(((PointerTypeSpec)this.wrappedType).pointerToArrayTypeSpec());
        }
        return result;
    }

    @Override
    public TypeSpec wrappedType() {
        return this.wrappedType;
    }

    @Override
    public void setWrappedType(TypeSpec type) {
        this.wrappedType = type instanceof WrapperTypeSpec ? ((WrapperTypeSpec)type).wrappedType : type;
    }

    @Override
    public boolean isAnIOTypeSpec(SymbolTable symbolTable) {
        return this.wrappedType != null && this.wrappedType.isAnIOTypeSpec(symbolTable);
    }

    @Override
    protected TypeSpec cloneAsUndefinedNumeric(boolean undefined) {
        return new WrapperTypeSpec(this.wrappedType.cloneAsUndefinedNumeric(undefined));
    }

    @Override
    public TypeSpec nestedLevelType() {
        return this.wrappedType;
    }

    @Override
    public TypeSpec peelPointer() {
        return this.wrappedType == null ? null : this.wrappedType.peelPointer();
    }

    @Override
    public String baseTypeName() {
        return this.wrappedType == null ? "Undefined" : this.wrappedType.baseTypeName();
    }

    @Override
    public WrapperTypeSpec baseTypeSpec(boolean stopOnPointer) {
        if (this.wrappedType != null && (WrapperTypeSpec.isA(this.wrappedType, 2) || WrapperTypeSpec.isA(this.wrappedType, 3) || WrapperTypeSpec.isA(this.wrappedType, 5) || WrapperTypeSpec.isA(this.wrappedType, 6) && !stopOnPointer)) {
            return this.wrappedType.baseTypeSpec(stopOnPointer);
        }
        return this;
    }

    @Override
    public WrapperTypeSpec modifiedBaseTypeSpec() {
        if (WrapperTypeSpec.isA(this.wrappedType, 2) || WrapperTypeSpec.isA(this.wrappedType, 6)) {
            return this.wrappedType.modifiedBaseTypeSpec();
        }
        return this;
    }

    @Override
    public boolean containsAPointer() {
        return this.wrappedType != null && this.wrappedType.containsAPointer();
    }

    @Override
    public TapList<ArrayDim> getAllDimensions() {
        return this.wrappedType == null ? null : this.wrappedType.getAllDimensions();
    }

    @Override
    public boolean containsUnknownDimension() {
        return this.wrappedType != null && this.wrappedType.containsUnknownDimension();
    }

    @Override
    public WrapperTypeSpec elementType() {
        if (WrapperTypeSpec.isA(this.wrappedType, 2)) {
            return this.wrappedType.elementType();
        }
        return this;
    }

    @Override
    public void doUpdateAfterImports(SymbolTable symbolTable, TapList<TypeSpec> dejaVu) {
        if (this.wrappedType != null) {
            this.wrappedType.updateAfterImports(symbolTable, dejaVu);
        }
    }

    @Override
    protected int computeSize() {
        if (this.wrappedType == null) {
            return 1;
        }
        return this.wrappedType.size();
    }

    @Override
    public boolean isFunction() {
        return this.wrappedType != null && this.wrappedType.isFunction();
    }

    @Override
    public boolean isCharacter() {
        return this.wrappedType != null && this.wrappedType.isCharacter();
    }

    @Override
    public boolean isString() {
        return this.wrappedType != null && this.wrappedType.isString();
    }

    @Override
    public boolean isPointer() {
        return this.wrappedType != null && this.wrappedType.isPointer();
    }

    @Override
    public boolean isTarget() {
        return this.wrappedType != null && this.wrappedType.isTarget();
    }

    @Override
    public boolean isArray() {
        return this.wrappedType != null && this.wrappedType.isArray();
    }

    @Override
    public boolean isNamedType() {
        return this.wrappedType != null && this.wrappedType.isNamedType();
    }

    @Override
    protected boolean testComparesWith(TypeSpec other, int comparison, TypeSpec toThis, TypeSpec toOther, TapList<TapPair<TypeSpec, TypeSpec>> dejaVu) {
        if (this == other) {
            return true;
        }
        if (this.wrappedType == null) {
            if (WrapperTypeSpec.testHasInference(comparison)) {
                if (other != null) {
                    this.setWrappedType(other.weakenForInference(comparison));
                }
                return true;
            }
            return !WrapperTypeSpec.testTypesLitteral(comparison) && WrapperTypeSpec.testAcceptsUnspecified(comparison);
        }
        return this.wrappedType.comparesWith(other, comparison, this, toOther, dejaVu);
    }

    @Override
    protected TypeSpec weakenForInference(int comparison) {
        if (this.wrappedType == null) {
            return this;
        }
        return new WrapperTypeSpec(this.wrappedType.weakenForInference(comparison));
    }

    @Override
    public TypeSpec copy() {
        return new WrapperTypeSpec(this.wrappedType == null ? null : this.wrappedType.copy());
    }

    @Override
    public TypeSpec copyStopOnComposite(Unit publishedUnit) {
        TypeSpec copyWrapped = this.wrappedType == null ? null : this.wrappedType.copyStopOnComposite(publishedUnit);
        return copyWrapped == this.wrappedType ? this : new WrapperTypeSpec(copyWrapped);
    }

    @Override
    public int precisionSize() {
        return this.wrappedType == null ? -1 : this.wrappedType.precisionSize();
    }

    @Override
    public Tree buildConstantZero() {
        return this.wrappedType == null ? null : this.wrappedType.buildConstantZero();
    }

    @Override
    public Tree buildConstantOne() {
        return this.wrappedType == null ? null : this.wrappedType.buildConstantOne();
    }

    @Override
    protected boolean containsMetaType(TapList<TypeSpec> dejaVu) {
        return this.wrappedType != null && this.wrappedType.containsMetaType(dejaVu);
    }

    @Override
    protected TypeSpec localize(TapList<TapTriplet<TypeSpec, TypeSpec, Boolean>> toAlreadyCopied, ToBool containsMeta) {
        WrapperTypeSpec copiedResult = (WrapperTypeSpec)this.findAlreadyCopiedType(toAlreadyCopied, containsMeta);
        if (copiedResult == null) {
            TypeSpec copiedActualTypeSpec;
            copiedResult = new WrapperTypeSpec(null);
            TapTriplet<WrapperTypeSpec, WrapperTypeSpec, Boolean> alreadyRef = new TapTriplet<WrapperTypeSpec, WrapperTypeSpec, Boolean>(this, copiedResult, Boolean.FALSE);
            toAlreadyCopied.placdl(alreadyRef);
            TypeSpec typeSpec = copiedActualTypeSpec = this.wrappedType == null ? null : this.wrappedType.localize(toAlreadyCopied, containsMeta);
            if (copiedActualTypeSpec instanceof WrapperTypeSpec) {
                copiedResult = (WrapperTypeSpec)copiedActualTypeSpec;
                alreadyRef.second = copiedResult;
            } else {
                copiedResult.wrappedType = copiedActualTypeSpec;
            }
            if (containsMeta.get()) {
                alreadyRef.third = Boolean.TRUE;
            } else {
                alreadyRef.first = null;
            }
        }
        return copiedResult;
    }

    @Override
    protected boolean hasUndefinedSize() {
        if (this.wrappedType == null) {
            return false;
        }
        return this.wrappedType.hasUndefinedSize();
    }

    @Override
    protected void setHasUndefinedSize(boolean val) {
        if (this.wrappedType != null) {
            this.wrappedType.setHasUndefinedSize(val);
        }
    }

    @Override
    protected WrapperTypeSpec addOneDimension(ArrayDim dimension) {
        if (this.wrappedType != null) {
            return new WrapperTypeSpec(this.wrappedType.addOneDimension(dimension));
        }
        TapEnv.toolWarning(-1, "(Add one dimension) Not expected on unspecified type " + this);
        ArrayDim[] dimensions = new ArrayDim[]{dimension};
        return new WrapperTypeSpec(new ArrayTypeSpec(this, dimensions));
    }

    @Override
    protected WrapperTypeSpec realToComplex(TapList<TapPair<TypeSpec, TypeSpec>> dejaVu, WrapperTypeSpec complexTypeSpec) {
        TypeSpec convertedActualType = this.wrappedType.realToComplex(dejaVu, complexTypeSpec);
        return new WrapperTypeSpec(convertedActualType);
    }

    protected void addRefDiffTypeSpec(SymbolTable symbolTable, SymbolTable srcSymbolTable) {
        if (TapEnv.associationByAddress() && this.wrappedType.diffTypeSpec == null && !TapEnv.get().complexStep) {
            SymbolTable diffTypesSymbolTable = TapEnv.relatedLanguageIsFortran() ? TapEnv.assocAddressDiffTypesUnit(3).publicSymbolTable() : symbolTable.getCallGraph().globalRootSymbolTable();
            WrapperTypeSpec equalsTypeSpec = TapList.findTypeSpec(diffTypesSymbolTable.associationByAddressTypes, this);
            if (equalsTypeSpec != null) {
                this.wrappedType.diffTypeSpec = equalsTypeSpec.wrappedType.diffTypeSpec;
            }
        }
        this.wrappedType.addDiffTypeSpec(symbolTable, srcSymbolTable);
    }

    @Override
    public void cumulActiveParts(TapList diffInfos, SymbolTable symbolTable) {
        if (diffInfos != null && this.wrappedType != null) {
            TypeDecl typeDecl;
            this.wrappedType.cumulActiveParts(diffInfos, symbolTable);
            if (this.typeDeclName() != null && this.needsADiffType(null) && (typeDecl = symbolTable.getTypeDecl(this.typeDeclName())) != null) {
                typeDecl.setActive(true);
            }
        }
    }

    @Override
    public boolean needsADiffType(TapList<TypeSpec> dejaVu) {
        return this.wrappedType != null && this.wrappedType.needsADiffType(dejaVu);
    }

    @Override
    public boolean isDifferentiated(TapList<TypeSpec> dejaVu) {
        return this.wrappedType != null && this.wrappedType.isDifferentiated(dejaVu);
    }

    @Override
    protected boolean checkTypeSpecValidity(TapList<TypeSpec> dejaVu) {
        return this.wrappedType == null || this.wrappedType.checkTypeSpecValidity(dejaVu);
    }

    @Override
    public Tree generateTree(SymbolTable symbolTable, TapList<SymbolDecl> dependsOn, TapList<SymbolDecl> shortNames, boolean useShortNames, TapList<TypeSpec> dejaVu) {
        Tree typeTree;
        if (this.wrappedType == null) {
            TapEnv.toolWarning(-1, "(TypeSpec tree regeneration) null wrapped type");
            typeTree = ILUtils.build(96, "UnknownType");
        } else if (TapList.contains(dejaVu, this)) {
            TapEnv.toolWarning(-1, "(TypeSpec tree regeneration) circular type");
            typeTree = ILUtils.build(96, "CircularType");
        } else {
            String shortName;
            dejaVu = new TapList<TypeSpec>(this, dejaVu);
            String string = shortName = useShortNames ? this.wrappedType.findShortName(dependsOn, shortNames) : null;
            if (shortName != null) {
                typeTree = WrapperTypeSpec.isA(this, 7) ? this.wrappedType.generateTree(symbolTable, dependsOn, shortNames, false, dejaVu) : ILUtils.build(96, shortName);
            } else if (TapEnv.relatedLanguageIsC()) {
                NewSymbolHolder diffSH = this.wrappedType.diffTypeDeclSymbolHolder;
                if (diffSH != null) {
                    boolean fromOtherCompilationUnit = symbolTable != null && TapEnv.isC(symbolTable.language()) && diffSH.solvingRootIsOutsideFile(symbolTable);
                    typeTree = diffSH.makeNewRef(fromOtherCompilationUnit ? null : symbolTable);
                } else {
                    typeTree = !WrapperTypeSpec.isA(this, 7) && this.wrappedType.typeDeclName() != null ? ILUtils.build(96, this.wrappedType.genTypeDeclName()) : (WrapperTypeSpec.isA(this, 21) && ((CompositeTypeSpec)this.wrappedType).name != null ? ILUtils.build(96, ((CompositeTypeSpec)this.wrappedType).name) : this.wrappedType.generateTree(symbolTable, dependsOn, shortNames, true, dejaVu));
                }
            } else {
                typeTree = this.wrappedType.generateTree(symbolTable, dependsOn, shortNames, true, dejaVu);
            }
        }
        return typeTree;
    }

    @Override
    public String showType() {
        return this.wrappedType == null ? "UNKNOWN" : this.wrappedType.showType();
    }

    @Override
    public void dump() throws IOException {
        TapEnv.print(this.toString());
    }

    @Override
    public String toString() {
        return (this.typeDeclName() == null ? "" : "\"" + this.typeDeclName() + "\":") + "{" + (this.wrappedType == null ? "?" : this.wrappedType.toString()) + "}";
    }
}

