/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.representation;

import fr.inria.tapenade.analysis.ActivityPattern;
import fr.inria.tapenade.representation.FunctionDecl;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.NewSymbolHolder;
import fr.inria.tapenade.representation.PointerTypeSpec;
import fr.inria.tapenade.representation.SymbolDecl;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.TypeSpec;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.representation.WrapperTypeSpec;
import fr.inria.tapenade.utils.Tree;

public class VariableDecl
extends SymbolDecl {
    private WrapperTypeSpec type;
    public Integer constantValue;
    public int formalArgRank = -2;
    public int formalArgRankInOrigUnit = -1;
    public boolean isReturnVar;
    public FunctionDecl isReturnVarFromFunction;
    public boolean isFunctionName;
    public boolean isVariableName;
    public FunctionDecl[] initFunctionDecls;
    public TapList activityInfo;
    private TapList toZones = new TapList<Object>(null, null);
    private Tree initializationTree;
    private NewSymbolHolder[][] varDiffSymbolHolderRs = null;

    public void setType(WrapperTypeSpec typeSpec) {
        this.type = typeSpec;
    }

    public VariableDecl(Tree identTree, WrapperTypeSpec typeSpec) {
        super(identTree, 1);
        this.type = typeSpec;
    }

    public VariableDecl(Tree identTree, WrapperTypeSpec typeSpec, boolean isATrueSymbolDecl) {
        super(identTree, 1);
        this.type = typeSpec;
        this.isATrueSymbolDecl = isATrueSymbolDecl;
    }

    public VariableDecl() {
    }

    public void setReturnVar() {
        this.formalArgRank = 0;
        this.isReturnVar = true;
    }

    public void setReturnVar(FunctionDecl funcDecl, boolean isFortran) {
        if (!isFortran) {
            this.formalArgRank = 0;
        }
        this.isReturnVar = true;
        this.isReturnVarFromFunction = funcDecl;
    }

    public Tree initializationTree() {
        if (this.initializationTree == null || this.initializationTree.isAtom()) {
            return this.initializationTree;
        }
        return this.initializationTree.down(2);
    }

    public Tree getInitializationTree() {
        return this.initializationTree;
    }

    public void setInitializationTree(Tree tree) {
        this.initializationTree = tree;
    }

    public Tree generateInitializationTree() {
        if (WrapperTypeSpec.isPointerOrArrayOfPointer(this.type) || this.initializationTree.opCode() == 14 && this.initializationTree.down(2).opCode() == 31 && this.initializationTree.down(2).down(1).opCode() == 96 && this.initializationTree.down(2).down(1).stringValue().toLowerCase().equals("null")) {
            Tree resultTree = ILUtils.build(152, this.initializationTree.cutChild(1), this.initializationTree.cutChild(2));
            resultTree.copyAnnotations(this.initializationTree);
            this.initializationTree = resultTree;
        }
        if (this.initializationTree.isAtom()) {
            return ILUtils.build(14, ILUtils.build(96, this.symbol), ILUtils.copy(this.initializationTree));
        }
        if (this.initializationTree.opCode() == 14 || this.initializationTree.opCode() == 152) {
            Tree result = ILUtils.copy(this.initializationTree);
            result.setChild(ILUtils.build(96, this.symbol), 1);
            return result;
        }
        return ILUtils.copy(this.initializationTree);
    }

    @Override
    public boolean isTarget(WrapperTypeSpec modelTypeSpec) {
        if (this.type == null || this.type.wrappedType == null || !this.type.wrappedType.isTarget()) {
            return false;
        }
        if (modelTypeSpec == null || modelTypeSpec.wrappedType == null) {
            return true;
        }
        return modelTypeSpec.canMatchPointerTo(this.type);
    }

    @Override
    public WrapperTypeSpec type() {
        return this.type;
    }

    @Override
    public TapList zones() {
        return this.toZones.tail;
    }

    @Override
    public void setZones(TapList value) {
        this.toZones.tail = value;
    }

    @Override
    public void accumulateZones(TapList intTree) {
        if (intTree != null) {
            this.toZones.tail = TapList.cumulWithOper(this.toZones.tail, intTree, 91);
        }
    }

    @Override
    public int formalArgRankOrResultZero() {
        return this.isReturnVar ? 0 : this.formalArgRank;
    }

    public void adoptZones(VariableDecl model) {
        this.toZones = model.toZones;
    }

    @Override
    protected void recomputeDependsOn(SymbolTable symbolTable) {
        TapList<Object> toDependsOn = new TapList<Object>(null, this.dependsOn);
        if (this.initializationTree != null) {
            VariableDecl.addUsedSymbolsInExpr(this.initializationTree(), toDependsOn, symbolTable, null, false, true);
        }
        if (this.type != null && this.type.wrappedType != null) {
            this.type.wrappedType.addUsedSymbolsInType(toDependsOn, symbolTable);
        }
        this.dependsOn = toDependsOn.tail;
    }

    @Override
    public void collectUsedTrees(TapList<Tree> toUsedTrees, TapList<TypeSpec> toDejaVu) {
        if (this.initializationTree != null) {
            toUsedTrees.tail = new TapList<Tree>(this.initializationTree(), toUsedTrees.tail);
        }
        if (this.type != null && this.type.wrappedType != null) {
            this.type.wrappedType.collectUsedTrees(toUsedTrees, toDejaVu);
        }
    }

    public void setConstant() {
        this.kind = 5;
    }

    public boolean equalsOther(VariableDecl varDecl) {
        boolean result = this.symbol.equals(varDecl.symbol);
        if (result) {
            result = this.kind == varDecl.kind && this.type.equalsCompilDep(varDecl.type);
        }
        return result;
    }

    public void turnTypeIntoPointer() {
        this.type = new WrapperTypeSpec(new PointerTypeSpec(this.type, null));
    }

    public Tree buildVarDeclaration(SymbolTable symbolTable) {
        this.type = this.type.checkNoneDimensionsOfNewSH(this.symbol, this.symbol, ILUtils.build(96, this.symbol), symbolTable, null);
        return ILUtils.build(199, ILUtils.build(130), this.type.wrappedType.generateTree(null, null, null, true, null), ILUtils.build(54, ILUtils.build(96, this.symbol)));
    }

    public boolean cumulActiveField(Tree tree) {
        boolean modified;
        if (this.activityInfo == null) {
            this.activityInfo = new TapList<Object>(null, null);
        }
        TapList<?> toLeaf = TapList.getSetFieldLocation(this.activityInfo, tree, true);
        if (toLeaf.head instanceof Boolean && ((Boolean)toLeaf.head).booleanValue()) {
            modified = false;
        } else {
            if (toLeaf.head instanceof TapList) {
                ((TapList)toLeaf.head).setAll(true);
            } else {
                toLeaf.head = Boolean.TRUE;
            }
            modified = true;
        }
        return modified;
    }

    public boolean passesByValue(Unit refUnit) {
        boolean result = false;
        if (refUnit != null) {
            if (refUnit.isFortran()) {
                result = this.hasModifier("value");
            } else if (refUnit.isC()) {
                result = !this.isReference();
            }
        }
        return result;
    }

    @Override
    public void setDiffSymbolHolder(int diffSort, ActivityPattern pattern, int iReplic, NewSymbolHolder nSH) {
        if (TapEnv.diffReplica() >= 0) {
            if (this.varDiffSymbolHolderRs == null) {
                this.varDiffSymbolHolderRs = new NewSymbolHolder[5][];
                for (int j = 4; j >= 0; --j) {
                    this.varDiffSymbolHolderRs[j] = new NewSymbolHolder[TapEnv.diffReplica()];
                }
            }
            this.varDiffSymbolHolderRs[diffSort][iReplic] = nSH;
        } else {
            super.setDiffSymbolHolder(diffSort, null, 0, nSH);
        }
    }

    @Override
    public NewSymbolHolder getDiffSymbolHolder(int diffSort, ActivityPattern pattern, int iReplic) {
        if (TapEnv.diffReplica() > 0) {
            return this.varDiffSymbolHolderRs == null ? null : this.varDiffSymbolHolderRs[diffSort][iReplic];
        }
        return super.getDiffSymbolHolder(diffSort, null, 0);
    }

    @Override
    public boolean hasDiffSymbolHolders() {
        return this.varDiffSymbolHolderRs != null || super.hasDiffSymbolHolders();
    }

    @Override
    protected void replaceDiffSymbolHolder(NewSymbolHolder oldNSH, NewSymbolHolder newNSH) {
        if (this.varDiffSymbolHolderRs != null) {
            for (int i = this.varDiffSymbolHolderRs.length - 1; i >= 0; --i) {
                for (int iReplic = TapEnv.diffReplica() - 1; iReplic >= 0; --iReplic) {
                    if (this.varDiffSymbolHolderRs[i][iReplic] != oldNSH) continue;
                    this.varDiffSymbolHolderRs[i][iReplic] = newNSH;
                }
            }
        }
        super.replaceDiffSymbolHolder(oldNSH, newNSH);
    }

    @Override
    protected void eraseDiffSymbolHolder(int diffSort) {
        if (this.varDiffSymbolHolderRs != null) {
            // empty if block
        }
        super.eraseDiffSymbolHolder(diffSort);
    }

    @Override
    public String toString() {
        return this.symbol + ": " + (this.type == null ? "null_type" : this.type) + (this.kind() == 5 ? " constant (value:" + this.constantValue + ")." : (this.kind() == 6 ? " return variable." : " variable.")) + " zones:" + this.zones() + (this.importedFrom == null ? "" : " (=>" + this.importedFrom.first + " from @" + Integer.toHexString(((SymbolTable)this.importedFrom.second).hashCode()) + ")") + (!this.isReference() ? "" : " reference") + (!this.isActiveSymbolDecl() ? "" : " active") + (this.initializationTree == null ? "" : " Init:" + this.initializationTree) + (this.extraInfo() == null ? "" : " X" + this.extraInfo()) + (this.accessInfo == null ? "" : " A" + this.accessInfo);
    }
}

