/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.representation;

import fr.inria.tapenade.representation.ArrayDim;
import fr.inria.tapenade.representation.ArrayTypeSpec;
import fr.inria.tapenade.representation.CallGraph;
import fr.inria.tapenade.representation.ClassDecl;
import fr.inria.tapenade.representation.CompositeTypeSpec;
import fr.inria.tapenade.representation.EnumTypeSpec;
import fr.inria.tapenade.representation.FieldDecl;
import fr.inria.tapenade.representation.FunctionTypeSpec;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.Instruction;
import fr.inria.tapenade.representation.MetaTypeSpec;
import fr.inria.tapenade.representation.ModifiedTypeSpec;
import fr.inria.tapenade.representation.NamedTypeSpec;
import fr.inria.tapenade.representation.NewSymbolHolder;
import fr.inria.tapenade.representation.PointerTypeSpec;
import fr.inria.tapenade.representation.PrimitiveTypeSpec;
import fr.inria.tapenade.representation.ReferenceTypeSpec;
import fr.inria.tapenade.representation.SymbolDecl;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.TypeDecl;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.representation.VariableDecl;
import fr.inria.tapenade.representation.VoidTypeSpec;
import fr.inria.tapenade.representation.WrapperTypeSpec;
import fr.inria.tapenade.utils.TapPair;
import fr.inria.tapenade.utils.TapTriplet;
import fr.inria.tapenade.utils.ToBool;
import fr.inria.tapenade.utils.ToObject;
import fr.inria.tapenade.utils.Tree;
import java.io.IOException;

public abstract class TypeSpec {
    public static final String TARGET = "target";
    private static final int BEINGSIZED = -2;
    private static final int UNKNOWNSIZE = -1;
    private static final int ILLEGALTYPESIZE = 1;
    private static final int INFERENCE = 8;
    private static final int VECTORIAL = 16;
    private static final int LOOKDIMLENGTH = 32;
    private static final int RECEIVE = 64;
    private static final int RECVVECTINFRCPDP = 123;
    private static final int RECVooooINFRNOSZ = 108;
    private static final int RECVooooINFRCPDP = 107;
    private static final int RECVooooooooCPDP = 99;
    private static final int RECVVECTNOLNNOSZ = 84;
    private static final int ooooooooooooNOSZ = 36;
    private static final int ooooNOLNooooNOSZ = 20;
    private static final int ooooooooooooCPDP = 35;
    private static final int ooooNOLNooooCPDP = 19;
    private static final int ooooooooooooCPID = 34;
    private static final int ooooooooooooEQEQ = 33;
    protected static int compare_debug_indent;
    private final Tree position = null;
    public NewSymbolHolder diffTypeDeclSymbolHolder;
    public WrapperTypeSpec diffTypeSpec;
    public TypeDecl diffFromTypeDecl;
    private final int kind;
    private int storedSize = -1;
    private TapList<TapPair<Unit, String>> typeDeclNames;
    private String typeDeclName;

    protected TypeSpec(int kind) {
        this.kind = kind;
    }

    public static boolean isDifferentiableType(TypeSpec actualTypeSpec) {
        return TypeSpec.isDifferentiableTypeRec(actualTypeSpec, null);
    }

    private static boolean isDifferentiableTypeRec(TypeSpec actualTypeSpec, TapList<TypeSpec> dejaVu) {
        if (TapList.contains(dejaVu, actualTypeSpec)) {
            return true;
        }
        if (actualTypeSpec == null) {
            return true;
        }
        dejaVu = new TapList<TypeSpec>(actualTypeSpec, dejaVu);
        switch (actualTypeSpec.kind()) {
            case 3: {
                WrapperTypeSpec resultType = ((FunctionTypeSpec)actualTypeSpec).returnType;
                WrapperTypeSpec[] argTypes = ((FunctionTypeSpec)actualTypeSpec).argumentsTypes;
                int i = argTypes == null ? -1 : argTypes.length - 1;
                boolean oneDifferentiableArg = false;
                if (resultType != null && !TypeSpec.isA(resultType, 9)) {
                    oneDifferentiableArg = TypeSpec.isDifferentiableTypeRec(resultType.wrappedType, dejaVu);
                }
                while (!oneDifferentiableArg && i >= 0) {
                    assert (argTypes != null);
                    oneDifferentiableArg = argTypes[i] == null || TypeSpec.isDifferentiableTypeRec(argTypes[i].wrappedType, dejaVu);
                    --i;
                }
                return oneDifferentiableArg;
            }
            case 2: {
                WrapperTypeSpec elementType = actualTypeSpec.elementType();
                return elementType == null || TypeSpec.isDifferentiableTypeRec(elementType.wrappedType, dejaVu);
            }
            case 5: {
                WrapperTypeSpec elementType = actualTypeSpec.elementType();
                return elementType == null || TypeSpec.isDifferentiableTypeRec(elementType.wrappedType, dejaVu);
            }
            case 14: {
                TypeSpec wrappedType = ((WrapperTypeSpec)actualTypeSpec).wrappedType;
                return wrappedType == null || TypeSpec.isDifferentiableTypeRec(wrappedType, dejaVu);
            }
            case 21: {
                CompositeTypeSpec compositeTypeSpec = (CompositeTypeSpec)actualTypeSpec;
                boolean isDifferentiable = false;
                for (int i = compositeTypeSpec.fields.length - 1; !isDifferentiable && i >= 0; --i) {
                    FieldDecl fieldDecl = compositeTypeSpec.fields[i];
                    isDifferentiable = fieldDecl == null || fieldDecl.type() == null || TypeSpec.isDifferentiableTypeRec(fieldDecl.type().wrappedType, dejaVu);
                }
                return isDifferentiable;
            }
            case 6: {
                WrapperTypeSpec destinationType = ((PointerTypeSpec)actualTypeSpec).destinationType;
                return destinationType == null || TypeSpec.isDifferentiableTypeRec(destinationType.wrappedType, dejaVu);
            }
            case 7: {
                String typeName = ((PrimitiveTypeSpec)actualTypeSpec).name();
                return "float".equals(typeName) || "complex".equals(typeName) || TapEnv.diffKind() == 0 && "integer".equals(typeName);
            }
            case 9: 
            case 10: {
                return true;
            }
        }
        return false;
    }

    protected static boolean ignoreTypeDeclName(String typeDeclName) {
        return typeDeclName == null || typeDeclName.startsWith("struct ") || typeDeclName.startsWith("enum ") || typeDeclName.startsWith("union ") || typeDeclName.startsWith("__FILE") || typeDeclName.startsWith("_IO_FILE") || typeDeclName.startsWith("_G");
    }

    public static WrapperTypeSpec build(Tree typeTree, SymbolTable symbolTable, Instruction instruction, TapList<SymbolDecl> toTypeUsedSymbols, TapList<String> toSymbolDeclInfos, TapList<String> toSymbolDeclAccess, ToBool isPointer, WrapperTypeSpec currentBuiltTypeSpec) {
        switch (typeTree.opCode()) {
            case 138: {
                return new WrapperTypeSpec(null);
            }
            case 204: {
                return new WrapperTypeSpec(new VoidTypeSpec());
            }
            case 203: {
                return new WrapperTypeSpec(null);
            }
            case 104: {
                return symbolTable.getCallGraph().globalRootSymbolTable().getTypeDecl((String)"integer").typeSpec;
            }
            case 78: {
                return symbolTable.getCallGraph().globalRootSymbolTable().getTypeDecl((String)"float").typeSpec;
            }
            case 41: {
                return symbolTable.getCallGraph().globalRootSymbolTable().getTypeDecl((String)"complex").typeSpec;
            }
            case 29: {
                return symbolTable.getCallGraph().globalRootSymbolTable().getTypeDecl((String)"boolean").typeSpec;
            }
            case 35: {
                return symbolTable.getCallGraph().globalRootSymbolTable().getTypeDecl((String)"character").typeSpec;
            }
            case 173: {
                SymbolTable scopeST = symbolTable.getPrefixedNamedScope(typeTree.down(1));
                if (scopeST == null) {
                    return new WrapperTypeSpec(null);
                }
                return TypeSpec.build(typeTree.down(2), scopeST, instruction, toTypeUsedSymbols, toSymbolDeclInfos, toSymbolDeclAccess, isPointer, currentBuiltTypeSpec);
            }
            case 96: {
                ClassDecl classDecl;
                String typeName = ILUtils.getIdentString(typeTree);
                TypeDecl typeDecl = symbolTable.getTypeDecl(typeName);
                if (typeDecl == null && (classDecl = symbolTable.getClassDecl(typeName)) != null) {
                    ClassDecl topClassDecl = symbolTable.getTopClassDecl(typeName);
                    if (topClassDecl != null) {
                        toTypeUsedSymbols.placdl(topClassDecl);
                    }
                    return new WrapperTypeSpec(classDecl.unit.classTypeSpec());
                }
                if (typeDecl == null) {
                    typeDecl = new TypeDecl(typeName, new WrapperTypeSpec(new NamedTypeSpec(typeName)));
                    symbolTable.addSymbolDecl(typeDecl);
                }
                return typeDecl.typeSpec;
            }
            case 123: {
                String typeName = ILUtils.getIdentString(typeTree);
                return new WrapperTypeSpec(new MetaTypeSpec(typeName));
            }
            case 161: 
            case 195: {
                WrapperTypeSpec result;
                TapList<Object> fieldList = null;
                boolean isRecord = typeTree.opCode() == 161;
                Tree modifiersTree = isRecord ? typeTree.down(2) : null;
                Tree fieldsTree = typeTree.down(isRecord ? 3 : 2);
                if (ILUtils.isNullOrNone(fieldsTree)) {
                    String typeName = ILUtils.buildTypeName(typeTree);
                    TypeDecl typeDecl = symbolTable.getTypeDecl(typeName);
                    if (typeDecl == null) {
                        typeDecl = symbolTable.getTypeDecl((typeTree.opCode() == 161 ? "struct " : "union ") + typeName);
                    }
                    if ((result = typeDecl != null ? typeDecl.typeSpec : symbolTable.findCompositeTypeSpec(typeName)) == null) {
                        if (TypeSpec.isA(currentBuiltTypeSpec, 21) && typeName.equals(((CompositeTypeSpec)currentBuiltTypeSpec.wrappedType).name)) {
                            result = currentBuiltTypeSpec;
                        } else {
                            result = new WrapperTypeSpec(new CompositeTypeSpec(typeName, new FieldDecl[]{}, isRecord ? 8 : 13, null, TapEnv.relatedUnit()));
                            symbolTable.danglingCircularTypes = new TapList<WrapperTypeSpec>(result, symbolTable.danglingCircularTypes);
                        }
                    }
                } else {
                    int i;
                    Tree[] fieldDecls = fieldsTree.children();
                    FieldDecl[] fieldArray = new FieldDecl[]{};
                    String compositeTypeName = ILUtils.getIdentString(typeTree.down(1));
                    result = new WrapperTypeSpec(new CompositeTypeSpec(compositeTypeName, fieldArray, isRecord ? 8 : 13, modifiersTree, TapEnv.relatedUnit()));
                    for (i = 0; i < fieldDecls.length; ++i) {
                        TapList<Object> toFieldInfos = new TapList<Object>(null, null);
                        TapList<Object> toFieldAccess = new TapList<Object>(null, null);
                        ToBool fieldIsPointer = new ToBool(false);
                        Tree fieldDecl = fieldDecls[i];
                        if (fieldDecl.opCode() == 199) {
                            WrapperTypeSpec fieldTypeSpec = TypeSpec.build(fieldDecl.down(2), symbolTable, instruction, toTypeUsedSymbols, toFieldInfos, toFieldAccess, fieldIsPointer, result);
                            Tree[] declarators = fieldDecl.down(3).children();
                            for (int j = 0; j < declarators.length; ++j) {
                                if (declarators[j].opCode() == 90) continue;
                                FieldDecl fieldSymbolDecl = (FieldDecl)SymbolDecl.build(fieldTypeSpec, toFieldAccess.tail, fieldIsPointer.get(), declarators[j], 2, symbolTable, instruction, toTypeUsedSymbols.tail);
                                if (TapList.containsEquals(toFieldInfos.tail, "private")) {
                                    TapEnv.fileWarning(15, fieldDecl, "(DD18) Tapenade happily ignores private modifier in a composite type");
                                }
                                assert (fieldSymbolDecl != null);
                                fieldSymbolDecl.addExtraInfo(toFieldInfos.tail);
                                fieldList = new TapList<FieldDecl>(fieldSymbolDecl, fieldList);
                                toTypeUsedSymbols.tail = TapList.prependNoDups(fieldSymbolDecl.dependsOn(), toTypeUsedSymbols.tail);
                            }
                            continue;
                        }
                        if (fieldDecl.opCode() != 195 && fieldDecl.opCode() != 161) continue;
                        TypeSpec.build(fieldDecl, symbolTable, instruction, toTypeUsedSymbols, toFieldInfos, toFieldAccess, fieldIsPointer, result);
                    }
                    fieldArray = new FieldDecl[TapList.length(fieldList)];
                    for (i = TapList.length(fieldList) - 1; i >= 0; --i) {
                        assert (fieldList != null);
                        fieldArray[i] = (FieldDecl)fieldList.head;
                        fieldList = fieldList.tail;
                    }
                    ((CompositeTypeSpec)result.wrappedType).fields = fieldArray;
                    ((CompositeTypeSpec)result.wrappedType).initActiveFields();
                }
                typeTree.setAnnotation("WrapperTypeSpec", result);
                return result;
            }
            case 154: {
                ToBool subIsPointer = new ToBool(false);
                TapList<Object> toSubAccess = new TapList<Object>(null, null);
                WrapperTypeSpec resultType = TypeSpec.build(typeTree.down(1), symbolTable, instruction, toTypeUsedSymbols, toSymbolDeclInfos, toSubAccess, subIsPointer, null);
                if (subIsPointer.get()) {
                    resultType = new WrapperTypeSpec(new PointerTypeSpec(resultType, null));
                }
                PointerTypeSpec pointerType = new PointerTypeSpec(resultType, null);
                pointerType.subAccess = toSubAccess.tail;
                return new WrapperTypeSpec(pointerType);
            }
            case 164: {
                TapList<Object> toSubAccess = new TapList<Object>(null, null);
                WrapperTypeSpec resultType = TypeSpec.build(typeTree.down(1), symbolTable, instruction, toTypeUsedSymbols, toSymbolDeclInfos, toSubAccess, new ToBool(false), null);
                ReferenceTypeSpec referenceType = new ReferenceTypeSpec(resultType);
                referenceType.subAccess = toSubAccess.tail;
                return new WrapperTypeSpec(referenceType);
            }
            case 129: {
                WrapperTypeSpec resultType = TypeSpec.build(typeTree.down(2), symbolTable, instruction, toTypeUsedSymbols, toSymbolDeclInfos, toSymbolDeclAccess, isPointer, null);
                Tree[] modifiersTrees = typeTree.down(1).children();
                if (modifiersTrees.length == 1 && ILUtils.isIdent(modifiersTrees[0], "float", true) && !resultType.baseTypeName().equals("complex")) {
                    typeTree.down(1).removeChild(1);
                    modifiersTrees = typeTree.down(1).children();
                }
                TapPair<Object, Object> sizeAndDims = new TapPair<Object, Object>(null, null);
                int typeSign = TypeSpec.dispatchModifiers(modifiersTrees, null, sizeAndDims, isPointer, toSymbolDeclInfos, toSymbolDeclAccess, toTypeUsedSymbols, typeTree, instruction, symbolTable);
                if (sizeAndDims.first != null || typeSign != 0) {
                    ModifiedTypeSpec modifiedType = new ModifiedTypeSpec(resultType, (Tree)sizeAndDims.first, symbolTable);
                    modifiedType.typeSign = typeSign;
                    resultType = new WrapperTypeSpec(modifiedType);
                }
                if (sizeAndDims.second != null) {
                    resultType = new WrapperTypeSpec(new ArrayTypeSpec(resultType, (ArrayDim[])sizeAndDims.second));
                }
                return resultType;
            }
            case 13: {
                WrapperTypeSpec resultType = TypeSpec.build(typeTree.down(1), symbolTable, instruction, toTypeUsedSymbols, toSymbolDeclInfos, toSymbolDeclAccess, isPointer, null);
                ArrayDim[] dimensions = TypeSpec.buildDimsSpec(typeTree.down(2), symbolTable, toTypeUsedSymbols, null);
                if (TapEnv.inputLanguage() == 4) {
                    return new WrapperTypeSpec(new PointerTypeSpec(resultType, dimensions.length > 0 ? dimensions[0] : null));
                }
                return new WrapperTypeSpec(new ArrayTypeSpec(resultType, dimensions));
            }
            case 67: {
                String name = "";
                if (typeTree.down(1).opCode() != 138) {
                    name = typeTree.down(1).stringValue();
                }
                Tree previousIndexEnum = ILUtils.build(103, -1);
                WrapperTypeSpec result = new WrapperTypeSpec(new EnumTypeSpec(name, typeTree.down(2)));
                if (typeTree.down(2).opCode() != 138) {
                    for (int i = 1; i <= typeTree.down(2).children().length; ++i) {
                        Tree oneDeclarator;
                        String declName;
                        if (typeTree.down(2).down(i).opCode() == 14) {
                            declName = ILUtils.baseName(typeTree.down(2).down(i).down(1));
                            previousIndexEnum = ILUtils.copy(typeTree.down(2).down(i).down(2));
                            oneDeclarator = ILUtils.copy(typeTree.down(2).down(i));
                        } else {
                            declName = ILUtils.baseName(typeTree.down(2).down(i));
                            previousIndexEnum = ILUtils.addTree(ILUtils.build(103, 1), ILUtils.copy(previousIndexEnum));
                            oneDeclarator = ILUtils.build(14, ILUtils.copy(typeTree.down(2).down(i)), previousIndexEnum);
                        }
                        Tree decl = ILUtils.build(199, ILUtils.build(130, ILUtils.build(96, "privateEnumElement")), ILUtils.build(138), ILUtils.build(54, oneDeclarator));
                        symbolTable.addVarDeclaration(decl, null, false, null);
                        VariableDecl varDecl = symbolTable.getTopVariableDecl(declName);
                        if (varDecl == null) continue;
                        varDecl.setType(result);
                        varDecl.setConstant();
                        varDecl.isATrueSymbolDecl = !TapEnv.inStdCIncludeFile();
                        varDecl.setInstruction(instruction);
                    }
                } else if (!name.isEmpty()) {
                    TypeDecl typeDecl = symbolTable.getTypeDecl(name);
                    if (typeDecl == null) {
                        typeDecl = symbolTable.getTypeDecl("enum " + name);
                    }
                    if (typeDecl != null) {
                        result = typeDecl.typeSpec;
                    }
                }
                return result;
            }
            case 91: {
                WrapperTypeSpec returnTypeSpec = TypeSpec.build(typeTree.down(1), symbolTable, instruction, toTypeUsedSymbols, toSymbolDeclInfos, new TapList<Object>(null, null), isPointer, null);
                ToBool isVariableArgList = new ToBool(false);
                TapList<WrapperTypeSpec> argList = SymbolDecl.buildTypeSpecFromArgs(symbolTable, instruction, toTypeUsedSymbols, typeTree.down(2).children(), isVariableArgList);
                WrapperTypeSpec[] argsTypeSpecs = new WrapperTypeSpec[TapList.length(argList)];
                for (int i = TapList.length(argList) - 1; i >= 0; --i) {
                    argsTypeSpecs[i] = (WrapperTypeSpec)argList.head;
                    argList = argList.tail;
                }
                return new WrapperTypeSpec(new FunctionTypeSpec(returnTypeSpec, argsTypeSpecs, isVariableArgList.get()));
            }
            case 54: {
                return new WrapperTypeSpec(new MetaTypeSpec("Error"));
            }
        }
        TapEnv.toolWarning(-1, "(TypeSpec.build) Unexpected operator: " + typeTree.opName() + " in " + typeTree);
        return new WrapperTypeSpec(null);
    }

    protected static int dispatchModifiers(Tree[] modifiersTrees, Tree modifiedTree, TapPair<Tree, ArrayDim[]> sizeAndDims, ToBool isPointer, TapList<String> toSymbolDeclInfos, TapList<String> toSymbolDeclAccess, TapList<SymbolDecl> toTypeUsedSymbols, Tree typeTree, Instruction instruction, SymbolTable symbolTable) {
        ArrayDim[] dimensions = null;
        Tree sizeTypeModifier = null;
        int typeSign = 0;
        block6: for (int i = modifiersTrees.length - 1; i >= 0; --i) {
            Tree newModifier;
            Tree modifier = modifiersTrees[i];
            if (modifier != null && modifier.opCode() == 9 && symbolTable.unit != null && symbolTable.unit.fortranStuff() != null && (newModifier = symbolTable.unit.fortranStuff().checkArrayAccessOrCall(symbolTable, modifier)) != null && newModifier != modifier) {
                if (TapEnv.traceTypeCheckAnalysis()) {
                    TapEnv.indentOnTrace(TapEnv.traceIndent());
                    TapEnv.printlnOnTrace("Understand modifier " + modifier + " as function call " + newModifier);
                }
                instruction.replaceTree(modifier, newModifier);
                modifier = newModifier;
            }
            assert (modifier != null);
            switch (modifier.opCode()) {
                case 60: {
                    dimensions = TypeSpec.buildDimsSpec(modifier, symbolTable, toTypeUsedSymbols, modifiedTree);
                    continue block6;
                }
                case 96: {
                    String modifierName = modifier.stringValue();
                    if ("pointer".equals(modifierName)) {
                        isPointer.set(true);
                        continue block6;
                    }
                    if ("allocatable".equals(modifierName)) {
                        isPointer.set(true);
                        toSymbolDeclInfos.placdl(modifierName);
                        continue block6;
                    }
                    if ("short".equals(modifierName)) {
                        sizeTypeModifier = modifier;
                        continue block6;
                    }
                    if ("double".equals(modifierName)) {
                        if (sizeTypeModifier == null) {
                            sizeTypeModifier = modifier;
                            continue block6;
                        }
                        if (!ILUtils.isIdent(sizeTypeModifier, "long", true)) continue block6;
                        sizeTypeModifier = ILUtils.build(96, "long double");
                        continue block6;
                    }
                    if ("long".equals(modifierName)) {
                        if (sizeTypeModifier == null) {
                            sizeTypeModifier = modifier;
                            continue block6;
                        }
                        if (ILUtils.isIdent(sizeTypeModifier, "long", true)) {
                            sizeTypeModifier = ILUtils.build(96, "long long");
                            continue block6;
                        }
                        if (!ILUtils.isIdent(sizeTypeModifier, "double", true)) continue block6;
                        sizeTypeModifier = ILUtils.build(96, "long double");
                        continue block6;
                    }
                    if ("signed".equals(modifierName)) {
                        typeSign = 1;
                        continue block6;
                    }
                    if ("unsigned".equals(modifierName)) {
                        typeSign = 2;
                        continue block6;
                    }
                    if ("const".equals(modifierName) || "__const".equals(modifierName) || "__const__".equals(modifierName) || "restrict".equals(modifierName) || "__restrict".equals(modifierName) || "__restrict__".equals(modifierName)) {
                        toSymbolDeclAccess.placdl(modifierName);
                        continue block6;
                    }
                    if ("constant".equals(modifierName) || "__constant__".equals(modifierName) || "__shared__".equals(modifierName) || "__device__".equals(modifierName) || "__managed__".equals(modifierName) || "volatile".equals(modifierName) || "__volatile".equals(modifierName) || "__volatile__".equals(modifierName) || "save".equals(modifierName) || "auto".equals(modifierName) || "register".equals(modifierName) || "data".equals(modifierName) || "in".equals(modifierName) || "out".equals(modifierName) || "inout".equals(modifierName) || "external".equals(modifierName) || "extern".equals(modifierName) || "intrinsic".equals(modifierName) || "optional".equals(modifierName) || "deferred".equals(modifierName) || "nopass".equals(modifierName) || "pass".equals(modifierName) || TARGET.equals(modifierName) || "value".equals(modifierName) || "static".equals(modifierName) || "inline".equals(modifierName) || "__inline__".equals(modifierName) || "__noinline__".equals(modifierName) || "private".equals(modifierName) || "public".equals(modifierName) || "sequence".equals(modifierName) || "contiguous".equals(modifierName)) {
                        toSymbolDeclInfos.placdl(modifierName);
                        continue block6;
                    }
                    SymbolDecl.addUsedSymbolsInExpr(modifier, toTypeUsedSymbols, symbolTable, null, false, true);
                    if (sizeTypeModifier == null) {
                        sizeTypeModifier = modifier;
                        continue block6;
                    }
                    TapEnv.toolWarning(-1, "** Type modifier analysis: Can't combine type size modifier " + modifierName + " with " + ILUtils.toString(sizeTypeModifier));
                    continue block6;
                }
                case 134: {
                    String name = ILUtils.getIdentString(modifier.down(1));
                    if ("kind".equals(name)) {
                        sizeTypeModifier = modifier;
                        continue block6;
                    }
                    TapEnv.toolWarning(-1, "** Type modifier analysis: Unexpected named modifier: " + modifier + " in " + typeTree);
                    continue block6;
                }
                case 2: {
                    if (!ILUtils.isIdent(modifier.down(1), "bind", true) || symbolTable.unit == null || symbolTable.unit.fortranStuff() == null) continue block6;
                    Tree rebuiltBindDecl = ILUtils.build(2, ILUtils.copy(modifier), ILUtils.copy(instruction.tree.down(3)));
                    symbolTable.unit.fortranStuff().collectFortranCEDSForLater(new Instruction(rebuiltBindDecl), symbolTable);
                    symbolTable.unit.fortranStuff().addBindCDecl(symbolTable, instruction.tree);
                    continue block6;
                }
                default: {
                    sizeTypeModifier = modifier;
                }
            }
        }
        sizeAndDims.first = sizeTypeModifier;
        sizeAndDims.second = dimensions;
        return typeSign;
    }

    private static ArrayDim[] buildDimsSpec(Tree dimsTree, SymbolTable symbolTable, TapList<SymbolDecl> toTypeUsedSymbols, Tree typedTree) {
        Tree[] dimTrees = dimsTree.children();
        Integer lower = null;
        Integer upper = null;
        ArrayDim[] dimensions = new ArrayDim[dimTrees.length];
        String identNext = ILUtils.getIdentString(typedTree);
        for (int i = 0; i < dimTrees.length; ++i) {
            Tree upperDimTree;
            Tree lowerDimTree;
            Tree dimTree = dimTrees[i];
            if (dimTree.opCode() == 59) {
                lowerDimTree = dimTree.down(1);
                upperDimTree = dimTree.down(2);
            } else {
                lowerDimTree = null;
                upperDimTree = dimTree;
            }
            if (lowerDimTree != null && lowerDimTree.opCode() != 138) {
                lower = symbolTable.computeIntConstant(lowerDimTree);
                SymbolDecl.addUsedSymbolsInExpr(lowerDimTree, toTypeUsedSymbols, symbolTable, null, false, true);
            }
            if (upperDimTree != null && upperDimTree.opCode() != 138) {
                upper = symbolTable.computeIntConstant(upperDimTree);
                SymbolDecl.addUsedSymbolsInExpr(upperDimTree, toTypeUsedSymbols, symbolTable, null, false, true);
            }
            dimensions[i] = new ArrayDim(dimTree, lower, upper, identNext == null ? null : typedTree, i + 1, dimTrees.length, 1);
        }
        return dimensions;
    }

    public static WrapperTypeSpec peelSizeModifier(WrapperTypeSpec typeSpec, ToObject<ModifiedTypeSpec> toModifiedType) {
        if (typeSpec == null || typeSpec.wrappedType == null) {
            return typeSpec;
        }
        if (TypeSpec.isA(typeSpec.wrappedType, 2)) {
            return TypeSpec.peelSizeModifier(typeSpec.wrappedType.elementType(), toModifiedType);
        }
        if (TypeSpec.isA(typeSpec.wrappedType, 5)) {
            ModifiedTypeSpec modifiedType = (ModifiedTypeSpec)typeSpec.wrappedType;
            if (toModifiedType != null && modifiedType.sizeModifierValue() != -1) {
                toModifiedType.setObj(modifiedType);
            }
            return TypeSpec.peelSizeModifier(modifiedType.elementType(), toModifiedType);
        }
        return typeSpec;
    }

    protected static TapPair<WrapperTypeSpec, ArrayDim[]> peelArrayDimsAroundComposite(WrapperTypeSpec typeSpec) {
        if (TapEnv.inputLanguage() == 4 || TapEnv.inputLanguage() == 5) {
            return new TapPair<WrapperTypeSpec, Object>(typeSpec, null);
        }
        TapList<Object> collectedDims = null;
        boolean stopHere = false;
        block5: while (!stopHere && typeSpec != null && typeSpec.wrappedType != null) {
            switch (typeSpec.wrappedType.kind()) {
                case 5: {
                    typeSpec = typeSpec.wrappedType.elementType();
                    continue block5;
                }
                case 6: {
                    typeSpec = ((PointerTypeSpec)typeSpec.wrappedType).destinationType;
                    continue block5;
                }
                case 2: {
                    ArrayDim[] oDims = ((ArrayTypeSpec)typeSpec.wrappedType).dimensions();
                    for (int i = oDims.length - 1; i >= 0; --i) {
                        collectedDims = new TapList<ArrayDim>(oDims[i], collectedDims);
                    }
                    typeSpec = typeSpec.wrappedType.elementType();
                    continue block5;
                }
            }
            stopHere = true;
        }
        ArrayDim[] dims = null;
        if (collectedDims != null) {
            int nbDims = TapList.length(collectedDims);
            dims = new ArrayDim[nbDims];
            for (int i = 0; i < nbDims; ++i) {
                dims[i] = (ArrayDim)collectedDims.head;
                collectedDims = collectedDims.tail;
            }
        }
        return new TapPair<WrapperTypeSpec, Object>(typeSpec, dims);
    }

    protected static FunctionTypeSpec findFunctionTypeSpecUnderTypeSpec(WrapperTypeSpec typeSpec) {
        FunctionTypeSpec funcTypeSpec = null;
        if (typeSpec != null && typeSpec.wrappedType != null) {
            switch (typeSpec.wrappedType.kind()) {
                case 5: {
                    funcTypeSpec = TypeSpec.findFunctionTypeSpecUnderTypeSpec(typeSpec.wrappedType.elementType());
                    break;
                }
                case 6: {
                    funcTypeSpec = TypeSpec.findFunctionTypeSpecUnderTypeSpec(((PointerTypeSpec)typeSpec.wrappedType).destinationType);
                    break;
                }
                case 2: {
                    funcTypeSpec = TypeSpec.findFunctionTypeSpecUnderTypeSpec(typeSpec.wrappedType.elementType());
                    break;
                }
                case 3: {
                    funcTypeSpec = (FunctionTypeSpec)typeSpec.wrappedType;
                    break;
                }
            }
        }
        return funcTypeSpec;
    }

    protected static boolean canCompare(WrapperTypeSpec type1, WrapperTypeSpec type2) {
        if (TapEnv.traceTypeCheckAnalysis()) {
            TapEnv.printOnTrace("          ");
            for (int i = compare_debug_indent; i > 0; --i) {
                TapEnv.printOnTrace("| ");
            }
            TapEnv.printlnOnTrace("TS CANCOMPARE? " + type1 + " WITH " + type2);
            ++compare_debug_indent;
        }
        WrapperTypeSpec baseTypeLeft = type1.baseTypeSpec(true);
        WrapperTypeSpec baseTypeRight = type2.baseTypeSpec(true);
        boolean result = false;
        boolean noReturn = false;
        if (baseTypeLeft.wrappedType == null) {
            if (baseTypeRight.wrappedType != null) {
                baseTypeLeft.wrappedType = baseTypeRight.isNumericBase() ? baseTypeRight.wrappedType.cloneAsUndefinedNumeric(true) : baseTypeRight.wrappedType;
            }
            result = true;
        } else if (TypeSpec.isA(baseTypeLeft, 7) && baseTypeLeft.wrappedType.isUndefinedNumeric()) {
            if (baseTypeRight.wrappedType != null && !baseTypeRight.isNumericBase()) {
                result = false;
            } else {
                noReturn = true;
            }
        } else {
            noReturn = true;
        }
        if (noReturn) {
            if (baseTypeRight.wrappedType == null) {
                if (baseTypeLeft.wrappedType != null) {
                    baseTypeRight.wrappedType = baseTypeLeft.isNumericBase() ? baseTypeLeft.wrappedType.cloneAsUndefinedNumeric(true) : baseTypeLeft.wrappedType;
                }
                result = true;
            } else if (TypeSpec.isA(baseTypeRight, 7) && baseTypeRight.wrappedType.isUndefinedNumeric()) {
                if (baseTypeLeft.wrappedType != null && !baseTypeLeft.isNumericBase()) {
                    result = false;
                } else {
                    noReturn = true;
                }
            } else {
                noReturn = true;
            }
        }
        if (noReturn) {
            assert (baseTypeLeft.wrappedType != null);
            boolean bl = result = baseTypeLeft.wrappedType.equalsCompilDep(baseTypeRight.wrappedType) || baseTypeLeft.isNumericBase() && baseTypeRight.isNumericBase();
        }
        if (TapEnv.traceTypeCheckAnalysis()) {
            TapEnv.printOnTrace("          ");
            for (int i = --compare_debug_indent; i > 0; --i) {
                TapEnv.printOnTrace("| ");
            }
            TapEnv.printlnOnTrace(">TS CANCOMPARE " + type1 + " WITH " + type2 + " RETURNS:" + result);
        }
        return result;
    }

    public static String getRenamedTypeDeclName(TapList<TapPair<Unit, String>> typeDeclNames, Unit inUnit) {
        String name = null;
        boolean found = false;
        while (typeDeclNames != null && !found) {
            boolean bl = found = ((TapPair)typeDeclNames.head).first == inUnit;
            if (found) {
                name = (String)((TapPair)typeDeclNames.head).second;
            }
            typeDeclNames = typeDeclNames.tail;
        }
        return name;
    }

    public static boolean isA(TypeSpec type, int kind) {
        while (type instanceof WrapperTypeSpec) {
            type = ((WrapperTypeSpec)type).wrappedType;
        }
        return type != null && type.kind == kind;
    }

    protected static boolean testIsEquals(int comparison) {
        return (comparison & 0x40) == 0;
    }

    protected static boolean testIsReceives(int comparison) {
        return (comparison & 0x40) != 0;
    }

    protected static boolean testLooksDimensionLength(int comparison) {
        return (comparison & 0x20) != 0;
    }

    protected static boolean testAllowsVectorial(int comparison) {
        return (comparison & 0x10) != 0;
    }

    protected static boolean testHasInference(int comparison) {
        return (comparison & 8) != 0;
    }

    protected static boolean testIsReceivesWithInference(int comparison) {
        return (comparison & 0x48) == 72;
    }

    protected static boolean testTypesWithoutSize(int comparison) {
        return comparison % 8 == 4;
    }

    protected static boolean testTypesCompilDep(int comparison) {
        return comparison % 8 == 3;
    }

    private static boolean testTypesCompilIndep(int comparison) {
        return comparison % 8 == 2;
    }

    protected static boolean testTypesLitteral(int comparison) {
        return comparison % 8 == 1;
    }

    protected static boolean testAcceptsUnspecified(int comparison) {
        return TypeSpec.testIsReceives(comparison);
    }

    protected static int testSetEquals(int comparison) {
        return comparison & 0xFFFFFFBF;
    }

    protected static int testUnsetInference(int comparison) {
        return comparison & 0xFFFFFFF7;
    }

    public static String showComparison(int comparison) {
        return (TypeSpec.testIsEquals(comparison) ? "EQ" : "RECV") + (TypeSpec.testAllowsVectorial(comparison) ? "+VECTORIAL" : "") + (TypeSpec.testLooksDimensionLength(comparison) ? "" : "+NODIMLENGTH") + (TypeSpec.testHasInference(comparison) ? "+INFERENCE" : "") + " [" + (TypeSpec.testTypesWithoutSize(comparison) ? "neglect-sizes" : (TypeSpec.testTypesCompilDep(comparison) ? "compil-dep" : (TypeSpec.testTypesCompilIndep(comparison) ? "compil-INdep" : "litt-eq"))) + "]";
    }

    public static Tree generateDeclaratorTree(WrapperTypeSpec stoppingTypeSpec, TapList<SymbolDecl> declaredTypes, Tree declarator, WrapperTypeSpec typeSpec) {
        while (typeSpec != null && !typeSpec.equalsLiterally(stoppingTypeSpec)) {
            TypeSpec actualTypeSpec = typeSpec.wrappedType;
            if (TypeSpec.isA(actualTypeSpec, 2)) {
                ArrayDim[] dimensions;
                if (TapEnv.relatedLanguageIsFortran() && typeSpec.isString()) {
                    dimensions = ((ArrayTypeSpec)actualTypeSpec).dimensions();
                    Tree size = dimensions[0] != null && dimensions[0].tree().down(2).opCode() != 138 ? dimensions[0].tree().down(2).copy() : ILUtils.build(177);
                    declarator = ILUtils.build(175, declarator, size);
                } else {
                    declarator = ILUtils.build(11, declarator, ILUtils.build(60));
                    dimensions = ((ArrayTypeSpec)actualTypeSpec).dimensions();
                    for (int i = 0; i < dimensions.length; ++i) {
                        if (dimensions[i] != null) {
                            declarator.down(2).setChild(dimensions[i].tree().copy(), i + 1);
                            continue;
                        }
                        declarator.down(2).setChild(ILUtils.build(59, ILUtils.build(138), ILUtils.build(138)), i + 1);
                    }
                }
                typeSpec = actualTypeSpec.elementType();
                continue;
            }
            if (TypeSpec.isA(actualTypeSpec, 6)) {
                if (((PointerTypeSpec)actualTypeSpec).offsetLength != null) {
                    typeSpec = typeSpec.pointerToArrayTypeSpec();
                } else {
                    declarator = ILUtils.build(153, declarator);
                    typeSpec = ((PointerTypeSpec)actualTypeSpec).destinationType;
                }
                declarator = TypeSpec.addDeclaratorModifiers(declarator, ((PointerTypeSpec)actualTypeSpec).subAccess);
                continue;
            }
            if (TypeSpec.isA(actualTypeSpec, 3)) {
                declarator = ILUtils.build(90, declarator, ILUtils.build(8));
                WrapperTypeSpec[] argumentsTypes = ((FunctionTypeSpec)actualTypeSpec).argumentsTypes;
                for (int i = 0; i < argumentsTypes.length; ++i) {
                    declarator.down(2).setChild(argumentsTypes[i].generateTree(null, null, declaredTypes, true, null), i + 1);
                }
                TapEnv.toolWarning(-1, "(Regenerate a declarator) Declarator for function not yet implemented");
                typeSpec = ((FunctionTypeSpec)actualTypeSpec).returnType;
                continue;
            }
            if (TypeSpec.isA(actualTypeSpec, 5)) {
                if (TapEnv.relatedLanguageIsFortran()) {
                    typeSpec = null;
                    continue;
                }
                typeSpec = actualTypeSpec.elementType();
                continue;
            }
            typeSpec = null;
        }
        return declarator;
    }

    public static Tree addDeclaratorModifiers(Tree declaratorTree, TapList<String> modifiers) {
        if (modifiers != null) {
            Tree[] modifiersTrees;
            if (declaratorTree != null && declaratorTree.opCode() == 128) {
                modifiersTrees = declaratorTree.down(1).children();
                declaratorTree = declaratorTree.cutChild(2);
            } else {
                modifiersTrees = new Tree[]{};
            }
            Tree[] newModifiersTrees = new Tree[modifiersTrees.length + TapList.length(modifiers)];
            int index = 0;
            while (modifiers != null) {
                newModifiersTrees[index] = ILUtils.build(96, (String)modifiers.head);
                ++index;
                modifiers = modifiers.tail;
            }
            for (Tree modifiersTree : modifiersTrees) {
                newModifiersTrees[index] = ILUtils.copy(modifiersTree);
                ++index;
            }
            declaratorTree = ILUtils.build(128, ILUtils.build(130, newModifiersTrees), declaratorTree);
        }
        return declaratorTree;
    }

    public static Tree addTypeModifiers(Tree typeTree, TapList<Tree> modifiers) {
        if (modifiers != null) {
            Tree[] modifiersTrees;
            if (typeTree != null && typeTree.opCode() == 129) {
                modifiersTrees = typeTree.down(1).children();
                typeTree = typeTree.cutChild(2);
            } else {
                modifiersTrees = new Tree[]{};
            }
            Tree[] newModifiersTrees = new Tree[modifiersTrees.length + TapList.length(modifiers)];
            int index = 0;
            while (modifiers != null) {
                newModifiersTrees[index] = (Tree)modifiers.head;
                ++index;
                modifiers = modifiers.tail;
            }
            for (Tree modifiersTree : modifiersTrees) {
                newModifiersTrees[index] = ILUtils.copy(modifiersTree);
                ++index;
            }
            typeTree = ILUtils.build(129, ILUtils.build(130, newModifiersTrees), typeTree);
        }
        return typeTree;
    }

    public TapList<TapPair<Unit, String>> typeDeclNames() {
        return this.typeDeclNames;
    }

    public void setTypeDeclNames(TapList<TapPair<Unit, String>> tDeclNames) {
        this.typeDeclNames = tDeclNames;
    }

    public void addInTypeDeclNames(Unit unit, String name) {
        this.typeDeclNames = new TapList<TapPair<Unit, String>>(new TapPair<Unit, String>(unit, name), this.typeDeclNames);
    }

    protected String genTypeDeclName() {
        String result = null;
        TapList<TapPair<Unit, String>> otherNames = this.typeDeclNames;
        if (!TypeSpec.ignoreTypeDeclName(this.typeDeclName)) {
            result = this.typeDeclName;
        }
        while (otherNames != null && result == null) {
            TapPair otherName = (TapPair)otherNames.head;
            if (otherName.first == null && !TypeSpec.ignoreTypeDeclName((String)otherName.second)) {
                result = (String)otherName.second;
            }
            otherNames = otherNames.tail;
        }
        if (result == null) {
            result = this.typeDeclName;
        }
        return result;
    }

    public String typeDeclName() {
        return this.genTypeDeclName();
    }

    protected void setTypeDeclName(String name) {
        this.typeDeclName = name;
    }

    protected void setOrAddTypeDeclName(String name) {
        if (this.typeDeclName == null) {
            this.typeDeclName = name;
        }
        if (!TapList.containsEqualsObjectPair(this.typeDeclNames, null, name)) {
            this.typeDeclNames = new TapList<TapPair<Unit, String>>(new TapPair<Object, String>(null, name), this.typeDeclNames);
        }
    }

    public int kind() {
        return this.kind;
    }

    protected TypeSpec findAlreadyCopiedType(TapList<TapTriplet<TypeSpec, TypeSpec, Boolean>> toAlreadyCopied, ToBool containsMeta) {
        toAlreadyCopied = toAlreadyCopied.tail;
        while (!(toAlreadyCopied == null || ((TapTriplet)toAlreadyCopied.head).first != null && this.kind == ((TypeSpec)((TapTriplet)toAlreadyCopied.head).first).kind && this.equalsLiterally((TypeSpec)((TapTriplet)toAlreadyCopied.head).first))) {
            toAlreadyCopied = toAlreadyCopied.tail;
        }
        if (toAlreadyCopied != null && Boolean.TRUE.equals(((TapTriplet)toAlreadyCopied.head).third)) {
            containsMeta.set(true);
        }
        return toAlreadyCopied == null ? null : (TypeSpec)((TapTriplet)toAlreadyCopied.head).second;
    }

    protected TypeSpec combineWith(TypeSpec newActualTypeSpec, SymbolTable symbolTable) {
        TypeSpec result = null;
        if (TypeSpec.isA(this, 9)) {
            if (TypeSpec.isA(newActualTypeSpec, 9)) {
                result = this;
            }
        } else if (TypeSpec.isA(this, 2)) {
            if (TypeSpec.isA(newActualTypeSpec, 2)) {
                if (this.isIncompleteType()) {
                    ArrayDim[] dimNew;
                    ArrayDim[] dimThis = ((ArrayTypeSpec)this).dimensions();
                    if (dimThis.length == (dimNew = ((ArrayTypeSpec)newActualTypeSpec).dimensions()).length) {
                        for (int i = dimThis.length - 1; i >= 0; --i) {
                            if (dimThis[i].tree() != null && dimThis[i].tree().down(1).opCode() != 138) continue;
                            dimThis[i].setTree(dimNew[i].tree());
                            dimThis[i].lower = dimNew[i].lower;
                            dimThis[i].upper = dimNew[i].upper;
                        }
                        result = this;
                    }
                } else if (TapEnv.inputLanguage() != 4) {
                    if (this.baseTypeName().equals("character")) {
                        if (TypeSpec.isA(this.elementType().wrappedType, 2) || TypeSpec.isA(newActualTypeSpec.elementType().wrappedType, 2)) {
                            TapEnv.fileWarning(15, -2, "(DD02) Cannot combine successive declarations of character array: " + this.showType() + " and " + newActualTypeSpec.showType() + " (ignored new)");
                            result = null;
                        } else {
                            result = ((ArrayTypeSpec)newActualTypeSpec).combineArrayWith(this);
                        }
                    } else if (newActualTypeSpec.baseTypeName().equals("character")) {
                        if (TypeSpec.isA(this.elementType().wrappedType, 2) || TypeSpec.isA(newActualTypeSpec.elementType().wrappedType, 2)) {
                            TapEnv.fileWarning(15, -2, "(DD02) Cannot combine successive declarations of character array: " + this.showType() + " and " + newActualTypeSpec.showType() + " (ignored new)");
                            result = null;
                        } else {
                            result = ((ArrayTypeSpec)this).combineArrayWith(newActualTypeSpec);
                        }
                    } else {
                        result = this;
                    }
                } else {
                    result = this;
                }
            } else {
                result = ((ArrayTypeSpec)this).combineArrayWith(newActualTypeSpec);
            }
        } else if (TypeSpec.isA(newActualTypeSpec, 2)) {
            result = ((ArrayTypeSpec)newActualTypeSpec).combineArrayWith(this);
        } else if (TypeSpec.isA(this, 7)) {
            if (TypeSpec.isA(newActualTypeSpec, 7) && newActualTypeSpec.equalsCompilIndep(this)) {
                result = this.isUndefinedNumeric() && !newActualTypeSpec.isUndefinedNumeric() ? newActualTypeSpec : this;
            }
        } else if (TypeSpec.isA(this, 5)) {
            if (TypeSpec.isA(newActualTypeSpec, 5)) {
                WrapperTypeSpec newElementType;
                ModifiedTypeSpec thisModified = (ModifiedTypeSpec)this;
                ModifiedTypeSpec newModified = (ModifiedTypeSpec)newActualTypeSpec;
                if (thisModified.sizeModifierValue() == newModified.sizeModifierValue() && (newElementType = thisModified.elementType().combineWith(newModified.elementType(), symbolTable)) != null) {
                    result = new ModifiedTypeSpec(newElementType, thisModified);
                }
            }
        } else if (TypeSpec.isA(this, 21)) {
            if (TypeSpec.isA(newActualTypeSpec, 21) && newActualTypeSpec.equalsCompilIndep(this)) {
                result = this;
            }
        } else if (TypeSpec.isA(this, 6)) {
            if (TypeSpec.isA(newActualTypeSpec, 6) && TypeSpec.isA(((PointerTypeSpec)newActualTypeSpec).destinationType, 2)) {
                WrapperTypeSpec thisDestTypeSpec = ((PointerTypeSpec)this).destinationType;
                WrapperTypeSpec arrayTypeSpec = ((PointerTypeSpec)newActualTypeSpec).destinationType;
                ((ArrayTypeSpec)arrayTypeSpec.wrappedType).setElementType(thisDestTypeSpec);
                ((PointerTypeSpec)this).destinationType = ((PointerTypeSpec)newActualTypeSpec).destinationType;
                result = this;
            } else {
                if (((PointerTypeSpec)this).destinationType.wrappedType == null) {
                    ((PointerTypeSpec)this).destinationType.wrappedType = newActualTypeSpec;
                }
                result = this;
            }
        }
        return result;
    }

    private boolean isIncompleteType() {
        boolean result = false;
        if (TypeSpec.isA(this, 2)) {
            ArrayDim[] dimThis = ((ArrayTypeSpec)this).dimensions();
            for (int i = 0; !result && i < dimThis.length; ++i) {
                result = dimThis[i].tree() == null || dimThis[i].tree().down(1).opCode() == 138;
            }
        }
        return result;
    }

    protected boolean isUndefinedNumeric() {
        return false;
    }

    protected void setUndefinedNumeric(boolean value) {
    }

    private TapList<SymbolDecl> getDependsOnSymbolDeclAndModulesDef(TapList<Tree> usedTrees, SymbolTable symbolTable, TapList<Unit> definedInModule) {
        TapList<Object> result;
        TapList<Object> toResult = result = new TapList<Object>(null, null);
        TapList<Unit> toDefinedInModule = definedInModule;
        while (usedTrees != null) {
            Tree tree = (Tree)usedTrees.head;
            String name = ILUtils.baseName(tree);
            SymbolDecl symbolDecl = null;
            Unit module = null;
            for (SymbolTable curST = symbolTable; symbolDecl == null && curST != null; curST = curST.basisSymbolTable()) {
                if (name == null || (symbolDecl = curST.getTopDecl(name, 0)) == null || !curST.isImports || symbolDecl.importedFrom == null) continue;
                module = ((SymbolTable)symbolDecl.importedFrom.second).unit;
            }
            if (symbolDecl != null) {
                if (module != null) {
                    toDefinedInModule = toDefinedInModule.placdl(module);
                }
                toResult = toResult.placdl(symbolDecl);
            }
            usedTrees = usedTrees.tail;
        }
        return result.tail;
    }

    protected void createOrGetDiffTypeDeclSymbolHolder(SymbolTable diffSymbolTable, WrapperTypeSpec diffTypeSpec, String fSuffix) {
        NewSymbolHolder diffSH = diffTypeSpec.wrappedType.diffTypeDeclSymbolHolder;
        SymbolTable basisSymbolTable = diffSymbolTable.findAssocAddresTypeDeclSymbolTable();
        TapList<Object> modules = new TapList<Object>(null, null);
        if (diffSH == null) {
            String origTypeName = this.baseTypeName();
            if ("float".equals(origTypeName) && TapEnv.relatedLanguageIsFortran()) {
                origTypeName = "real";
            }
            int size = this.size();
            origTypeName = origTypeName + size;
            diffSH = new NewSymbolHolder(TapEnv.extendStringWithSuffix(origTypeName, fSuffix));
            TapList<Object> toUsedTrees = new TapList<Object>(null, null);
            TapList<Object> dejaVu = new TapList<Object>(null, null);
            diffTypeSpec.wrappedType.collectUsedTrees(toUsedTrees, dejaVu);
            TapList<SymbolDecl> dependsOn = diffTypeSpec.wrappedType.getDependsOnSymbolDeclAndModulesDef(toUsedTrees.tail, diffSymbolTable, modules);
            diffSH.setAsType(diffTypeSpec, dependsOn);
        }
        this.referencesDiffSHType(basisSymbolTable, diffTypeSpec, diffSH, basisSymbolTable, modules.tail, fSuffix);
    }

    private void referencesDiffSHType(SymbolTable diffSymbolTable, WrapperTypeSpec diffTypeSpec, NewSymbolHolder diffSH, SymbolTable basisSymbolTable, TapList<Unit> usedModules, String fSuffix) {
        int lang = 4;
        if (diffSymbolTable != null && diffSymbolTable.unit != null) {
            lang = diffSymbolTable.unit.language();
        }
        if (TapEnv.assocAddressDiffTypesUnit(lang) != null) {
            SymbolTable basisDiffSymbolTable;
            diffSH.addTypeDeclSymbolTable(TapEnv.assocAddressDiffTypesUnit(lang).publicSymbolTable());
            for (basisDiffSymbolTable = diffSymbolTable; basisDiffSymbolTable != null && !basisDiffSymbolTable.isFormalParamsLevel(); basisDiffSymbolTable = basisDiffSymbolTable.basisSymbolTable()) {
            }
            while (basisDiffSymbolTable != null && basisDiffSymbolTable.origUnit() != null && !basisDiffSymbolTable.origUnit().isTopInFile()) {
                basisDiffSymbolTable = basisDiffSymbolTable.basisSymbolTable();
                while (basisDiffSymbolTable.basisSymbolTable() != null && !basisDiffSymbolTable.isFormalParamsLevel()) {
                    basisDiffSymbolTable = basisDiffSymbolTable.basisSymbolTable();
                }
            }
            while (usedModules != null) {
                Unit module = (Unit)usedModules.head;
                assert (module.publicSymbolTable().origUnit() != null);
                Tree useDeclTree = ILUtils.build(197, ILUtils.build(96, module.publicSymbolTable().origUnit().name() + (TapEnv.get().stripPrimalModules ? "" : fSuffix)), ILUtils.build(166));
                Instruction useInstr = new Instruction(useDeclTree);
                useInstr.isDifferentiated = true;
                TapEnv.assocAddressDiffTypesUnit((int)3).publicSymbolTable().declarationsBlock.addInstrHdIfNotPresent(useInstr);
                CallGraph.addCallArrow(TapEnv.assocAddressDiffTypesUnit(3), 2, module);
                usedModules = usedModules.tail;
            }
        }
        if (basisSymbolTable != null && diffSH != null) {
            diffSH.addTypeDeclSymbolTable(basisSymbolTable);
            diffSH.makeNewRef(basisSymbolTable);
            diffSH.solvingLevelMustInclude(basisSymbolTable);
            diffSH.declarationLevelMustInclude(basisSymbolTable);
        }
        diffTypeSpec.wrappedType.diffTypeDeclSymbolHolder = diffSH;
    }

    public String getRenamedTypeDeclName(Unit inUnit) {
        return TypeSpec.getRenamedTypeDeclName(this.typeDeclNames, inUnit);
    }

    public boolean isScalar() {
        TypeSpec typeSpec = this;
        while (TypeSpec.isA(typeSpec, 5)) {
            typeSpec = typeSpec.elementType();
        }
        return TypeSpec.isA(typeSpec, 7);
    }

    public boolean isBooleanBase() {
        return this.baseTypeName().equals("boolean");
    }

    public boolean isNumericBase() {
        String baseName = this.baseTypeName();
        return baseName != null && ("integer".equals(baseName) || "float".equals(baseName) || "complex".equals(baseName) || TapEnv.relatedLanguageIsC() && TypeSpec.isA(this, 12) || TapEnv.relatedLanguageIsC() && "char".equals(baseName) || TapEnv.relatedLanguageIsC() && "boolean".equals(baseName));
    }

    public boolean isIntegerBase() {
        WrapperTypeSpec baseTypeSpec = this.baseTypeSpec(true);
        TypeSpec actualTypeSpec = baseTypeSpec == null ? null : baseTypeSpec.wrappedType;
        return actualTypeSpec != null && (TypeSpec.isA(actualTypeSpec, 7) && ((PrimitiveTypeSpec)actualTypeSpec).isInteger() || TypeSpec.isA(actualTypeSpec, 12) && TapEnv.relatedLanguageIsC());
    }

    public boolean isRealBase() {
        WrapperTypeSpec baseTypeSpec = this.baseTypeSpec(true);
        TypeSpec actualTypeSpec = baseTypeSpec == null ? null : baseTypeSpec.wrappedType;
        return TypeSpec.isA(actualTypeSpec, 7) && ((PrimitiveTypeSpec)actualTypeSpec).isReal();
    }

    public boolean isComplexBase() {
        WrapperTypeSpec baseTypeSpec = this.baseTypeSpec(true);
        TypeSpec actualTypeSpec = baseTypeSpec == null ? null : baseTypeSpec.wrappedType;
        return TypeSpec.isA(actualTypeSpec, 7) && ((PrimitiveTypeSpec)actualTypeSpec).isComplex();
    }

    public boolean isRealOrComplexBase() {
        WrapperTypeSpec baseTypeSpec = this.baseTypeSpec(true);
        TypeSpec actualTypeSpec = baseTypeSpec == null ? null : baseTypeSpec.wrappedType;
        return TypeSpec.isA(actualTypeSpec, 7) && ((PrimitiveTypeSpec)actualTypeSpec).isRealOrComplex();
    }

    boolean isProbablyRealOrComplexBase() {
        WrapperTypeSpec baseTypeSpec = this.baseTypeSpec(true);
        TypeSpec actualTypeSpec = baseTypeSpec == null ? null : baseTypeSpec.wrappedType;
        return TypeSpec.isA(actualTypeSpec, 7) && ((PrimitiveTypeSpec)actualTypeSpec).isProbablyRealOrComplex();
    }

    public boolean isAugmentedDoubleBase() {
        WrapperTypeSpec baseTypeSpec = this.baseTypeSpec(true);
        TypeSpec actualTypeSpec = baseTypeSpec == null ? null : baseTypeSpec.wrappedType;
        return TypeSpec.isA(actualTypeSpec, 7) && ((PrimitiveTypeSpec)actualTypeSpec).isAugmentedDouble();
    }

    public boolean isDifferentiablePlainType() {
        TypeSpec peeledType = this.peelWrapperAndModified(this);
        return TypeSpec.isA(peeledType, 7) && peeledType.isDifferentiated(null);
    }

    protected TypeSpec peelWrapperAndModified(TypeSpec typeSpec) {
        boolean peeling = true;
        while (peeling) {
            if (typeSpec == null) {
                peeling = false;
                continue;
            }
            if (typeSpec instanceof WrapperTypeSpec) {
                typeSpec = ((WrapperTypeSpec)typeSpec).wrappedType;
                peeling = true;
                continue;
            }
            if (typeSpec instanceof ModifiedTypeSpec) {
                typeSpec = typeSpec.elementType();
                peeling = true;
                continue;
            }
            peeling = false;
        }
        return typeSpec;
    }

    protected TypeSpec peelWrapperAndModifiedTo(TypeSpec type, TypeSpec toType) {
        boolean peeling = true;
        while (peeling) {
            if (type == null) {
                peeling = false;
                continue;
            }
            if (type instanceof WrapperTypeSpec) {
                toType = type;
                type = ((WrapperTypeSpec)type).wrappedType;
                peeling = true;
                continue;
            }
            if (type instanceof ModifiedTypeSpec) {
                toType = type;
                type = type.elementType();
                peeling = true;
                continue;
            }
            peeling = false;
        }
        return toType;
    }

    protected TypeSpec peelWrapperTo(TypeSpec type, TypeSpec toType) {
        while (type instanceof WrapperTypeSpec) {
            toType = type;
            type = ((WrapperTypeSpec)type).wrappedType;
        }
        return toType;
    }

    public TypeSpec peelDimensionsTo(TypeSpec type, TypeSpec toType, TapList<ArrayDim> toDimensions) {
        boolean peeling = true;
        while (peeling) {
            if (type == null) {
                peeling = false;
                continue;
            }
            if (type instanceof ArrayTypeSpec) {
                ArrayDim[] dims;
                for (ArrayDim dim : dims = ((ArrayTypeSpec)type).dimensions()) {
                    toDimensions = toDimensions.placdl(dim);
                }
                toType = type;
                type = type.elementType();
                peeling = true;
                continue;
            }
            if (type instanceof WrapperTypeSpec) {
                toType = type;
                type = ((WrapperTypeSpec)type).wrappedType;
                peeling = true;
                continue;
            }
            if (type instanceof ModifiedTypeSpec && type.containsArray()) {
                toType = type;
                type = type.elementType();
                peeling = true;
                continue;
            }
            peeling = false;
        }
        return toType;
    }

    public boolean containsArray() {
        if (this instanceof ArrayTypeSpec) {
            return true;
        }
        if (this instanceof PointerTypeSpec || this instanceof ReferenceTypeSpec || this instanceof FunctionTypeSpec) {
            return false;
        }
        TypeSpec inside = this.wrappedType();
        return inside != null && inside.containsArray();
    }

    protected TypeSpec peelSizeModifiersTo(TypeSpec type, TypeSpec toType, ToObject<Tree> toModifierTree, ToObject<ModifiedTypeSpec> toModifiedTypeSpec, boolean remainLitteral) {
        boolean peeling = true;
        while (peeling) {
            if (type == null) {
                peeling = false;
                continue;
            }
            if (type instanceof WrapperTypeSpec) {
                toType = type;
                type = ((WrapperTypeSpec)type).wrappedType;
                peeling = true;
                continue;
            }
            if (type instanceof ModifiedTypeSpec) {
                if (toModifiedTypeSpec != null) {
                    toModifiedTypeSpec.setObj((ModifiedTypeSpec)type);
                }
                if (!type.hasUndefinedSize()) {
                    Tree sizeModifierTree;
                    Tree tree = sizeModifierTree = remainLitteral ? ((ModifiedTypeSpec)type).sizeModifier : ((ModifiedTypeSpec)type).sizeModifierResolved;
                    if (sizeModifierTree != null) {
                        toModifierTree.setObj(sizeModifierTree);
                    }
                }
                toType = type;
                type = type.elementType();
                peeling = true;
                continue;
            }
            peeling = false;
        }
        return toType;
    }

    public TypeSpec wrappedType() {
        return null;
    }

    public void setWrappedType(TypeSpec type) {
    }

    protected boolean isAnIOTypeSpec(SymbolTable symbolTable) {
        return false;
    }

    protected TypeSpec cloneAsUndefinedNumeric(boolean undefined) {
        return null;
    }

    public TypeSpec nestedLevelType() {
        return null;
    }

    protected TypeSpec peelPointer() {
        return this;
    }

    protected abstract String baseTypeName();

    public WrapperTypeSpec baseTypeSpec(boolean stopOnPointer) {
        return null;
    }

    public WrapperTypeSpec modifiedBaseTypeSpec() {
        return null;
    }

    public boolean containsAPointer() {
        return false;
    }

    public TapList<ArrayDim> getAllDimensions() {
        return null;
    }

    public boolean containsUnknownDimension() {
        return false;
    }

    public WrapperTypeSpec elementType() {
        return null;
    }

    public void updateAfterImports(SymbolTable symbolTable, TapList<TypeSpec> dejaVu) {
        this.storedSize = -1;
        if (!TapList.contains(dejaVu, this)) {
            this.doUpdateAfterImports(symbolTable, new TapList<TypeSpec>(this, dejaVu));
        }
    }

    protected void doUpdateAfterImports(SymbolTable symbolTable, TapList<TypeSpec> dejaVu) {
    }

    public int size() {
        if (this.storedSize == -2) {
            TapEnv.fileWarning(15, this.position, "(TC46) Illegal recursive type definition");
            this.storedSize = 1;
        } else if (this.storedSize == -1) {
            this.storedSize = -2;
            this.storedSize = this.computeSize();
        }
        return this.storedSize;
    }

    protected int computeSize() {
        return 1;
    }

    public boolean isFunction() {
        return false;
    }

    public boolean isCharacter() {
        return false;
    }

    public boolean isString() {
        return false;
    }

    public boolean isPointer() {
        return false;
    }

    public boolean isTarget() {
        return false;
    }

    public boolean isArray() {
        return false;
    }

    public boolean isNamedType() {
        return false;
    }

    public void addUsedSymbolsInType(TapList<SymbolDecl> dependsOn, SymbolTable symbolTable) {
    }

    public void collectUsedTrees(TapList<Tree> toUsedTrees, TapList<TypeSpec> toDejaVu) {
    }

    public boolean receives(TypeSpec other, TypeSpec toThis, TypeSpec toOther) {
        return this.comparesWith(other, 123, toThis, toOther, null);
    }

    public boolean receivesVectorNeglectSizes(TypeSpec other) {
        return this.comparesWith(other, 84, null, null, null);
    }

    public boolean receivesNoVector(TypeSpec other, TypeSpec toThis, TypeSpec toOther) {
        return this.comparesWith(other, 107, toThis, toOther, null);
    }

    public boolean receivesNoVectorNeglectSizes(TypeSpec other, TypeSpec toThis, TypeSpec toOther) {
        return this.comparesWith(other, 108, toThis, toOther, null);
    }

    public boolean receivesNoInferenceNoVector(TypeSpec other) {
        return this.comparesWith(other, 99, null, null, null);
    }

    public boolean equalsNeglectSizesNeglectLengthes(TypeSpec other) {
        return this.comparesWith(other, 20, null, null, null);
    }

    public boolean equalsCompilDepNeglectLengthes(TypeSpec other) {
        return this.comparesWith(other, 19, null, null, null);
    }

    public boolean equalsNeglectSizes(TypeSpec other) {
        return this.comparesWith(other, 36, null, null, null);
    }

    public boolean equalsCompilDep(TypeSpec other) {
        return this.comparesWith(other, 35, null, null, null);
    }

    public boolean equalsCompilIndep(TypeSpec other) {
        return this.comparesWith(other, 34, null, null, null);
    }

    public boolean equalsLiterally(TypeSpec other) {
        return this.comparesWith(other, 33, null, null, null);
    }

    public boolean comparesWith(TypeSpec other, int comparison, TypeSpec toThis, TypeSpec toOther, TapList<TapPair<TypeSpec, TypeSpec>> dejaVu) {
        if (TapEnv.traceTypeCheckAnalysis()) {
            TapEnv.indentOnTrace(TapEnv.traceIndent());
            for (int i = compare_debug_indent; i > 0; --i) {
                TapEnv.printOnTrace("| ");
            }
            TapEnv.printlnOnTrace("Comparing types " + this + " " + TypeSpec.showComparison(comparison) + " " + other);
            ++compare_debug_indent;
        }
        boolean result = this.testComparesWith(other, comparison, toThis, toOther, dejaVu);
        if (TapEnv.traceTypeCheckAnalysis()) {
            TapEnv.indentOnTrace(TapEnv.traceIndent());
            for (int i = --compare_debug_indent; i > 0; --i) {
                TapEnv.printOnTrace("| ");
            }
            TapEnv.printlnOnTrace(">Compared types " + this + " " + TypeSpec.showComparison(comparison) + " " + other + " RETURNS:" + result);
        }
        return result;
    }

    protected abstract boolean testComparesWith(TypeSpec var1, int var2, TypeSpec var3, TypeSpec var4, TapList<TapPair<TypeSpec, TypeSpec>> var5);

    protected TypeSpec weakenForInference(int comparison) {
        return this;
    }

    protected void shareActiveFields(TypeSpec referenceType) {
        WrapperTypeSpec referenceTypeBasis = referenceType.baseTypeSpec(false);
        WrapperTypeSpec thisTypeBasis = this.baseTypeSpec(false);
        if (TypeSpec.isA(referenceTypeBasis, 21) && TypeSpec.isA(thisTypeBasis, 21)) {
            ((CompositeTypeSpec)thisTypeBasis.wrappedType).shareActiveFields((CompositeTypeSpec)referenceTypeBasis.wrappedType);
        }
    }

    public TypeSpec copy() {
        return null;
    }

    public abstract TypeSpec copyStopOnComposite(Unit var1);

    public int precisionSize() {
        return -1;
    }

    public Tree buildConstantZero() {
        return null;
    }

    public Tree buildConstantOne() {
        return null;
    }

    protected boolean containsMetaType(TapList<TypeSpec> dejaVu) {
        return false;
    }

    protected TypeSpec localize(TapList<TapTriplet<TypeSpec, TypeSpec, Boolean>> toAlreadyCopied, ToBool containsMeta) {
        return this;
    }

    protected TypeSpec preciseDimensions(TypeSpec complementType, TapList<TapPair<TypeSpec, TypeSpec>> dejaVu, SymbolTable symbolTable) {
        return this;
    }

    protected boolean hasUndefinedSize() {
        return false;
    }

    protected void setHasUndefinedSize(boolean val) {
    }

    public boolean containsUndefinedType() {
        return false;
    }

    protected TypeSpec addOneDimension(ArrayDim dimension) {
        ArrayDim[] dimensions = new ArrayDim[]{dimension};
        return new ArrayTypeSpec(new WrapperTypeSpec(this), dimensions);
    }

    public TypeSpec intToReal(TapList<TapPair<TypeSpec, TypeSpec>> dejaVu, SymbolTable symbolTable) {
        return this;
    }

    protected TypeSpec realToComplex(TapList<TapPair<TypeSpec, TypeSpec>> dejaVu, WrapperTypeSpec complexTypeSpec) {
        return this;
    }

    public WrapperTypeSpec differentiateTypeSpec(SymbolTable symbolTable, SymbolTable srcSymbolTable, int diffUnitSort, String fSuffix, boolean localDecl, boolean multiDirMode, ArrayDim multiDirDimensionMax, String hintArrayNameInText, String hintArrayNameInIdent, Tree hintArrayNameTree, Tree nameTree) {
        return null;
    }

    protected void addDiffTypeSpec(SymbolTable symbolTable, SymbolTable srcSymbolTable) {
        if (TapEnv.associationByAddress() && !TapEnv.get().complexStep && symbolTable != null && this.isScalar()) {
            NewSymbolHolder diffSH = this.diffTypeSpec.wrappedType.diffTypeDeclSymbolHolder;
            SymbolTable basisSymbolTable = symbolTable.findAssocAddresTypeDeclSymbolTable();
            this.referencesDiffSHType(symbolTable, this.diffTypeSpec, diffSH, basisSymbolTable, null, null);
        }
    }

    protected void cumulActiveParts(TapList diffInfos, SymbolTable symbolTable) {
    }

    public boolean needsADiffType(TapList<TypeSpec> dejaVu) {
        return false;
    }

    public boolean isDifferentiated(TapList<TypeSpec> dejaVu) {
        return false;
    }

    protected boolean checkTypeSpecValidity(TapList<TypeSpec> dejaVu) {
        return true;
    }

    protected String findShortName(TapList<SymbolDecl> dependsOn, TapList<SymbolDecl> shortNames) {
        TypeDecl dependsOnTypeDecl = TypeDecl.findTypeDecl(dependsOn);
        String dependsOnTypeName = dependsOnTypeDecl == null ? null : dependsOnTypeDecl.symbol;
        TapList<String> foundShortNames = null;
        while (shortNames != null) {
            TypeDecl typeDecl = (TypeDecl)shortNames.head;
            if (typeDecl.isATrueSymbolDecl && typeDecl.typeSpec.wrappedType == this && (dependsOnTypeName == null || typeDecl.symbol.equals(dependsOnTypeName) || dependsOnTypeDecl.typeSpec.wrappedType.diffTypeSpec == this)) {
                foundShortNames = new TapList<String>(typeDecl.symbol, foundShortNames);
            }
            shortNames = shortNames.tail;
        }
        String shortName = null;
        String notSoShortShortName = null;
        while (foundShortNames != null && shortName == null) {
            shortName = (String)foundShortNames.head;
            if (shortName.startsWith("struct ") || shortName.startsWith("union ") || shortName.startsWith("enum ")) {
                notSoShortShortName = shortName;
                shortName = null;
            }
            foundShortNames = foundShortNames.tail;
        }
        return shortName != null ? shortName : notSoShortShortName;
    }

    public Tree generateTree(SymbolTable symbolTable, TapList<SymbolDecl> dependsOn, TapList<SymbolDecl> shortNames, boolean useShortNames, TapList<TypeSpec> dejaVu) {
        TapEnv.toolWarning(-1, "(TypeSpec tree regeneration) unspecified type !");
        return ILUtils.build(96, "UnknownType");
    }

    public String showType() {
        return this.toString();
    }

    public void dump() throws IOException {
        TapEnv.print(this.toString());
    }

    public String toString() {
        return "Unspecified WrapperTypeSpec";
    }
}

