/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.representation;

import fr.inria.tapenade.representation.NewSymbolHolder;
import fr.inria.tapenade.representation.SymbolDecl;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.TypeSpec;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.representation.WrapperTypeSpec;
import fr.inria.tapenade.utils.Tree;

public final class TypeDecl
extends SymbolDecl {
    public WrapperTypeSpec typeSpec;

    public TypeDecl(Tree identTree, WrapperTypeSpec typeSpec) {
        super(identTree, 4);
        this.typeSpec = typeSpec;
        this.setTypeDeclName(this.symbol);
    }

    public TypeDecl(String name, WrapperTypeSpec typeSpec) {
        super(name, 4);
        this.typeSpec = typeSpec;
        this.setTypeDeclName(this.symbol);
    }

    public TypeDecl(Tree identTree, WrapperTypeSpec typeSpec, Unit inUnit) {
        super(identTree, 4);
        this.typeSpec = typeSpec;
        this.setTypeDeclName(this.symbol, inUnit);
    }

    public static TypeDecl findTypeDecl(TapList<SymbolDecl> dependsOn) {
        TypeDecl result = null;
        while (dependsOn != null && result == null) {
            SymbolDecl symbolDecl = (SymbolDecl)dependsOn.head;
            if (symbolDecl != null && symbolDecl.kind == 4) {
                result = (TypeDecl)symbolDecl;
            }
            dependsOn = dependsOn.tail;
        }
        return result;
    }

    public void setTypeDeclName(String name, Unit inUnit) {
        if (this.typeSpec.wrappedType != null) {
            this.typeSpec.wrappedType.addInTypeDeclNames(inUnit, name);
        }
    }

    public String getTypeDeclName() {
        if (this.typeSpec.wrappedType != null) {
            return this.typeSpec.wrappedType.typeDeclName();
        }
        return null;
    }

    public void setTypeDeclName(String name) {
        String oldName;
        if (this.typeSpec.wrappedType != null && TypeSpec.ignoreTypeDeclName(oldName = this.typeSpec.wrappedType.typeDeclName())) {
            this.typeSpec.wrappedType.setTypeDeclName(name);
        }
    }

    public TypeDecl activeTypeDecl(SymbolTable diffSymbolTable, WrapperTypeSpec activeTypeSpec, String fSuffix) {
        TypeDecl diffTypeDecl = null;
        String origTypeName = this.symbol;
        if (TypeSpec.isA(this.typeSpec, 21) || TapEnv.associationByAddress()) {
            NewSymbolHolder diffSymbolHolder = this.getDiffSymbolHolder(0, null, 0);
            if (diffSymbolHolder != null) {
                diffTypeDecl = diffSymbolHolder.newTypeDecl();
            } else if (activeTypeSpec != null) {
                if (this.importedFrom != null) {
                    diffTypeDecl = ((TypeDecl)this.importedFrom.first).activeTypeDecl(diffSymbolTable, activeTypeSpec, fSuffix);
                }
                if (this.importedFrom != null && origTypeName.equals(((SymbolDecl)this.importedFrom.first).symbol)) {
                    diffSymbolHolder = ((TypeDecl)this.importedFrom.first).getDiffSymbolHolder(0, null, 0);
                } else {
                    diffSymbolHolder = new NewSymbolHolder(TapEnv.extendStringWithSuffix(origTypeName, fSuffix));
                    diffSymbolHolder.setAsType(activeTypeSpec, null);
                    diffSymbolHolder.isDerivationFrom(this, fSuffix);
                    diffTypeDecl = diffSymbolHolder.newTypeDecl();
                }
                SymbolTable basisSymbolTable = diffSymbolTable;
                if (TapEnv.associationByAddress() && diffSymbolTable != null && this.typeSpec.isScalar()) {
                    basisSymbolTable = diffSymbolTable.findAssocAddresTypeDeclSymbolTable();
                }
                if (basisSymbolTable != null) {
                    diffSymbolHolder.addTypeDeclSymbolTable(basisSymbolTable);
                    diffSymbolHolder.makeNewRef(basisSymbolTable);
                    diffSymbolHolder.makeNewRef(diffSymbolTable);
                    diffSymbolHolder.solvingLevelMustInclude(basisSymbolTable);
                    if (TapEnv.associationByAddress() && !TapEnv.get().complexStep && basisSymbolTable.basisSymbolTable() != null) {
                        int basisLanguage = basisSymbolTable.language();
                        if (basisLanguage == -1 && basisSymbolTable.unit != null) {
                            basisLanguage = basisSymbolTable.unit.language();
                        }
                        diffSymbolHolder.declarationLevelMustInclude(TapEnv.assocAddressDiffTypesUnit(basisLanguage).publicSymbolTable());
                    }
                }
                this.setDiffSymbolHolder(0, null, 0, diffSymbolHolder);
            }
        } else {
            WrapperTypeSpec baseTypeSpec = this.typeSpec.baseTypeSpec(true);
            TapEnv.toolWarning(-1, "(Diff of a Type): Don't know how to differentiate a " + baseTypeSpec);
        }
        return diffTypeDecl;
    }

    @Override
    public void collectUsedTrees(TapList<Tree> toUsedTrees, TapList<TypeSpec> toDejaVu) {
        if (this.typeSpec != null && this.typeSpec.wrappedType != null) {
            this.typeSpec.wrappedType.collectUsedTrees(toUsedTrees, toDejaVu);
        }
    }

    @Override
    public WrapperTypeSpec type() {
        return this.typeSpec;
    }

    @Override
    public String toString() {
        return this.symbol + ": type." + (this.importedFrom == null ? "" : " (=>" + this.importedFrom.first + " from @" + Integer.toHexString(((SymbolTable)this.importedFrom.second).hashCode()) + ")") + " stands for " + (this.typeSpec == null ? "null_type" : this.typeSpec) + (!this.isActiveSymbolDecl() ? "" : " active") + " depends on:" + this.dependsOn();
    }
}

