/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.representation;

import fr.inria.tapenade.analysis.ADActivityAnalyzer;
import fr.inria.tapenade.analysis.ADTBRAnalyzer;
import fr.inria.tapenade.analysis.DepsAnalyzer;
import fr.inria.tapenade.analysis.DiffLivenessAnalyzer;
import fr.inria.tapenade.analysis.InOutAnalyzer;
import fr.inria.tapenade.analysis.MultithreadAnalyzer;
import fr.inria.tapenade.analysis.PointerAnalyzer;
import fr.inria.tapenade.analysis.ReqExplicit;
import fr.inria.tapenade.ir2tree.ControlStruct;
import fr.inria.tapenade.representation.ArrayDim;
import fr.inria.tapenade.representation.Block;
import fr.inria.tapenade.representation.BlockStorage;
import fr.inria.tapenade.representation.CallArrow;
import fr.inria.tapenade.representation.CallGraph;
import fr.inria.tapenade.representation.FGArrow;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.Instruction;
import fr.inria.tapenade.representation.InstructionMask;
import fr.inria.tapenade.representation.MixedLanguageInfos;
import fr.inria.tapenade.representation.PositionAndMessage;
import fr.inria.tapenade.representation.PublicInfo;
import fr.inria.tapenade.representation.SymbolDecl;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapEnvForThread;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.TypeSpec;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.representation.WrapperTypeSpec;
import fr.inria.tapenade.representation.ZoneInfo;
import fr.inria.tapenade.utils.BoolMatrix;
import fr.inria.tapenade.utils.BoolVector;
import fr.inria.tapenade.utils.TapIntList;
import fr.inria.tapenade.utils.TapPair;
import fr.inria.tapenade.utils.TapTriplet;
import fr.inria.tapenade.utils.Tree;
import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public final class TapEnv {
    public static final String UNDEFINEDSIZE = "undefinedSize";
    public static final int UNDEFINED = -1;
    public static final int FORTRAN = 1;
    public static final int FORTRAN90 = 2;
    public static final int FORTRAN2003 = 3;
    public static final int C = 4;
    public static final int CPLUSPLUS = 5;
    public static final int CUDA = 6;
    public static final int INCLUDE = 98;
    public static final int JAR = 99;
    public static final int MIXED = 100;
    public static final int FORTRAN_FAMILY = 0;
    public static final int C_FAMILY = 1;
    public static final int CPLUSPLUS_FAMILY = 2;
    public static final String STD_CPP_COMMAND = "/usr/bin/cpp";
    public static final String MAC_CPP_COMMAND = "/usr/bin/cpp";
    public static final int CPLUSPLUS_PARSER_NB_ARGS = 6;
    public static final int NO_POSITION = -1;
    public static final int NEXT_TREE = -2;
    public static final int MSG_ALWAYS = -1;
    public static final int MSG_ERROR = 0;
    public static final int MSG_SEVERE = 5;
    public static final int MSG_DEFAULT = 10;
    public static final int MSG_WARN = 15;
    public static final int MSG_TRACE = 30;
    protected static final int BYTE_SIZE = 1;
    protected static final int CHAR_SIZE = 1;
    protected static final int POINTER_SIZE = 8;
    protected static final int REAL_SIZE = 4;
    protected static final int TANGENT_MODE = 1;
    private static final int PREPROCESS_MODE = 0;
    private static final int ADJOINT_MODE = -1;
    private static final int OVERLOAD_MODE = 2;
    public static final int MAX_DIFF_SORTS = 5;
    public static final int NO_DEBUG = 0;
    public static final int TGT_DEBUG = 1;
    public static final int ADJ_DEBUG = -1;
    public static final String tapenadeCss = "<link type=\"text/CSS\" rel=\"stylesheet\" href=\"tapenade.css\">";
    public static final String bootstrapCss = "<link rel=\"stylesheet\" href=\"https://cdn.jsdelivr.net/npm/bootstrap@4.5.3/dist/css/bootstrap.min.css\" integrity=\"sha384-TX8t27EcRE3e/ihU7zmQxVncDAy5uIKz4rEkgIXeMed4M0jlfIDPvg6uqKI2xXr2\" crossorigin=\"anonymous\">";
    private static String activeMark = "";
    private static String reqXMark = "";
    private static String tapenadeHome = System.getProperty("tapenade_home");
    private static boolean isServlet;
    private static final ThreadLocal<TapEnvForThread> tapEnvForThread;
    private static boolean isDistribVersion;
    private static int traceLevel;
    private static int msgLevel;
    protected static final boolean BETTERMESSAGESTYLE = false;

    public static String activeMark() {
        return activeMark;
    }

    public static void setActiveMark(String activeMark) {
        TapEnv.activeMark = activeMark;
    }

    public static String reqXMark() {
        return reqXMark;
    }

    public static void setReqXMark(String reqXMark) {
        TapEnv.reqXMark = reqXMark;
    }

    public static String tapenadeHome() {
        return tapenadeHome;
    }

    public static void setTapenadeHome(String tapenadeDirectory) {
        tapenadeHome = tapenadeDirectory;
    }

    public static boolean isServlet() {
        return isServlet;
    }

    public static void setIsServlet() {
        isServlet = true;
    }

    private TapEnv() {
    }

    public static TapEnvForThread get() {
        return tapEnvForThread.get();
    }

    public static final boolean isDistribVersion() {
        return isDistribVersion;
    }

    public static void setDistribVersion(boolean value) {
        isDistribVersion = value;
    }

    public static final String outputExtension(int lang) {
        switch (lang) {
            case 1: {
                return ".f";
            }
            case 2: {
                return ".f90";
            }
            case 3: {
                return ".f03";
            }
            case 4: 
            case 100: {
                return ".c";
            }
            case 5: {
                return ".c++";
            }
            case 6: {
                return ".cu";
            }
        }
        return "";
    }

    public static final String getExtension(String filename) {
        return filename.substring(1 + filename.lastIndexOf(46)).toLowerCase();
    }

    public static final void switchOnCombineDeclMessages(boolean onOff) {
        TapEnv.get().combineDeclMessagesSwitch = onOff;
    }

    public static final boolean isFortran(int language) {
        return language == 1 || language == 2 || language == 3;
    }

    public static final boolean isFortran9x(int language) {
        return language == 2 || language == 3;
    }

    public static final boolean isC(int language) {
        return language == 4 || language == 6 || language == 5;
    }

    public static final boolean isCexactly(int language) {
        return language == 4;
    }

    public static final boolean sameLanguageFamily(int lang1, int lang2) {
        return TapEnv.isFortran(lang1) && TapEnv.isFortran(lang2) || TapEnv.isC(lang1) && TapEnv.isC(lang2);
    }

    public static final CallArrow relatedArrow() {
        return TapEnv.get().relatedArrow;
    }

    public static final void setRelatedArrow(CallArrow arrow) {
        TapEnv.get().relatedArrow = arrow;
    }

    public static final Unit relatedUnit() {
        return TapEnv.get().relatedUnit;
    }

    public static final void setRelatedUnit(Unit unit) {
        TapEnv.get().relatedUnit = unit;
        if (unit == null) {
            TapEnv.setRelatedLanguage(null);
        } else {
            TapEnv.setRelatedLanguage(unit.publicSymbolTable());
        }
        TapEnv.get().traceTypeCheckAnalysis = TapEnv.get().tracedTypeCheckUnits == null ? TapEnv.get().traceTypeCheck != null && ((String)TapEnv.get().traceTypeCheck.head).equals("%all%") : TapEnv.get().tracedTypeCheckUnits.head == null || unit != null && TapList.contains(TapEnv.get().tracedTypeCheckUnits, unit);
    }

    public static final void pushRelatedUnit(Unit unit) {
        TapEnv.get().relatedUnits = new TapList<Unit>(TapEnv.get().relatedUnit, TapEnv.get().relatedUnits);
        TapEnv.get().relatedUnit = unit;
        if (unit == null) {
            TapEnv.setRelatedLanguage(null);
        } else {
            TapEnv.setRelatedLanguage(unit.publicSymbolTable());
        }
    }

    public static final void popRelatedUnit() {
        if (TapEnv.get().relatedUnits != null) {
            TapEnv.get().relatedUnit = (Unit)TapEnv.get().relatedUnits.head;
            TapEnv.get().relatedUnits = TapEnv.get().relatedUnits.tail;
        } else {
            TapEnv.get().relatedUnit = null;
        }
        if (TapEnv.get().relatedUnit == null) {
            TapEnv.setRelatedLanguage(null);
        } else {
            TapEnv.setRelatedLanguage(TapEnv.get().relatedUnit.publicSymbolTable());
        }
    }

    public static final void resetRelatedUnit() {
        TapEnv.get().relatedUnit = null;
        TapEnv.get().relatedUnits = new TapList<Object>(null, null);
        TapEnv.setRelatedLanguage(null);
    }

    public static final void setModeNoDiff() {
        TapEnv.get().diffMode = 0;
    }

    public static final void setModeTangent() {
        TapEnv.get().diffMode = 1;
    }

    public static final void setModeAdjoint() {
        TapEnv.get().diffMode = -1;
    }

    public static final void setModeOverloading() {
        TapEnv.get().diffMode = 2;
    }

    public static final boolean modeIsNoDiff() {
        return TapEnv.get().diffMode == 0;
    }

    public static final boolean modeIsTangent() {
        return TapEnv.get().diffMode == 1;
    }

    public static final boolean modeIsAdjoint() {
        return TapEnv.get().diffMode == -1;
    }

    public static final boolean modeIsOverloading() {
        return TapEnv.get().diffMode == 2;
    }

    public static final void resetPushPopNumber() {
        TapEnv.get().pushPopNumber = 0;
    }

    public static final int getNewPushPopNumber() {
        if (TapEnv.get().numberPushPops) {
            ++TapEnv.get().pushPopNumber;
        }
        return TapEnv.get().pushPopNumber - 1;
    }

    public static final boolean associationByAddress() {
        return TapEnv.get().associationByAddress;
    }

    public static final void setAssociationByAddress(boolean value) {
        TapEnv.get().associationByAddress = value;
    }

    public static final String assocAddressValueSuffix() {
        return TapEnv.get().assocAddressValueSuffix;
    }

    public static final String assocAddressDiffSuffix() {
        return TapEnv.get().assocAddressDiffSuffix;
    }

    public static final boolean valid() {
        return TapEnv.get().valid;
    }

    public static final void setValid(boolean value) {
        TapEnv.get().valid = value;
    }

    public static final boolean traceCurAnalysis() {
        return TapEnv.get().traceCurAnalysis;
    }

    public static final void setTraceCurAnalysis(boolean value) {
        TapEnv.get().traceCurAnalysis = value;
    }

    public static final boolean traceThisCallArrow(CallArrow arrow) {
        return !(arrow == null || TapEnv.get().traceCallArrowOriginName == null || !"%any%".equals(TapEnv.get().traceCallArrowOriginName) && !arrow.origin.name().equals(TapEnv.get().traceCallArrowOriginName) || TapEnv.get().traceCallArrowDestinationName == null || !"%any%".equals(TapEnv.get().traceCallArrowDestinationName) && !arrow.destination.name().equals(TapEnv.get().traceCallArrowDestinationName));
    }

    public static final boolean traceTypeCheckAnalysis() {
        return TapEnv.get().traceTypeCheckAnalysis;
    }

    public static final void setTraceTypeCheckAnalysis(boolean value) {
        TapEnv.get().traceTypeCheckAnalysis = value;
    }

    public static final boolean traceInputIL() {
        return TapEnv.get().traceInputIL;
    }

    public static final void setTraceInputIL(boolean value) {
        TapEnv.get().traceInputIL = value;
    }

    public static final TapList<String> tracePointer() {
        return TapEnv.get().tracePointer;
    }

    public static final void setTracePointer(TapList<String> unitNames) {
        TapEnv.get().tracePointer = unitNames;
    }

    public static final TapList<String> traceFlowGraphBuild() {
        return TapEnv.get().traceFlowGraphBuild;
    }

    public static final void setTraceFlowGraphBuild(TapList<String> unitNames) {
        TapEnv.get().traceFlowGraphBuild = unitNames;
    }

    public static final TapList<String> traceInOut() {
        return TapEnv.get().traceInOut;
    }

    public static final void setTraceInOut(TapList<String> unitNames) {
        TapEnv.get().traceInOut = unitNames;
    }

    public static final TapList<String> traceDeps() {
        return TapEnv.get().traceDeps;
    }

    public static final void setTraceDeps(TapList<String> unitNames) {
        TapEnv.get().traceDeps = unitNames;
    }

    public static final TapList<String> traceADDeps() {
        return TapEnv.get().traceADDeps;
    }

    public static final void setTraceADDeps(TapList<String> unitNames) {
        TapEnv.get().traceADDeps = unitNames;
    }

    public static final TapList<String> traceActivity() {
        return TapEnv.get().traceActivity;
    }

    public static final void setTraceActivity(TapList<String> unitNames) {
        TapEnv.get().traceActivity = unitNames;
    }

    public static final TapList<String> traceReqExplicit() {
        return TapEnv.get().traceReqExplicit;
    }

    public static final void setTraceReqExplicit(TapList<String> unitNames) {
        TapEnv.get().traceReqExplicit = unitNames;
    }

    public static final TapList<String> traceDiffLiveness() {
        return TapEnv.get().traceDiffLiveness;
    }

    public static final void setTraceDiffLiveness(TapList<String> unitNames) {
        TapEnv.get().traceDiffLiveness = unitNames;
    }

    public static final TapList<String> traceTBR() {
        return TapEnv.get().traceTBR;
    }

    public static final void setTraceTBR(TapList<String> unitNames) {
        TapEnv.get().traceTBR = unitNames;
    }

    public static final TapList<String> traceMultithread() {
        return TapEnv.get().traceMultithread;
    }

    public static final void setTraceMultithread(TapList<String> unitNames) {
        TapEnv.get().traceMultithread = unitNames;
    }

    public static final TapList<String> duplicableUnitNames() {
        return TapEnv.get().duplicableUnitNames;
    }

    public static final void setDuplicableUnitNames(TapList<String> unitNames) {
        TapEnv.get().duplicableUnitNames = unitNames;
    }

    public static final int debugAdMode() {
        return TapEnv.get().debugAdMode;
    }

    public static final void setDebugAdMode(int value) {
        TapEnv.get().debugAdMode = value;
    }

    public static final boolean debugADMM() {
        return TapEnv.get().debugADMM;
    }

    public static final void setDebugADMM(boolean value) {
        TapEnv.get().debugADMM = value;
    }

    public static final int diffKind() {
        return TapEnv.get().diffKind;
    }

    public static final void setDiffKind(int kind) {
        TapEnv.get().diffKind = kind;
    }

    public static final boolean doActivity() {
        return TapEnv.get().doActivity;
    }

    public static final void setDoActivity(boolean value) {
        TapEnv.get().doActivity = value;
    }

    public static final boolean doUsefulness() {
        return TapEnv.get().doUsefulness;
    }

    public static final void setDoUsefulness(boolean value) {
        TapEnv.get().doUsefulness = value;
    }

    public static final boolean debugActivity() {
        return TapEnv.get().debugActivity;
    }

    public static final void setDebugActivity(boolean value) {
        TapEnv.get().debugActivity = value;
    }

    public static final boolean doTBR() {
        return TapEnv.get().doTBR;
    }

    public static final void setDoTBR(boolean value) {
        TapEnv.get().doTBR = value;
    }

    public static final boolean doRecompute() {
        return TapEnv.get().doRecompute;
    }

    public static final void setDoRecompute(boolean value) {
        TapEnv.get().doRecompute = value;
    }

    public static final boolean doMPI() {
        return TapEnv.get().doMPI;
    }

    public static final void setDoMPI(boolean value) {
        TapEnv.get().doMPI = value;
    }

    public static final boolean doOpenMP() {
        return TapEnv.get().doOpenMP;
    }

    public static final void setDoOpenMP(boolean value) {
        TapEnv.get().doOpenMP = value;
    }

    public static final boolean doOpenMPZ3() {
        return TapEnv.get().doOpenMPZ3;
    }

    public static final void setDoOpenMPZ3(boolean value) {
        TapEnv.get().doOpenMPZ3 = value;
    }

    public static final DepsAnalyzer depsAnalyzer() {
        return TapEnv.get().depsAnalyzer;
    }

    public static final void setDepsAnalyzer(DepsAnalyzer analyzer) {
        TapEnv.get().depsAnalyzer = analyzer;
    }

    public static final InOutAnalyzer inOutAnalyzer() {
        return TapEnv.get().inOutAnalyzer;
    }

    public static final void setInOutAnalyzer(InOutAnalyzer analyzer) {
        TapEnv.get().inOutAnalyzer = analyzer;
    }

    public static final MultithreadAnalyzer multithreadAnalyzer() {
        return TapEnv.get().multithreadAnalyzer;
    }

    public static final void setMultithreadAnalyzer(MultithreadAnalyzer analyzer) {
        TapEnv.get().multithreadAnalyzer = analyzer;
    }

    public static final ADActivityAnalyzer adActivityAnalyzer() {
        return TapEnv.get().adActivityAnalyzer;
    }

    public static final void setADActivityAnalyzer(ADActivityAnalyzer analyzer) {
        TapEnv.get().adActivityAnalyzer = analyzer;
    }

    public static final ADTBRAnalyzer adTbrAnalyzer() {
        return TapEnv.get().adTbrAnalyzer;
    }

    public static final void setADTBRAnalyzer(ADTBRAnalyzer analyzer) {
        TapEnv.get().adTbrAnalyzer = analyzer;
    }

    public static final DiffLivenessAnalyzer diffLivenessAnalyzer() {
        return TapEnv.get().diffLivenessAnalyzer;
    }

    public static final void setDiffLivenessAnalyzer(DiffLivenessAnalyzer analyzer) {
        TapEnv.get().diffLivenessAnalyzer = analyzer;
    }

    public static final PointerAnalyzer pointerAnalyzer() {
        return TapEnv.get().pointerAnalyzer;
    }

    public static final void setPointerAnalyzer(PointerAnalyzer analyzer) {
        TapEnv.get().pointerAnalyzer = analyzer;
    }

    public static final ReqExplicit reqExplicitAnalyzer() {
        return TapEnv.get().reqExplicitAnalyzer;
    }

    public static final void setReqExplicitAnalyzer(ReqExplicit analyzer) {
        TapEnv.get().reqExplicitAnalyzer = analyzer;
    }

    public static final String optionsString() {
        return TapEnv.get().optionsString;
    }

    public static final void addOptionsString(String options) {
        TapEnv.get().optionsString = TapEnv.get().optionsString + options;
    }

    public static final boolean mustTangent() {
        return TapEnv.get().mustTangent;
    }

    public static final void setMustTangent(boolean value) {
        TapEnv.get().mustTangent = value;
    }

    public static final boolean mustAdjoint() {
        return TapEnv.get().mustAdjoint;
    }

    public static final void setMustAdjoint(boolean value) {
        TapEnv.get().mustAdjoint = value;
    }

    public static final boolean mustContext() {
        return TapEnv.get().mustContext;
    }

    public static final void setMustContext(boolean value) {
        TapEnv.get().mustContext = value;
    }

    public static final int diffReplica() {
        return TapEnv.get().diffReplica;
    }

    public static final Unit assocAddressDiffTypesUnit(int language) {
        return TapEnv.get().assocAddressDiffTypesUnits[TapEnv.getAssocAddressIndex(language)];
    }

    public static final void setAssocAddressDiffTypesUnit(Unit unit) {
        TapEnv.get().assocAddressDiffTypesUnits[TapEnv.getAssocAddressIndex((int)unit.language())] = unit;
    }

    public static final int getAssocAddressIndex(int language) {
        int result = 0;
        if (language == 4 || language == 6) {
            result = 1;
        } else if (language == 5) {
            result = 2;
        }
        return result;
    }

    public static final boolean removeDeadPrimal() {
        return TapEnv.get().removeDeadPrimal;
    }

    public static final void setRemoveDeadPrimal(boolean value) {
        TapEnv.get().removeDeadPrimal = value;
    }

    public static final boolean removeDeadControl() {
        return TapEnv.get().removeDeadControl;
    }

    public static final void setRemoveDeadControl(boolean value) {
        TapEnv.get().removeDeadControl = value;
    }

    public static final boolean spareDiffReinitializations() {
        return TapEnv.get().spareDiffReinitializations;
    }

    public static final void setSpareDiffReinitializations(boolean value) {
        TapEnv.get().spareDiffReinitializations = value;
    }

    public static final Instruction currentIncludeInstruction() {
        return TapEnv.get().currentIncludeInstruction;
    }

    public static final void setCurrentIncludeInstruction(Instruction instruction) {
        TapEnv.get().currentIncludeInstruction = instruction;
    }

    public static final String disambigNewName(String name) {
        if (TapEnv.get().newSHdisambiguator < 0) {
            return name;
        }
        ++TapEnv.get().newSHdisambiguator;
        return name + "x" + TapEnv.get().newSHdisambiguator;
    }

    public static final String parserFileSeparator() {
        return TapEnv.get().parserFileSeparator;
    }

    public static final void setParserFileSeparator(String separator) {
        TapEnv.get().parserFileSeparator = separator;
    }

    public static final String commentStart(int language) {
        String result = "";
        switch (language) {
            case 1: {
                result = "C";
                break;
            }
            case 2: 
            case 3: {
                result = "!";
                break;
            }
            case 4: {
                result = "//";
                break;
            }
        }
        return result;
    }

    public static final String languageName(int lang) {
        String langName = "UNKNOWN";
        switch (lang) {
            case 1: {
                langName = "FORTRAN";
                break;
            }
            case 2: {
                langName = "FORTRAN90";
                break;
            }
            case 3: {
                langName = "FORTRAN2003";
                break;
            }
            case 4: {
                langName = "C";
                break;
            }
            case 6: {
                langName = "CUDA";
                break;
            }
            case 5: {
                langName = "CPP";
                break;
            }
            case 100: {
                langName = "MIXED";
                break;
            }
        }
        return langName;
    }

    public static final int inputLanguage() {
        return TapEnv.get().inputLanguage;
    }

    public static final void setInputLanguage(int lang) {
        TapEnv.get().inputLanguage = lang;
    }

    public static final int outputLanguage() {
        return TapEnv.get().outputLanguage;
    }

    public static final void setOutputLanguage(int lang) {
        TapEnv.get().outputLanguage = lang;
    }

    public static final int relatedLanguage() {
        return TapEnv.get().relatedLanguage;
    }

    public static final boolean relatedLanguageIsC() {
        return TapEnv.get().relatedLanguage == 4 || TapEnv.get().relatedLanguage == 6;
    }

    public static final boolean relatedLanguageIsCPLUSPLUS() {
        return TapEnv.get().relatedLanguage == 5;
    }

    public static final boolean relatedLanguageIsFortran() {
        int language = TapEnv.get().relatedLanguage;
        return language == 1 || language == 2 || language == 3;
    }

    public static final boolean relatedLanguageIsFortran77() {
        return TapEnv.get().relatedLanguage == 1;
    }

    public static final boolean relatedLanguageIsFortran9x() {
        int language = TapEnv.get().relatedLanguage;
        return language == 2 || language == 3;
    }

    public static final void setRelatedLanguage(int lang) {
        TapEnv.get().relatedLanguage = lang;
    }

    public static final void setRelatedLanguage(SymbolTable symbolTable) {
        TapEnv.get().relatedLanguage = symbolTable != null ? symbolTable.language() : TapEnv.get().inputLanguage;
    }

    public static final TapList<MixedLanguageInfos> mixedLanguageInfos() {
        return TapEnv.get().mixedLangInfos;
    }

    public static final void setMixedLanguageInfos(TapList<MixedLanguageInfos> infos) {
        TapEnv.get().mixedLangInfos = infos;
    }

    public static final void addMixedLanguageInfos(MixedLanguageInfos infos) {
        TapEnv.get().mixedLangInfos = new TapList<MixedLanguageInfos>(infos, TapEnv.get().mixedLangInfos);
    }

    public static final void setLanguages(int rank, int lang) {
        TapEnv.get().languages[rank] = lang;
    }

    public static final int languages(int i) {
        return TapEnv.get().languages[i];
    }

    public static final void warningFortran77WithFortran90Features(Unit unit) {
        if (unit.language() == 1) {
            unit.setLanguageAndUp(2);
            TapEnv.fileWarning(15, null, "(DD27) " + unit.name() + " contains FORTRAN90 feature");
        }
    }

    public static final void setCurrentDirectory(String dir) {
        Path curPath = null;
        if (dir != null && !dir.isEmpty()) {
            curPath = Paths.get(dir, new String[0]).toAbsolutePath().normalize();
        }
        TapEnv.get().currentDirectory = dir;
        if (TapEnv.get().rootDirectoryPath == null) {
            TapEnv.get().rootDirectoryPath = curPath;
        } else if (curPath != null && !TapEnv.get().currentDirectory.isEmpty() && !TapEnv.get().rootDirectoryPath.equals(curPath)) {
            int nbRoot = TapEnv.get().rootDirectoryPath.getNameCount();
            int nbCur = curPath.getNameCount();
            int nbEquals = 0;
            for (int i = 0; i < Math.min(nbRoot, nbCur); ++i) {
                if (!TapEnv.get().rootDirectoryPath.getName(i).equals(curPath.getName(i))) continue;
                nbEquals = i;
            }
            TapEnv.get().rootDirectoryPath = TapEnv.get().rootDirectoryPath.subpath(0, nbEquals + 1);
            TapEnv.get().rootDirectoryPath = curPath.getRoot().resolve(TapEnv.get().rootDirectoryPath);
        }
    }

    public static final void setCurrentParsedFile(String filename) {
        try {
            Path curPath = Paths.get(filename, new String[0]).toAbsolutePath().normalize();
            TapEnv.get().currentParsedFile = curPath.getFileName().toString();
        }
        catch (IOError | SecurityException | InvalidPathException e) {
            String name = filename.substring(filename.lastIndexOf(File.separator) + 1);
            TapEnv.systemWarning(-1, "Malformed input or input contains unmappable characters: " + name);
            TapEnv.get().currentParsedFile = name;
        }
    }

    public static final String currentParsedFile() {
        return TapEnv.get().currentParsedFile;
    }

    public static final void setCurrentTranslationUnitSymbolTable(SymbolTable symbolTable) {
        TapEnv.get().currentTranslationUnitSymbolTable = symbolTable;
    }

    public static final SymbolTable currentTranslationUnitSymbolTable() {
        return TapEnv.get().currentTranslationUnitSymbolTable;
    }

    public static final void setIncludeDirs(TapList<String> includeList) {
        TapEnv.get().includeDirs = includeList;
    }

    public static final TapList<String> includeDirs() {
        return TapEnv.get().includeDirs;
    }

    public static final void pushIncludeFile(String includeFileName) {
        TapEnv.get().includeFileStack = new TapList<String>(includeFileName, TapEnv.get().includeFileStack);
    }

    public static final String popIncludeFile() {
        if (TapEnv.get().includeFileStack == null) {
            return null;
        }
        String popped = (String)TapEnv.get().includeFileStack.head;
        TapEnv.get().includeFileStack = TapEnv.get().includeFileStack.tail;
        return popped;
    }

    public static final TapList<String> includeFileStack() {
        return TapEnv.get().includeFileStack;
    }

    public static final boolean exitingBackToInclude(String includeFileName) {
        return TapEnv.get().includeFileStack != null && TapEnv.get().includeFileStack.tail != null && includeFileName.equals(TapEnv.get().includeFileStack.tail.head);
    }

    public static final boolean inIncludeFile() {
        return TapEnv.get().inIncludeFile;
    }

    public static final Tree setInIncludeFile(Tree includeTree) {
        Tree includeCommandAsOpInclude = TapEnv.getIncludeTree(includeTree);
        TapEnv.checkAndUpdateTapEnvInclude(includeCommandAsOpInclude);
        return includeCommandAsOpInclude;
    }

    public static final Tree getIncludeTree(Tree includeTree) {
        Tree result = null;
        if (ILUtils.stopInclude(includeTree, "tapenade end #include")) {
            result = null;
        } else if (ILUtils.inInclude(includeTree, "tapenade begin #include")) {
            if (includeTree.opCode() == 101) {
                result = includeTree;
            } else {
                String include = includeTree.down(1).stringValue().substring("tapenade begin #include ".length());
                include = TapEnv.filterIncludeFileName(include, true, true);
                result = ILUtils.build(101, include);
            }
        } else if (includeTree.opCode() == 101) {
            result = includeTree;
        }
        return result;
    }

    public static final boolean enclosingIncludeIsEmptyOr(Tree includeTree) {
        String nextIncludeFile;
        if (TapEnv.get().includeFiles.tail == null) {
            return true;
        }
        if (includeTree.opCode() != 101) {
            includeTree = includeTree.down(1);
        }
        if ((nextIncludeFile = includeTree.stringValue()).startsWith("tapenade end #include")) {
            nextIncludeFile = nextIncludeFile.substring("tapenade end #include ".length());
            nextIncludeFile = TapEnv.filterIncludeFileName(nextIncludeFile, true, true);
        }
        return ((String)TapEnv.get().includeFiles.tail.head).equals(nextIncludeFile);
    }

    public static final String filterIncludeFileName(String includeFileName, boolean withCapsule, boolean mustExist) {
        String usrStr = "/usr/";
        String optStr = "/opt/";
        String includeStr = "include/";
        if ((includeFileName.startsWith(usrStr) || includeFileName.startsWith(optStr)) && includeFileName.indexOf(includeStr) > 0) {
            int index = includeFileName.lastIndexOf(includeStr);
            includeFileName = includeFileName.substring(index + includeStr.length());
            if (withCapsule) {
                includeFileName = "<" + includeFileName + ">";
            }
        } else {
            String includeName = includeFileName;
            if (!TapEnv.isStdIncludeName(includeName)) {
                boolean includeFileExists;
                if (includeName.startsWith("\"")) {
                    includeName = includeName.substring(1, includeName.length() - 1);
                }
                if (!(includeFileExists = new File(includeName).exists()) && !TapEnv.get().currentDirectory.isEmpty()) {
                    includeName = TapEnv.get().rootDirectoryPath.toString() + File.separator + includeName;
                    includeFileExists = new File(includeName).exists();
                }
                if (!includeFileExists && mustExist) {
                    TapEnv.parserError("Fatal error: " + includeName + ": No such include file");
                    TapEnv.tapenadeExit(1);
                }
            }
            if (!TapEnv.get().currentDirectory.isEmpty() && includeFileName.startsWith(TapEnv.get().currentDirectory)) {
                Path pathInclude = Paths.get(includeFileName, new String[0]);
                Path absInclude = pathInclude.toAbsolutePath();
                absInclude = absInclude.normalize();
                includeFileName = TapEnv.get().rootDirectoryPath.relativize(absInclude).toString();
            } else {
                TapList<String> includeDirectories = TapEnv.get().includeDirs;
                int index = -1;
                while (includeDirectories != null && index == -1) {
                    String includeDir = (String)includeDirectories.head;
                    if (includeFileName.startsWith(includeDir)) {
                        index = includeFileName.indexOf(includeDir) + includeDir.length();
                        includeFileName = includeFileName.substring(index);
                    }
                    includeDirectories = includeDirectories.tail;
                }
            }
            includeFileName = ILUtils.normalizePath(includeFileName);
            if (withCapsule) {
                includeFileName = "\"" + includeFileName + "\"";
            }
        }
        return includeFileName;
    }

    public static final void resetIncludeManager() {
        TapEnv.get().inIncludeFile = false;
        TapEnv.get().includeFiles = null;
        TapEnv.get().includeFileStack = null;
        TapEnv.get().currentIncludeInstruction = null;
    }

    public static final boolean inStdCIncludeFile() {
        return TapEnv.get().inIncludeFile && TapEnv.isStdCInclude(TapEnv.get().currentIncludeInstruction);
    }

    public static final boolean isStdIncludeName(String includeName) {
        return includeName.startsWith("<") && includeName.endsWith(">") || includeName.endsWith("mpi.h\"") && !includeName.endsWith("seismmpi.h\"") || includeName.endsWith("mpio.h\"") || includeName.endsWith("mpif.h") || TapEnv.isCPPIncludeBug(includeName);
    }

    private static final boolean isCPPIncludeBug(String includeName) {
        return includeName.equals("\"<built-in>\"") || includeName.equals("\"<command line>\"");
    }

    public static final boolean isStdCInclude(Instruction curInclude) {
        boolean result = false;
        if (curInclude.tree != null && curInclude.tree.opCode() == 101) {
            String includeName = curInclude.tree.stringValue();
            boolean bl = result = TapEnv.relatedLanguageIsC() && TapEnv.isStdIncludeName(includeName);
            if (!result && curInclude.fromInclude() != null) {
                result = TapEnv.isStdCInclude(curInclude.fromInclude());
            }
        }
        return result;
    }

    public static final boolean checkAndUpdateTapEnvInclude(Tree tree) {
        boolean duplicatedInclude;
        String treeValue = tree == null ? null : tree.stringValue();
        boolean bl = duplicatedInclude = tree != null && TapEnv.get().currentIncludeInstruction != null && TapEnv.get().currentIncludeInstruction.tree != null && treeValue.equals(TapEnv.get().currentIncludeInstruction.tree.stringValue());
        if (!duplicatedInclude) {
            TapEnv.updateTapEnvInclude(tree);
        }
        return tree == null || !duplicatedInclude && !TapEnv.isCPPIncludeBug(treeValue);
    }

    public static final void updateTapEnvInclude(Tree tree) {
        if (tree != null) {
            TapEnv.get().inIncludeFile = true;
            TapEnv.get().includeFiles = new TapList<String>(tree.stringValue(), TapEnv.get().includeFiles);
            Instruction oldIncludeInstruction = TapEnv.get().currentIncludeInstruction;
            TapEnv.get().currentIncludeInstruction = new Instruction(tree);
            TapEnv.get().currentIncludeInstruction.setFromInclude(oldIncludeInstruction);
        } else {
            if (TapEnv.get().includeFiles != null) {
                TapEnv.get().includeFiles = TapEnv.get().includeFiles.tail;
                TapEnv.get().currentIncludeInstruction = TapEnv.get().currentIncludeInstruction.fromInclude();
            }
            if (TapEnv.get().includeFiles == null) {
                TapEnv.get().inIncludeFile = false;
            }
        }
    }

    public static final boolean isDiffIncludeFileName(String includeFileName) {
        TapList diffIncludeInfos = TapEnv.get().differentiatedIncludeNames.tail;
        boolean isPrimalInclude = false;
        boolean isDiffInclude = false;
        while (diffIncludeInfos != null) {
            TapTriplet diffIncludeInfo = (TapTriplet)diffIncludeInfos.head;
            if (!isPrimalInclude) {
                isPrimalInclude = includeFileName.equals(diffIncludeInfo.first);
            }
            if (!isDiffInclude) {
                isDiffInclude = includeFileName.equals(diffIncludeInfo.second);
            }
            diffIncludeInfos = diffIncludeInfos.tail;
        }
        return !isPrimalInclude && isDiffInclude;
    }

    public static final boolean alreadyDiffInclude(String includeFileName) {
        TapList diffIncludeInfos = TapEnv.get().differentiatedIncludeNames.tail;
        boolean isDiffInclude = false;
        while (diffIncludeInfos != null && !isDiffInclude) {
            TapTriplet diffIncludeInfo = (TapTriplet)diffIncludeInfos.head;
            isDiffInclude = includeFileName.equals(diffIncludeInfo.second);
            diffIncludeInfos = diffIncludeInfos.tail;
        }
        return isDiffInclude;
    }

    public static final boolean sameFinalIncludeFile(String include1, String include2) {
        if (include1.equals(include2)) {
            return true;
        }
        String diffIncludeName = TapEnv.getDiffIncludeName(include1);
        if (diffIncludeName != null && diffIncludeName.equals(include2)) {
            return true;
        }
        if (include2 != null) {
            diffIncludeName = TapEnv.getDiffIncludeName(include2);
            return include1.equals(diffIncludeName);
        }
        return false;
    }

    public static final TapTriplet<String, String, Tree> getSetDiffIncludeInfo(String includeFileName) {
        TapTriplet<String, String, Tree> diffIncludeInfo = TapList.assqStringInTriplet(includeFileName, TapEnv.get().differentiatedIncludeNames.tail);
        if (diffIncludeInfo == null) {
            diffIncludeInfo = new TapTriplet<String, Object, Object>(includeFileName, null, null);
            TapEnv.get().differentiatedIncludeNames.placdl(diffIncludeInfo);
        }
        return diffIncludeInfo;
    }

    public static final String getDiffIncludeName(String includeFileName) {
        TapTriplet diffIncludeInfo = TapList.assqStringInTriplet(includeFileName, TapEnv.get().differentiatedIncludeNames.tail);
        return diffIncludeInfo == null ? null : (String)diffIncludeInfo.second;
    }

    public static final String differentiateIncludeName(String includeName, String suffix) {
        String result;
        if (!TapEnv.isStdIncludeName(includeName)) {
            includeName = includeName.startsWith("\"") ? "\"" + TapEnv.stripPath(includeName.substring(1)) : TapEnv.stripPath(includeName);
            int index = includeName.lastIndexOf(46);
            String name = includeName;
            if (index >= 0) {
                name = includeName.substring(0, index);
                result = TapEnv.extendStringWithSuffix(name, suffix) + "." + TapEnv.getExtension(includeName);
            } else {
                if (name.endsWith("\"")) {
                    name = name.substring(0, name.length() - 1);
                }
                result = TapEnv.extendStringWithSuffix(name, suffix);
            }
        } else {
            TapEnv.toolWarning(-1, "(Differentiation of include file) Don't want to differentiate a standard include: " + includeName);
            result = includeName;
        }
        return result;
    }

    public static final void setSourceCodeCorrespondence(Tree source, Tree code, boolean forward, boolean backward) {
        TapPair<Object, Object> sourceTags = (TapPair<Object, Object>)source.getAnnotation("toOtherTags");
        TapPair<Object, Object> codeTags = (TapPair<Object, Object>)code.getAnnotation("toOtherTags");
        if (sourceTags == null) {
            sourceTags = new TapPair<Object, Object>(null, null);
            source.setAnnotation("toOtherTags", sourceTags);
        }
        if (codeTags == null) {
            codeTags = new TapPair<Object, Object>(null, null);
            code.setAnnotation("toOtherTags", codeTags);
        }
        if (forward && sourceTags.second == null) {
            if (codeTags.first == null) {
                codeTags.first = "i" + TapEnv.get().nextCodeTag;
                ++TapEnv.get().nextCodeTag;
            }
            sourceTags.second = codeTags.first;
        }
        if (backward && codeTags.second == null) {
            if (sourceTags.first == null) {
                sourceTags.first = "i" + TapEnv.get().nextSourceTag;
                ++TapEnv.get().nextSourceTag;
            }
            codeTags.second = sourceTags.first;
        }
    }

    public static final void initializeSourceMessageCorrespondence() {
        TapEnv.get().nextSourceMsgTag = 0;
        TapEnv.get().nextMessageTag = 0;
    }

    public static final String extendStringWithSuffix(String str, String suffix) {
        int center = suffix.indexOf(37);
        if (center < 0) {
            center = -1;
        }
        return (center <= 0 ? "" : suffix.substring(0, center)) + str + suffix.substring(center + 1);
    }

    public static final String extendReplica(String str, int replicaRank) {
        if (TapEnv.diffReplica() < 2) {
            return str;
        }
        if (TapEnv.diffReplica() == 2) {
            return str + (replicaRank == 0 ? "r" : "i");
        }
        return str + (replicaRank + 1);
    }

    public static final void setTraceLevel(int level) {
        traceLevel = level;
    }

    public static final void setMsgLevel(int level) {
        msgLevel = level;
    }

    public static final int msgLevel() {
        return msgLevel;
    }

    public static final OutputStream curOutputStream() {
        return TapEnv.get().curOutputStream;
    }

    public static final void setCurOutputStream(OutputStream outStream) {
        TapEnv.get().curOutputStream = outStream;
    }

    public static final void pushOutputStream(OutputStream newOutputStream) {
        TapEnv.get().flushOutputStream();
        TapEnv.get().outputStreamStack = new TapList<OutputStream>(newOutputStream, TapEnv.get().outputStreamStack);
        TapEnv.get().curOutputStream = newOutputStream;
    }

    public static final void popOutputStream() {
        TapEnv.get().flushOutputStream();
        if (TapEnv.get().outputStreamStack.tail != null) {
            TapEnv.get().outputStreamStack = TapEnv.get().outputStreamStack.tail;
        }
        TapEnv.get().curOutputStream = (OutputStream)TapEnv.get().outputStreamStack.head;
    }

    public static final void closeOutputStream() {
        if (TapEnv.get().curOutputStream != System.out) {
            try {
                TapEnv.get().curOutputStream.close();
            }
            catch (IOException e) {
                System.out.println("OutputStream broken " + e);
            }
        }
    }

    public static final void printOnTrace(int level, String str) {
        if (level <= traceLevel) {
            TapEnv.printOnTrace(str);
        }
    }

    public static final void printlnOnTrace(int level, String str) {
        if (level <= traceLevel) {
            TapEnv.printlnOnTrace(str);
        }
    }

    public static final void printlnOnTrace(int level) {
        if (level <= traceLevel) {
            TapEnv.printlnOnTrace();
        }
    }

    public static final void indentprintlnOnTrace(String str) {
        TapEnv.indentOnTrace();
        TapEnv.printlnOnTrace(str);
    }

    public static final void indentprintlnOnTrace() {
        TapEnv.indentOnTrace();
        TapEnv.printlnOnTrace();
    }

    public static final void indentprintOnTrace(String str) {
        TapEnv.indentOnTrace();
        TapEnv.printOnTrace(str);
    }

    public static final void printlnOnTrace(String str) {
        TapEnv.printOnTrace(str + System.lineSeparator());
    }

    public static final void printlnOnTrace() {
        TapEnv.printOnTrace(System.lineSeparator());
    }

    public static final void printOnTrace(String str) {
        TapEnv.pushOutputStream(TapEnv.get().traceOutputStream);
        try {
            TapEnv.print(str);
        }
        catch (IOException e) {
            System.out.println("OutputStream for trace broken " + e);
        }
        TapEnv.popOutputStream();
    }

    public static final void printOnDump(String str) {
        TapEnv.pushOutputStream(TapEnv.get().dumpOutputStream);
        try {
            TapEnv.print(str);
        }
        catch (IOException e) {
            System.out.println("OutputStream for dump broken " + e);
        }
        TapEnv.popOutputStream();
    }

    public static final void dumpOnTrace(Object obj) {
        TapEnv.pushOutputStream(TapEnv.get().traceOutputStream);
        try {
            TapEnv.dumpObject(obj);
        }
        catch (IOException e) {
            System.out.println("OutputStream for trace broken " + e);
        }
        TapEnv.popOutputStream();
    }

    public static final void dumpBoolMatrixOnTrace(BoolMatrix boolMatrix, int[] rowMap, int[] colMap) {
        if (rowMap == null) {
            rowMap = new int[]{0, boolMatrix.nRows};
        }
        if (colMap == null) {
            colMap = new int[]{0, boolMatrix.nCols};
        }
        TapEnv.pushOutputStream(TapEnv.get().traceOutputStream);
        try {
            if (boolMatrix == null) {
                TapEnv.print("null");
            } else {
                boolMatrix.dump(rowMap, colMap);
            }
        }
        catch (IOException e) {
            System.out.println("OutputStream for dump broken " + e);
        }
        TapEnv.popOutputStream();
    }

    public static final void systemError(String message) {
        TapEnv.get().emitMessage(-1, null, "System: " + message, 0);
    }

    public static final void systemWarning(int inverseSeverity, String message) {
        TapEnv.get().emitMessage(-1, null, "System: " + message, inverseSeverity);
    }

    public static final void toolError(String message) {
        TapEnv.get().emitMessage(-1, null, "Tool: " + message, 0);
    }

    public static final void toolWarning(int inverseSeverity, String message) {
        TapEnv.get().emitMessage(-1, null, "Tool: " + message, inverseSeverity);
    }

    public static final void commandWarning(int inverseSeverity, String message) {
        TapEnv.get().emitMessage(-1, null, "Command: " + message, inverseSeverity);
    }

    public static final void parserError(String message) {
        TapEnv.get().hasParsingError = true;
        TapEnv.get().emitMessage(-1, null, "File: " + message, 0);
    }

    public static final void fileError(Tree tree, String message) {
        Unit relUnit = TapEnv.get().relatedUnit;
        if (tree == null && relUnit != null) {
            if (relUnit.entryBlock() != null && relUnit.entryBlock().headInstr() != null) {
                tree = relUnit.entryBlock().headInstr().tree;
            } else if (relUnit.isModule()) {
                tree = relUnit.parametersOrModuleNameTree;
            }
        }
        int position = tree == null ? -1 : ILUtils.position(tree);
        TapEnv.get().emitMessage(position, tree, message, 0);
    }

    public static final void fileWarning(int inverseSeverity, int position, String message) {
        TapEnv.get().emitMessage(position, null, message, inverseSeverity);
    }

    public static final void fileWarning(int inverseSeverity, Tree tree, String message) {
        Unit relUnit = TapEnv.get().relatedUnit;
        if (tree == null && relUnit != null) {
            if (relUnit.entryBlock() != null && relUnit.entryBlock().headInstr() != null) {
                tree = relUnit.entryBlock().headInstr().tree;
            } else if (relUnit.isModule()) {
                tree = relUnit.parametersOrModuleNameTree;
            }
        }
        int position = tree == null ? -1 : ILUtils.position(tree);
        TapEnv.get().emitMessage(position, tree, message, inverseSeverity);
    }

    public static final void addMessageAnnotation(Tree tree, String displayMessage) {
        if (tree != null) {
            TapList<String> msgTty = (TapList<String>)tree.getAnnotation("message");
            if (msgTty == null) {
                msgTty = new TapList<String>(displayMessage, null);
                tree.setAnnotation("message", msgTty);
            } else {
                TapList<String> tailMsg = msgTty;
                while (msgTty != null) {
                    tailMsg = msgTty;
                    msgTty = msgTty.tail;
                }
                tailMsg.placdl(displayMessage);
            }
        }
    }

    public static final TapList<PositionAndMessage> getAllMessages(CallGraph origCallGraph, CallGraph diffCallGraph, TapList<Unit> transformedUnits, boolean showMessagesOfAllUnits) {
        TapList<Object> hdAllMessages;
        TapList<Object> tlAllMessages = hdAllMessages = new TapList<Object>(null, null);
        TapList messagesList = TapEnv.get().danglingMessages.tail;
        while (messagesList != null) {
            tlAllMessages = tlAllMessages.placdl(messagesList.head);
            messagesList = messagesList.tail;
        }
        if (origCallGraph != null) {
            tlAllMessages = TapEnv.getMessages(tlAllMessages, origCallGraph, transformedUnits, showMessagesOfAllUnits);
        }
        if (diffCallGraph != null) {
            tlAllMessages = TapEnv.getMessages(tlAllMessages, diffCallGraph, transformedUnits, true);
        }
        return hdAllMessages.tail;
    }

    private static final TapList<PositionAndMessage> getMessages(TapList<PositionAndMessage> tlAllMessages, CallGraph callGraph, TapList<Unit> transformedUnits, boolean showMessagesOfAllUnits) {
        if (callGraph != null) {
            TapList<Unit> allUnits = callGraph.sortedUnits();
            if (allUnits == null) {
                allUnits = callGraph.units();
            }
            allUnits = TapList.append(allUnits, callGraph.intrinsicUnits());
            allUnits = TapList.append(allUnits, callGraph.interfaceUnits());
            while (allUnits != null) {
                boolean showMsgOfUnit;
                Unit unit = (Unit)allUnits.head;
                boolean bl = showMsgOfUnit = showMessagesOfAllUnits || TapList.contains(transformedUnits, unit) || unit.isInterface() || traceLevel > 0;
                if (showMsgOfUnit) {
                    tlAllMessages = TapEnv.getOneMessage(callGraph, unit, tlAllMessages);
                    if (traceLevel <= 0 && !showMessagesOfAllUnits) {
                        unit.messages.tail = null;
                    }
                }
                allUnits = allUnits.tail;
            }
        }
        return tlAllMessages;
    }

    private static final TapList<PositionAndMessage> getOneMessage(CallGraph callGraph, Unit unit, TapList<PositionAndMessage> tlAllMessages) {
        TapList messagesList = unit.messages.tail;
        while (messagesList != null) {
            PositionAndMessage pm = (PositionAndMessage)messagesList.head;
            if (pm.unit() != null && !pm.unit().name().equals(unit.name())) {
                pm = new PositionAndMessage(pm);
            }
            if (!unit.isExternal()) {
                Unit curUnit = unit;
                if (curUnit.origUnit != null) {
                    curUnit = curUnit.origUnit;
                }
                while (!curUnit.isTopInFile() && curUnit.upperLevelUnit() != null) {
                    curUnit = curUnit.upperLevelUnit();
                }
                pm.setUnit(unit);
                String curUnitName = curUnit.name();
                if (curUnit.translationUnitSymbolTable() != null) {
                    curUnitName = curUnit.translationUnitSymbolTable().containerFileName;
                }
                pm.fileName = callGraph == TapEnv.get().origCallGraph() || unit.origUnit != null ? curUnitName + TapEnv.get().preprocessFileSuffix : curUnitName;
            }
            tlAllMessages = tlAllMessages.placdl(pm);
            messagesList = messagesList.tail;
        }
        return tlAllMessages;
    }

    public static final void saveAllMessagesAsText(TapList<PositionAndMessage> msgs, String msgFileName) {
        File file = new File(msgFileName);
        if (file.exists() && !file.renameTo(new File(msgFileName + '~'))) {
            TapEnv.printlnOnTrace("Could not open output file " + msgFileName + '~');
        }
        try {
            OutputStream textFile = Files.newOutputStream(Paths.get(msgFileName, new String[0]), new OpenOption[0]);
            TapEnv.pushOutputStream(textFile);
            int nbMsg = 1;
            while (msgs != null) {
                String unitName;
                PositionAndMessage pm = (PositionAndMessage)msgs.head;
                String message = pm.message();
                String string = unitName = pm.unit() == null ? "" : pm.unit().name();
                if (unitName != null && !unitName.isEmpty()) {
                    message = unitName + ": " + message;
                }
                TapEnv.println(nbMsg + " " + message);
                msgs = msgs.tail;
                ++nbMsg;
            }
            textFile.close();
        }
        catch (IOException e) {
            System.out.println("OutputStream for messages in text file broken " + e);
        }
        TapEnv.popOutputStream();
    }

    public static final void saveAllMessagesAsHTML(TapList<PositionAndMessage> msgs, String msgFileName, String cssDir, String htmlDirectory, String outputFileName, boolean hasGlobalDeclarations, String preprocessSuffix) {
        String name = "";
        String unitName = "";
        int nbMsg = 1;
        try {
            OutputStream htmlFile = Files.newOutputStream(Paths.get(msgFileName, new String[0]), new OpenOption[0]);
            TapEnv.pushOutputStream(htmlFile);
            TapEnv.println("<!DOCTYPE html>");
            TapEnv.println("<title>Generated by TAPENADE</title>");
            TapEnv.println(bootstrapCss);
            TapEnv.println("<link type=\"text/CSS\" rel=\"stylesheet\" href=\"" + cssDir + "tapenade.css\">");
            TapEnv.println("<body>");
            TapEnv.println();
            TapEnv.println("<pre>");
            while (msgs != null) {
                if (((PositionAndMessage)msgs.head).tags.second != null) {
                    TapEnv.print("<a name=\"" + (String)((PositionAndMessage)msgs.head).tags.second + "\"></a>");
                }
                Unit unit = ((PositionAndMessage)msgs.head).unit();
                String thisMsgTarget = TapEnv.stripPath(((PositionAndMessage)msgs.head).fileName);
                if (unit != null) {
                    unitName = unit.shortName() + ": ";
                }
                if (outputFileName != null && !outputFileName.isEmpty()) {
                    name = outputFileName + preprocessSuffix + TapEnv.getLangSuffix(unit);
                } else if (!thisMsgTarget.isEmpty()) {
                    name = thisMsgTarget + TapEnv.getLangSuffix(unit);
                }
                if (hasGlobalDeclarations && name.isEmpty()) {
                    name = "GlobalDeclarations_p";
                }
                String message = ((PositionAndMessage)msgs.head).message();
                if (!name.isEmpty()) {
                    TapEnv.print(nbMsg + " " + unitName);
                    TapEnv.print(TapEnv.faqLink(message));
                    String targetAnchor = (String)((PositionAndMessage)msgs.head).tags.first;
                    TapEnv.println("<a href=\"" + htmlDirectory + name + ".html" + (targetAnchor == null ? "" : "#" + targetAnchor) + "\" target=\"origFile\">" + TapEnv.norefman(message) + "</a>");
                } else {
                    TapEnv.print(nbMsg + " " + TapEnv.faqLink(message));
                    TapEnv.println(unitName + TapEnv.norefman(message));
                }
                msgs = msgs.tail;
                ++nbMsg;
            }
            TapEnv.println("</pre>");
            TapEnv.println("</body>");
            htmlFile.close();
        }
        catch (IOException e) {
            System.out.println("OutputStream for messages in HTML file broken " + e);
        }
        TapEnv.popOutputStream();
    }

    private static final String getLangSuffix(Unit unit) {
        String langSuffix;
        if (unit == null) {
            Unit translationUnit = null;
            boolean ok = false;
            TapList<SymbolTable> tuSTs = TapEnv.get().origCallGraph().getTranslationUnitSymbolTables();
            while (!ok && tuSTs != null) {
                translationUnit = ((SymbolTable)tuSTs.head).unit;
                ok = !translationUnit.isPredefinedModuleOrTranslationUnit();
                tuSTs = tuSTs.tail;
            }
            assert (translationUnit != null);
            langSuffix = TapEnv.outputExtension(translationUnit.language());
        } else {
            langSuffix = TapEnv.outputExtension(unit.language());
        }
        return langSuffix;
    }

    private static final String faqLink(String message) {
        String result = "";
        if (message.matches(".*\\([A-Z][A-Z]\\d\\d\\).*")) {
            int first = message.indexOf(40);
            int last = message.indexOf(41, first);
            String errorStr = message.substring(first + 1, last);
            result = "<a href=\"http://www-sop.inria.fr/ecuador/tapenade/userdoc/build/html/tapenade/faq.html#" + errorStr + "\" target= \"_blank\">(" + errorStr + ")</a> ";
        }
        return result;
    }

    private static final String norefman(String message) {
        String result = message;
        if (message.matches(".*\\([A-Z][A-Z]\\d\\d\\).*")) {
            result = message.substring(message.indexOf(41) + 2);
        }
        return result;
    }

    public static final void print(String str) throws IOException {
        TapEnv.get().curOutputStream.write(str.getBytes(StandardCharsets.UTF_8));
    }

    public static final void println(String str) throws IOException {
        TapEnv.get().curOutputStream.write((str + System.lineSeparator()).getBytes(StandardCharsets.UTF_8));
    }

    public static final void println() throws IOException {
        TapEnv.get().curOutputStream.write(System.lineSeparator().getBytes(StandardCharsets.UTF_8));
    }

    public static final int traceIndent() {
        return TapEnv.get().traceIndent;
    }

    public static final void setTraceIndent(int amount) {
        TapEnv.get().traceIndent = amount;
    }

    public static final void incrTraceIndent(int delta) {
        TapEnv.get().traceIndent += delta;
    }

    public static final void decrTraceIndent(int delta) {
        TapEnv.get().traceIndent -= delta;
    }

    public static final void indentOnTrace(int amount) {
        TapEnv.pushOutputStream(TapEnv.get().traceOutputStream);
        try {
            TapEnv.indent(amount);
        }
        catch (IOException e) {
            System.out.println("OutputStream for trace broken " + e);
        }
        TapEnv.popOutputStream();
    }

    public static final void indentOnTrace() {
        TapEnv.pushOutputStream(TapEnv.get().traceOutputStream);
        try {
            TapEnv.indent(TapEnv.get().traceIndent);
        }
        catch (IOException e) {
            System.out.println("OutputStream for trace broken " + e);
        }
        TapEnv.popOutputStream();
    }

    public static final void indent(int indent) throws IOException {
        StringBuilder whites = new StringBuilder();
        for (int i = indent; i > 0; --i) {
            whites.append(' ');
        }
        TapEnv.get().curOutputStream.write(whites.toString().getBytes(StandardCharsets.UTF_8));
    }

    public static final void indentPrint(int indent, String str) throws IOException {
        TapEnv.indent(indent);
        TapEnv.get().curOutputStream.write(str.getBytes(StandardCharsets.UTF_8));
    }

    public static final void indentPrintln(int indent, String str) throws IOException {
        TapEnv.indent(indent);
        TapEnv.get().curOutputStream.write((str + System.lineSeparator()).getBytes(StandardCharsets.UTF_8));
    }

    public static final void printlnMappedBoolVector(String text, BoolVector boolVector, int[] map, String mapName) throws IOException {
        TapEnv.print(text);
        TapEnv.dumpBoolVector(boolVector, map, mapName);
        TapEnv.println();
    }

    public static final void printlnMappedBoolVectorWithDiffPtr(String text, TapPair<BoolVector, BoolVector> boolVectorPair, int[] map, String mapName, int[] ptrMap, String ptrMapName) throws IOException {
        TapEnv.printlnMappedBoolVectorWithDiffPtr(text, boolVectorPair == null ? null : (BoolVector)boolVectorPair.first, map, mapName, boolVectorPair == null ? null : (BoolVector)boolVectorPair.second, ptrMap, ptrMapName);
    }

    public static final void printlnMappedBoolVectorWithDiffPtr(String text, BoolVector boolVector, int[] map, String mapName, BoolVector ptrBoolVector, int[] ptrMap, String ptrMapName) throws IOException {
        TapEnv.print(text);
        TapEnv.dumpBoolVector(boolVector, map, mapName);
        TapEnv.print(" Ptr:");
        TapEnv.dumpBoolVector(ptrBoolVector, ptrMap, ptrMapName);
        TapEnv.println();
    }

    public static final void dumpBoolVector(BoolVector boolVector, int[] map, String mapName) throws IOException {
        if (boolVector == null) {
            TapEnv.print("null");
        } else {
            TapEnv.print(mapName + " ");
            if (boolVector.isFalse(map[map.length - 1])) {
                TapEnv.print("empty");
            } else {
                boolVector.dump(map);
            }
        }
    }

    public static final void dumpObject(Object object) throws IOException {
        if (object == null) {
            TapEnv.print("null");
        } else if (object instanceof Object[]) {
            Object[] array = (Object[])object;
            TapEnv.print("{");
            for (int i = 0; i < array.length; ++i) {
                TapEnv.dumpObject(array[i]);
                if (i >= array.length - 1) continue;
                TapEnv.print(" ; ");
            }
            TapEnv.print("}");
        } else if (object instanceof Boolean || object instanceof Integer) {
            TapEnv.print(object.toString());
        } else if (object instanceof String) {
            TapEnv.print((String)object);
        } else if (object instanceof BoolVector) {
            TapEnv.print(((BoolVector)object).toString());
        } else if (object instanceof BoolMatrix) {
            ((BoolMatrix)object).dump();
        } else if (object instanceof Tree) {
            ILUtils.dump((Tree)object, 0);
        } else if (object instanceof CallGraph) {
            ((CallGraph)object).dump(0);
        } else if (object instanceof Unit) {
            ((Unit)object).dump(0);
        } else if (object instanceof Block) {
            ((Block)object).dump(0);
        } else if (object instanceof BlockStorage) {
            ((BlockStorage)object).dump();
        } else if (object instanceof FGArrow) {
            ((FGArrow)object).dump();
        } else if (object instanceof Instruction) {
            ((Instruction)object).dump();
        } else if (object instanceof SymbolTable) {
            ((SymbolTable)object).dump(0);
        } else if (object instanceof SymbolDecl) {
            ((SymbolDecl)object).dump(0);
        } else if (object instanceof ArrayDim) {
            ((ArrayDim)object).dump();
        } else if (object instanceof WrapperTypeSpec) {
            ((WrapperTypeSpec)object).dump();
        } else if (object instanceof TypeSpec) {
            ((TypeSpec)object).dump();
        } else if (object instanceof ZoneInfo) {
            ((ZoneInfo)object).dump();
        } else if (object instanceof PublicInfo) {
            ((PublicInfo)object).dump();
        } else if (object instanceof ControlStruct) {
            ((ControlStruct)object).dump(0);
        } else if (object instanceof TapList) {
            ((TapList)object).dump();
        } else if (object instanceof TapIntList) {
            ((TapIntList)object).dump();
        } else if (object instanceof InstructionMask) {
            ((InstructionMask)object).dump();
        } else {
            TapEnv.println("Don't know how to dump objects of this type: " + object);
        }
    }

    public static final void resetSeenSymbolTables() {
        TapEnv.get().seenSymbolTables = null;
    }

    public static final String getSeenSymbolTableShortName(SymbolTable symbolTable) {
        return (String)TapList.cassq(symbolTable, TapEnv.get().seenSymbolTables);
    }

    protected static final void dumpSymbolTableIfNew(SymbolTable symbolTable, int indent) throws IOException {
        if (symbolTable == null) {
            TapEnv.println("NULL SymbolTable");
        } else if (TapEnv.getSeenSymbolTableShortName(symbolTable) != null) {
            TapEnv.println("already seen " + symbolTable.shortName() + " (" + symbolTable.addressChain() + ')');
        } else {
            TapEnv.println();
            symbolTable.dump(indent + 4);
            TapEnv.println();
            TapEnv.get().seenSymbolTables = new TapList<TapPair<SymbolTable, String>>(new TapPair<SymbolTable, String>(symbolTable, "seen"), TapEnv.get().seenSymbolTables);
        }
    }

    public static final String stripPath(String completeFileName) {
        try {
            return new File(completeFileName).getName();
        }
        catch (NullPointerException e) {
            TapEnv.printlnOnTrace(e.toString());
            return "xxx?";
        }
    }

    public static final String stripLanguageExtension(String fileName) {
        int dotPos = fileName.lastIndexOf(46);
        if (dotPos >= 0) {
            fileName = fileName.substring(0, dotPos);
        }
        return fileName;
    }

    public static final boolean stringContainedIn(String str, String[] strings) {
        boolean found = false;
        for (int i = strings.length - 1; !found && i > 0; --i) {
            found = strings[i].equals(str);
        }
        return found;
    }

    public static final String str3(int i) {
        if (i > 99) {
            return "" + i;
        }
        if (i > 9) {
            return " " + i;
        }
        return "  " + i;
    }

    public static final void tapenadeExit(int exitCode) {
        if (!isServlet) {
            if (exitCode != 0) {
                TapEnv.printlnOnTrace("tapenade: Differentiation failed");
            }
            System.exit(exitCode);
        }
    }

    static {
        tapEnvForThread = new ThreadLocal<TapEnvForThread>(){

            @Override
            protected TapEnvForThread initialValue() {
                return new TapEnvForThread();
            }
        };
        traceLevel = 0;
        msgLevel = 10;
    }
}

