/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.representation;

import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.SymbolDecl;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.TypeSpec;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.representation.WrapperTypeSpec;
import fr.inria.tapenade.utils.TapPair;
import fr.inria.tapenade.utils.Tree;
import java.io.IOException;

public final class ReferenceTypeSpec
extends TypeSpec {
    public TypeSpec destinationType;
    public TapList<String> subAccess;

    public ReferenceTypeSpec(TypeSpec destinationType) {
        super(22);
        this.destinationType = destinationType;
    }

    @Override
    public TypeSpec wrappedType() {
        return this.destinationType;
    }

    @Override
    public void setWrappedType(TypeSpec type) {
        this.destinationType = type instanceof WrapperTypeSpec ? (WrapperTypeSpec)type : new WrapperTypeSpec(type);
    }

    @Override
    public TypeSpec nestedLevelType() {
        return this.destinationType;
    }

    @Override
    protected String baseTypeName() {
        return "Reference";
    }

    @Override
    public WrapperTypeSpec baseTypeSpec(boolean stopOnPointer) {
        return this.destinationType == null ? null : this.destinationType.baseTypeSpec(stopOnPointer);
    }

    @Override
    protected boolean testComparesWith(TypeSpec other, int comparison, TypeSpec toThis, TypeSpec toOther, TapList<TapPair<TypeSpec, TypeSpec>> dejaVu) {
        if ((toOther = this.peelWrapperAndModifiedTo(other, toOther)) != null) {
            other = toOther.wrappedType();
        }
        if (this == other) {
            return true;
        }
        if (other == null) {
            if (ReferenceTypeSpec.testHasInference(comparison)) {
                if (toOther != null) {
                    toOther.setWrappedType(this);
                }
                return true;
            }
            return false;
        }
        if (!(other instanceof ReferenceTypeSpec)) {
            return false;
        }
        ReferenceTypeSpec otherReference = (ReferenceTypeSpec)other;
        if (TapList.containsObjectPair(dejaVu, this.destinationType, otherReference.destinationType)) {
            return true;
        }
        boolean comparesWell = true;
        if (this.destinationType == null) {
            if (ReferenceTypeSpec.testHasInference(comparison)) {
                this.setWrappedType(otherReference.destinationType == null ? null : otherReference.destinationType.weakenForInference(comparison));
            } else {
                comparesWell = ReferenceTypeSpec.testAcceptsUnspecified(comparison);
            }
        } else if (otherReference.destinationType == null) {
            if (ReferenceTypeSpec.testHasInference(comparison)) {
                otherReference.setWrappedType(this.destinationType);
            } else {
                comparesWell = false;
            }
        } else {
            comparesWell = this.destinationType.comparesWith(otherReference.destinationType, comparison, this, otherReference, new TapList<TapPair<TypeSpec, TypeSpec>>(new TapPair<TypeSpec, TypeSpec>(this.destinationType, otherReference.destinationType), dejaVu));
        }
        return comparesWell;
    }

    @Override
    public void updateAfterImports(SymbolTable symbolTable, TapList<TypeSpec> dejaVu) {
        if (this.destinationType != null) {
            this.destinationType.updateAfterImports(symbolTable, dejaVu);
        }
    }

    @Override
    public TypeSpec copyStopOnComposite(Unit publishedUnit) {
        TypeSpec copyDestination = this.destinationType == null ? null : this.destinationType.copyStopOnComposite(publishedUnit);
        return copyDestination == this.destinationType ? this : new ReferenceTypeSpec(copyDestination);
    }

    @Override
    public Tree generateTree(SymbolTable symbolTable, TapList<SymbolDecl> dependsOn, TapList<SymbolDecl> shortNames, boolean useShortNames, TapList<TypeSpec> dejaVu) {
        if (TapList.contains(dejaVu, this)) {
            TapEnv.toolWarning(-1, "(TypeSpec tree regeneration) circular type");
            return ILUtils.build(96, "CircularType");
        }
        this.destinationType = ((WrapperTypeSpec)this.destinationType).equalsDiffTypeSpecAndTypeSpec();
        dejaVu = new TapList<TypeSpec>(this, dejaVu);
        Tree result = this.destinationType.generateTree(symbolTable, dependsOn, shortNames, true, dejaVu);
        result = ReferenceTypeSpec.addTypeModifiers(result, ILUtils.buildListIdents(this.subAccess));
        return ILUtils.build(164, result);
    }

    @Override
    public String showType() {
        int language = TapEnv.relatedUnit() != null ? TapEnv.relatedUnit().language() : -1;
        return (this.destinationType == null ? "?" : this.destinationType.showType()) + (TapEnv.isFortran(language) ? " REFERENCE" : "&");
    }

    @Override
    public void dump() throws IOException {
        TapEnv.print(this.toString());
    }

    @Override
    public String toString() {
        return (this.typeDeclName() == null ? "" : "\"" + this.typeDeclName() + "\":") + "ref to " + (this.subAccess == null ? "" : " " + this.subAccess) + (this.destinationType == null ? "?" : this.destinationType.toString());
    }
}

