/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.representation;

import fr.inria.tapenade.representation.ArrayDim;
import fr.inria.tapenade.representation.ArrayDimPlusIter;
import fr.inria.tapenade.representation.ArrayTypeSpec;
import fr.inria.tapenade.representation.CallGraph;
import fr.inria.tapenade.representation.CompositeTypeSpec;
import fr.inria.tapenade.representation.FieldDecl;
import fr.inria.tapenade.representation.FunctionDecl;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.Instruction;
import fr.inria.tapenade.representation.IterDescriptor;
import fr.inria.tapenade.representation.MixedLanguageInfos;
import fr.inria.tapenade.representation.ModifiedTypeSpec;
import fr.inria.tapenade.representation.NewSymbolHolder;
import fr.inria.tapenade.representation.PointerTypeSpec;
import fr.inria.tapenade.representation.PrimitiveTypeSpec;
import fr.inria.tapenade.representation.SymbolDecl;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.TypeDecl;
import fr.inria.tapenade.representation.TypeSpec;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.representation.VariableDecl;
import fr.inria.tapenade.representation.VoidTypeSpec;
import fr.inria.tapenade.representation.WrapperTypeSpec;
import fr.inria.tapenade.representation.ZoneInfo;
import fr.inria.tapenade.utils.TapPair;
import fr.inria.tapenade.utils.ToBool;
import fr.inria.tapenade.utils.Tree;

public final class RefDescriptor {
    private static final int PUSHPOP = 1;
    private static final int CALL = 2;
    private static final int INIT = 3;
    private static final int ASSIGN = 4;
    public WrapperTypeSpec completeType;
    public WrapperTypeSpec elementType;
    public Tree altRootIdent;
    public boolean holdsAPointer;
    public boolean mayProtectAccesses = true;
    public TapPair<NewSymbolHolder, WrapperTypeSpec> toBranchVariable;
    public ZoneInfo zoneInfo;
    private final SymbolTable defSymbolTable;
    private final SymbolTable usageSymbolTable;
    private final SymbolTable otherUsageSymbolTable;
    private Unit targetUnit;
    private final WrapperTypeSpec integerTypeSpec;
    private Tree patternTree;
    private WrapperTypeSpec knownRootTypeSpec;
    private WrapperTypeSpec forceRootTypeSpec;
    private IterDescriptor[] itersMemo;
    private int itersMemoNextRk;
    private final IterDescriptor multiDirIterator;
    private final boolean isDiff;
    private Tree nonDiffRootIdent;
    private Tree diffRootIdent;
    private NestedLoopNode nestedLoopTree;
    private int nbControls;
    private boolean scalarIndices;
    private RefDescriptor companionVarDescriptor;
    private int ppLabel = -1;
    private int futureUse = -1;
    private Tree hintRootTree;
    private Tree hintArrayTreeForCallSize;

    public RefDescriptor(Tree tree, WrapperTypeSpec type, WrapperTypeSpec expectedType, Tree hintRootTree, SymbolTable defSymbolTable, SymbolTable usageSymbolTable, SymbolTable otherUsageSymbolTable, Tree altRootIdent, boolean isDiff, IterDescriptor multiDirIterator, Unit targetUnit) {
        this.defSymbolTable = defSymbolTable;
        this.usageSymbolTable = usageSymbolTable;
        this.otherUsageSymbolTable = otherUsageSymbolTable;
        this.integerTypeSpec = defSymbolTable.getTypeDecl((String)"integer").typeSpec;
        this.targetUnit = targetUnit;
        this.multiDirIterator = multiDirIterator;
        this.isDiff = isDiff;
        this.altRootIdent = altRootIdent;
        if (type == null) {
            this.knownRootTypeSpec = expectedType;
        } else {
            tree = RefDescriptor.explicitWhenImplicitArray(tree, type, expectedType, defSymbolTable);
        }
        this.hintRootTree = hintRootTree;
        this.initialize(tree, altRootIdent);
    }

    public RefDescriptor(Tree tree, WrapperTypeSpec forcedType, Tree hintRootTree, SymbolTable defSymbolTable, SymbolTable usageSymbolTable, SymbolTable otherUsageSymbolTable, Tree altRootIdent, boolean isDiff, IterDescriptor multiDirIterator, Unit targetUnit) {
        this.defSymbolTable = defSymbolTable;
        this.usageSymbolTable = usageSymbolTable;
        this.otherUsageSymbolTable = otherUsageSymbolTable;
        this.integerTypeSpec = defSymbolTable.getTypeDecl((String)"integer").typeSpec;
        this.targetUnit = targetUnit;
        this.multiDirIterator = multiDirIterator;
        this.isDiff = isDiff;
        this.altRootIdent = altRootIdent;
        this.forceRootTypeSpec = forcedType;
        this.hintRootTree = hintRootTree;
        this.initialize(tree, altRootIdent);
    }

    public RefDescriptor(Tree tree, Tree hintRootTree, SymbolTable defSymbolTable, SymbolTable usageSymbolTable, SymbolTable otherUsageSymbolTable, Tree altRootIdent, boolean isDiff, IterDescriptor multiDirIterator, Unit targetUnit) {
        this.defSymbolTable = defSymbolTable;
        this.usageSymbolTable = usageSymbolTable;
        this.otherUsageSymbolTable = otherUsageSymbolTable;
        this.integerTypeSpec = defSymbolTable.getTypeDecl((String)"integer").typeSpec;
        this.targetUnit = targetUnit;
        this.multiDirIterator = multiDirIterator;
        this.isDiff = isDiff;
        this.altRootIdent = altRootIdent;
        this.hintRootTree = hintRootTree;
        this.initialize(tree, altRootIdent);
    }

    public RefDescriptor(ZoneInfo zoneInfo, Tree zoneInfoVisibleAccessTree, SymbolTable defSymbolTable, SymbolTable usageSymbolTable, SymbolTable otherUsageSymbolTable, Tree altRootIdent, boolean isDiff, IterDescriptor multiDirIterator, Unit targetUnit) {
        this.zoneInfo = zoneInfo;
        this.defSymbolTable = defSymbolTable;
        this.usageSymbolTable = usageSymbolTable;
        this.otherUsageSymbolTable = otherUsageSymbolTable;
        this.integerTypeSpec = defSymbolTable.getTypeDecl((String)"integer").typeSpec;
        this.targetUnit = targetUnit;
        this.multiDirIterator = multiDirIterator;
        this.isDiff = isDiff;
        this.altRootIdent = altRootIdent;
        this.hintArrayTreeForCallSize = zoneInfoVisibleAccessTree;
        this.initialize(zoneInfoVisibleAccessTree, altRootIdent);
    }

    public static Tree explicitWhenImplicitArray(Tree tree, WrapperTypeSpec type, WrapperTypeSpec expectedType, SymbolTable symbolTable) {
        if (tree.opCode() == 9) {
            TapList<ArrayDim> dimensions = type.getAllDimensions();
            TapList<ArrayDim> expectedDimensions = expectedType.getAllDimensions();
            if (dimensions == null && expectedDimensions != null) {
                int size = 1;
                while (expectedDimensions != null && size != -1) {
                    ArrayDim extraDimension = (ArrayDim)expectedDimensions.head;
                    int dimSize = extraDimension.size();
                    size = dimSize == -1 ? -1 : (size *= dimSize);
                    expectedDimensions = expectedDimensions.tail;
                }
                tree = ILUtils.copy(tree);
                int rank = 1;
                if (TapEnv.relatedLanguageIsFortran()) {
                    rank = tree.down(2).length();
                }
                Tree index1 = tree.down(2).cutChild(rank);
                tree.down(2).setChild(ILUtils.build(12, index1, size == -1 ? ILUtils.build(138) : ILUtils.addTree(ILUtils.copy(index1), ILUtils.build(103, size - 1)), ILUtils.build(138)), rank);
                tree.down(2).down(rank).setAnnotation("subArrayAccess", Boolean.TRUE);
            }
        }
        return tree;
    }

    private static Tree turnIterVarRefIntoTriplets(Tree tree) {
        TapList<Tree> dos = null;
        while (tree.opCode() == 110) {
            dos = new TapList<Tree>(tree.down(2), dos);
            tree = tree.down(1).down(1);
        }
        return RefDescriptor.replaceIndicesByTriplets(ILUtils.copy(tree), dos);
    }

    private static Tree replaceIndicesByTriplets(Tree tree, TapList<Tree> dos) {
        TapList<Tree> inDos = dos;
        Tree found = null;
        while (found == null && inDos != null) {
            if (((Tree)dos.head).down(1).equalsTree(tree)) {
                found = (Tree)dos.head;
            }
            inDos = inDos.tail;
        }
        if (found != null) {
            tree = ILUtils.build(12, ILUtils.copy(found.down(2)), ILUtils.copy(found.down(3)), ILUtils.copy(found.down(4)));
        } else if (!tree.isAtom()) {
            Tree[] sons = tree.children();
            for (int i = sons.length - 1; i >= 0; --i) {
                Tree newSon = RefDescriptor.replaceIndicesByTriplets(sons[i], dos);
                if (newSon == sons[i]) continue;
                tree.setChild(newSon, i + 1);
            }
        }
        return tree;
    }

    private static Tree removeDerefOfAddress(Tree expr) {
        if (expr != null) {
            if (expr.opCode() == 151 && ILUtils.isNullOrNone(expr.down(2)) && expr.down(1).opCode() == 4) {
                expr = RefDescriptor.removeDerefOfAddress(expr.down(1).cutChild(1));
            } else if (!expr.isAtom()) {
                Tree[] subTrees = expr.children();
                for (int i = subTrees.length - 1; i >= 0; --i) {
                    Tree newSubTree = RefDescriptor.removeDerefOfAddress(subTrees[i]);
                    if (newSubTree == subTrees[i]) continue;
                    expr.setChild(newSubTree, i + 1);
                }
            }
        }
        return expr;
    }

    private static void synchronizeDoIterators(WrapperTypeSpec ts1, WrapperTypeSpec ts2) {
        while (ts1 != null && ts1.wrappedType != null && ts1.wrappedType.kind() == 5) {
            ts1 = ts1.wrappedType.elementType();
        }
        while (ts2 != null && ts2.wrappedType != null && ts2.wrappedType.kind() == 5) {
            ts2 = ts2.wrappedType.elementType();
        }
        assert (ts1 != null);
        assert (ts2 != null);
        switch (ts1.wrappedType.kind()) {
            case 2: {
                if (ts2.wrappedType.kind() != 2) break;
                ArrayTypeSpec ats1 = (ArrayTypeSpec)ts1.wrappedType;
                ArrayTypeSpec ats2 = (ArrayTypeSpec)ts2.wrappedType;
                ArrayDim[] dl1 = ats1.dimensions();
                ArrayDim[] dl2 = ats2.dimensions();
                for (int i = dl1.length - 1; i >= 0; --i) {
                    if (dl1[i] == null || i >= dl2.length || dl2[i] == null) continue;
                    ((ArrayDimPlusIter)dl1[i]).iter.setInitTree(((ArrayDimPlusIter)dl2[i]).iter.getInitTree());
                    ((ArrayDimPlusIter)dl1[i]).iter.indexHolder = ((ArrayDimPlusIter)dl2[i]).iter.indexHolder;
                }
                RefDescriptor.synchronizeDoIterators(ats1.elementType(), ats2.elementType());
                break;
            }
            case 21: {
                CompositeTypeSpec cts1 = (CompositeTypeSpec)ts1.wrappedType;
                CompositeTypeSpec cts2 = (CompositeTypeSpec)ts2.wrappedType;
                FieldDecl[] fl1 = cts1.fields;
                FieldDecl[] fl2 = cts2.fields;
                for (int i = fl1.length - 1; i >= 0; --i) {
                    if (fl1[i] == null || i >= fl2.length || fl2[i] == null) continue;
                    RefDescriptor.synchronizeDoIterators(fl1[i].type(), fl2[i].type());
                }
                break;
            }
            case 6: {
                PointerTypeSpec pts1 = (PointerTypeSpec)ts1.wrappedType;
                PointerTypeSpec pts2 = (PointerTypeSpec)ts2.wrappedType;
                ArrayDim dim1 = pts1.offsetLength;
                ArrayDim dim2 = pts2.offsetLength;
                if (dim1 == null || dim2 == null) break;
                ((ArrayDimPlusIter)dim1).iter.setInitTree(((ArrayDimPlusIter)dim2).iter.getInitTree());
                ((ArrayDimPlusIter)dim1).iter.indexHolder = ((ArrayDimPlusIter)dim2).iter.indexHolder;
                break;
            }
        }
    }

    private static boolean allDimensionsFull(ArrayDim[] dimensions) {
        boolean allFull = true;
        for (int i = dimensions.length - 1; i >= 0; --i) {
            if (((ArrayDimPlusIter)dimensions[i]).iter.isImplicitCompleteDimension) continue;
            allFull = false;
        }
        return allFull;
    }

    private static boolean subArrayAccess(ArrayDim[] dimensions) {
        return dimensions.length == 1 && ((ArrayDimPlusIter)dimensions[0]).iter.allSubArrayAccesses;
    }

    private static boolean isSameTSorActualTS(WrapperTypeSpec typeSpec, WrapperTypeSpec elemTypeSpec) {
        return typeSpec == elemTypeSpec || typeSpec != null && elemTypeSpec != null && typeSpec.wrappedType != null && typeSpec.wrappedType == elemTypeSpec.wrappedType;
    }

    private static TapList<Tree> collectTreesRec(NestedLoopNode node, TapList<Tree> collected) {
        if (node.nodes != null) {
            TapList nodes = node.nodes;
            while (nodes != null) {
                collected = RefDescriptor.collectTreesRec((NestedLoopNode)nodes.head, collected);
                nodes = nodes.tail;
            }
        } else {
            collected = new TapList<Tree>(node.expression, collected);
        }
        return collected;
    }

    public static Tree makeInitialize(Unit targetUnit, Tree expr, WrapperTypeSpec actualArgType, WrapperTypeSpec formalArgType, Tree hintRootTree, SymbolTable defSymbolTable, SymbolTable usageSymbolTable, SymbolTable otherUsageSymbolTable, Tree altRootIdent, boolean isDiff, IterDescriptor multiDirIterator, ZoneInfo fromZoneInfo, boolean protectAccesses, TapList ignoreStructure, boolean ignorePointed) {
        RefDescriptor refDescriptor = new RefDescriptor(expr, actualArgType, formalArgType, hintRootTree, defSymbolTable, usageSymbolTable, otherUsageSymbolTable, altRootIdent, isDiff, multiDirIterator, targetUnit);
        if (fromZoneInfo != null) {
            refDescriptor.zoneInfo = fromZoneInfo;
        }
        refDescriptor.setHintArrayTreeForCallSize(hintRootTree);
        refDescriptor.prepareForInitialize(targetUnit, ignoreStructure, ignorePointed);
        refDescriptor.mayProtectAccesses = protectAccesses;
        Tree result = refDescriptor.makeInitialize();
        return result;
    }

    public static Tree makeNormDiff(Unit targetUnit, Tree cumulTree, Tree newExpr, Tree oldExpr, SymbolTable defSymbolTable, SymbolTable usageSymbolTable, Tree newAltRootIdent, Tree oldAltRootIdent, boolean isDiff, IterDescriptor multiDirIterator) {
        RefDescriptor oldRefDescriptor = new RefDescriptor(oldExpr, null, defSymbolTable, usageSymbolTable, null, oldAltRootIdent, isDiff, multiDirIterator, targetUnit);
        RefDescriptor newRefDescriptor = new RefDescriptor(newExpr, null, defSymbolTable, usageSymbolTable, null, newAltRootIdent, isDiff, multiDirIterator, targetUnit);
        oldRefDescriptor.setCompanionVarDescriptor(newRefDescriptor);
        oldRefDescriptor.prepareForAssignOrNormDiff(newRefDescriptor, targetUnit, null, true);
        return oldRefDescriptor.makeNormDiff(cumulTree, newRefDescriptor.nestedLoopTree, oldRefDescriptor.nestedLoopTree, newRefDescriptor, oldRefDescriptor);
    }

    public static Tree makeAssign(Unit targetUnit, Tree lhsExpr, Tree rhsExpr, SymbolTable defSymbolTable, SymbolTable usageSymbolTable, Tree lhsAltRootIdent, Tree rhsAltRootIdent, boolean isDiff, IterDescriptor multiDirIterator) {
        RefDescriptor lhsRefDescriptor = new RefDescriptor(lhsExpr, null, defSymbolTable, usageSymbolTable, null, lhsAltRootIdent, isDiff, multiDirIterator, targetUnit);
        RefDescriptor rhsRefDescriptor = new RefDescriptor(rhsExpr, null, defSymbolTable, usageSymbolTable, null, rhsAltRootIdent, isDiff, multiDirIterator, targetUnit);
        lhsRefDescriptor.setCompanionVarDescriptor(rhsRefDescriptor);
        lhsRefDescriptor.prepareForAssignOrNormDiff(rhsRefDescriptor, targetUnit, null, true);
        return lhsRefDescriptor.makeAssign(rhsRefDescriptor);
    }

    public static Tree makeIncrement(Unit targetUnit, Tree lhsExpr, Tree rhsExpr, SymbolTable defSymbolTable, SymbolTable usageSymbolTable, Tree lhsAltRootIdent, Tree rhsAltRootIdent, boolean isDiff, IterDescriptor multiDirIterator) {
        RefDescriptor lhsRefDescriptor = new RefDescriptor(lhsExpr, null, defSymbolTable, usageSymbolTable, null, lhsAltRootIdent, isDiff, multiDirIterator, targetUnit);
        RefDescriptor rhsRefDescriptor = new RefDescriptor(rhsExpr, null, defSymbolTable, usageSymbolTable, null, rhsAltRootIdent, isDiff, multiDirIterator, targetUnit);
        lhsRefDescriptor.setCompanionVarDescriptor(rhsRefDescriptor);
        lhsRefDescriptor.prepareForAssignOrNormDiff(rhsRefDescriptor, targetUnit, null, true);
        return lhsRefDescriptor.makeIncrement(rhsRefDescriptor, false);
    }

    public static Instruction makePush(Unit targetUnit, Tree expr, SymbolTable defSymbolTable, SymbolTable usageSymbolTable, int ppLabel) {
        RefDescriptor refDescriptor = new RefDescriptor(expr, null, defSymbolTable, usageSymbolTable, null, null, false, null, targetUnit);
        refDescriptor.prepareForStack(targetUnit, ppLabel, null, true);
        return new Instruction(refDescriptor.makePush(), null, null);
    }

    public static Instruction makePop(Unit targetUnit, Tree expr, SymbolTable defSymbolTable, SymbolTable usageSymbolTable, int ppLabel, TapPair<NewSymbolHolder, WrapperTypeSpec> toBranchVariable) {
        RefDescriptor refDescriptor = new RefDescriptor(expr, null, defSymbolTable, usageSymbolTable, null, null, false, null, targetUnit);
        refDescriptor.toBranchVariable = toBranchVariable;
        refDescriptor.prepareForStack(targetUnit, ppLabel, null, true);
        Tree result = refDescriptor.makePop();
        return new Instruction(result, null, null);
    }

    public static Instruction makePushDiff(Unit targetUnit, Tree expr, Tree diffRoot, SymbolTable defSymbolTable, SymbolTable usageSymbolTable, int ppLabel) {
        RefDescriptor refDescriptor = new RefDescriptor(expr, null, defSymbolTable, usageSymbolTable, null, diffRoot, true, null, targetUnit);
        refDescriptor.prepareForStack(targetUnit, ppLabel, null, true);
        return new Instruction(refDescriptor.makePush(), null, null);
    }

    public static Instruction makePopDiff(Unit targetUnit, Tree expr, Tree diffRoot, SymbolTable defSymbolTable, SymbolTable usageSymbolTable, int ppLabel) {
        RefDescriptor refDescriptor = new RefDescriptor(expr, null, defSymbolTable, usageSymbolTable, null, diffRoot, true, null, targetUnit);
        refDescriptor.prepareForStack(targetUnit, ppLabel, null, true);
        return new Instruction(refDescriptor.makePop(), null, null);
    }

    public static Instruction makeFixedControlPop(Unit targetUnit, Tree expr, int nbCases, SymbolTable defSymbolTable, SymbolTable usageSymbolTable, int ppLabel) {
        RefDescriptor refDescriptor = new RefDescriptor(expr, null, null, defSymbolTable, usageSymbolTable, null, null, false, null, targetUnit);
        refDescriptor.makeFixedControl(nbCases);
        refDescriptor.prepareForStack(targetUnit, ppLabel, null, true);
        return new Instruction(refDescriptor.makePop(), null, null);
    }

    public static Tree makeStack(Unit targetUnit, String stackOp, boolean directDirection, ZoneInfo zoneInfo, Tree zoneInfoVisibleAccessTree, SymbolTable defSymbolTable, SymbolTable usageSymbolTable, boolean protectAccesses, int ppLabel) {
        RefDescriptor refDescriptor = new RefDescriptor(zoneInfo, zoneInfoVisibleAccessTree, defSymbolTable, usageSymbolTable, null, null, false, null, targetUnit);
        refDescriptor.prepareForStack(targetUnit, ppLabel, null, true);
        refDescriptor.mayProtectAccesses = protectAccesses;
        Tree result = refDescriptor.makeStack(refDescriptor.nestedLoopTree, stackOp, directDirection);
        refDescriptor.checkUnknownDimensionsForC(result, stackOp);
        return result;
    }

    public Tree refTree() {
        return this.patternTree;
    }

    public void setHintArrayTreeForCallSize(Tree tree) {
        this.hintArrayTreeForCallSize = tree;
    }

    private void initialize(Tree tree, Tree altRootIdent) {
        if (tree.opCode() == 52 || tree.opCode() == 5) {
            tree = tree.down(1);
        }
        this.patternTree = ILUtils.copy(tree);
        if (this.patternTree.opCode() == 110) {
            this.patternTree = RefDescriptor.turnIterVarRefIntoTriplets(this.patternTree);
        }
        if (altRootIdent != null) {
            this.patternTree = this.changeRootByAltRoot(this.patternTree, altRootIdent);
        }
        this.patternTree = RefDescriptor.removeDerefOfAddress(this.patternTree);
        this.itersMemo = new IterDescriptor[10];
        for (int i = 0; i < 10; ++i) {
            this.itersMemo[i] = null;
        }
        this.itersMemoNextRk = 0;
        WrapperTypeSpec initTypeSpec = new WrapperTypeSpec(null);
        TapPair<WrapperTypeSpec, WrapperTypeSpec> resultingTypeSpec = new TapPair<WrapperTypeSpec, WrapperTypeSpec>(initTypeSpec, initTypeSpec);
        String nameInText = "";
        String nameInIdent = "";
        if (this.hintRootTree != null) {
            nameInText = ILUtils.buildNameInText(this.hintRootTree);
            nameInIdent = ILUtils.buildNameInIdent(this.hintRootTree);
        }
        if (this.hintArrayTreeForCallSize != null) {
            this.hintArrayTreeForCallSize = ILUtils.buildSizeArgument1(this.hintArrayTreeForCallSize, this.usageSymbolTable);
        }
        HintPlace hintPlace = new HintPlace(tree, nameInText, nameInIdent, this.hintArrayTreeForCallSize, 0, 1);
        WrapperTypeSpec elementTypeSpec = this.typesAndIterates(this.patternTree, null, true, resultingTypeSpec, hintPlace);
        elementTypeSpec = this.createIterDescriptors(elementTypeSpec, hintPlace, null);
        this.itersMemo = null;
        this.elementType = elementTypeSpec;
        if (elementTypeSpec != null) {
            ((WrapperTypeSpec)resultingTypeSpec.second).wrappedType = elementTypeSpec.wrappedType;
        }
        this.completeType = (WrapperTypeSpec)resultingTypeSpec.first;
    }

    public boolean isChannelOrIO() {
        return this.zoneInfo != null && this.zoneInfo.isChannelOrIO;
    }

    public void makeFixedControl(int nbControls) {
        this.nbControls = nbControls;
    }

    private WrapperTypeSpec typesAndIterates(Tree tree, ArrayDim contextDim, boolean elementalUse, TapPair<WrapperTypeSpec, WrapperTypeSpec> resultingTypeSpec, HintPlace hintPlace) {
        WrapperTypeSpec indexTypeSpec;
        TapPair<WrapperTypeSpec, WrapperTypeSpec> resultingIndexTypeSpec;
        WrapperTypeSpec elementTypeSpec;
        WrapperTypeSpec danglingLeafType;
        switch (tree.opCode()) {
            case 96: {
                VariableDecl variableDecl;
                Tree nonDiffTree;
                Tree lengthTree;
                IterDescriptor iterDescriptor = this.getIterDescriptorForTree(tree);
                if (iterDescriptor != null) {
                    IterDescriptorUse iterDescriptorUse = new IterDescriptorUse(iterDescriptor, iterDescriptor.defaultUse, contextDim);
                    tree.setAnnotation("iterDescriptorUseAnnot", iterDescriptorUse);
                    ArrayDim[] dims1 = new ArrayDim[1];
                    int firstArrayIndex = this.targetUnit.isFortran() ? 1 : 0;
                    lengthTree = iterDescriptor.getLengthTree();
                    if (lengthTree != null && lengthTree.opCode() == 103) {
                        contextDim = new ArrayDim(null, firstArrayIndex, lengthTree.intValue() + firstArrayIndex - 1, null, -1, 0, 0);
                    }
                    dims1[0] = new ArrayDimPlusIter(contextDim, iterDescriptor);
                    iterDescriptorUse.contextDim = dims1[0];
                    danglingLeafType = new WrapperTypeSpec(null);
                    resultingTypeSpec.first = new WrapperTypeSpec(new ArrayTypeSpec(danglingLeafType, dims1));
                    resultingTypeSpec.second = danglingLeafType;
                    elementTypeSpec = this.integerTypeSpec;
                    break;
                }
                NewSymbolHolder diffSymbolHolder = null;
                String varSymbol = "";
                WrapperTypeSpec typeSpec = null;
                Tree tree2 = nonDiffTree = this.diffRootIdent != null && tree.equalsTree(this.diffRootIdent) ? this.nonDiffRootIdent : tree;
                if (nonDiffTree != null) {
                    diffSymbolHolder = NewSymbolHolder.getNewSymbolHolder(nonDiffTree);
                }
                if (diffSymbolHolder != null) {
                    if (diffSymbolHolder.derivationFrom == null) {
                        typeSpec = diffSymbolHolder.typeSpec();
                    } else if (diffSymbolHolder.derivationFrom instanceof VariableDecl) {
                        variableDecl = (VariableDecl)diffSymbolHolder.derivationFrom;
                        typeSpec = variableDecl.type();
                        varSymbol = variableDecl.symbol;
                    } else if (diffSymbolHolder.derivationFrom instanceof FunctionDecl) {
                        FunctionDecl funDecl = (FunctionDecl)diffSymbolHolder.derivationFrom;
                        typeSpec = funDecl.returnTypeSpec();
                        varSymbol = funDecl.symbol;
                    }
                } else {
                    varSymbol = ILUtils.getIdentString(nonDiffTree);
                    variableDecl = this.defSymbolTable.getVariableOrConstantDecl(varSymbol);
                    typeSpec = variableDecl == null ? null : variableDecl.type();
                }
                WrapperTypeSpec wrapperTypeSpec = elementTypeSpec = typeSpec != null ? typeSpec : this.knownRootTypeSpec;
                if (this.forceRootTypeSpec != null) {
                    elementTypeSpec = this.forceRootTypeSpec;
                }
                if (hintPlace.arrayNameInText == null || hintPlace.arrayNameInText.isEmpty()) {
                    hintPlace.arrayNameInText = varSymbol;
                }
                if (hintPlace.arrayNameInIdent == null || hintPlace.arrayNameInIdent.isEmpty()) {
                    hintPlace.arrayNameInIdent = varSymbol;
                }
                if (hintPlace.arrayTreeForCallSize != null) break;
                hintPlace.arrayTreeForCallSize = nonDiffTree;
                break;
            }
            case 12: 
            case 59: {
                int firstArrayIndex;
                IterDescriptor iterDescriptor = this.itersMemo[this.itersMemoNextRk];
                int n = firstArrayIndex = this.targetUnit.isFortran() ? 1 : 0;
                if (iterDescriptor == null) {
                    this.itersMemo[this.itersMemoNextRk] = iterDescriptor = new IterDescriptor(this.itersMemoNextRk + 1, this.usageSymbolTable, this.otherUsageSymbolTable, ILUtils.build(103, firstArrayIndex), hintPlace.refTree, hintPlace.arrayNameInText, hintPlace.arrayNameInIdent, hintPlace.arrayTreeForCallSize, hintPlace.dim, hintPlace.ndims);
                }
                ++this.itersMemoNextRk;
                IterDescriptorUse iterDescriptorUse = new IterDescriptorUse(iterDescriptor, tree, contextDim);
                tree.setAnnotation("iterDescriptorUseAnnot", iterDescriptorUse);
                ArrayDim[] dims1 = new ArrayDim[1];
                Tree lengthTree = iterDescriptor.getLengthTree();
                if (lengthTree != null && lengthTree.opCode() == 103) {
                    contextDim = new ArrayDim(null, firstArrayIndex, lengthTree.intValue() + firstArrayIndex - 1, null, -1, 0, 0);
                } else if (lengthTree != null && (contextDim == null || contextDim.tree() == null && contextDim.upper == null)) {
                    contextDim = new ArrayDim(ILUtils.build(59, ILUtils.build(103, 1), ILUtils.copy(lengthTree)), null, null, null, -1, 0, 0);
                }
                if (contextDim == null) {
                    contextDim = new ArrayDim(tree, null, null, null, -1, 0, 0);
                }
                dims1[0] = new ArrayDimPlusIter(contextDim, iterDescriptor);
                iterDescriptorUse.contextDim = dims1[0];
                danglingLeafType = new WrapperTypeSpec(null);
                resultingTypeSpec.first = new WrapperTypeSpec(new ArrayTypeSpec(danglingLeafType, dims1));
                resultingTypeSpec.second = danglingLeafType;
                elementTypeSpec = this.integerTypeSpec;
                break;
            }
            case 9: {
                WrapperTypeSpec arrayType = this.typesAndIterates(tree.down(1), null, false, resultingTypeSpec, hintPlace);
                hintPlace.arrayTreeForCallSize = ILUtils.copy(tree.down(1));
                if (TypeSpec.isA(arrayType, 2)) {
                    ArrayTypeSpec arrayTypeSpec = (ArrayTypeSpec)arrayType.wrappedType;
                    TapList<Object> resultingDimensions = null;
                    Tree[] indexes = tree.down(2).children();
                    int indexlength = arrayTypeSpec.dimensions().length;
                    if (indexlength > indexes.length) {
                        indexlength = indexes.length;
                    }
                    for (int i = 0; i < indexlength; ++i) {
                        WrapperTypeSpec initTypeSpec;
                        TapPair<WrapperTypeSpec, WrapperTypeSpec> resultingIndexTypeSpec2;
                        Tree index = indexes[i];
                        ArrayDim arrayDimType = arrayTypeSpec.dimensions()[i];
                        WrapperTypeSpec indexType = this.typesAndIterates(index, arrayDimType, true, resultingIndexTypeSpec2 = new TapPair<WrapperTypeSpec, WrapperTypeSpec>(initTypeSpec = new WrapperTypeSpec(null), initTypeSpec), hintPlace.deriveDim(i + 1, indexlength));
                        if (indexType != null) {
                            ((WrapperTypeSpec)resultingIndexTypeSpec2.second).wrappedType = indexType.wrappedType;
                        }
                        if (TypeSpec.isA(indexType = (WrapperTypeSpec)resultingIndexTypeSpec2.first, 2) && !indexType.isString()) {
                            ArrayDim newArrayDimType = ((ArrayTypeSpec)indexType.wrappedType).dimensions()[0];
                            resultingDimensions = new TapList<ArrayDim>(newArrayDimType, resultingDimensions);
                            continue;
                        }
                        this.scalarIndices = true;
                    }
                    if (resultingDimensions != null) {
                        ArrayDim[] newDimensions = new ArrayDim[TapList.length(resultingDimensions)];
                        for (int i = newDimensions.length - 1; i >= 0; --i) {
                            newDimensions[i] = (ArrayDim)resultingDimensions.head;
                            resultingDimensions = resultingDimensions.tail;
                        }
                        danglingLeafType = new WrapperTypeSpec(null);
                        ((WrapperTypeSpec)resultingTypeSpec.second).wrappedType = new ArrayTypeSpec(danglingLeafType, newDimensions);
                        resultingTypeSpec.second = danglingLeafType;
                    }
                    elementTypeSpec = arrayTypeSpec.elementType();
                    break;
                }
                elementTypeSpec = arrayType;
                break;
            }
            case 75: {
                elementTypeSpec = this.typesAndIterates(tree.down(1), null, true, resultingTypeSpec, hintPlace);
                if (TypeSpec.isA(elementTypeSpec, 21)) {
                    elementTypeSpec = ((CompositeTypeSpec)elementTypeSpec.wrappedType).getFieldType(tree.down(2));
                }
                hintPlace.makeField(ILUtils.getIdentString(tree.down(2)));
                break;
            }
            case 151: {
                WrapperTypeSpec initTypeSpec;
                WrapperTypeSpec pointerType = this.typesAndIterates(tree.down(1), null, false, resultingTypeSpec, hintPlace);
                if (TypeSpec.isA(pointerType, 6)) {
                    PointerTypeSpec pointerTypeSpec = (PointerTypeSpec)pointerType.wrappedType;
                    if (!ILUtils.isNullOrNone(tree.down(2))) {
                        TapPair<WrapperTypeSpec, WrapperTypeSpec> resultingIndexTypeSpec3;
                        ArrayDim arrayDimType = pointerTypeSpec.offsetLength;
                        Tree index = tree.down(2);
                        WrapperTypeSpec indexType = this.typesAndIterates(index, arrayDimType, true, resultingIndexTypeSpec3 = new TapPair<WrapperTypeSpec, WrapperTypeSpec>(initTypeSpec = new WrapperTypeSpec(null), initTypeSpec), hintPlace.deriveDim(1, 1));
                        if (indexType != null) {
                            ((WrapperTypeSpec)resultingIndexTypeSpec3.second).wrappedType = indexType.wrappedType;
                        }
                        if (TypeSpec.isA(indexType = (WrapperTypeSpec)resultingIndexTypeSpec3.first, 2) && !indexType.isString()) {
                            ArrayDim newArrayDimType = ((ArrayTypeSpec)indexType.wrappedType).dimensions()[0];
                            danglingLeafType = new WrapperTypeSpec(null);
                            ((WrapperTypeSpec)resultingTypeSpec.second).wrappedType = new PointerTypeSpec(danglingLeafType, newArrayDimType);
                            resultingTypeSpec.second = danglingLeafType;
                        }
                    }
                    elementTypeSpec = pointerTypeSpec.destinationType;
                } else {
                    elementTypeSpec = pointerType;
                }
                hintPlace.makePointerDest();
                break;
            }
            case 42: {
                elementTypeSpec = this.defSymbolTable.getTypeDecl((String)"complex").typeSpec;
                break;
            }
            case 3: 
            case 62: 
            case 133: 
            case 155: 
            case 182: {
                int memoInitRk = this.itersMemoNextRk;
                WrapperTypeSpec son1TypeSpec = this.typesAndIterates(tree.down(1), null, true, resultingTypeSpec, hintPlace);
                int memoMaxRk = this.itersMemoNextRk;
                if (son1TypeSpec != null) {
                    ((WrapperTypeSpec)resultingTypeSpec.second).wrappedType = son1TypeSpec.wrappedType;
                }
                son1TypeSpec = (WrapperTypeSpec)resultingTypeSpec.first;
                WrapperTypeSpec initTypeSpec = new WrapperTypeSpec(null);
                TapPair<WrapperTypeSpec, WrapperTypeSpec> resultingTypeSpecBis = new TapPair<WrapperTypeSpec, WrapperTypeSpec>(initTypeSpec, initTypeSpec);
                HintPlace hintPlace2 = new HintPlace(hintPlace.refTree, "", "", hintPlace.arrayTreeForCallSize, 0, 1);
                this.itersMemoNextRk = memoInitRk;
                WrapperTypeSpec son2TypeSpec = this.typesAndIterates(tree.down(2), null, true, resultingTypeSpecBis, hintPlace2);
                if (this.itersMemoNextRk < memoMaxRk) {
                    this.itersMemoNextRk = memoMaxRk;
                }
                if (son2TypeSpec != null) {
                    ((WrapperTypeSpec)resultingTypeSpecBis.second).wrappedType = son2TypeSpec.wrappedType;
                }
                son2TypeSpec = (WrapperTypeSpec)resultingTypeSpecBis.first;
                resultingTypeSpec.first = son1TypeSpec.addWith(son2TypeSpec);
                hintPlace.cumulWith(hintPlace2);
                resultingTypeSpec.second = new WrapperTypeSpec(null);
                elementTypeSpec = null;
                break;
            }
            case 124: {
                elementTypeSpec = this.typesAndIterates(tree.down(1), null, true, resultingTypeSpec, hintPlace);
                break;
            }
            case 103: {
                elementTypeSpec = this.integerTypeSpec;
                break;
            }
            case 160: {
                elementTypeSpec = this.defSymbolTable.getTypeDecl((String)"float").typeSpec;
                break;
            }
            case 180: {
                int firstArrayIndex;
                elementTypeSpec = this.defSymbolTable.getTypeDecl((String)"character").typeSpec;
                int length = tree.stringValue().length();
                int n = firstArrayIndex = this.targetUnit.isFortran() ? 1 : 0;
                if (length <= 1) break;
                ArrayDim[] dims1 = new ArrayDim[]{new ArrayDim(null, firstArrayIndex, length, null, -1, 0, 0)};
                elementTypeSpec = new WrapperTypeSpec(new ArrayTypeSpec(elementTypeSpec, dims1));
                break;
            }
            case 28: {
                elementTypeSpec = this.defSymbolTable.getTypeDecl((String)"boolean").typeSpec;
                break;
            }
            case 138: {
                elementTypeSpec = new WrapperTypeSpec(new VoidTypeSpec());
                break;
            }
            case 31: {
                if ("sum".equals(ILUtils.getCalledNameString(tree).toLowerCase())) {
                    elementTypeSpec = this.defSymbolTable.getTypeDecl((String)"float").typeSpec;
                    break;
                }
                elementTypeSpec = this.typesAndIterates(ILUtils.getArguments(tree).down(1), null, true, resultingTypeSpec, hintPlace);
                break;
            }
            default: {
                elementTypeSpec = new WrapperTypeSpec(new VoidTypeSpec());
                hintPlace.arrayNameInText = "???";
                hintPlace.arrayNameInIdent = "???";
            }
        }
        while (TypeSpec.isA(elementTypeSpec, 5)) {
            ModifiedTypeSpec modelModifiedTypeSpec = (ModifiedTypeSpec)elementTypeSpec.wrappedType;
            elementTypeSpec = modelModifiedTypeSpec.elementType();
            danglingLeafType = new WrapperTypeSpec(null);
            ((WrapperTypeSpec)resultingTypeSpec.second).wrappedType = new ModifiedTypeSpec(danglingLeafType, modelModifiedTypeSpec);
            resultingTypeSpec.second = danglingLeafType;
        }
        if (elementalUse && this.targetUnit.isFortran() && TypeSpec.isA(elementTypeSpec, 2)) {
            ArrayTypeSpec arrayTypeSpec = (ArrayTypeSpec)elementTypeSpec.wrappedType;
            ArrayDim[] dimensions = arrayTypeSpec.dimensions();
            ArrayDim[] dimensionsWithIter = new ArrayDim[dimensions.length];
            Tree[] explicitIndexes = new Tree[dimensions.length];
            for (int i = 0; i < dimensions.length; ++i) {
                explicitIndexes[i] = ILUtils.build(12);
                WrapperTypeSpec initTypeSpec = new WrapperTypeSpec(null);
                resultingIndexTypeSpec = new TapPair<WrapperTypeSpec, WrapperTypeSpec>(initTypeSpec, initTypeSpec);
                this.typesAndIterates(explicitIndexes[i], dimensions[i], false, resultingIndexTypeSpec, hintPlace.deriveDim(i + 1, dimensions.length));
                indexTypeSpec = (WrapperTypeSpec)resultingIndexTypeSpec.first;
                dimensionsWithIter[i] = ((ArrayTypeSpec)indexTypeSpec.wrappedType).dimensions()[0];
            }
            tree.setAnnotation("explicitIndexes", ILUtils.build(71, explicitIndexes));
            danglingLeafType = new WrapperTypeSpec(null);
            ((WrapperTypeSpec)resultingTypeSpec.second).wrappedType = new ArrayTypeSpec(danglingLeafType, dimensionsWithIter);
            resultingTypeSpec.second = danglingLeafType;
            elementTypeSpec = arrayTypeSpec.elementType();
        } else if (elementalUse && this.targetUnit.isFortran() && TypeSpec.isA(elementTypeSpec, 6) && ((PointerTypeSpec)elementTypeSpec.wrappedType).offsetLength != null) {
            PointerTypeSpec pointerTypeSpec = (PointerTypeSpec)elementTypeSpec.wrappedType;
            ArrayDim dimension = pointerTypeSpec.offsetLength;
            Tree explicitIndex = ILUtils.build(12);
            WrapperTypeSpec initTypeSpec = new WrapperTypeSpec(null);
            resultingIndexTypeSpec = new TapPair<WrapperTypeSpec, WrapperTypeSpec>(initTypeSpec, initTypeSpec);
            this.typesAndIterates(explicitIndex, dimension, false, resultingIndexTypeSpec, hintPlace.deriveDim(1, 1));
            indexTypeSpec = (WrapperTypeSpec)resultingIndexTypeSpec.first;
            ArrayDim dimensionWithIter = ((ArrayTypeSpec)indexTypeSpec.wrappedType).dimensions()[0];
            tree.setAnnotation("explicitIndexes", explicitIndex);
            danglingLeafType = new WrapperTypeSpec(null);
            ((WrapperTypeSpec)resultingTypeSpec.second).wrappedType = new PointerTypeSpec(danglingLeafType, dimensionWithIter);
            resultingTypeSpec.second = danglingLeafType;
            elementTypeSpec = pointerTypeSpec.destinationType;
        }
        return elementTypeSpec;
    }

    private WrapperTypeSpec createIterDescriptors(WrapperTypeSpec modelTypeSpec, HintPlace hintPlace, TapList<TypeSpec> dejaVu) {
        if (modelTypeSpec == null || modelTypeSpec.wrappedType == null) {
            return null;
        }
        if (TapList.contains(dejaVu, modelTypeSpec.wrappedType)) {
            TapEnv.toolWarning(-1, "Cannot create a reference to a recursive-type expression " + ILUtils.toString(this.patternTree));
            return null;
        }
        dejaVu = new TapList<TypeSpec>(modelTypeSpec.wrappedType, dejaVu);
        switch (modelTypeSpec.wrappedType.kind()) {
            case 2: {
                ArrayTypeSpec arrayTypeSpec = (ArrayTypeSpec)modelTypeSpec.wrappedType;
                ArrayDim[] dimensions = arrayTypeSpec.dimensions();
                ArrayDim[] copyDimensions = new ArrayDim[dimensions.length];
                int firstArrayIndex = this.targetUnit.isFortran() ? 1 : 0;
                for (int i = 0; i < dimensions.length; ++i) {
                    ArrayDim dimension = dimensions[i];
                    hintPlace.dim = i + 1;
                    IterDescriptor iterDescriptor = new IterDescriptor(this.itersMemoNextRk + 1, this.usageSymbolTable, null, ILUtils.build(103, firstArrayIndex), hintPlace.refTree, hintPlace.arrayNameInText, hintPlace.arrayNameInIdent, hintPlace.arrayTreeForCallSize, hintPlace.dim, dimensions.length);
                    ++this.itersMemoNextRk;
                    iterDescriptor.setLengthTree(ILUtils.buildSizeTree(dimension.tree().down(1), dimension.tree().down(2), ILUtils.build(103, 1)));
                    copyDimensions[i] = new ArrayDimPlusIter(dimension, iterDescriptor);
                }
                WrapperTypeSpec copyElementType = this.createIterDescriptors(arrayTypeSpec.elementType(), hintPlace, dejaVu);
                return new WrapperTypeSpec(new ArrayTypeSpec(copyElementType, copyDimensions));
            }
            case 21: {
                CompositeTypeSpec compositeTypeSpec = (CompositeTypeSpec)modelTypeSpec.wrappedType;
                FieldDecl[] fields = compositeTypeSpec.fields;
                FieldDecl[] copyFields = new FieldDecl[fields.length];
                int memoInitRk = this.itersMemoNextRk;
                for (int i = fields.length - 1; i >= 0; --i) {
                    copyFields[i] = fields[i] != null ? new FieldDecl(fields[i].symbol, this.createIterDescriptors(fields[i].type(), hintPlace.deriveField(fields[i].symbol), dejaVu)) : null;
                    this.itersMemoNextRk = memoInitRk;
                }
                CompositeTypeSpec copyCompositeType = compositeTypeSpec.isRecordType() ? new CompositeTypeSpec(null, copyFields, 8, compositeTypeSpec.modifiers, null) : new CompositeTypeSpec(null, copyFields, 13, null, null);
                copyCompositeType.shareActiveFields(compositeTypeSpec);
                return new WrapperTypeSpec(copyCompositeType);
            }
            case 5: {
                ModifiedTypeSpec modelModifiedTypeSpec = (ModifiedTypeSpec)modelTypeSpec.wrappedType;
                return new WrapperTypeSpec(new ModifiedTypeSpec(this.createIterDescriptors(modelModifiedTypeSpec.elementType(), hintPlace, dejaVu), modelModifiedTypeSpec));
            }
            case 6: {
                if (this.targetUnit.isFortran()) {
                    PointerTypeSpec pointerTypeSpec = (PointerTypeSpec)modelTypeSpec.wrappedType;
                    ArrayDim dimension = pointerTypeSpec.offsetLength;
                    ArrayDimPlusIter copyDimension = null;
                    int firstArrayIndex = 1;
                    if (dimension != null) {
                        IterDescriptor iterDescriptor = new IterDescriptor(this.itersMemoNextRk + 1, this.usageSymbolTable, null, ILUtils.build(103, firstArrayIndex), hintPlace.refTree, hintPlace.arrayNameInText, hintPlace.arrayNameInIdent, hintPlace.arrayTreeForCallSize, hintPlace.dim, hintPlace.ndims);
                        ++this.itersMemoNextRk;
                        iterDescriptor.setLengthTree(ILUtils.buildSizeTree(dimension.tree().down(1), dimension.tree().down(2), ILUtils.build(103, 1)));
                        copyDimension = new ArrayDimPlusIter(dimension, iterDescriptor);
                    }
                    hintPlace.makePointerDest();
                    return new WrapperTypeSpec(new PointerTypeSpec(this.createIterDescriptors(pointerTypeSpec.destinationType, hintPlace, dejaVu), copyDimension));
                }
                return modelTypeSpec;
            }
        }
        return modelTypeSpec;
    }

    private Tree changeRootByAltRoot(Tree expr, Tree altRoot) {
        switch (expr.opCode()) {
            case 9: 
            case 75: 
            case 151: {
                return ILUtils.build(expr.opCode(), this.changeRootByAltRoot(expr.down(1), altRoot), ILUtils.copy(expr.down(2)));
            }
            case 96: {
                this.nonDiffRootIdent = expr;
                this.diffRootIdent = altRoot;
                return ILUtils.copy(altRoot);
            }
        }
        return ILUtils.copy(expr);
    }

    public void addDeref() {
        this.patternTree = ILUtils.build(151, ILUtils.copy(this.patternTree));
    }

    private IterDescriptor getIterDescriptorForTree(Tree searchedIndexTree) {
        IterDescriptor found = null;
        for (int i = 0; found == null && i < this.itersMemo.length; ++i) {
            if (this.itersMemo[i] == null || this.itersMemo[i].indexTree == null || !this.itersMemo[i].indexTree.equalsTree(searchedIndexTree)) continue;
            found = this.itersMemo[i];
        }
        return found;
    }

    public void prepareForStack(Unit targetUnit, int ppLabel, TapList ignoreStructure, boolean ignorePointed) {
        this.targetUnit = targetUnit;
        this.futureUse = 1;
        boolean arrayNotationPermitted = this.decideArrayNotation(this.completeType, this.referencesIn(this.patternTree), 1, ignorePointed, false);
        this.makeNestedLoopTree(ignoreStructure, ignorePointed, arrayNotationPermitted);
        if (TapEnv.get().numberPushPops) {
            this.ppLabel = ppLabel;
        }
    }

    public void prepareForInitialize(Unit targetUnit, TapList ignoreStructure, boolean ignorePointed) {
        this.targetUnit = targetUnit;
        this.futureUse = 3;
        boolean arrayNotationPermitted = this.decideArrayNotation(this.completeType, this.referencesIn(this.patternTree), 3, ignorePointed, false);
        this.makeNestedLoopTree(ignoreStructure, ignorePointed, arrayNotationPermitted);
    }

    public void prepareForAssignOrNormDiff(RefDescriptor otherRefDescriptor, Unit targetUnit, TapList ignoreStructure, boolean ignorePointed) {
        this.targetUnit = targetUnit;
        this.futureUse = 4;
        otherRefDescriptor.targetUnit = targetUnit;
        boolean arrayNotationPermitted = this.decideArrayNotation(this.completeType, this.referencesIn(this.patternTree), 4, ignorePointed, false);
        otherRefDescriptor.decideArrayNotation(otherRefDescriptor.completeType, this.referencesIn(otherRefDescriptor.patternTree), 4, ignorePointed, false);
        RefDescriptor.synchronizeDoIterators(this.completeType, otherRefDescriptor.completeType);
        this.makeNestedLoopTree(ignoreStructure, ignorePointed, arrayNotationPermitted);
        otherRefDescriptor.makeNestedLoopTree(ignoreStructure, ignorePointed, arrayNotationPermitted);
    }

    private TapList<Tree> referencesIn(Tree accessTree) {
        TapList<Object> collection = new TapList<Object>(null, null);
        this.riRec(accessTree, collection);
        return collection.tail;
    }

    private void riRec(Tree accessTree, TapList<Tree> collection) {
        if (accessTree != null) {
            switch (accessTree.opCode()) {
                case 124: {
                    this.riRec(accessTree.down(1), collection);
                    break;
                }
                case 31: {
                    if (ILUtils.getArguments(accessTree).children().length <= 0) break;
                    this.riRec(ILUtils.getArguments(accessTree).down(1), collection);
                    break;
                }
                case 3: 
                case 42: 
                case 62: 
                case 133: 
                case 155: 
                case 182: {
                    this.riRec(accessTree.down(1), collection);
                    this.riRec(accessTree.down(2), collection);
                    break;
                }
                case 9: 
                case 75: 
                case 151: {
                    collection.placdl(ILUtils.baseTree(ILUtils.copy(accessTree)));
                    break;
                }
                case 96: {
                    if (!NewSymbolHolder.isANewSymbolRef(accessTree)) break;
                    collection.placdl(ILUtils.copy(accessTree));
                    break;
                }
            }
        }
    }

    private boolean oneIndexIsArray(Tree expr) {
        if (expr == null) {
            return false;
        }
        if (expr.opCode() == 71) {
            Tree[] indices = expr.children();
            boolean oneArray = false;
            for (int i = indices.length - 1; i >= 0 && !oneArray; --i) {
                oneArray = this.oneIndexIsArray(indices[i]);
            }
            return oneArray;
        }
        return TypeSpec.isA(this.defSymbolTable.typeOf(expr), 2);
    }

    private TapList<Tree> upTillDimensions(TapList<Tree> accessTrees, ArrayDim[] dimensions, ToBool derefFound) {
        TapList<Object> hdResult;
        TapList<Object> tlResult = hdResult = new TapList<Object>(null, null);
        while (accessTrees != null) {
            Tree origAccessTree = (Tree)accessTrees.head;
            if (origAccessTree != null) {
                Tree accessTree;
                boolean hasDeref = false;
                for (accessTree = origAccessTree.parent(); !(accessTree == null || accessTree.opCode() == 9 && dimensions != null && this.oneIndexIsArray(accessTree.down(2)) || accessTree.opCode() == 151 && dimensions != null && this.oneIndexIsArray(accessTree.down(2))); accessTree = accessTree.parent()) {
                    if (accessTree.opCode() != 151) continue;
                    hasDeref = true;
                }
                if (accessTree != null || dimensions == null) {
                    if (accessTree != null) {
                        tlResult = tlResult.placdl(accessTree);
                    }
                    if (hasDeref && derefFound != null) {
                        derefFound.set(true);
                    }
                }
            }
            accessTrees = accessTrees.tail;
        }
        return hdResult.tail;
    }

    private boolean decideArrayNotation(WrapperTypeSpec typeSpec, TapList<Tree> accessTrees, int mode, boolean ignorePointed, boolean insideElementTypeSpec) {
        ToBool derefFound = new ToBool(false);
        if (typeSpec == this.elementType || typeSpec != null && this.elementType != null && typeSpec.wrappedType != null && typeSpec.wrappedType == this.elementType.wrappedType) {
            insideElementTypeSpec = true;
            accessTrees = this.upTillDimensions(accessTrees, null, derefFound);
        }
        boolean arrayNotationPermitted = true;
        if (typeSpec != null && typeSpec.wrappedType != null) {
            switch (typeSpec.wrappedType.kind()) {
                case 2: {
                    ArrayTypeSpec arrayTypeSpec = (ArrayTypeSpec)typeSpec.wrappedType;
                    ArrayDim[] dimensions = arrayTypeSpec.dimensions();
                    if (!insideElementTypeSpec) {
                        accessTrees = this.upTillDimensions(accessTrees, dimensions, derefFound);
                    }
                    boolean arrayNotationUsedHere = !(!(arrayNotationPermitted = this.decideArrayNotation(arrayTypeSpec.elementType(), accessTrees, mode, ignorePointed, insideElementTypeSpec)) && (this.multiDirIterator == null || accessTrees != null && ((Tree)accessTrees.head).parent() != null || arrayTypeSpec.elementType() == null || !arrayTypeSpec.elementType().isDifferentiablePlainType()) || !this.targetUnit.hasArrayNotation() && (mode != 1 && mode != 2 || this.scalarIndices && !arrayTypeSpec.isString() || !RefDescriptor.allDimensionsFull(dimensions) && !RefDescriptor.subArrayAccess(dimensions)));
                    for (int i = dimensions.length - 1; i >= 0; --i) {
                        ((ArrayDimPlusIter)dimensions[i]).iter.isArray = arrayNotationUsedHere;
                    }
                    arrayNotationPermitted = arrayNotationPermitted && !arrayNotationUsedHere && !derefFound.get();
                    break;
                }
                case 21: {
                    CompositeTypeSpec compositeTypeSpec = (CompositeTypeSpec)typeSpec.wrappedType;
                    FieldDecl[] fields = compositeTypeSpec.fields;
                    arrayNotationPermitted = true;
                    for (int i = fields.length - 1; i >= 0; --i) {
                        if (fields[i] == null) continue;
                        boolean fieldNoDerefScalars = this.decideArrayNotation(fields[i].type(), null, mode, ignorePointed, true);
                        arrayNotationPermitted = arrayNotationPermitted && fieldNoDerefScalars;
                    }
                    arrayNotationPermitted = arrayNotationPermitted && !derefFound.get();
                    break;
                }
                case 5: {
                    ModifiedTypeSpec modifiedTypeSpec = (ModifiedTypeSpec)typeSpec.wrappedType;
                    arrayNotationPermitted = this.decideArrayNotation(modifiedTypeSpec.elementType(), accessTrees, mode, ignorePointed, insideElementTypeSpec);
                    arrayNotationPermitted = arrayNotationPermitted && !derefFound.get();
                    break;
                }
                case 6: {
                    if (!ignorePointed || !insideElementTypeSpec) {
                        PointerTypeSpec pointerTypeSpec = (PointerTypeSpec)typeSpec.wrappedType;
                        ArrayDim ptrDimension = pointerTypeSpec.offsetLength;
                        ArrayDimPlusIter dimension = null;
                        if (pointerTypeSpec.offsetLength instanceof ArrayDimPlusIter) {
                            dimension = (ArrayDimPlusIter)ptrDimension;
                        }
                        ArrayDim[] arrayOneDim = new ArrayDim[]{dimension};
                        if (!insideElementTypeSpec) {
                            accessTrees = this.upTillDimensions(accessTrees, arrayOneDim, null);
                        }
                        arrayNotationPermitted = this.decideArrayNotation(pointerTypeSpec.destinationType, accessTrees, mode, ignorePointed, insideElementTypeSpec);
                        if (dimension != null) {
                            dimension.iter.isArray = arrayNotationPermitted && (this.targetUnit.hasArrayNotation() || (mode == 1 || mode == 2) && dimension.iter.isImplicitCompleteDimension);
                        }
                        arrayNotationPermitted = false;
                        break;
                    }
                    arrayNotationPermitted = false;
                    break;
                }
                case 7: {
                    boolean arrayNotationUsedHere = this.multiDirIterator != null && TypeSpec.isDifferentiableType(typeSpec);
                    arrayNotationPermitted = !arrayNotationUsedHere && !derefFound.get();
                    break;
                }
                default: {
                    arrayNotationPermitted = false;
                }
            }
        }
        return arrayNotationPermitted;
    }

    private void makeNestedLoopTree(TapList ignoreStructure, boolean ignorePointed, boolean arrayNotationPermitted) {
        TapList<TapPair<WrapperTypeSpec, Tree>> typeStack = this.buildReversedTypeStack(this.completeType, this.elementType);
        TapList<Object> dimensionsAlreadyInExpressionTree = new TapList<Object>(null, null);
        Tree expressionTree = this.solveIndexes(ILUtils.copy(this.patternTree), typeStack, arrayNotationPermitted, dimensionsAlreadyInExpressionTree);
        boolean canHaveDiff = TypeSpec.isDifferentiableType(this.completeType);
        this.nestedLoopTree = new NestedLoopNode(expressionTree, null, null, null, true, null, null, canHaveDiff);
        Tree rootTree = ILUtils.baseTree(this.nonDiffRootIdent == null ? expressionTree : this.nonDiffRootIdent);
        String rootIdent = ILUtils.baseName(this.nonDiffRootIdent == null ? expressionTree : this.nonDiffRootIdent);
        VariableDecl rootDecl = rootIdent == null ? null : this.defSymbolTable.getVariableDecl(rootIdent);
        this.createNestedLoopTree(this.nestedLoopTree, expressionTree, rootDecl, this.completeType, null, ILUtils.build(103, 1), false, true, canHaveDiff, ignoreStructure, ignorePointed, dimensionsAlreadyInExpressionTree, typeStack, ILUtils.copy(this.diffRootIdent != null ? this.diffRootIdent : rootTree));
    }

    private TapList<TapPair<WrapperTypeSpec, Tree>> buildReversedTypeStack(WrapperTypeSpec fromTypeSpec, WrapperTypeSpec elemTypeSpec) {
        TapList<TapPair<WrapperTypeSpec, Object>> result = null;
        boolean stop = false;
        block5: while (!stop && fromTypeSpec != null && fromTypeSpec.wrappedType != null && !RefDescriptor.isSameTSorActualTS(fromTypeSpec, elemTypeSpec)) {
            switch (fromTypeSpec.wrappedType.kind()) {
                case 2: {
                    result = new TapList<TapPair<WrapperTypeSpec, Object>>(new TapPair<WrapperTypeSpec, Object>(fromTypeSpec, null), result);
                    fromTypeSpec = fromTypeSpec.wrappedType.elementType();
                    continue block5;
                }
                case 6: {
                    result = new TapList<TapPair<WrapperTypeSpec, Object>>(new TapPair<WrapperTypeSpec, Object>(fromTypeSpec, null), result);
                    fromTypeSpec = ((PointerTypeSpec)fromTypeSpec.wrappedType).destinationType;
                    continue block5;
                }
                case 5: {
                    fromTypeSpec = fromTypeSpec.wrappedType.elementType();
                    continue block5;
                }
            }
            stop = true;
        }
        return result;
    }

    private Tree solveIndexes(Tree expressionTree, TapList<TapPair<WrapperTypeSpec, Tree>> typeStack, boolean arrayNotationPermitted, TapList<ArrayDim> dimensionsAlreadyInExpressionTree) {
        block13: {
            block14: {
                Tree newSubTree;
                block15: {
                    Tree annotatedIndices;
                    IterDescriptorUse iterDescriptorUse;
                    if (expressionTree == null) break block13;
                    int opCode = expressionTree.opCode();
                    if ((opCode == 59 || opCode == 12) && (iterDescriptorUse = (IterDescriptorUse)expressionTree.getAnnotation("iterDescriptorUseAnnot")) != null) {
                        expressionTree = iterDescriptorUse.buildIndexTree(this.usageSymbolTable, this.targetUnit);
                        dimensionsAlreadyInExpressionTree.placdl(iterDescriptorUse.contextDim);
                    }
                    if ((annotatedIndices = (Tree)expressionTree.getAnnotation("explicitIndexes")) != null) {
                        expressionTree = ILUtils.copy(expressionTree);
                        expressionTree.removeAnnotation("explicitIndexes");
                        expressionTree = annotatedIndices.opCode() == 71 ? ILUtils.build(9, expressionTree, annotatedIndices) : ILUtils.build(151, expressionTree, annotatedIndices);
                    }
                    if (expressionTree.opCode() != 9) break block14;
                    TapList<TapPair<WrapperTypeSpec, Tree>> typeStackTail = typeStack == null ? null : typeStack.tail;
                    Tree newIndices = this.solveIndexes(expressionTree.down(2), typeStackTail, arrayNotationPermitted, dimensionsAlreadyInExpressionTree);
                    if (newIndices != expressionTree.down(2)) {
                        expressionTree.setChild(newIndices, 2);
                    }
                    boolean allImplicitColons = true;
                    Tree[] indx = newIndices.children();
                    for (int i = indx.length - 1; i >= 0; --i) {
                        if (indx[i].opCode() == 59 || indx[i].opCode() == 12) {
                            arrayNotationPermitted = false;
                        }
                        if (ILUtils.isImplicitCompleteDimension(indx[i])) continue;
                        allImplicitColons = false;
                    }
                    newSubTree = this.solveIndexes(expressionTree.down(1), typeStackTail, arrayNotationPermitted, dimensionsAlreadyInExpressionTree);
                    if (typeStack != null) {
                        ((TapPair)typeStack.head).second = newSubTree;
                    }
                    if (!allImplicitColons) break block15;
                    expressionTree = newSubTree;
                    break block13;
                }
                if (newSubTree == expressionTree.down(1)) break block13;
                expressionTree.setChild(newSubTree, 1);
                break block13;
            }
            if (expressionTree.opCode() == 151 && !ILUtils.isNullOrNone(expressionTree.down(2))) {
                TapList<TapPair<WrapperTypeSpec, Tree>> typeStackTail = typeStack == null ? null : typeStack.tail;
                Tree newIndex = this.solveIndexes(expressionTree.down(2), typeStackTail, arrayNotationPermitted, dimensionsAlreadyInExpressionTree);
                if (newIndex != expressionTree.down(2)) {
                    expressionTree.setChild(newIndex, 2);
                }
                Tree newSubTree = this.solveIndexes(expressionTree.down(1), typeStackTail, false, dimensionsAlreadyInExpressionTree);
                if (typeStack != null) {
                    ((TapPair)typeStack.head).second = newSubTree;
                }
                if (newSubTree != expressionTree.down(1)) {
                    expressionTree.setChild(newSubTree, 1);
                }
            } else if (!expressionTree.isAtom()) {
                Tree[] subTrees = expressionTree.children();
                for (int i = subTrees.length - 1; i >= 0; --i) {
                    Tree newSubTree = this.solveIndexes(subTrees[i], typeStack, arrayNotationPermitted, dimensionsAlreadyInExpressionTree);
                    if (newSubTree == subTrees[i]) continue;
                    expressionTree.setChild(newSubTree, i + 1);
                }
            }
        }
        return expressionTree;
    }

    private void createNestedLoopTree(NestedLoopNode inNLT, Tree expressionTree, SymbolDecl rootDecl, WrapperTypeSpec typeSpec, Tree typeSizeModifier, Tree arraySize, boolean insideElementTypeSpec, boolean isScalar, boolean canHaveDiff, TapList ignoreStructure, boolean ignorePointed, TapList<ArrayDim> dimensionsAlreadyInExpressionTree, TapList<TapPair<WrapperTypeSpec, Tree>> typeStack, Tree testTree) {
        if (ignoreStructure != null && ignoreStructure.tail == null && ignoreStructure.head instanceof Boolean && ((Boolean)ignoreStructure.head).booleanValue()) {
            inNLT.expression = null;
            return;
        }
        if (!insideElementTypeSpec && RefDescriptor.isSameTSorActualTS(typeSpec, this.elementType)) {
            insideElementTypeSpec = true;
        }
        int typeKind = -1;
        if (typeSpec != null && typeSpec.wrappedType != null) {
            typeKind = typeSpec.wrappedType.kind();
        }
        if (typeKind == 7 && TapEnv.modeIsOverloading()) {
            assert (typeSpec != null);
            TypeDecl tmp = this.targetUnit.callGraph().topBlock.symbolTable.getTypeDecl(typeSpec.baseTypeName());
            if (tmp != null) {
                typeSpec = tmp.typeSpec;
            }
            typeKind = typeSpec == null || typeSpec.wrappedType == null ? -1 : typeSpec.wrappedType.kind();
        }
        switch (typeKind) {
            case 2: {
                assert (typeSpec != null);
                ArrayTypeSpec arrayTypeSpec = (ArrayTypeSpec)typeSpec.wrappedType;
                ArrayDim[] dimensions = arrayTypeSpec.dimensions();
                TapList<IterDescriptor> loopIterators = null;
                TapList<Tree> indexes = null;
                boolean allImplicitColons = true;
                boolean noArrayAccess = expressionTree.opCode() != 9;
                for (ArrayDim arrayDim : dimensions) {
                    ArrayDimPlusIter dimension = (ArrayDimPlusIter)arrayDim;
                    Tree hintTreeFromStack = (Tree)TapList.cassq(typeSpec, typeStack);
                    if (hintTreeFromStack == null) {
                        dimension.iter.setHintArrayTreeForCallSize(expressionTree);
                    } else {
                        dimension.iter.setHintArrayTreeForCallSize(hintTreeFromStack);
                    }
                    if (dimension.iter.isArray) {
                        if (this.futureUse == 1) {
                            dimension.iter.preciseDefaultLengthTree(this.targetUnit, this.usageSymbolTable);
                            arraySize = ILUtils.mulTree(dimension.iter.getLengthTree(), arraySize);
                        }
                        isScalar = false;
                    } else {
                        loopIterators = new TapList<IterDescriptor>(dimension.iter, loopIterators);
                    }
                    if (TapList.contains(dimensionsAlreadyInExpressionTree, arrayDim) || !insideElementTypeSpec && (this.multiDirIterator == null || !noArrayAccess)) continue;
                    Tree indexTree = dimension.iter.buildIndexTree(this.usageSymbolTable, this.targetUnit);
                    if (!dimension.iter.isArray) {
                        allImplicitColons = false;
                    }
                    indexes = new TapList<Tree>(indexTree, indexes);
                }
                Tree indexesTree = null;
                if (indexes != null) {
                    indexes = TapList.nreverse(indexes);
                    indexesTree = ILUtils.build(71, indexes);
                }
                if (insideElementTypeSpec && !allImplicitColons || this.multiDirIterator != null && noArrayAccess) {
                    if (indexesTree != null) {
                        expressionTree = ILUtils.build(9, ILUtils.copy(expressionTree), ILUtils.copy(indexesTree));
                    }
                } else if (expressionTree.opCode() == 9) {
                    inNLT.expression = ILUtils.copy(inNLT.expression.down(1));
                }
                if (this.targetUnit.isFortran() && rootDecl != null && TypeSpec.isA(rootDecl.type(), 6)) {
                    inNLT.protectAllocatedAssociated = ILUtils.buildCall(ILUtils.build(96, rootDecl.hasModifier("allocatable") ? "ALLOCATED" : "ASSOCIATED"), ILUtils.build(71, ILUtils.copy(testTree)));
                    rootDecl = null;
                }
                if (indexesTree != null) {
                    testTree = ILUtils.build(9, ILUtils.copy(testTree), indexesTree);
                }
                if (loopIterators != null) {
                    inNLT.nodes = new TapList<NestedLoopNode>(new NestedLoopNode(expressionTree, typeSpec, null, null, isScalar, loopIterators, null, canHaveDiff), inNLT.nodes);
                    inNLT = (NestedLoopNode)((NestedLoopNode)inNLT).nodes.head;
                }
                this.createNestedLoopTree(inNLT, expressionTree, rootDecl, arrayTypeSpec.elementType(), typeSizeModifier, arraySize, insideElementTypeSpec, isScalar, canHaveDiff, ignoreStructure, ignorePointed, dimensionsAlreadyInExpressionTree, typeStack, testTree);
                break;
            }
            case 6: {
                assert (typeSpec != null);
                PointerTypeSpec pointerTypeSpec = (PointerTypeSpec)typeSpec.wrappedType;
                ArrayDim rawDimension = pointerTypeSpec.offsetLength;
                ArrayDimPlusIter dimension = null;
                if (rawDimension instanceof ArrayDimPlusIter) {
                    dimension = (ArrayDimPlusIter)rawDimension;
                }
                if (!ignorePointed || dimension != null) {
                    if (dimension != null && dimension.iter != null) {
                        if (insideElementTypeSpec || RefDescriptor.isSameTSorActualTS(pointerTypeSpec.destinationType, this.elementType)) {
                            dimension.iter.setHintArrayTreeForCallSize(expressionTree);
                        } else {
                            dimension.iter.setHintArrayTreeForCallSize((Tree)TapList.cassq(typeSpec, typeStack));
                        }
                    }
                    if (ignoreStructure != null && ignoreStructure.head instanceof Boolean) {
                        ignoreStructure = ignoreStructure.tail;
                    }
                    if (dimension != null && dimension.iter.isArray && this.futureUse == 1) {
                        dimension.iter.preciseDefaultLengthTree(this.targetUnit, this.usageSymbolTable);
                        arraySize = ILUtils.mulTree(dimension.iter.getLengthTree(), arraySize);
                        if (expressionTree.opCode() == 151) {
                            expressionTree = ILUtils.copy(expressionTree.down(1));
                        }
                        this.createNestedLoopTree(inNLT, expressionTree, rootDecl, pointerTypeSpec.destinationType, typeSizeModifier, arraySize, insideElementTypeSpec, false, canHaveDiff, ignoreStructure, ignorePointed, dimensionsAlreadyInExpressionTree, typeStack, testTree);
                        break;
                    }
                    TapList<IterDescriptor> loopIterators = null;
                    if (dimension != null) {
                        if (dimension.iter.isArray) {
                            isScalar = false;
                        } else {
                            loopIterators = new TapList<IterDescriptor>(dimension.iter, null);
                        }
                    }
                    Tree indexTree = null;
                    if (dimension != null) {
                        indexTree = dimension.iter.buildIndexTree(this.usageSymbolTable, this.targetUnit);
                    }
                    if (insideElementTypeSpec) {
                        expressionTree = ILUtils.build(151, ILUtils.copy(expressionTree), ILUtils.copy(indexTree));
                    }
                    inNLT.nodes = new TapList<NestedLoopNode>(new NestedLoopNode(expressionTree, typeSpec, null, null, isScalar, loopIterators, null, canHaveDiff), inNLT.nodes);
                    inNLT = (NestedLoopNode)((NestedLoopNode)inNLT).nodes.head;
                    if (rootDecl != null) {
                        if (this.targetUnit.isFortran()) {
                            inNLT.protectAllocatedAssociated = ILUtils.buildCall(ILUtils.build(96, rootDecl.hasModifier("allocatable") ? "ALLOCATED" : "ASSOCIATED"), ILUtils.build(71, ILUtils.copy(testTree)));
                            rootDecl = null;
                        } else if (this.targetUnit.isC() && rawDimension == null && rootDecl.kind == 1 && ((VariableDecl)rootDecl).formalArgRank == -2) {
                            inNLT.protectAllocatedAssociated = ILUtils.copy(testTree);
                            rootDecl = null;
                        }
                    }
                    testTree = ILUtils.build(151, ILUtils.copy(testTree), indexTree);
                    this.createNestedLoopTree(inNLT, expressionTree, rootDecl, pointerTypeSpec.destinationType, typeSizeModifier, arraySize, insideElementTypeSpec, isScalar, canHaveDiff, ignoreStructure, ignorePointed, dimensionsAlreadyInExpressionTree, typeStack, testTree);
                    break;
                }
                if (ignoreStructure != null && ignoreStructure.head instanceof Boolean && ((Boolean)ignoreStructure.head).booleanValue()) {
                    inNLT.expression = null;
                    break;
                }
                inNLT.nodes = new TapList<NestedLoopNode>(new NestedLoopNode(expressionTree, typeSpec, typeSizeModifier, arraySize, isScalar, null, null, canHaveDiff), inNLT.nodes);
                this.holdsAPointer = true;
                break;
            }
            case 21: {
                assert (typeSpec != null);
                CompositeTypeSpec compositeTypeSpec = (CompositeTypeSpec)typeSpec.wrappedType;
                FieldDecl[] fields = compositeTypeSpec.fields;
                TapList subIgnoreStructs = TapList.reverse(ignoreStructure);
                for (int i = fields.length - 1; i >= 0; --i) {
                    TapList subIgnoreStruct;
                    boolean fieldCanHaveDiff;
                    boolean bl = fieldCanHaveDiff = canHaveDiff && (compositeTypeSpec.isDifferentiatedField(i) || !TapEnv.doActivity() && TypeSpec.isDifferentiableType(fields[i].type()));
                    if (subIgnoreStructs != null && subIgnoreStructs.head instanceof TapList) {
                        subIgnoreStruct = (TapList)subIgnoreStructs.head;
                        subIgnoreStructs = subIgnoreStructs.tail;
                    } else {
                        subIgnoreStruct = subIgnoreStructs;
                    }
                    if (fields[i] == null || this.isDiff && !fieldCanHaveDiff) continue;
                    Tree fieldNameTree = ILUtils.build(96, fields[i].symbol);
                    ILUtils.setFieldRank(fieldNameTree, i);
                    this.createNestedLoopTree(inNLT, ILUtils.build(75, ILUtils.copy(expressionTree), ILUtils.copy(fieldNameTree)), fields[i], fields[i].type(), typeSizeModifier, ILUtils.copy(arraySize), insideElementTypeSpec, isScalar, fieldCanHaveDiff, subIgnoreStruct, ignorePointed, dimensionsAlreadyInExpressionTree, typeStack, ILUtils.build(75, ILUtils.copy(testTree), ILUtils.copy(fieldNameTree)));
                }
                break;
            }
            case 5: {
                assert (typeSpec != null);
                ModifiedTypeSpec modifiedTypeSpec = (ModifiedTypeSpec)typeSpec.wrappedType;
                int sizeModifierInt = modifiedTypeSpec.sizeModifierValue();
                Tree sizeModifier = sizeModifierInt != -1 ? ILUtils.build(103, sizeModifierInt) : ILUtils.copy(modifiedTypeSpec.sizeModifier);
                this.createNestedLoopTree(inNLT, expressionTree, rootDecl, modifiedTypeSpec.elementType(), sizeModifier == null ? typeSizeModifier : sizeModifier, arraySize, insideElementTypeSpec, isScalar, canHaveDiff, ignoreStructure, ignorePointed, dimensionsAlreadyInExpressionTree, typeStack, testTree);
                if (inNLT.nodes == null) break;
                ((NestedLoopNode)((NestedLoopNode)inNLT).nodes.head).modifiedTypeAbove = modifiedTypeSpec;
                break;
            }
            default: {
                TapList<IterDescriptor> loopIterators = null;
                if (this.multiDirIterator != null) {
                    if (!this.multiDirIterator.justAnIndex()) {
                        if (this.multiDirIterator.isArray) {
                            isScalar = false;
                        } else {
                            loopIterators = new TapList<IterDescriptor>(this.multiDirIterator, null);
                        }
                    }
                    Tree multiDirIndexTree = this.multiDirIterator.buildIndexTree(this.usageSymbolTable, this.targetUnit);
                    if ((expressionTree = ILUtils.copy(expressionTree)).opCode() == 9) {
                        expressionTree.down(2).addChild(multiDirIndexTree, -1);
                    } else if (!this.multiDirIterator.isArray || !this.multiDirIterator.isImplicitCompleteDimension) {
                        expressionTree = ILUtils.build(9, expressionTree, ILUtils.build(71, multiDirIndexTree));
                    }
                }
                if (expressionTree.opCode() == 151 && expressionTree.down(2).opCode() == 138 && rootDecl != null && inNLT.protectAllocatedAssociated == null && (this.targetUnit.isC() && rootDecl.kind == 1 && ((VariableDecl)rootDecl).formalArgRank == -2 || TapEnv.inputLanguage() == 100)) {
                    inNLT.protectAllocatedAssociated = ILUtils.copy(expressionTree.down(1));
                }
                if (this.multiDirIterator != null && !this.multiDirIterator.justAnIndex()) {
                    inNLT.nodes = new TapList<NestedLoopNode>(new NestedLoopNode(expressionTree, typeSpec, null, null, isScalar, loopIterators, null, canHaveDiff), inNLT.nodes);
                    inNLT = (NestedLoopNode)((NestedLoopNode)inNLT).nodes.head;
                }
                inNLT.nodes = new TapList<NestedLoopNode>(new NestedLoopNode(expressionTree, typeSpec, typeSizeModifier, arraySize, isScalar, null, null, canHaveDiff), inNLT.nodes);
            }
        }
    }

    public TapList<Tree> collectTrees(TapList<Tree> collected) {
        return RefDescriptor.collectTreesRec(this.nestedLoopTree, collected);
    }

    public void forceStaticSave(RefDescriptor saveVarVarDescriptor) {
        this.companionVarDescriptor = saveVarVarDescriptor;
    }

    public void setCompanionVarDescriptor(RefDescriptor otherVarDescriptor) {
        this.companionVarDescriptor = otherVarDescriptor;
    }

    public boolean usesStaticSave() {
        return this.companionVarDescriptor != null;
    }

    public Tree makePush() {
        Tree resultTree;
        if (this.companionVarDescriptor != null) {
            this.mayProtectAccesses = false;
            resultTree = this.companionVarDescriptor.makeAssign(this);
            this.checkUnknownDimensionsForC(resultTree, "assign");
        } else {
            resultTree = this.makeStack(this.nestedLoopTree, "push", true);
            this.checkUnknownDimensionsForC(resultTree, "push");
        }
        return resultTree;
    }

    public Tree makePop() {
        Tree resultTree;
        if (this.companionVarDescriptor != null) {
            this.mayProtectAccesses = false;
            resultTree = this.makeAssign(this.companionVarDescriptor);
            this.checkUnknownDimensionsForC(resultTree, "assign");
        } else {
            resultTree = this.makeStack(this.nestedLoopTree, "pop", false);
            this.checkUnknownDimensionsForC(resultTree, "pop");
        }
        return resultTree;
    }

    public Tree makeRebase(TapList ignorePrimal, TapList ignoreDiff, Tree diffBaseVar, int numRebase) {
        Tree resultTree = this.makeRebase(this.nestedLoopTree, ignorePrimal, ignoreDiff, diffBaseVar, numRebase);
        this.checkUnknownDimensionsForC(resultTree, "rebase");
        return resultTree;
    }

    private Tree makeStack(NestedLoopNode node, String oper, boolean directOrder) {
        Tree expr;
        Tree result;
        if (node.nodes != null) {
            TapList loopsOutside = node.loopIterators;
            TapList nodes = node.nodes;
            TapList<Tree> codeInside = null;
            while (nodes != null) {
                codeInside = new TapList<Tree>(this.makeStack((NestedLoopNode)nodes.head, oper, directOrder), codeInside);
                nodes = nodes.tail;
            }
            if (directOrder) {
                codeInside = TapList.nreverse(codeInside);
            }
            result = codeInside != null && codeInside.tail == null ? (Tree)codeInside.head : ILUtils.build(27, codeInside);
            while (loopsOutside != null) {
                Tree loopHeader = ((IterDescriptor)loopsOutside.head).buildDoHeaderTree(this.usageSymbolTable, this.targetUnit, directOrder);
                result = ILUtils.build(121, null, null, loopHeader, result);
                loopsOutside = loopsOutside.tail;
            }
        } else if (node.branchIsEmpty()) {
            result = null;
        } else {
            String sizedType;
            expr = node.expression;
            WrapperTypeSpec type = node.type;
            Tree sizeModifier = ILUtils.copy(node.typeSizeModifier);
            if (sizeModifier != null && sizeModifier.opCode() == 96) {
                if (sizeModifier.stringValue().equals("undefinedSize") || sizeModifier.stringValue().equals("signed") || sizeModifier.stringValue().equals("unsigned")) {
                    sizeModifier = null;
                } else if (sizeModifier.stringValue().equals("short") || sizeModifier.stringValue().equals("long")) {
                    sizeModifier = ILUtils.build(96, "SIZE_OF_" + sizeModifier.stringValue());
                }
            } else if (sizeModifier != null && sizeModifier.opCode() == 134) {
                sizeModifier = sizeModifier.down(2);
            }
            Tree arraySize = ILUtils.copy(node.arraySize);
            String typeName = type == null ? "Undefined" : type.baseTypeName();
            Tree lengthMultiplier = null;
            result = null;
            if (this.nbControls >= 2) {
                int nBits = 1;
                int curCtr = this.nbControls - 1;
                while (curCtr >= 2) {
                    curCtr /= 2;
                    ++nBits;
                }
                sizedType = "Control" + nBits + "b";
            } else if (typeName.equals("character")) {
                sizedType = "Character";
                if (sizeModifier != null && (sizeModifier.opCode() != 103 || sizeModifier.intValue() != -2)) {
                    lengthMultiplier = sizeModifier;
                }
            } else if (typeName.equals("integer") || typeName.equals("float") || typeName.equals("complex")) {
                int baseSize;
                String string = typeName.equals("integer") ? "Integer" : (sizedType = typeName.equals("complex") ? "Complex" : "Real");
                if (sizeModifier == null) {
                    baseSize = typeName.equals("integer") ? TapEnv.get().integerSize : (typeName.equals("complex") ? 2 * TapEnv.get().realSize : TapEnv.get().realSize);
                } else if (sizeModifier.opCode() == 103) {
                    baseSize = sizeModifier.intValue() == -2 ? (typeName.equals("integer") ? 2 * TapEnv.get().integerSize : (typeName.equals("complex") ? 2 * TapEnv.get().doubleRealSize : TapEnv.get().doubleRealSize)) : (sizeModifier.intValue() == -3 ? (typeName.equals("integer") ? TapEnv.get().integerSize / 2 : (typeName.equals("complex") ? 2 * TapEnv.get().realSize : TapEnv.get().realSize)) : (sizeModifier.intValue() == -4 ? (typeName.equals("integer") ? 4 * TapEnv.get().integerSize : (typeName.equals("complex") ? 2 * TapEnv.get().doubleDoubleRealSize : TapEnv.get().doubleDoubleRealSize)) : sizeModifier.intValue()));
                } else {
                    baseSize = typeName.equals("integer") ? TapEnv.get().integerSize : TapEnv.get().realSize;
                    lengthMultiplier = ILUtils.buildSmartMulDiv(sizeModifier, -1, ILUtils.build(103, baseSize));
                }
                sizedType = sizedType + baseSize;
            } else {
                sizedType = typeName.equals("pointer") ? "Pointer" + TapEnv.get().pointerSize : (typeName.equals("boolean") ? "Boolean" : (typeName.equals("Undefined") ? "UNKNOWNTYPE" : typeName));
            }
            if (lengthMultiplier != null) {
                arraySize = ILUtils.mulTree(lengthMultiplier, arraySize);
            }
            TapList<Tree> finalArgs = null;
            String funcName = oper + sizedType;
            boolean argIsArray = arraySize != null && (!node.isScalar || !ILUtils.evalsToOne(arraySize));
            boolean isAllocatableArray = false;
            WrapperTypeSpec typeSpec = this.defSymbolTable.typeOf(expr);
            if (typeSpec != null) {
                this.allocationCheckingNeeded(expr);
                if (typeName.equals("pointer") && (isAllocatableArray = this.defSymbolTable.varHasModifier(expr, "allocatable"))) {
                    TapEnv.fileWarning(15, expr, "(AD07) Data-Flow recovery needs to restore allocatable pointer " + ILUtils.toString(expr) + ", not implemented yet");
                }
            }
            if (argIsArray) {
                funcName = funcName + "Array";
                finalArgs = new TapList<Tree>(arraySize, null);
            }
            expr = ILUtils.copy(expr);
            if (!argIsArray && MixedLanguageInfos.passesByValue(this.targetUnit.language(), this.targetUnit.language()) && "pop".equals(oper)) {
                expr = expr.opCode() == 151 && ILUtils.isNullOrNone(expr.down(2)) ? expr.cutChild(1) : ILUtils.build(4, expr);
            }
            if (!argIsArray && this.targetUnit.isC() && typeName.equals("pointer") && "pop".equals(oper)) {
                expr = ILUtils.build(32, ILUtils.build(154, ILUtils.build(154, ILUtils.build(204))), expr);
            }
            if (this.targetUnit.isFortran9x() && typeName.equals("pointer") && (oper.equals("push") || oper.equals("pop"))) {
                this.targetUnit.usesISO_C_BINDING = true;
                if (!isAllocatableArray) {
                    if (oper.equals("push")) {
                        expr = ILUtils.buildCLoc(expr, "C_LOC");
                    } else {
                        TapPair<NewSymbolHolder, Tree> buildPair = NewSymbolHolder.buildCptrTree(expr, this.targetUnit.privateSymbolTable(), false, "cptr", this.targetUnit, typeSpec, false);
                        NewSymbolHolder cptrSH = (NewSymbolHolder)buildPair.first;
                        result = (Tree)buildPair.second;
                        expr = cptrSH.makeNewRef(this.targetUnit.privateSymbolTable());
                    }
                }
            }
            finalArgs = new TapList<Tree>(expr, finalArgs);
            if (this.targetUnit.isFortran()) {
                funcName = funcName.toUpperCase();
            }
            Tree callFunc = ILUtils.buildCall(ILUtils.build(96, funcName), ILUtils.build(71, finalArgs));
            if (result == null) {
                result = callFunc;
            } else {
                result.addChild(callFunc, 1);
            }
            if (TapEnv.get().numberPushPops && this.ppLabel >= 0) {
                result.setAnnotation("endLineComment", ILUtils.build(180, "pp:" + this.ppLabel));
            }
        }
        if (result != null && this.mayProtectAccesses && node.expression != null && node.protectAllocatedAssociated != null) {
            if (oper.equals("push")) {
                RefDescriptor branchVarRefDescriptor = new RefDescriptor(ILUtils.build(103, 0), null, this.usageSymbolTable, this.usageSymbolTable, null, null, false, null, this.targetUnit);
                branchVarRefDescriptor.makeFixedControl(2);
                branchVarRefDescriptor.prepareForStack(this.targetUnit, -1, null, true);
                Tree pushZero = branchVarRefDescriptor.makePush();
                branchVarRefDescriptor = new RefDescriptor(ILUtils.build(103, 1), null, this.usageSymbolTable, this.usageSymbolTable, null, null, false, null, this.targetUnit);
                branchVarRefDescriptor.makeFixedControl(2);
                branchVarRefDescriptor.prepareForStack(this.targetUnit, -1, null, true);
                Tree pushOne = branchVarRefDescriptor.makePush();
                result = ILUtils.build(98, ILUtils.copy(node.protectAllocatedAssociated), ILUtils.build(27, result, pushOne), pushZero);
            } else if ("pop".equals(oper)) {
                if (this.toBranchVariable.first == null) {
                    this.toBranchVariable.first = new NewSymbolHolder("branch", this.targetUnit, (WrapperTypeSpec)this.toBranchVariable.second, -1);
                }
                ((NewSymbolHolder)this.toBranchVariable.first).declarationLevelMustInclude(this.targetUnit.privateSymbolTable());
                expr = ((NewSymbolHolder)this.toBranchVariable.first).makeNewRef(this.usageSymbolTable);
                RefDescriptor refDescriptor = new RefDescriptor(expr, null, this.usageSymbolTable, this.usageSymbolTable, null, null, false, null, this.targetUnit);
                refDescriptor.makeFixedControl(2);
                refDescriptor.prepareForStack(this.targetUnit, -1, null, true);
                Tree popZeroOrOne = refDescriptor.makePop();
                result = ILUtils.build(27, popZeroOrOne, ILUtils.build(98, ILUtils.build(68, ILUtils.copy(expr), ILUtils.build(103, 1)), result));
            } else {
                result = ILUtils.build(98, ILUtils.copy(node.protectAllocatedAssociated), result);
            }
        }
        return result;
    }

    private Tree makeRebase(NestedLoopNode node, TapList ignorePrimal, TapList ignoreDiff, Tree diffBaseVar, int numRebase) {
        Tree result;
        if (node.nodes != null) {
            TapList loopsOutside = node.loopIterators;
            TapList nodes = node.nodes;
            TapList<Tree> codeInside = null;
            while (nodes != null) {
                Tree subTree;
                NestedLoopNode subNode = (NestedLoopNode)nodes.head;
                TapList subIgnorePrimal = ignorePrimal;
                TapList<Object> subIgnoreDiff = ignoreDiff;
                if (subNode.expression.opCode() == 75) {
                    int rank = ILUtils.getFieldRank(subNode.expression.down(2));
                    if (ignorePrimal != null && ignorePrimal.head instanceof TapList) {
                        subIgnorePrimal = (TapList)TapList.nth(ignorePrimal, rank);
                    }
                    if (ignoreDiff != null && ignoreDiff.head instanceof TapList) {
                        subIgnoreDiff = (TapList)TapList.nth(ignoreDiff, rank);
                    }
                }
                if ((subTree = this.makeRebase((NestedLoopNode)nodes.head, subIgnorePrimal, node.canHaveDiff ? subIgnoreDiff : new TapList<Boolean>(Boolean.TRUE, null), node.canHaveDiff ? diffBaseVar : null, numRebase)) != null) {
                    codeInside = new TapList<Tree>(subTree, codeInside);
                }
                nodes = nodes.tail;
            }
            if (codeInside == null) {
                result = null;
            } else {
                result = codeInside.tail == null ? (Tree)codeInside.head : ILUtils.build(27, codeInside);
                while (loopsOutside != null) {
                    Tree loopHeader = ((IterDescriptor)loopsOutside.head).buildDoHeaderTree(this.usageSymbolTable, this.targetUnit, false);
                    result = ILUtils.build(121, null, null, loopHeader, result);
                    loopsOutside = loopsOutside.tail;
                }
            }
        } else if (node.branchIsEmpty() || TapList.trueForAll(ignorePrimal) && (!node.canHaveDiff || diffBaseVar == null || TapList.trueForAll(ignoreDiff))) {
            result = null;
        } else {
            String funcName;
            Tree expr = node.expression;
            WrapperTypeSpec type = node.type;
            Tree sizeModifier = ILUtils.copy(node.typeSizeModifier);
            result = null;
            if (sizeModifier != null && sizeModifier.opCode() == 96) {
                if (sizeModifier.stringValue().equals("undefinedSize") || sizeModifier.stringValue().equals("signed") || sizeModifier.stringValue().equals("unsigned")) {
                    sizeModifier = null;
                } else if (sizeModifier.stringValue().equals("short") || sizeModifier.stringValue().equals("long")) {
                    sizeModifier = ILUtils.build(96, "SIZE_OF_" + sizeModifier.stringValue());
                }
            } else if (sizeModifier != null && sizeModifier.opCode() == 134) {
                sizeModifier = sizeModifier.down(2);
            }
            Tree arraySize = ILUtils.copy(node.arraySize);
            boolean argIsArray = arraySize != null && (!node.isScalar || !ILUtils.evalsToOne(arraySize));
            TapList<Tree> finalArgs = null;
            if (numRebase != -1) {
                finalArgs = new TapList<Tree>(ILUtils.build(180, "Reb" + numRebase), null);
            }
            String string = funcName = !node.canHaveDiff || diffBaseVar == null || TapList.trueForAll(ignoreDiff) ? "ADMM_rebase" : "ADMM_rebaseShadowed";
            if (argIsArray) {
                funcName = funcName + "Array";
                finalArgs = new TapList<Tree>(arraySize, finalArgs);
            }
            expr = ILUtils.copy(expr);
            if (!argIsArray && MixedLanguageInfos.passesByValue(this.targetUnit.language(), this.targetUnit.language())) {
                expr = expr.opCode() == 151 && ILUtils.isNullOrNone(expr.down(2)) ? expr.cutChild(1) : ILUtils.build(4, expr);
            }
            if (this.targetUnit.isC() && !argIsArray) {
                expr = ILUtils.build(32, ILUtils.build(154, ILUtils.build(154, ILUtils.build(204))), expr);
            }
            Tree exprFortran = null;
            Tree primalExpr = null;
            if (this.targetUnit.isFortran9x() && !this.usageSymbolTable.varHasModifier(expr, "allocatable")) {
                TapPair<NewSymbolHolder, Tree> buildPair = NewSymbolHolder.buildCptrTree(expr, this.targetUnit.privateSymbolTable(), TapList.trueForAll(ignorePrimal), "cptr", this.targetUnit, type, true);
                NewSymbolHolder cptrSH = (NewSymbolHolder)buildPair.first;
                result = (Tree)buildPair.second;
                exprFortran = cptrSH.makeNewRef(this.usageSymbolTable);
                if (TapList.trueForAll(ignorePrimal)) {
                    primalExpr = exprFortran;
                }
            }
            if (node.canHaveDiff && diffBaseVar != null && !TapList.trueForAll(ignoreDiff)) {
                Tree diffExpr;
                if (this.targetUnit.isFortran9x() && !this.usageSymbolTable.varHasModifier(expr, "allocatable")) {
                    Tree tmpDiffExpr = ILUtils.replaceIdentStringOccurences(ILUtils.copy(expr), ILUtils.baseName(node.expression), diffBaseVar);
                    TapPair<NewSymbolHolder, Tree> buildPair = NewSymbolHolder.buildCptrTree(tmpDiffExpr, this.targetUnit.privateSymbolTable(), false, "cptrb", this.targetUnit, type, true);
                    NewSymbolHolder cptrSH = (NewSymbolHolder)buildPair.first;
                    Tree resultb = (Tree)buildPair.second;
                    result.addChild(ILUtils.copy(resultb.down(1)), 2);
                    result.addChild(ILUtils.copy(resultb.down(2)), 4);
                    diffExpr = cptrSH.makeNewRef(this.usageSymbolTable);
                } else {
                    diffExpr = ILUtils.replaceIdentStringOccurences(ILUtils.copy(expr), ILUtils.baseName(node.expression), diffBaseVar);
                }
                finalArgs = new TapList<Tree>(diffExpr, finalArgs);
            }
            if (exprFortran != null) {
                expr = exprFortran;
            }
            if (!TapList.trueForAll(ignorePrimal)) {
                primalExpr = expr;
            } else {
                if (primalExpr == null) {
                    primalExpr = ILUtils.build(103, 0);
                }
                if (this.targetUnit.isC()) {
                    primalExpr = ILUtils.build(32, ILUtils.build(154, ILUtils.build(204)), primalExpr);
                }
            }
            finalArgs = new TapList<Tree>(primalExpr, finalArgs);
            if (this.targetUnit.isFortran()) {
                funcName = funcName.toUpperCase();
            }
            Tree callFunc = ILUtils.buildCall(ILUtils.build(96, funcName), ILUtils.build(71, finalArgs));
            if (result == null) {
                result = callFunc;
            } else {
                result.addChild(callFunc, result.length() / 2 + 1);
            }
        }
        return result;
    }

    private void checkUnknownDimensionsForC(Tree resultTree, String action) {
        if (resultTree != null && this.targetUnit.isC() && this.zoneInfo != null) {
            WrapperTypeSpec type1 = this.completeType;
            WrapperTypeSpec type2 = this.knownRootTypeSpec;
            if (type1 == null) {
                type1 = this.usageSymbolTable.typeOf(this.patternTree);
            }
            if (ILUtils.containsUnknownDimension(this.patternTree)) {
                TapEnv.fileWarning(-1, null, "(AD15) Not sure how to " + action + (this.isDiff ? " the derivative " : " ") + ILUtils.toString(this.patternTree) + " of type:" + type1.showType() + (type2 == null ? "" : " (formal:" + type2.showType() + ')') + " with instruction:" + ILUtils.toString(resultTree));
            }
        }
    }

    public Tree makeInitialize() {
        Tree resultTree = this.makeInitialize(this.nestedLoopTree);
        this.checkUnknownDimensionsForC(resultTree, "initialize");
        return resultTree;
    }

    private Tree makeInitialize(NestedLoopNode node) {
        Tree result;
        if (node.nodes != null) {
            TapList loopsOutside = node.loopIterators;
            TapList nodes = node.nodes;
            TapList<Tree> codeInside = null;
            while (nodes != null) {
                codeInside = new TapList<Tree>(this.makeInitialize((NestedLoopNode)nodes.head), codeInside);
                nodes = nodes.tail;
            }
            result = (codeInside = TapList.nreverse(codeInside)) == null ? null : (codeInside.tail == null ? (Tree)codeInside.head : ILUtils.build(27, codeInside));
            while (loopsOutside != null) {
                Tree loopHeader = ((IterDescriptor)loopsOutside.head).buildDoHeaderTree(this.usageSymbolTable, this.targetUnit, true);
                result = ILUtils.build(121, null, null, loopHeader, result);
                loopsOutside = loopsOutside.tail;
            }
        } else if (node.branchIsEmpty()) {
            result = null;
        } else {
            Tree expr = node.expression;
            WrapperTypeSpec type = node.type;
            Tree sizeModifier = ILUtils.copy(node.typeSizeModifier);
            if (sizeModifier != null && sizeModifier.opCode() == 134) {
                sizeModifier = sizeModifier.down(2);
            }
            Tree zeroTree = null;
            if (TypeSpec.isA(type, 6)) {
                zeroTree = TapEnv.relatedLanguageIsC() ? ILUtils.build(96, "NULL") : ILUtils.buildCall(ILUtils.build(96, "null"), ILUtils.build(71));
            } else {
                String typeName;
                if (type == null) {
                    typeName = "NULL_TYPE_NAME";
                    TapEnv.fileWarning(15, expr, "(AD14) Differentiated procedure of " + TapEnv.relatedUnit().name() + " needs to initialize to 0 an undefined variable " + expr);
                    TapEnv.toolWarning(-1, "Warning: Wrong initialization value for " + ILUtils.toString(expr) + " of type null");
                } else {
                    typeName = type.baseTypeName();
                }
                if (typeName.equals("character")) {
                    zeroTree = ILUtils.build(180, "");
                } else if (typeName.equals("integer")) {
                    zeroTree = ILUtils.build(103, 0);
                } else if (typeName.equals("float") || typeName.equals("complex")) {
                    if (sizeModifier == null || TapEnv.relatedLanguageIsC()) {
                        zeroTree = PrimitiveTypeSpec.buildRealConstantZero();
                    } else if (sizeModifier.opCode() == 103) {
                        if (sizeModifier.intValue() == -2) {
                            zeroTree = ILUtils.build(160, "0.D0");
                        } else {
                            int sizeModifierValue = sizeModifier.intValue();
                            assert (type != null);
                            if (TapEnv.relatedLanguageIsFortran77() || type.hasUndefinedSize()) {
                                zeroTree = sizeModifierValue == 8 ? ILUtils.build(160, "0.D0") : PrimitiveTypeSpec.buildRealConstantZero();
                            } else {
                                if (typeName.equals("complex")) {
                                    sizeModifierValue /= 2;
                                }
                                zeroTree = ILUtils.build(160, "0.0_" + sizeModifierValue);
                            }
                        }
                    } else {
                        zeroTree = sizeModifier.opCode() == 180 ? ILUtils.build(160, "0.0_" + ILUtils.getIdentString(sizeModifier)) : PrimitiveTypeSpec.buildRealConstantZero();
                    }
                    if (typeName.equals("complex")) {
                        zeroTree = ILUtils.build(42, zeroTree, ILUtils.copy(zeroTree));
                    }
                } else if (typeName.equals("Undefined")) {
                    if (!CallGraph.isMessagePassingChannelName(ILUtils.toString(expr))) {
                        TapEnv.fileWarning(15, null, "(AD14) Differentiated procedure of " + TapEnv.relatedUnit().name() + " needs to initialize to 0 an undefined-type variable " + ILUtils.toString(expr));
                        new Throwable().printStackTrace();
                    }
                } else {
                    zeroTree = typeName.equals("NULL_TYPE_NAME") ? ILUtils.build(160, "0.0_NULLTYPE") : PrimitiveTypeSpec.buildRealConstantZero();
                }
            }
            if (zeroTree == null) {
                TapEnv.toolWarning(-1, "Warning: Cannot find an initialization value for " + ILUtils.toString(expr) + " of type " + type);
                zeroTree = ILUtils.build(103, 0);
            }
            result = TapEnv.associationByAddress() ? ILUtils.build(14, ILUtils.build(75, ILUtils.copy(expr), ILUtils.build(96, TapEnv.assocAddressDiffSuffix())), zeroTree) : ILUtils.build(14, ILUtils.copy(expr), zeroTree);
        }
        if (result != null && this.mayProtectAccesses && node.expression != null && node.protectAllocatedAssociated != null) {
            result = ILUtils.build(98, ILUtils.copy(node.protectAllocatedAssociated), result);
        }
        return result;
    }

    public Tree makeAssign(RefDescriptor rhsd) {
        Tree resultTree = this.makeAssign(this.nestedLoopTree, rhsd.nestedLoopTree, false, false);
        this.checkUnknownDimensionsForC(resultTree, "assign");
        return resultTree;
    }

    public Tree makeIncrement(RefDescriptor incrd, boolean needAtomic) {
        Tree resultTree = this.makeAssign(this.nestedLoopTree, incrd.nestedLoopTree, true, needAtomic);
        this.checkUnknownDimensionsForC(resultTree, "increment");
        return resultTree;
    }

    private Tree makeAssign(NestedLoopNode node, NestedLoopNode rhsNode, boolean increment, boolean needAtomic) {
        Tree result;
        if (node.nodes != null) {
            TapList loopsOutside = node.loopIterators;
            TapList nodes = node.nodes;
            TapList rhsNodes = rhsNode.nodes;
            TapList<Tree> codeInside = null;
            while (nodes != null && rhsNodes != null) {
                codeInside = new TapList<Tree>(this.makeAssign((NestedLoopNode)nodes.head, (NestedLoopNode)rhsNodes.head, increment, needAtomic), codeInside);
                nodes = nodes.tail;
                rhsNodes = rhsNodes.tail;
            }
            if (nodes != null || rhsNodes != null) {
                TapEnv.toolWarning(-1, "(RefDescriptor makeAssign) Different shapes in lhs ans rhs");
            }
            result = (codeInside = TapList.nreverse(codeInside)) != null && codeInside.tail == null ? (Tree)codeInside.head : ILUtils.build(27, codeInside);
            while (loopsOutside != null) {
                Tree loopHeader = ((IterDescriptor)loopsOutside.head).buildDoHeaderTree(this.usageSymbolTable, this.targetUnit, true);
                result = ILUtils.build(121, null, null, loopHeader, result);
                loopsOutside = loopsOutside.tail;
            }
        } else if (node.branchIsEmpty()) {
            result = null;
        } else {
            Tree newLhs = ILUtils.copy(node.expression);
            Tree newRhs = ILUtils.copy(rhsNode.expression);
            result = increment ? ILUtils.incrementByProtectedExpr(TapEnv.relatedLanguage(), newLhs, newRhs, needAtomic) : ILUtils.setToProtectedExpr(TapEnv.relatedLanguage(), newLhs, newRhs, node.modifiedTypeAbove == null ? node.type : node.modifiedTypeAbove);
        }
        if (result != null && this.mayProtectAccesses && node.expression != null && node.protectAllocatedAssociated != null) {
            result = ILUtils.build(98, ILUtils.copy(node.protectAllocatedAssociated), result);
        }
        return result;
    }

    private Tree makeNormDiff(Tree cumulTree, NestedLoopNode newNode, NestedLoopNode oldNode, RefDescriptor newRefDescriptor, RefDescriptor oldRefDescriptor) {
        Tree result;
        if (oldNode.nodes != null) {
            TapList loopsOutside = oldNode.loopIterators;
            TapList oldNodes = oldNode.nodes;
            TapList newNodes = newNode.nodes;
            TapList<Tree> codeInside = null;
            while (oldNodes != null && newNodes != null) {
                codeInside = new TapList<Tree>(this.makeNormDiff(cumulTree, (NestedLoopNode)newNodes.head, (NestedLoopNode)oldNodes.head, newRefDescriptor, oldRefDescriptor), codeInside);
                oldNodes = oldNodes.tail;
                newNodes = newNodes.tail;
            }
            if (oldNodes != null || newNodes != null) {
                TapEnv.toolWarning(-1, "(RefDescriptor makeNormDiff) different shapes in old and new");
            }
            result = (codeInside = TapList.nreverse(codeInside)) != null && codeInside.tail == null ? (Tree)codeInside.head : ILUtils.build(27, codeInside);
            while (loopsOutside != null) {
                Tree loopHeader = ((IterDescriptor)loopsOutside.head).buildDoHeaderTree(this.usageSymbolTable, this.targetUnit, true);
                result = ILUtils.build(121, null, null, loopHeader, result);
                loopsOutside = loopsOutside.tail;
            }
        } else if (newNode.branchIsEmpty() || oldNode.branchIsEmpty()) {
            result = null;
        } else {
            Tree oldExpr = ILUtils.copy(oldNode.expression);
            Tree newExpr = ILUtils.copy(newNode.expression);
            if (newNode.type != null && newNode.type.isAugmentedDoubleBase()) {
                newExpr = ILUtils.build(31, ILUtils.build(138), ILUtils.build(96, "getDiff"), ILUtils.build(71));
            }
            if (oldNode.type != null && oldNode.type.isAugmentedDoubleBase()) {
                oldExpr = ILUtils.build(31, ILUtils.build(138), ILUtils.build(96, "getDiff"), ILUtils.build(71));
            }
            TapList<ArrayDim> dimensions = oldRefDescriptor.completeType.getAllDimensions();
            boolean usesArrayNotation = false;
            while (!usesArrayNotation && dimensions != null) {
                if (dimensions.head instanceof ArrayDimPlusIter) {
                    usesArrayNotation = ((ArrayDimPlusIter)dimensions.head).iter.isArray;
                }
                dimensions = dimensions.tail;
            }
            result = ILUtils.build(155, ILUtils.build(182, newExpr, oldExpr), ILUtils.build(103, 2));
            if (usesArrayNotation) {
                result = ILUtils.reducSumProtectedExpr(result, null);
            }
            result = ILUtils.build(14, ILUtils.copy(cumulTree), ILUtils.build(3, ILUtils.copy(cumulTree), result));
        }
        return result;
    }

    public Tree makeRef() {
        Tree resultTree = this.makeRef(this.nestedLoopTree);
        this.checkUnknownDimensionsForC(resultTree, "build a reference to");
        return resultTree;
    }

    private Tree makeRef(NestedLoopNode node) {
        Tree result;
        if (node == null) {
            return ILUtils.copy(this.patternTree);
        }
        if (node.nodes != null) {
            TapList nodes = node.nodes;
            TapList<Tree> codeInside = null;
            while (nodes != null) {
                codeInside = new TapList<Tree>(this.makeRef((NestedLoopNode)nodes.head), codeInside);
                nodes = nodes.tail;
            }
            codeInside = TapList.nreverse(codeInside);
            result = ILUtils.build(71, codeInside);
            TapList loopsOutside = node.loopIterators;
            while (loopsOutside != null) {
                Tree loopHeader = ((IterDescriptor)loopsOutside.head).buildDoHeaderTree(this.usageSymbolTable, this.targetUnit, true);
                result = ILUtils.build(110, result, loopHeader);
                loopsOutside = loopsOutside.tail;
            }
        } else {
            result = node.branchIsEmpty() ? null : ILUtils.copy(node.expression);
        }
        return result;
    }

    private Tree allocationCheckingNeeded(Tree tree) {
        Tree result = null;
        int operator = tree.opCode();
        switch (operator) {
            case 9: {
                result = this.allocationCheckingNeeded(tree.down(1));
                break;
            }
            case 151: {
                result = tree.down(1);
                break;
            }
            case 75: {
                WrapperTypeSpec typeSpec = this.defSymbolTable.typeOf(tree.down(1));
                if (TypeSpec.isA(typeSpec.wrappedType, 6)) {
                    result = tree.down(1);
                    break;
                }
                result = this.allocationCheckingNeeded(tree.down(1));
                break;
            }
            case 96: {
                VariableDecl varDecl = this.defSymbolTable.getVariableDecl(tree.stringValue());
                if (varDecl == null || !TypeSpec.isA(varDecl.type().wrappedType, 6)) break;
                result = tree;
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    public String toString() {
        return "REFDESCRIPTOR: " + this.patternTree + " (" + this.completeType + ") " + this.nestedLoopTree;
    }

    private final class IterDescriptorUse {
        private boolean isImplicitCompleteDimension;
        private Tree explicitTree;
        private IterDescriptor iterDescriptor;
        public ArrayDim contextDim;

        private IterDescriptorUse(IterDescriptor iterDescriptor, Tree tree, ArrayDim contextDim) {
            this.iterDescriptor = iterDescriptor;
            int treeOper = tree.opCode();
            if (treeOper == 59 || treeOper == 12) {
                Tree explicitStride;
                Tree contextUpper;
                this.explicitTree = ILUtils.copy(tree);
                Tree contextLower = contextDim == null ? null : ILUtils.copy(contextDim.lowerTree());
                Tree tree2 = contextUpper = contextDim == null ? null : ILUtils.copy(contextDim.upperTree());
                if (ILUtils.isNullOrNone(this.explicitTree.down(1)) && contextLower != null) {
                    this.explicitTree.setChild(contextLower, 1);
                }
                if (ILUtils.isNullOrNone(this.explicitTree.down(2)) && contextUpper != null) {
                    this.explicitTree.setChild(contextUpper, 2);
                }
                if (tree.getAnnotation("subArrayAccess") != null) {
                    iterDescriptor.allSubArrayAccesses = true;
                }
                if (treeOper == 12) {
                    if (ILUtils.isNullOrNone(this.explicitTree.down(3))) {
                        explicitStride = ILUtils.build(103, 1);
                        this.explicitTree.setChild(explicitStride, 3);
                    } else {
                        explicitStride = this.explicitTree.down(3);
                    }
                } else {
                    explicitStride = ILUtils.build(103, 1);
                }
                if (iterDescriptor == RefDescriptor.this.multiDirIterator) {
                    this.isImplicitCompleteDimension = false;
                } else if (ILUtils.evalsToOne(explicitStride) && (contextLower == null || RefDescriptor.this.defSymbolTable.equalValues(this.explicitTree.down(1), contextLower)) && (contextUpper == null || RefDescriptor.this.defSymbolTable.equalValues(this.explicitTree.down(2), contextUpper))) {
                    this.isImplicitCompleteDimension = true;
                } else {
                    this.isImplicitCompleteDimension = false;
                    iterDescriptor.isImplicitCompleteDimension = false;
                }
                if (!ILUtils.isNullOrNone(this.explicitTree.down(1))) {
                    iterDescriptor.setInitTree(ILUtils.copy(this.explicitTree.down(1)));
                }
                iterDescriptor.preciseLengthTree(ILUtils.buildSizeTree(iterDescriptor.getInitTree(), this.explicitTree.down(2), explicitStride));
            } else if (treeOper == 64) {
                this.explicitTree = ILUtils.copy(tree);
                Tree explicitStride = this.explicitTree.down(4);
                if (ILUtils.isNullOrNone(explicitStride)) {
                    explicitStride = ILUtils.build(103, 1);
                    this.explicitTree.setChild(explicitStride, 4);
                }
                this.isImplicitCompleteDimension = false;
                iterDescriptor.isImplicitCompleteDimension = false;
                iterDescriptor.setInitTree(ILUtils.copy(this.explicitTree.down(2)));
                iterDescriptor.preciseLengthTree(ILUtils.buildSizeTree(this.explicitTree.down(2), this.explicitTree.down(3), explicitStride));
            }
        }

        private boolean comesFromHiddenScope(Tree sizeExpr, SymbolTable symbolTable) {
            boolean hidden = false;
            if (sizeExpr != null) {
                switch (sizeExpr.opCode()) {
                    case 96: {
                        hidden = symbolTable.getDecl(sizeExpr.stringValue(), 0, false) == null;
                        break;
                    }
                    case 75: {
                        hidden = this.comesFromHiddenScope(sizeExpr.down(1), symbolTable);
                        break;
                    }
                    default: {
                        Tree[] exps = sizeExpr.children();
                        for (int i = exps.length - 1; i >= 0 && !hidden; --i) {
                            hidden = this.comesFromHiddenScope(exps[i], symbolTable);
                        }
                    }
                }
            }
            return hidden;
        }

        private Tree buildIndexTree(SymbolTable usageSymbolTable, Unit targetUnit) {
            Tree initIndex;
            if (this.iterDescriptor.isArray) {
                if (this.iterDescriptor.allSubArrayAccesses) {
                    return ILUtils.copy(this.explicitTree.down(1));
                }
                if (this.isImplicitCompleteDimension || this.explicitTree.opCode() == 59) {
                    return ILUtils.build(12);
                }
                Tree arrayTriplet = ILUtils.copy(this.explicitTree);
                if (ILUtils.evalsToOne(arrayTriplet.down(3))) {
                    arrayTriplet.setChild(ILUtils.build(138), 3);
                }
                return arrayTriplet;
            }
            Tree index = this.iterDescriptor.buildIndexTree(usageSymbolTable, targetUnit);
            Tree from = this.explicitTree.down(1);
            Tree stride = null;
            if (this.explicitTree.opCode() == 12) {
                stride = this.explicitTree.down(3);
            }
            if (!ILUtils.evalsToZero(initIndex = this.iterDescriptor.getInitTree())) {
                index = ILUtils.subTree(index, initIndex);
            }
            return ILUtils.addTree(ILUtils.copy(from), stride == null ? index : ILUtils.mulTree(ILUtils.copy(stride), index));
        }

        public String toString() {
            return "IDUse(" + this.iterDescriptor + " explicitTree:" + this.explicitTree + ")";
        }
    }

    private static final class NestedLoopNode {
        private Tree expression;
        private Tree protectAllocatedAssociated;
        private WrapperTypeSpec type;
        private Tree typeSizeModifier;
        private ModifiedTypeSpec modifiedTypeAbove = null;
        private Tree arraySize;
        private boolean isScalar;
        private boolean canHaveDiff;
        private TapList<IterDescriptor> loopIterators;
        private TapList<NestedLoopNode> nodes;

        private NestedLoopNode(Tree expression, WrapperTypeSpec type, Tree typeSizeModifier, Tree arraySize, boolean isScalar, TapList<IterDescriptor> loopIterators, TapList<NestedLoopNode> nodes, boolean canHaveDiff) {
            this.expression = expression;
            this.type = type;
            this.typeSizeModifier = typeSizeModifier;
            this.arraySize = arraySize;
            this.isScalar = isScalar;
            this.canHaveDiff = canHaveDiff;
            this.loopIterators = loopIterators;
            this.nodes = nodes;
        }

        private boolean branchIsEmpty() {
            if (this.nodes != null) {
                boolean isEmpty = true;
                TapList<NestedLoopNode> inNodes = this.nodes;
                while (isEmpty && inNodes != null) {
                    isEmpty = ((NestedLoopNode)inNodes.head).branchIsEmpty();
                    inNodes = inNodes.tail;
                }
                return isEmpty;
            }
            return this.expression == null;
        }

        public String toString() {
            if (this.nodes != null) {
                StringBuilder result = new StringBuilder("FOR([");
                result.append(this.expression);
                result.append("] type:" + this.type);
                TapList<IterDescriptor> inLoops = this.loopIterators;
                while (inLoops != null) {
                    result.append(' ').append(inLoops.head);
                    inLoops = inLoops.tail;
                }
                result.append(") {\n");
                TapList<NestedLoopNode> inNodes = this.nodes;
                boolean firstNode = true;
                while (inNodes != null) {
                    if (firstNode) {
                        result.append(inNodes.head);
                    } else {
                        result.append(" ; ").append(inNodes.head);
                    }
                    firstNode = false;
                    inNodes = inNodes.tail;
                }
                return result + "\n}";
            }
            return this.expression + " type:" + this.type + '_' + this.typeSizeModifier + '[' + this.arraySize + ']';
        }
    }

    private static final class HintPlace {
        private Tree refTree;
        private String arrayNameInText;
        private String arrayNameInIdent;
        private Tree arrayTreeForCallSize;
        private int dim;
        private int ndims;

        private HintPlace(Tree refTree, String arrayNameInText, String arrayNameInIdent, Tree arrayTreeSize, int dim, int ndims) {
            this.refTree = refTree;
            this.arrayNameInText = arrayNameInText;
            this.arrayNameInIdent = arrayNameInIdent;
            this.arrayTreeForCallSize = arrayTreeSize;
            this.dim = dim;
            this.ndims = ndims;
        }

        private HintPlace deriveDim(int ndim, int ndims) {
            return new HintPlace(this.refTree, this.arrayNameInText, this.arrayNameInIdent, this.arrayTreeForCallSize, ndim, ndims);
        }

        private HintPlace deriveField(String fieldName) {
            return new HintPlace(this.refTree, this.arrayNameInText + "%" + fieldName, this.arrayNameInIdent + "_" + fieldName, this.arrayTreeForCallSize, 0, 1);
        }

        private void makeField(String fieldName) {
            this.arrayNameInText = this.arrayNameInText + "%" + fieldName;
            this.arrayNameInIdent = this.arrayNameInIdent + "_" + fieldName;
        }

        private void makePointerDest() {
            this.arrayNameInText = "*" + this.arrayNameInText;
            this.arrayNameInIdent = "Drf" + this.arrayNameInIdent;
        }

        private void cumulWith(HintPlace hintPlace2) {
            if ((this.arrayNameInText == null || this.arrayNameInText.isEmpty()) && hintPlace2.arrayNameInText != null && !hintPlace2.arrayNameInText.isEmpty()) {
                this.arrayNameInText = hintPlace2.arrayNameInText;
                this.arrayNameInIdent = hintPlace2.arrayNameInIdent;
                this.dim = hintPlace2.dim;
            }
        }

        public String toString() {
            return "HintPlace(" + this.refTree + " " + this.arrayNameInText + " " + this.arrayNameInIdent + " sz:" + this.arrayTreeForCallSize + " " + this.dim + "/" + this.ndims + ')';
        }
    }
}

