/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.representation;

import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TypeSpec;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.representation.ZoneInfo;
import fr.inria.tapenade.utils.TapIntList;
import java.io.IOException;

public final class PublicInfo {
    public ZoneInfo zone;
    public boolean coversFurther;
    private final int kind;
    private TapIntList ranks;
    private TapIntList realRanks;
    private TapIntList intRanks;
    private TapIntList ptrRanks;

    private PublicInfo(int kind) {
        this.kind = kind;
        this.ranks = null;
        this.realRanks = null;
        this.intRanks = null;
        this.ptrRanks = null;
    }

    public static PublicInfo createIdentityInfo(ZoneInfo zone) {
        PublicInfo ret = new PublicInfo(15);
        ret.zone = zone;
        return ret;
    }

    public static PublicInfo createResultInfo(int rank, ZoneInfo zone) {
        PublicInfo tmpPublicInfo = new PublicInfo(10);
        tmpPublicInfo.ranks = new TapIntList(rank, null);
        tmpPublicInfo.zone = zone;
        return tmpPublicInfo;
    }

    public static PublicInfo createParameterInfo(int rank, ZoneInfo zoneInfo, Unit destination, Unit origin) {
        PublicInfo tmpPublicInfo = new PublicInfo(7);
        tmpPublicInfo.ranks = new TapIntList(rank, null);
        tmpPublicInfo.zone = zoneInfo;
        if (destination != null && origin != null) {
            if (origin.isC() && destination.isFortran() && !zoneInfo.passesByValue(destination, 4)) {
                ZoneInfo zi = zoneInfo.copy();
                zi.shareActivity(zoneInfo);
                zi.accessTree = ILUtils.addPointerAccessAtBase(ILUtils.copy(zoneInfo.accessTree));
                zi.description = ILUtils.toString(zi.accessTree, 2);
                tmpPublicInfo.zone = zi;
            } else if (origin.isFortran() && destination.isC()) {
                if (TypeSpec.isA(zoneInfo.type, 6) && (ILUtils.isNullOrNone(zoneInfo.accessTree) || zoneInfo.accessTree.opCode() == 96)) {
                    tmpPublicInfo = null;
                } else {
                    ZoneInfo zi = zoneInfo.copy();
                    zi.shareActivity(zoneInfo);
                    zi.accessTree = ILUtils.addAddressOfAtBase(ILUtils.copy(zoneInfo.accessTree));
                    zi.description = ILUtils.toString(zi.accessTree, 4);
                    tmpPublicInfo.zone = zi;
                }
            }
        }
        return tmpPublicInfo;
    }

    public static PublicInfo createDeclaredInfo(TapIntList ranks, TapIntList realRanks, TapIntList intRanks, TapIntList ptrRanks) {
        PublicInfo tmpPublicInfo = new PublicInfo(8);
        tmpPublicInfo.ranks = ranks;
        tmpPublicInfo.realRanks = realRanks;
        tmpPublicInfo.intRanks = intRanks;
        tmpPublicInfo.ptrRanks = ptrRanks;
        return tmpPublicInfo;
    }

    public static int getPublicZoneFromDeclaredZone(PublicInfo[] translator, int declaredZone) {
        int k;
        boolean found = false;
        for (k = 0; !found && k < translator.length; ++k) {
            PublicInfo transk = translator[k];
            if (transk.kind != 8 || !TapIntList.contains(translator[k].ranks, declaredZone)) continue;
            found = true;
        }
        return found ? k - 1 : -1;
    }

    public TapIntList ranks(int whichKind) {
        switch (whichKind) {
            case 1: {
                return this.realRanks;
            }
            case 2: {
                return this.intRanks;
            }
            case 3: {
                return this.ptrRanks;
            }
        }
        return this.ranks;
    }

    public int getParamRank() {
        return this.ranks.head;
    }

    public int kind() {
        return this.kind;
    }

    public void dump() throws IOException {
        TapEnv.print(this.toString());
    }

    public String toString() {
        String access = this.zone == null ? "" : " " + ILUtils.toString(this.zone.accessTree);
        String allRanks = null;
        if (this.kind != 10 && this.kind != 7) {
            allRanks = (this.ranks == null ? "<_>" : this.ranks) + " [" + (this.realRanks == null ? "" : this.realRanks) + "] [" + (this.ptrRanks == null ? "" : this.ptrRanks) + "] [" + (this.intRanks == null ? "" : this.intRanks) + "]";
        }
        switch (this.kind) {
            case 7: {
                String passing = "?";
                if (TapEnv.relatedArrow() != null && TapEnv.relatedUnit() != null) {
                    passing = this.zone.passesByValue(TapEnv.relatedArrow().destination(), TapEnv.relatedUnit().language()) ? "value" : "reference";
                }
                return "parameter#" + (this.ranks != null ? Integer.valueOf(this.getParamRank()) : "?") + access + ", passed by " + passing;
            }
            case 10: {
                return "function result" + access;
            }
            case 8: {
                return "declared:" + allRanks;
            }
        }
        return "PublicInfo?" + allRanks;
    }
}

