/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.representation;

import fr.inria.tapenade.representation.ArrayDim;
import fr.inria.tapenade.representation.ArrayTypeSpec;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.MetaTypeSpec;
import fr.inria.tapenade.representation.PrimitiveTypeSpec;
import fr.inria.tapenade.representation.SymbolDecl;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.TypeDecl;
import fr.inria.tapenade.representation.TypeSpec;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.representation.WrapperTypeSpec;
import fr.inria.tapenade.utils.TapPair;
import fr.inria.tapenade.utils.TapTriplet;
import fr.inria.tapenade.utils.ToBool;
import fr.inria.tapenade.utils.Tree;
import java.io.IOException;

public final class PointerTypeSpec
extends TypeSpec {
    public WrapperTypeSpec destinationType;
    protected TapList<String> subAccess;
    public ArrayDim offsetLength;

    public PointerTypeSpec(WrapperTypeSpec destinationType, ArrayDim offsetLength) {
        super(6);
        this.offsetLength = offsetLength;
        this.destinationType = destinationType;
    }

    public boolean isInFactArray() {
        return this.offsetLength != null;
    }

    protected ArrayTypeSpec pointerToArrayTypeSpec() {
        ArrayTypeSpec result = null;
        if (this.offsetLength != null) {
            ArrayDim[] newDimensions = new ArrayDim[]{this.offsetLength};
            result = new ArrayTypeSpec(this.destinationType.pointerToArrayTypeSpec(), newDimensions);
        }
        return result;
    }

    @Override
    public TypeSpec wrappedType() {
        return this.destinationType;
    }

    @Override
    public void setWrappedType(TypeSpec type) {
        this.destinationType = type instanceof WrapperTypeSpec ? (WrapperTypeSpec)type : new WrapperTypeSpec(type);
    }

    @Override
    public TypeSpec nestedLevelType() {
        return this.destinationType;
    }

    @Override
    protected TypeSpec peelPointer() {
        return this.destinationType;
    }

    @Override
    protected String baseTypeName() {
        return "pointer";
    }

    @Override
    public WrapperTypeSpec baseTypeSpec(boolean stopOnPointer) {
        return this.destinationType.baseTypeSpec(stopOnPointer);
    }

    @Override
    public WrapperTypeSpec modifiedBaseTypeSpec() {
        return this.destinationType.modifiedBaseTypeSpec();
    }

    @Override
    protected boolean isAnIOTypeSpec(SymbolTable symbolTable) {
        return this.destinationType != null && this.destinationType.isAnIOTypeSpec(symbolTable);
    }

    @Override
    public boolean containsAPointer() {
        return true;
    }

    @Override
    public boolean containsUnknownDimension() {
        boolean result = false;
        if (this.destinationType != null) {
            result = this.destinationType.containsUnknownDimension();
        }
        if (!result) {
            result = this.offsetLength == null || this.offsetLength.isUnknown();
        }
        return result;
    }

    @Override
    public void updateAfterImports(SymbolTable symbolTable, TapList<TypeSpec> dejaVu) {
        if (this.destinationType != null) {
            this.destinationType.updateAfterImports(symbolTable, dejaVu);
        }
        if (this.offsetLength != null) {
            this.offsetLength.updateImportedDim(symbolTable);
        }
    }

    @Override
    protected int computeSize() {
        return 8;
    }

    @Override
    public boolean isPointer() {
        return true;
    }

    @Override
    protected boolean testComparesWith(TypeSpec other, int comparison, TypeSpec toThis, TypeSpec toOther, TapList<TapPair<TypeSpec, TypeSpec>> dejaVu) {
        if ((toOther = this.peelWrapperAndModifiedTo(other, toOther)) != null) {
            other = toOther.wrappedType();
        }
        if (this == other) {
            return true;
        }
        if (other == null) {
            if (PointerTypeSpec.testHasInference(comparison)) {
                if (toOther != null) {
                    toOther.setWrappedType(this);
                }
                return true;
            }
            return false;
        }
        if (TapEnv.relatedLanguageIsC() && PointerTypeSpec.testIsReceives(comparison) && other instanceof PrimitiveTypeSpec && ((PrimitiveTypeSpec)other).isInteger()) {
            return true;
        }
        if (TapEnv.relatedLanguageIsC() && PointerTypeSpec.testIsReceives(comparison) && other.isFunction()) {
            other = new PointerTypeSpec(new WrapperTypeSpec(other), null);
        }
        if (other instanceof MetaTypeSpec && PointerTypeSpec.testAcceptsUnspecified(comparison)) {
            other = ((MetaTypeSpec)other).makeLocalizedTypeSpec();
        }
        if (!(other instanceof PointerTypeSpec)) {
            return false;
        }
        PointerTypeSpec otherPointer = (PointerTypeSpec)other;
        if (TapList.containsObjectPair(dejaVu, this.destinationType, otherPointer.destinationType)) {
            return true;
        }
        boolean comparesWell = true;
        if (this.destinationType == null) {
            if (PointerTypeSpec.testHasInference(comparison)) {
                this.setWrappedType(otherPointer.destinationType == null ? null : otherPointer.destinationType.weakenForInference(comparison));
            } else {
                comparesWell = PointerTypeSpec.testAcceptsUnspecified(comparison);
            }
        } else if (otherPointer.destinationType == null) {
            if (PointerTypeSpec.testHasInference(comparison)) {
                otherPointer.setWrappedType(this.destinationType);
            } else {
                comparesWell = false;
            }
        } else if (!(PointerTypeSpec.testIsReceives(comparison) && (PointerTypeSpec.isA(this.destinationType, 9) || this.destinationType != null && this.destinationType.isCharacter() || PointerTypeSpec.isA(otherPointer.destinationType, 9) || otherPointer.destinationType != null && otherPointer.destinationType.isCharacter()))) {
            comparesWell = this.destinationType.comparesWith(otherPointer.destinationType, comparison, this, otherPointer, new TapList<TapPair<TypeSpec, TypeSpec>>(new TapPair<WrapperTypeSpec, WrapperTypeSpec>(this.destinationType, otherPointer.destinationType), dejaVu));
        }
        if (comparesWell) {
            comparesWell = this.offsetLength == null ? true : (otherPointer.offsetLength == null ? true : this.offsetLength.equalLength(otherPointer.offsetLength, comparison));
        }
        return comparesWell;
    }

    @Override
    protected TypeSpec weakenForInference(int comparison) {
        if (this.destinationType == null) {
            return new PointerTypeSpec(new WrapperTypeSpec(null), null);
        }
        return new PointerTypeSpec((WrapperTypeSpec)this.destinationType.weakenForInference(comparison), null);
    }

    @Override
    public PointerTypeSpec copy() {
        return new PointerTypeSpec((WrapperTypeSpec)this.destinationType.copy(), this.offsetLength);
    }

    @Override
    public TypeSpec copyStopOnComposite(Unit publishedUnit) {
        TypeSpec copyDestination = this.destinationType == null ? null : this.destinationType.copyStopOnComposite(publishedUnit);
        return copyDestination == this.destinationType ? this : new PointerTypeSpec((WrapperTypeSpec)copyDestination, this.offsetLength);
    }

    @Override
    public Tree buildConstantZero() {
        if (this.offsetLength != null) {
            ArrayTypeSpec arrayTypeSpec = this.pointerToArrayTypeSpec();
            assert (arrayTypeSpec != null);
            return arrayTypeSpec.buildConstantZero();
        }
        if (TapEnv.relatedLanguageIsC() || TapEnv.relatedUnit() == null) {
            return ILUtils.build(32, ILUtils.build(154, ILUtils.build(204)), ILUtils.build(103, 0));
        }
        return ILUtils.buildCall(ILUtils.build(96, "NULL"), ILUtils.build(71));
    }

    @Override
    protected boolean containsMetaType(TapList<TypeSpec> dejaVu) {
        if (TapList.contains(dejaVu, this)) {
            return false;
        }
        return this.destinationType.containsMetaType(new TapList<TypeSpec>(this, dejaVu)) || this.offsetLength == null || this.offsetLength.isUnknown();
    }

    @Override
    protected TypeSpec localize(TapList<TapTriplet<TypeSpec, TypeSpec, Boolean>> toAlreadyCopied, ToBool containsMeta) {
        PointerTypeSpec copiedResult = (PointerTypeSpec)this.findAlreadyCopiedType(toAlreadyCopied, containsMeta);
        if (copiedResult == null) {
            copiedResult = new PointerTypeSpec(null, this.offsetLength);
            copiedResult.setOrAddTypeDeclName(this.typeDeclName());
            TapTriplet<PointerTypeSpec, PointerTypeSpec, Boolean> alreadyRef = new TapTriplet<PointerTypeSpec, PointerTypeSpec, Boolean>(this, copiedResult, Boolean.FALSE);
            toAlreadyCopied.placdl(alreadyRef);
            if (this.destinationType != null) {
                copiedResult.destinationType = (WrapperTypeSpec)this.destinationType.localize(toAlreadyCopied, containsMeta);
            }
            if (containsMeta.get()) {
                alreadyRef.third = Boolean.TRUE;
            } else {
                alreadyRef.first = null;
            }
        }
        return copiedResult;
    }

    @Override
    public TypeSpec preciseDimensions(TypeSpec complementType, TapList<TapPair<TypeSpec, TypeSpec>> dejaVu, SymbolTable symbolTable) {
        if (!PointerTypeSpec.isA(complementType, 6)) {
            return this;
        }
        PointerTypeSpec precisedType = (PointerTypeSpec)TapList.cassq(this, dejaVu);
        if (precisedType == null) {
            precisedType = new PointerTypeSpec(null, null);
            dejaVu.placdl(new TapPair<PointerTypeSpec, PointerTypeSpec>(this, precisedType));
            WrapperTypeSpec precisedDestinationType = WrapperTypeSpec.preciseDimensions(this.destinationType, ((PointerTypeSpec)complementType).destinationType, dejaVu, symbolTable);
            ArrayDim precisedOffsetLength = ArrayDim.preciseDimension(this.offsetLength, ((PointerTypeSpec)complementType).offsetLength, symbolTable);
            if (precisedDestinationType == this.destinationType && precisedOffsetLength == this.offsetLength || precisedDestinationType.wrappedType == null || precisedOffsetLength == null) {
                precisedType = this;
            } else {
                precisedType.destinationType = precisedDestinationType;
                precisedType.offsetLength = precisedOffsetLength;
            }
        }
        return precisedType;
    }

    @Override
    public TypeSpec intToReal(TapList<TapPair<TypeSpec, TypeSpec>> dejaVu, SymbolTable symbolTable) {
        PointerTypeSpec convertedType = (PointerTypeSpec)TapList.cassq(this, dejaVu);
        if (convertedType == null) {
            convertedType = new PointerTypeSpec(null, null);
            dejaVu.placdl(new TapPair<PointerTypeSpec, PointerTypeSpec>(this, convertedType));
            WrapperTypeSpec convertedDestinationType = WrapperTypeSpec.intToReal(this.destinationType, dejaVu, symbolTable);
            if (convertedDestinationType == this.destinationType || convertedDestinationType.wrappedType == null) {
                convertedType = this;
            } else {
                convertedType.destinationType = convertedDestinationType;
                convertedType.offsetLength = this.offsetLength;
            }
        }
        return convertedType;
    }

    @Override
    protected TypeSpec realToComplex(TapList<TapPair<TypeSpec, TypeSpec>> dejaVu, WrapperTypeSpec complexTypeSpec) {
        PointerTypeSpec convertedType = (PointerTypeSpec)TapList.cassq(this, dejaVu);
        if (convertedType == null) {
            convertedType = new PointerTypeSpec(null, null);
            dejaVu.placdl(new TapPair<PointerTypeSpec, PointerTypeSpec>(this, convertedType));
            TypeSpec convertedDestinationType = this.destinationType.realToComplex(dejaVu, complexTypeSpec);
            if (convertedDestinationType == this.destinationType || ((WrapperTypeSpec)convertedDestinationType).wrappedType == null) {
                convertedType = this;
            } else {
                convertedType.destinationType = convertedDestinationType;
                convertedType.offsetLength = this.offsetLength;
            }
        }
        return convertedType;
    }

    @Override
    public WrapperTypeSpec differentiateTypeSpec(SymbolTable symbolTable, SymbolTable srcSymbolTable, int diffUnitSort, String fSuffix, boolean localDecl, boolean multiDirMode, ArrayDim multiDirDimensionMax, String hintArrayNameInText, String hintArrayNameInIdent, Tree hintArrayNameTree, Tree nameTree) {
        boolean isForAdjoint;
        WrapperTypeSpec result = null;
        ArrayDim diffOffsetLength = this.offsetLength;
        if (TapEnv.relatedLanguageIsFortran()) {
            multiDirDimensionMax = new ArrayDim(ILUtils.build(59, ILUtils.build(138), ILUtils.build(138)), null, null, null, -1, 0, 0);
        }
        WrapperTypeSpec activeDestinationType = this.destinationType.differentiateTypeSpecMemo(symbolTable, srcSymbolTable, diffUnitSort, fSuffix, false, multiDirMode, multiDirDimensionMax, "*" + hintArrayNameInText, "Drf" + hintArrayNameInIdent, hintArrayNameTree, null);
        boolean bl = isForAdjoint = diffUnitSort == 2 || diffUnitSort == 3;
        if (activeDestinationType == null && this.subAccess != null && isForAdjoint) {
            activeDestinationType = this.destinationType;
        }
        if (activeDestinationType != null) {
            PointerTypeSpec diffPointerType = new PointerTypeSpec(activeDestinationType, diffOffsetLength);
            if (!isForAdjoint) {
                diffPointerType.subAccess = this.subAccess;
            }
            result = new WrapperTypeSpec(diffPointerType);
        }
        if (TapEnv.associationByAddress()) {
            this.diffTypeSpec = result;
        }
        return result;
    }

    @Override
    protected void addDiffTypeSpec(SymbolTable symbolTable, SymbolTable srcSymbolTable) {
        this.destinationType.addRefDiffTypeSpec(symbolTable, srcSymbolTable);
    }

    @Override
    protected void cumulActiveParts(TapList diffInfos, SymbolTable symbolTable) {
        if (diffInfos != null && this.destinationType != null) {
            TypeDecl typeDecl;
            this.destinationType.cumulActiveParts(diffInfos.tail, symbolTable);
            if (this.typeDeclName() != null && this.needsADiffType(null) && (typeDecl = symbolTable.getTypeDecl(this.typeDeclName())) != null) {
                typeDecl.setActive(true);
            }
        }
    }

    @Override
    public boolean needsADiffType(TapList<TypeSpec> dejaVu) {
        return this.destinationType != null && !TapList.contains(dejaVu, this) && this.destinationType.needsADiffType(new TapList<TypeSpec>(this, dejaVu));
    }

    @Override
    public boolean isDifferentiated(TapList<TypeSpec> dejaVu) {
        return this.destinationType != null && !TapList.contains(dejaVu, this) && this.destinationType.isDifferentiated(new TapList<TypeSpec>(this, dejaVu));
    }

    @Override
    protected boolean checkTypeSpecValidity(TapList<TypeSpec> dejaVu) {
        if (this.destinationType != null && this.destinationType.wrappedType == this) {
            TapEnv.fileWarning(15, null, "(TC41) Illegal recursive type definition " + this.showType());
            return false;
        }
        assert (this.destinationType != null);
        return this.destinationType.checkTypeSpecValidity(dejaVu);
    }

    @Override
    public Tree generateTree(SymbolTable symbolTable, TapList<SymbolDecl> dependsOn, TapList<SymbolDecl> shortNames, boolean useShortNames, TapList<TypeSpec> dejaVu) {
        Tree result;
        if (TapList.contains(dejaVu, this)) {
            TapEnv.toolWarning(-1, "(TypeSpec tree regeneration) circular type");
            result = ILUtils.build(96, "CircularType");
        } else {
            dejaVu = new TapList<TypeSpec>(this, dejaVu);
            if (this.offsetLength != null) {
                ArrayTypeSpec arrayTypeSpec = this.pointerToArrayTypeSpec();
                assert (arrayTypeSpec != null);
                result = arrayTypeSpec.generateTree(symbolTable, dependsOn, shortNames, true, dejaVu);
            } else {
                this.destinationType = this.destinationType.equalsDiffTypeSpecAndTypeSpec();
                result = this.destinationType.generateTree(symbolTable, dependsOn, shortNames, true, dejaVu);
                result = PointerTypeSpec.addTypeModifiers(result, ILUtils.buildListIdents(this.subAccess));
                result = ILUtils.build(154, result);
            }
        }
        return result;
    }

    @Override
    public String showType() {
        int language = TapEnv.relatedUnit() != null ? TapEnv.relatedUnit().language() : -1;
        return (this.destinationType == null ? "?" : this.destinationType.showType()) + (TapEnv.isFortran(language) ? " POINTER" : (this.offsetLength == null ? "*" : "[" + this.offsetLength.showType() + "]"));
    }

    @Override
    public void dump() throws IOException {
        TapEnv.print(this.toString());
    }

    @Override
    public String toString() {
        return (this.typeDeclName() == null ? "" : "\"" + this.typeDeclName() + "\":") + "*" + (this.offsetLength == null ? "" : "[" + this.offsetLength + "]") + (this.subAccess == null ? "" : this.subAccess) + (this.destinationType == null ? "?" : this.destinationType.toString());
    }
}

