/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.representation;

import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;

public final class MixedLanguageInfos {
    private final int origLangCaller;
    private final int destLangCallee;
    private final String parameterPassing;
    private final String functionBinding;
    private final String suffix;

    public MixedLanguageInfos(int caller, int callee, String passing, String binding, String suffix) {
        this.origLangCaller = caller;
        this.destLangCallee = callee;
        this.parameterPassing = passing;
        this.functionBinding = binding;
        this.suffix = suffix;
    }

    public static TapList<MixedLanguageInfos> defaultMixedLangInfos() {
        MixedLanguageInfos fortranInfos = new MixedLanguageInfos(1, 1, "byRef", "", null);
        MixedLanguageInfos fortran90Infos = new MixedLanguageInfos(2, 2, "byRef", "", null);
        MixedLanguageInfos fortran2003Infos = new MixedLanguageInfos(3, 3, "byRef", "", null);
        MixedLanguageInfos cInfos = new MixedLanguageInfos(4, 4, "byValue", "", null);
        MixedLanguageInfos cFortranInfos = new MixedLanguageInfos(4, 1, "byRef", "remove", "_");
        MixedLanguageInfos fortranCInfos = new MixedLanguageInfos(1, 4, "byValue", "add", "_");
        MixedLanguageInfos cFortran90Infos = new MixedLanguageInfos(4, 2, "byRef", "remove", "_");
        MixedLanguageInfos fortran90CInfos = new MixedLanguageInfos(2, 4, "byValue", "add", "_");
        MixedLanguageInfos cFortran2003Infos = new MixedLanguageInfos(4, 3, "byValue", "remove", "_");
        MixedLanguageInfos fortran2003CInfos = new MixedLanguageInfos(3, 4, "byValue", "add", "_");
        MixedLanguageInfos cPlusPlusInfos = new MixedLanguageInfos(5, 5, "byValue", "", null);
        MixedLanguageInfos cPlusPlusCInfos = new MixedLanguageInfos(5, 4, "byValue", "", null);
        TapEnv.addMixedLanguageInfos(fortranInfos);
        TapEnv.addMixedLanguageInfos(fortran90Infos);
        TapEnv.addMixedLanguageInfos(fortran2003Infos);
        TapEnv.addMixedLanguageInfos(cInfos);
        TapEnv.addMixedLanguageInfos(cFortranInfos);
        TapEnv.addMixedLanguageInfos(fortranCInfos);
        TapEnv.addMixedLanguageInfos(cFortran90Infos);
        TapEnv.addMixedLanguageInfos(fortran90CInfos);
        TapEnv.addMixedLanguageInfos(cFortran2003Infos);
        TapEnv.addMixedLanguageInfos(fortran2003CInfos);
        TapEnv.addMixedLanguageInfos(cPlusPlusInfos);
        TapEnv.addMixedLanguageInfos(cPlusPlusCInfos);
        return TapEnv.mixedLanguageInfos();
    }

    public static boolean passesByValue(int callerLanguage, int calledLanguage) {
        String parameterPassing = MixedLanguageInfos.getParameterPassing(callerLanguage, calledLanguage, TapEnv.mixedLanguageInfos());
        return parameterPassing == null || parameterPassing.toLowerCase().startsWith("byvalue");
    }

    public static String getParameterPassing(int origLang, int destLang, TapList<MixedLanguageInfos> infos) {
        String result = null;
        TapList<MixedLanguageInfos> mlInfos = infos;
        if (TapEnv.isFortran(origLang) && TapEnv.isFortran(destLang)) {
            destLang = origLang;
        }
        while (result == null && mlInfos != null) {
            MixedLanguageInfos mixedLanguageInfos = (MixedLanguageInfos)mlInfos.head;
            if (mixedLanguageInfos.getOrigLangCaller() == origLang && mixedLanguageInfos.getDestLangCallee() == destLang) {
                result = mixedLanguageInfos.getParameterPassing();
            }
            mlInfos = mlInfos.tail;
        }
        return result;
    }

    public int getOrigLangCaller() {
        return this.origLangCaller;
    }

    public int getDestLangCallee() {
        return this.destLangCallee;
    }

    private String getParameterPassing() {
        return this.parameterPassing;
    }

    public String getFunctionBinding() {
        return this.functionBinding;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public String toString() {
        return this.origLangCaller + "->" + this.destLangCallee + " " + this.parameterPassing + " " + this.functionBinding + " " + this.suffix;
    }
}

