/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.representation;

import fr.inria.tapenade.representation.CallGraph;
import fr.inria.tapenade.representation.CompositeTypeSpec;
import fr.inria.tapenade.representation.FieldDecl;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.MemMap;
import fr.inria.tapenade.representation.SubVariableDecl;
import fr.inria.tapenade.representation.SymbolDecl;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.TypeSpec;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.representation.VarStartBoundary;
import fr.inria.tapenade.representation.VariableDecl;
import fr.inria.tapenade.representation.WrapperTypeSpec;
import fr.inria.tapenade.representation.ZoneAllocator;
import fr.inria.tapenade.representation.ZoneInfoAccessElements;
import fr.inria.tapenade.utils.TapIntList;
import fr.inria.tapenade.utils.TapPair;
import fr.inria.tapenade.utils.ToBool;
import fr.inria.tapenade.utils.Tree;

public final class MemoryMaps {
    public TapList<MemMap> maps = new TapList<Object>(null, null);
    public TapList<VarStartBoundary> mapAccesses = new TapList<Object>(null, null);

    public MemMap getSetMemMap(String commonName) {
        MemMap result = this.getMemMap(commonName);
        if (result == null) {
            result = new MemMap(commonName);
            this.maps.placdl(result);
        }
        return result;
    }

    public MemMap getMemMap(String commonName) {
        if (commonName != null) {
            TapList<MemMap> inMaps = this.maps;
            while (inMaps.tail != null) {
                if (commonName.equals(((MemMap)inMaps.tail.head).name)) {
                    return (MemMap)inMaps.tail.head;
                }
                inMaps = inMaps.tail;
            }
        }
        return null;
    }

    public void addRegistration(VarStartBoundary entry) {
        this.mapAccesses.tail = new TapList<VarStartBoundary>(entry, this.mapAccesses.tail);
    }

    public VarStartBoundary getRegistration(SymbolDecl symbolDecl) {
        TapList inMapAccesses = this.mapAccesses.tail;
        VarStartBoundary entry = null;
        while (entry == null && inMapAccesses != null) {
            if (((VarStartBoundary)inMapAccesses.head).variableDecl == symbolDecl) {
                entry = (VarStartBoundary)inMapAccesses.head;
            }
            inMapAccesses = inMapAccesses.tail;
        }
        return entry;
    }

    public VarStartBoundary delRegistration(SymbolDecl symbolDecl) {
        TapList<VarStartBoundary> inMapAccesses = this.mapAccesses;
        VarStartBoundary entry = null;
        while (entry == null && inMapAccesses.tail != null) {
            if (((VarStartBoundary)inMapAccesses.tail.head).variableDecl == symbolDecl) {
                entry = (VarStartBoundary)inMapAccesses.tail.head;
                inMapAccesses.tail = inMapAccesses.tail.tail;
                continue;
            }
            inMapAccesses = inMapAccesses.tail;
        }
        return entry;
    }

    public static void placeCEDSIntoMemoryMaps(Tree declaration, SymbolTable declSymbolTable, Unit declUnit, MemoryMaps unitMaps, CallGraph callGraph) {
        switch (declaration.opCode()) {
            case 39: {
                Tree commonNameTree = declaration.down(1);
                String commonName = ILUtils.isNullOrNone(commonNameTree) ? "" : commonNameTree.stringValue();
                MemoryMaps.placeCommonIntoMemoryMap(declaration, commonName, declSymbolTable, declUnit, unitMaps, callGraph.globalFortranMaps);
                break;
            }
            case 69: {
                MemoryMaps.placeEquivalenceIntoMemoryMap(declaration.children(), declSymbolTable, declUnit, unitMaps, callGraph.globalFortranMaps);
                break;
            }
            case 51: 
            case 171: {
                MemoryMaps.placeDSIntoMemoryMap(declaration, declSymbolTable, declUnit, unitMaps, callGraph.globalFortranMaps);
                break;
            }
            case 2: {
                if (!ILUtils.isIdent(declaration.down(1).down(1), "bind", false)) break;
                MemoryMaps.placeBindCIntoMemoryMap(declaration.down(1).down(2), declaration.down(2), declSymbolTable, declUnit, unitMaps, callGraph);
            }
        }
    }

    private static void placeCommonIntoMemoryMap(Tree declaration, String commonName, SymbolTable declSymbolTable, Unit declUnit, MemoryMaps unitMaps, MemoryMaps globalMaps) {
        MemMap commonMap = globalMaps.getSetMemMap(commonName);
        Tree[] commonVars = declaration.down(2).children();
        int offset = 0;
        boolean infiniteEndOffset = false;
        for (int i = 0; i < commonVars.length; ++i) {
            VarStartBoundary previousRegistration;
            int varSize;
            String varName = ILUtils.baseName(commonVars[i]);
            VariableDecl varDecl = declSymbolTable.getVariableDecl(varName);
            int n = varSize = varDecl != null && varDecl.type() != null ? varDecl.type().size() : -1;
            if (varSize < 0) {
                TapEnv.fileWarning(15, declaration, "Cannot compute the size of variable " + varName + " in common " + commonName);
                infiniteEndOffset = true;
                continue;
            }
            if (unitMaps != null && (previousRegistration = unitMaps.getRegistration(varDecl)) != null) {
                commonMap.absorb(previousRegistration.map, previousRegistration.boundary.offset - offset, unitMaps, globalMaps);
            } else {
                previousRegistration = globalMaps.getRegistration(varDecl);
                if (previousRegistration != null) {
                    if (previousRegistration.map.name.startsWith("/Fortran_Save_")) {
                        previousRegistration.map.removeVariableFrom(varDecl, globalMaps);
                        commonMap.insertVariableAt(offset, varSize, varDecl, declSymbolTable, globalMaps);
                    } else {
                        TapEnv.fileError(commonVars[i], "(TC28) Variable " + varDecl.symbol + " cannot be added to common " + commonName + " because it is already in common " + previousRegistration.map.name);
                    }
                } else {
                    commonMap.insertVariableAt(offset, varSize, varDecl, declSymbolTable, globalMaps);
                }
            }
            offset += varSize;
        }
        ToBool toCommonMapInfiniteEndOffset = new ToBool(false);
        int commonMapLastOffset = commonMap.getLastOffset(toCommonMapInfiniteEndOffset);
        if (!infiniteEndOffset && !toCommonMapInfiniteEndOffset.get() && commonMapLastOffset != offset) {
            TapEnv.fileWarning(15, null, "(TC29) Common " + commonName + " declared with two different sizes: here " + offset + " vs " + commonMapLastOffset + " elsewhere");
        }
    }

    private static void placeBindCIntoMemoryMap(Tree bindExprs, Tree localExprs, SymbolTable declSymbolTable, Unit declUnit, MemoryMaps unitMaps, CallGraph callGraph) {
        String bindName;
        VariableDecl bindDecl;
        MemoryMaps globalFortranMaps = callGraph.globalFortranMaps;
        String bindLang = ILUtils.getIdentString(bindExprs.down(1));
        SymbolTable bindSymbolTable = callGraph.languageRootSymbolTable(4);
        Tree localExpr = localExprs.down(1);
        String localName = ILUtils.getIdentString(localExpr);
        boolean localNameIsCommon = localName.startsWith("/") && localName.endsWith("/");
        Tree bindExpr = ILUtils.getNamedElement(bindExprs, "name");
        if (bindExpr == null && bindExprs.length() >= 2) {
            bindExpr = bindExprs.down(2);
        }
        if ((bindDecl = bindSymbolTable.getVariableDecl(bindName = bindExpr == null ? localName : bindExpr.stringValue())) == null) {
            TapEnv.fileError(bindExprs, "(TCxx) No C variable named " + bindName + " to bind with");
        } else {
            TapList<ZoneInfoAccessElements> bindDeclCMap = callGraph.getCglobalMap(bindDecl);
            MemMap receivingMap = null;
            int receivingOffset = 0;
            if (localNameIsCommon) {
                receivingMap = globalFortranMaps.getSetMemMap(localName);
                receivingOffset = 0;
            } else {
                VariableDecl localDecl = declSymbolTable.getVariableDecl(localName);
                if (localDecl == null) {
                    TapEnv.fileError(localExprs, "(TCxx) No Fortran variable named " + localName + " to bind");
                } else {
                    VarStartBoundary registration0g;
                    VarStartBoundary registration0 = unitMaps == null ? null : unitMaps.getRegistration(localDecl);
                    VarStartBoundary varStartBoundary = registration0g = registration0 == null ? globalFortranMaps.getRegistration(localDecl) : null;
                    if (registration0g == null) {
                        MemMap newMap = globalFortranMaps.getSetMemMap(null);
                        if (registration0 != null) {
                            newMap.absorb(registration0.map, 0, unitMaps, globalFortranMaps);
                        } else {
                            int localSize;
                            int n = localSize = localDecl.type() != null ? localDecl.type().size() : -1;
                            if (localSize < 0) {
                                TapEnv.fileWarning(15, localExprs, "Cannot compute the size of variable " + localName);
                                localSize = 0;
                            }
                            newMap.insertVariableAt(0, localSize, localDecl, declSymbolTable, globalFortranMaps);
                        }
                        registration0g = globalFortranMaps.getRegistration(localDecl);
                    }
                    receivingMap = registration0g.map;
                    receivingOffset = registration0g.boundary.offset;
                }
            }
            if (receivingMap != null) {
                while (bindDeclCMap != null) {
                    ZoneInfoAccessElements cAccess = (ZoneInfoAccessElements)bindDeclCMap.head;
                    MemoryMaps.placeCAccessIntoFortranMap(cAccess, receivingMap, bindName, receivingOffset, globalFortranMaps);
                    bindDeclCMap = bindDeclCMap.tail;
                }
            }
        }
    }

    public static void placeCAccessIntoFortranMap(ZoneInfoAccessElements cAccess, MemMap receivingMap, String bindName, int receivingOffset, MemoryMaps globalFortranMaps) {
        VariableDecl oneCdecl = (VariableDecl)cAccess.symbolDecl;
        SymbolTable oneCaccessSymbolTable = cAccess.symbolTable;
        TapList<Object> toParts = new TapList<Object>(null, null);
        MemoryMaps.splitStructs(oneCdecl.type(), bindName, ILUtils.build(96, bindName), null, toParts, oneCdecl, oneCaccessSymbolTable);
        toParts = toParts.tail;
        int offsetInMap = receivingOffset;
        while (toParts != null) {
            SubVariableDecl subBindDecl = (SubVariableDecl)((TapPair)toParts.head).second;
            int subBindSize = (Integer)((TapPair)toParts.head).first;
            receivingMap.insertVariableAt(offsetInMap, subBindSize, subBindDecl, oneCaccessSymbolTable, globalFortranMaps);
            offsetInMap += subBindSize;
            toParts = toParts.tail;
        }
    }

    private static TapList<TapPair<Integer, SubVariableDecl>> splitStructs(TypeSpec type, String name, Tree accessTree, TapIntList revItinerary, TapList<TapPair<Integer, SubVariableDecl>> tlParts, VariableDecl varDecl, SymbolTable symbolTable) {
        TapList<Object> hdResult;
        TapList<Object> tlResult = hdResult = new TapList<Object>(null, null);
        switch (type.kind()) {
            case 14: {
                tlParts = MemoryMaps.splitStructs(((WrapperTypeSpec)type).wrappedType, name, accessTree, revItinerary, tlParts, varDecl, symbolTable);
                break;
            }
            case 2: 
            case 5: {
                tlParts = MemoryMaps.splitStructs(type.elementType(), name, accessTree, revItinerary, tlParts, varDecl, symbolTable);
                break;
            }
            case 21: {
                CompositeTypeSpec compositeTypeSpec = (CompositeTypeSpec)type;
                for (int i = 0; i < compositeTypeSpec.fields.length; ++i) {
                    FieldDecl fieldDecl = compositeTypeSpec.fields[i];
                    Tree fieldTree = ILUtils.build(96, fieldDecl.symbol);
                    ILUtils.setFieldRank(fieldTree, i);
                    tlParts = MemoryMaps.splitStructs(fieldDecl.type(), name + "%" + fieldDecl.symbol, ILUtils.build(75, ILUtils.copy(accessTree), fieldTree), new TapIntList(i, revItinerary), tlParts, varDecl, symbolTable);
                }
                break;
            }
            default: {
                int size = type.size();
                Tree dummyNameTree = ILUtils.build(96, name);
                SubVariableDecl dummyVarDecl = new SubVariableDecl(dummyNameTree, new WrapperTypeSpec(type), varDecl, TapIntList.reverse(revItinerary), accessTree);
                tlParts = tlParts.placdl(new TapPair<Integer, SubVariableDecl>(size, dummyVarDecl));
            }
        }
        return tlParts;
    }

    private static void placeEquivalenceIntoMemoryMap(Tree[] equivalenceDecls, SymbolTable declSymbolTable, Unit declUnit, MemoryMaps unitMaps, MemoryMaps globalMaps) {
        for (int i = equivalenceDecls.length - 1; i >= 0; --i) {
            Tree[] equivSet = equivalenceDecls[i].children();
            Tree lastChild = equivSet[equivSet.length - 1];
            VariableDecl varDecl0 = declSymbolTable.getVariableDecl(ILUtils.baseName(lastChild));
            int varSize0 = varDecl0 == null || varDecl0.type() == null ? -1 : varDecl0.type().size();
            int offset0 = declSymbolTable.refOffset(lastChild);
            VarStartBoundary registration0 = unitMaps == null ? null : unitMaps.getRegistration(varDecl0);
            VarStartBoundary registration0g = registration0 == null ? globalMaps.getRegistration(varDecl0) : null;
            for (int j = equivSet.length - 2; j >= 0; --j) {
                VarStartBoundary registration1g;
                VariableDecl varDecl1 = declSymbolTable.getVariableDecl(ILUtils.baseName(equivSet[j]));
                int varSize1 = varDecl1 == null || varDecl1.type() == null ? -1 : varDecl1.type().size();
                int offset1 = declSymbolTable.refOffset(equivSet[j]);
                VarStartBoundary registration1 = unitMaps == null ? null : unitMaps.getRegistration(varDecl1);
                VarStartBoundary varStartBoundary = registration1g = registration1 == null ? globalMaps.getRegistration(varDecl1) : null;
                if (registration0 != null) {
                    if (registration1 != null) {
                        if (registration0.map == registration1.map) continue;
                        registration0.map.absorb(registration1.map, registration1.boundary.offset + offset1 - (registration0.boundary.offset + offset0), unitMaps, unitMaps);
                        continue;
                    }
                    if (registration1g != null) {
                        registration1g.map.absorb(registration0.map, registration0.boundary.offset + offset0 - (registration1g.boundary.offset + offset1), unitMaps, globalMaps);
                        continue;
                    }
                    registration0.map.insertVariableAt(registration0.boundary.offset + offset0 - offset1, varSize1, varDecl1, declSymbolTable, unitMaps);
                    continue;
                }
                if (registration0g != null) {
                    if (registration1 != null) {
                        registration0g.map.absorb(registration1.map, registration1.boundary.offset + offset1 - (registration0g.boundary.offset + offset0), unitMaps, globalMaps);
                        continue;
                    }
                    if (registration1g != null) {
                        if (registration0g.map == registration1g.map) continue;
                        registration0g.map.absorb(registration1g.map, registration1g.boundary.offset + offset1 - (registration0g.boundary.offset + offset0), globalMaps, globalMaps);
                        continue;
                    }
                    registration0g.map.insertVariableAt(registration0g.boundary.offset + offset0 - offset1, varSize1, varDecl1, declSymbolTable, globalMaps);
                    continue;
                }
                if (registration1 != null) {
                    registration1.map.insertVariableAt(registration1.boundary.offset + offset1 - offset0, varSize0, varDecl0, declSymbolTable, unitMaps);
                    continue;
                }
                if (registration1g != null) {
                    registration1g.map.insertVariableAt(registration1g.boundary.offset + offset1 - offset0, varSize0, varDecl0, declSymbolTable, globalMaps);
                    continue;
                }
                MemMap newMap = unitMaps.getSetMemMap(null);
                newMap.insertVariableAt(-offset0, varSize0, varDecl0, declSymbolTable, unitMaps);
                newMap.insertVariableAt(-offset1, varSize1, varDecl1, declSymbolTable, unitMaps);
            }
        }
    }

    private static void placeDSIntoMemoryMap(Tree dsTree, SymbolTable declSymbolTable, Unit declUnit, MemoryMaps unitMaps, MemoryMaps globalMaps) {
        Tree[] savedVars;
        if (dsTree.opCode() == 51) {
            Tree[] dataElems = dsTree.down(1).children();
            savedVars = new Tree[dataElems.length];
            for (int i = dataElems.length - 1; i >= 0; --i) {
                savedVars[i] = ILUtils.baseTree(dataElems[i]);
            }
        } else {
            savedVars = dsTree.children();
        }
        for (int i = savedVars.length - 1; i >= 0; --i) {
            MemMap commonMap;
            VarStartBoundary previousRegistration;
            int varSize;
            String varName = savedVars[i].stringValue();
            VariableDecl varDecl = declSymbolTable.getVariableDecl(varName);
            if (varDecl == null) continue;
            int n = varSize = varDecl != null && varDecl.type() != null ? varDecl.type().size() : -1;
            if (varSize < 0) {
                TapEnv.fileWarning(15, dsTree, "Cannot compute the size of variable " + varName + " in " + ILUtils.toString(dsTree));
                varSize = 9;
            }
            if (varDecl == null) continue;
            if (unitMaps != null && (previousRegistration = unitMaps.getRegistration(varDecl)) != null) {
                commonMap = globalMaps.getSetMemMap(null);
                commonMap.name = "/Fortran_Save" + (declUnit == null ? "" : "_In_" + declUnit.name() + "/");
                commonMap.absorb(previousRegistration.map, 0, unitMaps, globalMaps);
                continue;
            }
            previousRegistration = globalMaps.getRegistration(varDecl);
            if (previousRegistration != null) continue;
            commonMap = globalMaps.getSetMemMap(null);
            commonMap.name = "/Fortran_Save" + (declUnit == null ? "" : "_In_" + declUnit.name() + "/");
            commonMap.insertVariableAt(0, varSize, varDecl, declSymbolTable, globalMaps);
        }
    }

    public void allocateZones(ZoneAllocator zoneAllocator, Unit declarationUnit) {
        TapList<MemMap> memMaps = this.maps;
        while (memMaps.tail != null) {
            if (!zoneAllocator.targetSymbolTable.isGlobalSymbolTable() && !((MemMap)memMaps.tail.head).touchesSymbolTable(zoneAllocator.targetSymbolTable)) {
                memMaps = memMaps.tail;
                continue;
            }
            ((MemMap)memMaps.tail.head).allocateZones(zoneAllocator, declarationUnit);
            memMaps.tail = memMaps.tail.tail;
        }
    }

    public String toString() {
        String result = "";
        TapList inMaps = this.maps.tail;
        while (inMaps != null) {
            result = result + "\n        -- " + inMaps.head;
            inMaps = inMaps.tail;
        }
        return "MemoryMaps:" + result;
    }
}

