/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.representation;

import fr.inria.tapenade.representation.AlignmentBoundary;
import fr.inria.tapenade.representation.ArrayDim;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.MemoryMaps;
import fr.inria.tapenade.representation.SubVariableDecl;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.TypeSpec;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.representation.VarStartBoundary;
import fr.inria.tapenade.representation.VariableDecl;
import fr.inria.tapenade.representation.WrapperTypeSpec;
import fr.inria.tapenade.representation.ZoneAllocator;
import fr.inria.tapenade.representation.ZoneInfo;
import fr.inria.tapenade.representation.ZoneInfoAccessElements;
import fr.inria.tapenade.utils.TapPair;
import fr.inria.tapenade.utils.ToBool;
import fr.inria.tapenade.utils.Tree;

public final class MemMap {
    public String name = null;
    public TapList<AlignmentBoundary> boundaries = new TapList<Object>(null, null);

    public MemMap(String commonName) {
        this.name = commonName;
    }

    private TapList<AlignmentBoundary> gotoGetSetBoundary(TapList<AlignmentBoundary> inBoundaries, int offset, boolean infiniteEndOffset, WrapperTypeSpec type) {
        while (inBoundaries.tail != null && ((AlignmentBoundary)inBoundaries.tail.head).isBefore(offset, infiniteEndOffset)) {
            inBoundaries = inBoundaries.tail;
        }
        if (inBoundaries.tail == null || !((AlignmentBoundary)inBoundaries.tail.head).isEqual(offset, infiniteEndOffset)) {
            inBoundaries.placdl(new AlignmentBoundary(offset, infiniteEndOffset));
        }
        if (type != null) {
            ((AlignmentBoundary)inBoundaries.tail.head).type = type;
        }
        return inBoundaries;
    }

    public void insertVariableAt(int offset, int varSize, VariableDecl variableDecl, SymbolTable declSymbolTable, MemoryMaps thisMaps) {
        TapList<AlignmentBoundary> inBoundaries = this.gotoGetSetBoundary(this.boundaries, offset, false, variableDecl.type());
        ((AlignmentBoundary)inBoundaries.tail.head).addStartVar(variableDecl, declSymbolTable, null);
        thisMaps.addRegistration(new VarStartBoundary(variableDecl, this, (AlignmentBoundary)inBoundaries.tail.head));
        inBoundaries = this.gotoGetSetBoundary(inBoundaries, offset + varSize, varSize == 0, null);
        ((AlignmentBoundary)inBoundaries.tail.head).addEndVar(variableDecl, declSymbolTable);
    }

    public int getLastOffset(ToBool toInfiniteLastOffset) {
        AlignmentBoundary lastBoundary = TapList.last(this.boundaries);
        if (lastBoundary == null) {
            toInfiniteLastOffset.set(false);
            return 0;
        }
        toInfiniteLastOffset.set(lastBoundary.infiniteOffset);
        return lastBoundary.offset;
    }

    public void setActiveRegion(int startOffset, int endOffset, boolean infiniteEndOffset) {
        TapList<AlignmentBoundary> inBoundaries = this.gotoGetSetBoundary(this.boundaries, startOffset, false, null);
        ((AlignmentBoundary)inBoundaries.tail.head).active = true;
        inBoundaries = inBoundaries.tail;
        while (inBoundaries.tail != null && ((AlignmentBoundary)inBoundaries.tail.head).isBefore(endOffset, infiniteEndOffset)) {
            ((AlignmentBoundary)inBoundaries.tail.head).active = true;
            inBoundaries = inBoundaries.tail;
        }
        if (inBoundaries.tail == null || !((AlignmentBoundary)inBoundaries.tail.head).isEqual(endOffset, infiniteEndOffset)) {
            inBoundaries.placdl(new AlignmentBoundary(endOffset, infiniteEndOffset));
        }
    }

    public boolean isActiveRegion(int startOffset, int endOffset, boolean infiniteEndOffset) {
        TapList<AlignmentBoundary> inBoundaries = this.gotoGetSetBoundary(this.boundaries, startOffset, false, null);
        boolean isActive = ((AlignmentBoundary)inBoundaries.tail.head).active;
        inBoundaries = inBoundaries.tail;
        while (!isActive && inBoundaries.tail != null && ((AlignmentBoundary)inBoundaries.tail.head).isBefore(endOffset, infiniteEndOffset)) {
            if (((AlignmentBoundary)inBoundaries.tail.head).active) {
                isActive = true;
            }
            inBoundaries = inBoundaries.tail;
        }
        return isActive;
    }

    public void absorb(MemMap otherMap, int shift, MemoryMaps otherMaps, MemoryMaps thisMaps) {
        TapList<AlignmentBoundary> toBoundaries = this.boundaries;
        TapList otherBoundaries = otherMap.boundaries.tail;
        while (otherBoundaries != null) {
            AlignmentBoundary otherBoundary = (AlignmentBoundary)otherBoundaries.head;
            otherBoundary.offset -= shift;
            while (toBoundaries.tail != null && ((AlignmentBoundary)toBoundaries.tail.head).isBefore(otherBoundary)) {
                toBoundaries = toBoundaries.tail;
            }
            if (toBoundaries.tail == null || !((AlignmentBoundary)toBoundaries.tail.head).isEqual(otherBoundary)) {
                toBoundaries = toBoundaries.placdl(otherBoundary);
            } else {
                AlignmentBoundary thisBoundary = (AlignmentBoundary)toBoundaries.tail.head;
                TapList<VariableDecl> otherEndings = otherBoundary.endVars;
                while (otherEndings != null) {
                    thisBoundary.endVars = new TapList<VariableDecl>((VariableDecl)otherEndings.head, thisBoundary.endVars);
                    otherEndings = otherEndings.tail;
                }
                TapList<ZoneInfoAccessElements> otherStartings = otherBoundary.startVars;
                while (otherStartings != null) {
                    thisBoundary.startVars = new TapList<ZoneInfoAccessElements>((ZoneInfoAccessElements)otherStartings.head, thisBoundary.startVars);
                    VarStartBoundary thisDeclAccess = otherMaps.delRegistration(((ZoneInfoAccessElements)otherStartings.head).symbolDecl);
                    thisDeclAccess.map = this;
                    thisDeclAccess.boundary = thisBoundary;
                    thisMaps.addRegistration(thisDeclAccess);
                    otherStartings = otherStartings.tail;
                }
            }
            otherBoundaries = otherBoundaries.tail;
        }
        TapList<MemMap> toOther = otherMaps.maps;
        while (toOther != null && toOther.tail != null) {
            if (toOther.tail.head == otherMap) {
                toOther.tail = toOther.tail.tail;
                toOther = null;
                continue;
            }
            toOther = toOther.tail;
        }
    }

    public void removeVariableFrom(VariableDecl varDecl, MemoryMaps thisMaps) {
        VarStartBoundary startPlace = thisMaps.delRegistration(varDecl);
        MemMap oldMap = startPlace.map;
        AlignmentBoundary oldBoundary = startPlace.boundary;
        oldBoundary.removeStartVar(varDecl);
        TapList inBoundaries = oldMap.boundaries.tail;
        while (inBoundaries != null && inBoundaries.head != oldBoundary) {
            inBoundaries = inBoundaries.tail;
        }
        while (inBoundaries != null && !TapList.contains(((AlignmentBoundary)inBoundaries.head).endVars, varDecl)) {
            inBoundaries = inBoundaries.tail;
        }
        ((AlignmentBoundary)inBoundaries.head).removeEndVar(varDecl);
    }

    public void allocateZones(ZoneAllocator zoneAllocator, Unit declarationUnit) {
        int jump = 0;
        TapList<ZoneInfoAccessElements> curAccesses = null;
        TapList inBoundaries = this.boundaries.tail;
        TapList<Object> toCopiedZoneInfos = new TapList<Object>(null, null);
        zoneAllocator.setCommonName(this.name);
        if (declarationUnit != null) {
            // empty if block
        }
        boolean needAdditionalAllocateZones = false;
        ToBool currentSharedSymbolActivity = new ToBool(false);
        while (inBoundaries != null) {
            AlignmentBoundary boundary = (AlignmentBoundary)inBoundaries.head;
            AlignmentBoundary nextBoundary = inBoundaries.tail == null ? null : (AlignmentBoundary)inBoundaries.tail.head;
            boolean infiniteNextOffset = nextBoundary == null || nextBoundary.infiniteOffset;
            int nextOffset = infiniteNextOffset ? -1 : nextBoundary.offset;
            jump = infiniteNextOffset ? -1 : nextOffset - boundary.offset;
            WrapperTypeSpec accessType = boundary.buildNextType(jump);
            if ((curAccesses = MemMap.removeEndingVars(curAccesses, boundary.endVars, jump)) == null) {
                currentSharedSymbolActivity = new ToBool(false);
            }
            zoneAllocator.ambiguousWithoutIndices = curAccesses != null;
            curAccesses = MemMap.addStartingVars(curAccesses, boundary.startVars, jump);
            boolean bl = zoneAllocator.ambiguousWithoutIndices = zoneAllocator.ambiguousWithoutIndices || !MemMap.allVariablesEndAt(curAccesses, nextBoundary);
            if (!(curAccesses == null && boundary.type == null || needAdditionalAllocateZones)) {
                TapList regionZones;
                VariableDecl varDecl;
                zoneAllocator.setOffsets(boundary.offset, nextOffset, infiniteNextOffset);
                boolean isInt = false;
                boolean isReal = false;
                boolean isPtr = false;
                TapList<String> cumulExtraInfo = null;
                TapList<ZoneInfoAccessElements> inAccesses = curAccesses;
                while (inAccesses != null) {
                    varDecl = (VariableDecl)((ZoneInfoAccessElements)inAccesses.head).symbolDecl;
                    varDecl.shareActivity(currentSharedSymbolActivity);
                    if (varDecl instanceof SubVariableDecl) {
                        ((SubVariableDecl)varDecl).trueVariableDecl.shareActivity(currentSharedSymbolActivity);
                    }
                    WrapperTypeSpec type = varDecl.type();
                    if (accessType == null) {
                        accessType = type;
                    }
                    if (type.isRealOrComplexBase()) {
                        isReal = true;
                    }
                    if (type.isIntegerBase()) {
                        isInt = true;
                    }
                    if (type.isPointer()) {
                        isPtr = true;
                    }
                    cumulExtraInfo = TapList.unionString(cumulExtraInfo, varDecl.extraInfo());
                    inAccesses = inAccesses.tail;
                }
                boundary.zones = regionZones = zoneAllocator.allocateZones(accessType, -1, cumulExtraInfo, curAccesses, accessType, -1, isInt, isReal, isPtr, null, declarationUnit == null ? null : declarationUnit.privateSymbolTable(), null);
                inAccesses = curAccesses;
                while (inAccesses != null) {
                    varDecl = (VariableDecl)((ZoneInfoAccessElements)inAccesses.head).symbolDecl;
                    if (varDecl instanceof SubVariableDecl) {
                        ((SubVariableDecl)varDecl).accumulateSubZones(regionZones);
                    } else {
                        ZoneInfo libReaderZoneInfo;
                        varDecl.accumulateZones(regionZones);
                        if (varDecl.nameTree != null && (libReaderZoneInfo = (ZoneInfo)varDecl.nameTree.getAnnotation("zoneInfo")) != null) {
                            ZoneInfo finalZoneInfo = zoneAllocator.lastAllocated();
                            libReaderZoneInfo.index = finalZoneInfo.index;
                            libReaderZoneInfo.intZoneNb = finalZoneInfo.intZoneNb;
                            libReaderZoneInfo.realZoneNb = finalZoneInfo.realZoneNb;
                            libReaderZoneInfo.ptrZoneNb = finalZoneInfo.ptrZoneNb;
                            finalZoneInfo.accessTree = null;
                            finalZoneInfo.setVariableNames(null);
                            finalZoneInfo.description = libReaderZoneInfo.description;
                            libReaderZoneInfo.accessTree = null;
                        }
                    }
                    inAccesses = inAccesses.tail;
                }
            }
            inBoundaries = inBoundaries.tail;
        }
        zoneAllocator.ambiguousWithoutIndices = false;
        zoneAllocator.setOffsets(-1, -1, false);
        zoneAllocator.setCommonName(null);
    }

    private static boolean allVariablesEndAt(TapList<ZoneInfoAccessElements> curAccesses, AlignmentBoundary boundary) {
        if (boundary == null) {
            return true;
        }
        boolean allEnd = true;
        while (allEnd && curAccesses != null) {
            if (!TapList.contains(boundary.endVars, (VariableDecl)((ZoneInfoAccessElements)curAccesses.head).symbolDecl)) {
                allEnd = false;
            }
            curAccesses = curAccesses.tail;
        }
        return allEnd;
    }

    private static TapList<ZoneInfoAccessElements> removeEndingVars(TapList<ZoneInfoAccessElements> curAccesses, TapList<VariableDecl> removedVars, int jump) {
        TapList<ZoneInfoAccessElements> toResult;
        TapList<ZoneInfoAccessElements> inResult = toResult = new TapList<ZoneInfoAccessElements>(null, curAccesses);
        while (inResult.tail != null) {
            if (TapList.contains(removedVars, (VariableDecl)((ZoneInfoAccessElements)inResult.tail.head).symbolDecl)) {
                inResult.tail = inResult.tail.tail;
                continue;
            }
            ZoneInfoAccessElements access = (ZoneInfoAccessElements)inResult.tail.head;
            access.startOffsetInArray += jump;
            if (access.accessTree.opCode() == 9) {
                access.accessTree = ILUtils.build(9, ILUtils.copy(access.accessTree.down(1)), ILUtils.build(71, ILUtils.build(12, ILUtils.build(103, access.accessTree.down(2).down(1).down(2).intValue() + 1), ILUtils.build(103, access.startOffsetInArray / access.baseSize))));
            }
            inResult = inResult.tail;
        }
        return toResult.tail;
    }

    private static TapList<ZoneInfoAccessElements> addStartingVars(TapList<ZoneInfoAccessElements> curAccesses, TapList<ZoneInfoAccessElements> addedVars, int jump) {
        while (addedVars != null) {
            ZoneInfoAccessElements origAccess = (ZoneInfoAccessElements)addedVars.head;
            VariableDecl varDecl = (VariableDecl)origAccess.symbolDecl;
            WrapperTypeSpec varType = varDecl.type();
            Tree accessTree = varDecl instanceof SubVariableDecl ? ILUtils.copy(((SubVariableDecl)varDecl).accessTree) : ILUtils.build(96, varDecl.symbol);
            int baseSize = -1;
            if (varType.isArray()) {
                int arraySize = varType.size();
                TapPair<WrapperTypeSpec, ArrayDim[]> baseTypeAndDims = TypeSpec.peelArrayDimsAroundComposite(varType);
                baseSize = ((WrapperTypeSpec)baseTypeAndDims.first).size();
                if (arraySize != jump && jump != -1 && baseSize != -1) {
                    accessTree = ILUtils.build(9, accessTree, ILUtils.build(71, ILUtils.build(12, ILUtils.build(103, 0), ILUtils.build(103, jump / baseSize - 1))));
                }
            }
            ZoneInfoAccessElements newAccess = new ZoneInfoAccessElements(origAccess.symbolDecl, accessTree, origAccess.symbolTable);
            newAccess.startOffsetInArray = 0;
            newAccess.baseSize = baseSize;
            curAccesses = new TapList<ZoneInfoAccessElements>(newAccess, curAccesses);
            addedVars = addedVars.tail;
        }
        return curAccesses;
    }

    protected boolean touchesSymbolTable(SymbolTable targetSymbolTable) {
        TapList inBoundaries = this.boundaries.tail;
        boolean touches = false;
        while (!touches && inBoundaries != null) {
            TapList<ZoneInfoAccessElements> inStartVars = ((AlignmentBoundary)inBoundaries.head).startVars;
            while (!touches && inStartVars != null) {
                VariableDecl varDecl = (VariableDecl)((ZoneInfoAccessElements)inStartVars.head).symbolDecl;
                if (targetSymbolTable.getTopVariableDecl(varDecl.symbol) == varDecl) {
                    touches = true;
                }
                inStartVars = inStartVars.tail;
            }
            inBoundaries = inBoundaries.tail;
        }
        return touches;
    }

    public String toString() {
        String contents = "";
        TapList<AlignmentBoundary> inBoundaries = this.boundaries;
        while (inBoundaries != null) {
            contents = contents + inBoundaries.head;
            inBoundaries = inBoundaries.tail;
        }
        return "MemMap(" + this.name + "):" + contents;
    }
}

