/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.representation;

import fr.inria.tapenade.representation.BasicBlock;
import fr.inria.tapenade.representation.Block;
import fr.inria.tapenade.representation.FGArrow;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.utils.Tree;

public final class LabelHeap {
    private LabelHeapCell topCell;

    public Block getSetLabelled(String label, TapList<Block> allBlocks, boolean defines, Tree position) {
        LabelHeapCell curCell = this.topCell;
        while (curCell != null && !curCell.label.equals(label)) {
            curCell = curCell.next;
        }
        if (curCell == null) {
            BasicBlock block = new BasicBlock(null, null, allBlocks);
            block.setOrigLabel(label);
            curCell = this.topCell = new LabelHeapCell(label, block, this.topCell);
        }
        if (defines) {
            if (curCell.definitionPosition != null) {
                TapEnv.fileWarning(5, position, "(DD13) Double definition of label " + label + " (ignored new)");
                return null;
            }
            curCell.definitionPosition = position;
        } else {
            curCell.usagePositions = new TapList<Tree>(position, curCell.usagePositions);
        }
        return curCell.block;
    }

    public void fuseLabelled(String label, Block fuseBlock, Tree position) {
        LabelHeapCell curCell = this.topCell;
        while (curCell != null && !curCell.label.equals(label)) {
            curCell = curCell.next;
        }
        if (curCell == null) {
            this.topCell = new LabelHeapCell(label, fuseBlock, this.topCell);
            this.topCell.definitionPosition = position;
        } else if (curCell.definitionPosition != null) {
            TapEnv.fileWarning(5, position, "(DD13) Double definition of label " + label + " (ignored new)");
        } else {
            Block oldBlock = curCell.block;
            curCell.block = fuseBlock;
            curCell.definitionPosition = position;
            TapList<FGArrow> arrows = oldBlock.backFlow();
            while (arrows != null) {
                ((FGArrow)arrows.head).redirectDestination(fuseBlock);
                arrows = arrows.tail;
            }
        }
    }

    public void checkFormatLabel(String label, Tree position) {
        LabelHeapCell curCell = this.topCell;
        while (curCell != null && !curCell.label.equals(label)) {
            curCell = curCell.next;
        }
        if (curCell == null) {
            this.topCell = new LabelHeapCell(label, null, this.topCell);
            this.topCell.definitionPosition = position;
        } else {
            TapEnv.fileWarning(5, position, "(DD13) Double definition of label " + label + " (ignored new)");
        }
    }

    public Block getLabelled(String label) {
        LabelHeapCell curCell = this.topCell;
        while (curCell != null && !curCell.label.equals(label)) {
            curCell = curCell.next;
        }
        if (curCell != null) {
            return curCell.block;
        }
        return null;
    }

    public void undefinedLabels(Block exitBlock, SymbolTable symbolTable) {
        LabelHeapCell curCell = this.topCell;
        while (curCell != null) {
            if (curCell.definitionPosition == null) {
                TapList usages = curCell.usagePositions;
                while (usages != null) {
                    TapEnv.fileWarning(5, (Tree)usages.head, "(TC50) Label " + curCell.label + " is not defined");
                    ((LabelHeapCell)curCell).block.symbolTable = symbolTable;
                    usages = usages.tail;
                }
                new FGArrow(curCell.block, 0, null, exitBlock);
            }
            curCell = curCell.next;
        }
    }

    private static final class LabelHeapCell {
        private final String label;
        private final LabelHeapCell next;
        private Block block;
        private Tree definitionPosition;
        private TapList<Tree> usagePositions;

        private LabelHeapCell(String label, Block block, LabelHeapCell next) {
            this.label = label;
            this.block = block;
            this.next = next;
            this.definitionPosition = null;
            this.usagePositions = null;
        }
    }
}

