/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.representation;

import fr.inria.tapenade.analysis.ADActivityAnalyzer;
import fr.inria.tapenade.representation.FunctionDecl;
import fr.inria.tapenade.representation.FunctionTypeSpec;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.SymbolDecl;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.representation.WrapperTypeSpec;
import fr.inria.tapenade.utils.ToBool;
import fr.inria.tapenade.utils.Tree;

public final class InterfaceDecl
extends SymbolDecl {
    protected boolean usefulName = true;
    public TapList<Tree> contents;
    public TapList<FunctionDecl> functionDecls;
    public TapList<String> functionNames;
    protected Unit containerUnit;
    protected SymbolTable definitionSymbolTable;
    public int formalArgRank = -1;
    private boolean isADifferentiatedInterface;
    private TapList<Unit> interfaceUnits;

    protected InterfaceDecl() {
        this.kind = 16;
        this.defPositions = new TapList<Object>(null, null);
        this.nameTree = null;
        this.functionDecls = null;
    }

    public InterfaceDecl(Tree identTree) {
        super(identTree, 16);
        this.nameTree = identTree;
        this.functionDecls = null;
    }

    protected InterfaceDecl(Tree identTree, FunctionDecl functionDecl, SymbolTable symbolTable, Unit containerUnit) {
        super(identTree, 16);
        this.containerUnit = containerUnit;
        this.nameTree = identTree;
        this.definitionSymbolTable = symbolTable;
        this.functionDecls = null;
        if (functionDecl != null) {
            this.functionDecls = new TapList<FunctionDecl>(functionDecl, null);
            functionDecl.unit().enclosingUnitOfInterface = containerUnit;
        }
    }

    public TapList<Unit> interfaceUnits() {
        return this.interfaceUnits;
    }

    public void setInterfaceUnits(TapList<Unit> units) {
        this.interfaceUnits = units;
    }

    protected void addInInterfaceDecl(Tree tree) {
        this.contents = TapList.append(this.contents, new TapList<Tree>(tree, null));
        if (tree.opCode() == 132) {
            Tree[] sons;
            for (Tree son : sons = tree.children()) {
                if (son.opCode() != 96) continue;
                this.functionNames = new TapList<String>(son.stringValue(), this.functionNames);
            }
        }
    }

    protected void addInInterfaceDecl(FunctionDecl functionDecl, Unit enclosingUnit) {
        functionDecl.unit().enclosingUnitOfInterface = enclosingUnit;
        this.functionDecls = TapList.append(this.functionDecls, new TapList<FunctionDecl>(functionDecl, null));
        if (this.nameTree == null) {
            this.nameTree = ILUtils.build(138);
            this.symbol = functionDecl.symbol;
            this.usefulName = false;
        }
    }

    private FunctionDecl findCalledFunction(FunctionTypeSpec actualCallTypeSpec, Tree actualCallTree) {
        int thisMatchRk;
        FunctionDecl funcDecl;
        Unit unit;
        TapList<FunctionDecl> funcDecls = this.functionDecls;
        TapList<String> funcNames = this.functionNames;
        int bestMatchRkSoFar = 999;
        TapList<FunctionDecl> exactMatches = null;
        FunctionDecl bestMatchSoFar = null;
        SymbolTable publicSymbolTable = this.definitionSymbolTable;
        SymbolTable privateSymbolTable = null;
        if (this.definitionSymbolTable != null && (unit = this.definitionSymbolTable.unit) != null) {
            publicSymbolTable = unit.publicSymbolTable();
            privateSymbolTable = unit.privateSymbolTable();
        }
        while (funcDecls != null) {
            funcDecl = (FunctionDecl)funcDecls.head;
            thisMatchRk = this.measureMatching(funcDecl);
            if (thisMatchRk == 0) {
                exactMatches = new TapList<FunctionDecl>(funcDecl, exactMatches);
                bestMatchRkSoFar = 0;
            } else if (thisMatchRk < bestMatchRkSoFar) {
                bestMatchSoFar = funcDecl;
                bestMatchRkSoFar = thisMatchRk;
            }
            funcDecls = funcDecls.tail;
        }
        while (funcNames != null) {
            TapList<FunctionDecl> sameFuncDecls;
            String funcName = (String)funcNames.head;
            funcDecl = null;
            if (privateSymbolTable != null) {
                sameFuncDecls = privateSymbolTable.getFunctionDecl(funcName, null, null, false);
                FunctionDecl functionDecl = funcDecl = sameFuncDecls == null ? null : (FunctionDecl)sameFuncDecls.head;
            }
            if (funcDecl == null && publicSymbolTable != null) {
                sameFuncDecls = publicSymbolTable.getFunctionDecl(funcName, null, null, false);
                FunctionDecl functionDecl = funcDecl = sameFuncDecls == null ? null : (FunctionDecl)sameFuncDecls.head;
            }
            if (funcDecl != null) {
                thisMatchRk = this.measureMatching(funcDecl);
                if (thisMatchRk == 0) {
                    exactMatches = new TapList<FunctionDecl>(funcDecl, exactMatches);
                    bestMatchRkSoFar = 0;
                } else if (thisMatchRk < bestMatchRkSoFar) {
                    bestMatchSoFar = funcDecl;
                    bestMatchRkSoFar = thisMatchRk;
                }
            }
            funcNames = funcNames.tail;
        }
        if (exactMatches != null) {
            if (exactMatches.tail != null) {
                TapEnv.fileWarning(15, actualCallTree, "(DD23) More than one procedure in interface " + this.symbol + " exactly match this call");
            }
            return (FunctionDecl)exactMatches.head;
        }
        if (bestMatchSoFar != null) {
            return bestMatchSoFar;
        }
        TapEnv.fileWarning(15, actualCallTree, "(DD23) No procedure in interface " + this.symbol + " can match this call");
        return null;
    }

    private int measureMatching(FunctionDecl funcDecl) {
        if (funcDecl != null && funcDecl.functionTypeSpec() != null) {
            return 4;
        }
        return 1000;
    }

    public FunctionDecl findFunctionDecl(WrapperTypeSpec[] types, WrapperTypeSpec resultType, Tree callTree) {
        FunctionDecl functionDecl = this.findFunctionDeclEqualsOrElementType(types, true, true, false, callTree);
        if (functionDecl == null) {
            functionDecl = this.findFunctionDeclEqualsOrElementType(types, true, false, false, callTree);
        }
        if (functionDecl == null) {
            functionDecl = this.findFunctionDeclEqualsOrElementType(types, false, true, false, callTree);
        }
        if (functionDecl == null) {
            functionDecl = this.findFunctionDeclEqualsOrElementType(types, false, false, false, callTree);
        }
        return functionDecl;
    }

    protected FunctionDecl findOneFunctionDecl(WrapperTypeSpec[] types, Tree callTree) {
        return this.findFunctionDeclEqualsOrElementType(types, false, false, true, callTree);
    }

    private FunctionDecl findFunctionDeclEqualsOrElementType(WrapperTypeSpec[] types, boolean strictComparisonForType, boolean strictComparisonForArray, boolean onlyParamsNumber, Tree callTree) {
        TapList<FunctionDecl> sameFuncs;
        FunctionDecl func;
        SymbolTable symbolTableOfInterfaceDef = this.definitionSymbolTable;
        Unit unit = symbolTableOfInterfaceDef == null ? null : symbolTableOfInterfaceDef.unit;
        SymbolTable publicSymbolTable = unit == null ? symbolTableOfInterfaceDef : unit.publicSymbolTable();
        SymbolTable privateSymbolTable = unit == null ? symbolTableOfInterfaceDef : unit.privateSymbolTable();
        FunctionDecl foundFunc = null;
        TapList<FunctionDecl> funcs = this.functionDecls;
        while (foundFunc == null && funcs != null) {
            func = (FunctionDecl)funcs.head;
            if (func.functionTypeSpec() != null && this.isCalledFunctionFromInterface(func.unit(), types, strictComparisonForType, strictComparisonForArray, onlyParamsNumber, false, callTree)) {
                foundFunc = func;
            }
            funcs = funcs.tail;
        }
        TapList<FunctionDecl> tapList = funcs = callTree.opCode() == 31 ? this.functionDecls : null;
        while (foundFunc == null && funcs != null) {
            func = (FunctionDecl)funcs.head;
            if (func.functionTypeSpec() != null && this.isCalledFunctionFromInterface(func.unit(), types, strictComparisonForType, strictComparisonForArray, onlyParamsNumber, true, callTree)) {
                foundFunc = func;
            }
            funcs = funcs.tail;
        }
        TapList<String> funcNames = this.functionNames;
        while (foundFunc == null && funcNames != null) {
            sameFuncs = privateSymbolTable.getFunctionDecl((String)funcNames.head, null, null, false);
            FunctionDecl functionDecl = func = sameFuncs == null ? null : (FunctionDecl)sameFuncs.head;
            if (func != null && func.functionTypeSpec() != null && this.isCalledFunctionFromInterface(func.unit(), types, strictComparisonForType, strictComparisonForArray, onlyParamsNumber, false, callTree)) {
                foundFunc = func;
            }
            funcNames = funcNames.tail;
        }
        TapList<String> tapList2 = funcNames = callTree.opCode() == 31 ? this.functionNames : null;
        while (foundFunc == null && funcNames != null) {
            sameFuncs = privateSymbolTable.getFunctionDecl((String)funcNames.head, null, null, false);
            FunctionDecl functionDecl = func = sameFuncs == null ? null : (FunctionDecl)sameFuncs.head;
            if (func != null && func.functionTypeSpec() != null && this.isCalledFunctionFromInterface(func.unit(), types, strictComparisonForType, strictComparisonForArray, onlyParamsNumber, true, callTree)) {
                foundFunc = func;
            }
            funcNames = funcNames.tail;
        }
        if (foundFunc == null) {
            func = null;
            if (this.functionDecls != null && this.functionDecls.tail == null) {
                func = (FunctionDecl)this.functionDecls.head;
            }
            if (func == null && this.functionNames != null && this.functionNames.tail == null) {
                sameFuncs = privateSymbolTable.getTopFunctionDecl((String)this.functionNames.head, null, null, false);
                if (sameFuncs == null) {
                    sameFuncs = publicSymbolTable.getTopFunctionDecl((String)this.functionNames.head, null, null, false);
                }
                FunctionDecl functionDecl = func = sameFuncs == null ? null : (FunctionDecl)sameFuncs.head;
            }
            if (func != null) {
                FunctionTypeSpec funcTypeSpec = func.functionTypeSpec();
                assert (funcTypeSpec != null);
                if (types.length != funcTypeSpec.argumentsTypes.length) {
                    foundFunc = func;
                } else {
                    boolean matches = true;
                    for (int index = types.length - 1; matches && index >= 0; --index) {
                        matches = types[index] != null && types[index].equalsCompilDep(funcTypeSpec.argumentsTypes[index]);
                    }
                    if (matches) {
                        foundFunc = func;
                    }
                }
            }
        }
        return foundFunc;
    }

    private boolean isCalledFunctionFromInterface(Unit calledUnit, WrapperTypeSpec[] types, boolean strictComparisonForType, boolean strictComparisonForArray, boolean onlyParamsNumber, boolean considerOptionalArguments, Tree callTree) {
        boolean matches;
        FunctionTypeSpec funcTypeSpec = calledUnit.functionTypeSpec();
        int nbFormalArgs = funcTypeSpec.argumentsTypes.length;
        if (TapEnv.traceTypeCheckAnalysis()) {
            TapEnv.indentOnTrace(TapEnv.traceIndent());
            TapEnv.printOnTrace("Checking if call " + ILUtils.toString(callTree) + " actual types:");
            TapEnv.dumpOnTrace(types);
            TapEnv.printOnTrace(" is matched by available interface " + calledUnit.name() + ':' + funcTypeSpec);
            if (onlyParamsNumber) {
                TapEnv.printOnTrace(", watching only params length");
            } else {
                TapEnv.printOnTrace(", " + (strictComparisonForType ? "strict" : "lax") + " on types, " + (strictComparisonForArray ? "strict" : "lax") + " on arrays");
            }
            TapEnv.setTraceIndent(TapEnv.traceIndent() + 2);
        }
        if (considerOptionalArguments) {
            Tree newCallTree = ILUtils.copy(callTree);
            Tree optionalTree = ILUtils.copy(callTree);
            Tree[] actualArgs = ILUtils.getArguments(callTree).children();
            int nbActualArgs = actualArgs.length;
            types = calledUnit.typeCheckNameEqOptionalArguments(null, actualArgs, types, new WrapperTypeSpec[nbActualArgs], nbActualArgs, newCallTree, optionalTree, new ToBool(false));
            calledUnit.typeCheckOptionalArguments(types, newCallTree, optionalTree, new ToBool(false));
            int optNb = calledUnit.getOptionalParameterDeclsNumber();
            int nbNeededArgs = nbFormalArgs - optNb;
            if (TapEnv.traceTypeCheckAnalysis()) {
                TapEnv.printlnOnTrace(", with " + nbNeededArgs + " args needed and " + optNb + " optional");
            }
            matches = nbNeededArgs <= nbActualArgs && nbActualArgs <= nbFormalArgs;
        } else {
            if (TapEnv.traceTypeCheckAnalysis()) {
                TapEnv.printlnOnTrace();
            }
            boolean bl = matches = types.length == nbFormalArgs;
        }
        if (matches && !onlyParamsNumber) {
            for (int index = Math.min(types.length, nbFormalArgs) - 1; matches && index >= 0; --index) {
                WrapperTypeSpec actualType = types[index];
                WrapperTypeSpec formalType = funcTypeSpec.argumentsTypes[index];
                if (actualType != null && actualType.isPointer() && !formalType.isPointer()) {
                    actualType = (WrapperTypeSpec)actualType.peelPointer();
                }
                if (actualType == null || WrapperTypeSpec.isFree(actualType)) continue;
                boolean eqType = strictComparisonForType ? (strictComparisonForArray ? actualType.equalsCompilDep(formalType) : actualType.equalsCompilDepNeglectLengthes(formalType)) : (strictComparisonForArray ? actualType.equalsNeglectSizes(formalType) : actualType.equalsNeglectSizesNeglectLengthes(formalType));
                matches = eqType;
            }
        }
        if (TapEnv.traceTypeCheckAnalysis()) {
            TapEnv.setTraceIndent(TapEnv.traceIndent() - 2);
            TapEnv.indentOnTrace(TapEnv.traceIndent());
            TapEnv.printlnOnTrace("--> Matching result:" + matches);
        }
        return matches;
    }

    protected TapList<Unit> units() {
        TapList<Unit> result = null;
        if (this.functionNames == null) {
            TapList<FunctionDecl> funcDecl = this.functionDecls;
            while (funcDecl != null) {
                result = new TapList<Unit>(((FunctionDecl)funcDecl.head).unit(), result);
                funcDecl = funcDecl.tail;
            }
        }
        return result;
    }

    protected FunctionDecl functionDecl() {
        FunctionDecl result = null;
        if (this.functionDecls != null) {
            result = (FunctionDecl)this.functionDecls.head;
        }
        return result;
    }

    public boolean mustHaveADiff(ADActivityAnalyzer activityAnalyzer) {
        FunctionDecl oneUnitDecl;
        boolean active = false;
        TapList<FunctionDecl> inFunctionDecls = this.functionDecls;
        while (!active && inFunctionDecls != null) {
            oneUnitDecl = (FunctionDecl)inFunctionDecls.head;
            active = activityAnalyzer.isActiveUnit(oneUnitDecl.unit().origUnit);
            inFunctionDecls = inFunctionDecls.tail;
        }
        SymbolTable visibleSymbolTable = this.containerUnit == null ? this.definitionSymbolTable : this.containerUnit.privateSymbolTable();
        TapList<String> inFunctionNames = this.functionNames;
        while (!active && inFunctionNames != null) {
            TapList<FunctionDecl> oneUnitDecls = visibleSymbolTable.getFunctionDecl((String)inFunctionNames.head, null, null, false);
            FunctionDecl functionDecl = oneUnitDecl = oneUnitDecls == null ? null : (FunctionDecl)oneUnitDecls.head;
            if (oneUnitDecl != null) {
                Unit oneUnit = oneUnitDecl.unit();
                Unit origUnit = oneUnit.origUnit != null ? oneUnit.origUnit : oneUnit;
                active = activityAnalyzer.isActiveUnit(origUnit);
            }
            inFunctionNames = inFunctionNames.tail;
        }
        return active;
    }

    @Override
    public int formalArgRankOrResultZero() {
        return this.formalArgRank;
    }

    @Override
    public String toString() {
        return this.symbol + ": interface. nameTree:" + this.nameTree + " interfaceUnits:" + this.interfaceUnits + " functionDecls:" + this.functionDecls + " functionNames:" + this.functionNames + " contents:" + this.contents + (this.extraInfo() == null ? "" : " X" + this.extraInfo());
    }
}

