/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.representation;

import fr.inria.tapenade.representation.Block;
import fr.inria.tapenade.representation.Directive;
import fr.inria.tapenade.representation.FunctionDecl;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.InstructionMask;
import fr.inria.tapenade.representation.SymbolDecl;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.utils.BoolVector;
import fr.inria.tapenade.utils.TapIntList;
import fr.inria.tapenade.utils.TapPair;
import fr.inria.tapenade.utils.TapTriplet;
import fr.inria.tapenade.utils.Tree;
import java.io.IOException;

public final class Instruction {
    public Tree tree;
    public Tree preComments;
    public Tree postComments;
    public Tree preCommentsBlock;
    public Tree postCommentsBlock;
    public Block block;
    public TapList<Directive> directives;
    public Instruction syntaxController;
    public int lineNo = 0;
    public boolean isPhantom;
    public TapList<TapPair<TapIntList, BoolVector>> pointerDestsChanges;
    public boolean isDifferentiated;
    private InstructionMask whereMask;
    private boolean isMaskDefinition;
    private Instruction fromInclude;
    private TapList<Unit> interfaceUnits;

    public Instruction() {
    }

    public Instruction(Tree tree) {
        this.setTree(tree);
    }

    public Instruction(Tree tree, Instruction syntaxController) {
        this.setTree(tree);
        this.syntaxController = syntaxController;
    }

    public Instruction(Tree tree, Instruction syntaxController, int lineNo) {
        this.setTree(tree);
        this.syntaxController = syntaxController;
        this.lineNo = lineNo;
    }

    public Instruction(Tree tree, Instruction syntaxController, Block block) {
        this.setTree(tree);
        this.syntaxController = syntaxController;
        this.block = block;
    }

    public void setTree(Tree newTree) {
        this.tree = newTree;
        if (newTree != null) {
            newTree.setAnnotation("instruction", this);
        }
    }

    public static Instruction createUnitDefinitionStub(Unit definedUnit, Block containerBlock) {
        return new Instruction(Instruction.createUnitDefinitionStubTree(definedUnit), null, containerBlock);
    }

    public static Tree createUnitDefinitionStubTree(Unit definedUnit) {
        int stubOp;
        int n = definedUnit.isClass() ? 36 : (stubOp = definedUnit.isModule() ? 131 : 89);
        int nameRank = definedUnit.isClass() ? 2 : (definedUnit.isModule() ? 1 : 4);
        Tree defTree = ILUtils.build(stubOp);
        defTree.setAnnotation("Unit", definedUnit);
        defTree.setChild(ILUtils.build(96, definedUnit.name()), nameRank);
        return defTree;
    }

    public static Instruction fromIncludeCopy(Instruction fromIncludeInstr, boolean copy) {
        Instruction result;
        if (fromIncludeInstr == null) {
            result = null;
        } else {
            Instruction copiedOneFromInclude = result = new Instruction(copy ? ILUtils.copy(fromIncludeInstr.tree) : fromIncludeInstr.tree);
            Instruction fromIncl = fromIncludeInstr.fromInclude;
            while (fromIncl != null) {
                copiedOneFromInclude.fromInclude = new Instruction(copy ? ILUtils.copy(fromIncl.tree) : fromIncl.tree);
                fromIncl = fromIncl.fromInclude;
                copiedOneFromInclude = copiedOneFromInclude.fromInclude;
            }
        }
        return result;
    }

    private static Instruction smartCopyWhereMask(Instruction origWhereMask, TapList<TapPair<Instruction, Instruction>> alreadyCopiedMasks) {
        Instruction resultInstruction;
        TapPair place = TapList.assq(origWhereMask, alreadyCopiedMasks);
        Tree origTree = origWhereMask.tree;
        if (place == null || place.second == null) {
            resultInstruction = new Instruction(ILUtils.copy(origTree));
            alreadyCopiedMasks.placdl(new TapPair<Instruction, Instruction>(origWhereMask, resultInstruction));
        } else {
            resultInstruction = (Instruction)place.second;
        }
        resultInstruction.fromInclude = origWhereMask.fromInclude;
        return resultInstruction;
    }

    private static Tree addComment(Tree oldComment, String content) {
        Tree newComment = ILUtils.build(180, content);
        if (oldComment != null) {
            oldComment.addChild(newComment, 1);
            return oldComment;
        }
        return ILUtils.build(37, newComment);
    }

    public static Instruction differentiateChainedIncludes(Instruction includeInstr, String suffix, boolean wait) {
        String originalIncludeString = includeInstr.tree.stringValue();
        TapTriplet<String, String, Tree> diffIncludeInfo = TapEnv.getSetDiffIncludeInfo(originalIncludeString);
        if (diffIncludeInfo.second == null) {
            if (wait) {
                if (diffIncludeInfo.third == null) {
                    diffIncludeInfo.third = ILUtils.copy(includeInstr.tree);
                }
            } else {
                String diffIncludeFileName = TapEnv.differentiateIncludeName(originalIncludeString, suffix);
                diffIncludeInfo.second = diffIncludeFileName;
                if (diffIncludeInfo.third == null) {
                    diffIncludeInfo.third = ILUtils.copy(includeInstr.tree);
                }
                ((Tree)diffIncludeInfo.third).setValue(diffIncludeFileName);
            }
        }
        Instruction diffIncludeInstr = new Instruction((Tree)diffIncludeInfo.third);
        if (includeInstr.fromInclude != null && !ILUtils.isNullOrEmptyAtom(includeInstr.fromInclude.tree)) {
            diffIncludeInstr.fromInclude = Instruction.differentiateChainedIncludes(includeInstr.fromInclude, suffix, wait);
        }
        return diffIncludeInstr;
    }

    public static TapList<Unit> usedUnits(Tree tree, TapList<Unit> collected, SymbolTable symbolTable) {
        if (tree == null) {
            return collected;
        }
        switch (tree.opCode()) {
            case 14: 
            case 45: {
                collected = Instruction.usedUnits(tree.down(2), collected, symbolTable);
                break;
            }
            case 199: {
                collected = Instruction.usedUnits(tree.down(3), collected, symbolTable);
                break;
            }
            case 10: 
            case 54: {
                Tree[] decls = tree.children();
                for (int i = decls.length - 1; i >= 0; --i) {
                    collected = Instruction.usedUnits(decls[i], collected, symbolTable);
                }
                break;
            }
            case 31: {
                collected = Instruction.usedUnits(ILUtils.getCalledName(tree), collected, symbolTable);
                break;
            }
            case 96: {
                Unit found;
                String funcName = ILUtils.getIdentString(tree);
                FunctionDecl funcDecl = funcName == null ? null : symbolTable.getFunctionNotInterfaceDecl(funcName);
                Unit unit = found = funcDecl == null ? null : funcDecl.unit();
                if (found == null) break;
                collected = new TapList<Unit>(found, collected);
                break;
            }
            case 4: 
            case 124: {
                collected = Instruction.usedUnits(tree.down(1), collected, symbolTable);
                break;
            }
            case 3: 
            case 22: 
            case 62: 
            case 116: 
            case 133: 
            case 169: 
            case 182: {
                collected = Instruction.usedUnits(tree.down(1), collected, symbolTable);
                collected = Instruction.usedUnits(tree.down(2), collected, symbolTable);
                break;
            }
            case 5: 
            case 11: 
            case 28: 
            case 32: 
            case 90: 
            case 101: 
            case 103: 
            case 118: 
            case 138: 
            case 153: 
            case 160: 
            case 180: 
            case 192: 
            case 202: {
                break;
            }
            case 36: 
            case 46: 
            case 56: 
            case 89: 
            case 131: 
            case 136: 
            case 159: {
                break;
            }
            case 47: 
            case 57: 
            case 67: 
            case 161: 
            case 173: 
            case 195: 
            case 198: {
                break;
            }
            default: {
                TapEnv.toolError("(usedUnits) unexpected operator " + tree.opName());
            }
        }
        return collected;
    }

    public InstructionMask whereMask() {
        return this.whereMask;
    }

    public boolean isMaskDefinition() {
        return this.isMaskDefinition;
    }

    protected void declareIsMaskDefinition() {
        this.isMaskDefinition = true;
    }

    public Instruction fromInclude() {
        return this.fromInclude;
    }

    private Instruction fromIncludeRoot() {
        Instruction result = this.fromInclude;
        while (result.fromInclude != null) {
            result = result.fromInclude;
        }
        return result;
    }

    public String fromIncludeRootName() {
        if (this.fromInclude == null) {
            return null;
        }
        Instruction result = this.fromIncludeRoot();
        if (result.tree != null && result.tree.opCode() == 101) {
            return result.tree.stringValue();
        }
        return null;
    }

    public void setFromInclude(Instruction incl) {
        this.fromInclude = incl;
    }

    public void encloseInWhereMask(InstructionMask enclosingWhereMask) {
        if (this.whereMask == null) {
            this.whereMask = enclosingWhereMask;
        } else if (this.whereMask != enclosingWhereMask) {
            InstructionMask lastWhereMask = this.whereMask;
            while (lastWhereMask.enclosingMask != null && lastWhereMask.enclosingMask != enclosingWhereMask) {
                lastWhereMask = lastWhereMask.enclosingMask;
            }
            lastWhereMask.enclosingMask = enclosingWhereMask;
        }
    }

    public void updateUnitDefinitionStub(Unit definedUnit) {
        int nameRank = definedUnit.isClass() ? 2 : (definedUnit.isModule() ? 1 : 4);
        this.tree.setAnnotation("Unit", definedUnit);
        this.tree.setChild(ILUtils.build(96, definedUnit.name()), nameRank);
    }

    public Unit isUnitDefinitionStub() {
        return this.tree == null ? null : (Unit)this.tree.getAnnotation("Unit");
    }

    public boolean syntaxControls(Instruction controlled) {
        while (controlled != null && controlled != this) {
            controlled = controlled.syntaxController;
        }
        return controlled != null;
    }

    public boolean isALoop() {
        return this.tree != null && this.tree.opCode() == 121;
    }

    public int getPosition() {
        return this.tree == null ? -1 : ILUtils.position(this.tree);
    }

    public void setPosition(Instruction refInstr) {
        int refPos;
        int n = refPos = refInstr == null ? -1 : refInstr.getPosition();
        if (this.tree != null) {
            ILUtils.setPosition(this.tree, refPos);
        }
    }

    public Instruction copy(TapList<TapPair<Instruction, Instruction>> alreadyCopiedMasks) {
        Instruction copyInstr = new Instruction(this.tree.copy());
        copyInstr.preComments = this.preComments;
        copyInstr.postComments = this.postComments;
        copyInstr.preCommentsBlock = this.preCommentsBlock;
        copyInstr.postCommentsBlock = this.postCommentsBlock;
        copyInstr.directives = this.directives;
        copyInstr.whereMask = null;
        if (this.whereMask != null) {
            Instruction localTest = this.whereMask.controlInstruction;
            Instruction result = Instruction.smartCopyWhereMask(localTest, alreadyCopiedMasks);
            copyInstr.whereMask = this.whereMask.copy();
            copyInstr.whereMask.controlInstruction = result;
        }
        copyInstr.isMaskDefinition = this.isMaskDefinition;
        copyInstr.fromInclude = Instruction.fromIncludeCopy(this.fromInclude, true);
        copyInstr.isPhantom = this.isPhantom;
        copyInstr.interfaceUnits = this.interfaceUnits;
        return copyInstr;
    }

    public Tree copyTreePlusComments() {
        if (this.tree == null) {
            return null;
        }
        Tree copyTree = ILUtils.copy(this.tree);
        this.copyCommentsToTree(copyTree);
        return copyTree;
    }

    public void copyCommentsToTree(Tree tree) {
        Tree postCommentsLocation = tree;
        if (tree.opCode() == 121 && tree.down(3) != null) {
            postCommentsLocation = tree.down(3);
        }
        if (this.preComments != null) {
            tree.setAnnotation("preComments", ILUtils.copy(this.preComments));
        }
        if (this.preCommentsBlock != null) {
            tree.setAnnotation("preCommentsBlock", ILUtils.copy(this.preCommentsBlock));
        }
        if (this.postComments != null) {
            postCommentsLocation.setAnnotation("postComments", ILUtils.copy(this.postComments));
        }
        if (this.postCommentsBlock != null) {
            postCommentsLocation.setAnnotation("postCommentsBlock", ILUtils.copy(this.postCommentsBlock));
        }
    }

    public Directive hasDirective(int kind) {
        return Directive.hasDirective(this.directives, kind);
    }

    public boolean isAWhereControl() {
        return this.tree.opCode() == 205 && this.tree.down(2).opCode() == 138 && this.tree.down(3).opCode() == 138 && this.tree.getAnnotation("notemptywhere") == null;
    }

    public InstructionMask getWhereMask() {
        if (this.tree == null) {
            return null;
        }
        if (this.whereMask != null && this.isAWhereControl()) {
            return this.whereMask.enclosingMask;
        }
        return this.whereMask;
    }

    public void setWhereMask(InstructionMask whereMask) {
        this.whereMask = whereMask;
    }

    public int whereMaskDepth() {
        return this.whereMask == null ? 0 : this.whereMask.depth();
    }

    public String containsPreComment(String searched) {
        if (this.preComments == null) {
            return null;
        }
        Tree[] preCommentStringTrees = this.preComments.children();
        String found = null;
        for (int i = preCommentStringTrees.length - 1; i >= 0 && found == null; --i) {
            if (preCommentStringTrees[i].opCode() != 180 || !preCommentStringTrees[i].stringValue().toLowerCase().contains(searched)) continue;
            found = preCommentStringTrees[i].stringValue();
        }
        return found;
    }

    public void addPreComments(String newComment) {
        this.preComments = Instruction.addComment(this.preComments, newComment);
    }

    public void appendPreComments(TapList<Tree> newComments) {
        if (newComments != null) {
            this.preComments = ILUtils.appendComments(this.preComments, newComments, 37);
        }
    }

    public void appendPostComments(TapList<Tree> newComments) {
        if (newComments != null) {
            this.postComments = ILUtils.appendComments(this.postComments, newComments, 37);
        }
    }

    public boolean isAProcedure() {
        return this.tree.opCode() == 89 || this.tree.opCode() == 159;
    }

    public boolean isADeclaration() {
        return this.tree != null && ILUtils.isADeclaration(this.tree);
    }

    public boolean isANoOp() {
        return this.tree != null && this.tree.opCode() == 138;
    }

    public TapList<SymbolDecl> declaredSymbolDecls(SymbolTable publicSymbolTable, SymbolTable privateSymbolTable) {
        TapList<SymbolDecl> result = null;
        switch (this.tree.opCode()) {
            case 199: {
                result = this.getSymbolDeclsFrom(this.tree.down(3), publicSymbolTable, privateSymbolTable);
                break;
            }
            case 45: {
                result = this.getSymbolDeclsFrom(this.tree.down(2), publicSymbolTable, privateSymbolTable);
                break;
            }
            case 202: {
                result = this.getSymbolDeclsFrom(this.tree, publicSymbolTable, privateSymbolTable);
                break;
            }
            case 192: {
                if (this.tree.down(1).opCode() != 96) break;
                SymbolDecl symbDecl = null;
                if (privateSymbolTable != null) {
                    symbDecl = privateSymbolTable.getTopSymbolDecl(ILUtils.baseName(this.tree.down(1)));
                }
                if (symbDecl == null) {
                    symbDecl = publicSymbolTable.getTopSymbolDecl(ILUtils.baseName(this.tree.down(1)));
                }
                if (symbDecl == null) break;
                result = new TapList<SymbolDecl>(symbDecl, null);
                break;
            }
            case 2: {
                if (this.tree.down(2).opCode() != 71) break;
                result = this.getSymbolDeclsFrom(this.tree.down(2), publicSymbolTable, privateSymbolTable);
                break;
            }
            case 74: 
            case 108: 
            case 171: {
                result = this.getSymbolDeclsFrom(this.tree, publicSymbolTable, privateSymbolTable);
                break;
            }
            case 39: {
                result = this.getSymbolDeclsFrom(this.tree.down(2), publicSymbolTable, privateSymbolTable);
                break;
            }
        }
        return result;
    }

    private TapList<SymbolDecl> getSymbolDeclsFrom(Tree declarators, SymbolTable publicSymbolTable, SymbolTable privateSymbolTable) {
        TapList<SymbolDecl> result = null;
        SymbolDecl symbDecl = null;
        for (int i = declarators.length(); i > 0; --i) {
            if (privateSymbolTable != null) {
                symbDecl = privateSymbolTable.getTopSymbolDecl(ILUtils.baseName(declarators.down(i)));
            }
            if (symbDecl == null && publicSymbolTable != null) {
                symbDecl = publicSymbolTable.getTopSymbolDecl(ILUtils.baseName(declarators.down(i)));
            }
            if (symbDecl == null) continue;
            result = new TapList<SymbolDecl>(symbDecl, result);
        }
        return result;
    }

    public void setFromIncludeCopy(Instruction origInclude, boolean copy) {
        Instruction copiedInclude = Instruction.fromIncludeCopy(origInclude, copy);
        this.setFromInclude(copiedInclude);
    }

    public boolean isInStdCInclude() {
        return (TapEnv.relatedLanguageIsC() || TapEnv.relatedLanguage() == 100) && this.isInStdInclude();
    }

    public boolean isInStdInclude() {
        boolean inStd = false;
        Instruction include = this.fromInclude;
        if (include != null && this.tree.opCode() == 101 && this.tree.stringValue().equals(include.tree.stringValue())) {
            include = include.fromInclude();
        }
        while (include != null && !inStd) {
            inStd = include.tree != null && TapEnv.isStdIncludeName(include.tree.stringValue());
            include = include.fromInclude;
        }
        return inStd;
    }

    public void setIncludeOfDiffInstructions(Instruction primalInstruction, boolean primalIsRewritten, TapList<Instruction>[] diffInstructionSR, String suffix) {
        if (!TapEnv.get().expandDiffIncludeFile && this.tree != null && this.tree.stringValue() != null && !this.tree.stringValue().isEmpty()) {
            Instruction diffInclude = this;
            if (!TapEnv.alreadyDiffInclude(this.tree.stringValue())) {
                diffInclude = Instruction.differentiateChainedIncludes(this, suffix, !primalIsRewritten && (diffInstructionSR == null || diffInstructionSR.length == 0 || diffInstructionSR[0] == null));
            }
            if (diffInstructionSR != null) {
                for (int iReplic = diffInstructionSR.length - 1; iReplic >= 0; --iReplic) {
                    TapList<Instruction> diffInstructionS = diffInstructionSR[iReplic];
                    while (diffInstructionS != null) {
                        ((Instruction)diffInstructionS.head).fromInclude = diffInclude;
                        diffInstructionS = diffInstructionS.tail;
                    }
                }
            }
            if (primalInstruction != null) {
                primalInstruction.fromInclude = diffInclude;
                if (primalInstruction.tree != null && primalInstruction.tree.opCode() == 101 && primalInstruction.tree.stringValue().equals(this.tree.stringValue())) {
                    primalInstruction.tree = diffInclude.tree;
                }
            }
        }
    }

    public void forceDiffInclude(String suffix) {
        String originalIncludeString = this.tree.stringValue();
        TapTriplet<String, String, Tree> diffIncludeInfo = TapEnv.getSetDiffIncludeInfo(originalIncludeString);
        if (diffIncludeInfo.second == null) {
            diffIncludeInfo.second = TapEnv.differentiateIncludeName(originalIncludeString, suffix);
        }
    }

    public TapList<Unit> declaresUnits(SymbolTable symbolTable) {
        TapList<Unit> found = null;
        if (this.tree != null) {
            if (this.tree.opCode() == 89) {
                FunctionDecl funcDecl;
                String funcName = ILUtils.getIdentString(this.tree.down(4));
                FunctionDecl functionDecl = funcDecl = funcName == null ? null : symbolTable.getFunctionNotInterfaceDecl(funcName);
                if (funcDecl != null) {
                    found = new TapList<Unit>(funcDecl.unit(), null);
                }
            } else if (this.tree.opCode() == 199) {
                Tree[] declarators = this.tree.down(3).children();
                for (int i = declarators.length - 1; i >= 0; --i) {
                    FunctionDecl funcDecl;
                    if (declarators[i].opCode() != 90) continue;
                    String funcName = ILUtils.getIdentString(declarators[i].down(1));
                    FunctionDecl functionDecl = funcDecl = funcName == null ? null : symbolTable.getFunctionNotInterfaceDecl(funcName);
                    if (funcDecl == null) continue;
                    found = new TapList<Unit>(funcDecl.unit(), found);
                }
            }
        }
        return found;
    }

    public Tree replaceTree(Tree oldTree, Tree newTree) {
        if (newTree == null || newTree == oldTree) {
            return oldTree;
        }
        if (this.tree == oldTree) {
            this.setTree(newTree);
        } else {
            oldTree.parent().setChild(newTree, oldTree.rankInParent());
        }
        return newTree;
    }

    public void setInterfaceUnits(TapList<Unit> units) {
        this.interfaceUnits = units;
        while (units != null) {
            ((Unit)units.head).setInterfaceDeclaration(this);
            units = units.tail;
        }
    }

    public void dump() throws IOException {
        InstructionMask mask = this.whereMask;
        if (mask != null) {
            TapEnv.print("whereMask:");
            mask.dump();
        }
        TapEnv.print(" ");
        if (this.isPhantom) {
            TapEnv.print("phantom: ");
        }
        if (this.tree != null) {
            if (this.tree.getAnnotation("Unit") != null) {
                TapEnv.print("<Definition of " + this.tree.getAnnotation("Unit") + ">");
            } else {
                TapEnv.print(ILUtils.toString(this.tree));
            }
            TapEnv.print(" +line:" + this.lineNo);
            int pos = ILUtils.getPosition(this.tree);
            if (pos != 0) {
                TapEnv.print(" +position:" + pos);
            }
        } else {
            TapEnv.print("null tree");
        }
        if (this.preComments != null) {
            TapEnv.print(" +preComments:");
            if (ILUtils.isNullOrNoneOrEmptyList(this.preComments)) {
                TapEnv.print("empty");
            } else {
                ILUtils.dump(this.preComments, 0);
            }
        }
        if (this.postComments != null) {
            TapEnv.print(" +postComments:");
            if (ILUtils.isNullOrNoneOrEmptyList(this.postComments)) {
                TapEnv.print("empty");
            } else {
                ILUtils.dump(this.postComments, 0);
            }
        }
        if (this.preCommentsBlock != null) {
            TapEnv.print(" +preCommentsBlock:");
            if (ILUtils.isNullOrNoneOrEmptyList(this.preCommentsBlock)) {
                TapEnv.print("empty");
            } else {
                ILUtils.dump(this.preCommentsBlock, 0);
            }
        }
        if (this.postCommentsBlock != null) {
            TapEnv.print(" +postCommentsBlock:");
            if (ILUtils.isNullOrNoneOrEmptyList(this.postCommentsBlock)) {
                TapEnv.print("empty");
            } else {
                ILUtils.dump(this.postCommentsBlock, 0);
            }
        }
        if (this.directives != null) {
            TapEnv.print(" +directives:");
            TapEnv.print(this.directives.toString());
        }
        if (this.fromInclude != null) {
            TapEnv.print(" from ");
            this.fromInclude.dump();
        }
    }

    public String toString() {
        String result = "Instr:";
        if (this.isPhantom) {
            result = "(phantom)" + result;
        }
        if (this.whereMask != null) {
            result = result + this.whereMask;
        }
        result = this.tree == null ? result + "null_tree" : (this.tree.getAnnotation("Unit") != null ? result + "<Definition of " + this.tree.getAnnotation("Unit") + ">" : result + this.tree);
        if (this.fromInclude != null) {
            result = result + " {from " + this.fromInclude + '}';
        }
        return result;
    }
}

