/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.representation;

import fr.inria.tapenade.representation.ArrayDim;
import fr.inria.tapenade.representation.ArrayTypeSpec;
import fr.inria.tapenade.representation.Block;
import fr.inria.tapenade.representation.FunctionDecl;
import fr.inria.tapenade.representation.FunctionTypeSpec;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.Instruction;
import fr.inria.tapenade.representation.NewSymbolHolder;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.TypeSpec;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.representation.VariableDecl;
import fr.inria.tapenade.representation.WrapperTypeSpec;
import fr.inria.tapenade.utils.ToBool;
import fr.inria.tapenade.utils.TopDownTreeWalk;
import fr.inria.tapenade.utils.Tree;

final class InFunction {
    protected final Unit inlinedUnit;
    protected final Unit copiedUnit;
    private final Tree callingTree;
    protected Instruction callingInstruction;
    protected int rank = -1;
    private Tree resultTree;
    private FunctionTypeSpec functionTypeSpec;

    protected InFunction(Unit inF, Tree callTree, Instruction callInstruction, Tree lhs, WrapperTypeSpec[] actualArgsTypes) {
        this.inlinedUnit = inF;
        this.insertMetaVar();
        this.callingTree = callTree;
        if (lhs != null) {
            this.resultTree = ILUtils.copy(lhs);
        }
        this.copiedUnit = new Unit(null, -1, null, this.inlinedUnit.language());
        Unit.copyUnitBody(this.inlinedUnit, this.copiedUnit, callInstruction);
        if (this.inlinedUnit.allBlocks != null) {
            this.copiedUnit.setPrivateSymbolTable(((Block)this.inlinedUnit.allBlocks.head).symbolTable);
        }
        this.copiedUnit.orig2copiedBlocks = null;
        this.copiedUnit.origPublicSTDeclarationBlock = null;
        this.copiedUnit.copyPublicSTDeclarationBlock = null;
        this.copiedUnit.messages = this.inlinedUnit.messages;
        if (this.inlinedUnit.hasArrayNotation()) {
            this.copiedUnit.setHasArrayNotation();
        }
        TapList<Block> copiedBlocks = this.copiedUnit.allBlocks;
        while (copiedBlocks != null) {
            Block copyBlock = (Block)copiedBlocks.head;
            copyBlock.rank += 1000;
            copyBlock.parallelControls = callInstruction.block.parallelControls;
            copiedBlocks = copiedBlocks.tail;
        }
        this.functionTypeSpec = (FunctionTypeSpec)callTree.getAnnotation("functionTypeSpec");
        if (this.functionTypeSpec == null) {
            this.functionTypeSpec = (FunctionTypeSpec)this.inlinedUnit.functionTypeSpec().localize(new TapList<Object>(null, null), new ToBool(false));
            for (int i = this.functionTypeSpec.argumentsTypes.length - 1; i >= 0; --i) {
                if (actualArgsTypes[i] == null) continue;
                this.functionTypeSpec.argumentsTypes[i] = actualArgsTypes[i];
            }
            Tree funcCallTree = callTree.opCode() == 31 ? callTree : callTree.down(2);
            WrapperTypeSpec actualReturnType = callInstruction.block.symbolTable.typeOf(funcCallTree);
            if (actualReturnType != null) {
                this.functionTypeSpec.returnType = actualReturnType;
            }
            callTree.setAnnotation("functionTypeSpec", this.functionTypeSpec);
        }
    }

    private static void replaceVariable(Tree treeOld, Tree treeNew, TapList<Block> blocks) {
        while (blocks != null) {
            Block currentBlock = (Block)blocks.head;
            TapList<Instruction> instructions = currentBlock.instructions;
            while (instructions != null) {
                Instruction instruction = (Instruction)instructions.head;
                if (treeNew.isAtom()) {
                    if (instruction.whereMask() != null) {
                        InFunction.replaceAllIdent(instruction.whereMask().getControlTree(), treeOld, treeNew);
                    }
                    InFunction.replaceAllIdent(instruction.tree, treeOld, treeNew);
                } else {
                    if (instruction.whereMask() != null) {
                        InFunction.replaceAll(instruction.whereMask().getControlTree(), treeOld, treeNew);
                    }
                    InFunction.replaceAll(instruction.tree, treeOld, treeNew);
                }
                instructions = instructions.tail;
            }
            blocks = blocks.tail;
        }
    }

    private static void replaceAll(Tree tree, Tree oldTree, Tree newTree) {
        TapList<Tree> trees = InFunction.getAll(tree, oldTree);
        while (trees != null) {
            Tree currentTree = (Tree)trees.head;
            currentTree.parent().setChild(ILUtils.copy(newTree), currentTree.rankInParent());
            trees = trees.tail;
        }
    }

    private static TapList<Tree> getAll(Tree tree, Tree oldTree) {
        TapList<Tree> result = null;
        TopDownTreeWalk i = new TopDownTreeWalk(tree);
        while (!i.atEnd()) {
            Tree currentTree = i.get();
            if (currentTree.equalsTree(oldTree)) {
                result = new TapList<Tree>(currentTree, result);
            }
            i.advance();
        }
        return result;
    }

    public static void replaceAllIdent(Tree tree, Tree oldTree, Tree newTree) {
        if (newTree.isStringAtom() && newTree.opCode() == oldTree.opCode()) {
            String newTreeValue = newTree.stringValue();
            TopDownTreeWalk i = new TopDownTreeWalk(tree);
            while (!i.atEnd()) {
                Tree currentTree = i.get();
                if (currentTree.equalsTree(oldTree)) {
                    currentTree.setValue(newTreeValue);
                }
                i.advance();
            }
        } else {
            InFunction.replaceAll(tree, oldTree, newTree);
        }
    }

    private static String createNewVarName(String name, SymbolTable futureUsageSymbolTable) {
        int i = 1;
        while (futureUsageSymbolTable.getVariableDecl(name + i) != null) {
            ++i;
        }
        return name + i;
    }

    protected TapList<Block> allBlocks() {
        return this.copiedUnit.allBlocks;
    }

    private void insertMetaVar() {
        Tree callTree = this.inlinedUnit.entryBlock().headTree();
        assert (callTree != null);
        Tree unitName = ILUtils.getCalledName(callTree);
        Tree[] args = ILUtils.getArguments(callTree).children();
        InFunction.replaceVariable(unitName, ILUtils.build(123, unitName.stringValue()), new TapList<Block>(this.inlinedUnit.entryBlock(), this.inlinedUnit.allBlocks));
        for (Tree arg : args) {
            InFunction.replaceVariable(arg, ILUtils.build(123, arg.stringValue()), new TapList<Block>(this.inlinedUnit.entryBlock(), this.inlinedUnit.allBlocks));
        }
    }

    protected Tree replaceAllVariables(SymbolTable futureUsageSymbolTable, SymbolTable futureDeclSymbolTable) {
        Tree[] newTrees = ILUtils.getArguments(this.callingTree).children();
        assert (this.inlinedUnit.entryBlock().headTree() != null);
        Tree[] oldTrees = ILUtils.getArguments(this.inlinedUnit.entryBlock().headTree()).children();
        Tree functionName = ILUtils.getCalledName(this.inlinedUnit.entryBlock().headTree());
        for (int i = 0; i < oldTrees.length; ++i) {
            if (!ILUtils.instrHasSideEffect(newTrees[i]) && this.cost(newTrees[i]) < 100) {
                InFunction.replaceVariable(oldTrees[i], newTrees[i], this.allBlocks());
                continue;
            }
            this.insertLocalVariable(oldTrees[i], newTrees[i], futureUsageSymbolTable, futureDeclSymbolTable, i);
        }
        Tree newFunctionName = null;
        Tree functionNameIdent = ILUtils.build(123, functionName.stringValue());
        if (this.resultTree != null) {
            this.replaceLeftVariableInAssign(functionNameIdent, this.resultTree, null, futureUsageSymbolTable);
        } else {
            NewSymbolHolder symbolHolder = this.declareNewVarName(functionName.stringValue(), futureUsageSymbolTable);
            newFunctionName = symbolHolder.makeNewRef(futureDeclSymbolTable);
            this.replaceLeftVariableInAssign(functionNameIdent, newFunctionName, symbolHolder, futureUsageSymbolTable);
        }
        return newFunctionName;
    }

    private void replaceLeftVariableInAssign(Tree treeOld, Tree treeNew, NewSymbolHolder symbolHolder, SymbolTable futureUsageSymbolTable) {
        VariableDecl newVarDecl = null;
        TapList<Block> blocks = this.allBlocks();
        if (symbolHolder != null) {
            newVarDecl = symbolHolder.newVariableDecl();
        }
        while (blocks != null) {
            Block currentBlock = (Block)blocks.head;
            TapList<Instruction> instructions = currentBlock.instructions;
            while (instructions != null) {
                Instruction instruction = (Instruction)instructions.head;
                if (instruction.tree.opCode() == 14) {
                    Tree tree1 = instruction.tree.down(1);
                    if (tree1.equalsTree(treeOld)) {
                        instruction.tree.setChild(ILUtils.copy(treeNew), 1);
                    } else if (tree1.opCode() == 151 && tree1.down(1).equalsTree(treeOld)) {
                        tree1.setChild(ILUtils.copy(treeNew), 1);
                    }
                    WrapperTypeSpec curTypeSpec = futureUsageSymbolTable.typeOf(instruction.tree.down(2));
                    if (newVarDecl != null && newVarDecl.type() != curTypeSpec && curTypeSpec != null) {
                        TapList<ArrayDim> dims;
                        newVarDecl.type().receives(curTypeSpec, null, null);
                        if (TypeSpec.isA(newVarDecl.type(), 2) && (dims = newVarDecl.type().getAllDimensions()) == null && TypeSpec.isA(curTypeSpec, 2)) {
                            ((ArrayTypeSpec)newVarDecl.type().wrappedType).setDimensions(((ArrayTypeSpec)curTypeSpec.wrappedType).dimensions());
                        }
                    }
                }
                instructions = instructions.tail;
            }
            blocks = blocks.tail;
        }
    }

    private void insertLocalVariable(Tree formalArg, Tree actualArg, SymbolTable futureUsageSymbolTable, SymbolTable futureDeclSymbolTable, int rank) {
        Block firstBlock = (Block)this.allBlocks().head;
        TapList<Instruction> instructions = firstBlock.instructions;
        Tree leftTree = ILUtils.copy(formalArg);
        assert (leftTree != null);
        String newVarName = InFunction.createNewVarName(leftTree.stringValue(), futureUsageSymbolTable);
        leftTree.setValue(newVarName);
        Tree tree = ILUtils.build(14, leftTree, ILUtils.copy(actualArg));
        WrapperTypeSpec newVarType = this.functionTypeSpec.argumentsTypes != null ? this.functionTypeSpec.argumentsTypes[rank] : new WrapperTypeSpec(null);
        VariableDecl varDecl = new VariableDecl(leftTree, newVarType);
        futureDeclSymbolTable.addSymbolDecl(varDecl);
        Tree varDeclaration = varDecl.buildVarDeclaration(futureDeclSymbolTable);
        InFunction.replaceVariable(formalArg, leftTree, this.allBlocks());
        TapList<Instruction> lastinstruction = null;
        while (instructions != null) {
            lastinstruction = instructions;
            instructions = instructions.tail;
        }
        assert (lastinstruction != null);
        Instruction newInstr = new Instruction(varDeclaration, ((Instruction)lastinstruction.head).syntaxController, ((Instruction)lastinstruction.head).block);
        futureDeclSymbolTable.declarationsBlock.addInstrHdAfterDecls(newInstr);
        newInstr = new Instruction(tree, ((Instruction)lastinstruction.head).syntaxController, ((Instruction)lastinstruction.head).block);
        newInstr.setWhereMask(((Instruction)lastinstruction.head).getWhereMask());
        TapList newTail = new TapList(lastinstruction.head, lastinstruction.tail);
        lastinstruction.head = newInstr;
        lastinstruction.tail = newTail;
        InFunction.replaceVariable(leftTree, ILUtils.build(96, leftTree.stringValue()), this.allBlocks());
    }

    private NewSymbolHolder declareNewVarName(String name, SymbolTable futureUsageSymbolTable) {
        FunctionDecl oldFunctionDecl;
        WrapperTypeSpec typeSpec = null;
        TapList<FunctionDecl> oldFunctionDecls = futureUsageSymbolTable.getFunctionDecl(name, null, null, false);
        FunctionDecl functionDecl = oldFunctionDecl = oldFunctionDecls == null ? null : (FunctionDecl)oldFunctionDecls.head;
        if (oldFunctionDecl != null) {
            typeSpec = this.functionTypeSpec.returnType;
            if (typeSpec.wrappedType == null && oldFunctionDecl.unit() != null && oldFunctionDecl.functionTypeSpec() != null) {
                typeSpec = oldFunctionDecl.functionTypeSpec().returnType;
            }
        }
        NewSymbolHolder symbolHolder = new NewSymbolHolder(name);
        Tree newTree = symbolHolder.makeNewRef(futureUsageSymbolTable);
        typeSpec = typeSpec.checkNoneDimensionsOfNewSH(name, name, newTree, futureUsageSymbolTable, symbolHolder);
        symbolHolder.setAsVariable(typeSpec, null);
        symbolHolder.declarationLevelMustInclude(futureUsageSymbolTable);
        return symbolHolder;
    }

    private int cost(Tree tree) {
        int result;
        switch (tree.opCode()) {
            case 103: 
            case 160: {
                result = 2;
                break;
            }
            case 9: {
                result = 2 + this.cost(tree.down(2).children());
                break;
            }
            case 3: {
                result = 5 + this.cost(tree.down(1)) + this.cost(tree.down(2));
                break;
            }
            case 133: {
                result = 20 + this.cost(tree.down(1)) + this.cost(tree.down(2));
                break;
            }
            case 62: {
                result = 30 + this.cost(tree.down(1)) + this.cost(tree.down(2));
                break;
            }
            case 31: {
                result = 100 + this.cost(ILUtils.getArguments(tree).children());
                break;
            }
            default: {
                result = 10;
            }
        }
        return result;
    }

    private int cost(Tree[] tree) {
        int result = 0;
        for (Tree value : tree) {
            result += this.cost(value);
        }
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("InFunction ");
        result.append(this.inlinedUnit);
        result.append(" rank ");
        result.append(this.rank);
        result.append(System.lineSeparator());
        if (this.callingInstruction != null) {
            result.append(this.callingInstruction).append(System.lineSeparator());
        }
        if (this.callingTree != null) {
            result.append(this.callingTree).append(System.lineSeparator());
        }
        TapList<Block> allBlocks = this.copiedUnit.allBlocks;
        while (allBlocks != null) {
            result.append("    Block ").append(allBlocks.head).append(" instructions:").append(((Block)allBlocks.head).instructions).append(System.lineSeparator());
            allBlocks = allBlocks.tail;
        }
        return result.toString();
    }
}

