/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.representation;

import fr.inria.tapenade.analysis.ADActivityAnalyzer;
import fr.inria.tapenade.analysis.ActivityPattern;
import fr.inria.tapenade.analysis.ReqExplicit;
import fr.inria.tapenade.representation.ArrayDim;
import fr.inria.tapenade.representation.FunctionDecl;
import fr.inria.tapenade.representation.Instruction;
import fr.inria.tapenade.representation.NewSymbolHolder;
import fr.inria.tapenade.representation.PrimitiveTypeSpec;
import fr.inria.tapenade.representation.SymbolDecl;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.TypeSpec;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.representation.WrapperTypeSpec;
import fr.inria.tapenade.utils.ILLangOps;
import fr.inria.tapenade.utils.Operator;
import fr.inria.tapenade.utils.TapIntList;
import fr.inria.tapenade.utils.TapPair;
import fr.inria.tapenade.utils.ToBool;
import fr.inria.tapenade.utils.ToInt;
import fr.inria.tapenade.utils.TopDownTreeWalk;
import fr.inria.tapenade.utils.Tree;
import java.io.IOException;
import java.util.Enumeration;

public final class ILUtils {
    private static final int DIFFERENT = -1;
    private static final int DOUBT = 0;
    private static final int SAME = 1;
    private static final int MAX_LIST_LENGTH = 78;

    public static Operator operator(String name) {
        int g = 1;
        int d = ILLangOps.opsLength() - 1;
        while (g <= d) {
            int m = (g + d) / 2;
            String opName = ILLangOps.ops((int)m).name;
            if (name.equals(opName)) {
                return ILLangOps.ops(m);
            }
            if (name.compareTo(opName) < 0) {
                d = m - 1;
                continue;
            }
            g = m + 1;
        }
        return null;
    }

    public static String getIdentString(Tree tree) {
        if (tree != null && (tree.opCode() == 96 || tree.opCode() == 123)) {
            return tree.stringValue();
        }
        return null;
    }

    public static boolean isIdent(Tree tree, String name, boolean caseSensitive) {
        return tree != null && name != null && tree.opCode() == 96 && (caseSensitive ? name.equals(tree.stringValue()) : name.equalsIgnoreCase(tree.stringValue()));
    }

    public static boolean isACIOSymbol(Tree tree) {
        String varName = ILUtils.baseName(tree);
        return "stdin".equals(varName) || "stdout".equals(varName) || "stderr".equals(varName);
    }

    public static boolean isParallelController(Tree tree) {
        return tree != null && (tree.opCode() == 145 || tree.opCode() == 144);
    }

    public static boolean isCudaController(Tree tree) {
        return tree != null && tree.opCode() == 145 && ILUtils.isIdent(tree.down(1), "CUDA", true);
    }

    public static boolean isIdentOf(Tree tree, String[] names, boolean caseSensitive) {
        if (tree == null || tree.opCode() != 96) {
            return false;
        }
        String name = tree.stringValue();
        boolean found = false;
        for (int i = names.length - 1; i >= 0 && !found; --i) {
            found = caseSensitive ? names[i].equals(name) : names[i].equalsIgnoreCase(name);
        }
        return found;
    }

    public static boolean isStringOf(String name, String[] names) {
        boolean found = false;
        for (int i = names.length - 1; i >= 0 && !found; --i) {
            found = names[i].equals(name);
        }
        return found;
    }

    public static boolean isIntCst(Tree tree, int value) {
        return tree != null && tree.opCode() == 103 && tree.intValue() == value;
    }

    public static boolean isOptPointersIdent(Tree tree) {
        return tree != null && (tree.opCode() == 96 || tree.opCode() == 153 && ILUtils.isOptPointersIdent(tree.down(1)));
    }

    public static boolean isAllocate(Tree tree) {
        if (tree == null) {
            return false;
        }
        while (tree.opCode() == 32) {
            tree = tree.down(2);
        }
        return tree.opCode() == 5;
    }

    public static Tree skipAllocate(Tree tree) {
        if (tree == null) {
            return null;
        }
        switch (tree.opCode()) {
            case 5: {
                return ILUtils.copy(tree.down(1));
            }
            case 9: 
            case 75: 
            case 151: {
                return ILUtils.build(tree.opCode(), ILUtils.skipAllocate(tree.down(1)), ILUtils.copy(tree.down(2)));
            }
        }
        return ILUtils.copy(tree);
    }

    public static boolean isAccessibleDirectlyFromVariable(Tree tree) {
        if (tree == null) {
            return true;
        }
        switch (tree.opCode()) {
            case 5: 
            case 151: {
                return false;
            }
        }
        if (!tree.isAtom() && tree.down(1) != null) {
            return ILUtils.isAccessibleDirectlyFromVariable(tree.down(1));
        }
        return true;
    }

    public static String getCallFunctionNameString(Tree callTree) {
        if (callTree.opCode() == 109) {
            callTree = callTree.down(1);
        } else if (callTree.opCode() == 31) {
            callTree = ILUtils.getCalledName(callTree);
        }
        while (callTree != null && callTree.opCode() != 96) {
            if (callTree.opCode() == 151 || callTree.opCode() == 9) {
                callTree = callTree.down(1);
                continue;
            }
            if (callTree.opCode() == 173 || callTree.opCode() == 75) {
                callTree = callTree.down(2);
                continue;
            }
            callTree = null;
        }
        return callTree != null ? ILUtils.getIdentString(callTree) : null;
    }

    public static Tree buildCall(Tree object, Tree funcName, Tree arguments) {
        return ILUtils.build(31, object, funcName, arguments);
    }

    public static Tree buildCall(Tree funcName, Tree arguments) {
        return ILUtils.build(31, ILUtils.build(138), funcName, arguments);
    }

    public static Tree getObject(Tree callTree) {
        return callTree.down(1);
    }

    public static Tree getCalledName(Tree callTree) {
        return callTree.down(2);
    }

    public static String getCalledNameString(Tree callTree) {
        Tree calledName = ILUtils.getCalledName(callTree);
        while (calledName != null && calledName.opCode() != 96) {
            if (calledName.opCode() == 151 || calledName.opCode() == 9) {
                calledName = calledName.down(1);
                continue;
            }
            if (calledName.opCode() == 173 || calledName.opCode() == 75) {
                calledName = calledName.down(2);
                continue;
            }
            calledName = null;
        }
        return ILUtils.getIdentString(calledName);
    }

    public static Tree getArguments(Tree callTree) {
        return callTree.down(3);
    }

    public static void setArguments(Tree callTree, Tree arguments) {
        callTree.setChild(arguments, 3);
    }

    public static boolean isCallingString(Tree callTree, String calledName, boolean caseSensitive) {
        if (callTree != null && callTree.opCode() == 31) {
            String calledString = ILUtils.getCalledNameString(callTree);
            return caseSensitive ? calledName.equals(calledString) : calledName.equalsIgnoreCase(calledString);
        }
        return false;
    }

    public static String getClassNameString(Tree constructorCallTree) {
        String classNameType = null;
        if (constructorCallTree.opCode() == 151 || constructorCallTree.opCode() == 9) {
            classNameType = ILUtils.baseName(constructorCallTree.down(1));
        } else if (constructorCallTree.opCode() == 96) {
            classNameType = constructorCallTree.stringValue();
        }
        if (classNameType != null && classNameType.length() >= 6 && classNameType.startsWith("class ")) {
            return classNameType.substring(6);
        }
        return classNameType;
    }

    public static boolean isAccessedThroughPointer(Tree expr) {
        switch (expr.opCode()) {
            case 9: 
            case 75: 
            case 110: {
                return ILUtils.isAccessedThroughPointer(expr.down(1));
            }
            case 71: {
                Tree[] sons = expr.children();
                boolean isatp = false;
                for (int i = sons.length - 1; !isatp && i >= 0; --i) {
                    isatp = ILUtils.isAccessedThroughPointer(sons[i]);
                }
                return isatp;
            }
            case 151: {
                return true;
            }
        }
        return false;
    }

    public static boolean hasTwoLevelIndex(Tree indices, SymbolTable symbolTable) {
        Tree[] indexList = indices.children();
        boolean hasTwoLevels = false;
        for (int i = indexList.length - 1; !hasTwoLevels && i >= 0; --i) {
            hasTwoLevels = !ILUtils.isNullOrNone(indexList[i]) && indexList[i].opCode() != 12 && symbolTable.typeOf(indexList[i]).isArray();
        }
        return hasTwoLevels;
    }

    public static boolean containsModifier(String value, Tree tree, boolean stopOnPointer) {
        boolean result = false;
        Tree declarator = tree.down(3).down(1);
        if (stopOnPointer && declarator != null && ILUtils.containsPointerDeclarator(declarator)) {
            return false;
        }
        if (tree.opCode() == 199 && tree.down(2).opCode() == 129) {
            result = ILUtils.containsModifierRec(value, tree.down(2));
        }
        return result;
    }

    private static boolean containsPointerDeclarator(Tree tree) {
        switch (tree.opCode()) {
            case 96: {
                return false;
            }
            case 153: {
                return true;
            }
            case 9: 
            case 11: 
            case 14: 
            case 90: 
            case 128: 
            case 151: 
            case 175: {
                return ILUtils.containsPointerDeclarator(tree.down(1));
            }
        }
        return false;
    }

    private static boolean containsModifierRec(String value, Tree subTree) {
        Tree modifiers = subTree.down(1);
        boolean found = false;
        int nb = modifiers.length();
        for (int i = 1; !found && i <= nb; ++i) {
            found = modifiers.down(i).opCode() == 96 && modifiers.down(i).stringValue().equals(value);
        }
        boolean result = found;
        if (!result && subTree.down(2).opCode() == 129) {
            result = ILUtils.containsModifierRec(value, subTree.down(2));
        }
        return result;
    }

    public static boolean containsUnknownDimension(Tree expr) {
        boolean unknown = false;
        switch (expr.opCode()) {
            case 75: 
            case 110: {
                unknown = ILUtils.containsUnknownDimension(expr.down(1));
                break;
            }
            case 71: {
                Tree[] sons = expr.children();
                for (int i = sons.length - 1; !unknown && i >= 0; --i) {
                    unknown = ILUtils.containsUnknownDimension(sons[i]);
                }
                break;
            }
            case 9: {
                unknown = ILUtils.containsUnknownDimension(expr.down(1));
                if (unknown) break;
                Tree[] dims = expr.down(2).children();
                for (int i = dims.length - 1; i >= 0 && !unknown; --i) {
                    if (!ILUtils.isUnknownDim(dims[i])) continue;
                    unknown = true;
                }
                break;
            }
            case 151: {
                unknown = ILUtils.containsUnknownDimension(expr.down(1));
                if (unknown) break;
                unknown = ILUtils.isUnknownDim(expr.down(2));
                break;
            }
        }
        return unknown;
    }

    private static boolean isUnknownDim(Tree dim) {
        if (ILUtils.isNullOrNone(dim)) {
            return true;
        }
        Tree lastIndex = dim;
        if (dim.opCode() == 59) {
            lastIndex = dim.down(2);
        } else if (dim.opCode() == 12) {
            lastIndex = dim.down(2);
        }
        return ILUtils.isNullOrNoneOrStar(lastIndex);
    }

    public static boolean isIORead(Tree tree) {
        if (tree.opCode() != 109) {
            return false;
        }
        String ioAction = ILUtils.getIdentString(tree.down(1));
        assert (ioAction != null);
        return ioAction.equals("read") || ioAction.equals("accept") || ioAction.equals("decode");
    }

    public static boolean isIOWrite(Tree tree) {
        if (tree.opCode() != 109) {
            return false;
        }
        String ioAction = ILUtils.getIdentString(tree.down(1));
        assert (ioAction != null);
        return ioAction.equals("write") || ioAction.equals("rewrite") || ioAction.equals("print") || ioAction.equals("encode");
    }

    public static boolean disjointPath(Tree exp1, Tree exp2) {
        if (ILUtils.isNullOrNone(exp1)) {
            return !ILUtils.isNullOrNone(exp2);
        }
        if (ILUtils.isNullOrNone(exp2)) {
            return true;
        }
        switch (exp1.opCode()) {
            case 96: {
                return false;
            }
            case 75: {
                if (exp2.opCode() == 96) {
                    return false;
                }
                return exp2.opCode() != 75 || !ILUtils.getIdentString(exp1.down(2)).equals(ILUtils.getIdentString(exp2.down(2))) || ILUtils.disjointPath(exp1.down(1), exp2.down(1));
            }
            case 9: {
                if (exp2.opCode() == 96) {
                    return false;
                }
                return exp2.opCode() != exp1.opCode() || ILUtils.disjointPath(exp1.down(1), exp2.down(1));
            }
        }
        TapEnv.toolError("(disjointPath) Unexpected operator: " + exp1.opName());
        return false;
    }

    public static String gotoLabelVar(Tree tree) {
        return tree.down(1).stringValue();
    }

    public static String assignedLabelVar(Tree tree) {
        return tree.down(2).stringValue();
    }

    public static String assignedLabel(Tree tree) {
        return tree.down(1).stringValue();
    }

    public static String assignedName(Tree tree) {
        return ILUtils.baseName(tree.down(1));
    }

    public static int getFieldRank(Tree field) {
        Object fieldRankObject = field.getAnnotation("fieldRank");
        if (fieldRankObject == null) {
            return -1;
        }
        return (Integer)fieldRankObject;
    }

    public static void setFieldRank(Tree field, int fieldRank) {
        field.setAnnotation("fieldRank", fieldRank);
    }

    public static boolean isImplicitCompleteDimension(Tree indexTree) {
        return indexTree.opCode() == 59 && ILUtils.isNullOrNone(indexTree.down(1)) && ILUtils.isNullOrNone(indexTree.down(2)) || indexTree.opCode() == 12 && ILUtils.isNullOrNone(indexTree.down(1)) && ILUtils.isNullOrNone(indexTree.down(2)) && ILUtils.isNullOrNone(indexTree.down(3));
    }

    public static TapList<Tree> collectIndexes(Tree tree, TapList<Tree> indexes) {
        switch (tree.opCode()) {
            case 9: {
                Tree[] indices = tree.down(2).children();
                for (int i = indices.length - 1; i >= 0; --i) {
                    indexes = new TapList<Tree>(indices[i], indexes);
                }
                ILUtils.collectIndexes(tree.down(1), indexes);
                break;
            }
            case 75: 
            case 183: {
                ILUtils.collectIndexes(tree.down(1), indexes);
                break;
            }
            case 151: {
                indexes = new TapList<Tree>(tree.down(2), indexes);
                ILUtils.collectIndexes(tree.down(1), indexes);
                break;
            }
            case 96: {
                break;
            }
            default: {
                TapEnv.toolError("(Collect indexes) Unexpected operator: " + tree.opName());
            }
        }
        return indexes;
    }

    public static Tree baseTree(Tree tree) {
        switch (tree.opCode()) {
            case 4: 
            case 9: 
            case 11: 
            case 14: 
            case 52: 
            case 75: 
            case 90: 
            case 151: 
            case 153: 
            case 163: 
            case 175: 
            case 183: {
                return ILUtils.baseTree(tree.down(1));
            }
            case 31: {
                return ILUtils.baseTree(ILUtils.getCalledName(tree));
            }
            case 3: 
            case 5: 
            case 20: 
            case 28: 
            case 43: 
            case 54: 
            case 62: 
            case 103: 
            case 124: 
            case 129: 
            case 130: 
            case 133: 
            case 138: 
            case 160: 
            case 177: 
            case 180: 
            case 182: {
                return null;
            }
            case 71: 
            case 96: {
                return tree;
            }
            case 32: 
            case 128: 
            case 134: 
            case 173: {
                return ILUtils.baseTree(tree.down(2));
            }
            case 98: 
            case 99: {
                Tree base = ILUtils.baseTree(tree.down(2));
                if (base == null) {
                    base = ILUtils.baseTree(tree.down(3));
                }
                return base;
            }
            case 110: {
                return ILUtils.baseTree(tree.down(1).down(1));
            }
        }
        TapEnv.toolError("(Get base Tree) Unexpected operator: " + tree.opName());
        return tree;
    }

    public static String baseName(Tree tree) {
        switch (tree.opCode()) {
            case 96: 
            case 123: {
                return ILUtils.getIdentString(tree);
            }
            case 4: 
            case 9: 
            case 11: 
            case 14: 
            case 52: 
            case 75: 
            case 90: 
            case 106: 
            case 151: 
            case 152: 
            case 153: 
            case 161: 
            case 163: 
            case 175: 
            case 183: {
                return ILUtils.baseName(tree.down(1));
            }
            case 31: {
                return ILUtils.baseName(ILUtils.getCalledName(tree));
            }
            case 71: {
                if (tree.length() > 0) {
                    return ILUtils.baseName(tree.down(1));
                }
                return null;
            }
            case 3: 
            case 5: 
            case 13: 
            case 20: 
            case 29: 
            case 35: 
            case 41: 
            case 54: 
            case 62: 
            case 78: 
            case 98: 
            case 99: 
            case 103: 
            case 104: 
            case 124: 
            case 129: 
            case 130: 
            case 133: 
            case 138: 
            case 154: 
            case 160: 
            case 164: 
            case 177: 
            case 180: 
            case 182: 
            case 195: 
            case 204: {
                return null;
            }
            case 2: 
            case 17: 
            case 32: 
            case 128: 
            case 134: 
            case 173: {
                return ILUtils.baseName(tree.down(2));
            }
            case 110: {
                return ILUtils.baseName(tree.down(1).down(1));
            }
        }
        if (!tree.isAtom() && tree.down(1) != null && tree.down(1).opCode() == 138) {
            return tree.opName();
        }
        TapEnv.toolError("(Get base name) Unexpected operator: " + tree.opName());
        return null;
    }

    public static Tree baseTypeTree(Tree tree) {
        switch (tree.opCode()) {
            case 29: 
            case 35: 
            case 41: 
            case 78: 
            case 96: 
            case 104: {
                return tree;
            }
            case 13: 
            case 67: 
            case 91: 
            case 154: 
            case 161: {
                return ILUtils.baseTypeTree(tree.down(1));
            }
            case 129: {
                return ILUtils.baseTypeTree(tree.down(2));
            }
        }
        return null;
    }

    public static Tree addPointerAccess(Tree tree) {
        if (tree.opCode() == 4) {
            return tree.cutChild(1);
        }
        return ILUtils.build(151, tree, ILUtils.build(138));
    }

    public static Tree addPointerAccessAtBase(Tree tree) {
        switch (tree.opCode()) {
            case 9: 
            case 75: 
            case 151: 
            case 183: {
                tree.setChild(ILUtils.addPointerAccessAtBase(tree.cutChild(1)), 1);
                break;
            }
            case 4: {
                if (tree.down(1).opCode() == 96) {
                    tree = tree.cutChild(1);
                    break;
                }
                tree.setChild(ILUtils.addPointerAccessAtBase(tree.cutChild(1)), 1);
                break;
            }
            case 96: {
                tree = ILUtils.build(151, tree, ILUtils.build(138));
                break;
            }
            default: {
                TapEnv.toolError("(Add pointerAccess at base) Unexpected operator: " + tree.opName());
            }
        }
        return tree;
    }

    public static Tree addAddressOf(Tree tree) {
        if (tree.opCode() == 151 && ILUtils.isNullOrNone(tree.down(2))) {
            return tree.cutChild(1);
        }
        return ILUtils.build(4, tree);
    }

    public static Tree addAddressOfAtBase(Tree tree) {
        switch (tree.opCode()) {
            case 4: 
            case 9: 
            case 75: 
            case 183: {
                tree.setChild(ILUtils.addAddressOfAtBase(tree.cutChild(1)), 1);
                break;
            }
            case 151: {
                if (ILUtils.isNullOrNone(tree.down(1)) || tree.down(1).opCode() == 96) {
                    tree = tree.cutChild(1);
                    break;
                }
                tree.setChild(ILUtils.addAddressOfAtBase(tree.cutChild(1)), 1);
                break;
            }
            case 96: {
                tree = ILUtils.build(4, tree);
                break;
            }
            default: {
                TapEnv.toolError("(Add addressOf at base) Unexpected operator: " + tree.opName());
            }
        }
        return tree;
    }

    public static String getUnitName(Tree tree) {
        if (tree.opCode() == 89) {
            return ILUtils.getIdentString(tree.down(4));
        }
        return null;
    }

    public static Tree contains(Tree tree, int operator, String value) {
        Tree result = null;
        if (tree == null) {
            return null;
        }
        switch (tree.opCode()) {
            case 9: 
            case 151: {
                result = ILUtils.contains(tree.down(1), operator, value);
                break;
            }
            case 75: {
                if (operator != 75) break;
                result = tree;
                break;
            }
            case 199: {
                if (operator == 14 || operator == 152) {
                    result = ILUtils.contains(tree.down(3), operator, value);
                    break;
                }
                if (operator != 130) break;
                result = ILUtils.contains(tree.down(2), 130, value);
                break;
            }
            case 54: {
                for (int i = 1; result == null && i <= tree.length(); ++i) {
                    result = ILUtils.contains(tree.down(i), operator, value);
                }
                break;
            }
            case 14: 
            case 152: {
                result = tree;
                break;
            }
            case 129: {
                result = ILUtils.contains(tree.down(1), operator, value);
                if (result != null) break;
                result = ILUtils.contains(tree.down(2), operator, value);
                break;
            }
            case 130: {
                for (int i = 1; result == null && i <= tree.length(); ++i) {
                    if (!ILUtils.isIdent(tree.down(i), value, true)) continue;
                    result = tree.down(i);
                }
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    public static boolean isAVariableOnlyDeclaration(Tree tree) {
        if (tree.opCode() != 199) {
            return false;
        }
        Tree[] declarators = tree.down(3).children();
        boolean onlyVarDeclarators = true;
        for (int i = declarators.length - 1; i >= 0 && onlyVarDeclarators; --i) {
            Tree declarator = declarators[i];
            while (declarator.opCode() == 128) {
                declarator = declarator.down(2);
            }
            if (declarator.opCode() != 90 && declarator.opCode() != 48 && declarator.opCode() != 58) continue;
            onlyVarDeclarators = false;
        }
        return onlyVarDeclarators;
    }

    public static boolean declaresVariable(Tree tree, String varName) {
        if (varName == null || tree.opCode() != 199) {
            return false;
        }
        Tree[] declarators = tree.down(3).children();
        boolean found = false;
        for (int i = declarators.length - 1; i >= 0 && !found; --i) {
            Tree declarator = declarators[i];
            block5: while (declarator != null && declarator.opCode() != 96) {
                switch (declarator.opCode()) {
                    case 11: 
                    case 14: 
                    case 153: 
                    case 163: 
                    case 175: {
                        declarator = declarator.down(1);
                        continue block5;
                    }
                    case 128: {
                        declarator = declarator.down(2);
                        continue block5;
                    }
                }
                declarator = null;
            }
            if (!varName.equals(ILUtils.getIdentString(declarator))) continue;
            found = true;
        }
        return found;
    }

    public static boolean isADeclaration(Tree tree) {
        return tree.opCode() == 199 || tree.opCode() == 202 || tree.opCode() == 45 || tree.opCode() == 192 || tree.opCode() == 90 || tree.opCode() == 89 || tree.opCode() == 159 || tree.opCode() == 131 || tree.opCode() == 36 || tree.opCode() == 46 || tree.opCode() == 56 || tree.opCode() == 106 || tree.opCode() == 2 || tree.opCode() == 74 || tree.opCode() == 108 || tree.opCode() == 171 || tree.opCode() == 135 || tree.opCode() == 39 || tree.opCode() == 69 || tree.opCode() == 197 || tree.opCode() == 101;
    }

    public static boolean isAUnitPlaceHolder(Tree tree) {
        return tree != null && (tree.opCode() == 89 || tree.opCode() == 159 || tree.opCode() == 131 || tree.opCode() == 36 || tree.opCode() == 46 || tree.opCode() == 56 || tree.opCode() == 136) && tree.getAnnotation("Unit") != null;
    }

    public static boolean isADeclMayAppearFirst(Tree tree) {
        return tree.opCode() == 74 || tree.opCode() == 108 || tree.opCode() == 2 && !ILUtils.isNullOrNoneOrEmptyList(tree.down(2)) && !ILUtils.isIdentOf(tree.down(1), new String[]{"allocatable", "target", "pointer"}, false);
    }

    public static boolean isAVarRef(Tree tree, SymbolTable symbolTable) {
        switch (tree.opCode()) {
            case 96: {
                SymbolDecl symbolDecl;
                SymbolDecl symbolDecl2 = symbolDecl = symbolTable == null ? null : symbolTable.getSymbolDecl(ILUtils.getIdentString(tree));
                if (symbolDecl != null) {
                    return symbolDecl.isA(1) && !symbolDecl.hasModifier("constant") && !symbolDecl.isCconst();
                }
                return NewSymbolHolder.getAttachedVariableDecl(tree) != null;
            }
            case 9: 
            case 75: 
            case 151: 
            case 183: {
                return ILUtils.isAVarRef(tree.down(1), symbolTable);
            }
        }
        return false;
    }

    public static boolean isAWritableVarRef(Tree tree, SymbolTable symbolTable) {
        switch (tree.opCode()) {
            case 96: {
                SymbolDecl symbolDecl = symbolTable.getSymbolDecl(ILUtils.getIdentString(tree));
                if (symbolDecl != null) {
                    return symbolDecl.isA(1) && !symbolDecl.hasModifier("constant");
                }
                return NewSymbolHolder.getAttachedVariableDecl(tree) != null;
            }
            case 4: 
            case 9: 
            case 75: 
            case 151: 
            case 183: {
                return ILUtils.isAWritableVarRef(tree.down(1), symbolTable);
            }
        }
        return false;
    }

    public static boolean isAWritableIdentVarRef(Tree tree, SymbolTable symbolTable) {
        switch (tree.opCode()) {
            case 96: {
                SymbolDecl symbolDecl = symbolTable.getSymbolDecl(ILUtils.getIdentString(tree));
                if (symbolDecl != null) {
                    return symbolDecl.isA(1) && !symbolDecl.hasModifier("constant");
                }
                return NewSymbolHolder.getAttachedVariableDecl(tree) != null;
            }
            case 4: 
            case 9: 
            case 151: {
                return ILUtils.isAWritableIdentVarRef(tree.down(1), symbolTable);
            }
        }
        return false;
    }

    public static boolean isAVarRefOrConstant(Tree tree) {
        switch (tree.opCode()) {
            case 4: 
            case 9: 
            case 10: 
            case 75: 
            case 124: 
            case 151: 
            case 183: {
                return ILUtils.isAVarRefOrConstant(tree.down(1));
            }
            case 32: {
                return ILUtils.isAVarRefOrConstant(tree.down(2));
            }
            case 20: 
            case 28: 
            case 96: 
            case 103: 
            case 111: 
            case 138: 
            case 160: 
            case 177: 
            case 180: {
                return true;
            }
        }
        return false;
    }

    public static boolean isAStringManipulation(Tree tree) {
        if (TapEnv.relatedUnit().isFortran() && tree.opCode() == 31) {
            String calledFuncName = ILUtils.getCalledNameString(tree);
            return calledFuncName != null && (calledFuncName.equals("trim") || calledFuncName.equals("adjustl") || calledFuncName.equals("adjustr"));
        }
        return false;
    }

    public static boolean isAccessDeclValue(Tree tree, String value) {
        boolean result;
        boolean bl = result = tree.opCode() == 2 && tree.down(1).opCode() == 96;
        if (result) {
            result = tree.down(1).stringValue().equals(value);
        }
        return result;
    }

    public static String getBindCValue(Tree tree, int rank) {
        Tree accessDeclTree;
        String result = null;
        if (tree.opCode() == 2) {
            result = tree.down(1).down(2).length() == 1 ? tree.down(2).down(1).stringValue() : tree.down(1).down(2).down(2).down(2).stringValue();
        } else if (tree.opCode() == 199 && (accessDeclTree = ILUtils.findAccessDecl(tree)) != null) {
            result = accessDeclTree.down(2).length() == 1 ? ILUtils.baseName(tree.down(3).down(rank)) : accessDeclTree.down(2).down(2).down(2).stringValue();
        }
        return result;
    }

    public static Tree getNamedElement(Tree listOfElements, String name) {
        Tree found = null;
        Tree[] children = listOfElements.children();
        for (int i = 0; i < children.length && found == null; ++i) {
            if (children[i].opCode() != 134 || !ILUtils.isIdent(children[i].down(1), name, true)) continue;
            found = children[i].down(2);
        }
        return found;
    }

    private static Tree findAccessDecl(Tree tree) {
        Tree result = null;
        TopDownTreeWalk i = new TopDownTreeWalk(tree);
        while (!i.atEnd() && result == null) {
            Tree currentTree = i.get();
            if (currentTree.opCode() == 2) {
                result = currentTree;
            }
            i.advance();
        }
        return result;
    }

    public static boolean instrHasSideEffect(Tree expr) {
        switch (expr.opCode()) {
            case 14: 
            case 31: 
            case 109: {
                return true;
            }
        }
        Tree[] exprSons = expr.children();
        boolean hasSideEffect = false;
        if (exprSons != null) {
            for (int i = exprSons.length - 1; !hasSideEffect && i >= 0; --i) {
                hasSideEffect = ILUtils.instrHasSideEffect(exprSons[i]);
            }
        }
        return hasSideEffect;
    }

    public static Tree findSizeofCall(Tree expression) {
        if (expression.opCode() == 176) {
            return expression;
        }
        Tree[] exprSons = expression.children();
        Tree found = null;
        if (exprSons != null) {
            for (int i = exprSons.length - 1; i >= 0 && found == null; --i) {
                found = ILUtils.findSizeofCall(exprSons[i]);
            }
        }
        return found;
    }

    public static boolean isNullOrEmptyAtom(Tree tree) {
        if (tree == null) {
            return true;
        }
        if (!tree.isAtom()) {
            return false;
        }
        String atVal = tree.stringValue();
        return atVal == null || atVal.isEmpty();
    }

    public static boolean isNullOrNone(Tree tree) {
        return tree == null || tree.opCode() == 138;
    }

    public static boolean isNullOrNoneOrStar(Tree tree) {
        return tree == null || tree.opCode() == 138 || tree.opCode() == 177;
    }

    public static boolean isNullOrNoneOrVoid(Tree tree) {
        return tree == null || tree.opCode() == 138 || tree.opCode() == 204;
    }

    public static boolean isStar(Tree tree) {
        return tree != null && tree.opCode() == 177;
    }

    public static boolean isCall(Tree tree) {
        return tree.opCode() == 31 || tree.opCode() == 14 && tree.down(2).opCode() == 31;
    }

    public static Tree getCall(Tree tree) {
        if (tree.opCode() == 31) {
            return tree;
        }
        if (tree.opCode() == 14 && tree.down(2).opCode() == 31) {
            return tree.down(2);
        }
        return null;
    }

    public static TapList<Tree> getListOfStatements(Tree tree) {
        if (tree.opCode() == 27) {
            return tree.childrenList();
        }
        return new TapList<Tree>(tree, null);
    }

    public static Tree buildSingleStatement(TapList<Tree> statements) {
        if (statements == null) {
            return ILUtils.build(138);
        }
        if (statements.tail == null) {
            return (Tree)statements.head;
        }
        return ILUtils.build(27, statements);
    }

    public static TapList<Tree> buildListIdents(TapList<String> identNames) {
        TapList<Object> hdResult;
        TapList<Object> tlResult = hdResult = new TapList<Object>(null, null);
        while (identNames != null) {
            tlResult = tlResult.placdl(ILUtils.build(96, (String)identNames.head));
            identNames = identNames.tail;
        }
        return hdResult.tail;
    }

    public static int buildIterativeLength(Tree tree, SymbolTable symbolTable) {
        int length = 1;
        switch (tree.opCode()) {
            case 71: 
            case 201: {
                Tree[] exps = tree.children();
                length = 0;
                for (int i = exps.length - 1; i >= 0 && length != -1; --i) {
                    int sublength = ILUtils.buildIterativeLength(exps[i], symbolTable);
                    length = sublength == -1 ? -1 : length + sublength;
                }
                break;
            }
            case 110: {
                length = ILUtils.buildIterativeLength(tree.down(1), symbolTable);
                if (length == -1) break;
                Tree sizeTree = ILUtils.buildSizeTree(tree.down(2).down(2), tree.down(2).down(3), tree.down(2).down(4));
                Integer iters = symbolTable.computeIntConstant(sizeTree);
                length = iters == null ? -1 : length * iters;
                break;
            }
            default: {
                WrapperTypeSpec type = symbolTable.typeOf(tree);
                TapList<ArrayDim> typeDims = type.getAllDimensions();
                while (typeDims != null && length != -1) {
                    int sublength = ((ArrayDim)typeDims.head).size();
                    length = sublength == -1 ? -1 : length * sublength;
                    typeDims = typeDims.tail;
                }
                break block0;
            }
        }
        return length;
    }

    public static boolean isNullOrEmptyList(Tree tree) {
        return tree == null || tree.isList() && tree.children().length == 0;
    }

    public static boolean isNullOrNoneOrEmptyList(Tree tree) {
        return tree == null || tree.opCode() == 138 || tree.isList() && tree.children().length == 0;
    }

    public static boolean isNotNoneNorEmpty(Tree tree) {
        int opCode = tree.opCode();
        if (opCode == 138) {
            return false;
        }
        if (tree.isList()) {
            return tree.children().length != 0;
        }
        return true;
    }

    public static boolean isNotNone(Tree tree) {
        return tree.opCode() != 138;
    }

    public static boolean isNotVoid(Tree tree) {
        return tree.opCode() != 204;
    }

    public static boolean isNotNoneNorVoid(Tree tree) {
        int opCode = tree.opCode();
        return opCode != 138 && opCode != 204;
    }

    public static boolean isZero(Tree tree) {
        return tree.opCode() == 103 && tree.intValue() == 0 || tree.opCode() == 160 && ("0.0".equals(tree.stringValue()) || "0.D0".equals(tree.stringValue()) || tree.stringValue().startsWith("0.0_"));
    }

    public static TapList<Tree> commentsToListReversed(Tree commentsTree) {
        Tree[] commentsSons;
        if (commentsTree == null) {
            return null;
        }
        TapList<Tree> result = null;
        for (Tree commentsSon : commentsSons = commentsTree.children()) {
            result = new TapList<Tree>(commentsSon, result);
        }
        return result;
    }

    public static Tree listReversedToComments(TapList<Tree> commentsListReversed) {
        if (commentsListReversed == null) {
            return null;
        }
        TapList<Tree> commentsList = TapList.nreverse(commentsListReversed);
        return ILUtils.build(37, commentsList);
    }

    public static void adoptOrAppendComments(Tree commentsTree, String commentsString, Tree commentedTree) {
        if (commentsTree != null) {
            Tree existingAnnot = (Tree)commentedTree.getAnnotation(commentsString);
            if (existingAnnot != null) {
                commentsTree = ILUtils.appendComments(existingAnnot, commentsTree);
            }
            commentedTree.setAnnotation(commentsString, commentsTree);
        }
    }

    public static TapList<Tree> copiedSonsList(Tree tree) {
        TapList<Tree> list = null;
        int nbSons = tree.length();
        Tree[] sons = tree.children();
        for (int index = nbSons - 1; index >= 0; --index) {
            list = new TapList<Tree>(sons[index].copy(), list);
        }
        return list;
    }

    public static TapList<Tree> collectCommentStrings(Tree commentsTree) {
        TapList<Object> hdResult;
        TapList<Object> tlResult = hdResult = new TapList<Object>(null, null);
        ILUtils.ccsRec(commentsTree, tlResult);
        return hdResult.tail;
    }

    public static TapList<Tree> collectCommentStrings(TapList<Tree> commentsTrees) {
        TapList<Object> hdResult;
        TapList<Object> tlResult = hdResult = new TapList<Object>(null, null);
        while (commentsTrees != null) {
            tlResult = ILUtils.ccsRec((Tree)commentsTrees.head, tlResult);
            commentsTrees = commentsTrees.tail;
        }
        return hdResult.tail;
    }

    private static TapList<Tree> ccsRec(Tree commentsTree, TapList<Tree> tlResult) {
        if (commentsTree.opCode() == 180) {
            tlResult = tlResult.placdl(ILUtils.build(180, commentsTree.stringValue()));
        } else if (commentsTree.opCode() == 156) {
            tlResult = tlResult.placdl(ILUtils.copy(commentsTree));
        } else if (commentsTree.isList()) {
            Tree[] children;
            for (Tree child : children = commentsTree.children()) {
                tlResult = ILUtils.ccsRec(child, tlResult);
            }
        }
        return tlResult;
    }

    public static Tree appendComments(Tree comments1, Tree comments2) {
        return ILUtils.appendComments1(comments1, comments2, 37);
    }

    public static void appendCommentsBlock(Tree comments1, Tree comments2) {
        ILUtils.appendComments1(comments1, comments2, 38);
    }

    private static Tree appendComments1(Tree comments1, Tree comments2, int commentsOperator) {
        if (comments2 != null) {
            if (comments2.opCode() == 180) {
                if (comments1 == null) {
                    comments2 = ILUtils.build(commentsOperator, ILUtils.copy(comments2));
                    return comments2;
                }
                comments1.addChild(comments2, comments1.length() + 1);
                return comments1;
            }
            TapList<Tree> sons = ILUtils.copiedSonsList(comments2);
            return ILUtils.appendComments(comments1, sons, 37);
        }
        return comments1;
    }

    public static Tree appendComments(Tree oldComments, TapList<Tree> newComments, int operatorCode) {
        if (oldComments == null) {
            oldComments = ILUtils.build(operatorCode, newComments);
        } else {
            int rank = oldComments.length() + 1;
            while (newComments != null) {
                oldComments.addChild((Tree)newComments.head, rank);
                ++rank;
                newComments = newComments.tail;
            }
        }
        return oldComments;
    }

    public static void setOrigTree(Tree tree, Tree origTree) {
        tree.setAnnotation("origTree", origTree);
    }

    public static void setPosition(Tree tree, int position) {
        tree.setAnnotation("position", position);
    }

    public static int getPosition(Tree tree) {
        Object positionObject = tree.getAnnotation("position");
        if (positionObject == null) {
            return 0;
        }
        return (Integer)positionObject;
    }

    public static Tree removeSourceCodeAnnot(Tree tree) {
        tree.removeAnnotation("toOtherTags");
        return tree;
    }

    public static Tree buildSizeTree(Tree from, Tree to, Tree stride) {
        Tree result;
        if (to.opCode() == 138 || to.opCode() == 177) {
            result = null;
        } else {
            int intFrom = 1;
            int intTo = 1;
            int intStride = 1;
            boolean knownIntFrom = true;
            boolean knownIntTo = true;
            boolean knownIntStride = true;
            if (from.opCode() == 138) {
                intFrom = 1;
            } else if (from.opCode() == 103) {
                intFrom = from.intValue();
            } else {
                knownIntFrom = false;
            }
            if (to.opCode() == 103) {
                intTo = to.intValue();
            } else {
                knownIntTo = false;
            }
            if (stride == null || stride.opCode() == 138) {
                intStride = 1;
            } else if (stride.opCode() == 103) {
                intStride = stride.intValue();
            } else {
                knownIntStride = false;
            }
            if (knownIntFrom) {
                if (knownIntTo) {
                    result = knownIntStride ? ILUtils.build(103, (intTo - intFrom) / intStride + 1) : ILUtils.build(3, ILUtils.build(62, ILUtils.build(103, intTo - intFrom), stride.copy()), ILUtils.build(103, 1));
                } else if (knownIntStride && intStride == 1) {
                    result = intFrom == 1 ? to.copy() : ILUtils.subTree(to.copy(), ILUtils.build(103, intFrom - 1));
                } else if (knownIntStride && intStride == -1) {
                    result = intFrom == -1 ? ILUtils.minusTree(to.copy()) : ILUtils.subTree(ILUtils.build(103, intFrom + 1), to.copy());
                } else {
                    result = intFrom == 0 ? to.copy() : ILUtils.subTree(to.copy(), ILUtils.build(103, intFrom));
                    assert (stride != null);
                    result = ILUtils.build(3, ILUtils.build(62, result, stride.copy()), ILUtils.build(103, 1));
                }
            } else if (knownIntTo) {
                if (knownIntStride && intStride == 1) {
                    result = intTo == -1 ? ILUtils.minusTree(from.copy()) : ILUtils.subTree(ILUtils.build(103, intTo + 1), from.copy());
                } else if (knownIntStride && intStride == -1) {
                    result = intTo == 1 ? from.copy() : ILUtils.subTree(from.copy(), ILUtils.build(103, intTo - 1));
                } else {
                    assert (stride != null);
                    result = intTo == 0 ? ILUtils.subTree(ILUtils.build(103, 1), ILUtils.build(62, from.copy(), stride.copy())) : ILUtils.build(3, ILUtils.build(62, ILUtils.build(182, ILUtils.build(103, intTo), from.copy()), stride.copy()), ILUtils.build(103, 1));
                }
            } else if (knownIntStride && intStride == 1) {
                result = ILUtils.addTree(ILUtils.subTree(to.copy(), from.copy()), ILUtils.build(103, 1));
            } else if (knownIntStride && intStride == -1) {
                result = ILUtils.addTree(ILUtils.subTree(from.copy(), to.copy()), ILUtils.build(103, 1));
            } else {
                assert (stride != null);
                result = ILUtils.build(3, ILUtils.build(62, ILUtils.subTree(to.copy(), from.copy()), stride.copy()), ILUtils.build(103, 1));
            }
        }
        return result;
    }

    public static Tree stripArrayAccesses(Tree expr) {
        if (expr == null) {
            return null;
        }
        switch (expr.opCode()) {
            case 9: {
                return ILUtils.stripArrayAccesses(expr.down(1));
            }
            case 75: 
            case 151: {
                return ILUtils.build(expr.opCode(), ILUtils.stripArrayAccesses(expr.down(1)), ILUtils.copy(expr.down(2)));
            }
        }
        return ILUtils.copy(expr);
    }

    public static Tree modifyRootName(Tree model, String oldName, String newName) {
        Tree result = null;
        switch (model.opCode()) {
            case 96: {
                if (model.stringValue().equals(oldName)) {
                    result = ILUtils.build(96, newName);
                    break;
                }
                result = ILUtils.copy(model);
                break;
            }
            case 9: 
            case 75: 
            case 151: {
                result = model.operator().tree();
                result.setChild(ILUtils.modifyRootName(model.down(1), oldName, newName), 1);
                result.setChild(ILUtils.copy(model.down(2)), 2);
                break;
            }
            default: {
                TapEnv.toolError("(modifyRootName) Unexpected operator: " + model.opName());
            }
        }
        assert (result != null);
        result.copyAnnotations(model);
        return result;
    }

    public static Tree replaceIdentStringOccurences(Tree tree, String identString, Tree newTree) {
        if (tree.opCode() == 96 && tree.stringValue().equals(identString)) {
            return ILUtils.copy(newTree);
        }
        if (tree.isAtom()) {
            return tree;
        }
        for (int i = tree.length() - 1; i >= 0; --i) {
            tree.setChild(ILUtils.replaceIdentStringOccurences(tree.down(i + 1), identString, newTree), i + 1);
        }
        return tree;
    }

    public static void putBackNamedArguments(Tree tree) {
        if (!tree.isAtom()) {
            for (int i = tree.length(); i > 0; --i) {
                ILUtils.putBackNamedArguments(tree.down(i));
            }
        }
        if (tree.opCode() == 31) {
            Tree[] args = ILUtils.getArguments(tree).children();
            int noneFirstRk = -1;
            for (int i = 0; noneFirstRk == -1 && i < args.length; ++i) {
                if (args[i].opCode() != 138) continue;
                noneFirstRk = i;
            }
            if (noneFirstRk != -1) {
                TapList<Tree> newArgs = null;
                for (int i = args.length - 1; i >= 0; --i) {
                    if (args[i].opCode() == 138) continue;
                    Tree newArg = ILUtils.copy(args[i]);
                    Tree sourceNameEq = (Tree)args[i].getAnnotation("sourcetree");
                    if (sourceNameEq != null && sourceNameEq.opCode() == 134) {
                        newArg.removeAnnotation("sourcetree");
                        newArg = ILUtils.build(134, ILUtils.copy(sourceNameEq.down(1)), newArg);
                    }
                    newArgs = new TapList<Tree>(newArg, newArgs);
                }
                ILUtils.setArguments(tree, ILUtils.build(71, newArgs));
            }
        }
    }

    public static boolean matches(Tree tree, Tree patternTree, TapList<TapPair<Tree, Tree>> keyTreeList) {
        TapPair<Tree, Tree> place = TapList.assqTree(patternTree, keyTreeList);
        if (place != null) {
            place.second = tree;
            return true;
        }
        boolean matches = true;
        if (tree.operator() != patternTree.operator()) {
            matches = false;
        } else if (tree.isAtom()) {
            matches = tree.equalsTree(patternTree);
        } else {
            Tree[] subPatternTrees;
            Tree[] subTrees = tree.children();
            int len = subTrees.length;
            if (len < (subPatternTrees = patternTree.children()).length) {
                matches = false;
            } else if (len > subPatternTrees.length) {
                len = subPatternTrees.length;
                matches = false;
            }
            for (int i = 0; i < len; ++i) {
                if (ILUtils.matches(subTrees[i], subPatternTrees[i], keyTreeList)) continue;
                matches = false;
            }
        }
        return matches;
    }

    public static TapPair<Tree, TapList<TapPair<Tree, Tree>>> copyWatchingSubtrees(Tree origTree, TapList<TapPair<Tree, Tree>> subTreeCopies) {
        TapList<Object> toNewKeyList = new TapList<Object>(null, null);
        Tree copiedTree = ILUtils.cwsr(origTree, subTreeCopies, toNewKeyList);
        return new TapPair<Tree, TapList<TapPair<Tree, Tree>>>(copiedTree, toNewKeyList.tail);
    }

    private static Tree cwsr(Tree origTree, TapList<TapPair<Tree, Tree>> subTreeCopies, TapList<TapPair<Tree, Tree>> toNewKeyList) {
        Tree resultTree;
        TapPair place = TapList.assq(origTree, subTreeCopies);
        if (place == null) {
            Operator operator = origTree.operator();
            if (!origTree.isAtom()) {
                resultTree = operator.tree();
                Tree[] subTrees = origTree.children();
                for (int i = subTrees.length - 1; i >= 0; --i) {
                    resultTree.setChild(ILUtils.cwsr(subTrees[i], subTreeCopies, toNewKeyList), i + 1);
                }
                if (origTree.allAnnotations() != null) {
                    resultTree.copyAnnotations(origTree);
                }
            } else {
                resultTree = ILUtils.copy(origTree);
            }
        } else {
            resultTree = place.second == null ? ILUtils.copy(origTree) : (Tree)place.second;
            toNewKeyList.placdl(new TapPair<Tree, Object>(resultTree, null));
        }
        return resultTree;
    }

    public static Tree copyWatchingEqualsSubtrees(Tree origTree, TapList<TapPair<Tree, Tree>> subTreeCopies) {
        Tree resultTree;
        TapPair<Tree, Tree> place = TapList.assqTree(origTree, subTreeCopies);
        if (place == null) {
            Operator operator = origTree.operator();
            if (!origTree.isAtom()) {
                resultTree = operator.tree();
                Tree[] subTrees = origTree.children();
                for (int i = subTrees.length - 1; i >= 0; --i) {
                    resultTree.setChild(ILUtils.copyWatchingEqualsSubtrees(subTrees[i], subTreeCopies), i + 1);
                }
                if (origTree.allAnnotations() != null) {
                    resultTree.copyAnnotations(origTree);
                }
            } else {
                resultTree = ILUtils.copy(origTree);
            }
        } else {
            resultTree = place.second == null ? ILUtils.copy(origTree) : ILUtils.copy((Tree)place.second);
        }
        return resultTree;
    }

    public static int position(Tree tree) {
        Tree aboveTree;
        for (aboveTree = tree; aboveTree != null && ILUtils.getPosition(aboveTree) == 0; aboveTree = aboveTree.parent()) {
        }
        ToInt foundPosition = new ToInt(-1);
        if (aboveTree != null) {
            ILUtils.sweepPosition(aboveTree, tree, ILUtils.getPosition(aboveTree), foundPosition);
        }
        return foundPosition.get();
    }

    private static int sweepPosition(Tree inTree, Tree searchTree, int position, ToInt foundPosition) {
        if (foundPosition.get() == -1) {
            if (inTree == searchTree) {
                foundPosition.set(position);
            } else {
                Tree[] subTrees = inTree.children();
                ++position;
                if (subTrees != null) {
                    for (Tree subTree : subTrees) {
                        position = ILUtils.sweepPosition(subTree, searchTree, position, foundPosition);
                    }
                }
                if (inTree.isList()) {
                    ++position;
                }
            }
        }
        return position;
    }

    public static Tree copy(Tree tree) {
        return tree == null ? null : tree.copy();
    }

    public static void incorporateAnnotations(Tree destTree, Tree origTree) {
        TapList destMessages;
        TapList origMessages;
        if (origTree != null && destTree != null && (origMessages = (TapList)origTree.getAnnotation("message")) != (destMessages = (TapList)destTree.getAnnotation("message"))) {
            if (destMessages == null) {
                destTree.setAnnotation("message", origMessages);
            } else {
                TapList tlDestMessages = destMessages;
                while (tlDestMessages.tail != null) {
                    tlDestMessages = tlDestMessages.tail;
                }
                tlDestMessages.tail = origMessages;
            }
        }
    }

    public static Tree turnReturnIntoAssign(Tree returnTree, String returnVarName) {
        Tree expression = returnTree.cutChild(1);
        return ILUtils.build(14, ILUtils.build(96, returnVarName), expression);
    }

    public static void resetReturnFromAssign(Tree returnTree, Tree assignTree) {
        Tree expression = assignTree.cutChild(2);
        returnTree.setChild(expression, 1);
    }

    public static void turnAssignFromInitDecl(Tree assignmentTree) {
        if (assignmentTree.getAnnotation("danglingDeclChain") != null) {
            TapEnv.toolError("Danger: forbidden nested call of turnAssignFromInitDecl()");
        } else {
            Tree parentTreeCut = assignmentTree;
            int parentRankCut = 1;
            Tree declDeclarator = assignmentTree.down(1);
            block4: while (declDeclarator != null && declDeclarator.opCode() != 96 && declDeclarator.opCode() != 11) {
                switch (declDeclarator.opCode()) {
                    case 26: 
                    case 90: 
                    case 153: {
                        parentTreeCut = declDeclarator;
                        parentRankCut = 1;
                        declDeclarator = declDeclarator.down(1);
                        continue block4;
                    }
                    case 128: {
                        parentTreeCut = declDeclarator;
                        parentRankCut = 2;
                        declDeclarator = declDeclarator.down(2);
                        continue block4;
                    }
                }
                TapEnv.toolWarning(-1, "(Peeling declarator) Unexpected operator: " + declDeclarator.opName());
                declDeclarator = null;
            }
            if (parentTreeCut != assignmentTree && declDeclarator != null) {
                declDeclarator = parentTreeCut.cutChild(parentRankCut);
                Tree danglingDeclChain = assignmentTree.cutChild(1);
                assignmentTree.setAnnotation("danglingDeclChain", danglingDeclChain);
                assignmentTree.setChild(declDeclarator, 1);
            }
        }
    }

    public static void resetAssignFromInitDecl(Tree assignmentTree) {
        Tree danglingDeclChain = (Tree)assignmentTree.getAnnotation("danglingDeclChain");
        if (danglingDeclChain != null) {
            assignmentTree.removeAnnotation("danglingDeclChain");
            Tree declDeclarator = danglingDeclChain;
            Tree parentTreeCut = null;
            int parentRankCut = -1;
            block4: while (!ILUtils.isNullOrNone(declDeclarator)) {
                switch (declDeclarator.opCode()) {
                    case 26: 
                    case 90: 
                    case 153: {
                        parentTreeCut = declDeclarator;
                        parentRankCut = 1;
                        declDeclarator = declDeclarator.down(1);
                        continue block4;
                    }
                    case 128: {
                        parentTreeCut = declDeclarator;
                        parentRankCut = 2;
                        declDeclarator = declDeclarator.down(2);
                        continue block4;
                    }
                }
                TapEnv.toolWarning(-1, "(un-Peeling declarator) Unexpected operator: " + declDeclarator.opName());
            }
            Tree leaf = assignmentTree.cutChild(1);
            assignmentTree.setChild(danglingDeclChain, 1);
            assert (parentTreeCut != null);
            parentTreeCut.setChild(leaf, parentRankCut);
        }
    }

    public static TapPair<Tree, Tree> splitDeclInit(Tree tree, boolean addSaveModifier, Unit curUnit) {
        Tree type = tree.opCode() == 199 ? ILUtils.copy(tree.down(2)) : ILUtils.copy(tree.down(1));
        Tree[] declarators = tree.opCode() == 199 ? tree.down(3).children() : tree.down(2).children();
        TapList<Tree> newAssignments = null;
        TapList<Tree> newDeclarators = null;
        Tree newVarDecl = null;
        for (int i = declarators.length - 1; i >= 0; --i) {
            if (declarators[i].opCode() == 14) {
                if (addSaveModifier && ILUtils.contains(type, 96, "save") == null) {
                    type = ILUtils.build(129, ILUtils.build(130, ILUtils.build(96, "save")), type);
                }
                newAssignments = new TapList<Tree>(ILUtils.build(14, ILUtils.copy(ILUtils.peelDeclarators(declarators[i].down(1))), ILUtils.copy(declarators[i].down(2))), newAssignments);
                if (curUnit.isC()) {
                    newDeclarators = new TapList<Tree>(ILUtils.copy(declarators[i]), newDeclarators);
                    continue;
                }
                newDeclarators = new TapList<Tree>(ILUtils.copy(declarators[i].down(1)), newDeclarators);
                continue;
            }
            if (declarators[i].opCode() == 152) {
                newAssignments = new TapList<Tree>(ILUtils.build(152, ILUtils.copy(ILUtils.peelDeclarators(declarators[i].down(1))), ILUtils.copy(declarators[i].down(2))), newAssignments);
                newDeclarators = new TapList<Tree>(ILUtils.copy(declarators[i].down(1)), newDeclarators);
                continue;
            }
            newDeclarators = new TapList<Tree>(ILUtils.copy(declarators[i]), newDeclarators);
        }
        if (newAssignments != null && newAssignments.tail != null) {
            newAssignments = new TapList<Tree>(ILUtils.build(27, newAssignments), null);
        }
        if (tree.opCode() == 199) {
            newVarDecl = ILUtils.build(tree.opCode(), ILUtils.build(130), type, ILUtils.build(54, newDeclarators));
        }
        return new TapPair<Tree, Object>(newVarDecl == null ? ILUtils.build(tree.opCode(), type, ILUtils.build(54, newDeclarators)) : newVarDecl, (newAssignments == null ? null : (Tree)newAssignments.head));
    }

    private static Tree peelDeclarators(Tree declarator) {
        switch (declarator.opCode()) {
            case 11: 
            case 90: 
            case 153: 
            case 175: {
                return ILUtils.peelDeclarators(declarator.down(1));
            }
            case 128: {
                return ILUtils.peelDeclarators(declarator.down(2));
            }
        }
        return declarator;
    }

    public static Tree buildInitAssign(Tree doTree) {
        return ILUtils.build(14, ILUtils.copy(doTree.down(1)), ILUtils.copy(doTree.down(2)));
    }

    public static TapList<Tree> usedVarsInTreeOfExps(TapList<Tree> treeOfExps, TapList<Tree> dejaVu, boolean keepTop) {
        while (treeOfExps != null) {
            Tree expression = (Tree)treeOfExps.head;
            dejaVu = ILUtils.usedVarsInExp(expression, dejaVu, keepTop);
            treeOfExps = treeOfExps.tail;
        }
        return dejaVu;
    }

    public static TapList<Tree> usedVarsInExp(Tree expression, TapList<Tree> dejaVu, boolean keepTop) {
        if (expression == null) {
            return dejaVu;
        }
        switch (expression.opCode()) {
            case 4: {
                return ILUtils.usedVarsInExp(expression.down(1), dejaVu, false);
            }
            case 75: {
                if (keepTop) {
                    dejaVu = ILUtils.addTreeInList(expression, dejaVu);
                }
                return ILUtils.usedVarsInExp(expression.down(1), dejaVu, false);
            }
            case 151: {
                if (keepTop) {
                    dejaVu = ILUtils.addTreeInList(expression, dejaVu);
                }
                dejaVu = ILUtils.usedVarsInExp(expression.down(1), dejaVu, true);
                dejaVu = ILUtils.usedVarsInExp(expression.down(2), dejaVu, true);
                return dejaVu;
            }
            case 9: {
                if (keepTop) {
                    dejaVu = ILUtils.addTreeInList(expression, dejaVu);
                }
                dejaVu = ILUtils.usedVarsInExp(expression.down(1), dejaVu, false);
                dejaVu = ILUtils.usedVarsInExp(expression.down(2), dejaVu, true);
                return dejaVu;
            }
            case 96: {
                if (keepTop) {
                    dejaVu = ILUtils.addTreeInList(expression, dejaVu);
                }
                return dejaVu;
            }
            case 31: {
                dejaVu = ILUtils.usedVarsInExp(ILUtils.getObject(expression), dejaVu, true);
                return ILUtils.usedVarsInExp(ILUtils.getArguments(expression), dejaVu, true);
            }
            case 14: 
            case 152: {
                dejaVu = ILUtils.usedVarsInExp(expression.down(1), dejaVu, false);
                return ILUtils.usedVarsInExp(expression.down(2), dejaVu, true);
            }
            case 10: 
            case 71: 
            case 181: {
                Tree[] exps;
                for (Tree exp : exps = expression.children()) {
                    dejaVu = ILUtils.usedVarsInExp(exp, dejaVu, keepTop);
                }
                return dejaVu;
            }
            case 27: 
            case 54: 
            case 60: {
                Tree[] exps;
                for (Tree exp : exps = expression.children()) {
                    dejaVu = ILUtils.usedVarsInExp(exp, dejaVu, true);
                }
                return dejaVu;
            }
            case 47: 
            case 199: {
                return ILUtils.usedVarsInExp(expression.down(3), dejaVu, true);
            }
            case 5: 
            case 52: 
            case 90: 
            case 124: 
            case 139: 
            case 140: 
            case 153: 
            case 175: 
            case 176: 
            case 184: 
            case 205: {
                return ILUtils.usedVarsInExp(expression.down(1), dejaVu, true);
            }
            case 11: {
                dejaVu = ILUtils.usedVarsInExp(expression.down(2), dejaVu, true);
                if (keepTop) {
                    dejaVu = ILUtils.addTreeInList(expression, dejaVu);
                }
                return dejaVu;
            }
            case 17: {
                dejaVu = ILUtils.usedVarsInExp(expression.down(1), dejaVu, true);
                return ILUtils.usedVarsInExp(expression.down(3), dejaVu, true);
            }
            case 12: 
            case 98: 
            case 99: {
                dejaVu = ILUtils.usedVarsInExp(expression.down(1), dejaVu, true);
                dejaVu = ILUtils.usedVarsInExp(expression.down(2), dejaVu, true);
                return ILUtils.usedVarsInExp(expression.down(3), dejaVu, true);
            }
            case 110: {
                return ILUtils.usedVarsInExp(expression.down(1), dejaVu, keepTop);
            }
            case 32: 
            case 194: {
                return ILUtils.usedVarsInExp(expression.down(2), dejaVu, true);
            }
            case 121: {
                return ILUtils.usedVarsInExp(expression.down(4), dejaVu, true);
            }
            case 64: {
                dejaVu = ILUtils.usedVarsInExp(expression.down(2), dejaVu, true);
                dejaVu = ILUtils.usedVarsInExp(expression.down(3), dejaVu, true);
                return ILUtils.usedVarsInExp(expression.down(4), dejaVu, true);
            }
            case 3: 
            case 6: 
            case 18: 
            case 22: 
            case 24: 
            case 42: 
            case 43: 
            case 44: 
            case 59: 
            case 62: 
            case 68: 
            case 92: 
            case 95: 
            case 115: 
            case 116: 
            case 122: 
            case 126: 
            case 133: 
            case 134: 
            case 137: 
            case 143: 
            case 155: 
            case 168: 
            case 169: 
            case 182: 
            case 207: {
                dejaVu = ILUtils.usedVarsInExp(expression.down(1), dejaVu, true);
                return ILUtils.usedVarsInExp(expression.down(2), dejaVu, true);
            }
            case 2: 
            case 13: 
            case 15: 
            case 20: 
            case 28: 
            case 29: 
            case 30: 
            case 35: 
            case 39: 
            case 40: 
            case 41: 
            case 45: 
            case 49: 
            case 51: 
            case 67: 
            case 69: 
            case 74: 
            case 78: 
            case 91: 
            case 94: 
            case 101: 
            case 103: 
            case 104: 
            case 106: 
            case 108: 
            case 109: 
            case 111: 
            case 118: 
            case 129: 
            case 135: 
            case 138: 
            case 154: 
            case 160: 
            case 161: 
            case 171: 
            case 177: 
            case 179: 
            case 180: 
            case 192: 
            case 195: 
            case 197: 
            case 202: 
            case 204: {
                return dejaVu;
            }
        }
        TapEnv.toolWarning(-1, "(Variables used in expression) Unexpected operator: " + expression.opName());
        return dejaVu;
    }

    public static TapList<Tree> usedVarsInDiffExp(Tree expression, TapList<Tree> primR, TapList<Tree> toDiffR, boolean keepTop) {
        if (expression == null) {
            return primR;
        }
        switch (expression.opCode()) {
            case 4: {
                return ILUtils.usedVarsInDiffExp(expression.down(1), primR, toDiffR, false);
            }
            case 75: {
                if (keepTop) {
                    primR = ILUtils.addTreeOrDiffTree(expression, primR, toDiffR);
                }
                return ILUtils.usedVarsInDiffExp(expression.down(1), primR, toDiffR, false);
            }
            case 151: {
                if (keepTop) {
                    primR = ILUtils.addTreeOrDiffTree(expression, primR, toDiffR);
                }
                primR = ILUtils.usedVarsInDiffExp(expression.down(1), primR, toDiffR, true);
                primR = ILUtils.usedVarsInDiffExp(expression.down(2), primR, null, true);
                return primR;
            }
            case 9: {
                if (keepTop) {
                    primR = ILUtils.addTreeOrDiffTree(expression, primR, toDiffR);
                }
                primR = ILUtils.usedVarsInDiffExp(expression.down(1), primR, null, false);
                primR = ILUtils.usedVarsInDiffExp(expression.down(2), primR, null, true);
                return primR;
            }
            case 96: {
                if (keepTop) {
                    primR = ILUtils.addTreeOrDiffTree(expression, primR, toDiffR);
                }
                return primR;
            }
            case 31: {
                primR = ILUtils.usedVarsInDiffExp(ILUtils.getObject(expression), primR, toDiffR, true);
                return ILUtils.usedVarsInDiffExp(ILUtils.getArguments(expression), primR, toDiffR, true);
            }
            case 14: 
            case 152: {
                primR = ILUtils.usedVarsInDiffExp(expression.down(1), primR, toDiffR, false);
                return ILUtils.usedVarsInDiffExp(expression.down(2), primR, toDiffR, true);
            }
            case 10: 
            case 71: 
            case 181: {
                Tree[] exps;
                for (Tree exp : exps = expression.children()) {
                    primR = ILUtils.usedVarsInDiffExp(exp, primR, toDiffR, keepTop);
                }
                return primR;
            }
            case 27: 
            case 54: 
            case 60: {
                Tree[] exps;
                for (Tree exp : exps = expression.children()) {
                    primR = ILUtils.usedVarsInDiffExp(exp, primR, toDiffR, true);
                }
                return primR;
            }
            case 47: 
            case 199: {
                return ILUtils.usedVarsInDiffExp(expression.down(3), primR, toDiffR, true);
            }
            case 5: 
            case 52: 
            case 90: 
            case 124: 
            case 139: 
            case 140: 
            case 153: 
            case 175: 
            case 176: 
            case 184: 
            case 205: {
                return ILUtils.usedVarsInDiffExp(expression.down(1), primR, null, true);
            }
            case 11: {
                primR = ILUtils.usedVarsInDiffExp(expression.down(2), primR, null, true);
                if (keepTop) {
                    primR = ILUtils.addTreeOrDiffTree(expression, primR, toDiffR);
                }
                return primR;
            }
            case 17: {
                primR = ILUtils.usedVarsInDiffExp(expression.down(1), primR, toDiffR, true);
                return ILUtils.usedVarsInDiffExp(expression.down(3), primR, toDiffR, true);
            }
            case 12: 
            case 98: 
            case 99: {
                primR = ILUtils.usedVarsInDiffExp(expression.down(1), primR, toDiffR, true);
                primR = ILUtils.usedVarsInDiffExp(expression.down(2), primR, toDiffR, true);
                return ILUtils.usedVarsInDiffExp(expression.down(3), primR, toDiffR, true);
            }
            case 110: {
                return ILUtils.usedVarsInDiffExp(expression.down(1), primR, toDiffR, keepTop);
            }
            case 32: 
            case 194: {
                return ILUtils.usedVarsInDiffExp(expression.down(2), primR, toDiffR, true);
            }
            case 121: {
                return ILUtils.usedVarsInDiffExp(expression.down(4), primR, toDiffR, true);
            }
            case 64: {
                primR = ILUtils.usedVarsInDiffExp(expression.down(2), primR, toDiffR, true);
                primR = ILUtils.usedVarsInDiffExp(expression.down(3), primR, toDiffR, true);
                return ILUtils.usedVarsInDiffExp(expression.down(4), primR, toDiffR, true);
            }
            case 3: 
            case 6: 
            case 18: 
            case 22: 
            case 24: 
            case 42: 
            case 43: 
            case 44: 
            case 59: 
            case 62: 
            case 68: 
            case 92: 
            case 95: 
            case 115: 
            case 116: 
            case 122: 
            case 126: 
            case 133: 
            case 134: 
            case 137: 
            case 143: 
            case 155: 
            case 168: 
            case 169: 
            case 182: 
            case 207: {
                primR = ILUtils.usedVarsInDiffExp(expression.down(1), primR, toDiffR, true);
                return ILUtils.usedVarsInDiffExp(expression.down(2), primR, toDiffR, true);
            }
            case 2: 
            case 13: 
            case 15: 
            case 20: 
            case 28: 
            case 29: 
            case 30: 
            case 35: 
            case 39: 
            case 40: 
            case 41: 
            case 45: 
            case 49: 
            case 51: 
            case 67: 
            case 69: 
            case 74: 
            case 78: 
            case 91: 
            case 94: 
            case 101: 
            case 103: 
            case 104: 
            case 106: 
            case 108: 
            case 109: 
            case 111: 
            case 118: 
            case 129: 
            case 135: 
            case 138: 
            case 154: 
            case 160: 
            case 161: 
            case 171: 
            case 177: 
            case 179: 
            case 180: 
            case 192: 
            case 195: 
            case 197: 
            case 202: 
            case 204: {
                return primR;
            }
        }
        TapEnv.toolWarning(-1, "(Variables used in diff expression) Unexpected operator: " + expression.opName());
        return primR;
    }

    private static TapList<Tree> addTreeOrDiffTree(Tree expr, TapList<Tree> primR, TapList<Tree> toDiffR) {
        if (toDiffR != null) {
            toDiffR.tail = ILUtils.addTreeInList(expr, toDiffR.tail);
        } else {
            primR = ILUtils.addTreeInList(expr, primR);
        }
        return primR;
    }

    public static boolean equalValues(Tree tree1, Tree tree2, Instruction instr1, Instruction instr2) {
        switch (tree1.opCode()) {
            case 9: 
            case 75: 
            case 96: 
            case 151: {
                return ILUtils.eqOrDisjointRef(tree1, tree2, instr1, instr2) == 1;
            }
        }
        boolean equals = false;
        if (tree1.operator() == tree2.operator()) {
            if (!tree1.isAtom()) {
                Tree[] subTrees1 = tree1.children();
                Tree[] subTrees2 = tree2.children();
                boolean bl = equals = tree1.length() == tree2.length();
                if (equals) {
                    for (int i = subTrees1.length - 1; i >= 0; --i) {
                        if (ILUtils.equalValues(subTrees1[i], subTrees2[i], instr1, instr2)) continue;
                        equals = false;
                    }
                }
            } else {
                equals = tree1.equalsTree(tree2);
            }
        }
        return equals;
    }

    public static int eqOrDisjointRef(Tree tree1, Tree tree2, Instruction instr1, Instruction instr2) {
        switch (tree1.opCode()) {
            case 96: {
                if (tree2.opCode() == 96 && ILUtils.getIdentString(tree1).equals(ILUtils.getIdentString(tree2))) {
                    if (NewSymbolHolder.getNewSymbolHolder(tree1) == NewSymbolHolder.getNewSymbolHolder(tree2)) {
                        return 1;
                    }
                    return -1;
                }
                if (tree2.opCode() == 9) {
                    return ILUtils.eqOrDisjointRefIdentArray(tree1, tree2, instr1, instr2);
                }
                return 0;
            }
            case 9: {
                if (tree2.opCode() == 96) {
                    return ILUtils.eqOrDisjointRefIdentArray(tree2, tree1, instr1, instr2);
                }
                if (tree2.opCode() != 9 || tree1.down(2).children().length != tree2.down(2).children().length) {
                    return 0;
                }
                int eqOrDisjointBase = ILUtils.eqOrDisjointRef(tree1.down(1), tree2.down(1), instr1, instr2);
                if (eqOrDisjointBase == 1) {
                    Tree[] indices1 = tree1.down(2).children();
                    Tree[] indices2 = tree2.down(2).children();
                    int totalIndexComparison = 1;
                    for (int i = indices1.length - 1; i >= 0 && totalIndexComparison != -1; --i) {
                        int eqOrDisjointIndex = ILUtils.eqOrDisjointExprs(indices1[i], indices2[i]);
                        if (eqOrDisjointIndex == -1) {
                            totalIndexComparison = -1;
                            continue;
                        }
                        if (eqOrDisjointIndex != 0) continue;
                        totalIndexComparison = 0;
                    }
                    return totalIndexComparison;
                }
                if (eqOrDisjointBase == -1) {
                    return -1;
                }
                return 0;
            }
            case 75: {
                if (tree2.opCode() != 75) {
                    return 0;
                }
                int eqOrDisjointBase = ILUtils.eqOrDisjointRef(tree1.down(1), tree2.down(1), instr1, instr2);
                if (eqOrDisjointBase == 1) {
                    if (ILUtils.getIdentString(tree1.down(2)).equals(ILUtils.getIdentString(tree2.down(2)))) {
                        return 1;
                    }
                    return -1;
                }
                if (eqOrDisjointBase == -1) {
                    return -1;
                }
                if (ILUtils.getIdentString(tree1.down(2)).equals(ILUtils.getIdentString(tree2.down(2)))) {
                    return 0;
                }
                return -1;
            }
            case 151: {
                if (tree2.opCode() != 151) {
                    return 0;
                }
                if (instr1 == instr2 && ILUtils.eqOrDisjointRef(tree1.down(1), tree2.down(1), instr1, instr2) == 1) {
                    return ILUtils.eqOrDisjointExprs(tree1.down(2), tree2.down(2));
                }
                return 0;
            }
        }
        return 0;
    }

    private static int eqOrDisjointExprs(Tree expr1, Tree expr2) {
        if (expr1 != null && expr1.opCode() == 138 && expr2 != null && expr2.opCode() == 138) {
            return 1;
        }
        Tree diffExpr = ILUtils.subTree(expr1, expr2);
        if (ILUtils.evalsToZero(diffExpr)) {
            return 1;
        }
        if (diffExpr.opCode() == 103) {
            return -1;
        }
        return 0;
    }

    private static int eqOrDisjointRefIdentArray(Tree identtree1, Tree arraytree2, Instruction instr1, Instruction instr2) {
        int result = 0;
        if (instr1 != null && instr2 != null && (result = ILUtils.eqOrDisjointRef(identtree1, arraytree2.down(1), instr1, instr2)) == 1 && !instr1.block.symbolTable.typeOf(identtree1).equalsCompilDep(instr2.block.symbolTable.typeOf(arraytree2))) {
            result = 0;
        }
        return result;
    }

    public static TapList<Tree> addTreeInList(Tree tree, TapList<Tree> list) {
        if (tree == null || TapList.containsTree(list, tree)) {
            return list;
        }
        return new TapList<Tree>(tree, list);
    }

    public static TapList<Tree> addListTreeInList(TapList<Tree> listTree, TapList<Tree> list) {
        while (listTree != null) {
            list = ILUtils.addTreeInList((Tree)listTree.head, list);
            listTree = listTree.tail;
        }
        return list;
    }

    public static Tree buildDimColon(int minIndex, Tree dimSize) {
        if (minIndex != 1) {
            dimSize = minIndex <= 0 ? ILUtils.subTree(dimSize, ILUtils.build(103, 1 - minIndex)) : ILUtils.addTree(dimSize, ILUtils.build(103, minIndex - 1));
        }
        return ILUtils.build(59, ILUtils.build(103, minIndex), dimSize);
    }

    public static Tree reverseArrayComponentOrder(Tree tree) {
        Tree result = tree.operator().tree();
        for (int i = 0; i < tree.length(); ++i) {
            result.addChild(ILUtils.copy(tree.down(i + 1)), 1);
        }
        return result;
    }

    private static void changeOrAdoptSon(Tree father, Tree son, int rank, int sonsNb) {
        if (son == null) {
            son = ILLangOps.ops(138).tree();
        }
        if (rank <= sonsNb) {
            father.setChild(son, rank);
        } else {
            father.addChild(son, rank);
        }
    }

    public static TapList<Tree> arrayTripletsInside(Tree tree) {
        switch (tree.opCode()) {
            case 9: {
                TapList<Tree> result = null;
                Tree[] sons = tree.down(2).children();
                for (int i = sons.length - 1; i >= 0; --i) {
                    result = TapList.append(ILUtils.arrayTripletsInside(sons[i]), result);
                }
                return result;
            }
            case 12: {
                return new TapList<Tree>(tree, null);
            }
        }
        return null;
    }

    public static boolean containsArrayTriplet(Tree tree) {
        boolean result = false;
        TopDownTreeWalk i = new TopDownTreeWalk(tree);
        while (!i.atEnd() && !result) {
            Tree currentTree = i.get();
            result = ILUtils.arrayAccessContainsArrayTriplet(currentTree);
            i.advance();
        }
        return result;
    }

    private static boolean arrayAccessContainsArrayTriplet(Tree tree) {
        boolean result = false;
        if (tree.opCode() == 9) {
            result = ILUtils.oneIsArrayTriplet(tree.down(2));
        }
        return result;
    }

    public static boolean oneIsArrayTriplet(Tree indices) {
        Tree[] indexArray = indices.children();
        boolean foundTriplet = false;
        for (int i = indexArray.length - 1; i >= 0 && !foundTriplet; --i) {
            foundTriplet = indexArray[i].opCode() == 12;
        }
        return foundTriplet;
    }

    public static Tree findArrayTriplet(Tree tree) {
        Tree result = null;
        TopDownTreeWalk i = new TopDownTreeWalk(tree);
        while (!i.atEnd() && result == null) {
            Tree currentTree = i.get();
            if (ILUtils.arrayAccessContainsArrayTriplet(currentTree)) {
                result = currentTree;
                result = ILUtils.checkLower(result);
            }
            i.advance();
        }
        return result;
    }

    private static Tree checkLower(Tree tree) {
        assert (tree != null);
        Tree result = ILUtils.copy(tree);
        Tree sons = result.down(2);
        for (int i = 1; i <= sons.length(); ++i) {
            Tree lower;
            if (sons.down(i).opCode() != 12 || sons.down(i).down(3).opCode() != 138 || (lower = sons.down(i).down(1)).opCode() == 103 && lower.intValue() == 1 || lower.opCode() == 138) continue;
            sons.down(i).setChild(ILUtils.addTree(ILUtils.subTree(sons.down(i).down(2), sons.down(i).down(1)), ILUtils.build(103, 1)), 2);
            sons.down(i).setChild(ILUtils.build(103, 1), 1);
        }
        return result;
    }

    public static Tree keepArrayTriplet(Tree tree) {
        assert (tree != null);
        Tree result = ILUtils.copy(tree);
        for (int i = tree.length(); i > 0; --i) {
            if (tree.down(i).opCode() == 12) continue;
            result.removeChild(i);
        }
        return result;
    }

    public static Tree findDimColons(Tree tree) {
        Tree result = null;
        if (tree.opCode() == 199) {
            tree = tree.down(2);
        }
        int op = tree.opCode();
        switch (op) {
            case 129: {
                tree = tree.down(1);
                boolean found = false;
                for (int i = 1; !found && i <= tree.down(1).length(); ++i) {
                    boolean bl = found = tree.down(1).down(i).opCode() == 60;
                    if (!found) continue;
                    result = tree.down(1).down(i);
                }
                break;
            }
            case 13: {
                result = tree.down(1).isAtom() ? null : tree.down(1).down(2);
                break;
            }
            case 11: {
                result = tree.down(2);
                break;
            }
        }
        return result;
    }

    public static Tree buildArrayDeclarator(int language, Tree declTree, Tree typeTree) {
        assert (declTree != null);
        Tree result = declTree;
        if (declTree.opCode() == 11) {
            if (language == 4) {
                result = ILUtils.build(11, declTree, typeTree);
            } else {
                Tree dimColons = ILUtils.copy(typeTree);
                assert (dimColons != null);
                dimColons.addChildren(ILUtils.copiedSonsList(declTree.down(2)), -1);
                declTree.setChild(dimColons, 2);
            }
        } else {
            result = ILUtils.build(11, declTree, typeTree);
        }
        return result;
    }

    public static int findRankOfDeclarator(Tree tree, String symbol) {
        int result = 1;
        boolean found = false;
        while (result < tree.length() && !found) {
            int op = tree.down(result).opCode();
            switch (op) {
                case 96: {
                    found = tree.down(result).stringValue().equals(symbol);
                    break;
                }
                case 11: {
                    found = tree.down(result).down(1).stringValue().equals(symbol);
                    break;
                }
            }
            if (found) continue;
            ++result;
        }
        return result;
    }

    public static void reBuildNameEqArgs(Tree callTree, Tree resultTree) {
        int nbArgsResultTree = ILUtils.getArguments(resultTree).children().length;
        int nbArgsCallTree = ILUtils.getArguments(callTree).children().length;
        int nbArgs = Math.max(nbArgsResultTree, nbArgsCallTree);
        Tree callArguments = ILUtils.getArguments(callTree);
        Tree resultArguments = ILUtils.getArguments(resultTree);
        for (int j = 0; j < nbArgs; ++j) {
            Tree resultArg = resultArguments.down(j + 1);
            Tree callArg = callArguments.down(j + 1);
            if (resultArg == null || callArg == null) continue;
            if (resultArg.opCode() == 134 && callArg.opCode() != 138 && callArg.opCode() != 134) {
                Tree tmpTree = ILUtils.copy(resultArg);
                tmpTree.setChild(ILUtils.copy(callArg), 2);
                resultArguments.setChild(tmpTree, j + 1);
                continue;
            }
            if (resultArg.opCode() == 138 || callArg.opCode() == 138) continue;
            resultArguments.setChild(ILUtils.copy(callArg), j + 1);
        }
    }

    public static Tree pathFromPointerAccess(Tree expr) {
        switch (expr.opCode()) {
            case 151: {
                return ILUtils.build(151, ILUtils.build(138), ILUtils.build(138));
            }
            case 9: 
            case 75: {
                return ILUtils.build(expr.opCode(), ILUtils.pathFromPointerAccess(expr.down(1)), ILUtils.copy(expr.down(2)));
            }
        }
        return ILUtils.copy(expr);
    }

    public static TapList<Tree> reversedExprAccess(Tree expr) {
        TapList<Tree> cumulTrees = null;
        while (expr != null) {
            cumulTrees = new TapList<Tree>(expr, cumulTrees);
            int opcode = expr.opCode();
            if (opcode == 75 || opcode == 9 || opcode == 151) {
                expr = expr.down(1);
                continue;
            }
            expr = null;
        }
        return cumulTrees;
    }

    public static Tree getAllocatedRef(Tree accessTree) {
        if (accessTree == null) {
            return null;
        }
        switch (accessTree.opCode()) {
            case 5: {
                return accessTree.down(1);
            }
            case 9: 
            case 75: 
            case 151: {
                return ILUtils.getAllocatedRef(accessTree.down(1));
            }
        }
        return null;
    }

    public static TapList<Tree> reversedExprAccessFromPointerAccess(Tree expr, boolean peelAllocate) {
        TapList<Tree> cumulTrees = null;
        while (expr != null) {
            if (peelAllocate) {
                while (expr != null && expr.opCode() == 5) {
                    expr = expr.down(1);
                }
            }
            cumulTrees = new TapList<Tree>(expr, cumulTrees);
            assert (expr != null);
            int opcode = expr.opCode();
            if (opcode == 75 || opcode == 9) {
                expr = expr.down(1);
                continue;
            }
            expr = null;
        }
        return cumulTrees;
    }

    public static boolean contains(Tree listTree, String value, boolean caseSensitive) {
        boolean found = false;
        Tree[] children = listTree.children();
        for (int i = children.length - 1; i >= 0 && !found; --i) {
            if (!children[i].isStringAtom()) continue;
            found = caseSensitive ? value.equals(children[i].stringValue()) : value.equalsIgnoreCase(children[i].stringValue());
        }
        return found;
    }

    public static boolean containsFunctionDeclarator(Tree trees, String value) {
        boolean result = false;
        for (int i = 1; !result && i <= trees.length(); ++i) {
            result = trees.down(i).opCode() == 90 && trees.down(i).down(1).isAtom() && trees.down(i).down(1).stringValue().equals(value);
        }
        return result;
    }

    public static TapList<Tree> splitLongDeclaration(Tree tree) {
        TapList<Object> hdResult;
        int nbDecls = tree.down(3).length();
        if (nbDecls <= 78 || tree.down(2).opCode() == 138) {
            return null;
        }
        TapList<Object> tlResult = hdResult = new TapList<Object>(null, null);
        Tree[] origDecls = tree.down(3).children();
        int index = 0;
        while (index < nbDecls) {
            int stopAt = Math.min(nbDecls, index + 78);
            Tree[] copiedDecls = new Tree[stopAt - index];
            for (int i = 0; i < copiedDecls.length; ++i) {
                copiedDecls[i] = ILUtils.copy(origDecls[index + i]);
            }
            tlResult = tlResult.placdl(ILUtils.build(199, ILUtils.copy(tree.down(1)), ILUtils.copy(tree.down(2)), ILUtils.build(54, copiedDecls)));
            index = stopAt;
        }
        return hdResult.tail;
    }

    public static String typeName(Tree tree) {
        String result = "_";
        if (tree.opCode() == 161 || tree.opCode() == 67 || tree.opCode() == 195) {
            result = ILUtils.getIdentString(tree.down(1));
        } else if (tree.opCode() == 192 && tree.down(1).opCode() == 138) {
            result = ILUtils.typeName(tree.down(2));
        }
        return result;
    }

    public static String buildTypeName(Tree tree) {
        String result = null;
        if (tree.opCode() == 161 || tree.opCode() == 67 || tree.opCode() == 195) {
            String identString = ILUtils.getIdentString(tree.down(1));
            if (identString != null) {
                String opName = "";
                if (tree.opCode() == 161) {
                    opName = "struct ";
                } else if (tree.opCode() == 195) {
                    opName = "union ";
                } else if (tree.opCode() == 67) {
                    opName = "enum ";
                }
                result = opName + identString;
            } else {
                result = null;
            }
        } else if (tree.opCode() == 192 && tree.down(1).opCode() == 138) {
            result = ILUtils.buildTypeName(tree.down(2));
        }
        return result;
    }

    public static int getLineNumber(Tree tree) {
        Object annotValue = null;
        if (tree.opCode() == 31) {
            annotValue = ILUtils.getCalledName(tree).getAnnotation("line");
        } else if (tree.opCode() == 14) {
            annotValue = tree.down(1).getAnnotation("line");
        }
        return annotValue == null ? 0 : ILUtils.intConstantValue(annotValue);
    }

    public static boolean inInclude(Tree tree, String beginOrEnd) {
        boolean result = false;
        if (tree.opCode() == 101) {
            String line = tree.stringValue();
            if (line.equals(beginOrEnd)) {
                result = true;
            } else if (beginOrEnd.equals("tapenade begin #include") && !line.equals("tapenade end #include")) {
                result = true;
            }
        } else {
            String line = tree.down(1).stringValue();
            result = line.startsWith(beginOrEnd);
        }
        return result;
    }

    public static boolean stopInclude(Tree tree, String stopValue) {
        Tree keyTree = tree.opCode() == 101 ? tree : tree.down(1);
        return keyTree.stringValue().startsWith(stopValue);
    }

    public static Tree peelInOutConstValueModifier(Tree type) {
        if (type.opCode() != 129) {
            return type;
        }
        int toRemove = -1;
        Tree[] modifiers = type.down(1).children();
        for (int i = modifiers.length - 1; i >= 0; --i) {
            String value;
            if (modifiers[i].opCode() != 96 || !(value = modifiers[i].stringValue()).equals("in") && !value.equals("out") && !value.equals("value") && !value.equals("const") && !value.equals("constant")) continue;
            toRemove = i;
        }
        if (toRemove != -1) {
            type.down(1).removeChild(toRemove + 1);
        }
        if (type.down(1).length() == 0) {
            return type.cutChild(2);
        }
        return type;
    }

    public static Tree peelConstModifier(Tree type) {
        if (type.opCode() != 129) {
            return type;
        }
        int toRemove = -1;
        Tree[] modifiers = type.down(1).children();
        for (int i = modifiers.length - 1; i >= 0; --i) {
            String value;
            if (modifiers[i].opCode() != 96 || !(value = modifiers[i].stringValue()).equals("const") && !value.equals("constant")) continue;
            toRemove = i;
        }
        if (toRemove != -1) {
            type.down(1).removeChild(toRemove + 1);
        }
        if (type.down(1).length() == 0) {
            return type.cutChild(2);
        }
        return type;
    }

    public static void peelModifier(Tree tree, String modifier) {
        Tree typeSpec = tree.down(2);
        if (typeSpec.opCode() == 129) {
            ILUtils.peelModifierRec(typeSpec, modifier);
        }
    }

    private static void peelModifierRec(Tree typeSpec, String modifier) {
        int toRemove = -1;
        Tree[] modifiers = typeSpec.down(1).children();
        for (int i = modifiers.length - 1; i >= 0; --i) {
            String value;
            if (modifiers[i].opCode() != 96 || !(value = modifiers[i].stringValue()).equals(modifier)) continue;
            toRemove = i;
        }
        if (toRemove != -1) {
            typeSpec.down(1).removeChild(toRemove + 1);
        } else if (typeSpec.down(2).opCode() == 129) {
            ILUtils.peelModifierRec(typeSpec.down(2), modifier);
        }
    }

    public static void checkFunctionName(FunctionDecl functionDecl, SymbolTable symbolTable) {
        String functionName = functionDecl.symbol;
        Instruction instr = symbolTable.declarationsBlock.getOperatorDeclarationInstruction(functionDecl, 199, null);
        if (instr != null && instr.tree.opCode() == 199) {
            Tree declarators = instr.tree.down(3);
            boolean found = false;
            for (int i = 1; !found && i <= declarators.length(); ++i) {
                Tree decl = declarators.down(i);
                if (decl.opCode() == 96) {
                    found = decl.stringValue().equals(functionName);
                }
                if (!found) continue;
                decl.setAnnotation("isFunctionName", Boolean.TRUE);
            }
        }
    }

    public static boolean equalsInclude(String include, Tree tree) {
        boolean result = false;
        if (tree != null && tree.opCode() == 101) {
            result = include.equals(tree.stringValue());
        }
        return result;
    }

    public static Tree variableDeclaratorToVariableRef(Tree varDecl) {
        Tree result;
        switch (varDecl.opCode()) {
            case 11: {
                result = ILUtils.build(9, ILUtils.variableDeclaratorToVariableRef(varDecl.down(1)), ILUtils.build(71));
                break;
            }
            case 153: {
                result = ILUtils.build(151, ILUtils.variableDeclaratorToVariableRef(varDecl.down(1)));
                break;
            }
            default: {
                result = ILUtils.copy(varDecl);
            }
        }
        return result;
    }

    public static Tree buildArrayTripletAccess(Tree array, Tree from, Tree to, int startIndex) {
        ToInt toRank;
        Tree foundTriplet;
        boolean inMinus = false;
        if (array.opCode() == 124) {
            inMinus = true;
            array = array.cutChild(1);
        }
        if ((foundTriplet = ILUtils.getToArrayTriplet(array, toRank = new ToInt(-1))) == null) {
            array = ILUtils.build(9, array, ILUtils.build(71, to == null ? from : ILUtils.build(12, from, to)));
        } else {
            array = ILUtils.copy(array);
            Tree parent = ILUtils.getToArrayTriplet(array, toRank);
            assert (parent != null);
            Tree oldSection = parent.down(toRank.get() + 1);
            Tree newSection = ILUtils.combineSections(oldSection, from, to, startIndex);
            parent.setChild(newSection, toRank.get() + 1);
        }
        if (inMinus) {
            array = ILUtils.build(124, array);
        }
        return array;
    }

    private static Tree getToArrayTriplet(Tree ref, ToInt toRank) {
        if (ref == null) {
            return null;
        }
        switch (ref.opCode()) {
            case 9: {
                Tree[] indices = ref.down(2).children();
                Tree found = null;
                for (int i = indices.length - 1; i >= 0; --i) {
                    if (indices[i] == null || indices[i].opCode() != 12) continue;
                    if (found == null) {
                        found = ref.down(2);
                        toRank.set(i);
                        continue;
                    }
                    found = null;
                    i = -1;
                }
                return found;
            }
            case 75: 
            case 151: {
                return ILUtils.getToArrayTriplet(ref.down(1), toRank);
            }
        }
        return null;
    }

    private static Tree combineSections(Tree section, Tree from, Tree to, int startIndex) {
        Tree from1;
        Tree stride1 = section.down(3);
        if (startIndex == 1) {
            from = ILUtils.subTree(from, ILUtils.build(103, 1));
        }
        if (!ILUtils.isNullOrNone(stride1)) {
            from = ILUtils.mulTree(from, ILUtils.copy(stride1));
        }
        if (to != null) {
            if (startIndex == 1) {
                to = ILUtils.subTree(to, ILUtils.build(103, 1));
            }
            if (!ILUtils.isNullOrNone(stride1)) {
                to = ILUtils.mulTree(to, ILUtils.copy(stride1));
            }
        }
        if (ILUtils.isNullOrNone(from1 = section.down(1))) {
            from1 = ILUtils.build(103, startIndex);
        }
        Tree result = ILUtils.addTree(from1, from);
        if (to != null) {
            result = ILUtils.build(12, result, ILUtils.addTree(ILUtils.copy(from1), to), ILUtils.copy(stride1));
        }
        return result;
    }

    public static void removeTreeDeclOf(String symbol, Tree varDeclTree) {
        int foundRank = -1;
        Tree[] varDecls = varDeclTree.down(3).children();
        for (int i = varDecls.length - 1; i >= 0 && foundRank < 0; --i) {
            if (!symbol.equals(ILUtils.baseName(varDecls[i]))) continue;
            foundRank = i + 1;
        }
        if (foundRank > 0) {
            varDeclTree.down(3).removeChild(foundRank);
        }
    }

    public static boolean mayBeTransformed2Do(Tree tree) {
        boolean result = false;
        String indexName = null;
        Tree strideTree = null;
        if (tree.down(1).opCode() == 14) {
            boolean bl = result = tree.down(1).down(1).opCode() == 96;
            if (result) {
                indexName = tree.down(1).down(1).stringValue();
            }
        } else if (tree.down(1).opCode() == 199) {
            boolean bl = result = tree.down(1).down(3).down(1).opCode() == 14 && tree.down(1).down(3).down(1).down(1).opCode() == 96;
            if (result) {
                indexName = tree.down(1).down(3).down(1).down(1).stringValue();
            }
        }
        if (result) {
            int unaryStride = ILUtils.isUnaryPrefixOrPostfixIncrOrDecr(tree.down(3));
            if (unaryStride != 0 && ILUtils.isIdent(tree.down(3).down(2), indexName, true)) {
                strideTree = ILUtils.build(103, unaryStride == -1 ? -1 : 1);
            } else if (tree.down(3).opCode() == 14 && ILUtils.isIncr(tree.down(3), indexName)) {
                strideTree = ILUtils.getIncr(tree.down(3), indexName);
            } else {
                result = false;
            }
        }
        boolean bl = result = result && (tree.down(2).opCode() == 122 || tree.down(2).opCode() == 115 || tree.down(2).opCode() == 95 || tree.down(2).opCode() == 92);
        if (result) {
            Tree leftOfTest = tree.down(2).down(1);
            Tree rightOfTest = tree.down(2).down(2);
            if (leftOfTest.opCode() == 133 && rightOfTest.opCode() == 133 && leftOfTest.down(2).equalsTree(strideTree) && rightOfTest.down(2).equalsTree(strideTree)) {
                leftOfTest = leftOfTest.down(1);
                rightOfTest = rightOfTest.down(1);
            }
            boolean bl2 = result = ILUtils.isIdent(leftOfTest, indexName, true) || ILUtils.isIdent(rightOfTest, indexName, true);
        }
        if (tree.down(2).opCode() == 137) {
            result = ILUtils.isUnaryPrefixOrPostfixIncrOrDecr(tree.down(3)) != 0;
        }
        return result;
    }

    private static int isUnaryPrefixOrPostfixIncrOrDecr(Tree tree) {
        if (tree.opCode() == 194) {
            if (tree.down(1).stringValue().equals("++postfix") || tree.down(1).stringValue().equals("++prefix")) {
                return 1;
            }
            if (tree.down(1).stringValue().equals("--postfix") || tree.down(1).stringValue().equals("--prefix")) {
                return -1;
            }
            return 0;
        }
        return 0;
    }

    private static boolean isIncr(Tree tree, String indexName) {
        return !(!ILUtils.isIdent(tree.down(1), indexName, true) || tree.down(2).opCode() != 3 && tree.down(2).opCode() != 182 || !ILUtils.isIdent(tree.down(2).down(1), indexName, true) && !ILUtils.isIdent(tree.down(2).down(2), indexName, true));
    }

    private static Tree getIncr(Tree tree, String indexName) {
        Tree result = tree.down(2).down(1).opCode() == 96 && tree.down(2).down(1).stringValue().equals(indexName) ? tree.down(2).down(2) : tree.down(2).down(1);
        return result;
    }

    public static Tree transformFor2Do(Tree tree) {
        Tree result = ILUtils.build(64);
        boolean incr = true;
        if (tree.down(1).opCode() == 14) {
            result.setChild(ILUtils.copy(tree.down(1).down(1)), 1);
            result.setChild(ILUtils.copy(tree.down(1).down(2)), 2);
        } else if (tree.down(1).opCode() == 199) {
            Tree initDecl = tree.down(1).down(3).down(1);
            result.setChild(ILUtils.copy(initDecl.down(1)), 1);
            result.setChild(ILUtils.copy(initDecl.down(2)), 2);
        }
        String indexName = result.down(1).stringValue();
        Tree strideTree = null;
        if (tree.down(3).opCode() == 194) {
            if (tree.down(3).down(1).stringValue().equals("++postfix") || tree.down(3).down(1).stringValue().equals("++prefix")) {
                strideTree = ILUtils.build(103, 1);
                result.setChild(ILUtils.build(138), 4);
            } else if (tree.down(3).down(1).stringValue().equals("--postfix") || tree.down(3).down(1).stringValue().equals("--prefix")) {
                strideTree = ILUtils.build(103, -1);
                result.setChild(strideTree, 4);
                incr = false;
            }
        } else if (tree.down(3).opCode() == 14) {
            strideTree = ILUtils.copy(ILUtils.getIncr(tree.down(3), indexName));
            result.setChild(strideTree, 4);
        }
        Tree leftOfTest = tree.down(2).down(1);
        Tree rightOfTest = tree.down(2).down(2);
        if (tree.down(2).opCode() == 122 || tree.down(2).opCode() == 95) {
            if (leftOfTest.opCode() == 133 && rightOfTest.opCode() == 133 && strideTree != null && leftOfTest.down(2).equalsTree(strideTree) && rightOfTest.down(2).equalsTree(strideTree)) {
                leftOfTest = leftOfTest.down(1);
                rightOfTest = rightOfTest.down(1);
            }
            if (leftOfTest.opCode() == 96 && leftOfTest.stringValue().equals(indexName)) {
                if (incr) {
                    result.setChild(ILUtils.build(182, ILUtils.copy(rightOfTest), ILUtils.build(103, 1)), 3);
                } else {
                    result.setChild(ILUtils.build(3, ILUtils.copy(rightOfTest), ILUtils.build(103, 1)), 3);
                }
            } else if (incr) {
                result.setChild(ILUtils.build(182, ILUtils.copy(leftOfTest), ILUtils.build(103, 1)), 3);
            } else {
                result.setChild(ILUtils.build(3, ILUtils.copy(leftOfTest), ILUtils.build(103, 1)), 3);
            }
        } else if (tree.down(2).opCode() == 115 || tree.down(2).opCode() == 92) {
            if (leftOfTest.opCode() == 133 && rightOfTest.opCode() == 133 && strideTree != null && leftOfTest.down(2).equalsTree(strideTree) && rightOfTest.down(2).equalsTree(strideTree)) {
                leftOfTest = leftOfTest.down(1);
                rightOfTest = rightOfTest.down(1);
            }
            if (leftOfTest.opCode() == 96 && leftOfTest.stringValue().equals(indexName)) {
                result.setChild(ILUtils.copy(rightOfTest), 3);
            } else {
                result.setChild(ILUtils.copy(leftOfTest), 3);
            }
        } else if (tree.down(2).opCode() == 137) {
            if (leftOfTest.opCode() == 96 && leftOfTest.stringValue().equals(indexName)) {
                if (incr) {
                    result.setChild(ILUtils.build(182, ILUtils.copy(rightOfTest), ILUtils.build(103, 1)), 3);
                } else {
                    result.setChild(ILUtils.build(3, ILUtils.copy(rightOfTest), ILUtils.build(103, 1)), 3);
                }
            } else if (incr) {
                result.setChild(ILUtils.build(182, ILUtils.copy(leftOfTest), ILUtils.build(103, 1)), 3);
            } else {
                result.setChild(ILUtils.build(3, ILUtils.copy(leftOfTest), ILUtils.build(103, 1)), 3);
            }
        }
        return result;
    }

    public static Tree replaceRootWithNewRoot(Tree ref, Tree oldRoot, Tree newRoot) {
        Tree result = null;
        if (ref == null) {
            result = null;
        } else if (ref.equalsTree(oldRoot)) {
            result = newRoot;
        } else {
            switch (ref.opCode()) {
                case 9: 
                case 75: 
                case 151: {
                    result = ILUtils.build(ref.opCode(), ILUtils.replaceRootWithNewRoot(ref.down(1), oldRoot, newRoot), ILUtils.copy(ref.down(2)));
                    break;
                }
                case 5: {
                    result = ILUtils.build(5, ILUtils.replaceRootWithNewRoot(ref.down(1), oldRoot, newRoot), ILUtils.copy(ref.down(2)), ILUtils.copy(ref.down(3)), ILUtils.copy(ref.down(4)), ILUtils.copy(ref.down(5)));
                    break;
                }
                case 96: {
                    result = ILUtils.copy(ref);
                    break;
                }
                default: {
                    TapEnv.toolError("(Replace root reference): Unexpected operator: " + ref.opName());
                    result = ILUtils.copy(ref);
                }
            }
        }
        return result;
    }

    public static void replaceAllCallName(Tree tree, String oldUnitName, String newUnitName, Tree newUnitNameTree, SymbolTable symbolTable) {
        switch (tree.opCode()) {
            case 31: {
                Tree calledName = ILUtils.getCalledName(tree);
                if (calledName.opCode() == 96 && (TapEnv.associationByAddress() ? ILUtils.getIdentString(calledName).equals(oldUnitName) : symbolTable.isFunctionNamed(ILUtils.getIdentString(calledName), oldUnitName))) {
                    if (newUnitNameTree != null) {
                        tree.setChild(ILUtils.copy(newUnitNameTree), 2);
                    } else {
                        calledName.setValue(newUnitName);
                    }
                    Tree annot = null;
                    Enumeration<?> e = tree.allAnnotations();
                    if (e != null) {
                        while (e.hasMoreElements()) {
                            Object annotValue = ((TapPair)e.nextElement()).second;
                            if (!(annotValue instanceof Tree) || (annot = (Tree)annotValue).opCode() != 31 || !ILUtils.isIdent(ILUtils.getCalledName(annot), oldUnitName, true)) continue;
                            ILUtils.getCalledName(annot).setValue(newUnitName);
                        }
                    }
                }
                Tree arguments = ILUtils.getArguments(tree);
                ILUtils.replaceAllCallName(arguments, oldUnitName, newUnitName, newUnitNameTree, symbolTable);
                break;
            }
            case 14: 
            case 63: 
            case 125: 
            case 150: 
            case 190: {
                ILUtils.replaceAllCallName(tree.down(1), oldUnitName, newUnitName, newUnitNameTree, symbolTable);
                ILUtils.replaceAllCallName(tree.down(2), oldUnitName, newUnitName, newUnitNameTree, symbolTable);
                break;
            }
            case 75: {
                if (newUnitNameTree == null) break;
                ILUtils.replaceAllCallName(tree.down(1), oldUnitName, newUnitName, newUnitNameTree, symbolTable);
                break;
            }
            case 9: 
            case 151: 
            case 183: {
                if (newUnitNameTree != null) {
                    ILUtils.replaceAllCallName(tree.down(1), oldUnitName, newUnitName, newUnitNameTree, symbolTable);
                }
                ILUtils.replaceAllCallName(tree.down(2), oldUnitName, newUnitName, newUnitNameTree, symbolTable);
                break;
            }
            case 89: {
                ILUtils.replaceAllCallName(tree.down(4), oldUnitName, newUnitName, newUnitNameTree, symbolTable);
                break;
            }
            case 96: {
                if (!(TapEnv.associationByAddress() ? ILUtils.getIdentString(tree).equals(oldUnitName) : symbolTable.isFunctionNamed(ILUtils.getIdentString(tree), oldUnitName))) break;
                if (newUnitNameTree != null) {
                    Tree newFuncName = ILUtils.copy(newUnitNameTree);
                    newFuncName.setAnnotation("isFunctionName", Boolean.TRUE);
                    tree.parent().setChild(newFuncName, tree.rankInParent());
                    break;
                }
                tree.setValue(newUnitName);
                tree.setAnnotation("isFunctionName", Boolean.TRUE);
                break;
            }
            default: {
                Tree[] subTrees = tree.children();
                if (subTrees == null) break;
                for (int i = subTrees.length - 1; i >= 0; --i) {
                    ILUtils.replaceAllCallName(subTrees[i], oldUnitName, newUnitName, newUnitNameTree, symbolTable);
                }
            }
        }
    }

    public static void replaceAllIdentsNamed(Tree tree, String oldName, String newName) {
        TopDownTreeWalk i = new TopDownTreeWalk(tree);
        while (!i.atEnd()) {
            Tree currentTree = i.get();
            if (currentTree.opCode() == 96 && currentTree.stringValue().equals(oldName)) {
                currentTree.setValue(newName);
            }
            i.advance();
        }
    }

    public static void replaceUsedModule(Tree tree, String oldUnitName, Tree newUnitNameTree) {
        TopDownTreeWalk i = new TopDownTreeWalk(tree);
        while (!i.atEnd()) {
            Tree currentTree = i.get();
            if (currentTree.opCode() == 197 && currentTree.down(1).stringValue().equals(oldUnitName)) {
                currentTree.setChild(ILUtils.copy(newUnitNameTree), 1);
            }
            i.advance();
        }
    }

    public static TapList<String> getModulesFromInterfaceDecl(Tree tree) {
        TapList<String> result = null;
        int nbInterfaces = tree.down(2).length();
        for (int i = 1; i <= nbInterfaces; ++i) {
            if (tree.down(2).down(i).opCode() != 105) continue;
            Tree blockStatementTree = tree.down(2).down(i).down(1).down(6);
            for (int j = 1; j <= blockStatementTree.length(); ++j) {
                String moduleName;
                if (blockStatementTree.down(j).opCode() != 197 || (moduleName = ILUtils.getIdentString(blockStatementTree.down(j).down(1))).startsWith("#") || moduleName.equals("iso_c_binding")) continue;
                result = new TapList<String>(moduleName, result);
            }
        }
        return result;
    }

    public static void removeUsedModuleFromInterfaceDecl(Tree tree, String moduleName) {
        int nbInterfaces = tree.down(2).length();
        for (int i = 1; i <= nbInterfaces; ++i) {
            if (tree.down(2).down(i).opCode() != 105) continue;
            Tree blockStatementTree = tree.down(2).down(i).down(1).down(6);
            for (int j = blockStatementTree.length(); j >= 1; --j) {
                if (blockStatementTree.down(j).opCode() != 197 || !ILUtils.getIdentString(blockStatementTree.down(j).down(1)).equals(moduleName)) continue;
                blockStatementTree.removeChild(j);
            }
        }
    }

    public static Tree mergeUseDeclTrees(Tree newRestrict, Tree oldRestrict) {
        Tree result = newRestrict;
        if (newRestrict.opCode() == 166 && newRestrict.length() == 0) {
            result = oldRestrict;
        } else if (oldRestrict.opCode() == 166 && oldRestrict.length() == 0) {
            result = newRestrict;
        } else if (newRestrict.opCode() == 142 && oldRestrict.opCode() == 142) {
            TapList<Tree> newList = newRestrict.childrenList();
            TapList<Tree> toOldList = new TapList<Tree>(null, oldRestrict.childrenList());
            TapList<Tree> cumul = null;
            while (newList != null) {
                Tree newElem = (Tree)newList.head;
                String newName = newElem.opCode() == 165 ? newElem.down(2).stringValue() : newElem.stringValue();
                TapList<Tree> inOldList = toOldList;
                boolean found = false;
                while (!found && inOldList.tail != null) {
                    Tree oldElem = (Tree)inOldList.tail.head;
                    if (oldElem.opCode() == 96 && oldElem.stringValue().equals(newName)) {
                        cumul = new TapList<Tree>(ILUtils.copy(newElem), cumul);
                        found = true;
                        inOldList.tail = inOldList.tail.tail;
                        continue;
                    }
                    if (oldElem.opCode() == 165 && oldElem.down(1).stringValue().equals(newName)) {
                        cumul = newElem.opCode() == 165 ? new TapList<Tree>(ILUtils.build(165, ILUtils.copy(newElem.down(1)), ILUtils.copy(oldElem.down(2))), cumul) : new TapList<Tree>(ILUtils.copy(oldElem), cumul);
                        found = true;
                        inOldList.tail = inOldList.tail.tail;
                        continue;
                    }
                    inOldList = inOldList.tail;
                }
                newList = newList.tail;
            }
            result = ILUtils.build(142, TapList.nreverse(cumul));
        } else if (newRestrict.opCode() == 166 && oldRestrict.opCode() == 166 && newRestrict.down(1).opCode() == 165 && oldRestrict.down(1).opCode() == 165) {
            if (newRestrict.down(1).down(2).stringValue().equals(oldRestrict.down(1).down(1).stringValue())) {
                result = ILUtils.copy(result);
                result.down(1).setChild(ILUtils.copy(oldRestrict.down(1).down(2)), 2);
            } else {
                TapEnv.toolWarning(-1, "(Merge use declarations) Renamed declarations probably ignored: (" + ILUtils.toString(newRestrict) + ") and (" + ILUtils.toString(oldRestrict) + ')');
            }
        } else {
            TapEnv.toolWarning(-1, "(Merge use declarations) Renamed declarations probably ignored: (" + ILUtils.toString(newRestrict) + ") and (" + ILUtils.toString(oldRestrict) + ')');
        }
        return result;
    }

    public static Tree arrayTypeToArrayDeclarator(Tree tree) {
        assert (tree != null);
        Tree result = ILUtils.copy(tree);
        Tree dimColons = tree.down(2).down(2);
        result.setChild(ILUtils.copy(result.down(2).down(1)), 2);
        Tree[] declarators = tree.down(3).children();
        for (int i = 0; i < declarators.length; ++i) {
            Tree decl = ILUtils.build(11, ILUtils.copy(declarators[i]), ILUtils.copy(dimColons));
            result.down(3).setChild(decl, i + 1);
        }
        return result;
    }

    public static boolean containsArrayDeclarator(SymbolDecl varDecl, Tree tree) {
        String varName = varDecl.symbol;
        Tree[] varDecls = tree.down(2).children();
        boolean found = false;
        for (int i = 0; !found && i < varDecls.length; ++i) {
            if (varDecls[i].opCode() != 11) continue;
            String varDeclName = varDecls[i].down(1).stringValue();
            found = varDeclName.equals(varName);
        }
        return found;
    }

    public static boolean hasInitializations(Tree tree) {
        boolean found = false;
        switch (tree.opCode()) {
            case 54: {
                Tree[] sons = tree.children();
                for (int i = sons.length - 1; !found && i >= 0; --i) {
                    found = ILUtils.hasInitializations(sons[i]);
                }
                break;
            }
            case 14: 
            case 152: {
                found = true;
                break;
            }
        }
        return found;
    }

    public static boolean hasFortran90Modifiers(Tree tree) {
        boolean found = false;
        if (tree.opCode() == 129 && tree.down(1).opCode() == 130) {
            int length = tree.down(1).length();
            for (int i = 1; !found && i <= length; ++i) {
                found = ILUtils.isFortran90Modifier(tree.down(1).down(i));
            }
        }
        return found;
    }

    private static boolean isFortran90Modifier(Tree tree) {
        String value;
        boolean result = tree.opCode() == 96 ? (value = tree.stringValue()).equals("in") || value.equals("out") || value.equals("inout") : tree.opCode() == 60;
        return result;
    }

    public static String buildNameInText(Tree tree) {
        if (tree == null) {
            return "";
        }
        switch (tree.opCode()) {
            case 96: {
                return ILUtils.getIdentString(tree);
            }
            case 9: 
            case 11: {
                return ILUtils.buildNameInText(tree.down(1));
            }
            case 128: 
            case 134: {
                return ILUtils.buildNameInText(tree.down(2));
            }
            case 151: 
            case 153: {
                return "*" + ILUtils.buildNameInText(tree.down(1));
            }
            case 75: {
                return ILUtils.buildNameInText(tree.down(1)) + "%" + ILUtils.getIdentString(tree.down(2));
            }
            case 103: 
            case 160: 
            case 180: {
                return "ConstantValue";
            }
            case 124: 
            case 163: {
                return ILUtils.buildNameInIdent(tree.down(1));
            }
            case 4: {
                return "Adr" + ILUtils.buildNameInIdent(tree.down(1));
            }
        }
        TapEnv.toolError("(Building hint string): Unexpected operator: " + tree.opName() + " in " + tree);
        return ILUtils.toString(tree);
    }

    public static String buildNameInIdent(Tree tree) {
        if (tree == null) {
            return "";
        }
        switch (tree.opCode()) {
            case 96: {
                return ILUtils.getIdentString(tree);
            }
            case 9: 
            case 11: 
            case 124: 
            case 163: {
                return ILUtils.buildNameInIdent(tree.down(1));
            }
            case 128: 
            case 134: {
                return ILUtils.buildNameInIdent(tree.down(2));
            }
            case 151: 
            case 153: {
                return "Drf" + ILUtils.buildNameInIdent(tree.down(1));
            }
            case 75: {
                return ILUtils.buildNameInIdent(tree.down(1)) + "_" + ILUtils.getIdentString(tree.down(2));
            }
            case 103: 
            case 160: 
            case 180: {
                return "ConstantValue";
            }
            case 4: {
                return "Adr" + ILUtils.buildNameInIdent(tree.down(1));
            }
        }
        TapEnv.toolError("(Building hint string): Unexpected operator: " + tree.opName() + " in " + tree);
        return ILUtils.toString(tree);
    }

    public static Tree buildSizeArgument1(Tree tree, SymbolTable symbolTable) {
        if (ILUtils.isAVarRef(tree, symbolTable)) {
            switch (tree.opCode()) {
                case 4: 
                case 9: 
                case 11: 
                case 124: 
                case 151: {
                    return ILUtils.buildSizeArgument1(tree.down(1), symbolTable);
                }
            }
            return tree;
        }
        return null;
    }

    public static boolean hasATypeOperator(Tree tree) {
        int operator = tree.opCode();
        boolean result = operator == 154 || operator == 13;
        return result;
    }

    public static boolean isAFortranOverloadedOperator(Tree tree) {
        return !tree.isAtom() && tree.opCode() != 17 && tree.down(1) != null && tree.down(1).opCode() == 138;
    }

    public static String stripSpecialization(String name) {
        int index = name.indexOf("_SPEC");
        return index <= 0 ? name : name.substring(0, index);
    }

    public static Tree concatWithNull(Tree strTree) {
        return ILUtils.build(43, strTree, ILUtils.buildCall(ILUtils.build(96, "char"), ILUtils.build(71, ILUtils.build(103, 0))));
    }

    public static Tree getRemoveSchedule(Tree ompPragma) {
        Tree schedule = null;
        int rank = -1;
        if (!ILUtils.isNullOrNone(ompPragma.down(2))) {
            Tree[] clauses = ompPragma.down(2).children();
            for (int i = clauses.length - 1; rank == -1 && i >= 0; --i) {
                if (clauses[i] == null || clauses[i].opCode() != 172) continue;
                rank = i;
            }
            if (rank != -1) {
                schedule = clauses[rank];
                ompPragma.down(2).removeChild(rank + 1);
            }
        }
        return schedule;
    }

    public static boolean isStaticSchedule(Tree schedule) {
        if (schedule == null) {
            return false;
        }
        Tree[] exps = schedule.down(1).children();
        boolean hasStatic = false;
        for (int i = exps.length - 1; !hasStatic && i >= 0; --i) {
            if (!ILUtils.isIdent(exps[i], "static", false)) continue;
            hasStatic = true;
        }
        return hasStatic;
    }

    public static void addSchedule(Tree schedule, Tree ompPragma) {
        if (!ILUtils.isNullOrNone(schedule)) {
            if (ILUtils.isNullOrNone(ompPragma.down(2))) {
                ompPragma.setChild(ILUtils.build(71), 2);
            }
            ompPragma.down(2).addChild(schedule, 1);
        }
    }

    public static Tree tapenadeUtilityFunctionName(Unit diffUnit, String funcName) {
        return ILUtils.build(96, diffUnit.isFortran() ? funcName.toUpperCase() : funcName);
    }

    public static Tree cleanBoolCopy(Tree boolTree, Unit diffUnit) {
        if (boolTree == null) {
            return null;
        }
        String boolStr = ILUtils.getIdentString(boolTree);
        if (boolStr == null || boolStr.isEmpty()) {
            return null;
        }
        if (boolStr.equalsIgnoreCase("true") || boolStr.equalsIgnoreCase(".true.")) {
            return ILUtils.build(28, diffUnit.isC() ? "1" : "TRUE");
        }
        if (boolStr.equalsIgnoreCase("false") || boolStr.equalsIgnoreCase(".false.")) {
            return ILUtils.build(28, diffUnit.isC() ? "0" : "FALSE");
        }
        return ILUtils.copy(boolTree);
    }

    public static boolean evalsToZero(Tree tree) {
        if (tree == null) {
            return true;
        }
        switch (tree.opCode()) {
            case 103: {
                return tree.intValue() == 0;
            }
            case 160: {
                TapIntList toIntVal = new TapIntList(0, null);
                return ILUtils.realIsInt(tree.stringValue(), toIntVal) && toIntVal.head == 0;
            }
            case 124: {
                return ILUtils.evalsToZero(tree.down(1));
            }
        }
        return false;
    }

    public static boolean evalsToOne(Tree tree) {
        switch (tree.opCode()) {
            case 103: {
                return tree.intValue() == 1;
            }
            case 160: {
                TapIntList toIntVal = new TapIntList(0, null);
                return ILUtils.realIsInt(tree.stringValue(), toIntVal) && toIntVal.head == 1;
            }
            case 124: {
                return ILUtils.evalsToMinusOne(tree.down(1));
            }
        }
        return false;
    }

    public static Tree getOptionalDim(Tree[] srcParamExprs, SymbolTable symbolTable) {
        WrapperTypeSpec arg1type;
        Tree dimTree = null;
        for (int i = srcParamExprs.length - 1; i >= 1 && dimTree == null; --i) {
            if (srcParamExprs[i].opCode() != 134 || !srcParamExprs[i].down(1).stringValue().equals("dim")) continue;
            dimTree = srcParamExprs[i].down(2);
        }
        if (dimTree == null && srcParamExprs.length >= 2 && !TypeSpec.isA(arg1type = symbolTable.typeOf(srcParamExprs[1]), 2) && srcParamExprs[1].opCode() != 134) {
            dimTree = srcParamExprs[1];
        }
        return dimTree;
    }

    public static Tree getOptionalMask(Tree[] srcParamExprs, SymbolTable symbolTable) {
        Tree maskTree = null;
        for (int i = srcParamExprs.length - 1; i >= 1 && maskTree == null; --i) {
            if (srcParamExprs[i].opCode() != 134 || !srcParamExprs[i].down(1).stringValue().equals("mask")) continue;
            maskTree = srcParamExprs[i].down(2);
        }
        if (maskTree == null && srcParamExprs.length >= 2) {
            WrapperTypeSpec arg1type = symbolTable.typeOf(srcParamExprs[1]);
            if (TypeSpec.isA(arg1type, 2) && srcParamExprs[1].opCode() != 134) {
                maskTree = srcParamExprs[1];
            } else if (srcParamExprs.length >= 3 && srcParamExprs[2].opCode() != 134) {
                maskTree = srcParamExprs[2];
            }
        }
        return maskTree;
    }

    public static boolean evalsToMinusOne(Tree tree) {
        switch (tree.opCode()) {
            case 103: {
                return tree.intValue() == -1;
            }
            case 160: {
                TapIntList toIntVal = new TapIntList(0, null);
                return ILUtils.realIsInt(tree.stringValue(), toIntVal) && toIntVal.head == -1;
            }
            case 124: {
                return ILUtils.evalsToOne(tree.down(1));
            }
        }
        return false;
    }

    public static boolean evalsToGTZero(Tree tree) {
        switch (tree.opCode()) {
            case 103: {
                return tree.intValue() > 0;
            }
            case 160: {
                String value = tree.stringValue();
                ToBool isDouble = new ToBool(false);
                int[] digits = new int[40];
                ILUtils.parseNumericalString(value, digits, isDouble, false);
                return digits[0] > 0;
            }
        }
        return false;
    }

    public static boolean evalsToGEZero(Tree tree) {
        switch (tree.opCode()) {
            case 103: {
                return tree.intValue() >= 0;
            }
            case 160: {
                String value = tree.stringValue();
                ToBool isDouble = new ToBool(false);
                int[] digits = new int[40];
                ILUtils.parseNumericalString(value, digits, isDouble, false);
                return digits[0] >= 0;
            }
        }
        return false;
    }

    public static boolean evalsToLTZero(Tree tree) {
        switch (tree.opCode()) {
            case 103: {
                return tree.intValue() < 0;
            }
            case 160: {
                String value = tree.stringValue();
                ToBool isDouble = new ToBool(false);
                int[] digits = new int[40];
                ILUtils.parseNumericalString(value, digits, isDouble, false);
                return digits[0] < 0;
            }
        }
        return false;
    }

    protected static boolean realIsInt(String str, TapIntList toIntVal) {
        if (str != null && (str.endsWith("iF") || str.endsWith("jF"))) {
            return false;
        }
        int[] digits = new int[40];
        int power = ILUtils.parseNumericalString(str, digits, new ToBool(false), false);
        if (digits[0] == 0) {
            toIntVal.head = 0;
            return true;
        }
        if (power < 0) {
            return false;
        }
        for (int i = power + 1; i < 40; ++i) {
            if (digits[i] == 0) continue;
            return false;
        }
        if (toIntVal != null) {
            int val = 0;
            boolean negative = false;
            for (int i = 0; i <= power; ++i) {
                int d = digits[i];
                if (d < 0) {
                    negative = true;
                    d = -d;
                }
                if (i == 39 || val + 1 >= 0xCCCCCCC) {
                    i = power;
                    val = Integer.MAX_VALUE;
                    continue;
                }
                val = 10 * val + d;
            }
            if (negative) {
                val = -val;
            }
            toIntVal.head = val;
        }
        return true;
    }

    public static boolean isExpressionConstant(Tree tree) {
        switch (tree.opCode()) {
            case 103: 
            case 160: {
                return true;
            }
            case 124: {
                return ILUtils.isExpressionConstant(tree.down(1));
            }
            case 3: 
            case 62: 
            case 133: 
            case 182: {
                if (ILUtils.isExpressionConstant(tree.down(1))) {
                    return ILUtils.isExpressionConstant(tree.down(2));
                }
                return false;
            }
        }
        return false;
    }

    public static boolean isExpressionNumConstant(Tree tree) {
        switch (tree.opCode()) {
            case 103: 
            case 160: {
                return true;
            }
            case 124: {
                return ILUtils.isExpressionNumConstant(tree.down(1));
            }
        }
        return false;
    }

    public static boolean isExpressionIntConstant(Tree tree) {
        switch (tree.opCode()) {
            case 103: {
                return true;
            }
            case 124: {
                return ILUtils.isExpressionIntConstant(tree.down(1));
            }
        }
        return false;
    }

    public static int intConstantValue(Tree tree) {
        switch (tree.opCode()) {
            case 103: {
                return tree.intValue();
            }
            case 124: {
                return -ILUtils.intConstantValue(tree.down(1));
            }
        }
        TapEnv.toolError("(Value of int constant) Unexpected operator: " + tree.opName());
        return 0;
    }

    public static Tree addExpressionsNumConstants(Tree left, Tree right) {
        int leftOp = left.opCode();
        int rightOp = right.opCode();
        boolean leftIsOpposed = false;
        boolean rightIsOpposed = false;
        int leftSign = 1;
        int rightSign = 1;
        while (leftOp == 124) {
            left = left.down(1);
            leftSign = -leftSign;
            leftIsOpposed = !leftIsOpposed;
            leftOp = left.opCode();
        }
        while (rightOp == 124) {
            right = right.down(1);
            rightSign = -rightSign;
            rightIsOpposed = !rightIsOpposed;
            rightOp = right.opCode();
        }
        if (leftOp == 103 && rightOp == 103) {
            return ILUtils.build(103, leftSign * left.intValue() + rightSign * right.intValue());
        }
        String leftString = left.stringValue();
        String rightString = right.stringValue();
        return ILUtils.build(160, ILUtils.addNumericalStrings(leftString, leftIsOpposed, rightString, rightIsOpposed));
    }

    protected static String addNumericalStrings(String str1, boolean isStr1Opposed, String str2, boolean isStr2Opposed) {
        int i;
        ToBool isDouble = new ToBool(false);
        int[] digits1 = new int[40];
        int power1 = ILUtils.parseNumericalString(str1, digits1, isDouble, isStr1Opposed);
        int[] digits2 = new int[40];
        int power2 = ILUtils.parseNumericalString(str2, digits2, isDouble, isStr2Opposed);
        boolean positiveSum = ILUtils.positiveSum(digits1, power1, digits2, power2);
        if (power1 <= power2) {
            ILUtils.shiftRight(digits1, power2 - power1 + 1, str1, str2);
            ILUtils.shiftRight(digits2, 1, str1, str2);
            power1 = ++power2;
        } else {
            ILUtils.shiftRight(digits1, 1, str1, str2);
            ILUtils.shiftRight(digits2, power1 - power2 + 1, str1, str2);
            power2 = ++power1;
        }
        int carry = 0;
        for (int i2 = 39; i2 >= 0; --i2) {
            digits2[i2] = digits1[i2] + digits2[i2] + carry;
            carry = 0;
            if (positiveSum) {
                if (digits2[i2] >= 10) {
                    int n = i2;
                    digits2[n] = digits2[n] - 10;
                    ++carry;
                    continue;
                }
                if (digits2[i2] >= 0) continue;
                int n = i2;
                digits2[n] = digits2[n] + 10;
                --carry;
                continue;
            }
            if (digits2[i2] > 0) {
                int n = i2;
                digits2[n] = digits2[n] - 10;
                ++carry;
                continue;
            }
            if (digits2[i2] > -10) continue;
            int n = i2;
            digits2[n] = digits2[n] + 10;
            --carry;
        }
        String result = "";
        int lasti = -1;
        if (!positiveSum) {
            result = "-";
            for (i = 0; i < 40; ++i) {
                digits2[i] = -digits2[i];
            }
        }
        for (i = 0; i < 40; ++i) {
            if (digits2[i] == 0) continue;
            lasti = i;
        }
        if (power2 >= 0 && power2 <= 20) {
            if (lasti < power2 + 1) {
                lasti = power2 + 1;
            }
            boolean initial = true;
            for (int i3 = 0; i3 <= lasti; ++i3) {
                if (!initial || power2 <= 0 || digits2[i3] != 0) {
                    result = result + digits2[i3];
                    initial = false;
                }
                if (i3 != power2) continue;
                if (initial) {
                    result = result + '0';
                }
                result = result + '.';
            }
            if (isDouble.get()) {
                result = result + "D0";
            }
        } else {
            result = result + digits2[0] + '.';
            for (i = 1; i <= lasti; ++i) {
                result = result + digits2[i];
            }
            result = isDouble.get() ? result + 'D' + power2 : result + 'E' + power2;
        }
        return result;
    }

    private static int parseNumericalString(String str, int[] digits, ToBool isDouble, boolean takeOpposite) {
        int d;
        int strl = str.length();
        boolean isNegativePower = false;
        boolean inMantissa = true;
        boolean beforeDot = true;
        int power = 0;
        int curPower = 0;
        int epower = 0;
        for (d = 0; d < 40; ++d) {
            digits[d] = 0;
        }
        d = 0;
        for (int i = 0; i < strl; ++i) {
            char c = str.charAt(i);
            if (c >= '0' && c <= '9') {
                if (beforeDot) {
                    ++power;
                } else {
                    --curPower;
                }
                if (inMantissa) {
                    if (d == 0 && c == '0') continue;
                    digits[d] = c - 48;
                    if (d == 0) {
                        power = beforeDot ? 0 : curPower;
                    }
                    ++d;
                    continue;
                }
                epower = epower * 10 + c - 48;
                continue;
            }
            if (c == '.') {
                curPower = 0;
                beforeDot = false;
                continue;
            }
            if (c == '-') {
                if (inMantissa) {
                    takeOpposite = !takeOpposite;
                    continue;
                }
                isNegativePower = true;
                continue;
            }
            if (c == 'd' || c == 'D') {
                isDouble.set(true);
                inMantissa = false;
                beforeDot = false;
                continue;
            }
            if (c == 'e' || c == 'E') {
                inMantissa = false;
                beforeDot = false;
                continue;
            }
            if (c != '_') continue;
            beforeDot = false;
            i = strl;
        }
        if (takeOpposite) {
            for (d = 0; d < 40; ++d) {
                digits[d] = -digits[d];
            }
        }
        return isNegativePower ? power - epower : power + epower;
    }

    private static boolean positiveSum(int[] digits1, int power1, int[] digits2, int power2) {
        if (power1 > power2) {
            return digits1[0] > 0;
        }
        if (power2 > power1) {
            return digits2[0] > 0;
        }
        int d = 0;
        boolean found = false;
        while (!found && d < 40) {
            if (digits1[d] + digits2[d] != 0) {
                found = true;
                continue;
            }
            ++d;
        }
        return d >= 40 || digits1[d] + digits2[d] > 0;
    }

    private static void shiftRight(int[] digits, int offset, String str1, String str2) {
        int i;
        boolean loosePrecision = false;
        if (offset > 40) {
            offset = 40;
        }
        for (i = 40 - offset; i < 40; ++i) {
            if (digits[i] == 0) continue;
            loosePrecision = true;
        }
        if (loosePrecision) {
            TapEnv.toolError("Lost accuracy in adding " + str1 + " and " + str2);
        }
        for (i = 40 - offset - 1; i >= 0; --i) {
            digits[i + offset] = digits[i];
        }
        for (i = 0; i < offset; ++i) {
            digits[i] = 0;
        }
    }

    public static boolean isNegativeExpression(Tree tree) {
        int oper = tree.opCode();
        if (oper == 103) {
            int value = tree.intValue();
            return value < 0;
        }
        if (oper == 160) {
            String value = tree.stringValue();
            return value.charAt(0) == '-';
        }
        return oper == 124;
    }

    public static Tree buildExpressionOpposite(Tree tree) {
        Tree result = ILUtils.buildNumericalOpposite(tree);
        if (result == null) {
            return ILUtils.build(124, tree);
        }
        return result;
    }

    public static Tree buildNumericalOpposite(Tree tree) {
        int oper = tree.opCode();
        if (oper == 103) {
            int value = tree.intValue();
            return ILUtils.build(103, -value);
        }
        if (oper == 160) {
            StringBuilder valueBuf = new StringBuilder(tree.stringValue());
            if (valueBuf.charAt(0) == '-') {
                valueBuf.delete(0, 1);
            } else {
                valueBuf.insert(0, '-');
            }
            return ILUtils.build(160, valueBuf.toString());
        }
        if (oper == 124) {
            return tree.cutChild(1);
        }
        return null;
    }

    public static boolean seemsInteger(Tree exp) {
        switch (exp.opCode()) {
            case 3: 
            case 62: 
            case 133: 
            case 155: 
            case 182: {
                return ILUtils.seemsInteger(exp.down(1)) && ILUtils.seemsInteger(exp.down(2));
            }
            case 124: {
                return ILUtils.seemsInteger(exp.down(1));
            }
            case 96: 
            case 103: {
                return true;
            }
        }
        return false;
    }

    public static Tree hasDuplicableLastIndex(Tree doLoopControl, boolean exit) {
        Tree resultTree = null;
        Tree firstTree = doLoopControl.down(2);
        Tree lastTree = doLoopControl.down(3);
        Tree strideTree = doLoopControl.down(4);
        if (ILUtils.isNullOrNone(strideTree)) {
            strideTree = ILUtils.build(103, 1);
        }
        if (!(ILUtils.instrHasSideEffect(firstTree) || ILUtils.instrHasSideEffect(lastTree) || ILUtils.instrHasSideEffect(strideTree))) {
            resultTree = ILUtils.subTree(exit ? ILUtils.addTree(ILUtils.copy(lastTree), ILUtils.copy(strideTree)) : ILUtils.copy(lastTree), ILUtils.buildSmartMod(ILUtils.subTree(ILUtils.copy(lastTree), ILUtils.copy(firstTree)), ILUtils.copy(strideTree)));
        }
        return resultTree;
    }

    public static Tree mulProtectedExprs(Tree factor1, TypeSpec type1, Tree factor2, TypeSpec type2) {
        Tree result;
        Tree test2;
        if (factor1 == null || factor2 == null) {
            return null;
        }
        Tree test1 = ILUtils.isIfExpression(factor1) ? factor1.cutChild(1) : null;
        Tree tree = test2 = ILUtils.isIfExpression(factor2) ? factor2.cutChild(1) : null;
        if (test1 == null) {
            if (test2 == null) {
                result = ILUtils.mulTreeWatchComplex(factor1, type1, factor2, type2);
            } else {
                Tree fact2 = factor2.cutChild(3);
                Tree sfact2 = factor2.cutChild(2);
                Tree sfact = !ILUtils.isNullOrNone(sfact2) ? ILUtils.mulProtectedExprs(ILUtils.copy(factor1), type1, sfact2, type2) : null;
                result = ILUtils.build(99, test2, sfact, ILUtils.mulProtectedExprs(factor1, type1, fact2, type2));
            }
        } else {
            Tree fact1 = factor1.cutChild(3);
            if (test2 == null) {
                Tree sfact1 = factor1.cutChild(2);
                Tree sfact = !ILUtils.isNullOrNone(sfact1) ? ILUtils.mulProtectedExprs(sfact1, type1, ILUtils.copy(factor2), type2) : null;
                result = ILUtils.build(99, test1, sfact, ILUtils.mulProtectedExprs(fact1, type1, factor2, type2));
            } else {
                Tree fact2 = factor2.cutChild(3);
                result = ILUtils.build(99, ILUtils.build(143, test1, test2), null, ILUtils.mulProtectedExprs(fact1, type1, fact2, type2));
            }
        }
        return result;
    }

    private static Tree mulTreeWatchComplex(Tree factor1, TypeSpec type1, Tree factor2, TypeSpec type2) {
        if (factor1 == null || factor2 == null) {
            return null;
        }
        boolean isCmplx1 = ILUtils.isCallingString(factor1, "cmplx", false) || ILUtils.isCallingString(factor1, "complex", false);
        boolean zeroReal1 = false;
        boolean zeroImag1 = false;
        if (isCmplx1) {
            zeroReal1 = ILUtils.isZero(ILUtils.getArguments(factor1).down(1));
            zeroImag1 = ILUtils.isZero(ILUtils.getArguments(factor1).down(2));
        }
        boolean isCmplx2 = ILUtils.isCallingString(factor2, "cmplx", false) || ILUtils.isCallingString(factor2, "complex", false);
        boolean zeroReal2 = false;
        boolean zeroImag2 = false;
        if (isCmplx2) {
            zeroReal2 = ILUtils.isZero(ILUtils.getArguments(factor2).down(1));
            zeroImag2 = ILUtils.isZero(ILUtils.getArguments(factor2).down(2));
        }
        Tree result = null;
        if (isCmplx1 && (zeroReal1 || zeroImag1)) {
            if (!(isCmplx2 || type2 != null && type2.isComplexBase())) {
                result = zeroReal1 ? ILUtils.buildCall(ILUtils.build(96, "cmplx"), ILUtils.build(71, ILUtils.copy(ILUtils.getArguments(factor1).down(1)), ILUtils.mulTree(ILUtils.copy(ILUtils.getArguments(factor1).down(2)), factor2))) : ILUtils.buildCall(ILUtils.build(96, "cmplx"), ILUtils.build(71, ILUtils.mulTree(ILUtils.copy(ILUtils.getArguments(factor1).down(1)), factor2), ILUtils.copy(ILUtils.getArguments(factor1).down(2))));
                ILUtils.copyExtraChildren(ILUtils.getArguments(factor1), 2, ILUtils.getArguments(result), 2);
            } else if (zeroImag1) {
                result = ILUtils.mulTree(ILUtils.copy(ILUtils.getArguments(factor1).down(1)), factor2);
            }
        } else if (!(isCmplx1 || type1 != null && type1.isComplexBase())) {
            if (isCmplx2 && (zeroReal2 || zeroImag2)) {
                result = zeroReal2 ? ILUtils.buildCall(ILUtils.build(96, "cmplx"), ILUtils.build(71, ILUtils.copy(ILUtils.getArguments(factor2).down(1)), ILUtils.mulTree(factor1, ILUtils.copy(ILUtils.getArguments(factor2).down(2))))) : ILUtils.buildCall(ILUtils.build(96, "cmplx"), ILUtils.build(71, ILUtils.mulTree(factor1, ILUtils.copy(ILUtils.getArguments(factor2).down(1))), ILUtils.copy(ILUtils.getArguments(factor2).down(2))));
                ILUtils.copyExtraChildren(ILUtils.getArguments(factor2), 2, ILUtils.getArguments(result), 2);
            }
        } else if (zeroImag2) {
            result = ILUtils.mulTree(factor1, ILUtils.copy(ILUtils.getArguments(factor2).down(1)));
        }
        if (result == null) {
            result = ILUtils.mulTree(factor1, factor2);
        }
        return result;
    }

    public static Tree divProtectedExprs(Tree factor1, Tree factor2) {
        Tree result;
        Tree test2;
        if (factor1 == null || factor2 == null) {
            return null;
        }
        Tree test1 = ILUtils.isIfExpression(factor1) ? factor1.cutChild(1) : null;
        Tree tree = test2 = ILUtils.isIfExpression(factor2) ? factor2.cutChild(1) : null;
        if (test1 == null) {
            if (test2 == null) {
                result = ILUtils.divTree(factor1, factor2);
            } else {
                Tree fact2 = factor2.cutChild(3);
                Tree sfact2 = factor2.cutChild(2);
                Tree sfact = !ILUtils.isNullOrNone(sfact2) ? ILUtils.divProtectedExprs(ILUtils.copy(factor1), sfact2) : null;
                result = ILUtils.build(99, test2, sfact, ILUtils.divProtectedExprs(factor1, fact2));
            }
        } else {
            Tree fact1 = factor1.cutChild(3);
            if (test2 == null) {
                Tree sfact1 = factor1.cutChild(2);
                Tree sfact = !ILUtils.isNullOrNone(sfact1) ? ILUtils.divProtectedExprs(sfact1, ILUtils.copy(factor2)) : null;
                result = ILUtils.build(99, test1, sfact, ILUtils.divProtectedExprs(fact1, factor2));
            } else {
                Tree fact2 = factor2.cutChild(3);
                result = ILUtils.build(99, ILUtils.build(143, test1, test2), null, ILUtils.divProtectedExprs(fact1, fact2));
            }
        }
        return result;
    }

    public static Tree minusProtectedExpr(Tree factor) {
        if (ILUtils.isIfExpression(factor)) {
            Tree fact = factor.cutChild(2);
            if (!ILUtils.isNullOrNone(fact)) {
                fact = ILUtils.minusProtectedExpr(fact);
            }
            factor.setChild(fact, 2);
            fact = factor.cutChild(3);
            if (!ILUtils.isNullOrNone(fact)) {
                fact = ILUtils.minusProtectedExpr(fact);
            }
            factor.setChild(fact, 3);
            return factor;
        }
        return ILUtils.minusTree(factor);
    }

    public static Tree reducSumProtectedExpr(Tree factor, Tree maskTree) {
        Tree sumArgs;
        Tree fact1;
        boolean hasIf = ILUtils.isIfExpression(factor);
        Tree fact2 = null;
        if (hasIf) {
            fact1 = factor.cutChild(2);
            fact2 = factor.cutChild(3);
        } else {
            fact1 = factor;
        }
        if (!ILUtils.isNullOrNone(fact1)) {
            sumArgs = maskTree == null ? ILUtils.build(71, fact1) : ILUtils.build(71, fact1, ILUtils.build(134, ILUtils.build(96, "MASK"), ILUtils.copy(maskTree)));
            fact1 = ILUtils.build(31, ILUtils.build(138), ILUtils.build(96, "sum"), sumArgs);
        }
        if (!ILUtils.isNullOrNone(fact2)) {
            sumArgs = maskTree == null ? ILUtils.build(71, fact2) : ILUtils.build(71, fact2, ILUtils.build(134, ILUtils.build(96, "MASK"), ILUtils.copy(maskTree)));
            fact2 = ILUtils.build(31, ILUtils.build(138), ILUtils.build(96, "sum"), sumArgs);
        }
        if (hasIf) {
            factor.setChild(fact1, 2);
            factor.setChild(fact2, 3);
        } else {
            factor = fact1;
        }
        return factor;
    }

    public static boolean isIfExpression(Tree expr) {
        return expr != null && (expr.opCode() == 98 || expr.opCode() == 99);
    }

    public static Tree addProtectedExprs(Tree factor1, Tree factor2) {
        Tree result;
        Tree else2;
        Tree then2;
        Tree test2;
        Tree else1;
        Tree then1;
        Tree test1;
        if (factor1 == null) {
            return factor2;
        }
        if (factor2 == null) {
            return factor1;
        }
        if (ILUtils.isIfExpression(factor1)) {
            test1 = factor1.cutChild(1);
            then1 = factor1.cutChild(2);
            else1 = factor1.cutChild(3);
        } else {
            test1 = null;
            then1 = factor1;
            else1 = null;
        }
        if (ILUtils.isNullOrNone(then1)) {
            then1 = null;
        }
        if (ILUtils.isNullOrNone(else1)) {
            else1 = null;
        }
        if (ILUtils.isIfExpression(factor2)) {
            test2 = factor2.cutChild(1);
            then2 = factor2.cutChild(2);
            else2 = factor2.cutChild(3);
        } else {
            test2 = null;
            then2 = factor2;
            else2 = null;
        }
        if (ILUtils.isNullOrNone(then2)) {
            then2 = null;
        }
        if (ILUtils.isNullOrNone(else2)) {
            else2 = null;
        }
        if (test1 == null) {
            if (test2 == null) {
                result = ILUtils.addTreeWatchComplex(then1, then2);
            } else {
                Tree copyThen1 = ILUtils.copy(then1);
                result = ILUtils.build(99, ILUtils.copy(test2), ILUtils.addProtectedExprs(then1, then2), ILUtils.addProtectedExprs(copyThen1, else2));
            }
        } else if (test2 == null) {
            Tree copyThen2 = ILUtils.copy(then2);
            result = ILUtils.build(99, ILUtils.copy(test1), ILUtils.addProtectedExprs(then1, then2), ILUtils.addProtectedExprs(else1, copyThen2));
        } else {
            Tree newThen = ILUtils.testImpliesTest(test1, test2) ? ILUtils.addProtectedExprs(then1, then2) : (ILUtils.testImpliesNotTest(test1, test2) ? ILUtils.addProtectedExprs(ILUtils.copy(then1), ILUtils.copy(else2)) : ILUtils.build(99, ILUtils.copy(test2), ILUtils.addProtectedExprs(ILUtils.copy(then1), ILUtils.copy(then2)), ILUtils.addProtectedExprs(ILUtils.copy(then1), ILUtils.copy(else2))));
            Tree newElse = ILUtils.notTestImpliesTest(test1, test2) ? ILUtils.addProtectedExprs(ILUtils.copy(else1), ILUtils.copy(then2)) : (ILUtils.notTestImpliesNotTest(test1, test2) ? ILUtils.addProtectedExprs(ILUtils.copy(else1), ILUtils.copy(else2)) : ILUtils.build(99, ILUtils.copy(test2), ILUtils.addProtectedExprs(ILUtils.copy(else1), ILUtils.copy(then2)), ILUtils.addProtectedExprs(ILUtils.copy(else1), ILUtils.copy(else2))));
            result = ILUtils.build(99, ILUtils.copy(test1), newThen, newElse);
        }
        return result;
    }

    public static Tree pullProtectedArg(Tree callTree, int argRank) {
        Tree arg = ILUtils.getArguments(callTree).down(argRank);
        if (arg != null && arg.opCode() == 99 && TapEnv.relatedUnit().isFortran()) {
            arg = ILUtils.getArguments(callTree).cutChild(argRank);
            Tree test = arg.cutChild(1);
            Tree argTrue = arg.cutChild(2);
            Tree argFalse = arg.cutChild(3);
            if (!ILUtils.isNullOrNone(argTrue)) {
                Tree finalArgTrue = ILUtils.copy(callTree);
                ILUtils.getArguments(finalArgTrue).setChild(argTrue, argRank);
                argTrue = finalArgTrue;
            }
            if (!ILUtils.isNullOrNone(argFalse)) {
                Tree finalArgFalse = ILUtils.copy(callTree);
                ILUtils.getArguments(finalArgFalse).setChild(argFalse, argRank);
                argFalse = finalArgFalse;
            }
            return ILUtils.build(99, test, argTrue, argFalse);
        }
        return callTree;
    }

    private static Tree addTreeWatchComplex(Tree factor1, Tree factor2) {
        Tree result;
        if (factor1 == null) {
            return factor2;
        }
        if (factor2 == null) {
            return factor1;
        }
        boolean isCmplx1 = ILUtils.isCallingString(factor1, "cmplx", false);
        boolean isCmplx2 = ILUtils.isCallingString(factor2, "cmplx", false);
        boolean bothComplexConstructors = false;
        if (isCmplx1 && isCmplx2) {
            int i;
            bothComplexConstructors = true;
            Tree[] args1 = ILUtils.getArguments(factor1).children();
            Tree[] args2 = ILUtils.getArguments(factor2).children();
            for (i = 2; bothComplexConstructors && i < args1.length && i < args2.length; ++i) {
                bothComplexConstructors = args1[i].equalsTree(args2[i]);
            }
            if (i < args1.length || i < args2.length) {
                bothComplexConstructors = false;
            }
        }
        if (bothComplexConstructors) {
            result = ILUtils.buildCall(ILUtils.build(96, "cmplx"), ILUtils.build(71, ILUtils.addTree(ILUtils.getArguments(factor1).cutChild(1), ILUtils.getArguments(factor2).cutChild(1)), ILUtils.addTree(ILUtils.getArguments(factor1).cutChild(2), ILUtils.getArguments(factor2).cutChild(2))));
            ILUtils.copyExtraChildren(ILUtils.getArguments(factor1), 2, ILUtils.getArguments(result), 2);
        } else {
            result = ILUtils.addTree(factor1, factor2);
        }
        return result;
    }

    private static void copyExtraChildren(Tree srcTree, int srcIndex, Tree destListTree, int destIndex) {
        Tree[] srcTreeArray = srcTree.children();
        for (int i = srcTreeArray.length - 1; i >= srcIndex; --i) {
            destListTree.addChild(srcTreeArray[i], destIndex + 1);
        }
    }

    private static boolean testImpliesTest(Tree test1, Tree test2) {
        if (test2 == null || test2.equalsTree(test1)) {
            return true;
        }
        if (test1 == null) {
            return false;
        }
        if (test1.opCode() == 6) {
            return ILUtils.testImpliesTest(test1.down(1), test2) || ILUtils.testImpliesTest(test1.down(2), test2);
        }
        if (test1.opCode() == 139) {
            return ILUtils.notTestImpliesTest(test1.down(1), test2);
        }
        if (test2.opCode() == 143) {
            return ILUtils.testImpliesTest(test1, test2.down(1)) || ILUtils.testImpliesTest(test1, test2.down(2));
        }
        if (test2.opCode() == 139) {
            return ILUtils.notTestImpliesTest(test2.down(1), test1);
        }
        return false;
    }

    private static boolean notTestImpliesTest(Tree test1, Tree test2) {
        if (test1 == null) {
            return true;
        }
        if (test2 == null || test1.equalsTree(test2)) {
            return false;
        }
        if (test1.opCode() == 143) {
            return ILUtils.notTestImpliesTest(test1.down(1), test2) || ILUtils.notTestImpliesTest(test1.down(2), test2);
        }
        if (test1.opCode() == 139) {
            return ILUtils.testImpliesTest(test1.down(1), test2);
        }
        if (test2.opCode() == 143) {
            return ILUtils.notTestImpliesTest(test1, test2.down(1)) || ILUtils.notTestImpliesTest(test1, test2.down(2));
        }
        if (test2.opCode() == 139) {
            return ILUtils.testImpliesTest(test2.down(1), test1);
        }
        return false;
    }

    private static boolean testImpliesNotTest(Tree test1, Tree test2) {
        return ILUtils.notTestImpliesTest(test2, test1);
    }

    private static boolean notTestImpliesNotTest(Tree test1, Tree test2) {
        return ILUtils.testImpliesTest(test2, test1);
    }

    public static Tree incrementByProtectedExpr(int language, Tree lhs, Tree factor, boolean needAtomic) {
        if (ILUtils.isIfExpression(factor)) {
            Tree expr1 = factor.cutChild(2);
            if (ILUtils.isNullOrNone(expr1) || ILUtils.isZero(expr1)) {
                expr1 = null;
            }
            Tree expr2 = factor.cutChild(3);
            if (expr1 == null) {
                return ILUtils.build(98, ILUtils.build(139, factor.cutChild(1)), ILUtils.incrementByProtectedExpr(language, lhs, expr2, needAtomic), ILUtils.build(138));
            }
            if (ILUtils.isNullOrNone(expr2) || ILUtils.isZero(expr2)) {
                expr2 = null;
            }
            return ILUtils.build(98, factor.cutChild(1), ILUtils.incrementByProtectedExpr(language, ILUtils.copy(lhs), expr1, needAtomic), expr2 == null ? ILUtils.build(138) : ILUtils.incrementByProtectedExpr(language, lhs, expr2, needAtomic));
        }
        if (needAtomic && TapEnv.doOpenMP()) {
            return ILUtils.build(16, ILUtils.build(96, "OMP"), ILUtils.build(71, ILUtils.build(96, "update")), ILUtils.build(14, lhs, ILUtils.buildSmartAddSub(ILUtils.copy(lhs), 1, factor)));
        }
        if (needAtomic && TapEnv.relatedUnit() != null && TapEnv.relatedUnit().callGraph().hasCuda) {
            Tree assignment = ILUtils.build(14, lhs, ILUtils.buildSmartAddSub(ILUtils.copy(lhs), 1, factor));
            assignment.setAnnotation("preComments", ILUtils.build(180, "Must be atomic increment"));
            return assignment;
        }
        return ILUtils.build(14, lhs, ILUtils.buildSmartAddSub(ILUtils.copy(lhs), 1, factor));
    }

    public static Tree setToProtectedExpr(int language, Tree lhs, Tree rhs, TypeSpec assignedType) {
        if (ILUtils.isIfExpression(rhs)) {
            Tree thenExpr = rhs.cutChild(2);
            Tree elseExpr = rhs.cutChild(3);
            Tree zeroTree = assignedType != null && (assignedType.isRealOrComplexBase() || assignedType.isIntegerBase()) ? assignedType.buildConstantZero() : ILUtils.build(160, "0.0");
            if (ILUtils.isNullOrNone(thenExpr)) {
                thenExpr = ILUtils.copy(zeroTree);
            }
            if (ILUtils.isNullOrNone(elseExpr)) {
                elseExpr = ILUtils.copy(zeroTree);
            }
            if (TapEnv.isC(language)) {
                return ILUtils.build(14, lhs, ILUtils.build(99, rhs.cutChild(1), thenExpr, elseExpr));
            }
            return ILUtils.build(98, rhs.cutChild(1), ILUtils.setToProtectedExpr(language, lhs, thenExpr, assignedType), ILUtils.setToProtectedExpr(language, ILUtils.copy(lhs), elseExpr, assignedType));
        }
        return ILUtils.build(14, lhs, rhs);
    }

    public static Tree minusTree(Tree tree) {
        if (tree == null) {
            return ILUtils.build(103, -1);
        }
        if (tree.opCode() == 124) {
            return tree.cutChild(1);
        }
        if (tree.opCode() == 103) {
            return ILUtils.build(103, -tree.intValue());
        }
        return ILUtils.build(124, tree);
    }

    public static Tree addTree(Tree tree1, Tree tree2) {
        Tree result = ILUtils.buildSmartAddSub(tree1, 1, tree2);
        if (result == null) {
            return ILUtils.build(103, 0);
        }
        return result;
    }

    public static Tree subTree(Tree tree1, Tree tree2) {
        Tree result = ILUtils.buildSmartAddSub(tree1, -1, tree2);
        if (result == null) {
            return ILUtils.build(103, 0);
        }
        return result;
    }

    public static Tree mulTree(Tree tree1, Tree tree2) {
        if (tree1 == null) {
            return tree2;
        }
        return ILUtils.buildSmartMulDiv(tree1, 1, tree2);
    }

    private static Tree divTree(Tree tree1, Tree tree2) {
        if (tree2 == null) {
            return tree1;
        }
        if (tree1 == null) {
            tree1 = ILUtils.build(160, "1.D0");
        }
        return ILUtils.buildSmartMulDiv(tree1, -1, tree2);
    }

    public static Tree powerTree(Tree tree1, Tree tree2) {
        return ILUtils.build(155, tree1, tree2);
    }

    private static Tree buildSmartMod(Tree leftTree, Tree rightTree) {
        Tree result = null;
        boolean isMoreSimple = false;
        if (ILUtils.isExpressionNumConstant(rightTree)) {
            int rightSign = 1;
            if (rightTree.opCode() == 124) {
                rightTree = rightTree.down(1);
                rightSign = -1;
            }
            if (ILUtils.evalsToOne(rightTree) || ILUtils.evalsToMinusOne(rightTree)) {
                switch (rightTree.opCode()) {
                    case 160: {
                        result = PrimitiveTypeSpec.buildRealConstantZero();
                        isMoreSimple = true;
                        break;
                    }
                    case 103: {
                        result = ILUtils.build(103, 0);
                        isMoreSimple = true;
                        break;
                    }
                }
            } else if (ILUtils.isExpressionNumConstant(leftTree)) {
                int leftSign = 1;
                if (leftTree.opCode() == 124) {
                    leftTree = leftTree.down(1);
                    leftSign = -1;
                }
                if (rightTree.opCode() == 103 && leftTree.opCode() == 103) {
                    result = ILUtils.build(103, leftSign * leftTree.intValue() % (rightSign * rightTree.intValue()));
                    isMoreSimple = true;
                }
            }
        }
        if (!isMoreSimple) {
            result = ILUtils.build(126, leftTree, rightTree);
        }
        return result;
    }

    public static Tree buildSmartAddSub(Tree leftTree, int factor, Tree rightTree) {
        TapList<Object> toTerms = new TapList<Object>(null, null);
        TapIntList toFactors = new TapIntList(1, null);
        if (leftTree != null) {
            ILUtils.addTermsFrom(leftTree, 1, toTerms, toFactors);
        }
        if (rightTree != null) {
            ILUtils.addTermsFrom(rightTree, factor, toTerms, toFactors);
        }
        if (toTerms.head != null && !ILUtils.evalsToZero((Tree)toTerms.head)) {
            toTerms.newR(toTerms.head);
            toFactors.newR(1);
        }
        toTerms = toTerms.tail;
        toFactors = toFactors.tail;
        if (toTerms == null) {
            return null;
        }
        if (toFactors.head <= 0) {
            TapList inTerms = toTerms.tail;
            TapIntList inFactors = toFactors.tail;
            while (inFactors != null && inFactors.head <= 0) {
                inTerms = inTerms.tail;
                inFactors = inFactors.tail;
            }
            if (inFactors != null) {
                Tree positiveTerm = (Tree)inTerms.head;
                int positiveFactor = inFactors.head;
                inTerms.head = toTerms.head;
                inFactors.head = toFactors.head;
                toTerms.head = positiveTerm;
                toFactors.head = positiveFactor;
            }
        }
        Tree result = null;
        while (toTerms != null) {
            int repetition;
            Tree term = (Tree)toTerms.head;
            factor = toFactors.head;
            if (ILUtils.isNegativeExpression(term)) {
                factor = -factor;
                term = ILUtils.buildNumericalOpposite(term);
            }
            Tree lastDiffRef = ILUtils.getLastDiffFactor(term);
            for (int i = repetition = 1; i > 0; --i) {
                if (term.parent() != null) {
                    term = ILUtils.copy(term);
                }
                if (factor == 0) continue;
                if (result == null) {
                    if (factor == -1) {
                        result = ILUtils.buildExpressionOpposite(term);
                        continue;
                    }
                    if (factor == 1) {
                        result = term;
                        continue;
                    }
                    result = ILUtils.mulLeftmost(ILUtils.build(103, factor), term);
                    continue;
                }
                ToInt childRk = new ToInt(0);
                Tree parentOfMatch = ILUtils.findSameDiffFactor(lastDiffRef, result, childRk, true);
                result = parentOfMatch != null ? ILUtils.factorizeDiffVar(result, parentOfMatch, childRk.get(), term, factor) : (factor < -1 ? ILUtils.build(182, result, ILUtils.mulLeftmost(ILUtils.build(103, -factor), term)) : (factor == -1 ? ILUtils.build(182, result, term) : (factor == 1 ? ILUtils.build(3, result, term) : (term.opCode() == 160 && "1.0".equals(term.stringValue()) ? ILUtils.build(3, result, ILUtils.build(103, factor)) : ILUtils.build(3, result, ILUtils.mulLeftmost(ILUtils.build(103, factor), term))))));
            }
            toTerms = toTerms.tail;
            toFactors = toFactors.tail;
        }
        return result;
    }

    private static Tree getLastDiffFactor(Tree term) {
        if (ILUtils.isNullOrNone(term = ILUtils.lastFactor(term)) || !ILUtils.isAVarRef(term, null) || !ILUtils.isADiffRef(term)) {
            term = null;
        }
        return term;
    }

    private static Tree findSameDiffFactor(Tree searched, Tree expr, ToInt childRk, boolean top) {
        if (searched == null || expr == null) {
            return null;
        }
        if (top && ILUtils.sameDiffRef(searched, ILUtils.lastFactor(expr))) {
            childRk.set(0);
            return expr;
        }
        if ((expr.opCode() == 3 || expr.opCode() == 182) && ILUtils.sameDiffRef(searched, ILUtils.lastFactor(expr.down(2)))) {
            childRk.set(2);
            return expr;
        }
        if (expr.opCode() == 3 || expr.opCode() == 182 || expr.opCode() == 124) {
            if (ILUtils.sameDiffRef(searched, ILUtils.lastFactor(expr.down(1)))) {
                childRk.set(1);
                return expr;
            }
            return ILUtils.findSameDiffFactor(searched, expr.down(1), childRk, false);
        }
        return null;
    }

    private static Tree lastFactor(Tree term) {
        if (term.opCode() == 62) {
            term = term.down(1);
        }
        return term.opCode() == 133 ? term.down(2) : term;
    }

    private static boolean isADiffRef(Tree ref) {
        switch (ref.opCode()) {
            case 96: {
                return ref.getAnnotation("NewSymbolHolder") != null;
            }
            case 9: 
            case 75: 
            case 151: {
                return ILUtils.isADiffRef(ref.down(1));
            }
        }
        return false;
    }

    private static boolean sameDiffRef(Tree ref1, Tree ref2) {
        switch (ref1.opCode()) {
            case 96: {
                return ref1.equalsTree(ref2) && ref1.getAnnotation("NewSymbolHolder") == ref2.getAnnotation("NewSymbolHolder");
            }
            case 9: 
            case 75: 
            case 151: {
                return ref2.opCode() == ref1.opCode() && ref1.down(2).equalsTree(ref2.down(2)) && ILUtils.sameDiffRef(ref1.down(1), ref2.down(1));
            }
        }
        return false;
    }

    private static Tree factorizeDiffVar(Tree fullExpr, Tree parentOfMatch, int rankInParent, Tree term, int factor) {
        Tree addedCoeff;
        Tree origCoeff;
        Tree subExpr = parentOfMatch;
        if (parentOfMatch.opCode() == 3) {
            subExpr = parentOfMatch.down(rankInParent);
        } else if (parentOfMatch.opCode() == 182) {
            subExpr = parentOfMatch.down(rankInParent);
            if (rankInParent == 2) {
                factor = -factor;
            }
        } else if (parentOfMatch.opCode() == 124) {
            subExpr = parentOfMatch.down(1);
            factor = -factor;
        }
        Tree divisor = null;
        boolean subExprWasDiv = false;
        if (subExpr.opCode() == 62) {
            subExprWasDiv = true;
            divisor = subExpr.cutChild(2);
            subExpr = subExpr.cutChild(1);
        }
        Tree tree = origCoeff = subExpr.opCode() == 133 ? subExpr.cutChild(1) : ILUtils.build(160, "1.0");
        if (divisor != null) {
            origCoeff = ILUtils.build(62, origCoeff, divisor);
        }
        divisor = null;
        if (term.opCode() == 62) {
            divisor = term.cutChild(2);
            term = term.cutChild(1);
        }
        Tree tree2 = addedCoeff = term.opCode() == 133 ? term.cutChild(1) : ILUtils.build(160, "1.0");
        if (divisor != null) {
            addedCoeff = ILUtils.build(62, addedCoeff, divisor);
        }
        Tree newCoeff = ILUtils.buildSmartAddSub(origCoeff, factor, addedCoeff);
        if (subExpr.opCode() == 133 && newCoeff != null && !subExprWasDiv) {
            subExpr.setChild(newCoeff, 1);
            return fullExpr;
        }
        Tree newSubExpr = null;
        if (newCoeff != null) {
            newSubExpr = ILUtils.build(133, newCoeff, subExpr.opCode() == 133 ? subExpr.cutChild(2) : subExpr);
        }
        if (rankInParent != 0) {
            parentOfMatch.setChild(newSubExpr, rankInParent);
            return fullExpr;
        }
        return newSubExpr;
    }

    private static Tree mulLeftmost(Tree factor, Tree term) {
        switch (term.opCode()) {
            case 62: 
            case 133: {
                term.setChild(ILUtils.mulLeftmost(factor, term.cutChild(1)), 1);
                return term;
            }
        }
        return ILUtils.build(133, factor, term);
    }

    private static void addTermsFrom(Tree tree, int factor, TapList<Tree> toTerms, TapIntList toFactors) {
        switch (tree.opCode()) {
            case 3: {
                ILUtils.addTermsFrom(tree.down(1), factor, toTerms, toFactors);
                ILUtils.addTermsFrom(tree.down(2), factor, toTerms, toFactors);
                break;
            }
            case 182: {
                ILUtils.addTermsFrom(tree.down(1), factor, toTerms, toFactors);
                ILUtils.addTermsFrom(tree.down(2), -factor, toTerms, toFactors);
                break;
            }
            case 124: {
                ILUtils.addTermsFrom(tree.down(1), -factor, toTerms, toFactors);
                break;
            }
            case 133: {
                if (ILUtils.isExpressionIntConstant(tree.down(1))) {
                    ILUtils.addTermsFrom(tree.down(2), factor * ILUtils.intConstantValue(tree.down(1)), toTerms, toFactors);
                    break;
                }
                if (ILUtils.isExpressionIntConstant(tree.down(2))) {
                    ILUtils.addTermsFrom(tree.down(1), factor * ILUtils.intConstantValue(tree.down(2)), toTerms, toFactors);
                    break;
                }
                ILUtils.addOneTerm(tree, factor, toTerms, toFactors);
                break;
            }
            case 103: 
            case 160: {
                if (ILUtils.isNegativeExpression(tree)) {
                    factor = -factor;
                    tree = ILUtils.buildNumericalOpposite(tree);
                }
                assert (tree != null);
                if ((factor < -1 || factor > 1) && tree.opCode() == 160) {
                    ILUtils.addOneTerm(tree, factor, toTerms, toFactors);
                    break;
                }
                if (factor == -1 && tree.opCode() == 160) {
                    tree = ILUtils.buildNumericalOpposite(tree);
                } else if (factor != 1 && tree.opCode() == 103) {
                    tree = ILUtils.build(103, factor * tree.intValue());
                }
                factor = 1;
                if (toTerms.head == null) {
                    toTerms.head = tree;
                    break;
                }
                toTerms.head = ILUtils.addExpressionsNumConstants((Tree)toTerms.head, tree);
                break;
            }
            default: {
                ILUtils.addOneTerm(tree, factor, toTerms, toFactors);
            }
        }
    }

    private static void addOneTerm(Tree tree, int factor, TapList<Tree> toTerms, TapIntList toFactors) {
        if (!ILUtils.evalsToZero(tree)) {
            while (toTerms.tail != null && !ILUtils.equalValues((Tree)toTerms.tail.head, tree, null, null)) {
                toTerms = toTerms.tail;
                toFactors = toFactors.tail;
            }
            if (toTerms.tail == null) {
                toTerms.tail = new TapList<Tree>(tree, null);
                toFactors.tail = new TapIntList(0, null);
            }
            toFactors.tail.head += factor;
        }
    }

    public static Tree buildSmartMulDiv(Tree leftTree, int power, Tree rightTree) {
        TapList<Object> toTerms = new TapList<Object>(null, null);
        TapIntList toPowers = new TapIntList(0, null);
        ToBool positive = new ToBool(true);
        if (power == -1 && ILUtils.evalsToZero(rightTree)) {
            TapEnv.toolError("Building a division by zero!");
            return ILUtils.build(62, leftTree, PrimitiveTypeSpec.buildRealConstantZero());
        }
        if (ILUtils.evalsToZero(leftTree) || ILUtils.evalsToZero(rightTree)) {
            return PrimitiveTypeSpec.buildRealConstantZero();
        }
        ILUtils.mulTermsFrom(leftTree, 1, toTerms, toPowers, positive);
        ILUtils.mulTermsFrom(rightTree, power, toTerms, toPowers, positive);
        toTerms = toTerms.tail;
        toPowers = toPowers.tail;
        Tree numerator = null;
        Tree denominator = null;
        while (toTerms != null) {
            int repetition;
            Tree nextTerm = (Tree)toTerms.head;
            int nextPower = toPowers.head;
            for (int i = repetition = 1; i > 0; --i) {
                if (nextPower == 0) continue;
                if (nextTerm.parent() != null) {
                    nextTerm = ILUtils.copy(nextTerm);
                }
                Tree newTree = nextPower > 0 ? numerator : denominator;
                int positivePower = nextPower > 0 ? nextPower : -nextPower;
                Tree newPowerTree = positivePower == 1 ? nextTerm : ILUtils.build(155, nextTerm, ILUtils.build(103, positivePower));
                if (newTree == null) {
                    newTree = newPowerTree;
                } else {
                    if (newPowerTree.parent() != null) {
                        newPowerTree = ILUtils.copy(newPowerTree);
                    }
                    newTree = ILUtils.build(133, newTree, newPowerTree);
                }
                if (nextPower > 0) {
                    numerator = newTree;
                    continue;
                }
                denominator = newTree;
            }
            toTerms = toTerms.tail;
            toPowers = toPowers.tail;
        }
        if (numerator == null) {
            numerator = leftTree.opCode() == 160 || rightTree.opCode() == 160 ? ILUtils.build(160, "1.0") : ILUtils.build(103, 1);
        }
        Tree result = denominator == null ? numerator : ILUtils.build(62, numerator, denominator);
        if (!positive.get()) {
            result = ILUtils.build(124, result);
        }
        return result;
    }

    private static void mulTermsFrom(Tree tree, int power, TapList<Tree> toTerms, TapIntList toPowers, ToBool positive) {
        switch (tree.opCode()) {
            case 133: {
                ILUtils.mulTermsFrom(tree.down(1), power, toTerms, toPowers, positive);
                ILUtils.mulTermsFrom(tree.down(2), power, toTerms, toPowers, positive);
                break;
            }
            case 62: {
                ILUtils.mulTermsFrom(tree.down(1), power, toTerms, toPowers, positive);
                ILUtils.mulTermsFrom(tree.down(2), -power, toTerms, toPowers, positive);
                break;
            }
            case 124: {
                if (power % 2 == 1 || power < 0 && -power % 2 == 1) {
                    positive.not();
                }
                ILUtils.mulTermsFrom(tree.down(1), power, toTerms, toPowers, positive);
                break;
            }
            case 155: {
                if (ILUtils.isExpressionIntConstant(tree.down(2))) {
                    ILUtils.mulTermsFrom(tree.down(1), power * ILUtils.intConstantValue(tree.down(2)), toTerms, toPowers, positive);
                    break;
                }
                ILUtils.mulOneTerm(tree, power, toTerms, toPowers);
                break;
            }
            case 103: 
            case 160: {
                if (ILUtils.isNegativeExpression(tree)) {
                    positive.not();
                    tree = ILUtils.buildNumericalOpposite(tree);
                }
                ILUtils.mulOneTerm(tree, power, toTerms, toPowers);
                break;
            }
            default: {
                ILUtils.mulOneTerm(tree, power, toTerms, toPowers);
            }
        }
    }

    private static void mulOneTerm(Tree tree, int power, TapList<Tree> toTerms, TapIntList toPowers) {
        if (!ILUtils.evalsToOne(tree)) {
            while (toTerms.tail != null && !ILUtils.equalValues((Tree)toTerms.tail.head, tree, null, null)) {
                toTerms = toTerms.tail;
                toPowers = toPowers.tail;
            }
            if (toTerms.tail == null) {
                toTerms.tail = new TapList<Tree>(tree, null);
                toPowers.tail = new TapIntList(0, null);
            }
            toPowers.tail.head += power;
        }
    }

    public static Tree build(int opRank, int value) {
        Tree result = ILLangOps.ops(opRank).tree();
        result.setValue(value);
        return result;
    }

    public static Tree build(int opRank, String value) {
        Tree result = ILLangOps.ops(opRank).tree();
        result.setValue(value);
        return result;
    }

    public static Tree build(int opRank) {
        Tree result = ILLangOps.ops(opRank).tree();
        int sonsNb = result.children().length;
        int sonRk = 0;
        while (++sonRk <= sonsNb) {
            result.setChild(ILLangOps.ops(138).tree(), sonRk);
        }
        return result;
    }

    public static Tree build(int opRank, Tree son1) {
        Tree result = ILLangOps.ops(opRank).tree();
        int sonsNb = result.children().length;
        ILUtils.changeOrAdoptSon(result, son1, 1, sonsNb);
        int sonRk = 1;
        while (++sonRk <= sonsNb) {
            result.setChild(ILLangOps.ops(138).tree(), sonRk);
        }
        return result;
    }

    public static Tree build(int opRank, Tree son1, Tree son2) {
        Tree result = ILLangOps.ops(opRank).tree();
        int sonsNb = result.children().length;
        ILUtils.changeOrAdoptSon(result, son1, 1, sonsNb);
        ILUtils.changeOrAdoptSon(result, son2, 2, sonsNb);
        int sonRk = 2;
        while (++sonRk <= sonsNb) {
            result.setChild(ILLangOps.ops(138).tree(), sonRk);
        }
        return result;
    }

    public static Tree build(int opRank, Tree son1, Tree son2, Tree son3) {
        Tree result = ILLangOps.ops(opRank).tree();
        int sonsNb = result.children().length;
        ILUtils.changeOrAdoptSon(result, son1, 1, sonsNb);
        ILUtils.changeOrAdoptSon(result, son2, 2, sonsNb);
        ILUtils.changeOrAdoptSon(result, son3, 3, sonsNb);
        int sonRk = 3;
        while (++sonRk <= sonsNb) {
            result.setChild(ILLangOps.ops(138).tree(), sonRk);
        }
        return result;
    }

    public static Tree build(int opRank, Tree son1, Tree son2, Tree son3, Tree son4) {
        Tree result = ILLangOps.ops(opRank).tree();
        int sonsNb = result.children().length;
        ILUtils.changeOrAdoptSon(result, son1, 1, sonsNb);
        ILUtils.changeOrAdoptSon(result, son2, 2, sonsNb);
        ILUtils.changeOrAdoptSon(result, son3, 3, sonsNb);
        ILUtils.changeOrAdoptSon(result, son4, 4, sonsNb);
        int sonRk = 4;
        while (++sonRk <= sonsNb) {
            result.setChild(ILLangOps.ops(138).tree(), sonRk);
        }
        return result;
    }

    public static Tree build(int opRank, Tree son1, Tree son2, Tree son3, Tree son4, Tree son5) {
        Tree result = ILLangOps.ops(opRank).tree();
        int sonsNb = result.children().length;
        ILUtils.changeOrAdoptSon(result, son1, 1, sonsNb);
        ILUtils.changeOrAdoptSon(result, son2, 2, sonsNb);
        ILUtils.changeOrAdoptSon(result, son3, 3, sonsNb);
        ILUtils.changeOrAdoptSon(result, son4, 4, sonsNb);
        ILUtils.changeOrAdoptSon(result, son5, 5, sonsNb);
        int sonRk = 5;
        while (++sonRk <= sonsNb) {
            result.setChild(ILLangOps.ops(138).tree(), sonRk);
        }
        return result;
    }

    public static Tree build(int opRank, Tree son1, Tree son2, Tree son3, Tree son4, Tree son5, Tree son6) {
        Tree result = ILLangOps.ops(opRank).tree();
        int sonsNb = result.children().length;
        ILUtils.changeOrAdoptSon(result, son1, 1, sonsNb);
        ILUtils.changeOrAdoptSon(result, son2, 2, sonsNb);
        ILUtils.changeOrAdoptSon(result, son3, 3, sonsNb);
        ILUtils.changeOrAdoptSon(result, son4, 4, sonsNb);
        ILUtils.changeOrAdoptSon(result, son5, 5, sonsNb);
        ILUtils.changeOrAdoptSon(result, son6, 6, sonsNb);
        int sonRk = 6;
        while (++sonRk <= sonsNb) {
            result.setChild(ILLangOps.ops(138).tree(), sonRk);
        }
        return result;
    }

    public static Tree build(int opRank, Tree son1, Tree son2, Tree son3, Tree son4, Tree son5, Tree son6, Tree son7) {
        Tree result = ILLangOps.ops(opRank).tree();
        int sonsNb = result.children().length;
        ILUtils.changeOrAdoptSon(result, son1, 1, sonsNb);
        ILUtils.changeOrAdoptSon(result, son2, 2, sonsNb);
        ILUtils.changeOrAdoptSon(result, son3, 3, sonsNb);
        ILUtils.changeOrAdoptSon(result, son4, 4, sonsNb);
        ILUtils.changeOrAdoptSon(result, son5, 5, sonsNb);
        ILUtils.changeOrAdoptSon(result, son6, 6, sonsNb);
        ILUtils.changeOrAdoptSon(result, son7, 7, sonsNb);
        int sonRk = 7;
        while (++sonRk <= sonsNb) {
            result.setChild(ILLangOps.ops(138).tree(), sonRk);
        }
        return result;
    }

    public static Tree build(int opRank, Tree son1, Tree son2, Tree son3, Tree son4, Tree son5, Tree son6, Tree son7, Tree son8) {
        Tree result = ILLangOps.ops(opRank).tree();
        int sonsNb = result.children().length;
        ILUtils.changeOrAdoptSon(result, son1, 1, sonsNb);
        ILUtils.changeOrAdoptSon(result, son2, 2, sonsNb);
        ILUtils.changeOrAdoptSon(result, son3, 3, sonsNb);
        ILUtils.changeOrAdoptSon(result, son4, 4, sonsNb);
        ILUtils.changeOrAdoptSon(result, son5, 5, sonsNb);
        ILUtils.changeOrAdoptSon(result, son6, 6, sonsNb);
        ILUtils.changeOrAdoptSon(result, son7, 7, sonsNb);
        ILUtils.changeOrAdoptSon(result, son8, 8, sonsNb);
        int sonRk = 8;
        while (++sonRk <= sonsNb) {
            result.setChild(ILLangOps.ops(138).tree(), sonRk);
        }
        return result;
    }

    public static Tree build(int opRank, TapList<Tree> trees) {
        Tree result = ILLangOps.ops(opRank).tree();
        int sonsNb = result.children().length;
        int sonRk = 0;
        while (trees != null) {
            Tree tree = (Tree)trees.head;
            if (tree.parent() != null) {
                tree = ILUtils.copy(tree);
            }
            ILUtils.changeOrAdoptSon(result, tree, ++sonRk, sonsNb);
            trees = trees.tail;
        }
        while (++sonRk <= sonsNb) {
            result.setChild(ILLangOps.ops(138).tree(), sonRk);
        }
        return result;
    }

    public static Tree build(int opRank, Tree[] trees) {
        Tree result = ILLangOps.ops(opRank).tree();
        int sonsNb = result.children().length;
        int sonRk = 0;
        for (Tree tree : trees) {
            ILUtils.changeOrAdoptSon(result, tree, ++sonRk, sonsNb);
        }
        while (++sonRk <= sonsNb) {
            result.setChild(ILLangOps.ops(138).tree(), sonRk);
        }
        return result;
    }

    public static void dump(Tree tree, int indent) throws IOException {
        ILUtils.dumpRec(tree, indent, "");
    }

    private static void dumpRec(Tree tree, int indent, String commentPrefix) throws IOException {
        Tree comments = (Tree)tree.getAnnotation("preCommentsBlock");
        if (comments != null) {
            ILUtils.dumpRec(comments, indent, "//[preB on " + tree.opName() + "] ");
            TapEnv.println();
            TapEnv.indent(indent);
        }
        if ((comments = (Tree)tree.getAnnotation("preComments")) != null) {
            ILUtils.dumpRec(comments, indent, "//[pre on " + tree.opName() + "] ");
            TapEnv.println();
            TapEnv.indent(indent);
        }
        switch (tree.opCode()) {
            case 76: {
                for (int i = 1; i <= tree.length(); ++i) {
                    ILUtils.dumpRec(tree.down(i), indent, commentPrefix);
                    TapEnv.println();
                    TapEnv.println();
                    TapEnv.indent(indent);
                }
                break;
            }
            case 36: {
                ILUtils.dumpRec(tree.down(1), indent, commentPrefix);
                TapEnv.print(" class ");
                ILUtils.dumpRec(tree.down(2), indent, commentPrefix);
                TapEnv.print(" parents:");
                ILUtils.dumpRec(tree.down(3), indent, commentPrefix);
                TapEnv.print(" ");
                if (ILUtils.isNullOrNoneOrEmptyList(tree.down(4))) {
                    TapEnv.print("{}");
                    break;
                }
                ILUtils.dumpRec(tree.down(4), indent + 2, commentPrefix);
                break;
            }
            case 27: 
            case 53: {
                TapEnv.print("{");
                TapEnv.println();
                for (int i = 1; i <= tree.length(); ++i) {
                    TapEnv.indent(indent + 2);
                    ILUtils.dumpRec(tree.down(i), indent + 2, commentPrefix);
                    TapEnv.print(";");
                    TapEnv.println();
                }
                TapEnv.indent(indent);
                TapEnv.print("}");
                break;
            }
            case 89: {
                ILUtils.dumpRec(tree.down(1), indent, commentPrefix);
                ILUtils.dumpRec(tree.down(2), indent, commentPrefix);
                ILUtils.dumpRec(tree.down(3), indent, commentPrefix);
                TapEnv.print(" function ");
                ILUtils.dumpRec(tree.down(4), indent, commentPrefix);
                TapEnv.print("(");
                ILUtils.dumpRec(tree.down(5), indent, commentPrefix);
                TapEnv.print(") ");
                if (tree.down(4).getAnnotation("explicitReturnVar") != null) {
                    TapEnv.print(" explicitReturnVar (" + ILUtils.toString((Tree)tree.down(4).getAnnotation("explicitReturnVar")) + ") ");
                }
                if (tree.down(4).getAnnotation("bind") != null) {
                    TapEnv.print(" bind (" + ILUtils.toString((Tree)tree.down(4).getAnnotation("bind")) + ") ");
                }
                ILUtils.dumpRec(tree.down(6), indent, commentPrefix);
                break;
            }
            case 159: {
                ILUtils.dumpRec(tree.down(1), indent, commentPrefix);
                TapEnv.print("program ");
                ILUtils.dumpRec(tree.down(2), indent, commentPrefix);
                TapEnv.print("(");
                ILUtils.dumpRec(tree.down(3), indent, commentPrefix);
                TapEnv.print(") ");
                ILUtils.dumpRec(tree.down(4), indent, commentPrefix);
                break;
            }
            case 121: {
                TapEnv.print("loop [");
                ILUtils.dumpRec(tree.down(1), indent, commentPrefix);
                TapEnv.print("][");
                ILUtils.dumpRec(tree.down(2), indent, commentPrefix);
                TapEnv.print("] ");
                ILUtils.dumpRec(tree.down(3), indent, commentPrefix);
                TapEnv.print(" ");
                ILUtils.dumpRec(tree.down(4), indent, commentPrefix);
                break;
            }
            case 145: {
                TapEnv.print("parallel region [");
                ILUtils.dumpRec(tree.down(1), indent, commentPrefix);
                TapEnv.print("] ");
                ILUtils.dumpRec(tree.down(2), indent, commentPrefix);
                ILUtils.dumpRec(tree.down(3), indent, commentPrefix);
                break;
            }
            case 144: {
                TapEnv.print("parallel loop [");
                ILUtils.dumpRec(tree.down(1), indent, commentPrefix);
                TapEnv.print("] ");
                ILUtils.dumpRec(tree.down(2), indent, commentPrefix);
                ILUtils.dumpRec(tree.down(3), indent, commentPrefix);
                break;
            }
            case 98: {
                TapEnv.print("if (");
                ILUtils.dumpRec(tree.down(1), indent, commentPrefix);
                TapEnv.print(") then ");
                ILUtils.dumpRec(tree.down(2), indent, commentPrefix);
                TapEnv.print(" else ");
                ILUtils.dumpRec(tree.down(3), indent, commentPrefix);
                TapEnv.print(" endif");
                break;
            }
            case 161: {
                TapEnv.print("record");
                if (tree.down(1).opCode() != 138) {
                    TapEnv.print("<");
                    ILUtils.dumpRec(tree.down(1), indent, commentPrefix);
                    TapEnv.print(">");
                }
                if (tree.down(2).opCode() != 138) {
                    TapEnv.print("[");
                    ILUtils.dumpRec(tree.down(2), indent, commentPrefix);
                    TapEnv.print("[");
                }
                TapEnv.print("{");
                ILUtils.dumpRec(tree.down(3), indent, commentPrefix);
                TapEnv.print("}");
                break;
            }
            case 195: {
                TapEnv.print("union");
                if (tree.down(1).opCode() != 138) {
                    TapEnv.print("<");
                    ILUtils.dumpRec(tree.down(1), indent, commentPrefix);
                    TapEnv.print(">");
                }
                TapEnv.print("{");
                ILUtils.dumpRec(tree.down(2), indent, commentPrefix);
                TapEnv.print("}");
                break;
            }
            case 37: 
            case 38: {
                String blockPrefix = tree.opCode() == 38 ? "[Block]" : "[]";
                for (int i = 1; i <= tree.length(); ++i) {
                    TapEnv.print(commentPrefix + blockPrefix + ILUtils.toStringRec(tree.down(i), true, false, 0, 4, null));
                    if (i >= tree.length()) continue;
                    TapEnv.println();
                    TapEnv.indent(indent);
                }
                break;
            }
            case 39: {
                TapEnv.print("common ");
                ILUtils.dumpRec(tree.down(1), indent, commentPrefix);
                TapEnv.print(" ");
                ILUtils.dumpRec(tree.down(2), indent, commentPrefix);
                break;
            }
            case 69: {
                TapEnv.print("equivalence ");
                for (int i = 1; i <= tree.length(); ++i) {
                    TapEnv.print("(");
                    ILUtils.dumpRec(tree.down(i), indent, commentPrefix);
                    TapEnv.print(") ");
                }
                break;
            }
            case 129: {
                ILUtils.dumpRec(tree.down(2), indent, commentPrefix);
                TapEnv.print("*");
                ILUtils.dumpRec(tree.down(1), indent, commentPrefix);
                break;
            }
            case 192: {
                TapEnv.print("typedef ");
                ILUtils.dumpRec(tree.down(1), indent, commentPrefix);
                TapEnv.print(":");
                ILUtils.dumpRec(tree.down(2), indent, commentPrefix);
                break;
            }
            case 45: {
                ILUtils.dumpRec(tree.down(1), indent, commentPrefix);
                TapEnv.print(" constant ");
                ILUtils.dumpRec(tree.down(2), indent, commentPrefix);
                break;
            }
            case 13: {
                ILUtils.dumpRec(tree.down(1), indent, commentPrefix);
                TapEnv.print("[");
                ILUtils.dumpRec(tree.down(2), indent, commentPrefix);
                TapEnv.print("]");
                break;
            }
            case 136: {
                TapEnv.print("namespace ");
                ILUtils.dumpRec(tree.down(1), indent, commentPrefix);
                TapEnv.print(":");
                ILUtils.dumpRec(tree.down(2), indent, commentPrefix);
                break;
            }
            default: {
                TapEnv.print(ILUtils.toStringRec(tree, true, false, 0, 4, null));
            }
        }
        comments = (Tree)tree.getAnnotation("postComments");
        if (comments != null) {
            TapEnv.println();
            TapEnv.indent(indent);
            ILUtils.dumpRec(comments, indent, "//[post on " + tree.opName() + "] ");
        }
        if ((comments = (Tree)tree.getAnnotation("postCommentsBlock")) != null) {
            TapEnv.println();
            TapEnv.indent(indent);
            ILUtils.dumpRec(comments, indent, "//[postB on " + tree.opName() + "] ");
        }
    }

    public static String toString(Tree tree) {
        return ILUtils.toStringRec(tree, true, true, 0, 4, null);
    }

    public static String toString(Tree tree, int language) {
        return ILUtils.toStringRec(tree, true, true, 0, language, null);
    }

    public static String toString(Tree tree, int language, boolean withIndices) {
        return ILUtils.toStringRec(tree, withIndices, true, 0, language, null);
    }

    public static String toString(Tree tree, int language, ActivityPattern pattern) {
        return ILUtils.toStringRec(tree, true, true, 0, language, pattern);
    }

    public static String toString(Tree tree, ActivityPattern pattern) {
        return ILUtils.toStringRec(tree, true, true, 0, 4, pattern);
    }

    private static String toStringRec(Tree tree, boolean withIndices, boolean withTopComments, int requiredLevel, int language, ActivityPattern pattern) {
        String result;
        int thisLevel = 100;
        if (tree == null) {
            return "null";
        }
        String moreInfo = "";
        if (pattern != null && ADActivityAnalyzer.isAnnotatedActive(pattern, tree, null)) {
            moreInfo = moreInfo + TapEnv.activeMark();
        }
        if (pattern != null && ReqExplicit.isAnnotatedReqX(pattern, tree)) {
            moreInfo = moreInfo + TapEnv.reqXMark();
        }
        switch (tree.opCode()) {
            case 20: 
            case 28: 
            case 96: 
            case 103: 
            case 160: {
                result = tree.stringValue() + moreInfo;
                break;
            }
            case 180: {
                result = "\"" + tree.stringValue() + "\"" + moreInfo;
                break;
            }
            case 118: {
                result = "'" + tree.stringValue() + "'" + moreInfo;
                break;
            }
            case 101: {
                result = "include " + tree.stringValue() + moreInfo;
                break;
            }
            case 123: {
                result = "meta " + tree.stringValue() + moreInfo;
                break;
            }
            case 112: {
                result = ILUtils.toStringRec(tree.down(1), withIndices, true, 2, language, pattern) + "      " + ILUtils.toStringRec(tree.down(2), withIndices, true, 2, language, pattern);
                break;
            }
            case 14: 
            case 134: {
                thisLevel = 1;
                result = ILUtils.toStringRec(tree.down(1), withIndices, true, 2, language, pattern) + "=" + moreInfo + ILUtils.toStringRec(tree.down(2), withIndices, true, 1, language, pattern);
                break;
            }
            case 168: {
                result = "return " + ILUtils.toStringRec(tree.down(1), withIndices, true, 2, language, pattern);
                if (ILUtils.isNullOrNone(tree.down(2))) break;
                result = result + " (gto:" + ILUtils.toStringRec(tree.down(2), withIndices, true, 2, language, pattern) + ')';
                break;
            }
            case 152: {
                thisLevel = 1;
                result = ILUtils.toStringRec(tree.down(1), withIndices, true, 2, language, pattern) + "=>" + moreInfo + ILUtils.toStringRec(tree.down(2), withIndices, true, 1, language, pattern);
                break;
            }
            case 124: {
                thisLevel = 2;
                result = "-" + moreInfo + ILUtils.toStringRec(tree.down(1), withIndices, true, 3, language, pattern);
                break;
            }
            case 182: {
                thisLevel = 2;
                result = ILUtils.toStringRec(tree.down(1), withIndices, true, 2, language, pattern) + "-" + moreInfo + ILUtils.toStringRec(tree.down(2), withIndices, true, 3, language, pattern);
                break;
            }
            case 3: {
                thisLevel = 2;
                result = ILUtils.toStringRec(tree.down(1), withIndices, true, 2, language, pattern) + "+" + moreInfo + ILUtils.toStringRec(tree.down(2), withIndices, true, 3, language, pattern);
                break;
            }
            case 133: {
                thisLevel = 3;
                result = ILUtils.toStringRec(tree.down(1), withIndices, true, 3, language, pattern) + "*" + moreInfo + ILUtils.toStringRec(tree.down(2), withIndices, true, 4, language, pattern);
                break;
            }
            case 126: {
                thisLevel = 3;
                result = ILUtils.toStringRec(tree.down(1), withIndices, true, 3, language, pattern) + "%" + moreInfo + ILUtils.toStringRec(tree.down(2), withIndices, true, 4, language, pattern);
                break;
            }
            case 62: {
                thisLevel = 3;
                result = ILUtils.toStringRec(tree.down(1), withIndices, true, 3, language, pattern) + "/" + moreInfo + ILUtils.toStringRec(tree.down(2), withIndices, true, 4, language, pattern);
                break;
            }
            case 155: {
                thisLevel = 4;
                result = ILUtils.toStringRec(tree.down(1), withIndices, true, 3, language, pattern) + "^" + moreInfo + ILUtils.toStringRec(tree.down(2), withIndices, true, 4, language, pattern);
                break;
            }
            case 116: {
                thisLevel = 4;
                result = ILUtils.toStringRec(tree.down(1), withIndices, true, 3, language, pattern) + "<<" + moreInfo + ILUtils.toStringRec(tree.down(2), withIndices, true, 4, language, pattern);
                break;
            }
            case 169: {
                thisLevel = 4;
                result = ILUtils.toStringRec(tree.down(1), withIndices, true, 3, language, pattern) + ">>" + moreInfo + ILUtils.toStringRec(tree.down(2), withIndices, true, 4, language, pattern);
                break;
            }
            case 75: {
                thisLevel = 5;
                result = ILUtils.toStringRec(tree.down(1), withIndices, true, 4, language, pattern) + "." + ILUtils.toStringRec(tree.down(2), withIndices, true, 5, language, pattern) + moreInfo;
                break;
            }
            case 173: {
                thisLevel = 5;
                result = ILUtils.toStringRec(tree.down(1), withIndices, true, 4, language, pattern) + "::" + ILUtils.toStringRec(tree.down(2), withIndices, true, 5, language, pattern);
                break;
            }
            case 5: {
                if (tree.down(2) != null && tree.down(2).opCode() == 180) {
                    result = "[alloc" + ILUtils.toStringRec(tree.down(1), withIndices, true, 0, language, pattern) + " in " + tree.down(2).stringValue() + "]";
                    break;
                }
                result = "alloc(" + ILUtils.toStringRec(tree.down(1), withIndices, true, 0, language, pattern) + (ILUtils.isNullOrNone(tree.down(2)) ? "" : " ; " + ILUtils.toStringRec(tree.down(2), withIndices, true, 0, language, pattern) + " ; " + ILUtils.toStringRec(tree.down(3), withIndices, true, 0, language, pattern) + " ; " + ILUtils.toStringRec(tree.down(4), withIndices, true, 0, language, pattern)) + ')';
                break;
            }
            case 151: {
                if (ILUtils.isNullOrNone(tree.down(2))) {
                    result = "*" + moreInfo + ILUtils.toStringRec(tree.down(1), withIndices, true, 6, language, pattern);
                    break;
                }
                result = ILUtils.toStringRec(tree.down(1), withIndices, true, 0, language, pattern) + "[" + ILUtils.toStringRec(tree.down(2), withIndices, true, 0, language, pattern) + ']' + moreInfo;
                break;
            }
            case 153: {
                result = '*' + ILUtils.toStringRec(tree.down(1), withIndices, true, 6, language, pattern) + moreInfo;
                break;
            }
            case 4: {
                result = '&' + ILUtils.toStringRec(tree.down(1), withIndices, true, 6, language, pattern) + moreInfo;
                break;
            }
            case 57: {
                result = '~' + ILUtils.toStringRec(tree.down(1), withIndices, true, 0, language, pattern) + "()" + moreInfo;
                break;
            }
            case 146: {
                result = ILUtils.toStringRec(tree.down(2), withIndices, true, 0, language, pattern);
                String sizes = "";
                Tree[] fanSizes = tree.down(3).children();
                for (int i = 0; i < fanSizes.length; ++i) {
                    if (i != 0) {
                        sizes = sizes + ",";
                    }
                    sizes = sizes + ILUtils.toStringRec(fanSizes[i], withIndices, true, 0, language, pattern);
                }
                result = result + "<<<" + sizes + ">>>" + moreInfo;
                break;
            }
            case 31: 
            case 47: {
                boolean isCall = tree.opCode() == 31;
                Tree obj = isCall ? ILUtils.getObject(tree) : tree.down(1);
                Tree func = isCall ? ILUtils.getCalledName(tree) : tree.down(2);
                Tree[] args = (isCall ? ILUtils.getArguments(tree) : tree.down(3)).children();
                result = "";
                for (int i = args.length - 1; i >= 0; --i) {
                    result = ILUtils.toStringRec(args[i], withIndices, true, 0, language, pattern) + result;
                    if (i <= 0) continue;
                    result = "," + result;
                }
                boolean markAsActive = pattern != null && ADActivityAnalyzer.isAnnotatedActive(pattern, func, null);
                boolean markAsReqX = pattern != null && ReqExplicit.isAnnotatedReqX(pattern, func);
                Tree explicitReturnVar = (Tree)func.getAnnotation("explicitReturnVar");
                Tree bind = (Tree)func.getAnnotation("bind");
                result = (ILUtils.isNullOrNone(obj) ? "" : ILUtils.toStringRec(obj, withIndices, true, 0, language, pattern) + ".") + ILUtils.toStringRec(func, withIndices, true, 0, language, pattern) + (markAsActive ? TapEnv.activeMark() : "") + (markAsReqX ? TapEnv.reqXMark() : "") + "(" + result + ")" + moreInfo + (ILUtils.isNullOrNone(explicitReturnVar) ? "" : " [explicitReturnVar:" + ILUtils.toStringRec(explicitReturnVar, withIndices, true, 0, language, pattern) + "] ") + (ILUtils.isNullOrNoneOrEmptyList(bind) ? "" : " [bind:" + ILUtils.toStringRec(bind, withIndices, true, 0, language, pattern) + "] ");
                break;
            }
            case 9: 
            case 11: {
                result = "";
                if (withIndices) {
                    Tree[] subTrees = tree.down(2).children();
                    if (TapEnv.isFortran(language)) {
                        for (int i = 0; i < subTrees.length; ++i) {
                            result = ILUtils.toStringRec(subTrees[i], true, true, 0, language, pattern) + result;
                            if (i >= subTrees.length - 1) continue;
                            result = "," + result;
                        }
                    } else {
                        for (int i = subTrees.length - 1; i >= 0; --i) {
                            result = ILUtils.toStringRec(subTrees[i], true, true, 0, language, pattern) + result;
                            if (i <= 0) continue;
                            result = "," + result;
                        }
                    }
                    result = "[" + result + "]";
                }
                result = ILUtils.toStringRec(tree.down(1), withIndices, true, 0, language, pattern) + result + moreInfo;
                break;
            }
            case 37: {
                result = "";
                Tree[] subTrees = tree.children();
                for (int i = subTrees.length - 1; i >= 0; --i) {
                    result = ILUtils.toStringRec(subTrees[i], withIndices, true, 0, language, pattern) + result;
                    if (i == 0) continue;
                    result = "|" + result;
                }
                break;
            }
            case 138: {
                result = "_";
                break;
            }
            case 177: {
                result = "*";
                break;
            }
            case 12: {
                result = ILUtils.toStringRec(tree.down(1), withIndices, true, 0, language, pattern) + ':' + ILUtils.toStringRec(tree.down(2), withIndices, true, 0, language, pattern);
                if (tree.down(3).opCode() == 138) break;
                result = result + ':' + ILUtils.toStringRec(tree.down(3), withIndices, true, 0, language, pattern);
                break;
            }
            case 80: 
            case 110: {
                result = "(" + ILUtils.toStringRec(tree.down(1), withIndices, true, 0, language, pattern) + "," + ILUtils.toStringRec(tree.down(2), withIndices, true, 0, language, pattern) + ')';
                break;
            }
            case 8: 
            case 54: 
            case 71: 
            case 83: 
            case 130: {
                Tree[] subTrees = tree.children();
                result = "";
                for (int i = subTrees.length - 1; i >= 0; --i) {
                    if (i != subTrees.length - 1) {
                        result = " " + result;
                    }
                    result = ILUtils.toStringRec(subTrees[i], withIndices, true, 0, language, pattern) + result;
                }
                break;
            }
            case 53: 
            case 60: 
            case 200: 
            case 201: {
                Tree[] subTrees = tree.children();
                if (subTrees.length == 0) {
                    result = "";
                    break;
                }
                result = ILUtils.toStringRec(subTrees[subTrees.length - 1], withIndices, true, 0, language, pattern);
                for (int i = subTrees.length - 2; i >= 0; --i) {
                    result = ILUtils.toStringRec(subTrees[i], withIndices, true, 0, language, pattern) + "," + result;
                }
                break;
            }
            case 181: {
                Tree[] subTrees = tree.children();
                result = "";
                for (int i = subTrees.length - 1; i >= 0; --i) {
                    String stringi = ILUtils.toStringRec(subTrees[i], withIndices, true, 0, language, pattern);
                    result = i != subTrees.length - 1 ? stringi + " " + result : stringi;
                }
                break;
            }
            case 64: {
                result = tree.down(4).opCode() == 138 ? "" : "," + ILUtils.toStringRec(tree.down(4), withIndices, true, 0, language, pattern);
                result = ILUtils.toStringRec(tree.down(1), withIndices, true, 0, language, pattern) + "=" + ILUtils.toStringRec(tree.down(2), withIndices, true, 0, language, pattern) + "," + ILUtils.toStringRec(tree.down(3), withIndices, true, 0, language, pattern) + result;
                break;
            }
            case 82: {
                result = tree.down(4).opCode() == 138 ? "" : ":" + ILUtils.toStringRec(tree.down(4), withIndices, true, 0, language, pattern);
                result = ILUtils.toStringRec(tree.down(1), withIndices, true, 0, language, pattern) + "=" + ILUtils.toStringRec(tree.down(2), withIndices, true, 0, language, pattern) + ':' + ILUtils.toStringRec(tree.down(3), withIndices, true, 0, language, pattern) + result;
                break;
            }
            case 81: {
                result = ILUtils.toStringRec(tree.down(1), withIndices, true, 0, language, pattern) + " in " + ILUtils.toStringRec(tree.down(2), withIndices, true, 0, language, pattern);
                break;
            }
            case 59: {
                result = ILUtils.toStringRec(tree.down(1), withIndices, true, 0, language, pattern) + ':' + ILUtils.toStringRec(tree.down(2), withIndices, true, 0, language, pattern);
                break;
            }
            case 165: {
                result = ILUtils.toStringRec(tree.down(1), withIndices, true, 0, language, pattern) + " => " + ILUtils.toStringRec(tree.down(2), withIndices, true, 0, language, pattern);
                break;
            }
            case 166: {
                Tree[] subTrees = tree.children();
                result = "";
                for (int i = subTrees.length - 1; i >= 0; --i) {
                    result = ILUtils.toStringRec(subTrees[i], withIndices, true, 0, language, pattern) + " " + result;
                }
                break;
            }
            case 142: {
                Tree[] subTrees = tree.children();
                result = "";
                for (int i = subTrees.length - 1; i >= 0; --i) {
                    result = ILUtils.toStringRec(subTrees[i], withIndices, true, 0, language, pattern) + " " + result;
                }
                result = "only: " + result;
                break;
            }
            case 27: {
                Tree[] subTrees = tree.children();
                if (subTrees == null) {
                    result = ":" + tree.stringValue();
                    break;
                }
                result = "}";
                for (int i = subTrees.length - 1; i >= 0; --i) {
                    result = ILUtils.toStringRec(subTrees[i], withIndices, true, 0, language, pattern) + result;
                    if (i <= 0) continue;
                    result = "," + result;
                }
                result = "{" + result;
                break;
            }
            case 10: {
                Tree[] subTrees = tree.children();
                result = "";
                for (int i = subTrees.length - 1; i >= 0; --i) {
                    result = ILUtils.toStringRec(subTrees[i], withIndices, true, 0, language, pattern) + " " + result;
                }
                result = "/" + result + "/" + moreInfo;
                break;
            }
            case 90: {
                result = ILUtils.toStringRec(tree.down(1), withIndices, true, 0, language, pattern) + "(" + ILUtils.toStringRec(tree.down(2), withIndices, true, 0, language, pattern) + ')';
                break;
            }
            case 199: {
                result = (ILUtils.isNullOrNoneOrEmptyList(tree.down(1)) ? "" : ILUtils.toStringRec(tree.down(1), withIndices, true, 0, language, pattern) + ' ') + ILUtils.toStringRec(tree.down(2), withIndices, true, 0, language, pattern) + ' ' + ILUtils.toStringRec(tree.down(3), withIndices, true, 0, language, pattern);
                break;
            }
            case 98: {
                result = "if " + ILUtils.toStringRec(tree.down(1), withIndices, true, 0, language, pattern) + " then " + ILUtils.toStringRec(tree.down(2), withIndices, true, 0, language, pattern) + " else " + ILUtils.toStringRec(tree.down(3), withIndices, true, 0, language, pattern);
                break;
            }
            case 99: {
                result = "ifexp " + ILUtils.toStringRec(tree.down(1), withIndices, true, 0, language, pattern) + " then " + ILUtils.toStringRec(tree.down(2), withIndices, true, 0, language, pattern) + " else " + ILUtils.toStringRec(tree.down(3), withIndices, true, 0, language, pattern);
                break;
            }
            case 2: {
                result = ILUtils.toStringRec(tree.down(1), withIndices, true, 0, language, pattern) + " " + ILUtils.toStringRec(tree.down(2), withIndices, true, 0, language, pattern);
                break;
            }
            case 89: {
                Tree explicitReturnVar = (Tree)tree.down(4).getAnnotation("explicitReturnVar");
                Tree bind = (Tree)tree.down(4).getAnnotation("bind");
                result = "function(" + ILUtils.toStringRec(tree.down(1), withIndices, true, 0, language, pattern) + "," + ILUtils.toStringRec(tree.down(2), withIndices, true, 0, language, pattern) + "," + ILUtils.toStringRec(tree.down(3), withIndices, true, 0, language, pattern) + "," + ILUtils.toStringRec(tree.down(4), withIndices, true, 0, language, pattern) + "," + ILUtils.toStringRec(tree.down(5), withIndices, true, 0, language, pattern) + " [" + (ILUtils.isNullOrNone(explicitReturnVar) ? "" : "explicitReturnVar:" + ILUtils.toStringRec(explicitReturnVar, withIndices, true, 0, language, pattern)) + (ILUtils.isNullOrNoneOrEmptyList(bind) ? "" : " bind:" + ILUtils.toStringRec(bind, withIndices, true, 0, language, pattern)) + "] ," + ILUtils.toStringRec(tree.down(6), withIndices, true, 0, language, pattern) + ')';
                break;
            }
            case 204: {
                result = "void";
                break;
            }
            case 104: {
                result = TapEnv.isFortran(language) ? "INTEGER" : "int";
                break;
            }
            case 78: {
                result = TapEnv.isFortran(language) ? "REAL" : "float";
                break;
            }
            case 41: {
                result = TapEnv.isFortran(language) ? "COMPLEX" : "complex";
                break;
            }
            case 29: {
                result = TapEnv.isFortran(language) ? "LOGICAL" : "_Bool";
                break;
            }
            case 35: {
                result = TapEnv.isFortran(language) ? "CHARACTER" : "char";
                break;
            }
            case 129: {
                result = "[" + ILUtils.toStringRec(tree.down(1), withIndices, true, 0, language, pattern) + "]" + ILUtils.toStringRec(tree.down(2), withIndices, true, 0, language, pattern);
                break;
            }
            case 192: {
                result = "type " + ILUtils.toStringRec(tree.down(1), withIndices, true, 0, language, pattern) + ':' + ILUtils.toStringRec(tree.down(2), withIndices, true, 0, language, pattern);
                break;
            }
            case 161: {
                result = "record{" + ILUtils.toStringRec(tree.down(3), withIndices, true, 0, language, pattern) + "}";
                break;
            }
            case 136: {
                result = "namespace " + ILUtils.toStringRec(tree.down(1), withIndices, true, 0, language, pattern) + ":(" + ILUtils.toStringRec(tree.down(2), withIndices, true, 0, language, pattern) + ')';
                break;
            }
            default: {
                Tree[] subTrees = tree.children();
                if (subTrees == null) {
                    result = ":" + tree.stringValue();
                } else {
                    result = ")";
                    for (int i = subTrees.length - 1; i >= 0; --i) {
                        result = ILUtils.toStringRec(subTrees[i], withIndices, true, 0, language, pattern) + result;
                        if (i <= 0) continue;
                        result = "," + result;
                    }
                    result = "(" + result;
                }
                result = tree.opName() + moreInfo + result;
                break;
            }
        }
        if (withTopComments) {
            Tree comments = (Tree)tree.getAnnotation("preComments");
            if (comments != null) {
                result = "preC:[" + ILUtils.toStringRec(comments, withIndices, false, 0, language, pattern) + "]" + result;
            }
            if ((comments = (Tree)tree.getAnnotation("postComments")) != null) {
                result = result + "postC:[" + ILUtils.toStringRec(comments, withIndices, false, 0, language, pattern) + "]";
            }
        }
        if (thisLevel < requiredLevel) {
            result = "(" + result + ')';
        }
        return result;
    }

    public static Tree[] removeSizeModifiers(Tree[] modifiers) {
        if (modifiers == null) {
            return null;
        }
        TapList<Tree> keptModifiers = null;
        block5: for (int i = modifiers.length - 1; i >= 0; --i) {
            Tree modifier = modifiers[i];
            switch (modifier.opCode()) {
                case 2: 
                case 60: {
                    keptModifiers = new TapList<Tree>(modifier, keptModifiers);
                    continue block5;
                }
                case 96: {
                    if (!ILUtils.isIdentOf(modifier, new String[]{"signed", "unsigned", "const", "__const", "__const__", "restrict", "__restrict", "volatile", "__volatile", "__volatile__", "auto", "register", "extern", "static", "inline"}, true) && !ILUtils.isIdentOf(modifier, new String[]{"pointer", "allocatable", "constant", "save", "data", "in", "out", "inout", "external", "intrinsic", "optional", "target", "value", "private", "public", "sequence"}, false)) continue block5;
                    keptModifiers = new TapList<Tree>(modifier, keptModifiers);
                    continue block5;
                }
                case 134: {
                    if (ILUtils.isIdent(modifier.down(1), "kind", false)) continue block5;
                    keptModifiers = new TapList<Tree>(modifier, keptModifiers);
                    continue block5;
                }
            }
        }
        if (keptModifiers == null) {
            return null;
        }
        Tree[] result = new Tree[TapList.length(keptModifiers)];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Tree)keptModifiers.head;
            keptModifiers = keptModifiers.tail;
        }
        return result;
    }

    public static Tree buildCLoc(Tree expr, String cLoc) {
        return ILUtils.build(31, ILUtils.build(138), ILUtils.build(96, cLoc), ILUtils.build(71, expr));
    }

    public static boolean isAConstModified(Tree decl) {
        return decl != null && decl.opCode() == 128 && decl.down(1).length() == 1 && ILUtils.isIdent(decl.down(1).down(1), "const", true);
    }

    public static boolean isOverloadedAssign(Tree callAssign) {
        Tree sourceTree = (Tree)callAssign.getAnnotation("sourcetree");
        return sourceTree != null && sourceTree.opCode() == 17 && ILUtils.isIdent(sourceTree.down(2), "assign", true);
    }

    public static void addVarIntoFuturePrivates(NewSymbolHolder privateNSH, Tree pragma, boolean inFwd, boolean diff) {
        String annotationName = inFwd ? "futurePrivatesFwd" : (diff ? "futurePrivatesBwdDiff" : "futurePrivatesBwd");
        TapList privateNSHs = (TapList)pragma.getAnnotation(annotationName);
        if (!TapList.contains(privateNSHs, privateNSH)) {
            pragma.setAnnotation(annotationName, new TapList<NewSymbolHolder>(privateNSH, privateNSHs));
        }
    }

    public static void addVarIntoFutureSumReductions(NewSymbolHolder sumReductionNSH, Tree pragma) {
        String annotationName = "futureSumReductionsBwdDiff";
        TapList sumReductionNSHs = (TapList)pragma.getAnnotation(annotationName);
        if (!TapList.contains(sumReductionNSHs, sumReductionNSH)) {
            pragma.setAnnotation(annotationName, new TapList<NewSymbolHolder>(sumReductionNSH, sumReductionNSHs));
        }
    }

    public static String normalizePath(String path) {
        ToInt toStart = new ToInt(-1);
        ToInt toEnd = new ToInt(-1);
        while (ILUtils.simplifiableDotDot(path, toStart, toEnd)) {
            path = path.substring(0, toStart.get()) + path.substring(toEnd.get());
        }
        return path;
    }

    private static boolean simplifiableDotDot(String path, ToInt toStart, ToInt toEnd) {
        int end = path.indexOf("/../");
        if (end > 0) {
            int start = path.lastIndexOf("/", end - 1);
            toStart.set(start + 1);
            toEnd.set(end + 4);
            return true;
        }
        return false;
    }

    public static TapList<Tree> extractPrivateTrees(Tree pragma, SymbolTable usageST, boolean inFwd, boolean diff) {
        String annotationName = inFwd ? "futurePrivatesFwd" : (diff ? "futurePrivatesBwdDiff" : "futurePrivatesBwd");
        TapList privateNSHs = (TapList)pragma.getRemoveAnnotation(annotationName);
        TapList<Tree> result = null;
        while (privateNSHs != null) {
            result = new TapList<Tree>(((NewSymbolHolder)privateNSHs.head).makeNewRef(usageST), result);
            privateNSHs = privateNSHs.tail;
        }
        return result;
    }

    public static TapList<Tree> extractSumReductionTrees(Tree pragma, SymbolTable usageST) {
        String annotationName = "futureSumReductionsBwdDiff";
        TapList sumReductionNSHs = (TapList)pragma.getRemoveAnnotation(annotationName);
        TapList<Tree> result = null;
        while (sumReductionNSHs != null) {
            result = new TapList<Tree>(((NewSymbolHolder)sumReductionNSHs.head).makeNewRef(usageST), result);
            sumReductionNSHs = sumReductionNSHs.tail;
        }
        return result;
    }

    private ILUtils() {
    }
}

