/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.representation;

import fr.inria.tapenade.representation.Block;
import fr.inria.tapenade.representation.FGArrow;
import fr.inria.tapenade.representation.Instruction;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.utils.TapIntList;
import fr.inria.tapenade.utils.Tree;
import java.io.IOException;

public final class HeaderBlock
extends Block {
    public boolean loopIndexUnusedAfterLoop;
    public boolean dirtyOverwrittenIndex;
    public TapIntList localizedZones;
    public TapIntList uniqueAccessZones;
    public TapList<Tree> uniqueAccessTrees;
    public TapIntList topUniqueAccessZones;
    public TapIntList loopCompleteZones;
    public boolean declaresItsIterator;
    private String origCycleLabel;

    public HeaderBlock(SymbolTable symbolTable, TapList<Instruction> parallelControls, TapList<Block> allBlocks) {
        super(symbolTable, parallelControls, allBlocks);
    }

    public String origCycleLabel() {
        return this.origCycleLabel;
    }

    public void setOrigCycleLabel(String label) {
        this.origCycleLabel = label;
    }

    public void insertBlockBeforeLoopEntry(Block block) {
        TapList<FGArrow> toArrows;
        TapList<FGArrow> inArrows = toArrows = new TapList<FGArrow>(null, this.backFlow());
        while (inArrows.tail != null) {
            FGArrow arrow = (FGArrow)inArrows.tail.head;
            if (arrow.inACycle) {
                inArrows = inArrows.tail;
                continue;
            }
            arrow.destination = block;
            block.setBackFlow(new TapList<FGArrow>(arrow, block.backFlow()));
            inArrows.tail = inArrows.tail.tail;
        }
        this.setBackFlow(toArrows.tail);
        new FGArrow(block, 0, null, (Block)this);
    }

    public void insertBlockBeforeLoopCycle(Block block) {
        TapList<FGArrow> toArrows;
        TapList<FGArrow> inArrows = toArrows = new TapList<FGArrow>(null, this.backFlow());
        while (inArrows.tail != null) {
            FGArrow arrow = (FGArrow)inArrows.tail.head;
            if (arrow.inACycle) {
                arrow.destination = block;
                arrow.inACycle = false;
                block.setBackFlow(new TapList<FGArrow>(arrow, block.backFlow()));
                inArrows.tail = inArrows.tail.tail;
                continue;
            }
            inArrows = inArrows.tail;
        }
        this.setBackFlow(toArrows.tail);
        new FGArrow(block, 0, null, (Block)this, true);
    }

    public TapList<FGArrow> enteringArrows() {
        TapList<Object> hdResult;
        TapList<FGArrow> arrows = this.backFlow();
        TapList<Object> tlResult = hdResult = new TapList<Object>(null, null);
        while (arrows != null) {
            FGArrow arrow = (FGArrow)arrows.head;
            if (arrow.finalCycle() != arrow.destination.enclosingLoop()) {
                tlResult = tlResult.placdl(arrow);
            }
            arrows = arrows.tail;
        }
        return hdResult.tail;
    }

    public TapList<FGArrow> cyclingArrows() {
        TapList<Object> hdResult;
        TapList<FGArrow> arrows = this.backFlow();
        TapList<Object> tlResult = hdResult = new TapList<Object>(null, null);
        while (arrows != null) {
            FGArrow arrow = (FGArrow)arrows.head;
            if (arrow.finalCycle() == arrow.destination.enclosingLoop()) {
                tlResult = tlResult.placdl(arrow);
            }
            arrows = arrows.tail;
        }
        return hdResult.tail;
    }

    @Override
    public void cite() throws IOException {
        TapEnv.print("HB(" + this.rank + ')');
    }

    @Override
    public String toString() {
        return "H" + super.toString();
    }
}

