/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.representation;

import fr.inria.tapenade.representation.ArrayDim;
import fr.inria.tapenade.representation.ArrayTypeSpec;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.MetaTypeSpec;
import fr.inria.tapenade.representation.ModifiedTypeSpec;
import fr.inria.tapenade.representation.PointerTypeSpec;
import fr.inria.tapenade.representation.PrimitiveTypeSpec;
import fr.inria.tapenade.representation.SymbolDecl;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.TypeSpec;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.representation.WrapperTypeSpec;
import fr.inria.tapenade.utils.TapPair;
import fr.inria.tapenade.utils.TapTriplet;
import fr.inria.tapenade.utils.ToBool;
import fr.inria.tapenade.utils.Tree;
import java.io.IOException;

public final class FunctionTypeSpec
extends TypeSpec {
    public WrapperTypeSpec returnType;
    public WrapperTypeSpec[] argumentsTypes;
    public boolean variableArgList;

    public FunctionTypeSpec() {
        super(3);
    }

    public FunctionTypeSpec(WrapperTypeSpec returnType) {
        super(3);
        this.returnType = returnType;
        this.argumentsTypes = null;
    }

    public FunctionTypeSpec(WrapperTypeSpec returnType, WrapperTypeSpec[] argumentsTypes) {
        super(3);
        this.returnType = returnType;
        this.argumentsTypes = argumentsTypes;
    }

    public FunctionTypeSpec(WrapperTypeSpec returnType, WrapperTypeSpec[] argumentsTypes, boolean varArgList) {
        super(3);
        this.returnType = returnType;
        this.argumentsTypes = argumentsTypes;
        this.variableArgList = varArgList;
    }

    public FunctionTypeSpec(WrapperTypeSpec returnType, TapList<WrapperTypeSpec> paramsTypes) {
        super(3);
        this.returnType = returnType;
        this.argumentsTypes = new WrapperTypeSpec[TapList.length(paramsTypes)];
        for (int i = 0; i < this.argumentsTypes.length; ++i) {
            this.argumentsTypes[i] = (WrapperTypeSpec)paramsTypes.head;
            paramsTypes = paramsTypes.tail;
        }
    }

    private static void refineFormalWithActual(WrapperTypeSpec formalType, WrapperTypeSpec actualType, TapList<TypeSpec> dejaVu) {
        if (!TapList.contains(dejaVu, formalType)) {
            if (formalType.wrappedType == null) {
                formalType.wrappedType = actualType.wrappedType == null ? null : actualType.wrappedType.copy();
            } else if (FunctionTypeSpec.isA(formalType, 2)) {
                ArrayDim[] formalDims = ((ArrayTypeSpec)formalType.wrappedType).dimensions();
                ArrayDim[] actualDims = null;
                WrapperTypeSpec formalElementType = formalType.wrappedType.elementType();
                WrapperTypeSpec actualElementType = actualType;
                if (FunctionTypeSpec.isA(actualType, 2)) {
                    actualDims = ((ArrayTypeSpec)actualType.wrappedType).dimensions();
                    actualElementType = actualType.wrappedType.elementType();
                }
                if (formalDims == null) {
                    ((ArrayTypeSpec)formalType.wrappedType).setDimensions(actualDims);
                } else if (actualDims != null && formalDims.length == actualDims.length) {
                    for (int i = formalDims.length - 1; i >= 0; --i) {
                        if (formalDims[i] != null && !formalDims[i].isUnknown()) continue;
                        formalDims[i] = actualDims[i];
                    }
                }
                FunctionTypeSpec.refineFormalWithActual(formalElementType, actualElementType, new TapList<TypeSpec>(formalType, dejaVu));
            } else if (FunctionTypeSpec.isA(formalType, 7) && formalType.wrappedType.isUndefinedNumeric()) {
                WrapperTypeSpec insideActualType = actualType;
                ModifiedTypeSpec actualModif = null;
                ArrayTypeSpec actualArray = null;
                PrimitiveTypeSpec actualPrimitive = null;
                if (FunctionTypeSpec.isA(insideActualType, 2)) {
                    actualArray = (ArrayTypeSpec)insideActualType.wrappedType;
                    insideActualType = actualArray.elementType();
                }
                if (FunctionTypeSpec.isA(insideActualType, 5)) {
                    actualModif = (ModifiedTypeSpec)insideActualType.wrappedType;
                    insideActualType = actualModif.elementType();
                }
                if (FunctionTypeSpec.isA(insideActualType, 7) && !insideActualType.wrappedType.isUndefinedNumeric()) {
                    actualPrimitive = (PrimitiveTypeSpec)insideActualType.wrappedType;
                }
                if (actualPrimitive != null) {
                    formalType.wrappedType = ((PrimitiveTypeSpec)formalType.wrappedType).addWith(insideActualType);
                    formalType.wrappedType.setUndefinedNumeric(true);
                }
                if (actualModif != null) {
                    formalType.wrappedType = new ModifiedTypeSpec(new WrapperTypeSpec(formalType.wrappedType), actualModif);
                }
                if (actualArray != null) {
                    formalType.wrappedType = new ArrayTypeSpec(new WrapperTypeSpec(formalType.wrappedType), actualArray.dimensions());
                }
            }
        }
        formalType.setHasUndefinedSize(actualType.hasUndefinedSize());
    }

    protected static void finishLastMetaTypes(TapList<TapTriplet<TypeSpec, TypeSpec, Boolean>> toAlreadySolved, SymbolTable symbolTable) {
        toAlreadySolved = toAlreadySolved.tail;
        while (toAlreadySolved != null) {
            TapTriplet metaTriplet = (TapTriplet)toAlreadySolved.head;
            if (metaTriplet.first instanceof MetaTypeSpec) {
                WrapperTypeSpec foundType = (WrapperTypeSpec)metaTriplet.second;
                if (foundType.wrappedType == null) {
                    String metaName = ((MetaTypeSpec)metaTriplet.first).name;
                    TypeSpec baseType = null;
                    if (metaName.startsWith("real") || metaName.startsWith("float")) {
                        baseType = symbolTable.getTypeDecl((String)"float").typeSpec.wrappedType;
                    } else if (metaName.startsWith("int")) {
                        baseType = symbolTable.getTypeDecl((String)"integer").typeSpec.wrappedType;
                    } else if (metaName.startsWith("complex")) {
                        baseType = symbolTable.getTypeDecl((String)"complex").typeSpec.wrappedType;
                    } else if (metaName.startsWith("bool")) {
                        baseType = symbolTable.getTypeDecl((String)"boolean").typeSpec.wrappedType;
                    } else if (metaName.startsWith("char")) {
                        baseType = symbolTable.getTypeDecl((String)"character").typeSpec.wrappedType;
                    }
                    if (baseType != null) {
                        ModifiedTypeSpec modTypeSpec = new ModifiedTypeSpec(new WrapperTypeSpec(baseType), ILUtils.build(96, "undefinedSize"), symbolTable);
                        modTypeSpec.setHasUndefinedSize(true);
                        foundType.wrappedType = modTypeSpec;
                    }
                }
            }
            toAlreadySolved = toAlreadySolved.tail;
        }
    }

    public boolean isAFunction() {
        return this.returnType.wrappedType == null || !FunctionTypeSpec.isA(this.returnType, 9);
    }

    public void setReturnTypeSpec(WrapperTypeSpec typeSpec, Tree declaratorI) {
        if (this.returnType == null) {
            this.returnType = new WrapperTypeSpec(typeSpec.wrappedType);
        } else if (this.returnType.wrappedType == null) {
            this.returnType.wrappedType = typeSpec.wrappedType;
        } else if (typeSpec != null && !this.returnType.receives(typeSpec, null, null)) {
            TapEnv.fileWarning(15, declaratorI, "(DD06) Cannot combine successive declarations of function " + ILUtils.baseName(declaratorI) + " return type: " + this.returnType.showType() + " and " + typeSpec.showType() + " (overwritten previous)");
            this.returnType = typeSpec;
        }
    }

    public boolean matchesCall(TypeSpec callResultType, TypeSpec[] callArgTypes) {
        boolean matches = true;
        if (this.argumentsTypes != null && callArgTypes != null) {
            matches = this.argumentsTypes.length == callArgTypes.length;
            for (int i = this.argumentsTypes.length - 1; matches && i >= 0; --i) {
                if (this.argumentsTypes[i] == null) continue;
                WrapperTypeSpec formalArgType = this.argumentsTypes[i];
                TypeSpec actualArgType = callArgTypes[i];
                if (TapEnv.relatedLanguageIsFortran() && actualArgType != null && actualArgType.isPointer() && !((TypeSpec)formalArgType).isPointer()) {
                    actualArgType = actualArgType.peelPointer();
                }
                matches = formalArgType.receivesNoVectorNeglectSizes(actualArgType, null, null);
            }
        }
        return matches;
    }

    public boolean matchesCallExactly(TypeSpec callResultType, TypeSpec[] callArgTypes) {
        boolean matches = true;
        if (this.argumentsTypes != null && callArgTypes != null) {
            matches = this.argumentsTypes.length == callArgTypes.length;
            for (int i = this.argumentsTypes.length - 1; matches && i >= 0; --i) {
                if (this.argumentsTypes[i] == null) continue;
                WrapperTypeSpec formalArgType = this.argumentsTypes[i];
                TypeSpec actualArgType = callArgTypes[i];
                if (TapEnv.relatedLanguageIsFortran() && actualArgType != null && actualArgType.isPointer() && !((TypeSpec)formalArgType).isPointer()) {
                    actualArgType = actualArgType.peelPointer();
                }
                matches = formalArgType.equalsNeglectSizes(actualArgType);
            }
        }
        return matches;
    }

    @Override
    protected boolean testComparesWith(TypeSpec other, int comparison, TypeSpec toThis, TypeSpec toOther, TapList<TapPair<TypeSpec, TypeSpec>> dejaVu) {
        int i;
        if ((toOther = this.peelWrapperAndModifiedTo(other, toOther)) != null) {
            other = toOther.wrappedType();
        }
        if (this == other) {
            return true;
        }
        if (other == null) {
            if (FunctionTypeSpec.testHasInference(comparison) && FunctionTypeSpec.testIsEquals(comparison)) {
                if (toOther != null) {
                    toOther.setWrappedType(this);
                }
                return true;
            }
            return FunctionTypeSpec.testAcceptsUnspecified(comparison);
        }
        if (!(other instanceof FunctionTypeSpec)) {
            return false;
        }
        FunctionTypeSpec otherFunctionType = (FunctionTypeSpec)other;
        boolean comparesWell = true;
        if (this.argumentsTypes == null) {
            if (FunctionTypeSpec.testHasInference(comparison)) {
                if (otherFunctionType.argumentsTypes != null) {
                    this.argumentsTypes = new WrapperTypeSpec[otherFunctionType.argumentsTypes.length];
                    for (i = this.argumentsTypes.length - 1; i >= 0; --i) {
                        this.argumentsTypes[i] = new WrapperTypeSpec(null);
                    }
                }
            } else {
                comparesWell = FunctionTypeSpec.testAcceptsUnspecified(comparison);
            }
        } else if (otherFunctionType.argumentsTypes == null) {
            if (FunctionTypeSpec.testHasInference(comparison)) {
                otherFunctionType.argumentsTypes = new WrapperTypeSpec[this.argumentsTypes.length];
                for (i = this.argumentsTypes.length - 1; i >= 0; --i) {
                    otherFunctionType.argumentsTypes[i] = new WrapperTypeSpec(null);
                }
            } else {
                comparesWell = false;
            }
        } else {
            boolean bl = comparesWell = this.argumentsTypes.length == otherFunctionType.argumentsTypes.length;
        }
        if (this.argumentsTypes != null) {
            for (i = this.argumentsTypes.length - 1; comparesWell && i >= 0; --i) {
                if (this.argumentsTypes[i] == null) {
                    if (FunctionTypeSpec.testHasInference(comparison)) {
                        WrapperTypeSpec otherArgType = otherFunctionType.argumentsTypes[i];
                        this.argumentsTypes[i].setWrappedType(otherArgType);
                        continue;
                    }
                    comparesWell = FunctionTypeSpec.testAcceptsUnspecified(comparison);
                    continue;
                }
                if (otherFunctionType.argumentsTypes[i] == null) {
                    if (FunctionTypeSpec.testHasInference(comparison)) {
                        otherFunctionType.argumentsTypes[i].setWrappedType(this.argumentsTypes[i].weakenForInference(comparison));
                        continue;
                    }
                    comparesWell = false;
                    continue;
                }
                comparesWell = otherFunctionType.argumentsTypes[i].comparesWith(this.argumentsTypes[i], comparison, null, null, dejaVu);
            }
        }
        if (comparesWell) {
            if (this.returnType == null) {
                if (FunctionTypeSpec.testHasInference(comparison)) {
                    WrapperTypeSpec otherReturnType = otherFunctionType.returnType;
                    this.setWrappedType(otherReturnType == null ? null : ((TypeSpec)otherReturnType).weakenForInference(comparison));
                } else {
                    comparesWell = FunctionTypeSpec.testAcceptsUnspecified(comparison);
                }
            } else if (otherFunctionType.returnType == null) {
                if (FunctionTypeSpec.testHasInference(comparison)) {
                    otherFunctionType.setWrappedType(this.returnType);
                } else {
                    comparesWell = false;
                }
            } else {
                comparesWell = this.returnType.comparesWith(otherFunctionType.returnType, comparison, this, otherFunctionType, dejaVu);
            }
        }
        return comparesWell;
    }

    public boolean sameTypes(WrapperTypeSpec otherReturnType, WrapperTypeSpec[] otherArgumentsTypes) {
        boolean matches;
        boolean bl = matches = this.argumentsTypes == null && otherArgumentsTypes == null;
        if (otherArgumentsTypes != null && this.argumentsTypes != null) {
            boolean bl2 = matches = otherArgumentsTypes.length == this.argumentsTypes.length;
            if (matches) {
                for (int i = 0; i < otherArgumentsTypes.length; ++i) {
                    boolean argMatches;
                    if (otherArgumentsTypes[i] == null) {
                        argMatches = true;
                    } else {
                        WrapperTypeSpec otherArgType = otherArgumentsTypes[i];
                        WrapperTypeSpec thisArgType = this.argumentsTypes[i];
                        if (FunctionTypeSpec.isA(otherArgType, 6) && !FunctionTypeSpec.isA(thisArgType, 6) && !thisArgType.isMetaType()) {
                            otherArgType = ((PointerTypeSpec)otherArgType.wrappedType).destinationType;
                        }
                        if (FunctionTypeSpec.isA(otherArgType, 2) && FunctionTypeSpec.isA(thisArgType, 2)) {
                            thisArgType = thisArgType.wrappedType.elementType();
                            otherArgType = otherArgType.wrappedType.elementType();
                        }
                        argMatches = thisArgType.wrappedType == null || otherArgType.wrappedType == null || otherArgType.equalsCompilIndep(thisArgType);
                    }
                    matches = argMatches && matches;
                }
            }
        }
        return matches;
    }

    protected void matchArgumentsTypes(WrapperTypeSpec[] actualArgsTypes, Unit ctxtUnit, Unit calledUnit) {
        for (int i = 0; i < this.argumentsTypes.length && i < actualArgsTypes.length; ++i) {
            WrapperTypeSpec localFormalType = this.argumentsTypes[i];
            if (localFormalType == null) continue;
            WrapperTypeSpec actualArgType = actualArgsTypes[i];
            if ((ctxtUnit == null || ctxtUnit.isFortran9x()) && FunctionTypeSpec.isA(actualArgType, 6) && calledUnit.isIntrinsic()) {
                actualArgType = ((PointerTypeSpec)actualArgType.wrappedType).destinationType;
            }
            boolean alreadyUnified = false;
            if (FunctionTypeSpec.isA(localFormalType, 2)) {
                ArrayTypeSpec localFormalArrayType = (ArrayTypeSpec)localFormalType.wrappedType;
                if (WrapperTypeSpec.isFree(localFormalArrayType.elementType())) {
                    if (FunctionTypeSpec.isA(actualArgType, 2)) {
                        localFormalArrayType.setElementType(actualArgType.wrappedType.elementType());
                    } else {
                        localFormalArrayType.setElementType(actualArgType);
                    }
                    alreadyUnified = true;
                }
                if ((localFormalArrayType.dimensions() == null || localFormalArrayType.dimensions().length == 0) && FunctionTypeSpec.isA(actualArgType, 2)) {
                    localFormalArrayType.setDimensions(((ArrayTypeSpec)actualArgType.wrappedType).dimensions());
                }
            }
            if (actualArgType == null || alreadyUnified) continue;
            boolean canRefine = localFormalType.receives(actualArgType, null, null);
            if (!canRefine) {
                canRefine = actualArgType.receives(localFormalType, null, null);
            }
            if (!canRefine) continue;
            FunctionTypeSpec.refineFormalWithActual(localFormalType, actualArgType, null);
        }
    }

    @Override
    public TypeSpec wrappedType() {
        return this.returnType;
    }

    @Override
    public void setWrappedType(TypeSpec type) {
        this.returnType = type instanceof WrapperTypeSpec ? (WrapperTypeSpec)type : new WrapperTypeSpec(type);
    }

    @Override
    protected String baseTypeName() {
        return "";
    }

    @Override
    public WrapperTypeSpec baseTypeSpec(boolean stopOnPointer) {
        return this.returnType.baseTypeSpec(stopOnPointer);
    }

    @Override
    public boolean containsUnknownDimension() {
        return this.returnType != null && this.returnType.containsUnknownDimension();
    }

    @Override
    public void doUpdateAfterImports(SymbolTable symbolTable, TapList<TypeSpec> dejaVu) {
        if (this.argumentsTypes != null) {
            for (int i = this.argumentsTypes.length - 1; i >= 0; --i) {
                if (this.argumentsTypes[i] == null) continue;
                this.argumentsTypes[i].updateAfterImports(symbolTable, dejaVu);
            }
        }
        if (this.returnType != null) {
            this.returnType.updateAfterImports(symbolTable, dejaVu);
        }
    }

    @Override
    protected int computeSize() {
        return this.returnType.size();
    }

    @Override
    public boolean isFunction() {
        return true;
    }

    @Override
    public TypeSpec copy() {
        FunctionTypeSpec result = new FunctionTypeSpec();
        if (this.returnType != null) {
            result.returnType = new WrapperTypeSpec(this.returnType.wrappedType);
        }
        if (this.argumentsTypes != null) {
            result.argumentsTypes = new WrapperTypeSpec[this.argumentsTypes.length];
            for (int i = 0; i < this.argumentsTypes.length; ++i) {
                result.argumentsTypes[i] = new WrapperTypeSpec(this.argumentsTypes[i].wrappedType);
            }
        }
        result.variableArgList = this.variableArgList;
        return result;
    }

    @Override
    public TypeSpec copyStopOnComposite(Unit publishedUnit) {
        return this;
    }

    @Override
    protected boolean containsMetaType(TapList<TypeSpec> dejaVu) {
        boolean contains;
        if (TapList.contains(dejaVu, this)) {
            return false;
        }
        dejaVu = new TapList<TypeSpec>(this, dejaVu);
        boolean bl = contains = this.returnType != null && this.returnType.containsMetaType(dejaVu);
        if (this.argumentsTypes != null) {
            for (int i = 0; !contains && i < this.argumentsTypes.length; ++i) {
                if (this.argumentsTypes[i] == null) continue;
                contains = this.argumentsTypes[i].containsMetaType(dejaVu);
            }
        }
        return contains;
    }

    @Override
    public TypeSpec localize(TapList<TapTriplet<TypeSpec, TypeSpec, Boolean>> toAlreadyCopied, ToBool containsMeta) {
        FunctionTypeSpec copiedResult = (FunctionTypeSpec)this.findAlreadyCopiedType(toAlreadyCopied, containsMeta);
        if (copiedResult == null) {
            copiedResult = new FunctionTypeSpec(null, this.argumentsTypes == null ? null : new WrapperTypeSpec[this.argumentsTypes.length], this.variableArgList);
            copiedResult.setOrAddTypeDeclName(this.typeDeclName());
            TapTriplet<FunctionTypeSpec, FunctionTypeSpec, Boolean> alreadyRef = new TapTriplet<FunctionTypeSpec, FunctionTypeSpec, Boolean>(this, copiedResult, Boolean.FALSE);
            toAlreadyCopied.placdl(alreadyRef);
            if (this.returnType != null) {
                copiedResult.returnType = (WrapperTypeSpec)this.returnType.localize(toAlreadyCopied, containsMeta);
            }
            if (this.argumentsTypes != null) {
                for (int i = this.argumentsTypes.length - 1; i >= 0; --i) {
                    if (this.argumentsTypes[i] == null) {
                        copiedResult.argumentsTypes[i] = null;
                        continue;
                    }
                    ToBool subTypeContainsMeta = new ToBool(false);
                    copiedResult.argumentsTypes[i] = (WrapperTypeSpec)this.argumentsTypes[i].localize(toAlreadyCopied, subTypeContainsMeta);
                    if (!subTypeContainsMeta.get()) continue;
                    containsMeta.set(true);
                }
            }
            if (containsMeta.get()) {
                alreadyRef.third = Boolean.TRUE;
            } else {
                alreadyRef.first = null;
            }
        }
        return copiedResult;
    }

    @Override
    public WrapperTypeSpec differentiateTypeSpec(SymbolTable symbolTable, SymbolTable srcSymbolTable, int diffUnitSort, String fSuffix, boolean localDecl, boolean multiDirMode, ArrayDim multiDirDimensionMax, String hintArrayNameInText, String hintArrayNameInIdent, Tree hintArrayNameTree, Tree nameTree) {
        WrapperTypeSpec result = null;
        if (TapEnv.associationByAddress()) {
            result = this.diffTypeSpec = new WrapperTypeSpec(this);
        }
        return result;
    }

    @Override
    protected boolean checkTypeSpecValidity(TapList<TypeSpec> dejaVu) {
        if (this.returnType != null && this.returnType.wrappedType == this) {
            TapEnv.fileWarning(15, null, "(TC41) Illegal recursive type definition " + this.showType());
            return false;
        }
        if (this.returnType != null && !this.returnType.checkTypeSpecValidity(dejaVu)) {
            return false;
        }
        if (this.argumentsTypes != null) {
            for (int i = this.argumentsTypes.length - 1; i >= 0; --i) {
                if (this.argumentsTypes[i] == null || this.argumentsTypes[i].checkTypeSpecValidity(dejaVu)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean complexAbsAmbiguous(String unitName, TypeSpec[] formalArgsTypes, TypeSpec[] actualArgsTypes) {
        return ("abs".equals(unitName) || "dabs".equals(unitName)) && formalArgsTypes != null && formalArgsTypes[0] != null && formalArgsTypes[0].isComplexBase() && actualArgsTypes != null && actualArgsTypes[0] != null && !actualArgsTypes[0].isComplexBase();
    }

    @Override
    public Tree generateTree(SymbolTable symbolTable, TapList<SymbolDecl> dependsOn, TapList<SymbolDecl> shortNames, boolean useShortNames, TapList<TypeSpec> dejaVu) {
        Tree result;
        if (TapList.contains(dejaVu, this)) {
            TapEnv.toolWarning(-1, "(TypeSpec tree regeneration) circular type");
            result = ILUtils.build(96, "CircularType");
        } else {
            dejaVu = new TapList<TypeSpec>(this, dejaVu);
            result = ILUtils.build(91, this.returnType.generateTree(symbolTable, null, shortNames, true, dejaVu), ILUtils.build(8));
            if (this.argumentsTypes != null) {
                for (int i = 0; i < this.argumentsTypes.length; ++i) {
                    result.down(2).setChild(this.argumentsTypes[i].generateTree(symbolTable, null, shortNames, true, dejaVu), i + 1);
                }
            }
            if (this.variableArgList) {
                result.down(2).addChild(ILUtils.build(203), result.down(2).length() + 1);
            }
        }
        return result;
    }

    @Override
    public String showType() {
        String argsString;
        if (this.argumentsTypes == null) {
            argsString = "??";
        } else {
            argsString = this.variableArgList ? "...)" : ")";
            for (int i = this.argumentsTypes.length - 1; i >= 0; --i) {
                String string = argsString = this.argumentsTypes[i] == null ? "?" : this.argumentsTypes[i].showType() + argsString;
                if (i <= 0) continue;
                argsString = "," + argsString;
            }
            argsString = "(" + argsString;
        }
        return argsString + "=>" + (this.returnType == null ? "?" : this.returnType.showType());
    }

    @Override
    public void dump() throws IOException {
        TapEnv.print(this.toString());
    }

    @Override
    public String toString() {
        StringBuilder argsString;
        if (this.argumentsTypes == null) {
            argsString = new StringBuilder("??");
        } else {
            argsString = new StringBuilder(this.variableArgList ? "...)" : ")");
            for (int i = this.argumentsTypes.length - 1; i >= 0; --i) {
                argsString.insert(0, this.argumentsTypes[i]);
                if (i <= 0) continue;
                argsString.insert(0, ",");
            }
            argsString.insert(0, "(");
        }
        return (this.typeDeclName() == null ? "" : "\"" + this.typeDeclName() + "\":") + argsString + "=>" + (this.returnType == null ? "?" : this.returnType.toString());
    }
}

