/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.representation;

import fr.inria.tapenade.analysis.ActivityPattern;
import fr.inria.tapenade.representation.CallGraph;
import fr.inria.tapenade.representation.FunctionTypeSpec;
import fr.inria.tapenade.representation.NewSymbolHolder;
import fr.inria.tapenade.representation.SymbolDecl;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.TypeSpec;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.representation.WrapperTypeSpec;
import fr.inria.tapenade.utils.TapPair;
import fr.inria.tapenade.utils.ToBool;
import fr.inria.tapenade.utils.ToObject;
import fr.inria.tapenade.utils.Tree;

public final class FunctionDecl
extends SymbolDecl {
    public int formalArgRank = -1;
    private TapList zones;
    public SymbolTable definitionSymbolTable;
    public Tree declarator;
    public FunctionDecl[] initFunctionDecls;
    private ToObject<Unit> toUnit = new ToObject<Object>(null);
    private TapList<TapPair<ActivityPattern, NewSymbolHolder>>[] funcDiffSymbolHolders;
    private NewSymbolHolder funcCopySymbolHolder = null;

    public FunctionDecl() {
    }

    public FunctionDecl(Tree identTree, Unit unit) {
        super(identTree, 3);
        this.toUnit.setObj(unit);
    }

    public FunctionDecl(Tree identTree, Unit unit, SymbolTable symbolTable) {
        super(identTree, 3);
        this.toUnit.setObj(unit);
        this.definitionSymbolTable = symbolTable;
    }

    public FunctionDecl(Tree identTree, Unit unit, SymbolTable symbolTable, String className) {
        super(identTree, 3);
        this.className = className;
        this.toUnit.setObj(unit);
        this.definitionSymbolTable = symbolTable;
    }

    public Unit unit() {
        return this.toUnit.obj();
    }

    public void setUnit(Unit unit) {
        this.toUnit.setObj(unit);
    }

    public void shareUnitFrom(FunctionDecl otherFunctionDecl) {
        this.toUnit = otherFunctionDecl.toUnit;
    }

    public void deleteUnitIfDifferent(Unit otherUnit, CallGraph callGraph) {
        if (this.toUnit.obj() != null && this.toUnit.obj() != otherUnit && !this.toUnit.obj().isInterface()) {
            callGraph.deleteUnit(this.toUnit.obj());
            this.toUnit.setObj(null);
        }
    }

    @Override
    public boolean isTarget(WrapperTypeSpec modelTypeSpec) {
        if (this.type() == null) {
            return false;
        }
        if (modelTypeSpec == null || modelTypeSpec.wrappedType == null) {
            return true;
        }
        return modelTypeSpec.canMatchPointerTo(this.type());
    }

    @Override
    public WrapperTypeSpec type() {
        if (this.toUnit.obj() == null) {
            return null;
        }
        FunctionTypeSpec functionType = this.toUnit.obj().functionTypeSpec();
        return functionType == null ? null : new WrapperTypeSpec(functionType);
    }

    @Override
    public TapList zones() {
        return this.zones;
    }

    @Override
    public void setZones(TapList intTree) {
        this.zones = intTree;
    }

    public FunctionTypeSpec functionTypeSpec() {
        return this.toUnit.obj() == null ? null : this.toUnit.obj().functionTypeSpec();
    }

    @Override
    public void accumulateZones(TapList intTree) {
        this.zones = intTree;
    }

    @Override
    public int formalArgRankOrResultZero() {
        return this.formalArgRank;
    }

    public WrapperTypeSpec[] argumentsTypesSpec() {
        FunctionTypeSpec functionType = this.functionTypeSpec();
        return functionType == null ? null : functionType.argumentsTypes;
    }

    public WrapperTypeSpec returnTypeSpec() {
        FunctionTypeSpec functionType = this.functionTypeSpec();
        return functionType == null ? null : functionType.returnType;
    }

    public boolean isStandard() {
        return this.toUnit.obj() != null && this.toUnit.obj().isStandard();
    }

    @Override
    public boolean isExternal() {
        return this.toUnit.obj() != null && this.toUnit.obj().isExternal();
    }

    public boolean isIntrinsic() {
        return this.toUnit.obj() != null && this.toUnit.obj().isIntrinsic();
    }

    public boolean isVarFunction() {
        return this.toUnit.obj() != null && this.toUnit.obj().isVarFunction();
    }

    public boolean isInterface() {
        return this.toUnit.obj() != null && this.toUnit.obj().isInterface();
    }

    public boolean isRenamed() {
        return this.toUnit.obj() != null && this.toUnit.obj().isRenamed();
    }

    public boolean isElemental() {
        return this.toUnit.obj() != null && this.toUnit.obj().isElemental();
    }

    public boolean isIntrinsicNotElemental() {
        return this.toUnit.obj() != null && this.toUnit.obj().isIntrinsicNotElemental();
    }

    public boolean isModule() {
        return this.toUnit.obj() != null && this.toUnit.obj().isModule();
    }

    public boolean declarationMatchesCall(TypeSpec callResultType, TypeSpec[] callArgTypes) {
        if (this.toUnit.obj() != null && this.toUnit.obj().functionTypeSpec() != null) {
            FunctionTypeSpec funcTypeSpec = this.toUnit.obj().functionTypeSpec();
            return (funcTypeSpec = (FunctionTypeSpec)funcTypeSpec.localize(new TapList<Object>(null, null), new ToBool(false))).matchesCall(callResultType, callArgTypes) && !FunctionTypeSpec.complexAbsAmbiguous(this.toUnit.obj().name(), funcTypeSpec.argumentsTypes, callArgTypes);
        }
        return false;
    }

    public boolean sameTypes(WrapperTypeSpec otherReturnType, WrapperTypeSpec[] otherArgumentsTypes) {
        if (this.toUnit.obj() != null && this.toUnit.obj().functionTypeSpec() != null) {
            return this.toUnit.obj().functionTypeSpec().sameTypes(otherReturnType, otherArgumentsTypes);
        }
        return false;
    }

    @Override
    public void setDiffSymbolHolder(int diffSort, ActivityPattern pattern, int replica, NewSymbolHolder nSH) {
        if (!this.isModule()) {
            if (this.funcDiffSymbolHolders == null) {
                this.funcDiffSymbolHolders = new TapList[4];
            }
            if (diffSort == 0) {
                if (this.funcCopySymbolHolder == null) {
                    this.funcCopySymbolHolder = nSH;
                }
            } else {
                TapList newSymbolHolders = this.funcDiffSymbolHolders[diffSort - 1];
                TapPair<ActivityPattern, Object> forThisPattern = TapList.assq(pattern, newSymbolHolders);
                if (forThisPattern == null) {
                    forThisPattern = new TapPair<ActivityPattern, Object>(pattern, null);
                    this.funcDiffSymbolHolders[diffSort - 1] = new TapList(forThisPattern, newSymbolHolders);
                }
                forThisPattern.second = nSH;
            }
        } else {
            super.setDiffSymbolHolder(diffSort, null, 0, nSH);
        }
    }

    @Override
    public NewSymbolHolder getDiffSymbolHolder(int diffSort, ActivityPattern pattern, int replica) {
        if (!this.isModule()) {
            if (diffSort == 0) {
                return this.funcCopySymbolHolder;
            }
            if (this.funcDiffSymbolHolders == null || this.funcDiffSymbolHolders.length < diffSort) {
                return null;
            }
            TapList newSymbolHolders = this.funcDiffSymbolHolders[diffSort - 1];
            if (pattern == null) {
                return newSymbolHolders == null ? null : (NewSymbolHolder)((TapPair)newSymbolHolders.head).second;
            }
            return (NewSymbolHolder)TapList.cassq(pattern, newSymbolHolders);
        }
        return super.getDiffSymbolHolder(diffSort, pattern, replica);
    }

    @Override
    public boolean hasDiffSymbolHolders() {
        return this.funcDiffSymbolHolders != null || this.funcCopySymbolHolder != null || super.hasDiffSymbolHolders();
    }

    @Override
    protected void replaceDiffSymbolHolder(NewSymbolHolder oldNSH, NewSymbolHolder newNSH) {
        if (!this.isModule()) {
            if (this.funcDiffSymbolHolders != null) {
                for (int i = this.funcDiffSymbolHolders.length - 1; i >= 0; --i) {
                    TapList<TapPair<ActivityPattern, NewSymbolHolder>> newSymbolHolders = this.funcDiffSymbolHolders[i];
                    while (newSymbolHolders != null) {
                        TapPair activityToHolder = (TapPair)newSymbolHolders.head;
                        if (activityToHolder.second == oldNSH) {
                            activityToHolder.second = newNSH;
                        }
                        newSymbolHolders = newSymbolHolders.tail;
                    }
                }
            }
            if (this.funcCopySymbolHolder == oldNSH) {
                this.funcCopySymbolHolder = newNSH;
            }
        } else {
            super.replaceDiffSymbolHolder(oldNSH, newNSH);
        }
    }

    @Override
    protected void eraseDiffSymbolHolder(int diffSort) {
        if (!this.isModule()) {
            if (diffSort == 0 && this.funcCopySymbolHolder != null) {
                this.funcCopySymbolHolder = null;
            }
        } else {
            super.eraseDiffSymbolHolder(diffSort);
        }
    }

    @Override
    public String toString() {
        return this.symbol + ": " + (this.toUnit.obj() == null ? "unspecified function." : (this.toUnit.obj().isModule() ? "module " + this.toUnit.obj() : (this.toUnit.obj().isIntrinsic() ? "intrinsic " : "") + (this.toUnit.obj().isInterface() ? "interfaceinterface " : "") + (this.toUnit.obj().isVarFunction() ? "varfunction " : "") + (this.toUnit.obj().isExternal() ? "external " : "") + (this.toUnit.obj().isElemental() ? "elemental " : "") + (this.toUnit.obj().functionTypeSpec() == null ? "null_type" : this.toUnit.obj().functionTypeSpec()) + " function") + this.toUnit.obj() + ".") + (this.importedFrom == null ? "" : " (=> @" + Integer.toHexString(((SymbolDecl)this.importedFrom.first).hashCode()) + " from @" + Integer.toHexString(((SymbolTable)this.importedFrom.second).hashCode()) + ")") + (!this.isActiveSymbolDecl() ? "" : " Active") + (this.extraInfo() == null ? "" : " X" + this.extraInfo()) + " depends on:" + this.dependsOn();
    }
}

