/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.representation;

import fr.inria.tapenade.representation.CallGraph;
import fr.inria.tapenade.representation.FunctionDecl;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.InFunction;
import fr.inria.tapenade.representation.Instruction;
import fr.inria.tapenade.representation.MemoryMaps;
import fr.inria.tapenade.representation.SymbolDecl;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.TypeDecl;
import fr.inria.tapenade.representation.TypeSpec;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.representation.VariableDecl;
import fr.inria.tapenade.representation.WrapperTypeSpec;
import fr.inria.tapenade.utils.TapPair;
import fr.inria.tapenade.utils.Tree;

public final class FortranStuff {
    public Unit unit = null;
    public CallGraph callGraph = null;
    public SymbolTable refSymbolTable = null;
    protected TapList<Tree> statementFunctions;
    protected String publicPrivateDefault;
    protected TapList<TapPair<String, Instruction>> implicitDeclarations;
    private boolean checkArrayAccessOrCall = true;
    public TapList<TapPair<Tree, SymbolTable>> listFortranCEDS;
    private boolean saveAll;
    private TapList<TapPair<SymbolTable, Tree>> bindCDeclarationList;

    public static void initFortranSymbolTable(SymbolTable symbolTable) {
        symbolTable.setImplicitLetters('a', 'h', symbolTable.getTypeDecl((String)"float").typeSpec);
        symbolTable.setImplicitLetters('i', 'n', symbolTable.getTypeDecl((String)"integer").typeSpec);
        symbolTable.setImplicitLetters('o', 'z', symbolTable.getTypeDecl((String)"float").typeSpec);
    }

    protected void activateArrayAccessOrCall(boolean val) {
        this.checkArrayAccessOrCall = val;
    }

    protected void collectFortranCEDSForLater(Instruction instr, SymbolTable symbolTable) {
        this.listFortranCEDS = new TapList<TapPair<Tree, SymbolTable>>(new TapPair<Tree, SymbolTable>(instr.tree, symbolTable), this.listFortranCEDS);
        this.processVarsInFortranCEDS(instr.tree, symbolTable, instr);
    }

    private void processVarsInFortranCEDS(Tree declTree, SymbolTable symbolTable, Instruction instr) {
        switch (declTree.opCode()) {
            case 2: {
                break;
            }
            case 171: {
                Tree[] subDecls;
                for (Tree subDecl : subDecls = declTree.children()) {
                    this.processVarsInFortranCEDS(subDecl, symbolTable, instr);
                }
                break;
            }
            case 51: {
                Tree[] subDecls;
                for (Tree subDecl : subDecls = declTree.down(1).children()) {
                    Tree subDecli = ILUtils.baseTree(subDecl);
                    assert (subDecli != null);
                    this.processVarsInFortranCEDS(subDecli, symbolTable, instr);
                }
                break;
            }
            case 39: {
                Tree[] subDecls;
                for (Tree subDecl : subDecls = declTree.down(2).children()) {
                    this.processVarsInFortranCEDS(subDecl, symbolTable, instr);
                }
                break;
            }
            case 60: 
            case 69: 
            case 71: {
                Tree[] subDecls = declTree.children();
                for (int i = subDecls.length - 1; i >= 0; --i) {
                    this.processVarsInFortranCEDS(subDecls[i], symbolTable, instr);
                }
                break;
            }
            case 3: 
            case 59: 
            case 62: 
            case 133: 
            case 182: {
                this.processVarsInFortranCEDS(declTree.down(1), symbolTable, instr);
                this.processVarsInFortranCEDS(declTree.down(2), symbolTable, instr);
                break;
            }
            case 9: 
            case 11: 
            case 183: {
                this.processVarsInFortranCEDS(declTree.down(2), symbolTable, instr);
            }
            case 96: {
                boolean InEquivalence;
                String name = ILUtils.baseName(declTree);
                assert (name != null);
                VariableDecl variableDecl = symbolTable.getVariableOrConstantDecl(name);
                boolean isCommonName = false;
                if (variableDecl == null) {
                    boolean bl = isCommonName = this.callGraph.isCommonName(name) || instr != null && instr.tree != null && instr.tree.opCode() == 171 && name.startsWith("/") && name.endsWith("/");
                }
                if (isCommonName) break;
                boolean bl = InEquivalence = instr != null && instr.tree != null && instr.tree.opCode() == 69;
                if (!InEquivalence && variableDecl != this.refSymbolTable.getTopVariableOrConstantDecl(name)) {
                    symbolTable.moveSymbolDeclListUpRec(new TapList<SymbolDecl>(variableDecl, null), this.refSymbolTable);
                }
                SymbolDecl newVariableDecl = SymbolDecl.build(new WrapperTypeSpec(null), null, false, declTree, 1, symbolTable, instr, null);
                assert (newVariableDecl != null);
                if (!InEquivalence) {
                    symbolTable.moveSymbolDeclListUpRec(newVariableDecl.dependsOn(), this.refSymbolTable);
                }
                if (newVariableDecl.isA(1)) {
                    ((VariableDecl)newVariableDecl).isVariableName = true;
                }
                SymbolTable targetSymbolTable = InEquivalence ? symbolTable : this.refSymbolTable;
                targetSymbolTable.addSymbolDecl(newVariableDecl);
                VariableDecl publicVariableDecl = targetSymbolTable.getTopVariableDecl(newVariableDecl.symbol);
                if (publicVariableDecl == null || instr == null || instr.tree == null || instr.tree.opCode() != 39) break;
                publicVariableDecl.setCommonInstr(true);
                if (!ILUtils.containsArrayDeclarator(publicVariableDecl, instr.tree)) break;
                publicVariableDecl.setCommonWithArrayDeclaratorInstr(true);
                break;
            }
            case 103: {
                break;
            }
            case 124: {
                this.processVarsInFortranCEDS(declTree.down(1), symbolTable, instr);
                break;
            }
            default: {
                TapEnv.toolWarning(-1, "(declare COMMON or EQUIVALENCE) Unexpected operator: " + declTree.opName());
            }
        }
    }

    private void declareCommonEquivsSaveRec(VariableDecl variableDecl, SymbolTable symbolTable) {
        if (variableDecl != this.refSymbolTable.getTopVariableDecl(variableDecl.symbol)) {
            symbolTable.moveSymbolDeclListUpRec(new TapList<SymbolDecl>(variableDecl, null), this.refSymbolTable);
        }
        SymbolDecl newVariableDecl = SymbolDecl.build(new WrapperTypeSpec(null), null, false, ILUtils.build(96, variableDecl.symbol), 1, symbolTable, null, null);
        symbolTable.moveSymbolDeclListUpRec(variableDecl.dependsOn(), this.refSymbolTable);
        assert (newVariableDecl != null);
        if (newVariableDecl.isA(1)) {
            ((VariableDecl)newVariableDecl).isVariableName = true;
        }
        this.refSymbolTable.addSymbolDecl(newVariableDecl);
    }

    private Tree[] getSavedVars(Tree saveOrDataTree) {
        Tree[] results = null;
        if (saveOrDataTree.opCode() == 171) {
            results = saveOrDataTree.children();
        } else if (saveOrDataTree.opCode() == 51) {
            results = saveOrDataTree.down(1).children();
            for (int i = 0; i < results.length; ++i) {
                results[i] = ILUtils.baseTree(results[i]);
            }
        }
        return results;
    }

    protected void setSaveAll() {
        this.saveAll = true;
    }

    protected boolean getSaveAll() {
        return this.saveAll;
    }

    protected void computeSaveVarDecls(SymbolTable symbolTable, TapList<SymbolDecl> varDecls) {
        while (varDecls != null) {
            TapList<FunctionDecl> funDecls = symbolTable.getTopFunctionDecl(((SymbolDecl)varDecls.head).symbol, null, null, false);
            if (funDecls == null) {
                this.computeSaveVarDecl(symbolTable, (VariableDecl)varDecls.head);
            }
            varDecls = varDecls.tail;
        }
    }

    protected void computeSaveVarDecl(SymbolTable symbolTable, VariableDecl varDecl) {
        if (varDecl.formalArgRank < 0) {
            this.listFortranCEDS = new TapList<TapPair<Tree, SymbolTable>>(new TapPair<Tree, SymbolTable>(ILUtils.build(171, ILUtils.build(96, varDecl.symbol)), symbolTable), this.listFortranCEDS);
            this.declareCommonEquivsSaveRec(varDecl, symbolTable);
        }
    }

    protected Tree checkArrayAccessOrCall(SymbolTable symbolTable, Tree tree) {
        Tree result = tree;
        if (this.checkArrayAccessOrCall) {
            SymbolDecl symbolDecl;
            Tree arrayTree;
            boolean hasNoPointerAccess;
            boolean hasNoTriplet = !ILUtils.oneIsArrayTriplet(tree.down(2));
            boolean bl = hasNoPointerAccess = tree.down(1).opCode() != 151;
            if (hasNoTriplet && hasNoPointerAccess && (arrayTree = tree.down(1)).isAtom() && (!((symbolDecl = symbolTable.getSymbolDecl(arrayTree.stringValue())) instanceof VariableDecl) || !((VariableDecl)symbolDecl).isVariableName && !WrapperTypeSpec.hasAnArrayDimension(symbolDecl.type()))) {
                TypeDecl typeDecl = symbolTable.getTypeDecl(arrayTree.stringValue());
                result = typeDecl != null && TypeSpec.isA(typeDecl.typeSpec, 21) ? ILUtils.build(47, ILUtils.copy(tree.down(1)), ILUtils.copy(tree.down(1)), ILUtils.reverseArrayComponentOrder(tree.down(2))) : ILUtils.buildCall(ILUtils.copy(tree.down(1)), ILUtils.reverseArrayComponentOrder(tree.down(2)));
            }
        }
        return result;
    }

    protected static boolean isStatementFunctionDecl(SymbolTable symbolTable, Tree tree) {
        VariableDecl variableDecl;
        return tree.opCode() == 14 && tree.down(1).opCode() == 9 && tree.down(1).down(1).isAtom() && ((variableDecl = symbolTable.getVariableDecl(tree.down(1).down(1).stringValue())) == null || variableDecl.type() != null && variableDecl.type().wrappedType != null && !TypeSpec.isA(variableDecl.type().peelPointer(), 2)) && FortranStuff.allPlainIdents(tree.down(1).down(2).children());
    }

    protected boolean checkStatementFunctionDecl(SymbolTable symbolTable, Tree tree) {
        if (FortranStuff.isStatementFunctionDecl(symbolTable, tree)) {
            Tree indices = ILUtils.reverseArrayComponentOrder(tree.down(1).down(2));
            Tree newStmtFunc = ILUtils.build(178, ILUtils.buildCall(ILUtils.copy(tree.down(1).down(1)), indices), ILUtils.copy(tree.down(2)));
            this.statementFunctions = new TapList<Tree>(newStmtFunc, this.statementFunctions);
            return true;
        }
        return false;
    }

    private static boolean allPlainIdents(Tree[] args) {
        boolean result = true;
        for (Tree arg : args) {
            result = arg.opCode() == 96 && result;
        }
        return result;
    }

    protected Tree checkStatementFunctionCall(Tree tree) {
        Tree defTree = null;
        String funName = null;
        if (ILUtils.getCalledName(tree).isAtom()) {
            funName = ILUtils.getCalledName(tree).stringValue();
            defTree = this.getStatementFunctionDecl(funName);
        }
        Tree result = null;
        if (defTree != null) {
            Tree[] vars = ILUtils.getArguments(tree).children();
            Tree[] params = ILUtils.getArguments(defTree.down(1)).children();
            result = ILUtils.copy(defTree);
            assert (result != null);
            result = result.down(2);
            if (vars.length != params.length) {
                TapEnv.fileWarning(15, tree, "(TC32) Conflicting numbers of arguments for statement function " + funName + ", expected " + params.length + ", is here " + vars.length);
            }
            for (int i = 0; i < Math.min(vars.length, params.length); ++i) {
                InFunction.replaceAllIdent(result, params[i], vars[i]);
            }
            result = ILUtils.copy(result);
            ILUtils.setOrigTree(result, tree);
        }
        return result;
    }

    private Tree getStatementFunctionDecl(String functionName) {
        TapList<Tree> inStatementFunctions = this.statementFunctions;
        Tree found = null;
        while (found == null && inStatementFunctions != null) {
            if (ILUtils.getCalledName(((Tree)inStatementFunctions.head).down(1)).stringValue().equals(functionName)) {
                found = (Tree)inStatementFunctions.head;
            }
            inStatementFunctions = inStatementFunctions.tail;
        }
        return found;
    }

    protected void addPublicPrivateDecl(String publicPrivateDecl, Tree instructionTree) {
        if (this.publicPrivateDefault == null) {
            this.publicPrivateDefault = publicPrivateDecl;
        } else {
            TapEnv.fileWarning(5, instructionTree, "(DD18) Incorrect " + publicPrivateDecl + " declaration");
        }
    }

    protected void addBindCDecl(SymbolTable symbolTable, Tree instructionTree) {
        this.bindCDeclarationList = new TapList<TapPair<SymbolTable, Tree>>(new TapPair<SymbolTable, Tree>(symbolTable, instructionTree), this.bindCDeclarationList);
    }

    private String getCNameFromCommon(String commonName) {
        String cName = null;
        TapList<TapPair<SymbolTable, Tree>> bindCList = this.bindCDeclarationList;
        String cNameTmp = commonName.substring(1, commonName.length() - 1);
        if (bindCList == null) {
            cName = this.callGraph.getOtherLanguageName(cNameTmp, 1, 4);
        } else {
            while (bindCList != null && cName == null) {
                Tree bindTree = (Tree)((TapPair)bindCList.head).second;
                int nbVar = 1;
                if (bindTree.opCode() == 199) {
                    nbVar = bindTree.down(3).length();
                }
                for (int i = 1; i <= nbVar; ++i) {
                    String fortranName;
                    if (bindTree.opCode() == 199) {
                        fortranName = ILUtils.baseName(bindTree.down(3).down(i));
                    } else if (bindTree.opCode() == 96) {
                        fortranName = ILUtils.baseName(bindTree);
                        cName = this.callGraph.getOtherLanguageName(cNameTmp, 1, 4);
                    } else {
                        fortranName = ILUtils.baseName(bindTree.down(2).down(i));
                    }
                    assert (fortranName != null);
                    if (cName != null || !fortranName.equals(commonName)) continue;
                    cName = ILUtils.getBindCValue((Tree)((TapPair)bindCList.head).second, i);
                }
                bindCList = bindCList.tail;
            }
        }
        return cName;
    }

    protected void declareBindCInMemoryMap() {
        TapList<TapPair<SymbolTable, Tree>> bindCList = this.bindCDeclarationList;
        VariableDecl cVarDecl = null;
        MemoryMaps globalCMemoryMap = this.callGraph.globalFortranMaps;
        while (bindCList != null) {
            SymbolTable bindST = (SymbolTable)((TapPair)bindCList.head).first;
            Tree bindTree = (Tree)((TapPair)bindCList.head).second;
            int nbVar = 1;
            if (bindTree.opCode() == 199) {
                nbVar = bindTree.down(3).length();
            }
            for (int i = 1; i <= nbVar; ++i) {
                String fortranName;
                if (bindTree.opCode() == 199) {
                    fortranName = ILUtils.baseName(bindTree.down(3).down(i));
                    this.unit.setLanguageAndUp(3);
                    this.unit.translationUnitSymbolTable().setLanguage(3);
                } else if (bindTree.opCode() == 96) {
                    fortranName = bindTree.stringValue();
                } else {
                    fortranName = ILUtils.baseName(bindTree.down(2).down(i));
                    this.unit.setLanguageAndUp(3);
                    this.unit.translationUnitSymbolTable().setLanguage(3);
                }
                assert (fortranName != null);
                VariableDecl fortranVarDecl = bindST.getVariableDecl(fortranName);
                String cName = ILUtils.getBindCValue(bindTree, i);
                if (cName == null) {
                    cName = this.getCNameFromCommon(fortranName);
                }
                if (this.callGraph.cRootSymbolTable() != null) {
                    cVarDecl = this.callGraph.cRootSymbolTable().getVariableDecl(cName);
                }
                if (cVarDecl != null) {
                    if (fortranVarDecl == null) continue;
                    continue;
                }
                TypeDecl fortranTypeDecl = bindST.getTypeDecl(fortranName);
                TapList<SymbolTable> tuSymbolTables = this.callGraph.getTranslationUnitSymbolTables();
                TapList<TypeDecl> cTypeDecls = null;
                while (tuSymbolTables != null) {
                    if (((SymbolTable)tuSymbolTables.head).unit.isC()) {
                        TypeDecl cTypeDecl = ((SymbolTable)tuSymbolTables.head).getTypeDecl(cName);
                        if (cTypeDecl == null) {
                            cTypeDecl = ((SymbolTable)tuSymbolTables.head).getTypeDecl("struct " + cName);
                        }
                        if (cTypeDecl != null) {
                            this.callGraph.addBindFortranCType(fortranTypeDecl, cTypeDecl);
                            cTypeDecls = new TapList<TypeDecl>(cTypeDecl, cTypeDecls);
                        }
                    }
                    tuSymbolTables = tuSymbolTables.tail;
                }
                if (cTypeDecls != null || bindTree.opCode() == 96) continue;
                this.callGraph.addBindFortranCType(fortranTypeDecl, null);
                if (bindTree.down(2).opCode() == 192) continue;
                TapEnv.fileWarning(5, bindTree, "(TC26) bind(C) " + fortranName + " with " + cName + " ignored");
            }
            bindCList = bindCList.tail;
        }
    }
}

