/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.representation;

import fr.inria.tapenade.representation.BasicBlock;
import fr.inria.tapenade.representation.Block;
import fr.inria.tapenade.representation.Directive;
import fr.inria.tapenade.representation.FGArrow;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.Instruction;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.utils.TapIntList;

final class FGThreads {
    private ThreadListCell topCell;

    FGThreads() {
    }

    protected Block block() {
        return this.topCell.block;
    }

    protected void add(Block block, int test, int cas) {
        this.topCell = new ThreadListCell(block, test, cas, this.topCell);
    }

    protected void concat(FGThreads newThreads) {
        if (this.topCell != null) {
            ThreadListCell lastCell = this.topCell;
            while (lastCell.next != null) {
                lastCell = lastCell.next;
            }
            lastCell.next = newThreads.topCell;
        } else {
            this.topCell = newThreads.topCell;
        }
    }

    protected void convergeToBlock(Block destinationBlock, boolean inCycle, boolean traceOn) {
        if (traceOn) {
            TapEnv.printlnOnTrace(" Converge(ToBlock) thread(s): " + (this.topCell == null ? "empty!" : this.detail(this.topCell)));
            TapEnv.printlnOnTrace("  to " + this.showBlockTail(destinationBlock));
        }
        ThreadListCell currentCell = this.topCell;
        boolean isSwitchCase = false;
        while (!isSwitchCase && currentCell != null) {
            isSwitchCase = currentCell.test == 21 && currentCell.cas != -2;
            currentCell = currentCell.next;
        }
        currentCell = this.topCell;
        while (currentCell != null) {
            FGArrow newArrow = new FGArrow(currentCell.block, currentCell.test, currentCell.cas, destinationBlock, inCycle);
            if (isSwitchCase && currentCell.test != 21) {
                newArrow.isAJumpIntoNextCase = true;
            }
            currentCell = currentCell.next;
        }
    }

    protected void convergeToInstr(Instruction instruction, TapList<Block> allBlocks, Unit unit, SymbolTable symbolTable, TapList<Instruction> parallelControls, boolean traceOn) {
        if (traceOn) {
            TapEnv.printlnOnTrace(" Converge(ToInstr) thread(s): " + (this.topCell == null ? "empty!" : this.detail(this.topCell)));
            TapEnv.printlnOnTrace("  to new instruction tree:" + instruction.tree + " of SymbolTable " + symbolTable.addressChain() + " with parallelControls:" + parallelControls);
        }
        assert (this.topCell != null);
        if ((unit.isProcedureWithCode() || unit.isOutsideTBD() || unit.isInterface() || unit.isTranslationUnit()) && (this.topCell.next != null || this.topCell.test != 0 || this.topCell.block.flow() != null || symbolTable != ((ThreadListCell)this.topCell).block.symbolTable || parallelControls != ((ThreadListCell)this.topCell).block.parallelControls || ILUtils.isParallelController(instruction.tree) || Directive.containDirectives(instruction.preComments) || Directive.containDirectives(instruction.preCommentsBlock))) {
            BasicBlock block = new BasicBlock(symbolTable, parallelControls, allBlocks);
            if (symbolTable.declarationsBlock == null) {
                symbolTable.declarationsBlock = block;
            }
            block.addInstrTl(instruction);
            this.convergeToBlock(block, false, traceOn);
            this.topCell = new ThreadListCell(block, 0, 0, null);
        } else if ((symbolTable.unit == null || symbolTable.unit.isFortran()) && instruction.isADeclaration() && instruction.tree.opCode() != 101 && instruction.isUnitDefinitionStub() == null) {
            int movedUp = this.topCell.block.addInstrDeclTlBeforeUse(instruction, this.topCell.block.symbolDeclDeclared(instruction), null, ((ThreadListCell)this.topCell).block.symbolTable, false);
            if (movedUp != 0) {
                TapEnv.fileWarning(15, instruction.tree, "(DD31) Declaration statement " + ILUtils.toString(instruction.tree, symbolTable.language()) + " moved " + movedUp + " declarations up");
            }
        } else {
            this.topCell.block.addInstrTl(instruction);
        }
        if (traceOn) {
            TapEnv.printlnOnTrace(" Yielding new thread(s): " + this.detail(this.topCell));
        }
    }

    protected void reTypeThread(int newTest, int newCas) {
        this.topCell.test = newTest;
        this.topCell.cas = newCas;
    }

    protected void empty() {
        this.topCell = null;
    }

    protected boolean isNotEmpty() {
        return this.topCell != null;
    }

    private String showBlockTail(Block block) {
        TapList<Instruction> instrs = block.instructions;
        if (instrs == null) {
            return "Block@" + Integer.toHexString(block.hashCode()) + "[]";
        }
        if (instrs.tail == null) {
            return "Block@" + Integer.toHexString(block.hashCode()) + "[" + ((Instruction)instrs.head).tree + "]";
        }
        if (instrs.tail.tail == null) {
            return "Block@" + Integer.toHexString(block.hashCode()) + "[" + ((Instruction)instrs.head).tree + " ; " + ((Instruction)instrs.tail.head).tree + "]";
        }
        TapList<Instruction> revInstrs = TapList.reverse(instrs);
        return "Block@" + Integer.toHexString(block.hashCode()) + "[... " + ((Instruction)revInstrs.tail.head).tree + " ; " + ((Instruction)revInstrs.head).tree + "]";
    }

    private String detail(ThreadListCell inThread) {
        String result = "";
        while (inThread != null) {
            result = result + this.showBlockTail(inThread.block) + "==" + FGArrow.testAndCasesToString(inThread.test, new TapIntList(inThread.cas, null)) + "=>";
            if ((inThread = inThread.next) == null) continue;
            result = result + System.lineSeparator() + "                     ";
        }
        return result;
    }

    public String toString() {
        ThreadListCell inThread = this.topCell;
        int length = 0;
        while (inThread != null) {
            inThread = inThread.next;
            ++length;
        }
        return "FGThreads[holds:" + length + "]";
    }

    private static final class ThreadListCell {
        private final Block block;
        private int test;
        private int cas;
        private ThreadListCell next;

        private ThreadListCell(Block block, int test, int cas, ThreadListCell next) {
            this.block = block;
            this.test = test;
            this.cas = cas;
            this.next = next;
        }

        public String toString() {
            return this.block + "//" + this.test + "/" + this.cas + "||" + this.next;
        }
    }
}

