/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.representation;

import fr.inria.tapenade.representation.Block;
import fr.inria.tapenade.representation.FGConstants;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.Instruction;
import fr.inria.tapenade.representation.LoopBlock;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.utils.TapIntList;
import fr.inria.tapenade.utils.TapPair;
import fr.inria.tapenade.utils.Tree;
import java.io.IOException;

public final class FGArrow {
    public Block origin;
    public Block destination;
    public int test;
    public TapIntList cases;
    public int rank;
    public Object carry;
    public TapList<TapPair<Integer, LoopBlock>> iter;
    public boolean inACycle;
    public boolean isAJumpIntoNextCase;
    public boolean reachable = true;

    public FGArrow(Block origin, int test, int cas, Block destination) {
        this.origin = origin;
        this.test = test;
        this.cases = test == 0 ? null : new TapIntList(cas, null);
        this.destination = destination;
        this.carry = null;
        if (origin != null) {
            origin.addFlow(this);
        }
        if (destination != null) {
            destination.addBackFlow(this);
        }
    }

    public FGArrow(Block origin, int test, TapIntList cases, Block destination) {
        this.origin = origin;
        this.test = test;
        this.cases = cases;
        this.destination = destination;
        this.carry = null;
        if (origin != null) {
            origin.addFlow(this);
        }
        if (destination != null) {
            destination.addBackFlow(this);
        }
    }

    public FGArrow(Block origin, int test, int cas, Block destination, boolean inCycle) {
        this.origin = origin;
        this.test = test;
        this.cases = test == 0 ? null : new TapIntList(cas, null);
        this.destination = destination;
        this.carry = null;
        this.inACycle = inCycle;
        if (origin != null) {
            origin.addFlow(this);
        }
        if (destination != null) {
            destination.addBackFlow(this);
        }
    }

    public FGArrow(Block origin, int test, TapIntList cases, Block destination, boolean inCycle) {
        this.origin = origin;
        this.test = test;
        this.cases = cases;
        this.destination = destination;
        this.carry = null;
        this.inACycle = inCycle;
        if (origin != null) {
            origin.addFlow(this);
        }
        if (destination != null) {
            destination.addBackFlow(this);
        }
    }

    public FGArrow() {
    }

    public static String testAndCasesToString(int test, TapIntList cases) {
        StringBuilder result;
        switch (test) {
            case 30: {
                result = new StringBuilder("LOOP:");
                break;
            }
            case 20: {
                result = new StringBuilder("IF:");
                break;
            }
            case 21: {
                result = new StringBuilder("CASE:");
                break;
            }
            case -1: {
                result = new StringBuilder("ENTRY:");
                break;
            }
            case 10: {
                result = new StringBuilder("COMP_GOTO:");
                break;
            }
            case 11: {
                result = new StringBuilder("ASS_GOTO:");
                break;
            }
            case 12: {
                result = new StringBuilder("IO_GOTO:");
                break;
            }
            case 15: {
                result = new StringBuilder("CALL:");
                break;
            }
            case 0: {
                result = new StringBuilder("====");
                break;
            }
            default: {
                result = new StringBuilder("??:");
            }
        }
        TapIntList inCases = cases;
        while (inCases != null) {
            int theCase = inCases.head;
            switch (test) {
                case 30: {
                    if (theCase == 1) {
                        result.append("NEXT");
                        break;
                    }
                    if (theCase == 0) {
                        result.append("EXIT");
                        break;
                    }
                    result.append("??");
                    break;
                }
                case 20: {
                    if (theCase == 2) {
                        result.append("TRUE");
                        break;
                    }
                    if (theCase == 5) {
                        result.append("FALSE");
                        break;
                    }
                    if (theCase == 9) {
                        result.append("ELSEWHERE");
                        break;
                    }
                    result.append("??");
                    break;
                }
                case 21: {
                    if (theCase == -1) {
                        result.append("DEFAULT");
                        break;
                    }
                    result.append(theCase);
                    break;
                }
                case -1: {
                    if (theCase == 1) {
                        result.append("MAIN");
                        break;
                    }
                    result.append(theCase);
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 15: {
                    result.append(theCase);
                    break;
                }
                case 0: {
                    break;
                }
                default: {
                    result.append("??");
                }
            }
            if ((inCases = inCases.tail) == null) continue;
            result.append('+');
        }
        return result.toString();
    }

    public boolean isCyclingArrow() {
        TapList<LoopBlock> destLoops = this.destination.enclosingLoops();
        return destLoops != null && ((LoopBlock)destLoops.head).header() == this.destination && TapList.contains(this.origin.enclosingLoops(), destLoops.head) && (this.inACycle || !this.destination.isALoop());
    }

    public void setRank(int rank) {
        this.rank = rank;
    }

    public void delete() {
        this.redirectOrigin(null);
        this.redirectDestination(null);
    }

    public void redirectOrigin(Block block) {
        if (block != this.origin) {
            if (this.origin != null) {
                this.origin.setFlow(TapList.delete(this, this.origin.flow()));
            }
            this.origin = block;
            if (this.origin != null) {
                this.origin.setFlow(new TapList<FGArrow>(this, this.origin.flow()));
            }
        }
    }

    public void redirectDestination(Block block) {
        if (block != this.destination) {
            if (this.destination != null) {
                this.destination.setBackFlow(TapList.delete(this, this.destination.backFlow()));
            }
            this.destination = block;
            if (this.destination != null) {
                this.destination.setBackFlow(new TapList<FGArrow>(this, this.destination.backFlow()));
            }
        }
    }

    public void redirectDestination(Block block, boolean cycle) {
        this.redirectDestination(block);
        this.inACycle = cycle;
    }

    public void insertBlockAtOrig(Block block, int test, int cas) {
        Block previousOrigin = this.origin;
        this.redirectOrigin(block);
        FGArrow newArrow = new FGArrow(previousOrigin, this.test, this.cases, block, false);
        newArrow.turnNomatchIntoDefault();
        this.test = test;
        this.cases = test == 0 ? null : new TapIntList(cas, null);
    }

    public FGArrow insertBlockAtDest(Block block, int test, int cas) {
        Block previousDestination = this.destination;
        this.redirectDestination(block);
        this.turnNomatchIntoDefault();
        FGArrow newArrow = new FGArrow(block, test, cas, previousDestination, this.inACycle);
        newArrow.isAJumpIntoNextCase = this.isAJumpIntoNextCase;
        this.inACycle = false;
        this.isAJumpIntoNextCase = false;
        return newArrow;
    }

    public void turnNomatchIntoDefault() {
        if (this.test == 21 && TapIntList.contains(this.cases, -2)) {
            Tree tree;
            TapIntList inCases = this.cases = TapIntList.copy(this.cases);
            while (inCases != null) {
                if (inCases.head == -2) {
                    inCases.head = -1;
                }
                inCases = inCases.tail;
            }
            Instruction switchInstr = this.origin.lastInstr();
            if (switchInstr != null && (tree = switchInstr.tree) != null && tree.opCode() == 184) {
                tree.down(2).addChild(ILUtils.build(185, ILUtils.build(71), ILUtils.build(27)), 1 + tree.down(2).length());
            }
        }
    }

    public void mergeCases(FGArrow newArrow) {
        if (this.test != newArrow.test) {
            if (newArrow.cases == null || newArrow.cases.head != 9) {
                TapEnv.toolWarning(-1, " FGArrow.mergeCases: Incompatible arrow tests " + this.test + " and " + newArrow.test);
            }
        } else if (this.test == 20) {
            int totalcases = this.cases.head + newArrow.cases.head;
            if (totalcases < 7) {
                this.cases = new TapIntList(totalcases, null);
            } else {
                this.test = 0;
                this.cases = null;
            }
        } else if (this.test == 21) {
            this.cases = TapIntList.append(this.cases, newArrow.cases);
            this.cases = TapIntList.sort(this.cases);
        } else {
            this.cases = this.cases != null && TapIntList.contains(this.cases, -1) || newArrow.cases != null && TapIntList.contains(newArrow.cases, -1) ? new TapIntList(-1, null) : TapIntList.append(this.cases, newArrow.cases);
        }
    }

    public boolean exitsFromLoopAndLoopSymbolTable() {
        return this.containsCase(0) && this.origin.symbolTable.declarationsBlock == this.origin;
    }

    public boolean containsCase(int oneCase) {
        if (this.test == 20) {
            return (this.cases.head & oneCase) != 0;
        }
        return TapIntList.contains(this.cases, oneCase);
    }

    public void coherence() {
        LoopBlock loop;
        boolean outThenBackIn;
        TapList<LoopBlock> origLoops = this.origin.enclosingLoops();
        TapList<LoopBlock> destLoops = this.destination.enclosingLoops();
        TapList tmpList = null;
        boolean apparentlyCycling = destLoops != null && this.destination == ((LoopBlock)destLoops.head).header();
        boolean reallyInACycle = apparentlyCycling && (this.inACycle || !this.destination.isALoop());
        boolean bl = outThenBackIn = apparentlyCycling && TapList.contains(origLoops, destLoops.head) && !reallyInACycle;
        if (reallyInACycle && TapList.contains(origLoops, destLoops.head)) {
            loop = (LoopBlock)destLoops.head;
            this.iter = new TapList<TapPair<Integer, LoopBlock>>(new TapPair<Integer, LoopBlock>(FGConstants.CYCLE, loop), null);
            loop.cycleArrows = new TapList<FGArrow>(this, loop.cycleArrows);
        } else {
            this.iter = null;
        }
        while (destLoops != null && (!TapList.contains(origLoops, destLoops.head) || outThenBackIn)) {
            loop = (LoopBlock)destLoops.head;
            this.iter = new TapList<TapPair<Integer, LoopBlock>>(new TapPair<Integer, LoopBlock>(FGConstants.PUSH, loop), this.iter);
            if (!TapList.contains(loop.entryBlocks, this.destination)) {
                loop.entryBlocks = new TapList<Block>(this.destination, loop.entryBlocks);
            }
            if (this.destination != loop.header()) {
                Tree pos = null;
                if (this.destination.instructions != null) {
                    pos = this.destination.headInstr().tree;
                }
                TapEnv.fileWarning(15, pos, "(CF01) Irreductible entry into loop");
            }
            loop.entryArrows = new TapList<FGArrow>(this, loop.entryArrows);
            outThenBackIn = false;
            destLoops = destLoops.tail;
        }
        while (origLoops != null && (destLoops == null || origLoops.head != destLoops.head)) {
            tmpList = new TapList(origLoops.head, tmpList);
            origLoops = origLoops.tail;
        }
        while (tmpList != null) {
            loop = (LoopBlock)tmpList.head;
            this.iter = new TapList<TapPair<Integer, LoopBlock>>(new TapPair<Integer, LoopBlock>(FGConstants.POP, loop), this.iter);
            if (!TapList.contains(loop.exitBlocks, this.origin)) {
                loop.exitBlocks = new TapList<Block>(this.origin, loop.exitBlocks);
            }
            loop.exitArrows = new TapList<FGArrow>(this, loop.exitArrows);
            tmpList = tmpList.tail;
        }
    }

    public Block topmostPop() {
        TapList<TapPair<Integer, LoopBlock>> inIter = this.iter;
        LoopBlock topmostPop = null;
        while (inIter != null && ((Integer)((TapPair)inIter.head).first).equals(FGConstants.POP)) {
            topmostPop = (LoopBlock)((TapPair)inIter.head).second;
            inIter = inIter.tail;
        }
        if (topmostPop != null) {
            return topmostPop;
        }
        return this.origin;
    }

    public LoopBlock finalCycle() {
        TapList<TapPair<Integer, LoopBlock>> inIter = this.iter;
        if (inIter != null) {
            while (inIter.tail != null) {
                inIter = inIter.tail;
            }
        }
        if (inIter != null && ((Integer)((TapPair)inIter.head).first).equals(FGConstants.CYCLE)) {
            return (LoopBlock)((TapPair)inIter.head).second;
        }
        return null;
    }

    public boolean goesInsideControl() {
        switch (this.test) {
            case 30: {
                return TapIntList.contains(this.cases, 1);
            }
            case -1: 
            case 20: {
                return true;
            }
            case 21: {
                return !TapIntList.contains(this.cases, -2);
            }
        }
        if (this.origin.isANameSpace()) {
            SymbolTable nameSpaceBasisST = this.destination.symbolTable.basisSymbolTable();
            return nameSpaceBasisST == this.origin.symbolTable || nameSpaceBasisST == this.origin.symbolTable.getCallGraph().cPlusPlusRootSymbolTable();
        }
        if (this.origin.isParallelController()) {
            return this.destination.parallelControls != null && this.origin.lastInstr() == this.destination.parallelControls.head;
        }
        return false;
    }

    public SymbolTable commonSymbolTable() {
        if (this.origin == null || this.origin.symbolTable == null || this.destination == null || this.destination.symbolTable == null) {
            return null;
        }
        return this.origin.symbolTable.getCommonRoot(this.destination.symbolTable);
    }

    public boolean mayBeNatural() {
        switch (this.test) {
            case 11: {
                return false;
            }
            case 10: 
            case 12: 
            case 15: {
                return this.cases.head == -1;
            }
        }
        return true;
    }

    public void dump() throws IOException {
        if (this.inACycle) {
            TapEnv.print("in cycle arrow ");
        }
        if (this.origin == null) {
            TapEnv.print("null origin!");
        } else {
            TapEnv.print(this.origin.toString());
        }
        TapEnv.print(" ");
        this.dumpTestCaseCarry();
        TapEnv.print(" ");
        if (this.destination == null) {
            TapEnv.print("null destination!");
        } else {
            TapEnv.print(this.destination.toString());
        }
    }

    protected void dumpTestCaseCarry() throws IOException {
        TapEnv.print("==(" + this.rank + ")==");
        switch (this.test) {
            case 30: {
                TapEnv.print("LOOP(");
                break;
            }
            case 20: {
                TapEnv.print("IF(");
                break;
            }
            case -1: {
                TapEnv.print("ENTRY(");
                break;
            }
            case 10: {
                TapEnv.print("COMP_GOTO(");
                break;
            }
            case 11: {
                TapEnv.print("ASS_GOTO(");
                break;
            }
            case 12: {
                TapEnv.print("IO_GOTO(");
                break;
            }
            case 15: {
                TapEnv.print("CALL(");
                break;
            }
            case 21: {
                TapEnv.print("CASE(");
                break;
            }
            case 0: {
                TapEnv.print("=====");
                break;
            }
            default: {
                TapEnv.print("??(");
            }
        }
        this.dumpCase();
        if (this.test != 0) {
            TapEnv.print(")==");
        }
        if (this.carry != null) {
            TapEnv.print("&>");
        } else {
            TapEnv.print(">");
        }
    }

    private void dumpCase() throws IOException {
        TapIntList inCases = this.cases;
        while (inCases != null) {
            int theCase = inCases.head;
            switch (this.test) {
                case 30: {
                    if (theCase == 1) {
                        TapEnv.print("NEXT");
                        break;
                    }
                    if (theCase == 0) {
                        TapEnv.print("EXIT");
                        break;
                    }
                    TapEnv.print("??");
                    break;
                }
                case 20: {
                    if (theCase == 2) {
                        TapEnv.print("TRUE");
                        break;
                    }
                    if (theCase == 5) {
                        TapEnv.print("FALSE");
                        break;
                    }
                    if (theCase == 9) {
                        TapEnv.print("ELSEWHERE");
                        break;
                    }
                    TapEnv.print("??");
                    break;
                }
                case 21: {
                    if (theCase == -1) {
                        TapEnv.print("DEFAULT");
                        break;
                    }
                    TapEnv.print(String.valueOf(theCase));
                    break;
                }
                case -1: {
                    if (theCase == 1) {
                        TapEnv.print("MAIN");
                        break;
                    }
                    TapEnv.print(String.valueOf(theCase));
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 15: {
                    TapEnv.print(String.valueOf(theCase));
                    break;
                }
                default: {
                    TapEnv.print("??");
                }
            }
            if ((inCases = inCases.tail) == null) continue;
            TapEnv.print(",");
        }
    }

    public String toString() {
        return "FGA(" + (this.origin == null ? "()" : this.origin) + "==" + FGArrow.testAndCasesToString(this.test, this.cases) + (this.inACycle ? "*" : "=") + "=>" + (this.destination == null ? "()" : this.destination) + ')';
    }
}

