/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.representation;

import fr.inria.tapenade.representation.Block;
import fr.inria.tapenade.representation.FunctionDecl;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.Instruction;
import fr.inria.tapenade.representation.MPIcallInfo;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.utils.ToObject;
import fr.inria.tapenade.utils.Tree;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class Directive {
    private static final String AD_DIRECTIVE_HEAD = "$AD ";
    public static final int IILOOP = 13;
    public static final int BINOMIALCKP = 15;
    public static final int CHECKPOINTSTART = 16;
    public static final int CHECKPOINTEND = 17;
    public static final int NOCHECKPOINT = 12;
    public static final int SPECIALIZEACTIVITY = 27;
    public static final int NODIFFSTART = 21;
    public static final int NODIFFEND = 22;
    public static final int FIXEDPOINTLOOP = 23;
    public static final int LABEL_START = 28;
    public static final int LABEL_END = 29;
    public static final int DEBUGHERE = 18;
    public static final int DEBUGCALL = 19;
    private static final int MESSAGE_PASSING = 20;
    private static final int INDEPENDENT = 1;
    private static final int DEPENDENT = 2;
    private static final int DEADVARIABLE = 3;
    private static final int DEADADJOINTVARIABLE = 4;
    private static final int NOSNAPSHOT = 5;
    private static final int PASSIVEVARIABLE = 7;
    private static final int IN = 9;
    private static final int OUT = 10;
    private static final int PROCEDURE = 11;
    private static final int RESET = 14;
    private static final int LINE = 15;
    public static final int MULTITHREAD_TGT = 25;
    public static final int MULTITHREAD_ADJ = 26;
    private static final int MULTITHREAD = 24;
    private static final Pattern splitPattern = Pattern.compile("( +,? *|, *)");
    private String directiveCommand;
    public int type;
    public Tree[] arguments;
    public String label;
    public Float adjResidual = null;
    public Float adjReduction = null;

    public Directive(int directiveType) {
        this.type = directiveType;
    }

    protected static boolean containDirectives(TapList<Tree> commentsList) {
        boolean found = false;
        while (commentsList != null && !found) {
            found = Directive.getDirectiveText((Tree)commentsList.head) != null;
            commentsList = commentsList.tail;
        }
        return found;
    }

    protected static boolean containDirectives(Tree commentTree) {
        if (commentTree == null) {
            return false;
        }
        boolean found = false;
        Tree[] comments = commentTree.children();
        for (int i = comments.length - 1; i >= 0 && !found; --i) {
            found = Directive.getDirectiveText(comments[i]) != null;
        }
        return found;
    }

    public static Directive hasDirective(TapList<Directive> directives, int kind) {
        while (directives != null) {
            Directive directive = (Directive)directives.head;
            if (directive.type == kind) {
                return directive;
            }
            directives = directives.tail;
        }
        return null;
    }

    public static Directive hasDirective(TapList<Directive> directives, int kind, String label) {
        while (directives != null) {
            Directive directive = (Directive)directives.head;
            if (directive != null && directive.type == kind && (directive.label == null ? label == null : directive.label.equals(label))) {
                return directive;
            }
            directives = directives.tail;
        }
        return null;
    }

    public static int startKind(int endKind) {
        switch (endKind) {
            case 17: {
                return 16;
            }
            case 22: {
                return 21;
            }
            case 29: {
                return 28;
            }
        }
        return -1;
    }

    protected static void analyzeUnitDirectives(Unit unit, Tree unitComments) {
        if (unit.hasSource() && unitComments != null) {
            Tree comment;
            Tree[] comments;
            TapList<Object> directivesToCut = null;
            Instruction headerInstruction = unit.entryBlock().headInstr();
            for (Tree tree : comments = unitComments.children()) {
                comment = tree;
                String directiveText = Directive.getDirectiveText(comment);
                if (directiveText == null) continue;
                while (directiveText.startsWith(" ")) {
                    directiveText = directiveText.substring(1);
                }
                String directiveTextUC = directiveText.toUpperCase();
                Directive node = null;
                if (directiveTextUC.startsWith("INDEPENDENT ")) {
                    node = Directive.buildIndependent(directiveText.substring(12));
                } else if (directiveTextUC.startsWith("IN ")) {
                    node = Directive.buildWithArgs(9, directiveText.substring(3));
                } else if (directiveTextUC.startsWith("OUT ")) {
                    node = Directive.buildWithArgs(10, directiveText.substring(4));
                } else if (directiveTextUC.startsWith("NOSNAPSHOT")) {
                    node = Directive.buildWithArgs(5, directiveText.substring(10));
                } else if (directiveTextUC.startsWith("SPECIALIZEACTIVITY")) {
                    node = Directive.buildAtomic(27);
                } else if (directiveTextUC.startsWith("NOCHECKPOINT")) {
                    node = Directive.buildNoCheckpoint(headerInstruction);
                    unit.maybeNoCheckpointed = true;
                    unit.maybeCheckpointed = false;
                } else if (directiveTextUC.startsWith("RESET ")) {
                    node = Directive.buildSaveRestoreReset(directiveText.substring(6));
                } else if (directiveTextUC.startsWith("MULTITHREAD ") || directiveTextUC.startsWith("MULTITHREAD_")) {
                    String subText = directiveText.substring(12);
                    while (subText.startsWith(" ")) {
                        subText = subText.substring(1);
                    }
                    String subTextUC = subText.toUpperCase();
                    node = subTextUC.startsWith("TGT ") ? Directive.buildWithMultithreadScopings(25, subText.substring(4)) : (subTextUC.startsWith("TANGENT ") ? Directive.buildWithMultithreadScopings(25, subText.substring(8)) : (subTextUC.startsWith("ADJ ") ? Directive.buildWithMultithreadScopings(26, subText.substring(4)) : (subTextUC.startsWith("ADJOINT ") ? Directive.buildWithMultithreadScopings(26, subText.substring(8)) : Directive.buildWithArgs(24, subText))));
                }
                if (node == null) continue;
                directivesToCut = new TapList<Tree>(comment, directivesToCut);
                node.directiveCommand = directiveText;
                unit.directives = new TapList<Directive>(node, unit.directives);
            }
            while (directivesToCut != null) {
                comment = (Tree)directivesToCut.head;
                unitComments.removeChild(comment.rankInParent());
                directivesToCut = directivesToCut.tail;
            }
        }
    }

    protected static void analyzeInstructionDirectives(Instruction instruction, Tree instructionComments) {
        if (instructionComments != null) {
            Tree[] comments;
            TapList<Object> directivesToCut = null;
            for (Tree comment : comments = instructionComments.children()) {
                String directiveText = Directive.getDirectiveText(comment);
                if (directiveText == null) continue;
                while (directiveText.startsWith(" ")) {
                    directiveText = directiveText.substring(1);
                }
                String directiveTextUC = directiveText.toUpperCase();
                Directive node = null;
                if (directiveTextUC.startsWith("II-LOOP") && TapEnv.doActivity()) {
                    node = Directive.buildIILoop(directiveText.substring(7), instruction);
                } else if (directiveTextUC.startsWith("BINOMIAL-CKP ")) {
                    node = Directive.buildBinomialCkp(directiveText.substring(13), instruction);
                } else if (directiveTextUC.startsWith("CHECKPOINT-START")) {
                    node = Directive.buildAtomic(16);
                } else if (directiveTextUC.startsWith("CHECKPOINT-END")) {
                    node = Directive.buildAtomic(17);
                } else if (directiveTextUC.startsWith("SPECIALIZEACTIVITY")) {
                    node = Directive.buildAtomic(27);
                } else if (directiveTextUC.startsWith("NOCHECKPOINT")) {
                    node = Directive.buildNoCheckpoint(instruction);
                    if (ILUtils.isCall(instruction.tree)) {
                        FunctionDecl funcDecl;
                        SymbolTable symbolTable = instruction.block.symbolTable;
                        TapList<FunctionDecl> funcDecls = symbolTable.getFunctionDecl(ILUtils.getCalledNameString(ILUtils.getCall(instruction.tree)), null, null, false);
                        FunctionDecl functionDecl = funcDecl = funcDecls == null ? null : (FunctionDecl)funcDecls.head;
                        if (funcDecl != null) {
                            funcDecl.unit().maybeNoCheckpointed = true;
                        }
                    }
                } else if (directiveTextUC.startsWith("DO-NOT-DIFF")) {
                    node = Directive.buildWithLabel(21, directiveText.substring(11));
                } else if (directiveTextUC.startsWith("END-DO-NOT-DIFF")) {
                    node = Directive.buildWithLabel(22, directiveText.substring(15));
                } else if (directiveTextUC.startsWith("FP-LOOP")) {
                    node = Directive.buildFixedPoint(directiveText.substring(7), instruction);
                } else if (directiveTextUC.startsWith("LABEL")) {
                    node = Directive.buildWithLabel(28, directiveText.substring(6));
                } else if (directiveTextUC.startsWith("END-LABEL")) {
                    node = Directive.buildWithLabel(29, directiveText.substring(10));
                } else if (directiveTextUC.startsWith("DEBUG-HERE")) {
                    node = Directive.buildWithArgs(18, directiveText.substring(10));
                } else if (directiveTextUC.startsWith("DEBUG-CALL")) {
                    node = Directive.buildWithArgs(19, directiveText.substring(10));
                } else if (directiveTextUC.startsWith("INDEPENDENT ")) {
                    node = Directive.buildIndependent(directiveText.substring(12), instruction);
                } else if (directiveTextUC.startsWith("MAKE-PROCEDURE ")) {
                    node = Directive.buildMakeProcedure(directiveText.substring(15));
                } else if (directiveTextUC.startsWith("IN ")) {
                    node = Directive.buildWithArgs(9, directiveText.substring(3));
                } else if (directiveTextUC.startsWith("OUT ")) {
                    node = Directive.buildWithArgs(10, directiveText.substring(4));
                } else if (directiveTextUC.startsWith("NOSNAPSHOT")) {
                    node = Directive.buildWithArgs(5, directiveText.substring(10));
                } else if (directiveTextUC.startsWith("DEAD ")) {
                    node = Directive.buildWithLabel(3, directiveText.substring(5));
                } else if (directiveTextUC.startsWith("DEADADJOINT ")) {
                    node = Directive.buildWithLabel(4, directiveText.substring(12));
                } else if (directiveTextUC.startsWith("PASSIVE ")) {
                    node = Directive.buildWithArgs(7, directiveText.substring(8));
                } else if (directiveTextUC.startsWith("CHANNEL ")) {
                    node = Directive.buildMessagePassingChannel(directiveText.substring(8), instruction);
                } else if (directiveTextUC.startsWith("LINE ")) {
                    if (ILUtils.isCall(instruction.tree)) {
                        int lineNumber = Integer.parseInt(directiveText.substring(5));
                        ILUtils.getCall(instruction.tree).down(1).setAnnotation("line", ILUtils.build(103, lineNumber));
                    }
                    node = null;
                } else if (directiveTextUC.startsWith("MULTITHREAD ") || directiveTextUC.startsWith("MULTITHREAD_")) {
                    String subText = directiveText.substring(12);
                    while (subText.startsWith(" ")) {
                        subText = subText.substring(1);
                    }
                    String subTextUC = subText.toUpperCase();
                    node = subTextUC.startsWith("TGT ") ? Directive.buildWithMultithreadScopings(25, subText.substring(4)) : (subTextUC.startsWith("TANGENT ") ? Directive.buildWithMultithreadScopings(25, subText.substring(8)) : (subTextUC.startsWith("ADJ ") ? Directive.buildWithMultithreadScopings(26, subText.substring(4)) : (subTextUC.startsWith("ADJOINT ") ? Directive.buildWithMultithreadScopings(26, subText.substring(8)) : Directive.buildWithArgs(24, subText))));
                }
                if (node == null) continue;
                if (!directiveTextUC.startsWith("CHANNEL ")) {
                    directivesToCut = new TapList<Tree>(comment, directivesToCut);
                }
                node.directiveCommand = directiveText;
                instruction.directives = TapList.append(instruction.directives, new TapList<Directive>(node, null));
            }
            while (directivesToCut != null) {
                Tree comment = (Tree)directivesToCut.head;
                instructionComments.removeChild(comment.rankInParent());
                directivesToCut = directivesToCut.tail;
            }
        }
    }

    protected static boolean isIILoopDirective(Tree comment) {
        String directiveText = Directive.getDirectiveText(comment);
        return directiveText != null && directiveText.startsWith("II-LOOP");
    }

    protected static boolean isEndOfRegionDirective(Tree comment) {
        String directiveText = Directive.getDirectiveText(comment);
        return directiveText != null && directiveText.startsWith("END-");
    }

    protected static String getDirectiveText(Tree comment) {
        if (!comment.isStringAtom()) {
            return null;
        }
        String text = comment.stringValue();
        while (text.startsWith(" ")) {
            text = text.substring(1);
        }
        if (!text.toUpperCase().startsWith(AD_DIRECTIVE_HEAD)) {
            return null;
        }
        text = text.substring(AD_DIRECTIVE_HEAD.length());
        while (text.startsWith(" ")) {
            text = text.substring(1);
        }
        return text;
    }

    public String rebuildFullDirective() {
        return AD_DIRECTIVE_HEAD + this.directiveCommand;
    }

    private static Directive buildAtomic(int dirName) {
        return new Directive(dirName);
    }

    private static Directive buildWithLabel(int dirName, String args) {
        Directive newDir = new Directive(dirName);
        newDir.label = args.trim();
        return newDir;
    }

    private static Directive buildWithArgs(int dirName, String args) {
        Directive newDir = new Directive(dirName);
        Directive.parseArguments(newDir, args);
        return newDir;
    }

    private static Directive buildWithMultithreadScopings(int dirName, String args) {
        Directive newDir = new Directive(dirName);
        while (args.startsWith(" ")) {
            args = args.substring(1);
        }
        newDir.arguments = new Tree[]{ILUtils.build(96, args)};
        return newDir;
    }

    private static Directive buildIILoop(String args, Instruction instruction) {
        Block block = instruction.block;
        if (block.isALoop() && block.headInstr() == instruction) {
            Directive newDir = new Directive(13);
            newDir.label = args.trim();
            return newDir;
        }
        TapEnv.fileWarning(15, instruction.tree, "(XX00) Misplaced AD II-LOOP directive, ignored");
        return null;
    }

    private static Directive buildBinomialCkp(String args, Instruction instruction) {
        Block block = instruction.block;
        if (block.isALoop() && block.headInstr() == instruction) {
            Directive newDir = new Directive(15);
            Directive.parseArguments(newDir, args);
            return newDir;
        }
        TapEnv.fileWarning(15, instruction.tree, "(XX00) Misplaced AD BINOMIAL-CKP directive, ignored");
        return null;
    }

    private static Directive buildFixedPoint(String args, Instruction instruction) {
        Block block = instruction.block;
        if (block.isALoop() && block.headInstr() == instruction) {
            String reductionString;
            ToObject<String> remainingArgs = new ToObject<String>(args);
            Directive newDir = new Directive(23);
            String residualString = Directive.tokenAfter(remainingArgs, " adj_residual=");
            if (residualString == null) {
                residualString = Directive.tokenAfter(remainingArgs, " adjResidual=");
            }
            if (residualString != null) {
                try {
                    newDir.adjResidual = Float.valueOf(residualString);
                }
                catch (NumberFormatException e) {
                    TapEnv.fileError(instruction.tree, "(XX00) Incorrect number format for adj_residual:" + residualString);
                    newDir.adjResidual = Float.valueOf("1.0e-6");
                }
            }
            if ((reductionString = Directive.tokenAfter(remainingArgs, " adj_reduction=")) == null) {
                reductionString = Directive.tokenAfter(remainingArgs, " adjReduction=");
            }
            if (reductionString != null) {
                try {
                    newDir.adjReduction = Float.valueOf(reductionString);
                }
                catch (NumberFormatException e) {
                    TapEnv.fileError(instruction.tree, "(XX00) Incorrect number format for adj_reduction:" + reductionString);
                    newDir.adjReduction = Float.valueOf("1.0e-6");
                }
            }
            Directive.parseArguments(newDir, remainingArgs.obj());
            return newDir;
        }
        TapEnv.fileError(instruction.tree, "(XX00) Misplaced AD FP-LOOP directive, ignored");
        return null;
    }

    private static Directive buildNoCheckpoint(Instruction inst) {
        if (TapEnv.get().staticTape) {
            TapEnv.commandWarning(-1, "staticTape option deactivated on units with nocheckpoint option");
            TapEnv.get().staticTape = false;
        }
        Directive newDir = new Directive(12);
        Block block = inst.block;
        if (!block.isALoop() || block.headInstr() == inst) {
            // empty if block
        }
        return newDir;
    }

    private static Directive buildIndependent(String args, Instruction instruction) {
        Block block = instruction.block;
        if (block != null && block.isALoop() && block.headInstr() == instruction) {
            TapEnv.fileWarning(15, instruction.tree, "(XX00) AD directive INDEPENDENT not yet implemented on loops, ignored");
            return null;
        }
        return Directive.buildIndependent(args);
    }

    private static Directive buildIndependent(String args) {
        Directive newDir = new Directive(1);
        StringTokenizer namesToken = new StringTokenizer(args, " ");
        while (namesToken.hasMoreElements()) {
            String name = namesToken.nextToken();
        }
        return newDir;
    }

    private static Directive buildMakeProcedure(String args) {
        Directive newDir = new Directive(11);
        newDir.label = args.trim();
        return newDir;
    }

    private static Directive buildMessagePassingChannel(String args, Instruction instruction) {
        Directive newDir = new Directive(20);
        Tree channelStringTree = null;
        if (ILUtils.isCall(instruction.tree)) {
            Tree callTree = ILUtils.getCall(instruction.tree);
            channelStringTree = ILUtils.build(180, args);
            callTree.setAnnotation("channel", channelStringTree);
            Unit unit = instruction.block.unit();
            if (unit != null) {
                callTree.removeAnnotation("MPIcallInfo");
                MPIcallInfo messagePassingInfo = MPIcallInfo.getMessagePassingMPIcallInfo(ILUtils.getCalledNameString(callTree), callTree, unit.language(), instruction.block);
                if (messagePassingInfo != null && messagePassingInfo.isPointToPoint()) {
                    messagePassingInfo.registerMessagePassingChannel(unit.callGraph());
                }
            }
        }
        newDir.arguments = new Tree[]{channelStringTree};
        return newDir;
    }

    private static Directive buildSaveRestoreReset(String args) {
        Directive newDir = new Directive(14);
        splitPattern.split(args);
        return newDir;
    }

    public static void analyzeMultithreadScopings(Tree scopingsStringTree, boolean caseSensitive, TapList<Tree> toClausesGivenScoping, TapList<String> toForcedAtomicScopingNames, TapList<String> toForcedOtherScopingNames) {
        String scopingsString = scopingsStringTree == null ? null : scopingsStringTree.stringValue();
        ToObject<String> toScopings = new ToObject<String>(scopingsString);
        Directive.skipCommaWhites(toScopings);
        while (toScopings.obj() != null && !toScopings.obj().isEmpty()) {
            TapList<String> varsNames;
            String varsString;
            int scopingOp;
            String reducOp = null;
            boolean inAtomic = false;
            if (Directive.startsWithCaseIndep(toScopings.obj(), "private")) {
                scopingOp = 157;
                toScopings.setObj(toScopings.obj().substring(7));
                varsString = Directive.getInParentheses(toScopings);
                varsNames = Directive.getVarNamesInCommas(varsString, caseSensitive);
            } else if (Directive.startsWithCaseIndep(toScopings.obj(), "firstprivate")) {
                scopingOp = 77;
                toScopings.setObj(toScopings.obj().substring(12));
                varsString = Directive.getInParentheses(toScopings);
                varsNames = Directive.getVarNamesInCommas(varsString, caseSensitive);
            } else if (Directive.startsWithCaseIndep(toScopings.obj(), "lastprivate")) {
                scopingOp = 114;
                toScopings.setObj(toScopings.obj().substring(11));
                varsString = Directive.getInParentheses(toScopings);
                varsNames = Directive.getVarNamesInCommas(varsString, caseSensitive);
            } else if (Directive.startsWithCaseIndep(toScopings.obj(), "reduction")) {
                scopingOp = 162;
                toScopings.setObj(toScopings.obj().substring(9));
                varsString = Directive.getInParentheses(toScopings);
                ToObject<String> toReducInside = new ToObject<String>(varsString);
                reducOp = Directive.getBeforeColon(toReducInside);
                varsNames = Directive.getVarNamesInCommas(toReducInside.obj(), caseSensitive);
            } else if (Directive.startsWithCaseIndep(toScopings.obj(), "noconflict")) {
                scopingOp = 174;
                toScopings.setObj(toScopings.obj().substring(10));
                varsString = Directive.getInParentheses(toScopings);
                varsNames = Directive.getVarNamesInCommas(varsString, caseSensitive);
            } else if (Directive.startsWithCaseIndep(toScopings.obj(), "global") || Directive.startsWithCaseIndep(toScopings.obj(), "shared")) {
                scopingOp = 174;
                toScopings.setObj(toScopings.obj().substring(6));
                varsString = Directive.getInParentheses(toScopings);
                varsNames = Directive.getVarNamesInCommas(varsString, caseSensitive);
            } else if (Directive.startsWithCaseIndep(toScopings.obj(), "atomic")) {
                scopingOp = 174;
                inAtomic = true;
                toScopings.setObj(toScopings.obj().substring(6));
                varsString = Directive.getInParentheses(toScopings);
                varsNames = Directive.getVarNamesInCommas(varsString, caseSensitive);
            } else {
                TapEnv.fileError(null, "Syntax error in $AD OMP clause at:" + toScopings.obj());
                toScopings.setObj(null);
                scopingOp = 138;
                varsNames = null;
            }
            TapList<Object> toIdents = new TapList<Object>(null, null);
            while (varsNames != null) {
                if (inAtomic) {
                    toForcedAtomicScopingNames.newR((String)varsNames.head);
                } else {
                    toForcedOtherScopingNames.newR((String)varsNames.head);
                }
                toIdents.newR(ILUtils.build(96, (String)varsNames.head));
                varsNames = varsNames.tail;
            }
            if (toIdents.tail != null) {
                TapList<Tree> newClauseArgs = new TapList<Tree>(ILUtils.build(97, toIdents.tail), null);
                if (scopingOp == 162) {
                    newClauseArgs = new TapList<Tree>(ILUtils.build(96, reducOp), newClauseArgs);
                }
                toClausesGivenScoping.newR(ILUtils.build(scopingOp, newClauseArgs));
            }
            Directive.skipCommaWhites(toScopings);
        }
    }

    private static void skipCommaWhites(ToObject<String> toScopings) {
        String scopingsString;
        for (scopingsString = toScopings.obj(); scopingsString != null && (scopingsString.startsWith(" ") || scopingsString.startsWith(",")); scopingsString = scopingsString.substring(1)) {
        }
        toScopings.setObj(scopingsString);
    }

    private static String getInParentheses(ToObject<String> toScopings) {
        int closingPosition;
        String scopingsString;
        for (scopingsString = toScopings.obj(); scopingsString != null && scopingsString.startsWith(" "); scopingsString = scopingsString.substring(1)) {
        }
        assert (scopingsString != null);
        if (scopingsString.startsWith("(") && (closingPosition = scopingsString.indexOf(41)) > 0) {
            String contents = scopingsString.substring(1, closingPosition);
            toScopings.setObj(scopingsString.substring(closingPosition + 1));
            return contents;
        }
        toScopings.setObj(scopingsString);
        return null;
    }

    private static String getBeforeColon(ToObject<String> toContents) {
        String contentsString;
        for (contentsString = toContents.obj(); contentsString != null && contentsString.startsWith(" "); contentsString = contentsString.substring(1)) {
        }
        assert (contentsString != null);
        int colonPos = contentsString.indexOf(58);
        String reducOp = contentsString.substring(0, colonPos);
        int wPos = reducOp.indexOf(32);
        if (wPos > 0) {
            reducOp = reducOp.substring(0, wPos);
        }
        toContents.setObj(contentsString.substring(colonPos + 1));
        return reducOp;
    }

    private static boolean startsWithCaseIndep(String str, String prefix) {
        if (prefix.length() > str.length()) {
            return false;
        }
        return prefix.equals(str.substring(0, prefix.length()).toLowerCase());
    }

    private static TapList<String> getVarNamesInCommas(String identsString, boolean caseSensitive) {
        TapList<Object> toResult = new TapList<Object>(null, null);
        StringTokenizer identsTokenizer = new StringTokenizer(identsString, ", ");
        while (identsTokenizer.hasMoreElements()) {
            String varName = identsTokenizer.nextToken();
            if (caseSensitive) {
                varName = varName.toLowerCase();
            }
            toResult.newR(varName);
        }
        return toResult.tail;
    }

    private static void parseArguments(Directive directive, String args) {
        while (args.startsWith(" ")) {
            args = args.substring(1);
        }
        if (args.startsWith("\"")) {
            int lastDoubleQuote = args.lastIndexOf(34);
            args = args.substring(1, lastDoubleQuote);
        }
        StringTokenizer argumentsTokenizer = new StringTokenizer(args, ", ");
        TapList<Tree> expressionsReversed = null;
        while (argumentsTokenizer.hasMoreElements()) {
            Tree expressionTree;
            if (directive.type == 23) {
                TapList<String> referenceComponents = TapList.parseIdentifier(argumentsTokenizer.nextToken());
                expressionTree = ILUtils.build(96, (String)referenceComponents.head);
                referenceComponents = referenceComponents.tail;
                while (referenceComponents != null) {
                    expressionTree = ILUtils.build(75, expressionTree, ILUtils.build(96, (String)referenceComponents.head));
                    referenceComponents = referenceComponents.tail;
                }
            } else {
                expressionTree = ILUtils.build(96, argumentsTokenizer.nextToken());
            }
            expressionsReversed = new TapList<Tree>(expressionTree, expressionsReversed);
        }
        Tree[] arguments = new Tree[TapList.length(expressionsReversed)];
        for (int i = arguments.length - 1; i >= 0; --i) {
            assert (expressionsReversed != null);
            arguments[i] = (Tree)expressionsReversed.head;
            expressionsReversed = expressionsReversed.tail;
        }
        directive.arguments = arguments;
    }

    private static String tokenAfter(ToObject<String> toArgs, String key) {
        String args = toArgs.obj();
        int keyPos = args.indexOf(key);
        if (keyPos < 0) {
            return null;
        }
        String sequel = args.substring(keyPos + key.length());
        int whitePos = sequel.indexOf(" ,");
        toArgs.setObj(args.substring(0, keyPos) + (whitePos < 0 ? "" : args.substring(whitePos)));
        if (whitePos < 0) {
            return sequel;
        }
        return sequel.substring(0, whitePos);
    }

    public String toString() {
        StringBuilder argsString = new StringBuilder();
        if (this.arguments != null) {
            argsString.append(" args:[");
            for (int i = 0; i < this.arguments.length; ++i) {
                argsString.append(this.arguments[i]);
                if (i + 1 >= this.arguments.length) continue;
                argsString.append("; ");
            }
            argsString.append(']');
        }
        if (this.label != null) {
            argsString.append(" label:").append(this.label);
        }
        return "<Directive " + this.directiveCommand + " type:" + this.type + argsString;
    }
}

