/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.representation;

import fr.inria.tapenade.representation.ArrayDim;
import fr.inria.tapenade.representation.FieldDecl;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.NewSymbolHolder;
import fr.inria.tapenade.representation.PointerTypeSpec;
import fr.inria.tapenade.representation.SymbolDecl;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.TypeDecl;
import fr.inria.tapenade.representation.TypeSpec;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.representation.WrapperTypeSpec;
import fr.inria.tapenade.utils.TapPair;
import fr.inria.tapenade.utils.TapTriplet;
import fr.inria.tapenade.utils.ToBool;
import fr.inria.tapenade.utils.Tree;
import java.io.IOException;

public class CompositeTypeSpec
extends TypeSpec {
    private final int subKind;
    private final Unit definingUnit;
    public FieldDecl[] fields;
    public Tree modifiers;
    public String name;
    private boolean[] activeFields;
    private TapList<CompositeTypeSpec> copiesSharingActiveFields;
    protected boolean isAnIOType;
    private NewSymbolHolder unknownTypeSymbolHolder;

    public CompositeTypeSpec(String name, FieldDecl[] fields, int subKind, Tree modifiers, Unit definingUnit) {
        super(21);
        this.name = name;
        this.fields = fields;
        this.copiesSharingActiveFields = new TapList<CompositeTypeSpec>(this, null);
        this.initActiveFields();
        this.subKind = subKind;
        this.modifiers = modifiers;
        if (modifiers == null && subKind == 8) {
            this.modifiers = ILUtils.build(130);
        }
        this.definingUnit = definingUnit;
    }

    public boolean isRecordType() {
        return this.subKind == 8;
    }

    public boolean isUnionType() {
        return this.subKind == 13;
    }

    public FieldDecl namedFieldDecl(String name) {
        FieldDecl found = null;
        if (this.fields != null) {
            for (int i = this.fields.length - 1; found == null && i >= 0; --i) {
                if (this.fields[i] == null || !this.fields[i].symbol.equals(name)) continue;
                found = this.fields[i];
            }
        }
        return found;
    }

    public WrapperTypeSpec namedFieldType(String name) {
        FieldDecl field = this.namedFieldDecl(name);
        if (field != null) {
            if (TapList.containsEquals(field.extraInfo(), "allocatable") && !CompositeTypeSpec.isA(field.type(), 6)) {
                return new WrapperTypeSpec(new PointerTypeSpec(field.type(), null));
            }
            return field.type();
        }
        return null;
    }

    public WrapperTypeSpec getFieldType(Tree field) {
        int fieldRank = ILUtils.getFieldRank(field);
        if (fieldRank >= 0 && fieldRank < this.fields.length) {
            if (this.fields[fieldRank] != null) {
                return this.fields[fieldRank].type();
            }
            return null;
        }
        return this.namedFieldType(ILUtils.getIdentString(field));
    }

    public int namedFieldRank(String name) {
        int i;
        for (i = this.fields.length - 1; !(i < 0 || this.fields[i] != null && this.fields[i].symbol.equals(name)); --i) {
        }
        if (i >= 0) {
            return i;
        }
        return -1;
    }

    public int namedFieldOffset(String name) {
        int result = 0;
        for (int i = 0; i < this.fields.length && !this.fields[i].symbol.equals(name); ++i) {
            result += this.fields[i].type().size();
        }
        return result;
    }

    protected WrapperTypeSpec checkNamedFieldType(Tree instrTree, SymbolTable symbolTable, WrapperTypeSpec typeSpec) {
        Tree fieldTree = instrTree.down(2);
        String fieldName = ILUtils.getIdentString(fieldTree);
        WrapperTypeSpec result = this.namedFieldType(fieldName);
        if (result != null) {
            ILUtils.setFieldRank(fieldTree, this.namedFieldRank(fieldName));
            return result;
        }
        TapEnv.fileWarning(15, instrTree, "(TC45) No field named " + fieldName + " in " + this.showType());
        int fieldsLength = 0;
        if (this.fields != null) {
            fieldsLength = this.fields.length;
        }
        result = new WrapperTypeSpec(null);
        FieldDecl newFieldDecl = new FieldDecl(fieldTree, result);
        FieldDecl[] newFields = new FieldDecl[fieldsLength + 1];
        boolean[] newActiveFields = new boolean[newFields.length];
        for (int i = fieldsLength - 1; i >= 0; --i) {
            assert (this.fields != null);
            newFields[i] = this.fields[i];
            newActiveFields[i] = this.activeFields[i];
        }
        newFields[newFields.length - 1] = newFieldDecl;
        this.fields = newFields;
        TapList<CompositeTypeSpec> sharing = this.copiesSharingActiveFields;
        while (sharing != null) {
            ((CompositeTypeSpec)sharing.head).activeFields = newActiveFields;
            sharing = sharing.tail;
        }
        ILUtils.setFieldRank(fieldTree, newFields.length - 1);
        if (TapEnv.relatedUnit().isFortran() && this.typeDeclName() == null) {
            this.unknownTypeSymbolHolder = new NewSymbolHolder(TapEnv.disambigNewName("UnknownDerivedType"));
            Tree nameTree = this.unknownTypeSymbolHolder.makeNewRef(symbolTable);
            TypeDecl newTypeDecl = new TypeDecl(nameTree, typeSpec);
            this.unknownTypeSymbolHolder.setNewTypeDecl(newTypeDecl);
            this.unknownTypeSymbolHolder.addTypeDeclSymbolTable(symbolTable);
            this.unknownTypeSymbolHolder.makeNewRef(symbolTable);
            this.unknownTypeSymbolHolder.solvingLevelMustInclude(symbolTable);
        }
        return result;
    }

    public boolean isEmpty() {
        boolean result = true;
        for (int i = 0; i < this.fields.length; ++i) {
            result = result && this.fields[i] == null;
        }
        return result;
    }

    public boolean isDifferentiatedField(int i) {
        return this.fields[i] != null && this.activeFields != null && i < this.activeFields.length && this.activeFields[i];
    }

    public void initActiveFields() {
        this.activeFields = this.fields == null ? null : new boolean[this.fields.length];
    }

    public void shareActiveFields(CompositeTypeSpec other) {
        if (other.activeFields != null && this.activeFields != other.activeFields) {
            TapList<CompositeTypeSpec> futureCopiesSharing;
            TapList<CompositeTypeSpec> inCopies = futureCopiesSharing = TapList.append(this.copiesSharingActiveFields, other.copiesSharingActiveFields);
            while (inCopies != null) {
                ((CompositeTypeSpec)inCopies.head).copiesSharingActiveFields = futureCopiesSharing;
                ((CompositeTypeSpec)inCopies.head).activeFields = other.activeFields;
                inCopies = inCopies.tail;
            }
        }
    }

    @Override
    protected String baseTypeName() {
        return "";
    }

    @Override
    protected boolean isAnIOTypeSpec(SymbolTable symbolTable) {
        return this.isAnIOType;
    }

    @Override
    public boolean containsAPointer() {
        boolean contains = false;
        for (int i = this.fields.length - 1; i >= 0 && !contains; --i) {
            if (this.fields[i] == null || this.fields[i].type() == null || !this.fields[i].type().containsAPointer()) continue;
            contains = true;
        }
        return contains;
    }

    @Override
    public void doUpdateAfterImports(SymbolTable symbolTable, TapList<TypeSpec> dejaVu) {
        for (int i = this.fields.length - 1; i >= 0; --i) {
            if (this.fields[i] == null || this.fields[i].type() == null) continue;
            this.fields[i].type().updateAfterImports(symbolTable, dejaVu);
        }
    }

    @Override
    protected int computeSize() {
        int result = 0;
        for (FieldDecl field : this.fields) {
            if (field == null) continue;
            if (this.isRecordType()) {
                result += field.type().size();
                continue;
            }
            result = Math.max(result, field.type().size());
        }
        if (result == 0) {
            return 1;
        }
        return result;
    }

    @Override
    public void collectUsedTrees(TapList<Tree> toUsedTrees, TapList<TypeSpec> toDejaVu) {
        if (!TapList.contains(toDejaVu, this)) {
            toDejaVu.placdl(this);
            for (FieldDecl field : this.fields) {
                if (field == null) continue;
                field.collectUsedTrees(toUsedTrees, toDejaVu);
            }
        }
    }

    @Override
    protected boolean testComparesWith(TypeSpec other, int comparison, TypeSpec toThis, TypeSpec toOther, TapList<TapPair<TypeSpec, TypeSpec>> dejaVu) {
        String otherName;
        if ((toOther = this.peelWrapperAndModifiedTo(other, toOther)) != null) {
            other = toOther.wrappedType();
        }
        if (this == other) {
            return true;
        }
        if (other == null) {
            if (CompositeTypeSpec.testHasInference(comparison)) {
                if (toOther != null) {
                    toOther.setWrappedType(this);
                }
                return true;
            }
            return false;
        }
        if (!(other instanceof CompositeTypeSpec)) {
            return false;
        }
        CompositeTypeSpec otherCompositeType = (CompositeTypeSpec)other;
        String thisName = this.typeDeclName();
        if (thisName == null) {
            thisName = this.name;
        }
        if ((otherName = otherCompositeType.typeDeclName()) == null) {
            otherName = otherCompositeType.name;
        }
        if (thisName != null && thisName.equals(otherName)) {
            return true;
        }
        boolean comparesWell = true;
        if (this.fields == null) {
            if (CompositeTypeSpec.testHasInference(comparison)) {
                if (otherCompositeType.fields != null) {
                    this.fields = new FieldDecl[otherCompositeType.fields.length];
                    System.arraycopy(otherCompositeType.fields, 0, this.fields, 0, this.fields.length);
                }
            } else {
                comparesWell = CompositeTypeSpec.testAcceptsUnspecified(comparison);
            }
        } else if (otherCompositeType.fields == null) {
            if (CompositeTypeSpec.testHasInference(comparison)) {
                otherCompositeType.fields = new FieldDecl[this.fields.length];
                System.arraycopy(this.fields, 0, otherCompositeType.fields, 0, this.fields.length);
            } else {
                comparesWell = false;
            }
        } else {
            comparesWell = otherCompositeType.fields.length == this.fields.length;
            for (int i = this.fields.length - 1; comparesWell && i >= 0; --i) {
                comparesWell = this.fields[i] == null ? otherCompositeType.fields[i] == null : (otherCompositeType.fields[i] == null ? false : this.fields[i].symbol != null && this.fields[i].type() != null && otherCompositeType.fields[i].type() != null && this.fields[i].symbol.equals(otherCompositeType.fields[i].symbol) && this.fields[i].type().comparesWith(otherCompositeType.fields[i].type(), CompositeTypeSpec.testSetEquals(CompositeTypeSpec.testUnsetInference(comparison)), null, null, dejaVu));
            }
        }
        return comparesWell;
    }

    @Override
    public TypeSpec copy() {
        FieldDecl[] fieldsCopy = new FieldDecl[this.fields.length];
        System.arraycopy(this.fields, 0, fieldsCopy, 0, this.fields.length);
        CompositeTypeSpec result = new CompositeTypeSpec(null, fieldsCopy, this.kind(), null, null);
        result.shareActiveFields(this);
        result.setOrAddTypeDeclName(this.typeDeclName());
        return result;
    }

    @Override
    public TypeSpec copyStopOnComposite(Unit publishedUnit) {
        return this;
    }

    @Override
    protected boolean containsMetaType(TapList<TypeSpec> dejaVu) {
        if (TapList.contains(dejaVu, this)) {
            return false;
        }
        dejaVu = new TapList<TypeSpec>(this, dejaVu);
        boolean contains = false;
        for (int i = 0; !contains && i < this.fields.length; ++i) {
            if (this.fields[i] == null || this.fields[i].type() == null) continue;
            contains = this.fields[i].type().containsMetaType(dejaVu);
        }
        return contains;
    }

    @Override
    protected TypeSpec localize(TapList<TapTriplet<TypeSpec, TypeSpec, Boolean>> toAlreadyCopied, ToBool containsMeta) {
        CompositeTypeSpec copiedResult = (CompositeTypeSpec)this.findAlreadyCopiedType(toAlreadyCopied, containsMeta);
        if (copiedResult == null) {
            copiedResult = new CompositeTypeSpec(this.name, new FieldDecl[this.fields.length], this.subKind, this.modifiers, this.definingUnit);
            copiedResult.shareActiveFields(this);
            copiedResult.unknownTypeSymbolHolder = this.unknownTypeSymbolHolder;
            TapList<TapPair<Unit, String>> oldTypeDeclNames = this.typeDeclNames();
            copiedResult.setTypeDeclNames(oldTypeDeclNames);
            copiedResult.setOrAddTypeDeclName(this.typeDeclName());
            TapTriplet<CompositeTypeSpec, CompositeTypeSpec, Boolean> alreadyRef = new TapTriplet<CompositeTypeSpec, CompositeTypeSpec, Boolean>(this, copiedResult, Boolean.FALSE);
            toAlreadyCopied.placdl(alreadyRef);
            for (int i = this.fields.length - 1; i >= 0; --i) {
                FieldDecl copiedFieldDecl;
                FieldDecl fieldDecl = this.fields[i];
                if (fieldDecl == null) {
                    copiedResult.fields[i] = null;
                    continue;
                }
                copiedResult.fields[i] = copiedFieldDecl = new FieldDecl(fieldDecl.symbol, null);
                copiedFieldDecl.setInitializationTree(fieldDecl.getInitializationTree());
                copiedFieldDecl.setBitfieldTree(fieldDecl.bitfieldTree());
                ToBool subTypeContainsMeta = new ToBool(false);
                if (fieldDecl.type() != null) {
                    copiedFieldDecl.setType((WrapperTypeSpec)fieldDecl.type().localize(toAlreadyCopied, subTypeContainsMeta));
                }
                if (!subTypeContainsMeta.get()) continue;
                containsMeta.set(true);
            }
            if (containsMeta.get()) {
                alreadyRef.third = Boolean.TRUE;
            } else {
                alreadyRef.first = null;
            }
        }
        return copiedResult;
    }

    @Override
    public WrapperTypeSpec differentiateTypeSpec(SymbolTable symbolTable, SymbolTable srcSymbolTable, int diffUnitSort, String diffTypeSuffix, boolean localDecl, boolean multiDirMode, ArrayDim multiDirDimensionMax, String hintArrayNameInText, String hintArrayNameInIdent, Tree hintArrayNameTree, Tree nameTree) {
        if (multiDirMode && TapEnv.relatedLanguageIsFortran() && multiDirDimensionMax != null && multiDirDimensionMax.isUnknown()) {
            multiDirDimensionMax = new ArrayDim(ILUtils.buildDimColon(1, ILUtils.copy(TapEnv.get().fixedNbdirsmaxTree)), null, null, null, -1, 0, 0);
        }
        FieldDecl[] differentiatedFields = new FieldDecl[this.fields.length];
        String renamedTypeDeclName = null;
        TypeDecl typeDecl = null;
        TypeDecl renamedTypeDecl = null;
        for (int i = this.fields.length - 1; i >= 0; --i) {
            differentiatedFields[i] = null;
        }
        CompositeTypeSpec diffCompositeTypeSpec = new CompositeTypeSpec(null, differentiatedFields, this.subKind, this.modifiers, null);
        if (this.name != null) {
            diffCompositeTypeSpec.name = TapEnv.extendStringWithSuffix(this.name, diffTypeSuffix);
        }
        this.diffTypeSpec = new WrapperTypeSpec(diffCompositeTypeSpec);
        if (this.typeDeclName() != null) {
            typeDecl = symbolTable.getTypeDecl(this.typeDeclName());
            if (typeDecl == null) {
                renamedTypeDeclName = TypeSpec.getRenamedTypeDeclName(this.typeDeclNames(), symbolTable.origUnit());
                if (renamedTypeDeclName != null) {
                    typeDecl = renamedTypeDecl = symbolTable.getTypeDecl(renamedTypeDeclName);
                } else if (this.definingUnit != null && (typeDecl = this.definingUnit.publicSymbolTable().getTopTypeDecl(this.typeDeclName())) == null) {
                    typeDecl = this.definingUnit.privateSymbolTable().getTopTypeDecl(this.typeDeclName());
                }
            }
            TypeDecl activeTypeDecl = null;
            SymbolTable definitionST = null;
            if (typeDecl != null && !typeDecl.isATrueSymbolDecl) {
                typeDecl = null;
                this.diffTypeSpec = null;
            }
            if (typeDecl != null) {
                NewSymbolHolder newSymbolHolder = typeDecl.getDiffSymbolHolder(0, null, 0);
                if (newSymbolHolder == null) {
                    TapList<Object> toDefinitionST = new TapList<Object>(null, null);
                    symbolTable.getDecl(typeDecl.symbol, 4, false, toDefinitionST);
                    definitionST = (SymbolTable)toDefinitionST.head;
                    activeTypeDecl = typeDecl.activeTypeDecl(definitionST, this.diffTypeSpec, diffTypeSuffix);
                    newSymbolHolder = typeDecl.getDiffSymbolHolder(0, null, 0);
                    if (typeDecl.importedFrom != null) {
                        definitionST = (SymbolTable)typeDecl.importedFrom.second;
                        typeDecl = (TypeDecl)typeDecl.importedFrom.first;
                    }
                }
                if (newSymbolHolder != null) {
                    String typeDeclName = renamedTypeDeclName == null ? typeDecl.symbol : renamedTypeDecl.symbol;
                    TapList<Object> toDefinitionST = new TapList<Object>(null, null);
                    symbolTable.getDecl(typeDeclName, 4, false, toDefinitionST);
                    SymbolTable importST = (SymbolTable)toDefinitionST.head;
                    if (importST != null && importST.isImports) {
                        newSymbolHolder.addTypeDeclSymbolTable(importST);
                    }
                    newSymbolHolder.addTypeDeclSymbolTable(definitionST);
                    this.diffTypeSpec.wrappedType.diffTypeDeclSymbolHolder = newSymbolHolder;
                }
                if (activeTypeDecl != null) {
                    activeTypeDecl.dependsOn = typeDecl.dependsOn;
                }
                diffCompositeTypeSpec.diffFromTypeDecl = typeDecl;
                for (int i = 0; i < this.fields.length; ++i) {
                    FieldDecl fieldDecl = this.fields[i];
                    if (i < this.activeFields.length && this.activeFields[i] || !TapEnv.get().stripDiffTypes || !TapEnv.doActivity() && TypeSpec.isDifferentiableType(fieldDecl.type())) {
                        WrapperTypeSpec diffTypeSpecField = fieldDecl.type().differentiateTypeSpecMemo(symbolTable, srcSymbolTable, diffUnitSort, diffTypeSuffix, false, multiDirMode, multiDirDimensionMax, hintArrayNameInText + "%" + fieldDecl.symbol, hintArrayNameInIdent + "_" + fieldDecl.symbol, hintArrayNameTree, null);
                        FieldDecl actFieldDecl = fieldDecl;
                        if (diffTypeSpecField != null) {
                            actFieldDecl = new FieldDecl(fieldDecl.symbol, diffTypeSpecField);
                            if (fieldDecl.initializationTree() != null) {
                                actFieldDecl.setInitializationTree(ILUtils.copy(fieldDecl.getInitializationTree()));
                            }
                        }
                        actFieldDecl.setExtraInfo(fieldDecl.extraInfo());
                        diffCompositeTypeSpec.fields[i] = actFieldDecl;
                        continue;
                    }
                    if (!TapEnv.associationByAddress()) continue;
                    diffCompositeTypeSpec.fields[i] = fieldDecl;
                }
                typeDecl.setActive();
            }
        }
        if (this.diffTypeSpec != null && diffCompositeTypeSpec.isEmpty()) {
            if (typeDecl != null) {
                typeDecl.setActive(false);
            }
            this.diffTypeSpec = null;
        }
        return this.diffTypeSpec;
    }

    @Override
    protected void addDiffTypeSpec(SymbolTable symbolTable, SymbolTable srcSymbolTable) {
        NewSymbolHolder newSymbolHolder;
        TypeDecl typeDecl = null;
        TypeDecl renamedTypeDecl = null;
        if (this.typeDeclName() != null) {
            typeDecl = symbolTable.getTypeDecl(this.typeDeclName());
        }
        if (typeDecl == null && TapEnv.relatedLanguageIsFortran()) {
            String renamedTypeDeclName = TypeSpec.getRenamedTypeDeclName(this.typeDeclNames(), symbolTable.origUnit());
            if (renamedTypeDeclName != null) {
                typeDecl = renamedTypeDecl = symbolTable.getTypeDecl(renamedTypeDeclName);
                if (typeDecl.importedFrom != null) {
                    typeDecl = (TypeDecl)typeDecl.importedFrom.first;
                }
            } else if (this.typeDeclName() != null) {
                typeDecl = symbolTable.getTypeDecl(this.typeDeclName());
            }
        }
        if (typeDecl != null && (newSymbolHolder = typeDecl.getDiffSymbolHolder(0, null, 0)) != null) {
            String typeDeclName = renamedTypeDecl == null ? typeDecl.symbol : renamedTypeDecl.symbol;
            TapList<Object> toDefinitionST = new TapList<Object>(null, null);
            symbolTable.getDecl(typeDeclName, 4, false, toDefinitionST);
            SymbolTable importST = (SymbolTable)toDefinitionST.head;
            if (importST != null && importST.isImports) {
                newSymbolHolder.addTypeDeclSymbolTable(importST);
            }
        }
    }

    @Override
    protected void cumulActiveParts(TapList diffInfos, SymbolTable symbolTable) {
        if (diffInfos != null) {
            TypeDecl typeDecl;
            for (int i = 0; i < this.fields.length && diffInfos != null; ++i) {
                if (this.fields[i] != null) {
                    WrapperTypeSpec fieldTypeSpec = this.fields[i].type();
                    TapList fieldDiffInfos = diffInfos.head instanceof TapList ? (TapList)diffInfos.head : diffInfos;
                    boolean fieldIsActive = TapList.oneTrue(fieldDiffInfos);
                    if (i < this.activeFields.length && fieldIsActive) {
                        this.activeFields[i] = true;
                        ((TypeSpec)fieldTypeSpec).cumulActiveParts(fieldDiffInfos, symbolTable);
                    }
                }
                diffInfos = diffInfos.tail;
            }
            if (this.typeDeclName() != null && this.needsADiffType(null) && (typeDecl = symbolTable.getTypeDecl(this.typeDeclName())) != null) {
                typeDecl.setActive(true);
            }
        }
    }

    @Override
    public boolean needsADiffType(TapList<TypeSpec> dejaVu) {
        if (TapList.contains(dejaVu, this)) {
            return false;
        }
        boolean diffNeeded = false;
        boolean oneFieldDiff = false;
        boolean oneFieldNoDiff = false;
        dejaVu = new TapList<TypeSpec>(this, dejaVu);
        for (int i = this.fields.length - 1; !diffNeeded && i >= 0; --i) {
            WrapperTypeSpec fieldTypeSpec;
            WrapperTypeSpec wrapperTypeSpec = fieldTypeSpec = this.fields[i] == null ? null : this.fields[i].type();
            if (fieldTypeSpec == null || i >= this.activeFields.length) continue;
            if (this.activeFields[i]) {
                diffNeeded = ((TypeSpec)fieldTypeSpec).needsADiffType(dejaVu);
                oneFieldDiff = true;
                continue;
            }
            oneFieldNoDiff = true;
        }
        return diffNeeded || oneFieldDiff && oneFieldNoDiff;
    }

    @Override
    public boolean isDifferentiated(TapList<TypeSpec> dejaVu) {
        boolean isDiff = false;
        for (int i = this.fields.length - 1; !isDiff && i >= 0; --i) {
            isDiff = i < this.activeFields.length && this.activeFields[i];
        }
        return isDiff;
    }

    @Override
    protected boolean checkTypeSpecValidity(TapList<TypeSpec> dejaVu) {
        for (int i = this.fields.length - 1; i >= 0; --i) {
            if (this.fields[i] == null || this.fields[i].type() == null) continue;
            WrapperTypeSpec elementType = this.fields[i].type();
            if (elementType != null && elementType.wrappedType == this) {
                TapEnv.fileWarning(15, null, "(TC41) Illegal recursive type definition " + this.showType());
                return false;
            }
            if (TapList.contains(dejaVu, elementType)) continue;
            dejaVu = new TapList<TypeSpec>(elementType, dejaVu);
            assert (elementType != null);
            if (elementType.checkTypeSpecValidity(dejaVu)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Tree generateTree(SymbolTable symbolTable, TapList<SymbolDecl> dependsOn, TapList<SymbolDecl> shortNames, boolean useShortNames, TapList<TypeSpec> dejaVu) {
        Tree result;
        Tree nameTree = this.name != null ? ILUtils.build(96, this.name) : ILUtils.build(138);
        boolean generateTypeName = !TapEnv.relatedLanguageIsFortran() ? useShortNames && (this.diffTypeDeclSymbolHolder != null && this.diffTypeSpec == null || this.name != null || this.typeDeclName() != null) : useShortNames;
        if (generateTypeName) {
            if (this.diffTypeDeclSymbolHolder != null && this.diffTypeSpec == null) {
                nameTree = this.diffTypeDeclSymbolHolder.makeNewRef(symbolTable);
            } else if (this.unknownTypeSymbolHolder != null) {
                nameTree = this.unknownTypeSymbolHolder.makeNewRef(symbolTable);
            } else {
                NewSymbolHolder diffSH;
                NewSymbolHolder newSymbolHolder = diffSH = this.diffFromTypeDecl == null ? null : this.diffFromTypeDecl.getDiffSymbolHolder(0, null, 0);
                if (diffSH != null) {
                    boolean fromOtherCompilationUnit = symbolTable != null && TapEnv.isC(symbolTable.language()) && diffSH.solvingRootIsOutsideFile(symbolTable);
                    nameTree = diffSH.makeNewRef(fromOtherCompilationUnit ? null : symbolTable);
                } else {
                    nameTree = this.name != null ? ILUtils.build(96, this.name) : ILUtils.build(96, this.typeDeclName());
                }
            }
            result = nameTree;
        } else if (TapList.contains(dejaVu, this)) {
            TapEnv.toolWarning(-1, "(TypeSpec tree regeneration) circular type");
            result = ILUtils.build(96, "CircularType");
        } else {
            dejaVu = new TapList<TypeSpec>(this, dejaVu);
            result = this.isRecordType() ? ILUtils.build(161, nameTree, ILUtils.copy(this.modifiers), ILUtils.build(53)) : ILUtils.build(195, nameTree, ILUtils.build(200));
            int nbSons = 0;
            for (FieldDecl field : this.fields) {
                if (field == null) continue;
                WrapperTypeSpec fieldTypeSpec = field.type();
                fieldTypeSpec = fieldTypeSpec.equalsDiffTypeSpecAndTypeSpec();
                WrapperTypeSpec sharedTypeSpec = fieldTypeSpec.equalsDiffTypeSpecAndTypeSpec();
                if (!TapEnv.relatedLanguageIsFortran()) {
                    while (CompositeTypeSpec.isA(sharedTypeSpec, 2) || CompositeTypeSpec.isA(sharedTypeSpec, 6) && ((PointerTypeSpec)sharedTypeSpec.wrappedType).offsetLength != null) {
                        if (CompositeTypeSpec.isA(sharedTypeSpec, 2)) {
                            sharedTypeSpec = sharedTypeSpec.wrappedType.elementType();
                            continue;
                        }
                        sharedTypeSpec = ((PointerTypeSpec)sharedTypeSpec.wrappedType).destinationType;
                    }
                }
                Tree declarator = ILUtils.build(96, field.symbol);
                declarator = CompositeTypeSpec.addDeclaratorModifiers(declarator, field.accessInfo);
                declarator = CompositeTypeSpec.generateDeclaratorTree(sharedTypeSpec, null, declarator, fieldTypeSpec);
                if (field.initializationTree() != null) {
                    declarator = ILUtils.copy(field.generateInitializationTree());
                } else if (field.bitfieldTree() != null) {
                    declarator = ILUtils.build(26, declarator, field.bitfieldTree());
                }
                Tree sharedTypeTree = sharedTypeSpec.generateTree(symbolTable, field.dependsOn(), shortNames, true, dejaVu);
                if (field.extraInfo() != null) {
                    sharedTypeTree = ILUtils.build(129, ILUtils.build(130, ILUtils.buildListIdents(field.extraInfo())), sharedTypeTree);
                }
                Tree declaration = ILUtils.build(199, ILUtils.build(130), sharedTypeTree, ILUtils.build(54, declarator));
                result.down(result.length()).setChild(declaration, nbSons + 1);
                ++nbSons;
            }
        }
        result.setAnnotation("WrapperTypeSpec", new WrapperTypeSpec(this));
        return result;
    }

    @Override
    public String showType() {
        String shorthandName = this.typeDeclName();
        if (shorthandName == null) {
            String nameStrg;
            String string = nameStrg = this.name == null ? " unnamed" : " " + this.name;
            if (this.isRecordType()) {
                if (TapEnv.relatedLanguageIsFortran()) {
                    return "derived TYPE " + nameStrg.toUpperCase();
                }
                return "Record " + nameStrg;
            }
            return "Union " + nameStrg;
        }
        if (TapEnv.relatedLanguageIsFortran()) {
            return "derived TYPE " + shorthandName.toUpperCase();
        }
        return shorthandName;
    }

    @Override
    public void dump() throws IOException {
        TapEnv.print(this.toString());
    }

    @Override
    public String toString() {
        StringBuilder fieldsString;
        if (this.fields == null) {
            fieldsString = new StringBuilder("??");
        } else {
            fieldsString = new StringBuilder("(");
            for (int i = 0; i < this.fields.length; ++i) {
                if (i > 0) {
                    fieldsString.append(',');
                }
                fieldsString.append(this.fields[i] == null ? Character.valueOf('?') : this.fields[i].symbol + (this.isDifferentiatedField(i) ? "@" : "") + (this.fields[i].accessInfo == null ? "" : " access:" + this.fields[i].accessInfo));
            }
            fieldsString.append(')');
        }
        return (this.typeDeclName() == null ? "" : "\"" + this.typeDeclName() + "(generated as:" + this.genTypeDeclName() + ")\":") + (this.isRecordType() ? "record" : "union") + (this.name == null ? " unnamed" : " " + this.name) + " of " + fieldsString;
    }
}

