/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.representation;

import fr.inria.tapenade.analysis.InOutAnalyzer;
import fr.inria.tapenade.analysis.LoopArrayAccessAnalyzer;
import fr.inria.tapenade.analysis.PointerAnalyzer;
import fr.inria.tapenade.frontend.TreeProtocol;
import fr.inria.tapenade.representation.BasicBlock;
import fr.inria.tapenade.representation.Block;
import fr.inria.tapenade.representation.CallArrow;
import fr.inria.tapenade.representation.Directive;
import fr.inria.tapenade.representation.FunctionDecl;
import fr.inria.tapenade.representation.FunctionTypeSpec;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.Instruction;
import fr.inria.tapenade.representation.MPIcallInfo;
import fr.inria.tapenade.representation.MemMap;
import fr.inria.tapenade.representation.MemoryMaps;
import fr.inria.tapenade.representation.MixedLanguageInfos;
import fr.inria.tapenade.representation.PointerTypeSpec;
import fr.inria.tapenade.representation.PositionAndMessage;
import fr.inria.tapenade.representation.SymbolDecl;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.TypeDecl;
import fr.inria.tapenade.representation.TypeSpec;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.representation.VariableDecl;
import fr.inria.tapenade.representation.WrapperTypeSpec;
import fr.inria.tapenade.representation.ZoneAllocator;
import fr.inria.tapenade.representation.ZoneInfo;
import fr.inria.tapenade.representation.ZoneInfoAccessElements;
import fr.inria.tapenade.utils.TapIntList;
import fr.inria.tapenade.utils.TapPair;
import fr.inria.tapenade.utils.TapTriplet;
import fr.inria.tapenade.utils.Tree;
import java.io.IOException;

public final class CallGraph {
    private SymbolTable globalRootSymbolTable;
    private SymbolTable fortranRootSymbolTable;
    private SymbolTable cRootSymbolTable;
    private SymbolTable cudaRootSymbolTable;
    private SymbolTable cPlusPlusRootSymbolTable;
    public MemoryMaps globalFortranMaps;
    public TapList<TapList<ZoneInfoAccessElements>> globalCMaps;
    public TapList<String> usedCommonNames = null;
    public TapList<ZoneInfo> allGlobalsForExternals = null;
    public int[] globalsForExternalsNumber4;
    public int[] globalZonesNumber4;
    public TapList<TapPair<String, TypeSpec>> toSharingTypes = new TapList<Object>(null, null);
    public TapList<TapPair<Unit, TapList<Unit>>> backAssociations;
    public Block topBlock;
    public TapList<Unit> MPIRecvCalls;
    public Tree topPreComments;
    public Tree topPostComments;
    public Tree topPreCommentsBlock;
    public Tree topPostCommentsBlock;
    public int zoneNbOfNullDest;
    public int zoneNbOfUnknownDest;
    public int zoneNbOfAllIOStreams;
    public int numberOfDummyRootZones;
    private final String callGraphName;
    private Unit mainUnit;
    private int nbUnits;
    private TapList<Unit> units;
    private TapList<Unit> topUnits;
    private TapList<Unit> intrinsicUnits;
    private TapList<Unit> interfaceUnits;
    private TapList<TapTriplet<String, String, FunctionDecl>> bindFortranCFunctions;
    private Unit[] sortedUnits;
    private TapList<Unit> recursivityUnits;
    private TapList<SymbolTable> translationUnitSymbolTables;
    private TreeProtocol inputStream;
    private TapList<TreeProtocol> inputStreams;
    private TapList<TapPair<TapPair<Tree, Tree>, TapPair<TypeSpec, SymbolTable>>> allocationPoints;
    private TapList<TapPair<MPIcallInfo, TapIntList>> allMessagePassingChannels;
    private TapList<TapTriplet<FunctionDecl, Unit, TapPair<FunctionDecl, SymbolTable>>> previousFunctionDeclAndNewUnitList;
    private int debuglevel;
    private TapList<Unit> bindFortranCDiffUnits;
    private TapList<TapPair<TypeDecl, TypeDecl>> bindFortranCType;
    public boolean hasCuda = false;
    private static final int SORT_INIT = 0;
    private static final int SORT_RECURSIVITY = 1;
    private static final int SORT_OK = 2;

    public SymbolTable globalRootSymbolTable() {
        return this.globalRootSymbolTable;
    }

    public void setGlobalRootSymbolTable(SymbolTable globalRootSymbolTable) {
        this.globalRootSymbolTable = globalRootSymbolTable;
    }

    public SymbolTable fortranRootSymbolTable() {
        return this.fortranRootSymbolTable;
    }

    public void setFortranRootSymbolTable(SymbolTable fortranRootSymbolTable) {
        this.fortranRootSymbolTable = fortranRootSymbolTable;
    }

    public SymbolTable cRootSymbolTable() {
        return this.cRootSymbolTable;
    }

    public void setCRootSymbolTable(SymbolTable cRootSymbolTable) {
        this.cRootSymbolTable = cRootSymbolTable;
    }

    public SymbolTable cudaRootSymbolTable() {
        return this.cudaRootSymbolTable;
    }

    public void setCudaRootSymbolTable(SymbolTable cudaRootSymbolTable) {
        this.cudaRootSymbolTable = cudaRootSymbolTable;
    }

    public SymbolTable cPlusPlusRootSymbolTable() {
        return this.cPlusPlusRootSymbolTable;
    }

    public void setCPlusPlusRootSymbolTable(SymbolTable cPlusPlusRootSymbolTable) {
        this.cPlusPlusRootSymbolTable = cPlusPlusRootSymbolTable;
    }

    public boolean isCommonName(String name) {
        return TapList.containsEquals(this.usedCommonNames, name);
    }

    public CallGraph(String name) {
        this.callGraphName = name;
        this.topBlock = new BasicBlock(null, null, null);
        this.topBlock.rank = 54;
        this.globalFortranMaps = new MemoryMaps();
        this.globalCMaps = null;
        this.usedCommonNames = null;
    }

    public static CallArrow addCallArrow(Unit origin, int kind, Unit destination) {
        CallArrow foundArrow = CallGraph.getCallArrow(origin, destination);
        if (foundArrow == null) {
            foundArrow = new CallArrow(origin, destination);
        }
        foundArrow.addKind(kind);
        if (kind == 1) {
            foundArrow.setTimes(foundArrow.times() + 1);
        }
        return foundArrow;
    }

    private static void delCallArrow(Unit origin, int kind, Unit destination) {
        CallArrow foundArrow = CallGraph.getCallArrow(origin, destination);
        assert (foundArrow != null);
        if (kind == 1) {
            foundArrow.setTimes(foundArrow.times() - 1);
        }
        foundArrow.delKind(kind);
        if (foundArrow.times() == 0 && !foundArrow.isImport() && !foundArrow.isContain()) {
            foundArrow.delete();
        }
    }

    public static CallArrow getCallArrow(Unit callerUnit, Unit calleeUnit) {
        boolean found = false;
        CallArrow res = null;
        if (calleeUnit.isIntrinsic() && !calleeUnit.hasSource()) {
            res = calleeUnit.genericArrow;
            res.origin = callerUnit;
        } else {
            TapList<CallArrow> tmpList = calleeUnit.callers();
            while (tmpList != null && !found) {
                if (((CallArrow)tmpList.head).origin == callerUnit) {
                    found = true;
                    res = (CallArrow)tmpList.head;
                }
                tmpList = tmpList.tail;
            }
        }
        return res;
    }

    private static MixedLanguageInfos functionNameBinding(int callerLanguage, int calleeLanguage) {
        TapList<MixedLanguageInfos> mixedLanguageInfos = TapEnv.mixedLanguageInfos();
        MixedLanguageInfos infos = null;
        boolean found = false;
        while (mixedLanguageInfos != null && !found) {
            infos = (MixedLanguageInfos)mixedLanguageInfos.head;
            if (infos.getOrigLangCaller() == callerLanguage && infos.getDestLangCallee() == calleeLanguage) {
                found = true;
            }
            mixedLanguageInfos = mixedLanguageInfos.tail;
        }
        return infos;
    }

    public static void dumpCompactCallGraph(TapList<Unit> unitsToDump) throws IOException {
        CallArrow arrow;
        TapList<CallArrow> callArrows;
        Unit unit;
        TapList<Unit> inUnitsToDump = unitsToDump;
        TapEnv.println("Nodes :");
        while (inUnitsToDump != null) {
            Unit containerUnit;
            unit = (Unit)inUnitsToDump.head;
            TapEnv.print(" [" + unit.rank() + "] ");
            if (unit.isTranslationUnit()) {
                TapEnv.print(" File (\"Translation Unit\") ");
            } else if (unit.isStandard()) {
                TapEnv.print(" Procedure ");
            } else if (unit.isExternal()) {
                TapEnv.print(" External procedure ");
            } else if (unit.isModule()) {
                TapEnv.print(" Module ");
            } else if (unit.isInterface()) {
                TapEnv.print(" Interface ");
            } else if (unit.isVarFunction()) {
                TapEnv.print(" VarFunction ");
            }
            if (containerUnit != null) {
                String containerString = "";
                for (containerUnit = unit.upperLevelUnit(); containerUnit != null; containerUnit = containerUnit.upperLevelUnit()) {
                    containerString = containerUnit.name() + "[" + containerUnit.rank() + "]:" + containerString;
                }
                TapEnv.print(containerString);
            }
            unit.cite();
            if (!unit.isModule() && unit.functionTypeSpec() != null) {
                FunctionTypeSpec funcType = unit.functionTypeSpec();
                boolean hasGlobalArgs = unit.hasGlobalArgs();
                WrapperTypeSpec[] argumentsTypes = funcType.argumentsTypes;
                TapEnv.print(" ");
                if (argumentsTypes != null) {
                    TapEnv.print("(");
                    for (int i = 0; i < argumentsTypes.length; ++i) {
                        TapEnv.print(argumentsTypes[i] + (i < argumentsTypes.length - 1 ? "," : ""));
                    }
                    if (hasGlobalArgs) {
                        TapEnv.print(" + Globals");
                    }
                    TapEnv.print(")");
                }
                TapEnv.print("=>" + funcType.returnType);
            }
            TapEnv.println();
            inUnitsToDump = inUnitsToDump.tail;
        }
        TapEnv.println();
        TapEnv.println("Call graph :");
        inUnitsToDump = unitsToDump;
        while (inUnitsToDump != null) {
            unit = (Unit)inUnitsToDump.head;
            callArrows = unit.callees();
            while (callArrows != null) {
                arrow = (CallArrow)callArrows.head;
                if (arrow.isCall() && TapList.contains(unitsToDump, arrow.destination)) {
                    TapEnv.print(" [" + unit.rank() + "] ");
                    unit.cite();
                    TapEnv.print(" calls [" + arrow.destination.rank() + "] ");
                    arrow.destination().cite();
                    TapEnv.println();
                }
                callArrows = callArrows.tail;
            }
            inUnitsToDump = inUnitsToDump.tail;
        }
        TapEnv.println();
        TapEnv.println("Use graph :");
        inUnitsToDump = unitsToDump;
        while (inUnitsToDump != null) {
            unit = (Unit)inUnitsToDump.head;
            callArrows = unit.callees();
            while (callArrows != null) {
                arrow = (CallArrow)callArrows.head;
                if (arrow.isImport() && TapList.contains(unitsToDump, arrow.destination)) {
                    TapEnv.println(" [" + unit.rank() + "] " + unit.name() + " imports [" + arrow.destination.rank() + "] " + arrow.destination.name());
                }
                callArrows = callArrows.tail;
            }
            inUnitsToDump = inUnitsToDump.tail;
        }
    }

    public String name() {
        return this.callGraphName;
    }

    public Unit getMainUnit() {
        return this.mainUnit;
    }

    public void setMainUnit(Unit unit) {
        this.mainUnit = unit;
    }

    public int nbUnits() {
        return this.nbUnits;
    }

    public TapList<Unit> units() {
        return this.units;
    }

    public TapList<Unit> topUnits() {
        return this.topUnits;
    }

    public TapList<Unit> intrinsicUnits() {
        return this.intrinsicUnits;
    }

    public void addIntrinsicUnit(Unit unit) {
        this.intrinsicUnits = new TapList<Unit>(unit, this.intrinsicUnits);
    }

    public TapList<Unit> interfaceUnits() {
        return this.interfaceUnits;
    }

    public void setInterfaceUnits(TapList<Unit> units) {
        this.interfaceUnits = units;
    }

    public TapList<TapTriplet<String, String, FunctionDecl>> bindFortranCFunctions() {
        return this.bindFortranCFunctions;
    }

    public void setBindCFortranCFunctions(TapList<TapTriplet<String, String, FunctionDecl>> origBindC) {
        this.bindFortranCFunctions = origBindC;
    }

    public Unit sortedUnit(int rank) {
        if (rank >= this.sortedUnits.length) {
            return null;
        }
        return this.sortedUnits[rank];
    }

    public TapList<Unit> sortedUnits() {
        return TapList.fromObjectArray(this.sortedUnits);
    }

    public TapList<Unit> sortedComputationalUnits() {
        TapList<Unit> result = null;
        for (int i = this.nbUnits - 1; i >= 0; --i) {
            Unit unit = this.sortedUnits[i];
            if (unit == null || !unit.isStandard() && !unit.isOutside()) continue;
            result = new TapList<Unit>(unit, result);
        }
        return result;
    }

    public TapList<Unit> getRecursivityUnits() {
        return this.recursivityUnits;
    }

    public SymbolTable languageRootSymbolTable(int language) {
        switch (language) {
            case 1: 
            case 2: 
            case 3: {
                return this.fortranRootSymbolTable;
            }
            case 4: {
                return this.cRootSymbolTable;
            }
            case 6: {
                return this.cudaRootSymbolTable;
            }
            case 5: {
                return this.cPlusPlusRootSymbolTable;
            }
        }
        return this.globalRootSymbolTable;
    }

    public void createRootSymbolTables() {
        this.globalRootSymbolTable = new SymbolTable(null);
        this.globalRootSymbolTable.setLanguage(-1);
        this.globalRootSymbolTable.setCaseDependent(true);
        this.globalRootSymbolTable.setShortName("Root SymbolTable");
        this.globalRootSymbolTable.setIsGlobal();
        this.globalRootSymbolTable.declarationsBlock = this.topBlock;
        this.globalRootSymbolTable.setRootCallGraph(this);
        this.globalRootSymbolTable.addPrimitiveTypes();
        this.topBlock.symbolTable = this.globalRootSymbolTable;
        this.fortranRootSymbolTable = new SymbolTable(this.globalRootSymbolTable);
        this.fortranRootSymbolTable.setLanguage(1);
        this.fortranRootSymbolTable.setCaseDependent(false);
        this.fortranRootSymbolTable.setShortName("Fortran language SymbolTable");
        this.fortranRootSymbolTable.setIsGlobal();
        this.fortranRootSymbolTable.declarationsBlock = new BasicBlock(this.fortranRootSymbolTable, null, null);
        this.fortranRootSymbolTable.implicits = new WrapperTypeSpec[26];
        this.cRootSymbolTable = new SymbolTable(this.globalRootSymbolTable);
        this.cRootSymbolTable.setLanguage(4);
        this.cRootSymbolTable.setCaseDependent(true);
        this.cRootSymbolTable.setShortName("C language SymbolTable");
        this.cRootSymbolTable.setIsGlobal();
        this.cRootSymbolTable.declarationsBlock = new BasicBlock(this.cRootSymbolTable, null, null);
        this.cudaRootSymbolTable = new SymbolTable(this.cRootSymbolTable);
        this.cudaRootSymbolTable.setLanguage(6);
        this.cudaRootSymbolTable.setCaseDependent(true);
        this.cudaRootSymbolTable.setShortName("Cuda language SymbolTable");
        this.cudaRootSymbolTable.setIsGlobal();
        this.cudaRootSymbolTable.declarationsBlock = new BasicBlock(this.cudaRootSymbolTable, null, null);
        this.cPlusPlusRootSymbolTable = new SymbolTable(this.globalRootSymbolTable);
        this.cPlusPlusRootSymbolTable.setLanguage(5);
        this.cPlusPlusRootSymbolTable.setCaseDependent(true);
        this.cPlusPlusRootSymbolTable.setShortName("C++ language SymbolTable");
        this.cPlusPlusRootSymbolTable.setIsGlobal();
        this.cPlusPlusRootSymbolTable.declarationsBlock = new BasicBlock(this.cPlusPlusRootSymbolTable, null, null);
    }

    public void addTranslationUnitSymbolTable(SymbolTable symbolTable) {
        this.translationUnitSymbolTables = new TapList<SymbolTable>(symbolTable, this.translationUnitSymbolTables);
    }

    public TapList<SymbolTable> getTranslationUnitSymbolTables() {
        return this.translationUnitSymbolTables;
    }

    public void setInputStream(TreeProtocol stream) {
        this.inputStream = stream;
    }

    public TapList<TapPair<MPIcallInfo, TapIntList>> getAllMessagePassingChannels() {
        return this.allMessagePassingChannels;
    }

    public void setAllMessagePassingChannels(TapList<TapPair<MPIcallInfo, TapIntList>> allChannels) {
        this.allMessagePassingChannels = allChannels;
    }

    public TapIntList getAllMessagePassingChannelZones() {
        TapList<TapPair<MPIcallInfo, TapIntList>> inAllChannels = this.allMessagePassingChannels;
        TapIntList result = null;
        while (inAllChannels != null) {
            result = TapIntList.append((TapIntList)((TapPair)inAllChannels.head).second, result);
            inAllChannels = inAllChannels.tail;
        }
        return result;
    }

    public boolean isAMessagePassingChannelZone(int zoneNb) {
        TapList<TapPair<MPIcallInfo, TapIntList>> inAllChannels = this.allMessagePassingChannels;
        boolean isMPZ = false;
        while (inAllChannels != null && !isMPZ) {
            isMPZ = TapIntList.contains((TapIntList)((TapPair)inAllChannels.head).second, zoneNb);
            inAllChannels = inAllChannels.tail;
        }
        return isMPZ;
    }

    public Unit createNewIntrinsicUnit(String name, int language) {
        Unit newUnit = new Unit(this, -1, null, language);
        newUnit.genericArrow = new CallArrow(null, newUnit);
        newUnit.setIntrinsic();
        newUnit.setName(name);
        newUnit.activityPatterns = null;
        this.addIntrinsicUnit(newUnit);
        return newUnit;
    }

    public Unit createNewUnit(Unit upperLevelUnit, int language) {
        Unit newUnit = new Unit(this, this.nbUnits, upperLevelUnit, language);
        this.units = new TapList<Unit>(newUnit, this.units);
        this.attachToUpperUnit(newUnit, upperLevelUnit);
        if (TapEnv.inIncludeFile()) {
            newUnit.setFromInclude(Instruction.fromIncludeCopy(TapEnv.currentIncludeInstruction(), true));
        }
        ++this.nbUnits;
        return newUnit;
    }

    public void detachFromUpperUnit(Unit unit) {
        if (unit.upperLevelUnit() != null) {
            unit.upperLevelUnit().lowerLevelUnits = TapList.delete(unit, unit.upperLevelUnit().lowerLevelUnits);
            CallGraph.delCallArrow(unit.upperLevelUnit(), 3, unit);
        } else {
            this.topUnits = TapList.delete(unit, this.topUnits);
        }
        unit.setUpperLevelUnit(null);
    }

    public void attachToUpperUnit(Unit unit, Unit upper) {
        unit.setUpperLevelUnit(upper);
        if (upper == null) {
            this.topUnits = new TapList<Unit>(unit, this.topUnits);
        } else {
            upper.lowerLevelUnits = new TapList<Unit>(unit, upper.lowerLevelUnits);
            CallGraph.addCallArrow(upper, 3, unit);
        }
    }

    public void deleteUnit(Unit unit) {
        if (unit.isIntrinsic() || !unit.wasDeleted()) {
            TapList msgs;
            if (!unit.isIntrinsic()) {
                unit.setDeleted();
            }
            if (!unit.isInterface()) {
                this.deleteBindFortranCFunction(unit);
            }
            TapList<Unit> lowerUnits = unit.lowerLevelUnits;
            while (lowerUnits != null) {
                this.deleteUnit((Unit)lowerUnits.head);
                lowerUnits = lowerUnits.tail;
            }
            unit.lowerLevelUnits = null;
            if (TapEnv.relatedUnit() == unit) {
                TapEnv.popRelatedUnit();
            }
            if ((msgs = unit.messages.tail) != null) {
                while (msgs != null) {
                    ((PositionAndMessage)msgs.head).setPosition(-1);
                    msgs = msgs.tail;
                }
                TapEnv.get().danglingMessages = TapList.append(TapEnv.get().danglingMessages, unit.messages.tail);
                unit.messages.tail = null;
            }
            if (unit.upperLevelUnit() != null) {
                unit.upperLevelUnit().lowerLevelUnits = TapList.delete(unit, unit.upperLevelUnit().lowerLevelUnits);
            } else {
                this.topUnits = TapList.delete(unit, this.topUnits);
            }
            if (unit.callers != null) {
                TapList<CallArrow> callerArrows = unit.callers;
                while (callerArrows != null) {
                    CallArrow callerArrow = (CallArrow)callerArrows.head;
                    if (callerArrow.origin != null) {
                        callerArrow.origin.callees = TapList.delete(callerArrow, callerArrow.origin.callees);
                    }
                    callerArrows = callerArrows.tail;
                }
            }
            this.units = TapList.delete(unit, this.units);
            unit.setRank(-1);
            if (!unit.isIntrinsic()) {
                --this.nbUnits;
            }
        }
    }

    public void deleteUnitFromSymbolTable(Unit unit) {
        SymbolTable unitSymbolTable = unit.publicSymbolTable();
        if (unitSymbolTable == null) {
            unitSymbolTable = this.languageRootSymbolTable(unit.language());
        }
        unitSymbolTable.removeDecl(unit.name(), 3, false);
    }

    public void resetPreviousFunctionDeclAndNewUnit() {
        this.previousFunctionDeclAndNewUnitList = null;
    }

    public TapTriplet<FunctionDecl, Unit, TapPair<FunctionDecl, SymbolTable>> getPreviousFunctionDeclAndNewUnit(String name) {
        TapList<TapTriplet<FunctionDecl, Unit, TapPair<FunctionDecl, SymbolTable>>> list = this.previousFunctionDeclAndNewUnitList;
        TapTriplet previousFunctionDeclAndNewUnit = null;
        while (list != null && previousFunctionDeclAndNewUnit == null) {
            if (((FunctionDecl)((TapTriplet)this.previousFunctionDeclAndNewUnitList.head).first).symbol.equals(name)) {
                previousFunctionDeclAndNewUnit = (TapTriplet)this.previousFunctionDeclAndNewUnitList.head;
            }
            list = list.tail;
        }
        return previousFunctionDeclAndNewUnit;
    }

    public void setPreviousFunctionDeclAndNewUnit(FunctionDecl oldFunctionDecl, Unit newUnit) {
        this.previousFunctionDeclAndNewUnitList = new TapList<TapTriplet<FunctionDecl, Unit, TapPair<FunctionDecl, SymbolTable>>>(new TapTriplet<FunctionDecl, Unit, Object>(oldFunctionDecl, newUnit, null), this.previousFunctionDeclAndNewUnitList);
    }

    public void absorbAndDeleteAfterCreateNewUnit() {
        while (this.previousFunctionDeclAndNewUnitList != null) {
            TapTriplet previousFunctionDeclAndNewUnit = (TapTriplet)this.previousFunctionDeclAndNewUnitList.head;
            FunctionDecl oldFunctionDecl = (FunctionDecl)previousFunctionDeclAndNewUnit.first;
            Unit finalUnit = (Unit)previousFunctionDeclAndNewUnit.second;
            TapPair newPair = (TapPair)previousFunctionDeclAndNewUnit.third;
            this.solveAndRemoveInterface(new TapList<FunctionDecl>(oldFunctionDecl, null), newPair == null ? null : (FunctionDecl)newPair.first, finalUnit, newPair == null ? null : (SymbolTable)newPair.second);
            this.previousFunctionDeclAndNewUnitList = this.previousFunctionDeclAndNewUnitList.tail;
        }
    }

    public void fixRemainingInterfaces() {
        TapList<Unit> toInterfaces;
        TapList<Unit> inInterfaces = toInterfaces = new TapList<Unit>(null, this.interfaceUnits);
        while (inInterfaces.tail != null) {
            Unit interfaceUnit = (Unit)inInterfaces.tail.head;
            String interfaceName = interfaceUnit.name();
            Unit enclosingUnit = interfaceUnit.enclosingUnitOfInterface;
            FunctionDecl interfaceDecl = (FunctionDecl)enclosingUnit.publicSymbolTable().getDecl(interfaceName, 3, true);
            if (interfaceDecl == null) {
                interfaceDecl = (FunctionDecl)enclosingUnit.privateSymbolTable().getDecl(interfaceName, 3, true);
            }
            Unit trueUnit = null;
            TapList<Unit> inUnits = this.units;
            while (trueUnit == null && inUnits != null) {
                if (inUnits.head != null && !((Unit)inUnits.head).wasDeleted() && !((Unit)inUnits.head).isInterface() && !((Unit)inUnits.head).isVarFunction() && interfaceName.equals(((Unit)inUnits.head).name()) && interfaceUnit.functionTypeSpec().receives(((Unit)inUnits.head).functionTypeSpec(), null, null)) {
                    trueUnit = (Unit)inUnits.head;
                }
                inUnits = inUnits.tail;
            }
            inUnits = this.units;
            while (trueUnit == null && inUnits != null) {
                if (inUnits.head != null && !((Unit)inUnits.head).wasDeleted() && !((Unit)inUnits.head).isInterface() && !((Unit)inUnits.head).isVarFunction() && interfaceName.equals(((Unit)inUnits.head).name())) {
                    trueUnit = (Unit)inUnits.head;
                }
                inUnits = inUnits.tail;
            }
            if (trueUnit != null) {
                if (trueUnit != interfaceDecl.unit()) {
                    trueUnit.absorb(interfaceUnit);
                    this.deleteUnit(interfaceUnit);
                    interfaceDecl.setUnit(trueUnit);
                    interfaceDecl.setNoneInstruction();
                }
                inInterfaces.tail = inInterfaces.tail.tail;
                continue;
            }
            inInterfaces = inInterfaces.tail;
        }
        this.interfaceUnits = toInterfaces.tail;
    }

    private void solveAndRemoveInterface(TapList<FunctionDecl> waitingDecls, FunctionDecl finalDecl, Unit finalUnit, SymbolTable hostSymbolTable) {
        TapList<Unit> alreadyDeletedUnits = null;
        while (waitingDecls != null) {
            FunctionDecl oldFunctionDecl = (FunctionDecl)waitingDecls.head;
            if (finalUnit != oldFunctionDecl.unit()) {
                finalUnit.absorb(oldFunctionDecl.unit());
                this.deleteUnit(oldFunctionDecl.unit());
                alreadyDeletedUnits = new TapList<Unit>(oldFunctionDecl.unit(), alreadyDeletedUnits);
                oldFunctionDecl.setUnit(finalUnit);
                oldFunctionDecl.setNoneInstruction();
            }
            waitingDecls = waitingDecls.tail;
        }
        if (finalDecl != null) {
            hostSymbolTable.addSymbolDecl(finalDecl);
            if (hostSymbolTable == TapEnv.currentTranslationUnitSymbolTable() && !finalUnit.isPrivate() && hostSymbolTable.basisSymbolTable() == this.cRootSymbolTable) {
                FunctionDecl sharedDecl;
                TapList<FunctionDecl> existingDecls = this.cRootSymbolTable.getTopFunctionDecl(finalUnit.name(), null, null, null, false);
                FunctionDecl functionDecl = sharedDecl = existingDecls == null ? null : (FunctionDecl)existingDecls.head;
                if (sharedDecl == null) {
                    sharedDecl = new FunctionDecl(ILUtils.build(96, finalUnit.name()), finalUnit);
                    sharedDecl.shareUnitFrom(finalDecl);
                    sharedDecl.setZones(finalDecl.zones());
                    sharedDecl.isATrueSymbolDecl = finalDecl.isATrueSymbolDecl;
                    this.cRootSymbolTable.addSymbolDecl(sharedDecl);
                } else {
                    if (finalUnit != sharedDecl.unit()) {
                        Unit unitToRemove = sharedDecl.unit();
                        finalUnit.absorb(unitToRemove);
                        sharedDecl.setUnit(finalUnit);
                        if (!TapList.contains(alreadyDeletedUnits, unitToRemove)) {
                            this.deleteUnit(unitToRemove);
                        }
                    }
                    finalDecl.shareUnitFrom(sharedDecl);
                }
            }
        }
    }

    private void detectRecursivity(boolean inModule) {
        TapList<Unit> allUnits = this.units;
        while (allUnits != null) {
            ((Unit)allUnits.head).sortRk = 0;
            allUnits = allUnits.tail;
        }
        allUnits = this.units;
        while (allUnits != null) {
            Unit unit = (Unit)allUnits.head;
            if (unit.isStandard() || inModule && unit.isModule()) {
                this.detectRecursivityRecFrom(unit, null, inModule);
            }
            allUnits = allUnits.tail;
        }
    }

    private boolean detectRecursivityRecFrom(Unit unit, TapList<Unit> visiting, boolean inModule) {
        boolean result = false;
        if (unit.isStandard() || inModule && unit.isModule()) {
            switch (unit.sortRk) {
                case 2: {
                    break;
                }
                case 1: {
                    TapList<Unit> inVisiting = visiting;
                    String recurChain = unit.name();
                    TapList<Unit> recurChainUnit = new TapList<Unit>(unit, null);
                    boolean recurChainContainsModule = false;
                    assert (inVisiting != null);
                    while (inVisiting.head != unit) {
                        if (((Unit)inVisiting.head).isModule()) {
                            recurChainContainsModule = true;
                        }
                        recurChain = ((Unit)inVisiting.head).name() + "-->" + recurChain;
                        recurChainUnit = new TapList<Unit>((Unit)inVisiting.head, recurChainUnit);
                        inVisiting = inVisiting.tail;
                    }
                    TapEnv.fileWarning(15, null, "(TC42) Recursivity: " + unit.name() + "-->" + recurChain);
                    this.recursivityUnits = TapList.prependNoDups(recurChainUnit, this.recursivityUnits);
                    if (!inModule || !recurChainContainsModule) break;
                    result = true;
                    break;
                }
                case 0: {
                    unit.sortRk = 1;
                    visiting = new TapList<Unit>(unit, visiting);
                    TapList<CallArrow> arrows = unit.callees();
                    while (arrows != null) {
                        CallArrow arrow = (CallArrow)arrows.head;
                        if ((arrow.isCall() || inModule) && this.detectRecursivityRecFrom(arrow.destination, visiting, inModule)) {
                            result = true;
                        }
                        arrows = arrows.tail;
                    }
                    if (inModule && unit.isModule()) {
                        TapList<SymbolDecl> functionDecls = unit.publicSymbolTable().getAllTopFunctionDecls();
                        functionDecls = TapList.append(unit.privateSymbolTable().getAllTopFunctionDecls(), functionDecls);
                        while (functionDecls != null) {
                            Unit declUnit = ((FunctionDecl)functionDecls.head).unit();
                            if (this.detectRecursivityRecFrom(declUnit, visiting, inModule)) {
                                result = true;
                            }
                            functionDecls = functionDecls.tail;
                        }
                    }
                    unit.sortRk = 2;
                    break;
                }
            }
        }
        return result;
    }

    public TapList<Unit> orderedFiles() {
        Unit unit;
        TapList<FileUnit> fileUnits = null;
        TapList<Unit> allUnits = this.units;
        while (allUnits != null) {
            unit = (Unit)allUnits.head;
            if (unit.isTranslationUnit()) {
                fileUnits = new TapList<FileUnit>(new FileUnit(unit), fileUnits);
            }
            allUnits = allUnits.tail;
        }
        allUnits = this.units;
        while (allUnits != null) {
            unit = (Unit)allUnits.head;
            if (!unit.isTranslationUnit() && (unit.isStandard() || unit.isPackage())) {
                Unit topUnit = unit.upperLevelUnit();
                while (!topUnit.isTranslationUnit()) {
                    topUnit = topUnit.upperLevelUnit();
                }
                FileUnit fileUnit = this.getFileUnit(topUnit, fileUnits);
                TapList<Unit> nextUnits = this.collectNextUnits(unit, true, unit.isFortran() ? 0 : 1, 1, 0);
                while (nextUnits != null) {
                    Unit nextUnit = (Unit)nextUnits.head;
                    if (!nextUnit.isTranslationUnit() && (nextUnit.isStandard() || nextUnit.isPackage())) {
                        Unit nextTopUnit = nextUnit.upperLevelUnit();
                        while (!nextTopUnit.isTranslationUnit()) {
                            nextTopUnit = nextTopUnit.upperLevelUnit();
                        }
                        FileUnit nextFileUnit = this.getFileUnit(nextTopUnit, fileUnits);
                        if (nextFileUnit != null && nextFileUnit != fileUnit && !TapList.contains(fileUnit.usedFiles, nextFileUnit)) {
                            fileUnit.usedFiles = new TapList<FileUnit>(nextFileUnit, fileUnit.usedFiles);
                        }
                    }
                    nextUnits = nextUnits.tail;
                }
            }
            allUnits = allUnits.tail;
        }
        TapList<FileUnit> inFileUnits = fileUnits;
        while (inFileUnits != null) {
            ((FileUnit)inFileUnits.head).rank = 0;
            inFileUnits = inFileUnits.tail;
        }
        TapList<Object> toVisited = new TapList<Object>(null, null);
        TapList<FileUnit> inFileUnits2 = fileUnits;
        while (inFileUnits2 != null) {
            this.sortFileUnitsRec((FileUnit)inFileUnits2.head, toVisited);
            inFileUnits2 = inFileUnits2.tail;
        }
        return TapList.nreverse(toVisited.tail);
    }

    private FileUnit getFileUnit(Unit unit, TapList<FileUnit> fileUnits) {
        FileUnit found = null;
        while (found == null && fileUnits != null) {
            if (((FileUnit)fileUnits.head).unit == unit) {
                found = (FileUnit)fileUnits.head;
            }
            fileUnits = fileUnits.tail;
        }
        return found;
    }

    private void sortFileUnitsRec(FileUnit fileUnit, TapList<Unit> toVisited) {
        switch (fileUnit.rank) {
            case 2: {
                break;
            }
            case 1: {
                TapEnv.fileWarning(15, null, "Circular dependence in generated file");
                break;
            }
            case 0: {
                fileUnit.rank = 1;
                TapList nextFiles = fileUnit.usedFiles;
                while (nextFiles != null) {
                    this.sortFileUnitsRec((FileUnit)nextFiles.head, toVisited);
                    nextFiles = nextFiles.tail;
                }
                fileUnit.rank = 2;
                toVisited.tail = new TapList<Unit>(fileUnit.unit, toVisited.tail);
                break;
            }
        }
    }

    public void sortUnits(boolean keepAllUnits, int callsDir, int importsDir, int containsDir) {
        int i;
        Unit unit;
        TapList<Unit> toAllUnits;
        TapList<Unit> allUnits = toAllUnits = new TapList<Unit>(null, this.units);
        while (allUnits.tail != null) {
            unit = (Unit)allUnits.tail.head;
            if (!(keepAllUnits || unit.isPackage() || unit.isVarFunction() && unit.callers() != null || unit.functionTypeSpec() != null && unit.functionTypeSpec().argumentsTypes != null)) {
                unit.setRank(-1);
                allUnits.tail = allUnits.tail.tail;
                --this.nbUnits;
                continue;
            }
            unit.setRank(0);
            allUnits = allUnits.tail;
        }
        this.units = toAllUnits.tail;
        allUnits = this.sortDecreasingPositions(this.units);
        this.debuglevel = 0;
        TapList<Object> visited = new TapList<Object>(null, null);
        while (allUnits != null) {
            unit = (Unit)allUnits.head;
            if (unit.rank() != -1) {
                this.sortUnitsRec(unit, true, null, visited, callsDir, importsDir, containsDir);
            }
            allUnits = allUnits.tail;
        }
        visited = visited.tail;
        if (this.nbUnits < 0) {
            this.nbUnits = 0;
        }
        this.sortedUnits = new Unit[this.nbUnits];
        for (i = 0; i < this.nbUnits && visited != null; ++i) {
            this.sortedUnits[i] = (Unit)visited.head;
            this.sortedUnits[i].setRank(i);
            visited = visited.tail;
        }
        this.topUnits = this.sortByIncreasingRank(this.topUnits);
        for (i = 0; i < this.nbUnits; ++i) {
            if (this.sortedUnits[i] == null) continue;
            this.sortedUnits[i].lowerLevelUnits = this.sortByIncreasingRank(this.sortedUnits[i].lowerLevelUnits);
        }
        this.units = this.sortByIncreasingRank(this.units);
    }

    public TapList<Unit> buildSortedUnitsList(int callsDir, int importsDir, int containsDir) {
        TapList<Unit> allUnits = this.units;
        while (allUnits != null) {
            ((Unit)allUnits.head).sortRk = 0;
            allUnits = allUnits.tail;
        }
        TapList<Object> visited = new TapList<Object>(null, null);
        allUnits = this.sortDecreasingPositions(this.units);
        while (allUnits != null) {
            this.sortUnitsRec((Unit)allUnits.head, false, null, visited, callsDir, importsDir, containsDir);
            allUnits = allUnits.tail;
        }
        return visited.tail;
    }

    private void sortUnitsRec(Unit unit, boolean inrk, TapList<Unit> visiting, TapList<Unit> visited, int callsDir, int importsDir, int containsDir) {
        ++this.debuglevel;
        switch (inrk ? unit.rank() : unit.sortRk) {
            case 2: {
                break;
            }
            case 1: {
                break;
            }
            case 0: {
                if (inrk) {
                    unit.setRank(1);
                } else {
                    unit.sortRk = 1;
                }
                TapList<Unit> aroundUnit = new TapList<Unit>(unit, unit.enclosingUnits());
                TapList<Unit> nextUnits = this.collectNextUnits(unit, false, callsDir, importsDir, containsDir);
                while (nextUnits != null) {
                    Unit nextUnit;
                    for (nextUnit = (Unit)nextUnits.head; nextUnit != null && !nextUnit.isTopInFile() && !TapList.contains(aroundUnit, nextUnit.upperLevelUnit()); nextUnit = nextUnit.upperLevelUnit()) {
                    }
                    if (nextUnit != null) {
                        this.sortUnitsRec(nextUnit, inrk, new TapList<Unit>(unit, visiting), visited, callsDir, importsDir, containsDir);
                    }
                    nextUnits = nextUnits.tail;
                }
                if (inrk) {
                    unit.setRank(2);
                } else {
                    unit.sortRk = 2;
                }
                visited.tail = new TapList<Unit>(unit, visited.tail);
                break;
            }
        }
        --this.debuglevel;
    }

    public void decideForwardDeclarations() {
        TapList<SymbolTable> tuSTs = this.translationUnitSymbolTables;
        while (tuSTs != null) {
            SymbolTable tuST = (SymbolTable)tuSTs.head;
            if (TapEnv.isC(tuST.language())) {
                tuST.privateForwardDeclarations = null;
                tuST.nonPrivForwardDeclarations = null;
                TapList<Unit> alreadyDeclared = this.checkUnitsDefUse(this.topBlock, null, null);
                if (this.cRootSymbolTable != null) {
                    alreadyDeclared = this.checkUnitsDefUse(this.cRootSymbolTable.declarationsBlock, alreadyDeclared, null);
                }
                TapList<Block> topBlocks = tuST.unit.allBlocks;
                while (topBlocks != null) {
                    alreadyDeclared = this.checkUnitsDefUse((Block)topBlocks.head, alreadyDeclared, tuST);
                    topBlocks = topBlocks.tail;
                }
            }
            tuSTs = tuSTs.tail;
        }
    }

    private TapList<Unit> checkUnitsDefUse(Block block, TapList<Unit> forwardDeclared, SymbolTable tuSymbolTable) {
        if (block != null) {
            TapList<Instruction> instructions = block.instructions;
            while (instructions != null) {
                Instruction instr = (Instruction)instructions.head;
                Unit instrUnit = instr.isUnitDefinitionStub();
                if (tuSymbolTable != null) {
                    TapList<Unit> usedUnits = instrUnit != null ? this.collectNextUnits(instrUnit, true, 1, 0, 0) : Instruction.usedUnits(instr.tree, null, block.symbolTable);
                    while (usedUnits != null) {
                        Unit usedUnit = (Unit)usedUnits.head;
                        if (!TapList.contains(forwardDeclared, usedUnit)) {
                            if (usedUnit.isPrivate()) {
                                if (!TapList.contains(tuSymbolTable.privateForwardDeclarations, usedUnit)) {
                                    tuSymbolTable.privateForwardDeclarations = new TapList<Unit>(usedUnit, tuSymbolTable.privateForwardDeclarations);
                                }
                            } else if (!TapList.contains(tuSymbolTable.nonPrivForwardDeclarations, usedUnit)) {
                                tuSymbolTable.nonPrivForwardDeclarations = new TapList<Unit>(usedUnit, tuSymbolTable.nonPrivForwardDeclarations);
                            }
                        }
                        usedUnits = usedUnits.tail;
                    }
                }
                TapList<Unit> declaredUnits = instrUnit != null ? new TapList<Unit>(instrUnit, null) : instr.declaresUnits(block.symbolTable);
                while (declaredUnits != null) {
                    if (!TapList.contains(forwardDeclared, declaredUnits.head)) {
                        forwardDeclared = new TapList<Unit>((Unit)declaredUnits.head, forwardDeclared);
                    }
                    declaredUnits = declaredUnits.tail;
                }
                instructions = instructions.tail;
            }
        }
        return forwardDeclared;
    }

    private TapList<Unit> collectNextUnits(Unit unit, boolean notWhenForwardDecl, int callsDir, int importsDir, int containsDir) {
        TapList<Object> toResult = new TapList<Object>(null, null);
        TapList<Unit> forwardDeclared = null;
        if (notWhenForwardDecl) {
            forwardDeclared = this.checkUnitsDefUse(this.topBlock, null, null);
            if (this.cRootSymbolTable != null) {
                forwardDeclared = this.checkUnitsDefUse(this.cRootSymbolTable.declarationsBlock, forwardDeclared, null);
            }
            forwardDeclared = this.checkUnitsDefUse(unit.translationUnitSymbolTable().declarationsBlock, forwardDeclared, null);
        }
        TapList<CallArrow> arrows = unit.callees();
        while (arrows != null) {
            if (((CallArrow)arrows.head).followsDirections(callsDir, importsDir, containsDir, forwardDeclared)) {
                this.insertDecreasingPositions(((CallArrow)arrows.head).destination, toResult);
            }
            arrows = arrows.tail;
        }
        arrows = unit.callers();
        while (arrows != null) {
            if (((CallArrow)arrows.head).followsDirections(-callsDir, -importsDir, -containsDir, forwardDeclared)) {
                this.insertDecreasingPositions(((CallArrow)arrows.head).origin, toResult);
            }
            arrows = arrows.tail;
        }
        return toResult.tail;
    }

    private TapList<Unit> sortDecreasingPositions(TapList<Unit> unitTapList) {
        TapList<Object> toResult = new TapList<Object>(null, null);
        while (unitTapList != null) {
            this.insertDecreasingPositions((Unit)unitTapList.head, toResult);
            unitTapList = unitTapList.tail;
        }
        return toResult.tail;
    }

    private void insertDecreasingPositions(Unit newUnit, TapList<Unit> toListUnits) {
        int newPos = newUnit.getPosition();
        while (toListUnits.tail != null && ((Unit)toListUnits.tail.head).getPosition() > newPos) {
            toListUnits = toListUnits.tail;
        }
        toListUnits.tail = new TapList<Unit>(newUnit, toListUnits.tail);
    }

    private TapList<Unit> sortByIncreasingRank(TapList<Unit> unitTapList) {
        TapList<Object> sortedList = new TapList<Object>(null, null);
        while (unitTapList != null) {
            int rank = ((Unit)unitTapList.head).rank();
            TapList<Object> insortedList = sortedList;
            while (insortedList.tail != null && ((Unit)insortedList.tail.head).rank() < rank) {
                insortedList = insortedList.tail;
            }
            insortedList.placdl(unitTapList.head);
            unitTapList = unitTapList.tail;
        }
        return sortedList.tail;
    }

    public void terminateTypesAndZones() {
        int i;
        int i2;
        int i3;
        TapList<TapList<ZoneInfoAccessElements>> toCMaps;
        Unit unit;
        int i4;
        int nbSortedUserUnits = this.nbUnits;
        if (TapEnv.get().traceTypeCheck != null && ((String)TapEnv.get().traceTypeCheck.head).equals("%all%")) {
            TapEnv.setTraceTypeCheckAnalysis(true);
        }
        if (this.fortranRootSymbolTable != null) {
            this.fortranRootSymbolTable.fixImplicits();
        }
        this.sortUnits(true, 0, -1, 1);
        for (i4 = 0; i4 < nbSortedUserUnits; ++i4) {
            unit = this.sortedUnits[i4];
            TapEnv.setRelatedUnit(unit);
            unit.importAllSymbolTables();
            unit.importInheritedClassesSymbolTables();
        }
        for (i4 = 0; i4 < nbSortedUserUnits; ++i4) {
            unit = this.sortedUnits[i4];
            TapEnv.setRelatedUnit(unit);
            unit.declareAllSymbolDecls();
        }
        TapEnv.printlnOnTrace(15, "@@ Checking types for global declarations");
        this.globalRootSymbolTable.checkTypeSpecValidity();
        this.topBlock.typeCheck(this.globalRootSymbolTable);
        TapEnv.setRelatedLanguage(1);
        this.fortranRootSymbolTable.declarationsBlock.typeCheck(this.fortranRootSymbolTable);
        this.fortranRootSymbolTable.checkTypeSpecValidity();
        TapEnv.setRelatedLanguage(4);
        this.cRootSymbolTable.declarationsBlock.typeCheck(this.cRootSymbolTable);
        this.cRootSymbolTable.checkTypeSpecValidity();
        TapEnv.setRelatedLanguage(6);
        this.cudaRootSymbolTable.declarationsBlock.typeCheck(this.cudaRootSymbolTable);
        this.cudaRootSymbolTable.checkTypeSpecValidity();
        TapEnv.setRelatedLanguage(5);
        this.cPlusPlusRootSymbolTable.declarationsBlock.typeCheck(this.cPlusPlusRootSymbolTable);
        this.cPlusPlusRootSymbolTable.checkTypeSpecValidity();
        TapList<SymbolTable> tuSTs = this.translationUnitSymbolTables;
        while (tuSTs != null) {
            TapEnv.printlnOnTrace(15, "@@ Checking types for file " + ((SymbolTable)tuSTs.head).unit.name());
            TapEnv.setRelatedLanguage(((SymbolTable)tuSTs.head).language());
            ((SymbolTable)tuSTs.head).declarationsBlock.typeCheck((SymbolTable)tuSTs.head);
            ((SymbolTable)tuSTs.head).checkTypeSpecValidity();
            tuSTs = tuSTs.tail;
        }
        TapEnv.setRelatedLanguage(null);
        TapEnv.setTraceTypeCheckAnalysis(false);
        TapEnv.get().tracedTypeCheckUnits = this.getUnits(TapEnv.get().traceTypeCheck);
        for (int i5 = 0; i5 < nbSortedUserUnits; ++i5) {
            unit = this.sortedUnits[i5];
            TapEnv.setRelatedUnit(unit);
            if (!unit.isStandard() && !unit.isIntrinsic() && !unit.isModule() && !unit.isInterface()) continue;
            unit.fixImplicits();
            unit.exportFunctionTypeSpec();
        }
        TapEnv.setRelatedUnit(null);
        for (int i6 = 0; i6 < nbSortedUserUnits; ++i6) {
            Unit enclosingUnit;
            SymbolTable enclosingScope;
            FunctionDecl conflictUnit;
            unit = this.sortedUnits[i6];
            TapEnv.setRelatedUnit(unit);
            if (unit.isStandard() || unit.isIntrinsic() || unit.isModule() || unit.isClass()) {
                unit.typeCheck();
                unit.preprocess();
                Directive.analyzeUnitDirectives(unit, unit.preComments);
                Directive.analyzeUnitDirectives(unit, unit.preCommentsBlock);
                TapList<Block> blocks = unit.allBlocks();
                while (blocks != null) {
                    TapList<Instruction> instructions = ((Block)blocks.head).instructions;
                    while (instructions != null) {
                        Instruction instr = (Instruction)instructions.head;
                        Directive.analyzeInstructionDirectives(instr, instr.preComments);
                        Directive.analyzeInstructionDirectives(instr, instr.preCommentsBlock);
                        instructions = instructions.tail;
                    }
                    blocks = blocks.tail;
                }
                unit.checkMessagePassingCalls(this);
            } else if (unit.isInterface()) {
                unit.typeCheckInterface();
            }
            if (unit.isStandard() && !unit.isTopInFile() && (conflictUnit = (enclosingScope = (enclosingUnit = unit.upperLevelUnit()).externalSymbolTable()).getFunctionNotInterfaceDecl(unit.name())) != null && !conflictUnit.isModule() && conflictUnit.unit() != unit) {
                TapEnv.fileWarning(15, unit.entryBlock().headTree(), "(DD25) Definition of " + unit.name() + " in " + enclosingUnit.name() + " overrides a definition in an enclosing scope.");
            }
            TapList<SymbolTable> unitSymbolTables = unit.symbolTablesBottomUp();
            while (unitSymbolTables != null) {
                ((SymbolTable)unitSymbolTables.head).checkTypeSpecValidity();
                unitSymbolTables = unitSymbolTables.tail;
            }
        }
        TapEnv.setRelatedUnit(null);
        this.sortUnits(true, 1, 1, 1);
        this.detectRecursivity(false);
        this.detectRecursivity(true);
        TapList<Unit> intfUnits = this.interfaceUnits;
        while (intfUnits != null) {
            unit = (Unit)intfUnits.head;
            if (unit.rank() == -1) {
                TapEnv.setRelatedUnit(unit);
                unit.importAllSymbolTables();
                unit.importInheritedClassesSymbolTables();
                unit.typeCheckInterface();
                TapEnv.setRelatedUnit(null);
            }
            intfUnits = intfUnits.tail;
        }
        TapList<TapList<ZoneInfoAccessElements>> inCMaps = toCMaps = new TapList<TapList<ZoneInfoAccessElements>>(null, this.globalCMaps);
        while (inCMaps.tail != null) {
            TapList cMap = (TapList)inCMaps.tail.head;
            boolean danglingExtern = true;
            TapList inCMap = cMap;
            ZoneInfoAccessElements cAccess = null;
            while (inCMap != null) {
                cAccess = (ZoneInfoAccessElements)inCMap.head;
                if (cAccess.symbolDecl instanceof VariableDecl && !cAccess.symbolDecl.isExtern()) {
                    danglingExtern = false;
                }
                inCMap = inCMap.tail;
            }
            MemMap receivingMap = null;
            String cName = null;
            if (danglingExtern && cAccess != null && (cName = cAccess.symbolDecl.symbol).endsWith("_")) {
                receivingMap = this.globalFortranMaps.getMemMap("/" + cName.substring(0, cName.length() - 1) + "/");
            }
            if (receivingMap != null) {
                inCMap = cMap;
                while (inCMap != null) {
                    cAccess = (ZoneInfoAccessElements)inCMap.head;
                    ((VariableDecl)cAccess.symbolDecl).underscoreToFortran = true;
                    MemoryMaps.placeCAccessIntoFortranMap(cAccess, receivingMap, cName, 0, this.globalFortranMaps);
                    inCMap = inCMap.tail;
                }
                inCMaps.tail = inCMaps.tail.tail;
                continue;
            }
            inCMaps = inCMaps.tail;
        }
        this.globalCMaps = toCMaps.tail;
        this.globalZonesNumber4 = new int[]{0, 0, 0, 0};
        TapList<Object> toAllocatedStaticZones = new TapList<Object>(null, null);
        this.initGlobalRootSymbolTable(toAllocatedStaticZones);
        this.initFortranRootSymbolTable(toAllocatedStaticZones);
        this.initCRootSymbolTable(toAllocatedStaticZones);
        this.initOtherRootSymbolTable(this.cudaRootSymbolTable, toAllocatedStaticZones);
        this.initOtherRootSymbolTable(this.cPlusPlusRootSymbolTable, toAllocatedStaticZones);
        this.allGlobalsForExternals = TapList.copy(toAllocatedStaticZones.tail);
        this.globalsForExternalsNumber4 = this.cPlusPlusRootSymbolTable.freeDeclaredZone4();
        tuSTs = this.translationUnitSymbolTables;
        while (tuSTs != null) {
            if (TapEnv.traceTypeCheckAnalysis()) {
                TapEnv.printlnOnTrace("  allocate memory zones for Translation Unit " + ((SymbolTable)tuSTs.head).unit + " starting at z=" + this.globalZonesNumber4[0]);
            }
            this.initOtherRootSymbolTable((SymbolTable)tuSTs.head, toAllocatedStaticZones);
            tuSTs = tuSTs.tail;
        }
        for (i3 = this.nbUnits - 1; i3 >= 0; --i3) {
            unit = this.sortedUnits[i3];
            if (!unit.isInterface()) continue;
            SymbolTable interfaceRootSymbolTable = unit.publicSymbolTable();
            if (interfaceRootSymbolTable.basisSymbolTable() != null && interfaceRootSymbolTable.basisSymbolTable().isImports) {
                interfaceRootSymbolTable = interfaceRootSymbolTable.basisSymbolTable();
            }
            if (interfaceRootSymbolTable == null) continue;
            interfaceRootSymbolTable.setBasisSymbolTable(this.globalRootSymbolTable());
        }
        this.sortUnits(true, 0, 1, 1);
        for (i3 = this.nbUnits - 1; i3 >= 0; --i3) {
            unit = this.sortedUnits[i3];
            TapEnv.setRelatedUnit(unit);
            if (!unit.isModule() && !unit.isClass() || unit.upperLevelUnit != null && !unit.upperLevelUnit.isTranslationUnit()) continue;
            if (TapEnv.traceTypeCheckAnalysis()) {
                TapEnv.printlnOnTrace("  allocate memory zones for Package " + unit.name() + " starting at z=" + this.globalZonesNumber4[0]);
            }
            unit.allocateDeclaredZones(this.globalZonesNumber4, true, toAllocatedStaticZones);
        }
        this.sortUnits(true, 0, -1, 1);
        TapList<ZoneInfo> allStaticZones = TapList.nreverse(toAllocatedStaticZones.tail);
        for (i2 = 0; i2 < this.nbUnits; ++i2) {
            unit = this.sortedUnits[i2];
            TapEnv.setRelatedUnit(unit);
            if (unit.isTranslationUnit() && TapEnv.isC(unit.language())) {
                if (TapEnv.traceTypeCheckAnalysis()) {
                    TapEnv.printlnOnTrace("  collect imported memory zones for C file " + unit.name() + " up to z=" + this.globalZonesNumber4[0]);
                }
                unit.translationUnitSymbolTable().fillImportedZones(this.globalZonesNumber4, allStaticZones);
            }
            if (unit.importsSymbolTable() != null) {
                if (TapEnv.traceTypeCheckAnalysis()) {
                    TapEnv.printlnOnTrace("  collect imported memory zones for unit " + unit.name() + " up to z=" + this.globalZonesNumber4[0]);
                }
                unit.importsSymbolTable().fillImportedZones(this.globalZonesNumber4, allStaticZones);
            }
            if (unit.isProcedure() || unit.isInterface()) {
                if (TapEnv.traceTypeCheckAnalysis()) {
                    TapEnv.printlnOnTrace("  allocate memory zones for " + unit.name() + " starting at z=" + this.globalZonesNumber4[0]);
                }
                unit.allocateDeclaredZones(CallGraph.copyZone4Ranks(this.globalZonesNumber4), false, null);
            }
            if (!unit.isStandard() && !unit.isTranslationUnit()) continue;
            unit.computeAllDominatorlikeInfo();
        }
        this.sortUnits(true, 1, 1, 1);
        for (i2 = this.nbUnits - 1; i2 >= 0; --i2) {
            unit = this.sortedUnits[i2];
            TapEnv.setRelatedUnit(unit);
            if (!unit.isStandard()) continue;
            unit.computeZonesUsedInDeclarations();
        }
        TapList<Unit> iUnits = this.intrinsicUnits();
        while (iUnits != null) {
            Unit iUnit = (Unit)iUnits.head;
            TapEnv.setRelatedUnit(iUnit);
            iUnit.computeZoneInterfaces();
            iUnits = iUnits.tail;
        }
        for (i = this.nbUnits - 1; i >= 0; --i) {
            unit = this.sortedUnits[i];
            TapEnv.setRelatedUnit(unit);
            if (!unit.isStandard() && !unit.isOutside() && !unit.isInterface() && !unit.isModule() && !unit.isVarFunction()) continue;
            unit.computeZoneInterfaces();
        }
        for (i = this.nbUnits - 1; i >= 0; --i) {
            unit = this.sortedUnits[i];
            TapEnv.setRelatedUnit(unit);
            if (!unit.isStandard() && !unit.isOutside() && !unit.isInterface()) continue;
            unit.computeArrowZoneInterfaces();
        }
        boolean runAgainCG = true;
        while (runAgainCG) {
            runAgainCG = false;
            for (int i7 = this.nbUnits - 1; i7 >= 0; --i7) {
                unit = this.sortedUnits[i7];
                if (unit.relevantZones == null) continue;
                Unit unitContainer = unit;
                while (unitContainer.upperLevelUnit != null && unitContainer.upperLevelUnit.isStandard()) {
                    unitContainer = unitContainer.upperLevelUnit;
                }
                TapList<CallArrow> callees = unit.callees;
                while (callees != null) {
                    if (((CallArrow)callees.head).isCall()) {
                        Unit calledUnit = ((CallArrow)callees.head).destination;
                        if (calledUnit.relevantZones != null) {
                            runAgainCG = unit.relevantZones.cumulOrGrows(calledUnit.relevantZones, unitContainer.globalZonesNumber(0));
                        }
                    }
                    callees = callees.tail;
                }
            }
        }
        TapEnv.setRelatedUnit(null);
    }

    public static final int[] copyZone4Ranks(int[] rks) {
        return new int[]{rks[0], rks[1], rks[2], rks[3]};
    }

    private void initGlobalRootSymbolTable(TapList<ZoneInfo> toAllocatedStaticZones) {
        if (this.globalRootSymbolTable != null) {
            this.globalRootSymbolTable.computeFirstDeclaredZone(this.globalZonesNumber4, this.globalRootSymbolTable);
            ZoneAllocator zoneAllocator = new ZoneAllocator(this.globalRootSymbolTable);
            zoneAllocator.setAllocateZonesForPointed(true);
            Tree dummy = ILUtils.build(96, "%NULL_DEST%");
            WrapperTypeSpec dummyType = new WrapperTypeSpec(null);
            ZoneInfoAccessElements access = new ZoneInfoAccessElements(new VariableDecl(dummy, dummyType), null, this.globalRootSymbolTable);
            TapList zones = zoneAllocator.allocateOneZone(dummyType, -1, new TapList<ZoneInfoAccessElements>(access, null), null, -1, false, false, false, false, null);
            ZoneInfo lastZoneInfo = zoneAllocator.lastAllocated();
            lastZoneInfo.description = "null_dest";
            this.zoneNbOfNullDest = lastZoneInfo.zoneNb;
            dummy = ILUtils.build(96, "%UNKNOWN_DEST%");
            dummyType = new WrapperTypeSpec(null);
            access = new ZoneInfoAccessElements(new VariableDecl(dummy, dummyType), null, this.globalRootSymbolTable);
            zones = zoneAllocator.allocateOneZone(dummyType, -1, new TapList<ZoneInfoAccessElements>(access, null), null, -1, false, false, false, false, null);
            lastZoneInfo = zoneAllocator.lastAllocated();
            lastZoneInfo.description = "unknown_dest";
            this.zoneNbOfUnknownDest = lastZoneInfo.zoneNb;
            this.numberOfDummyRootZones = zoneAllocator.nextZone;
            this.allocateGlobalMPChannelsAndIOStreams(this.globalRootSymbolTable, zoneAllocator);
            this.globalRootSymbolTable.allocateZones(zoneAllocator, null);
            this.prepareAllocationPoints(zoneAllocator);
            zoneAllocator.extractAllZoneInfosIntoTargetSymbolTable(toAllocatedStaticZones);
            for (int i = 0; i < 4; ++i) {
                this.globalZonesNumber4[i] = this.globalRootSymbolTable.freeDeclaredZone(i);
            }
        }
    }

    private void initFortranRootSymbolTable(TapList<ZoneInfo> toAllocatedStaticZones) {
        if (this.fortranRootSymbolTable != null) {
            this.fortranRootSymbolTable.computeFirstDeclaredZone(this.globalZonesNumber4, this.fortranRootSymbolTable);
            ZoneAllocator zoneAllocator = new ZoneAllocator(this.fortranRootSymbolTable);
            zoneAllocator.setAllocateZonesForPointed(true);
            this.globalFortranMaps.allocateZones(zoneAllocator, null);
            this.fortranRootSymbolTable.allocateZones(zoneAllocator, null);
            this.prepareAllocationPoints(zoneAllocator);
            zoneAllocator.extractAllZoneInfosIntoTargetSymbolTable(toAllocatedStaticZones);
            for (int i = 0; i < 4; ++i) {
                this.globalZonesNumber4[i] = this.fortranRootSymbolTable.freeDeclaredZone(i);
            }
        }
    }

    private void initCRootSymbolTable(TapList<ZoneInfo> toAllocatedStaticZones) {
        if (this.cRootSymbolTable != null) {
            this.cRootSymbolTable.computeFirstDeclaredZone(this.globalZonesNumber4, this.cRootSymbolTable);
            ZoneAllocator zoneAllocator = new ZoneAllocator(this.cRootSymbolTable);
            zoneAllocator.setAllocateZonesForPointed(true);
            zoneAllocator.ambiguousWithoutIndices = false;
            zoneAllocator.setOffsets(-1, -1, false);
            zoneAllocator.setCommonName(null);
            while (this.globalCMaps != null) {
                TapList sharedAccesses = (TapList)this.globalCMaps.head;
                VariableDecl varDecl = (VariableDecl)((ZoneInfoAccessElements)sharedAccesses.head).symbolDecl;
                if (varDecl.zones() == null) {
                    WrapperTypeSpec varType = varDecl.type();
                    boolean isInt = varType.isIntegerBase();
                    boolean isReal = varType.isRealOrComplexBase();
                    boolean isPtr = varType.isPointer();
                    TapList regionZones = zoneAllocator.allocateZones(varType, -1, varDecl.extraInfo(), sharedAccesses, varType, -1, isInt, isReal, isPtr, null, null, null);
                    while (sharedAccesses != null) {
                        varDecl = (VariableDecl)((ZoneInfoAccessElements)sharedAccesses.head).symbolDecl;
                        varDecl.accumulateZones(regionZones);
                        sharedAccesses = sharedAccesses.tail;
                    }
                }
                this.globalCMaps = this.globalCMaps.tail;
            }
            this.cRootSymbolTable.allocateZones(zoneAllocator, null);
            this.prepareAllocationPoints(zoneAllocator);
            zoneAllocator.extractAllZoneInfosIntoTargetSymbolTable(toAllocatedStaticZones);
            for (int i = 0; i < 4; ++i) {
                this.globalZonesNumber4[i] = this.cRootSymbolTable.freeDeclaredZone(i);
            }
        }
    }

    private void initOtherRootSymbolTable(SymbolTable rootSymbolTable, TapList<ZoneInfo> toAllocatedStaticZones) {
        if (rootSymbolTable != null) {
            rootSymbolTable.computeFirstDeclaredZone(this.globalZonesNumber4, rootSymbolTable);
            ZoneAllocator zoneAllocator = new ZoneAllocator(rootSymbolTable);
            zoneAllocator.setAllocateZonesForPointed(true);
            rootSymbolTable.allocateZones(zoneAllocator, null);
            this.prepareAllocationPoints(zoneAllocator);
            zoneAllocator.extractAllZoneInfosIntoTargetSymbolTable(toAllocatedStaticZones);
            for (int i = 0; i < 4; ++i) {
                this.globalZonesNumber4[i] = rootSymbolTable.freeDeclaredZone(i);
            }
        }
    }

    public TapList<ZoneInfoAccessElements> getCglobalMap(SymbolDecl sharedDecl) {
        TapList found = null;
        TapList<TapList<ZoneInfoAccessElements>> inMaps = this.globalCMaps;
        while (found == null && inMaps != null) {
            if (inMaps.head != null && ((ZoneInfoAccessElements)((TapList)inMaps.head).head).symbolDecl == sharedDecl) {
                found = (TapList)inMaps.head;
            }
            inMaps = inMaps.tail;
        }
        return found;
    }

    public static boolean isMessagePassingChannelName(String name) {
        return name != null && name.startsWith("%message_passing_channel_");
    }

    private void allocateGlobalMPChannelsAndIOStreams(SymbolTable symbolTable, ZoneAllocator zoneAllocator) {
        Tree ioDummy = ILUtils.build(96, "%all_io_streams%");
        WrapperTypeSpec ioType = new WrapperTypeSpec(null);
        ZoneInfoAccessElements access = new ZoneInfoAccessElements(new VariableDecl(ioDummy, ioType), null, symbolTable);
        TapList zones = zoneAllocator.allocateOneZone(ioType, -1, new TapList<ZoneInfoAccessElements>(access, null), null, -1, false, false, false, false, null);
        ZoneInfo lastZoneInfo = zoneAllocator.lastAllocated();
        lastZoneInfo.description = "all_io";
        lastZoneInfo.isChannelOrIO = true;
        this.zoneNbOfAllIOStreams = lastZoneInfo.zoneNb;
        this.prepareChannelCutting();
        TapList<TapPair<MPIcallInfo, TapIntList>> inAllChannels = this.allMessagePassingChannels;
        for (int channelsNb = MPIcallInfo.checkNumberOfChannels(this); inAllChannels != null && channelsNb > 0; --channelsNb) {
            TapPair oneChannels = (TapPair)inAllChannels.head;
            int channelNum = ((TapIntList)oneChannels.second).head;
            ioDummy = ILUtils.build(96, "%message_passing_channel_" + channelNum + "%");
            ioType = symbolTable.getTypeDecl((String)"float").typeSpec;
            access = new ZoneInfoAccessElements(new VariableDecl(ioDummy, ioType), null, symbolTable);
            zones = zoneAllocator.allocateOneZone(ioType, -1, new TapList<ZoneInfoAccessElements>(access, null), null, -1, false, false, false, false, null);
            lastZoneInfo = zoneAllocator.lastAllocated();
            lastZoneInfo.description = "channel_" + channelNum;
            lastZoneInfo.isChannelOrIO = true;
            inAllChannels = inAllChannels.tail;
        }
    }

    public TapIntList zoneRksOfIO() {
        return new TapIntList(this.zoneNbOfAllIOStreams, null);
    }

    public TapIntList zoneRksOfChannelOrIO() {
        TapIntList result = null;
        for (int i = this.globalRootSymbolTable.freeDeclaredZone(0) - 1; i >= 0; --i) {
            ZoneInfo zi = this.globalRootSymbolTable.declaredZoneInfo(i, 0);
            if (!zi.isChannelOrIO) continue;
            result = new TapIntList(i, result);
        }
        return result;
    }

    private void prepareChannelCutting() {
        TapList<TapPair<MPIcallInfo, TapIntList>> inAllChannels = this.allMessagePassingChannels;
        int i = this.zoneNbOfAllIOStreams + 1;
        while (inAllChannels != null) {
            TapPair oneChannels = (TapPair)inAllChannels.head;
            oneChannels.second = new TapIntList(i, null);
            ++i;
            inAllChannels = inAllChannels.tail;
        }
    }

    public void prepareAnalyses(TapList<Unit> rootUnits) {
        TapList<Unit> iUnits = this.intrinsicUnits();
        while (iUnits != null) {
            Unit iUnit = (Unit)iUnits.head;
            TapEnv.setRelatedUnit(iUnit);
            if (iUnit.unitInOutN() == null) {
                InOutAnalyzer.setExternalOrIntrinsicDefaultInOutInfo(iUnit);
            }
            iUnits = iUnits.tail;
        }
        TapEnv.setRelatedUnit(null);
        this.turnForLoopsIntoDoLoops(rootUnits);
        LoopArrayAccessAnalyzer.runAnalysis(this, TapEnv.mustContext() || TapEnv.modeIsNoDiff() ? null : rootUnits);
        PointerAnalyzer.runAnalysis(this, TapEnv.mustContext() || TapEnv.modeIsNoDiff() ? null : rootUnits);
        InOutAnalyzer.runAnalysis(this, TapEnv.mustContext() || TapEnv.modeIsNoDiff() ? null : rootUnits);
        this.turnForLoopsIntoDoLoops(rootUnits);
    }

    private void turnForLoopsIntoDoLoops(TapList<Unit> rootUnits) {
        TapList<Unit> aUnits;
        TapList<Unit> tapList = aUnits = rootUnits == null ? this.units : Unit.allCalleesMulti(rootUnits);
        while (aUnits != null) {
            TapList<Block> blocks = ((Unit)aUnits.head).allBlocks;
            while (blocks != null) {
                TapList<Instruction> instructions = ((Block)blocks.head).instructions;
                while (instructions != null) {
                    Tree instrTree = ((Instruction)instructions.head).tree;
                    if (instrTree != null && instrTree.opCode() == 121 && instrTree.down(3) != null && instrTree.down(3).opCode() == 79 && ILUtils.mayBeTransformed2Do(instrTree.down(3))) {
                        instrTree.setChild(ILUtils.transformFor2Do(instrTree.down(3)), 3);
                    }
                    instructions = instructions.tail;
                }
                blocks = blocks.tail;
            }
            aUnits = aUnits.tail;
        }
    }

    public Unit getFileUnit(String fileName) {
        TapList<Unit> inUnits = this.units;
        Unit found = null;
        while (found == null && inUnits != null) {
            if (fileName.equals(((Unit)inUnits.head).name())) {
                found = (Unit)inUnits.head;
            }
            inUnits = inUnits.tail;
        }
        return found;
    }

    public Unit getUnit(String funcName) {
        return this.getUnit(TapList.parseIdentifier(funcName));
    }

    public Unit getUnit(TapList<String> funcPath) {
        Unit subUnit;
        FunctionDecl subUnitDecl;
        String subName;
        String foundPathString = "";
        SymbolTable curST = null;
        String funcPathString = subName = (String)funcPath.head;
        Unit deepestFoundUnit = null;
        funcPath = funcPath.tail;
        if ((TapEnv.inputLanguage() == 100 || TapEnv.inputLanguage() == 4) && (subUnitDecl = this.cRootSymbolTable.getFunctionNotExternalNorInterfaceDecl(subName)) != null) {
            subUnit = subUnitDecl.unit();
            if (funcPath == null) {
                deepestFoundUnit = subUnit;
            }
            curST = subUnit.privateSymbolTable();
            foundPathString = "[C]";
        }
        if (curST == null && (TapEnv.inputLanguage() == 100 || TapEnv.inputLanguage() == 5)) {
            if (funcPath != null) {
                curST = this.cPlusPlusRootSymbolTable.getNamedScope(subName);
            }
            if (curST == null && (subUnitDecl = this.cPlusPlusRootSymbolTable.getFunctionNotExternalNorInterfaceDecl(subName)) != null) {
                subUnit = subUnitDecl.unit();
                if (funcPath == null) {
                    deepestFoundUnit = subUnit;
                }
                SymbolTable symbolTable = curST = subUnit == null ? null : subUnit.privateSymbolTable();
            }
            if (curST != null) {
                foundPathString = "[C++]";
            }
        }
        if (curST == null && (TapEnv.inputLanguage() == 100 || TapEnv.isFortran(TapEnv.inputLanguage()))) {
            if (funcPath != null && (subUnitDecl = this.fortranRootSymbolTable.getModuleDecl(subName.toLowerCase())) != null) {
                subUnit = subUnitDecl.unit();
                SymbolTable symbolTable = curST = subUnit == null ? null : subUnit.privateSymbolTable();
            }
            if (curST == null && (subUnitDecl = this.fortranRootSymbolTable.getFunctionNotExternalNorInterfaceDecl(subName.toLowerCase())) != null) {
                subUnit = subUnitDecl.unit();
                if (funcPath == null) {
                    deepestFoundUnit = subUnit;
                }
                SymbolTable symbolTable = curST = subUnit == null ? null : subUnit.privateSymbolTable();
            }
            if (curST != null) {
                foundPathString = "[Fortran]";
            }
        }
        TapList<SymbolTable> tuSTs = this.translationUnitSymbolTables;
        while (curST == null && tuSTs != null) {
            Unit subUnit2;
            FunctionDecl subUnitDecl2;
            if (funcPath != null) {
                curST = ((SymbolTable)tuSTs.head).getNamedScope(subName);
            }
            if (curST == null && funcPath != null && (subUnitDecl2 = ((SymbolTable)tuSTs.head).getModuleDecl(subName.toLowerCase())) != null) {
                subUnit2 = subUnitDecl2.unit();
                SymbolTable symbolTable = curST = subUnit2 == null ? null : subUnit2.privateSymbolTable();
            }
            if (curST == null && (subUnitDecl2 = ((SymbolTable)tuSTs.head).getFunctionNotExternalNorInterfaceDecl(((SymbolTable)tuSTs.head).isCaseDependent() ? subName : subName.toLowerCase())) != null) {
                subUnit2 = subUnitDecl2.unit();
                if (funcPath == null) {
                    deepestFoundUnit = subUnit2;
                }
                SymbolTable symbolTable = curST = subUnit2 == null ? null : subUnit2.privateSymbolTable();
            }
            if (curST != null) {
                foundPathString = "[file " + ((SymbolTable)tuSTs.head).containerFileName + TapEnv.outputExtension(((SymbolTable)tuSTs.head).language()) + "]";
            }
            tuSTs = tuSTs.tail;
        }
        while (curST != null && funcPath != null) {
            Unit subUnit3;
            FunctionDecl subUnitDecl3;
            SymbolTable searchedST = curST;
            curST = null;
            subName = (String)funcPath.head;
            funcPathString = funcPathString + "." + subName;
            funcPath = funcPath.tail;
            if (funcPath != null) {
                curST = searchedST.getNamedScope(subName);
            }
            if (curST == null && funcPath != null && (subUnitDecl3 = searchedST.getModuleDecl(subName.toLowerCase())) != null) {
                subUnit3 = subUnitDecl3.unit();
                SymbolTable symbolTable = curST = subUnit3 == null ? null : subUnit3.privateSymbolTable();
            }
            if (curST == null && (subUnitDecl3 = searchedST.getFunctionNotExternalNorInterfaceDecl(searchedST.isCaseDependent() ? subName : subName.toLowerCase())) != null) {
                subUnit3 = subUnitDecl3.unit();
                if (funcPath == null) {
                    deepestFoundUnit = subUnit3;
                }
                SymbolTable symbolTable = curST = subUnit3 == null ? null : subUnit3.privateSymbolTable();
            }
            if (curST == null) continue;
            foundPathString = foundPathString + "." + subName;
        }
        if (deepestFoundUnit == null || funcPath != null) {
            if (funcPath != null) {
                subName = (String)funcPath.head;
                funcPath = funcPath.tail;
                funcPathString = funcPathString + "." + subName;
            }
            if (subName != null && TapEnv.isFortran(TapEnv.inputLanguage())) {
                subName = subName.toLowerCase();
            }
            Unit unit = deepestFoundUnit = subName == null ? null : this.getAnyUnit(subName);
            if (deepestFoundUnit != null) {
                String fallBackName = deepestFoundUnit.name();
                if (!deepestFoundUnit.isTopInFile() && deepestFoundUnit.upperLevelUnit().name() != null && !deepestFoundUnit.upperLevelUnit().name().isEmpty()) {
                    fallBackName = deepestFoundUnit.upperLevelUnit().name() + "." + deepestFoundUnit.name();
                }
                TapEnv.commandWarning(-1, "Procedure " + funcPathString + " understood as " + fallBackName);
            }
        }
        return deepestFoundUnit;
    }

    public Unit getUnit(String name, FunctionTypeSpec functionTypeSpec) {
        TapList<Unit> allUnits = this.units;
        boolean found = false;
        Unit unit = null;
        while (!found && allUnits != null) {
            unit = (Unit)allUnits.head;
            found = unit.name().equals(name) && !unit.isInterface() && !unit.isVarFunction() && unit.functionTypeSpec().equalsCompilDep(functionTypeSpec);
            allUnits = allUnits.tail;
        }
        return found ? unit : null;
    }

    public Unit getAnyUnit(String name) {
        TapList<Unit> allUnits = this.units;
        boolean found = false;
        Unit unit = null;
        while (!found && allUnits != null) {
            unit = (Unit)allUnits.head;
            found = unit.name().equals(name) && !unit.isInterface() && !unit.isVarFunction();
            allUnits = allUnits.tail;
        }
        return found ? unit : null;
    }

    public Unit getAnyNonVarUnit(String name, Unit inUnit) {
        TapList<Unit> allUnits = this.units;
        boolean found = false;
        Unit unit = null;
        while (!found && allUnits != null) {
            unit = (Unit)allUnits.head;
            found = unit.name().equals(name) && unit.isTopInFile() && !unit.isInterface() && !unit.isVarFunction() && inUnit.sameLanguage(unit.language());
            allUnits = allUnits.tail;
        }
        return found ? unit : null;
    }

    public Unit getAnyIntrinsicUnit(String name) {
        TapList<Unit> allUnits = this.intrinsicUnits;
        boolean found = false;
        Unit unit = null;
        while (!found && allUnits != null) {
            unit = (Unit)allUnits.head;
            found = unit.name().equals(name);
            allUnits = allUnits.tail;
        }
        return found ? unit : null;
    }

    private void prepareAllocationPoints(ZoneAllocator zoneAllocator) {
        zoneAllocator.setPossiblyMultiple(true);
        zoneAllocator.setNeedsAccessTree(true);
        while (this.allocationPoints != null) {
            TapPair allocationPoint = (TapPair)this.allocationPoints.head;
            Tree allocationTree = (Tree)((TapPair)allocationPoint.first).first;
            Tree allocatedRoot = (Tree)((TapPair)allocationPoint.first).second;
            WrapperTypeSpec allocatedType = (WrapperTypeSpec)((TapPair)allocationPoint.second).first;
            SymbolTable allocationSymbolTable = (SymbolTable)((TapPair)allocationPoint.second).second;
            Tree allocatedTree = ILUtils.build(5, ILUtils.build(151, ILUtils.copy(allocatedRoot), ILUtils.build(138)), ILUtils.build(180, allocationSymbolTable.unit.shortName()));
            TapList<Object> zonesPlaceHolder = new TapList<Object>(null, null);
            allocatedTree.setAnnotation("allocatedZones", zonesPlaceHolder);
            if (TypeSpec.isA(allocatedType, 6)) {
                allocatedType = ((PointerTypeSpec)allocatedType.wrappedType).destinationType;
            }
            VariableDecl allocVarDecl = new VariableDecl(allocatedRoot, allocatedType);
            ZoneInfoAccessElements access = new ZoneInfoAccessElements(allocVarDecl, allocatedTree, allocationSymbolTable);
            TapList zones = zoneAllocator.allocateZones(allocatedType, -1, null, new TapList<ZoneInfoAccessElements>(access, null), allocatedType, -1, false, false, false, null, allocationSymbolTable, null);
            allocVarDecl.setZones(zones);
            if (zones == null) {
                TapEnv.fileError(null, "(TCxx) Could not allocate memory for " + allocatedTree + " in " + allocationSymbolTable.unit.name());
            } else {
                zonesPlaceHolder.head = zones.head;
                zonesPlaceHolder.tail = zones.tail;
                allocationTree.setAnnotation("allocatedZones", zones);
            }
            this.allocationPoints = this.allocationPoints.tail;
        }
        zoneAllocator.setPossiblyMultiple(false);
        zoneAllocator.setNeedsAccessTree(false);
    }

    protected void addAllocationPoint(Tree allocateTree, Tree recipientTree, TypeSpec allocatedType, SymbolTable symbolTable) {
        this.allocationPoints = new TapList<TapPair<TapPair<Tree, Tree>, TapPair<TypeSpec, SymbolTable>>>(new TapPair<TapPair<Tree, Tree>, TapPair<TypeSpec, SymbolTable>>(new TapPair<Tree, Tree>(allocateTree, recipientTree), new TapPair<TypeSpec, SymbolTable>(allocatedType, symbolTable)), this.allocationPoints);
    }

    protected void replaceInAllocationPoints(Tree oldAllocate, Tree newAllocate) {
        TapPair found = null;
        TapList<TapPair<TapPair<Tree, Tree>, TapPair<TypeSpec, SymbolTable>>> inAllocationPoints = this.allocationPoints;
        while (found == null && inAllocationPoints != null) {
            if (((TapPair)((TapPair)inAllocationPoints.head).first).first == oldAllocate) {
                found = (TapPair)((TapPair)inAllocationPoints.head).first;
            }
            inAllocationPoints = inAllocationPoints.tail;
        }
        if (found != null) {
            found.first = newAllocate;
        } else {
            TapEnv.toolError("Lost allocated zones for " + newAllocate);
        }
    }

    public TapList<Unit> getUnits(TapList<String> unitNames) {
        TapList<Object> hdResult;
        if (unitNames == null) {
            return null;
        }
        if (((String)unitNames.head).equals("%all%")) {
            return new TapList<Object>(null, null);
        }
        TapList<Object> tlResult = hdResult = new TapList<Object>(null, null);
        while (unitNames != null) {
            block11: {
                try {
                    int unitRk = Integer.parseInt((String)unitNames.head);
                    Unit unitToTrace = null;
                    for (int i = this.sortedUnits.length - 1; i >= 0 && unitToTrace == null; --i) {
                        if (this.sortedUnits[i].rank() != unitRk) continue;
                        unitToTrace = this.sortedUnits[i];
                    }
                    if (unitToTrace != null && !TapList.contains(hdResult.tail, unitToTrace)) {
                        tlResult = tlResult.placdl(unitToTrace);
                    }
                    if (unitToTrace == null) {
                        TapEnv.commandWarning(10, "Can't find unit of rank " + unitRk);
                    }
                }
                catch (NumberFormatException e) {
                    Unit unitToTraceFileName;
                    Unit unitToTraceLowerCase;
                    Unit unitToTraceSameCase = this.getUnit((String)unitNames.head);
                    if (unitToTraceSameCase != null && !TapList.contains(hdResult.tail, unitToTraceSameCase)) {
                        tlResult = tlResult.placdl(unitToTraceSameCase);
                    }
                    if ((unitToTraceLowerCase = this.getUnit(((String)unitNames.head).toLowerCase())) != null && unitToTraceLowerCase.isFortran() && unitToTraceLowerCase != unitToTraceSameCase && !TapList.contains(hdResult.tail, unitToTraceLowerCase)) {
                        tlResult = tlResult.placdl(unitToTraceLowerCase);
                    }
                    if ((unitToTraceFileName = this.getFileUnit((String)unitNames.head)) != null && !TapList.contains(hdResult.tail, unitToTraceFileName)) {
                        tlResult = tlResult.placdl(unitToTraceFileName);
                    }
                    if (unitToTraceSameCase != null || unitToTraceLowerCase != null && unitToTraceLowerCase.isFortran() || unitToTraceFileName != null) break block11;
                    TapEnv.commandWarning(10, "Can't find any unit named " + (String)unitNames.head);
                }
            }
            unitNames = unitNames.tail;
        }
        return hdResult.tail;
    }

    public void addBindFortranCFunction(String unitFortranName, String unitCName, FunctionDecl funcDecl) {
        this.bindFortranCFunctions = new TapList<TapTriplet<String, String, FunctionDecl>>(new TapTriplet<String, String, FunctionDecl>(unitFortranName, unitCName, funcDecl), this.bindFortranCFunctions);
    }

    public void addBindFortranCDiffUnit(Unit diffUnit) {
        this.bindFortranCDiffUnits = new TapList<Unit>(diffUnit, this.bindFortranCDiffUnits);
    }

    public TapList<TapPair<TypeDecl, TypeDecl>> bindFortranCType() {
        return this.bindFortranCType;
    }

    public void setBindFortranCType(TapList<TapPair<TypeDecl, TypeDecl>> origBindCType) {
        this.bindFortranCType = origBindCType;
    }

    public void addBindFortranCType(TypeDecl fortranTypeDecl, TypeDecl cTypeDecl) {
        this.bindFortranCType = new TapList<TapPair<TypeDecl, TypeDecl>>(new TapPair<TypeDecl, TypeDecl>(fortranTypeDecl, cTypeDecl), this.bindFortranCType);
    }

    public boolean naturalBindFortranCType(WrapperTypeSpec fType, WrapperTypeSpec cType) {
        return fType != null && cType != null && TypeSpec.isA(fType.baseTypeSpec(true), 7) && (fType.equalsLiterally(cType) || TypeSpec.isA(cType, 6) && fType.equalsLiterally(((PointerTypeSpec)cType.wrappedType).destinationType));
    }

    public boolean checkBindFortranCType(WrapperTypeSpec fortranTypeSpec, WrapperTypeSpec cTypeSpec) {
        boolean result = true;
        boolean found = false;
        TapList<TapPair<TypeDecl, TypeDecl>> bindTypes = this.bindFortranCType;
        while (bindTypes != null && !found) {
            if (((TypeDecl)((TapPair)bindTypes.head).first).typeSpec.wrappedType.equalsLiterally(fortranTypeSpec)) {
                if (((TapPair)bindTypes.head).second == null) {
                    String name = cTypeSpec.genTypeDeclName();
                    ((TapPair)bindTypes.head).second = new TypeDecl(name, cTypeSpec);
                } else if (((TypeDecl)((TapPair)bindTypes.head).second).typeSpec.wrappedType.equalsLiterally(cTypeSpec)) {
                    result = true;
                    found = true;
                } else if (TypeSpec.isA(cTypeSpec, 6) && ((TypeDecl)((TapPair)bindTypes.head).second).typeSpec.wrappedType.equalsLiterally(((PointerTypeSpec)cTypeSpec.wrappedType).destinationType)) {
                    result = true;
                    found = true;
                } else {
                    result = false;
                    found = true;
                }
            }
            bindTypes = bindTypes.tail;
        }
        return result;
    }

    public TypeDecl getOtherBindType(WrapperTypeSpec typeSpec) {
        TypeDecl result = null;
        TapList<TapPair<TypeDecl, TypeDecl>> bindTypes = this.bindFortranCType;
        while (bindTypes != null && result == null) {
            if (((TypeDecl)((TapPair)bindTypes.head).first).typeSpec.wrappedType.equalsLiterally(typeSpec)) {
                result = (TypeDecl)((TapPair)bindTypes.head).second;
            } else if (((TypeDecl)((TapPair)bindTypes.head).second).typeSpec.wrappedType.equalsLiterally(typeSpec)) {
                result = (TypeDecl)((TapPair)bindTypes.head).first;
            }
            bindTypes = bindTypes.tail;
        }
        return result;
    }

    private void deleteBindFortranCFunction(Unit unit) {
        TapList<TapTriplet<String, String, FunctionDecl>> toResult;
        TapList<TapTriplet<String, String, FunctionDecl>> inResult = toResult = new TapList<TapTriplet<String, String, FunctionDecl>>(null, this.bindFortranCFunctions);
        while (inResult.tail != null) {
            TapTriplet bindTriplet = (TapTriplet)inResult.tail.head;
            if (bindTriplet.third != null && ((FunctionDecl)bindTriplet.third).unit() == unit) {
                bindTriplet.third = null;
                inResult.tail = inResult.tail.tail;
                continue;
            }
            inResult = inResult.tail;
        }
        this.bindFortranCFunctions = toResult.tail;
    }

    public TapTriplet<String, String, FunctionDecl> getOtherLangFunctionDeclFromBindC(String funcName, int calleeLang) {
        TapTriplet<String, String, Object> result = null;
        TapList<TapTriplet<String, String, FunctionDecl>> bindFortranCFuncs = this.bindFortranCFunctions;
        while (result == null && bindFortranCFuncs != null) {
            if (calleeLang != 4 && funcName.equals(((TapTriplet)bindFortranCFuncs.head).second)) {
                result = (TapTriplet<String, String, Object>)bindFortranCFuncs.head;
            } else if (calleeLang == 4 && funcName.equals(((TapTriplet)bindFortranCFuncs.head).first)) {
                result = (TapTriplet)bindFortranCFuncs.head;
            }
            bindFortranCFuncs = bindFortranCFuncs.tail;
        }
        if (result == null) {
            TapList<Unit> bindFortranCUnits = this.bindFortranCDiffUnits;
            while (bindFortranCUnits != null) {
                if (((Unit)bindFortranCUnits.head).name().equals(funcName) || ((Unit)bindFortranCUnits.head).name().equals("#" + funcName + "#")) {
                    result = new TapTriplet<String, String, Object>(funcName, funcName, null);
                }
                bindFortranCUnits = bindFortranCUnits.tail;
            }
        }
        return result;
    }

    public TapPair<String, FunctionDecl> getMixedLanguageFunctionName(String functionName, int callerLanguage, int calleeLanguage) {
        TapTriplet<String, String, FunctionDecl> otherlangFuncDeclName;
        if (TapEnv.traceTypeCheckAnalysis()) {
            TapEnv.printOnTrace("    Mixed-language " + callerLanguage + "->" + calleeLanguage + " " + functionName + " ");
        }
        if ((otherlangFuncDeclName = this.getOtherLangFunctionDeclFromBindC(functionName, calleeLanguage)) != null) {
            String result = (String)otherlangFuncDeclName.second;
            if (TapEnv.traceTypeCheckAnalysis()) {
                TapEnv.printlnOnTrace("    Mixed-language 2003 -> " + result + " " + otherlangFuncDeclName.third);
            }
            return new TapPair<String, FunctionDecl>(result, (FunctionDecl)otherlangFuncDeclName.third);
        }
        String result = this.getOtherLanguageName(functionName, callerLanguage, calleeLanguage);
        if (TapEnv.traceTypeCheckAnalysis()) {
            TapEnv.printlnOnTrace("    Mixed-language -> " + result);
        }
        return new TapPair<String, Object>(result, null);
    }

    public String getOtherLanguageName(String symbolName, int callerLanguage, int calleeLanguage) {
        String result = symbolName;
        MixedLanguageInfos infos = CallGraph.functionNameBinding(callerLanguage, calleeLanguage);
        if (infos != null) {
            String bindingName = infos.getFunctionBinding();
            boolean addSuffix = bindingName.startsWith("add");
            String suffix = infos.getSuffix();
            if (suffix != null) {
                result = addSuffix ? symbolName + suffix : (symbolName.endsWith(suffix) ? symbolName.substring(0, symbolName.length() - suffix.length()) : null);
            } else if ((bindingName = bindingName.toLowerCase()).startsWith("upper")) {
                result = result.toUpperCase();
            } else if (bindingName.startsWith("lower")) {
                result = result.toLowerCase();
            }
        }
        return result;
    }

    public void numberSymbolTables() {
        int rk = 0;
        this.globalRootSymbolTable.setRank(rk);
        ++rk;
        if (this.cRootSymbolTable != null) {
            this.cRootSymbolTable.setRank(rk);
            ++rk;
        }
        if (this.cPlusPlusRootSymbolTable != null) {
            this.cPlusPlusRootSymbolTable.setRank(rk);
            ++rk;
        }
        if (this.fortranRootSymbolTable != null) {
            this.fortranRootSymbolTable.setRank(rk);
            ++rk;
        }
        if (this.cudaRootSymbolTable != null) {
            this.cudaRootSymbolTable.setRank(rk);
            ++rk;
        }
        TapList<Unit> allUnitsList = this.units();
        while (allUnitsList != null) {
            Unit unit = (Unit)allUnitsList.head;
            if (!MPIcallInfo.isMessagePassingFunction(unit.name(), unit.language()) && !unit.inStdCIncludeFile() && (unit.isStandard() || unit.isExternal() || unit.isModule() || unit.isInterface())) {
                TapList<SymbolTable> externals = null;
                for (SymbolTable externalSymbolTable = unit.externalSymbolTable(); externalSymbolTable != null && externalSymbolTable.isImports; externalSymbolTable = externalSymbolTable.basisSymbolTable()) {
                    externals = new TapList<SymbolTable>(externalSymbolTable, externals);
                }
                while (externals != null) {
                    ((SymbolTable)externals.head).setRank(++rk);
                    externals = externals.tail;
                }
                if (unit.publicSymbolTable() != null) {
                    unit.publicSymbolTable().setRank(++rk);
                }
                if (unit.privateSymbolTable() != null) {
                    unit.privateSymbolTable().setRank(++rk);
                    TapList<SymbolTable> seenSymbolTables = new TapList<SymbolTable>(unit.privateSymbolTable(), null);
                    TapList<Block> allBlocks = unit.allBlocks;
                    while (allBlocks != null) {
                        Block block = (Block)allBlocks.head;
                        if (block != null && block.symbolTable != null && !TapList.contains(seenSymbolTables, block.symbolTable)) {
                            block.symbolTable.setRank(++rk);
                            seenSymbolTables = new TapList<SymbolTable>(block.symbolTable, seenSymbolTables);
                        }
                        allBlocks = allBlocks.tail;
                    }
                }
            }
            allUnitsList = allUnitsList.tail;
        }
    }

    public void dumpAllSymbolTables(TapList<Unit> unitsToDump, boolean dumpAll, int indent) throws IOException {
        if (this.globalRootSymbolTable != null) {
            TapEnv.indentPrint(indent, this.globalRootSymbolTable.shortName() + " :");
            TapEnv.dumpSymbolTableIfNew(this.globalRootSymbolTable, indent);
            TapEnv.println();
        }
        TapEnv.indentPrint(indent, "FORTRAN GLOBAL MEMORY MAPS:");
        if (this.globalFortranMaps.maps.tail == null) {
            TapEnv.println(" none");
        } else {
            TapEnv.println();
            for (MemMap oneMap : this.globalFortranMaps.maps.tail) {
                TapEnv.indentPrintln(indent + 2, oneMap.toString());
            }
        }
        TapEnv.println();
        if (this.fortranRootSymbolTable != null) {
            TapEnv.indentPrint(indent, this.fortranRootSymbolTable.shortName() + " :");
            TapEnv.dumpSymbolTableIfNew(this.fortranRootSymbolTable, indent);
            TapEnv.println();
        }
        if (this.cRootSymbolTable != null) {
            TapEnv.indentPrint(indent, this.cRootSymbolTable.shortName() + " :");
            TapEnv.dumpSymbolTableIfNew(this.cRootSymbolTable, indent);
            TapEnv.println();
        }
        if (this.cudaRootSymbolTable != null) {
            TapEnv.indentPrint(indent, this.cudaRootSymbolTable.shortName() + " :");
            TapEnv.dumpSymbolTableIfNew(this.cudaRootSymbolTable, indent);
            TapEnv.println();
        }
        if (this.cPlusPlusRootSymbolTable != null) {
            TapEnv.indentPrint(indent, this.cPlusPlusRootSymbolTable.shortName() + " :");
            TapEnv.dumpSymbolTableIfNew(this.cPlusPlusRootSymbolTable, indent);
            TapEnv.println();
        }
        TapList<SymbolTable> tuSTs = this.translationUnitSymbolTables;
        while (tuSTs != null) {
            TapEnv.indentPrint(indent, ((SymbolTable)tuSTs.head).shortName() + " :");
            TapEnv.dumpSymbolTableIfNew((SymbolTable)tuSTs.head, indent);
            TapEnv.println();
            tuSTs = tuSTs.tail;
        }
        while (unitsToDump != null) {
            Unit unit = (Unit)unitsToDump.head;
            if (!(unit.isTranslationUnit() || dumpAll && (MPIcallInfo.isMessagePassingFunction(unit.name(), unit.language()) || unit.inStdCIncludeFile()))) {
                if (unit.importsSymbolTable() != null) {
                    TapEnv.indentPrint(indent, unit.importsSymbolTable().shortName() + " :");
                    TapEnv.dumpSymbolTableIfNew(unit.importsSymbolTable(), indent + 2);
                    TapEnv.println();
                } else {
                    TapEnv.indentPrintln(indent, "Imports SymbolTable of Unit " + unit + " is NULL");
                }
                if (unit.publicSymbolTable() != null) {
                    TapEnv.indentPrint(indent, unit.publicSymbolTable().shortName() + " :");
                    TapEnv.dumpSymbolTableIfNew(unit.publicSymbolTable(), indent + 2);
                    TapEnv.println();
                } else {
                    TapEnv.indentPrintln(indent, "Public SymbolTable of Unit " + unit + " is NULL");
                }
                if (unit.protectedSymbolTable() != null) {
                    TapEnv.indentPrint(indent, unit.protectedSymbolTable().shortName() + " :");
                    TapEnv.dumpSymbolTableIfNew(unit.protectedSymbolTable(), indent + 2);
                    TapEnv.println();
                }
                if (unit.privateSymbolTable() != null) {
                    TapEnv.indentPrint(indent, unit.privateSymbolTable().shortName() + " :");
                    TapEnv.dumpSymbolTableIfNew(unit.privateSymbolTable(), indent + 2);
                    TapEnv.println();
                }
                TapList<Block> allBlocks = unit.allBlocks;
                while (allBlocks != null) {
                    Block block = (Block)allBlocks.head;
                    if (block != null && block.symbolTable != null && TapEnv.getSeenSymbolTableShortName(block.symbolTable) == null) {
                        if (block.symbolTable.shortName() != null && block.symbolTable.shortName().contains("on top of")) {
                            TapEnv.indentPrint(indent, "Local scope SymbolTable of block #" + block.rank + " of " + unit.name() + ": ");
                        } else {
                            TapEnv.indentPrint(indent, block.symbolTable.shortName() + " :");
                        }
                        TapEnv.dumpSymbolTableIfNew(block.symbolTable, indent + 4);
                        TapEnv.println();
                    }
                    allBlocks = allBlocks.tail;
                }
            }
            unitsToDump = unitsToDump.tail;
        }
    }

    public void dumpAllFlowGraphs(TapList<Unit> unitsToDump, int indent) throws IOException {
        TapEnv.println("CallGraph top Block: " + this.topBlock + " (@" + Integer.toHexString(this.topBlock.hashCode()) + ")");
        this.topBlock.dumpInstructions(indent + 2);
        TapEnv.println();
        Block langBlock = this.fortranRootSymbolTable.declarationsBlock;
        TapEnv.println("Fortran language top Block: " + langBlock + " (@" + Integer.toHexString(langBlock.hashCode()) + ")");
        langBlock.dumpInstructions(indent + 2);
        TapEnv.println();
        TapEnv.println();
        langBlock = this.cRootSymbolTable.declarationsBlock;
        TapEnv.println("C language top Block: " + langBlock + " (@" + Integer.toHexString(langBlock.hashCode()) + ")");
        langBlock.dumpInstructions(indent + 2);
        TapEnv.println();
        langBlock = this.cudaRootSymbolTable.declarationsBlock;
        TapEnv.println("Cuda language top Block: " + langBlock + " (@" + Integer.toHexString(langBlock.hashCode()) + ")");
        langBlock.dumpInstructions(indent + 2);
        TapEnv.println();
        langBlock = this.cPlusPlusRootSymbolTable.declarationsBlock;
        TapEnv.println("C++ language top Block: " + langBlock + " (@" + Integer.toHexString(langBlock.hashCode()) + ")");
        langBlock.dumpInstructions(indent + 2);
        TapEnv.println();
        TapList<SymbolTable> tuSTs = this.translationUnitSymbolTables;
        while (tuSTs != null) {
            SymbolTable tuST = (SymbolTable)tuSTs.head;
            TapEnv.println("Top Block of file (\"Translation Unit\") " + tuST.containerFileName + "(" + TapEnv.outputExtension(tuST.language()) + "): " + tuST.declarationsBlock + " (@" + Integer.toHexString(tuST.declarationsBlock.hashCode()) + ")");
            tuST.declarationsBlock.dumpInstructions(indent + 2);
            TapEnv.println();
            tuSTs = tuSTs.tail;
        }
        while (unitsToDump != null) {
            ((Unit)unitsToDump.head).dump(indent);
            unitsToDump = unitsToDump.tail;
            if (unitsToDump == null) continue;
            TapEnv.println();
        }
    }

    public void dumpAllDataFlows(TapList<Unit> unitsToDump) throws IOException {
        while (unitsToDump != null) {
            if (!((Unit)unitsToDump.head).isModule()) {
                ((Unit)unitsToDump.head).dumpDataFlow(TapEnv.get().dumpPointers, TapEnv.get().dumpInOut, TapEnv.get().dumpDeps, true);
            }
            unitsToDump = unitsToDump.tail;
        }
    }

    public void dump(int indent) throws IOException {
        TapEnv.indentPrintln(indent, "DUMP of " + this.callGraphName + " :");
        TapEnv.indentPrintln(indent, "==========================================");
        TapEnv.resetSeenSymbolTables();
        TapEnv.indentPrint(indent, "Root Symbol Table: ");
        if (this.globalRootSymbolTable != null) {
            TapEnv.dumpSymbolTableIfNew(this.globalRootSymbolTable, indent + 2);
            TapEnv.println();
        }
        TapEnv.dumpSymbolTableIfNew(this.languageRootSymbolTable(TapEnv.inputLanguage()), indent + 2);
        TapEnv.indentPrint(indent, "CallGraph topBlock: ");
        this.topBlock.dump(indent);
        TapList<Unit> allUnits = this.sortedUnits();
        if (allUnits == null) {
            allUnits = this.units();
        }
        while (allUnits != null) {
            Unit unit = (Unit)allUnits.head;
            if (!MPIcallInfo.isMessagePassingFunction(unit.name(), unit.language()) && !unit.inStdCIncludeFile()) {
                TapEnv.println();
                unit.dump(indent + 2);
            }
            allUnits = allUnits.tail;
        }
    }

    private static final class FileUnit {
        private Unit unit;
        private TapList<FileUnit> usedFiles;
        private int rank;

        private FileUnit(Unit unit) {
            this.unit = unit;
        }

        public String toString() {
            String uses = null;
            TapList<FileUnit> isUsed = this.usedFiles;
            while (isUsed != null) {
                uses = uses == null ? "" : uses + ";";
                uses = uses + (isUsed.head == null ? "NULL!!" : ((FileUnit)isUsed.head).unit);
                isUsed = isUsed.tail;
            }
            return "FU[" + this.unit + " USES " + uses + "]";
        }
    }
}

