/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.representation;

import fr.inria.tapenade.representation.PublicInfo;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.representation.ZoneInfo;
import fr.inria.tapenade.utils.BoolVector;
import fr.inria.tapenade.utils.TapIntList;

public final class CallArrow {
    public Unit origin;
    public Unit destination;
    public PublicInfo[] translator;
    public BoolVector coversFurther = null;
    private boolean isCall;
    private boolean isImport;
    private boolean isContain;
    private int times;
    private String srcCallName;

    public boolean isCall() {
        return this.isCall;
    }

    public boolean isImport() {
        return this.isImport;
    }

    public void setImport(boolean anImport) {
        this.isImport = anImport;
    }

    public boolean isContain() {
        return this.isContain;
    }

    public void setContain(boolean contain) {
        this.isContain = contain;
    }

    protected int times() {
        return this.times;
    }

    protected void setTimes(int times) {
        this.times = times;
    }

    protected CallArrow(Unit origin, Unit destination) {
        this.origin = origin;
        this.times = 0;
        this.destination = destination;
        if (origin != null) {
            origin.callees = new TapList<CallArrow>(this, origin.callees);
        }
        if (destination != null) {
            destination.callers = new TapList<CallArrow>(this, destination.callers);
        }
        this.translator = null;
    }

    protected static PublicInfo computeCallTranslatorElem(ZoneInfo zoneInfo, Unit destination, Unit origin) {
        PublicInfo result = null;
        if (zoneInfo != null) {
            switch (zoneInfo.kind()) {
                case 7: {
                    result = PublicInfo.createParameterInfo(zoneInfo.index, zoneInfo, destination, origin);
                    break;
                }
                case 10: {
                    result = PublicInfo.createResultInfo(zoneInfo.index, zoneInfo);
                    break;
                }
                case 12: {
                    if (zoneInfo.from != null) break;
                    result = PublicInfo.createIdentityInfo(zoneInfo);
                    break;
                }
                case 13: {
                    result = PublicInfo.createDeclaredInfo(new TapIntList(zoneInfo.zoneNb, null), zoneInfo.realZoneNb == -1 ? null : new TapIntList(zoneInfo.realZoneNb, null), zoneInfo.intZoneNb == -1 ? null : new TapIntList(zoneInfo.intZoneNb, null), zoneInfo.ptrZoneNb == -1 ? null : new TapIntList(zoneInfo.ptrZoneNb, null));
                    break;
                }
                default: {
                    if (zoneInfo.from != null) break;
                    result = PublicInfo.createIdentityInfo(zoneInfo);
                }
            }
        }
        return result;
    }

    public Unit origin() {
        return this.origin;
    }

    public Unit destination() {
        return this.destination;
    }

    public PublicInfo[] translator() {
        return this.translator;
    }

    public String srcCallName() {
        return this.srcCallName;
    }

    protected void setSrcCallName(String calledName) {
        if (calledName != null && this.destination != null && !calledName.equals(this.destination.name())) {
            if (this.origin().isFortran()) {
                calledName = calledName.toUpperCase();
            }
            this.srcCallName = calledName;
        }
    }

    protected void addKind(int newKind) {
        switch (newKind) {
            case 1: {
                this.isCall = true;
                break;
            }
            case 2: {
                this.isImport = true;
                break;
            }
            case 3: {
                this.isContain = true;
                break;
            }
        }
    }

    protected void delKind(int k) {
        switch (k) {
            case 1: {
                this.isCall = false;
                break;
            }
            case 2: {
                this.isImport = false;
                break;
            }
            case 3: {
                this.isContain = false;
                break;
            }
        }
    }

    protected boolean followsDirections(int callsDir, int importsDir, int containsDir, TapList<Unit> forwardDeclarationUnits) {
        return this.isCall && callsDir == 1 && !TapList.contains(forwardDeclarationUnits, this.destination) && (importsDir != -1 || this.origin.upperLevelUnit() == this.destination.upperLevelUnit()) || this.isImport && importsDir == 1 || this.isContain && containsDir == 1;
    }

    public boolean takesArgumentByValue(int parameterRank) {
        return this.destination.takesArgumentByValue(parameterRank, this.origin.language());
    }

    protected void delete() {
        this.redirectOrigin(null);
        this.redirectDestination(null);
    }

    protected void redirectOrigin(Unit unit) {
        if (this.origin != null) {
            this.origin.callees = TapList.delete(this, this.origin.callees);
        }
        this.origin = unit;
        if (this.origin != null) {
            this.origin.callees = TapList.addUnlessPresentEquals(this.origin.callees, this);
        }
    }

    protected void redirectDestination(Unit unit) {
        if (this.destination != null) {
            this.destination.callers = TapList.delete(this, this.destination.callers);
        }
        this.destination = unit;
        if (this.destination != null) {
            this.destination.callers = new TapList<CallArrow>(this, this.destination.callers);
        }
    }

    protected void computeTranslator() {
        if (this.destination.hasParamElemsInfo()) {
            ZoneInfo zi;
            int nbParams = 0;
            int destShapeLength = this.destination.paramElemsNb();
            this.translator = new PublicInfo[destShapeLength];
            for (int i = 0; i < destShapeLength; ++i) {
                zi = this.destination.paramElemZoneInfo(i);
                this.translator[i] = CallArrow.computeCallTranslatorElem(zi, this.destination, this.origin);
                if (!zi.isParameter() || zi.index <= nbParams) continue;
                nbParams = zi.index;
            }
            if (this.destination.isIntrinsic() || this.destination.isExternal()) {
                int i;
                this.coversFurther = new BoolVector(destShapeLength);
                TapList[] paramCoverage = new TapList[nbParams];
                for (i = nbParams - 1; i >= 0; --i) {
                    paramCoverage[i] = new TapList<Object>(null, null);
                }
                for (i = 0; i < destShapeLength; ++i) {
                    zi = this.destination.paramElemZoneInfo(i);
                    if (!zi.isParameter()) continue;
                    TapList.getSetFieldLocation(paramCoverage[zi.index - 1], zi.accessTree, true);
                }
                for (i = 0; i < destShapeLength; ++i) {
                    zi = this.destination.paramElemZoneInfo(i);
                    if (!zi.isParameter()) continue;
                    TapList<?> toLocation = TapList.getSetFieldLocation(paramCoverage[zi.index - 1], zi.accessTree, false);
                    if (toLocation.tail != null || toLocation.head != null) continue;
                    if (this.translator[i] != null) {
                        this.translator[i].coversFurther = true;
                    }
                    this.coversFurther.set(i, true);
                }
            }
        }
    }

    public String toString() {
        return "CallArrow from " + (this.origin == null ? null : this.origin.name()) + " to " + (this.destination == null ? null : this.destination.name());
    }
}

