/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.representation;

import fr.inria.tapenade.representation.FunctionDecl;
import fr.inria.tapenade.representation.FunctionTypeSpec;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.Instruction;
import fr.inria.tapenade.representation.PointerTypeSpec;
import fr.inria.tapenade.representation.PrimitiveTypeSpec;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.TypeSpec;
import fr.inria.tapenade.representation.VariableDecl;
import fr.inria.tapenade.representation.VoidTypeSpec;
import fr.inria.tapenade.representation.WrapperTypeSpec;
import fr.inria.tapenade.utils.TapIntList;
import fr.inria.tapenade.utils.TapPair;
import fr.inria.tapenade.utils.ToBool;
import fr.inria.tapenade.utils.Tree;

public final class CStuff {
    private static final String[] ioCall = new String[]{"remove", "rename", "tmpfile", "tmpnam", "fclose", "fflush", "fopen", "freopen", "setbuf", "setvbuf", "fprintf", "sprintf", "vfprintf", "vprintf", "vsprintf", "snprintf", "vsnprintf", "fscanf", "scanf", "sscanf", "vfscanf", "vscanf", "vsscanf", "fgetc", "getc", "getchar", "fputc", "putc", "putchar", "fgets", "gets", "fputs", "puts", "ungetc", "fread", "fwrite", "fseek", "ftell", "rewind", "fgetpos", "fsetpos", "clearerr", "feof", "ferror", "perror", "printf"};

    public static void initCSymbolTable(SymbolTable symbolTable) {
        PrimitiveTypeSpec integerTypeSpec = new PrimitiveTypeSpec("integer");
        integerTypeSpec.setPrimitiveTypeSize(TapEnv.get().integerSize);
        VariableDecl ioVarDecl = new VariableDecl(ILUtils.build(96, "__FILE__"), new WrapperTypeSpec(new PointerTypeSpec(new WrapperTypeSpec(new PrimitiveTypeSpec("character")), null)), false);
        ioVarDecl.setZones(new TapList<TapIntList>(new TapIntList(TapEnv.get().origCallGraph().zoneNbOfAllIOStreams, null), null));
        symbolTable.addSystemSymbolDecl(ioVarDecl);
        ioVarDecl = new VariableDecl(ILUtils.build(96, "__LINE__"), new WrapperTypeSpec(integerTypeSpec), false);
        ioVarDecl.setZones(new TapList<TapIntList>(new TapIntList(TapEnv.get().origCallGraph().zoneNbOfAllIOStreams, null), null));
        symbolTable.addSystemSymbolDecl(ioVarDecl);
        ioVarDecl = new VariableDecl(ILUtils.build(96, "__func__"), new WrapperTypeSpec(new PointerTypeSpec(new WrapperTypeSpec(new FunctionTypeSpec(new WrapperTypeSpec(new VoidTypeSpec()))), null)), false);
        ioVarDecl.setZones(new TapList<TapIntList>(new TapIntList(TapEnv.get().origCallGraph().zoneNbOfAllIOStreams, null), null));
        symbolTable.addSystemSymbolDecl(ioVarDecl);
        symbolTable.addSystemSymbolDecl(new VariableDecl(ILUtils.build(96, "__PRETTY_FUNCTION__"), new WrapperTypeSpec(new PointerTypeSpec(new WrapperTypeSpec(new FunctionTypeSpec(new WrapperTypeSpec(new VoidTypeSpec()))), null)), false));
        symbolTable.addSystemSymbolDecl(new VariableDecl(ILUtils.build(96, "__tzname"), new WrapperTypeSpec(null), false));
        symbolTable.addSystemSymbolDecl(new VariableDecl(ILUtils.build(96, "ourIssmMPIStatusIgnore"), new WrapperTypeSpec(null), false));
        symbolTable.addSystemSymbolDecl(new VariableDecl(ILUtils.build(96, "__timezone"), new WrapperTypeSpec(null), false));
        symbolTable.addSystemSymbolDecl(new VariableDecl(ILUtils.build(96, "__daylight"), new WrapperTypeSpec(null), false));
        symbolTable.addSystemSymbolDecl(new VariableDecl(ILUtils.build(96, "__environ"), new WrapperTypeSpec(null), false));
    }

    public static boolean isAnIoCall(Tree callTree) {
        String functionName;
        boolean isIO = false;
        if (callTree != null && callTree.opCode() == 31 && (functionName = ILUtils.getCalledNameString(callTree)) != null) {
            for (int i = ioCall.length - 1; !isIO && i >= 0; --i) {
                isIO = functionName.equals(ioCall[i]);
            }
        }
        return isIO;
    }

    protected static Tree buildIOCall(Tree callTree) {
        return ILUtils.build(109, ILUtils.copy(ILUtils.getCalledName(callTree)), ILUtils.build(71), ILUtils.copy(ILUtils.getArguments(callTree)));
    }

    protected static boolean isAMalloc(Tree mallocTree) {
        boolean isMalloc = false;
        if (mallocTree != null) {
            while (mallocTree.opCode() == 32) {
                mallocTree = mallocTree.down(2);
            }
            if (mallocTree.opCode() == 31) {
                Tree functionName = ILUtils.getCalledName(mallocTree);
                isMalloc = ILUtils.isIdentOf(functionName, new String[]{"malloc", "calloc", "cudaMalloc"}, true);
            }
        }
        return isMalloc;
    }

    protected static Tree buildAllocate(Tree mallocTree, int typeSize, SymbolTable symbolTable, Instruction instruction) {
        Tree type = null;
        Tree result = ILUtils.build(5);
        if (mallocTree.opCode() == 32) {
            type = ILUtils.copy(mallocTree.down(1));
            if (type != null) {
                if (type.opCode() == 154 || type.opCode() == 13) {
                    type = type.down(1);
                } else {
                    WrapperTypeSpec typeSpec = TypeSpec.build(type, symbolTable, instruction, new TapList<Object>(null, null), new TapList<Object>(null, null), new TapList<Object>(null, null), new ToBool(false), null);
                    if (typeSpec != null) {
                        if (TypeSpec.isA(typeSpec, 6)) {
                            typeSpec = ((PointerTypeSpec)typeSpec.wrappedType).destinationType;
                        } else if (TypeSpec.isA(typeSpec, 2)) {
                            typeSpec = typeSpec.wrappedType.elementType();
                        }
                    }
                    type = typeSpec == null ? null : typeSpec.generateTree(symbolTable, null, null, true, null);
                }
            }
            mallocTree = mallocTree.down(2);
        }
        String funcName = ILUtils.getCalledNameString(mallocTree);
        Tree allocArgs = ILUtils.getArguments(mallocTree);
        Tree sizeInBytes = null;
        Tree sizeInObjects = null;
        if (funcName.equals("malloc")) {
            TapPair<Object, Object> foundSizes = new TapPair<Object, Object>(null, null);
            sizeInBytes = allocArgs.down(1);
            sizeInObjects = CStuff.extractElementSize(sizeInBytes, foundSizes, type, typeSize);
            if (foundSizes.first != null) {
                Tree sizeOfObject = (Tree)foundSizes.first;
                if (CStuff.isaModifiedFloatFloat(sizeOfObject.down(1))) {
                    sizeOfObject.setChild(sizeOfObject.cutChild(1).cutChild(2), 1);
                }
                if (type == null) {
                    type = ILUtils.copy(sizeOfObject.down(1));
                }
                if (foundSizes.second != null) {
                    sizeInObjects = sizeInObjects != null ? ILUtils.build(133, sizeInObjects, (Tree)foundSizes.second) : (Tree)foundSizes.second;
                }
            } else if (foundSizes.second == null) {
                sizeInObjects = typeSize != 0 ? ILUtils.build(62, sizeInObjects, ILUtils.build(103, typeSize)) : ILUtils.build(103, 1);
            }
        } else if (funcName.equals("calloc")) {
            Tree sizeOfObject;
            sizeInObjects = allocArgs.down(1);
            int nbArgs = allocArgs.length();
            if (nbArgs == 2) {
                sizeOfObject = allocArgs.down(2);
                if (sizeOfObject.opCode() == 176) {
                    if (CStuff.isaModifiedFloatFloat(sizeOfObject.down(1))) {
                        sizeOfObject.setChild(sizeOfObject.cutChild(1).cutChild(2), 1);
                    }
                    if (type == null) {
                        type = ILUtils.copy(sizeOfObject.down(1));
                    }
                }
            } else {
                TapEnv.fileError(mallocTree, "(TC32) Conflicting numbers of arguments for calloc, expected 2, is here " + allocArgs.length());
                return mallocTree;
            }
            sizeInBytes = ILUtils.build(133, ILUtils.copy(sizeInObjects), ILUtils.copy(sizeOfObject));
            result.setAnnotation("sourcetree", allocArgs);
        }
        if (sizeInObjects != null) {
            sizeInObjects = ILUtils.build(71, ILUtils.copy(sizeInObjects));
        }
        result.setChild(ILUtils.copy(sizeInBytes), 1);
        if (sizeInObjects != null) {
            result.setChild(sizeInObjects, 2);
        }
        if (type != null) {
            result.setChild(type, 3);
        }
        return result;
    }

    public static Tree buildMalloc(Tree allocateTree, Tree assigned) {
        Tree sourceTree;
        for (sourceTree = (Tree)allocateTree.getAnnotation("sourcetree"); sourceTree != null && sourceTree.opCode() == 32; sourceTree = sourceTree.down(2)) {
        }
        if (ILUtils.isCallingString(sourceTree, "cudaMalloc", true) || ILUtils.isCallingString(sourceTree, "cudaFree", true)) {
            Tree lhs = ILUtils.addAddressOf(ILUtils.copy(assigned));
            Tree newCudaMalloc = ILUtils.buildCall(null, ILUtils.build(96, "cudaMalloc"), ILUtils.build(71, lhs, ILUtils.copy(allocateTree.down(1))));
            return newCudaMalloc;
        }
        if (ILUtils.isCallingString(sourceTree, "malloc", true) || ILUtils.isCallingString(sourceTree, "free", true)) {
            Tree newMalloc = ILUtils.buildCall(null, ILUtils.build(96, "malloc"), ILUtils.build(71, ILUtils.copy(allocateTree.down(1))));
            if (!ILUtils.isNullOrNone(allocateTree.down(3))) {
                newMalloc = ILUtils.build(32, ILUtils.build(154, ILUtils.copy(allocateTree.down(3))), newMalloc);
            }
            return newMalloc;
        }
        if (ILUtils.isCallingString(sourceTree, "calloc", true)) {
            Tree newCalloc;
            if (ILUtils.isNullOrNone(allocateTree.down(3))) {
                newCalloc = ILUtils.copy(sourceTree);
            } else {
                Tree baseType = ILUtils.copy(allocateTree.down(3));
                newCalloc = ILUtils.build(32, ILUtils.build(154, ILUtils.copy(baseType)), ILUtils.buildCall(null, ILUtils.build(96, "calloc"), ILUtils.build(71, ILUtils.copy(allocateTree.down(2)), ILUtils.buildCall(null, ILUtils.build(96, "sizeof"), ILUtils.build(71, ILUtils.copy(baseType))))));
            }
            return newCalloc;
        }
        return ILUtils.copy(allocateTree);
    }

    private static Tree extractElementSize(Tree sizeInBytes, TapPair<Tree, Tree> foundSizes, Tree type, int typeSize) {
        if (sizeInBytes.opCode() == 133) {
            Tree x2 = CStuff.extractElementSize(sizeInBytes.down(2), foundSizes, type, typeSize);
            Tree x1 = CStuff.extractElementSize(sizeInBytes.down(1), foundSizes, type, typeSize);
            return x1 == null ? x2 : (x2 == null ? x1 : ILUtils.build(133, x1, x2));
        }
        if (sizeInBytes.opCode() == 62) {
            Tree x1 = CStuff.extractElementSize(sizeInBytes.down(1), foundSizes, type, typeSize);
            if (x1 == null) {
                x1 = ILUtils.build(103, 1);
            }
            return ILUtils.build(62, x1, ILUtils.copy(sizeInBytes.down(2)));
        }
        if (sizeInBytes.opCode() == 176) {
            if (foundSizes.first == null) {
                foundSizes.first = ILUtils.copy(sizeInBytes);
                return null;
            }
            return ILUtils.copy(sizeInBytes);
        }
        if (sizeInBytes.opCode() == 103) {
            if (foundSizes.first == null && foundSizes.second == null && typeSize != 0 && sizeInBytes.intValue() == typeSize) {
                foundSizes.second = ILUtils.copy(sizeInBytes);
                return null;
            }
            return ILUtils.copy(sizeInBytes);
        }
        return ILUtils.copy(sizeInBytes);
    }

    protected static boolean isAFree(Tree callTree) {
        boolean isFree = false;
        if (callTree != null && callTree.opCode() == 31) {
            Tree functionName = ILUtils.getCalledName(callTree);
            isFree = ILUtils.isIdentOf(functionName, new String[]{"free", "cudaFree"}, true);
        }
        return isFree;
    }

    protected static boolean isAPow(SymbolTable symbolTable, Tree callTree) {
        String functionName;
        boolean isPow = false;
        if (callTree != null && callTree.opCode() == 31 && (isPow = "pow".equals(functionName = ILUtils.getCalledNameString(callTree)))) {
            TapList<FunctionDecl> powFuncDecls = symbolTable.getFunctionDecl("pow", null, null, false);
            FunctionDecl powFuncDecl = powFuncDecls == null ? null : (FunctionDecl)powFuncDecls.head;
            isPow = powFuncDecl != null && (powFuncDecl.isExternal() || powFuncDecl.isIntrinsic()) && powFuncDecl.unit().inStdCIncludeFile();
        }
        return isPow;
    }

    protected static Tree buildDeallocate(Tree callFreeTree) {
        Tree container = ILUtils.copy(ILUtils.getArguments(callFreeTree).down(1));
        return ILUtils.build(52, container, null);
    }

    protected static Tree buildPow(Tree callPowTree) {
        Tree son1 = ILUtils.copy(ILUtils.getArguments(callPowTree).down(1));
        Tree son2 = ILUtils.copy(ILUtils.getArguments(callPowTree).down(2));
        return ILUtils.build(155, son1, son2);
    }

    protected static boolean isaModifiedFloatFloat(Tree instrOrExpr) {
        boolean result;
        boolean bl = result = instrOrExpr != null && instrOrExpr.opCode() == 129;
        if (result) {
            Tree instrOrExprDown1 = instrOrExpr.down(1);
            int length = instrOrExprDown1.length();
            result = instrOrExpr.down(2).opCode() == 78 && (length == 0 || length == 1 && ILUtils.isIdent(instrOrExprDown1.down(1), "float", false));
        }
        return result;
    }

    private CStuff() {
    }
}

