/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.representation;

import fr.inria.tapenade.analysis.DataFlowAnalyzer;
import fr.inria.tapenade.ir2tree.ControlStruct;
import fr.inria.tapenade.representation.ArrayTypeSpec;
import fr.inria.tapenade.representation.BasicBlock;
import fr.inria.tapenade.representation.Directive;
import fr.inria.tapenade.representation.EntryBlock;
import fr.inria.tapenade.representation.ExitBlock;
import fr.inria.tapenade.representation.FGArrow;
import fr.inria.tapenade.representation.FortranStuff;
import fr.inria.tapenade.representation.FunctionTypeSpec;
import fr.inria.tapenade.representation.HeaderBlock;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.InitConstructorBlock;
import fr.inria.tapenade.representation.Instruction;
import fr.inria.tapenade.representation.InstructionMask;
import fr.inria.tapenade.representation.LoopBlock;
import fr.inria.tapenade.representation.MPIcallInfo;
import fr.inria.tapenade.representation.NewSymbolHolder;
import fr.inria.tapenade.representation.PointerTypeSpec;
import fr.inria.tapenade.representation.SymbolDecl;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.TypeSpec;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.representation.VariableDecl;
import fr.inria.tapenade.representation.WrapperTypeSpec;
import fr.inria.tapenade.utils.BoolMatrix;
import fr.inria.tapenade.utils.BoolVector;
import fr.inria.tapenade.utils.TapIntList;
import fr.inria.tapenade.utils.TapPair;
import fr.inria.tapenade.utils.ToBool;
import fr.inria.tapenade.utils.TopDownTreeWalk;
import fr.inria.tapenade.utils.Tree;
import java.io.IOException;

public class Block {
    private TapList<FGArrow> flow;
    private TapList<FGArrow> backFlow;
    public TapList<Instruction> instructions;
    public SymbolTable symbolTable;
    public TapList<Instruction> parallelControls;
    protected int visit;
    public int rank;
    public String symbolicRk;
    public boolean isFGCycleTail;
    public boolean isFGCycleHead;
    public BoolVector constantZones;
    public BoolVector unusedZones;
    public boolean analysisIsOutOfDate = true;
    public int testZone = -1;
    public TapList<Block> controllers;
    public TapIntList controllersZone = null;
    public BoolVector successor;
    public BoolVector predecessor;
    public BoolVector postDominator;
    public BoolVector dominator;
    protected Block immediatePostDominator;
    protected Block immediateDominator;
    protected boolean reachable = true;
    public BoolMatrix pointerInfosIn;
    private String origLabel;
    private Block enclosing;
    private Object tmp1;
    private int tmp2;
    private Object tmp3;

    public Block(SymbolTable symbolTable, TapList<Instruction> parallelControls, TapList<Block> allBlocks) {
        this.symbolTable = symbolTable;
        this.parallelControls = parallelControls;
        if (allBlocks != null) {
            allBlocks.tail = new TapList<Block>(this, allBlocks.tail);
        }
    }

    public static TapList<Tree> addTreeDeclTl(TapList<Tree> trees, TapList<Tree> decls) {
        if (trees != null) {
            TapList<Tree> curInstructionListCell = trees;
            boolean ok = false;
            Tree nextTree = (Tree)curInstructionListCell.head;
            if (nextTree == null || !ILUtils.isADeclaration(nextTree)) {
                trees = TapList.append(decls, trees);
            } else {
                while (curInstructionListCell.tail != null && !ok) {
                    nextTree = (Tree)curInstructionListCell.tail.head;
                    if (nextTree == null || !ILUtils.isADeclaration(nextTree) && nextTree.opCode() != 138) {
                        curInstructionListCell.tail = TapList.append(decls, curInstructionListCell.tail);
                        ok = true;
                    }
                    curInstructionListCell = curInstructionListCell.tail;
                }
                if (!ok) {
                    curInstructionListCell.tail = TapList.append(decls, curInstructionListCell.tail);
                }
            }
        } else {
            trees = decls;
        }
        return trees;
    }

    private static boolean isDuplicable(Tree expr, SymbolTable symbolTable) {
        switch (expr.opCode()) {
            case 31: {
                Unit calledFunctionUnit = DataFlowAnalyzer.getCalledUnit(expr, symbolTable);
                if (calledFunctionUnit == null || !calledFunctionUnit.isIntrinsic() && !TapList.containsString(TapEnv.duplicableUnitNames(), calledFunctionUnit.name(), !TapEnv.isFortran(symbolTable.language()))) {
                    return false;
                }
                return Block.isDuplicable(ILUtils.getArguments(expr), symbolTable);
            }
            case 14: {
                return false;
            }
        }
        if (!expr.isAtom()) {
            Tree[] args = expr.children();
            boolean duplicable = true;
            for (int i = args.length - 1; duplicable && i >= 0; --i) {
                duplicable = Block.isDuplicable(args[i], symbolTable);
            }
            return duplicable;
        }
        return true;
    }

    public boolean flowsOutOfScope(SymbolTable symbolTable) {
        TapList<FGArrow> inFlow = this.flow;
        boolean flowsOut = false;
        while (inFlow != null && !flowsOut) {
            Block dest = ((FGArrow)inFlow.head).destination;
            flowsOut = dest != null && !dest.symbolTable.nestedIn(symbolTable);
            inFlow = inFlow.tail;
        }
        return flowsOut;
    }

    private static int duplicableCost(Tree tree, SymbolTable symbolTable) {
        switch (tree.opCode()) {
            case 134: {
                return Block.duplicableCost(tree.down(2), symbolTable);
            }
            case 75: 
            case 124: 
            case 139: {
                return Block.duplicableCost(tree.down(1), symbolTable);
            }
            case 4: 
            case 9: 
            case 151: 
            case 183: {
                return Block.duplicableCost(tree.down(1), symbolTable) + 1;
            }
            case 96: {
                return 1;
            }
            case 62: 
            case 133: {
                return Block.duplicableCost(tree.down(1), symbolTable) + Block.duplicableCost(tree.down(2), symbolTable) + 2;
            }
            case 3: 
            case 42: 
            case 116: 
            case 169: 
            case 182: {
                return Block.duplicableCost(tree.down(1), symbolTable) + Block.duplicableCost(tree.down(2), symbolTable) + 1;
            }
            case 6: 
            case 18: 
            case 22: 
            case 24: 
            case 68: 
            case 92: 
            case 95: 
            case 115: 
            case 122: 
            case 137: 
            case 143: 
            case 207: {
                return Block.duplicableCost(tree.down(1), symbolTable) + Block.duplicableCost(tree.down(2), symbolTable);
            }
            case 20: 
            case 28: 
            case 103: 
            case 111: 
            case 118: 
            case 138: 
            case 160: 
            case 177: 
            case 180: {
                return 0;
            }
        }
        return 1000;
    }

    public TapList<FGArrow> flow() {
        return this.flow;
    }

    protected final void setFlow(TapList<FGArrow> flow) {
        this.flow = flow;
    }

    protected void addFlow(FGArrow arrow) {
        this.flow = new TapList<FGArrow>(arrow, this.flow);
    }

    public boolean flowsTo(Block dest) {
        boolean found = false;
        TapList<FGArrow> inFlow = this.flow;
        while (inFlow != null && !found) {
            found = ((FGArrow)inFlow.head).destination == dest;
            inFlow = inFlow.tail;
        }
        return found;
    }

    public TapList<FGArrow> backFlow() {
        return this.backFlow;
    }

    protected final void setBackFlow(TapList<FGArrow> backFlow) {
        this.backFlow = backFlow;
    }

    protected void addBackFlow(FGArrow arrow) {
        this.backFlow = new TapList<FGArrow>(arrow, this.backFlow);
    }

    public Instruction headInstr() {
        return this.instructions == null ? null : (Instruction)this.instructions.head;
    }

    public Instruction lastInstr() {
        if (this.instructions == null) {
            return null;
        }
        TapList<Instruction> inInstructions = this.instructions;
        while (inInstructions.tail != null) {
            inInstructions = inInstructions.tail;
        }
        return (Instruction)inInstructions.head;
    }

    public String origLabel() {
        return this.origLabel;
    }

    public void setOrigLabel(String label) {
        this.origLabel = label;
    }

    public LoopBlock enclosingLoop() {
        return (LoopBlock)this.enclosing;
    }

    public void setEnclosingLoop(LoopBlock enclosingLoop) {
        this.enclosing = enclosingLoop;
    }

    public Block[] getLabelVariablesEffect() {
        return (Block[])this.tmp1;
    }

    public void setLabelVariablesEffect(Block[] effectAssGoto) {
        this.tmp1 = effectAssGoto;
    }

    public ControlStruct getControlStruct() {
        return (ControlStruct)this.tmp1;
    }

    public void setControlStruct(ControlStruct controlStruct) {
        this.tmp1 = controlStruct;
    }

    public int getFinalGotoRank() {
        return this.tmp2;
    }

    public void setFinalGotoRank(int rank) {
        this.tmp2 = rank;
    }

    public TapList<Block[]> getAssGotoInfoDone() {
        return (TapList)this.tmp3;
    }

    public void setAssGotoInfoDone(TapList<Block[]> assGotoInfoDone) {
        this.tmp3 = assGotoInfoDone;
    }

    public BoolVector getDominatorArrows() {
        return (BoolVector)this.tmp3;
    }

    protected void setDominatorArrows(BoolVector dominators) {
        this.tmp3 = dominators;
    }

    protected final void replaceInFlowGraph(Block oldBlock) {
        this.instructions = oldBlock.instructions;
        this.origLabel = oldBlock.origLabel;
        if (this instanceof HeaderBlock && oldBlock instanceof HeaderBlock) {
            ((HeaderBlock)this).declaresItsIterator = ((HeaderBlock)oldBlock).declaresItsIterator;
        }
        TapList<FGArrow> oldFlow = oldBlock.flow;
        while (oldFlow != null) {
            ((FGArrow)oldFlow.head).origin = this;
            oldFlow = oldFlow.tail;
        }
        this.flow = oldBlock.flow;
        oldBlock.flow = null;
        TapList<FGArrow> oldBackFlow = oldBlock.backFlow;
        while (oldBackFlow != null) {
            ((FGArrow)oldBackFlow.head).destination = this;
            oldBackFlow = oldBackFlow.tail;
        }
        this.backFlow = oldBlock.backFlow;
        oldBlock.backFlow = null;
    }

    public Unit unit() {
        return this.symbolTable == null ? null : this.symbolTable.unit;
    }

    protected void newDeclarationsBlock(Block modelBlock) {
        if (modelBlock.symbolTable != null && modelBlock.symbolTable.declarationsBlock == modelBlock) {
            modelBlock.symbolTable.declarationsBlock = this;
        }
    }

    protected void copyIntoWithoutArrows(Block newBlock, TapList<TapPair<Instruction, Instruction>> alreadyCopiedMasks) {
        TapList<Object> hdCopiedInstrs;
        newBlock.enclosing = this.enclosing;
        newBlock.flow = null;
        newBlock.backFlow = null;
        newBlock.origLabel = this.origLabel;
        newBlock.rank = this.rank;
        TapList<Instruction> instrs = this.instructions;
        TapList<Object> tlCopiedInstrs = hdCopiedInstrs = new TapList<Object>(null, null);
        while (instrs != null) {
            Instruction instr = (Instruction)instrs.head;
            Instruction copiedInstr = instr.copy(alreadyCopiedMasks);
            if (copiedInstr.tree != null && copiedInstr.tree.getAnnotation("hasBeenSplit") == Boolean.TRUE && !ILUtils.isOverloadedAssign(copiedInstr.tree)) {
                copiedInstr.tree.removeAnnotation("sourcetree");
                ILUtils.putBackNamedArguments(copiedInstr.tree);
            }
            copiedInstr.block = newBlock;
            tlCopiedInstrs = tlCopiedInstrs.placdl(copiedInstr);
            instrs = instrs.tail;
        }
        newBlock.instructions = hdCopiedInstrs.tail;
    }

    public void copyInstructions(Block modelBlock, TapList<TapPair<Instruction, Instruction>> copiedIncludes) {
        TapList<Object> hdCopiedInstrs;
        TapList<Object> tlCopiedInstrs = hdCopiedInstrs = new TapList<Object>(null, null);
        TapList<Instruction> origInstrs = modelBlock.instructions;
        while (origInstrs != null) {
            Instruction origInstr = (Instruction)origInstrs.head;
            Instruction copiedInstr = new Instruction(ILUtils.copy(origInstr.tree), null, this);
            copiedInstr.setWhereMask(origInstr.whereMask());
            if (origInstr.fromInclude() != null) {
                copiedInstr.setFromInclude(this.getSetCopiedInclude(origInstr.fromInclude(), copiedIncludes));
            }
            copiedInstr.preComments = origInstr.preComments;
            copiedInstr.preCommentsBlock = origInstr.preCommentsBlock;
            copiedInstr.postComments = origInstr.postComments;
            copiedInstr.postCommentsBlock = origInstr.postCommentsBlock;
            tlCopiedInstrs = tlCopiedInstrs.placdl(copiedInstr);
            origInstrs = origInstrs.tail;
        }
        this.instructions = hdCopiedInstrs.tail;
    }

    private Instruction getSetCopiedInclude(Instruction origInclude, TapList<TapPair<Instruction, Instruction>> copiedIncludes) {
        TapPair<Instruction, Object> found = TapList.assq(origInclude, copiedIncludes.tail);
        if (found == null) {
            found = new TapPair<Instruction, Object>(origInclude, null);
            copiedIncludes.placdl(found);
        }
        if (found.second == null) {
            Instruction copiedInclude = new Instruction(ILUtils.copy(origInclude.tree), null, this);
            found.second = copiedInclude;
            if (origInclude.fromInclude() != null) {
                copiedInclude.setFromInclude(this.getSetCopiedInclude(origInclude.fromInclude(), copiedIncludes));
            }
            copiedInclude.preComments = origInclude.preComments;
            copiedInclude.preCommentsBlock = origInclude.preCommentsBlock;
            copiedInclude.postComments = origInclude.postComments;
            copiedInclude.postCommentsBlock = origInclude.postCommentsBlock;
        }
        return (Instruction)found.second;
    }

    public void addInstrHdIfNotPresent(Instruction instr) {
        boolean found = false;
        if (this.instructions != null) {
            TapList<Instruction> curInstructionListCell = this.instructions;
            while (curInstructionListCell != null && !found) {
                Instruction curInstr = (Instruction)curInstructionListCell.head;
                found = instr.tree.equalsTree(curInstr.tree);
                curInstructionListCell = curInstructionListCell.tail;
            }
        }
        if (!found) {
            this.addInstrHd(instr);
        }
    }

    public void addInstrHd(Tree tree) {
        this.addInstrHd(new Instruction(tree, null, this));
    }

    public void addInstrHd(Instruction instr) {
        this.instructions = new TapList<Instruction>(instr, this.instructions);
    }

    public void addUseDecl(Tree tree) {
        TapList<Instruction> inInstructions = this.instructions;
        int place = 0;
        while (inInstructions != null && (((Instruction)inInstructions.head).tree.opCode() == 100 || ((Instruction)inInstructions.head).tree.opCode() == 197)) {
            ++place;
            inInstructions = inInstructions.tail;
        }
        this.addInstructionAt(tree, place);
    }

    public Instruction firstInstrAfterDecls() {
        TapList<Instruction> inInstructions = this.instructions;
        Instruction found = null;
        while (inInstructions != null && found == null) {
            if (!((Instruction)inInstructions.head).isADeclaration() && !((Instruction)inInstructions.head).isANoOp()) {
                found = (Instruction)inInstructions.head;
            }
            inInstructions = inInstructions.tail;
        }
        return found;
    }

    public Instruction addInstrHdAfterDecls(Tree tree) {
        Instruction newInstr = new Instruction(tree, null, this);
        this.addInstrHdAfterDecls(newInstr);
        return newInstr;
    }

    public void addInstrHdAfterDecls(Instruction instr) {
        TapList<Instruction> toInstructions;
        TapList<Instruction> inInstructions = toInstructions = new TapList<Instruction>(null, this.instructions);
        while (inInstructions.tail != null && (((Instruction)inInstructions.tail.head).isADeclaration() || ((Instruction)inInstructions.tail.head).isANoOp())) {
            inInstructions = inInstructions.tail;
        }
        inInstructions.tail = new TapList<Instruction>(instr, inInstructions.tail);
        instr.block = this;
        this.instructions = toInstructions.tail;
    }

    public void addInstrTl(Tree instr) {
        this.addInstrTl(new Instruction(instr, null, this));
    }

    public void addInstrTl(Instruction instr) {
        if (this.instructions == null) {
            this.instructions = new TapList<Instruction>(instr, null);
        } else {
            TapList<Instruction> inInstructions = this.instructions;
            while (inInstructions.tail != null) {
                inInstructions = inInstructions.tail;
            }
            inInstructions.tail = new TapList<Instruction>(instr, null);
        }
        if (instr.block == null) {
            instr.block = this;
        }
    }

    public boolean alreadyPresent(Instruction instr) {
        boolean found = false;
        if (instr.fromInclude() == null) {
            TapList<Instruction> instrs = this.instructions;
            while (!found && instrs != null) {
                Instruction curInstr = (Instruction)instrs.head;
                found = instr.tree.equalsTree(curInstr.tree);
                instrs = instrs.tail;
            }
        }
        return found;
    }

    public int addInstrDeclTlBeforeUse(Instruction instr, TapList<SymbolDecl> symbolDecls, TapList<Instruction> usageInstructions, SymbolTable declST, boolean strict) {
        int movedUp = 0;
        if (this.instructions != null) {
            TapList<Instruction> hdInstructions;
            if (declST == null) {
                declST = this.symbolTable;
            }
            TapList<Instruction> inInstructions = hdInstructions = new TapList<Instruction>(null, this.instructions);
            boolean placeItHere = false;
            while (!placeItHere && inInstructions.tail != null) {
                Instruction nextInstr = (Instruction)inInstructions.tail.head;
                placeItHere = !nextInstr.isADeclaration() && !nextInstr.isANoOp() && (this.symbolTable == null || !this.unit().isFortran() || !FortranStuff.isStatementFunctionDecl(this.symbolTable, nextInstr.tree)) || TapEnv.isFortran(declST.language()) && nextInstr.isAProcedure() || usageInstructions != null && usageInstructions.tail != null && TapList.contains(usageInstructions, nextInstr) || symbolDecls != null && this.dependsOn(nextInstr.tree, symbolDecls, instr, declST, strict);
                if (placeItHere) continue;
                inInstructions = inInstructions.tail;
            }
            movedUp = TapList.length(inInstructions.tail);
            inInstructions.tail = new TapList<Instruction>(instr, inInstructions.tail);
            this.instructions = hdInstructions.tail;
        } else {
            this.instructions = new TapList<Instruction>(instr, null);
        }
        if (instr.block == null) {
            instr.block = this;
        }
        return movedUp;
    }

    public void addInstrDeclTl(TapList<Instruction> decls) {
        if (this.instructions != null) {
            TapList<Instruction> curInstructionListCell = this.instructions;
            boolean ok = false;
            Instruction nextInstr = (Instruction)curInstructionListCell.head;
            if (!(nextInstr.isADeclaration() || nextInstr.isANoOp() || this.symbolTable != null && this.unit().isFortran() && FortranStuff.isStatementFunctionDecl(this.symbolTable, nextInstr.tree))) {
                this.instructions = TapList.append(decls, this.instructions);
            } else {
                while (curInstructionListCell.tail != null && !ok) {
                    nextInstr = (Instruction)curInstructionListCell.tail.head;
                    if (!(nextInstr.isADeclaration() || nextInstr.isANoOp() || this.symbolTable != null && this.unit().isFortran() && FortranStuff.isStatementFunctionDecl(this.symbolTable, nextInstr.tree))) {
                        curInstructionListCell.tail = TapList.append(decls, curInstructionListCell.tail);
                        ok = true;
                    }
                    curInstructionListCell = curInstructionListCell.tail;
                }
                if (!ok) {
                    curInstructionListCell.tail = TapList.append(decls, curInstructionListCell.tail);
                }
            }
        } else {
            this.instructions = decls;
        }
    }

    public void addInstructionAt(Tree tree, int place) {
        TapList<Instruction> hdInstructions;
        TapList<Instruction> inInstructions = hdInstructions = new TapList<Instruction>(null, this.instructions);
        if (place < 0) {
            int length = TapList.length(this.instructions);
            int n = place = place + length < 0 ? 0 : place + length + 1;
        }
        while (place > 0 && inInstructions.tail != null) {
            inInstructions = inInstructions.tail;
            --place;
        }
        inInstructions.placdl(new Instruction(tree, null, this));
        this.instructions = hdInstructions.tail;
    }

    public int findRankToInsert(Tree fileTree, Tree tree) {
        int i;
        Instruction instr = new Instruction(tree, null, this);
        Tree[] sons = fileTree.children();
        if (sons.length == 0) {
            this.dependsOn(tree, null, instr, this.symbolTable, true);
            return 1;
        }
        int nbIncludes = 0;
        boolean found = false;
        for (i = sons.length - 1; !found && i >= 0; --i) {
            Tree nextTree = sons[i];
            if (nextTree != null && nextTree.opCode() != 101) {
                if (!this.dependsOn(tree, this.symbolDeclDeclared(nextTree, null), instr, this.symbolTable, true) && (tree.opCode() != 89 || nextTree.opCode() != 192) && (ILUtils.isADeclaration(nextTree) || nextTree.opCode() == 138)) continue;
                found = true;
                continue;
            }
            ++nbIncludes;
        }
        if (nbIncludes != 0) {
            ++nbIncludes;
        }
        return found ? i + 3 : nbIncludes;
    }

    public TapList<SymbolDecl> symbolDeclDeclared(Instruction instruction) {
        return this.symbolDeclDeclared(instruction.tree, null);
    }

    public TapList<SymbolDecl> symbolDeclDeclared(Tree tree, SymbolTable inSymbolTable) {
        TapList<Object> toResult;
        TapList<Object> symbolDecls = toResult = new TapList<Object>(null, null);
        int op = tree.opCode();
        SymbolTable symbolTable = inSymbolTable != null ? inSymbolTable : (this.unit() != null ? (this.unit().isModule() ? this.unit().privateSymbolTable() : this.symbolTable) : (TapEnv.relatedUnit() != null ? TapEnv.relatedUnit().privateSymbolTable() : this.symbolTable));
        switch (op) {
            case 199: {
                Tree declarators = tree.down(3);
                if (declarators.opCode() != 54) break;
                for (int i = 1; i <= declarators.length(); ++i) {
                    SymbolDecl symbolDecl;
                    String name = ILUtils.baseName(declarators.down(i));
                    if (name == null || symbolTable == null || (symbolDecl = symbolTable.getSymbolDecl(name)) == null) continue;
                    symbolDecls.placdl(symbolDecl);
                }
                break;
            }
            case 202: {
                for (int i = 1; i <= tree.length(); ++i) {
                    SymbolDecl symbolDecl;
                    String name = ILUtils.baseName(tree.down(i));
                    if (name == null || symbolTable == null || (symbolDecl = symbolTable.getSymbolDecl(name)) == null) continue;
                    symbolDecls.placdl(symbolDecl);
                }
                break;
            }
            case 45: {
                break;
            }
            case 192: {
                SymbolDecl symbolDecl;
                String name = ILUtils.baseName(tree.down(1));
                if (name == null || symbolTable == null || (symbolDecl = symbolTable.getSymbolDecl(name)) == null) break;
                symbolDecls.placdl(symbolDecl);
                break;
            }
            case 90: {
                break;
            }
            case 2: {
                SymbolDecl symbolDecl;
                String name;
                if (tree.down(2).opCode() != 192 || (name = tree.down(2).down(1).stringValue()) == null || symbolTable == null || (symbolDecl = symbolTable.getSymbolDecl(name)) == null) break;
                symbolDecls.placdl(symbolDecl);
                break;
            }
            case 74: {
                for (int i = 1; i <= tree.length(); ++i) {
                    SymbolDecl symbolDecl;
                    String name = ILUtils.baseName(tree.down(i));
                    if (name == null || symbolTable == null || (symbolDecl = symbolTable.getSymbolDecl(name)) == null) continue;
                    symbolDecls.placdl(symbolDecl);
                }
                break;
            }
            case 106: {
                SymbolDecl symbolDecl;
                String name;
                if (tree.down(1).opCode() == 96 && (name = tree.down(1).stringValue()) != null && symbolTable != null && (symbolDecl = symbolTable.getSymbolDecl(name)) != null) {
                    symbolDecls.placdl(symbolDecl);
                }
                for (int i = 1; i <= tree.down(2).length(); ++i) {
                    if (tree.down(2).down(i).opCode() != 105 || (name = ILUtils.getUnitName(tree.down(2).down(i).down(1))) == null || symbolTable == null || (symbolDecl = symbolTable.getSymbolDecl(name)) == null) continue;
                    symbolDecls.placdl(symbolDecl);
                }
                break;
            }
            case 108: {
                break;
            }
            case 171: {
                break;
            }
            case 36: 
            case 46: 
            case 56: 
            case 89: 
            case 131: 
            case 136: 
            case 159: {
                SymbolDecl symbolDecl;
                String name;
                Tree unitName = tree.down(op == 89 ? 4 : (op == 131 || op == 136 ? 1 : 2));
                if (ILUtils.isNullOrNone(unitName) || tree.getAnnotation("Unit") != null || symbolTable == null || (name = unitName.stringValue()) == null || (symbolDecl = symbolTable.getSymbolDecl(name)) == null) break;
                symbolDecls.placdl(symbolDecl);
                break;
            }
        }
        return toResult.tail;
    }

    private boolean dependsOn(Tree tree, TapList<SymbolDecl> symbolDecls, Instruction defInstr, SymbolTable declST, boolean strict) {
        boolean result = false;
        if (tree != null && !ILUtils.isADeclMayAppearFirst(tree)) {
            SymbolTable symbolTable = this.symbolTable;
            if (this.unit() != null && (symbolTable == null || this.unit().isModule())) {
                symbolTable = this.unit().privateSymbolTable();
            }
            TapList<Object> toUsedSymbolsInTree = new TapList<Object>(null, null);
            SymbolDecl.addUsedSymbolsInExpr(tree, toUsedSymbolsInTree, declST, null, false, strict);
            TapList<SymbolDecl> inSymbolDecls = symbolDecls;
            while (inSymbolDecls != null && !result) {
                SymbolDecl symbolDecl = (SymbolDecl)inSymbolDecls.head;
                result = this.dependsOnOne(tree, symbolDecl, defInstr, symbolTable);
                if (!result) {
                    result = TapList.containsSameNameSymbolDecl(toUsedSymbolsInTree.tail, symbolDecl);
                }
                inSymbolDecls = inSymbolDecls.tail;
            }
        }
        return result;
    }

    private boolean dependsOnOne(Tree tree, SymbolDecl symbolDecl, Instruction defInstr, SymbolTable symbolTable) {
        boolean depends = false;
        int op = tree.opCode();
        SymbolDecl symbDecl = null;
        switch (op) {
            case 45: 
            case 199: {
                String baseName = ILUtils.baseName(tree.down(op == 45 ? 1 : 2));
                if (baseName != null) {
                    symbDecl = symbolTable.getSymbolDecl(baseName);
                }
                depends = symbolDecl == null ? false : symbDecl == symbolDecl && !symbDecl.isA(3) || symbDecl != null && TapList.contains(symbDecl.dependsOn, symbolDecl) || symbDecl != null && symbolDecl.isA(1) && TapList.containsVariableDecl(symbDecl.dependsOn, (VariableDecl)symbolDecl);
                Tree[] declarators = tree.down(op == 45 ? 2 : 3).children();
                for (int i = declarators.length - 1; !depends && i >= 0; --i) {
                    symbDecl = symbolTable.getSymbolDecl(ILUtils.baseName(declarators[i]));
                    if (symbolDecl == null) {
                        depends = false;
                    } else {
                        boolean bl = depends = symbDecl == symbolDecl && !symbDecl.isA(3) || symbDecl != null && TapList.contains(symbDecl.dependsOn, symbolDecl) || symbDecl != null && symbolDecl.isA(1) && TapList.containsVariableDecl(symbDecl.dependsOn, (VariableDecl)symbolDecl);
                    }
                    if (defInstr.tree.opCode() != 202 && defInstr.tree.opCode() != 2 || symbDecl != symbolDecl) continue;
                    depends = false;
                }
                break;
            }
            case 202: {
                for (int i = tree.length(); !depends && i > 0; --i) {
                    symbDecl = symbolTable.getSymbolDecl(ILUtils.baseName(tree.down(i)));
                    depends = symbDecl != null && (symbDecl == symbolDecl || TapList.contains(symbDecl.dependsOn, symbolDecl) || symbolDecl.isA(1) && TapList.containsVariableDecl(symbDecl.dependsOn, (VariableDecl)symbolDecl));
                }
                break;
            }
            case 39: {
                for (int i = tree.down(2).length(); !depends && i > 0; --i) {
                    symbDecl = symbolTable.getSymbolDecl(ILUtils.baseName(tree.down(2).down(i)));
                    depends = symbDecl != null && (TapList.contains(symbDecl.dependsOn, symbolDecl) || symbolDecl.isA(1) && TapList.containsVariableDecl(symbDecl.dependsOn, (VariableDecl)symbolDecl));
                }
                break;
            }
            case 69: {
                for (int i = tree.length(); !depends && i > 0; --i) {
                    for (int j = tree.down(i).length(); !depends && j > 0; --j) {
                        symbDecl = symbolTable.getSymbolDecl(ILUtils.baseName(tree.down(i).down(j)));
                        depends = symbDecl != null && (symbDecl == symbolDecl || TapList.contains(symbDecl.dependsOn, symbolDecl) || symbolDecl.isA(1) && TapList.containsVariableDecl(symbDecl.dependsOn, (VariableDecl)symbolDecl));
                    }
                }
                break;
            }
            case 192: {
                if (tree.down(1).opCode() != 96) break;
                symbDecl = symbolTable.getSymbolDecl(ILUtils.baseName(tree.down(1)));
                depends = symbDecl != null && symbolDecl != null && TapList.containsEquals(symbDecl.dependsOn, symbolDecl);
                break;
            }
            case 2: {
                if (ILUtils.isIdent(tree.down(1), "bind", false)) break;
                tree = tree.down(2);
                if (tree.opCode() == 192) break;
                for (int i = tree.length(); !depends && i > 0; --i) {
                    symbDecl = symbolTable.getSymbolDecl(ILUtils.baseName(tree.down(i)));
                    depends = symbDecl != null && (symbDecl == symbolDecl || TapList.contains(symbDecl.dependsOn, symbolDecl) || symbDecl != null && symbolDecl.isA(1) && TapList.containsVariableDecl(symbDecl.dependsOn, (VariableDecl)symbolDecl));
                }
                break;
            }
            case 89: {
                String funcName = ILUtils.baseName(tree.down(4));
                if (funcName == null) break;
                symbDecl = symbolTable.getSymbolDecl(funcName);
                depends = symbDecl != null && TapList.contains(symbDecl.dependsOn, symbolDecl) || symbDecl != null && symbolDecl.isA(1) && TapList.containsVariableDecl(symbDecl.dependsOn, (VariableDecl)symbolDecl);
                break;
            }
            case 74: 
            case 90: 
            case 106: 
            case 108: 
            case 171: 
            case 197: {
                break;
            }
        }
        return depends;
    }

    public void removeInstr(Instruction instr) {
        TapList<Instruction> toInstructions;
        TapList<Instruction> inInstructions = toInstructions = new TapList<Instruction>(null, this.instructions);
        while (inInstructions.tail != null && inInstructions.tail.head != instr) {
            inInstructions = inInstructions.tail;
        }
        if (inInstructions.tail != null) {
            inInstructions.tail = inInstructions.tail.tail;
        }
        this.instructions = toInstructions.tail;
    }

    protected void removeExternalInstr(SymbolDecl symbolDecl) {
        TapList<Instruction> toInstructions;
        TapList<Instruction> inInstructions = toInstructions = new TapList<Instruction>(null, this.instructions);
        while (!(inInstructions.tail == null || ((Instruction)inInstructions.tail.head).tree.opCode() == 74 && ((Instruction)inInstructions.tail.head).tree.down(1).stringValue().equals(symbolDecl.symbol))) {
            inInstructions = inInstructions.tail;
        }
        if (inInstructions.tail != null) {
            inInstructions.tail = inInstructions.tail.tail;
        }
        this.instructions = toInstructions.tail;
    }

    public Instruction getOperatorDeclarationInstruction(SymbolDecl symbolDecl, int operator, SymbolTable symbolTable) {
        Instruction result = null;
        TapList<Instruction> instrs = this.instructions;
        while (instrs != null && result == null) {
            TapList<SymbolDecl> symbolDecls;
            Instruction curInstr = (Instruction)instrs.head;
            if (curInstr.tree != null && curInstr.tree.opCode() == operator && TapList.containsEquals(symbolDecls = this.symbolDeclDeclared(curInstr.tree, symbolTable), symbolDecl)) {
                result = curInstr;
            }
            instrs = instrs.tail;
        }
        return result;
    }

    public void insertBlockBefore(Block block) {
        TapList<FGArrow> arrows;
        block.backFlow = arrows = this.backFlow;
        this.backFlow = null;
        while (arrows != null) {
            ((FGArrow)arrows.head).destination = block;
            arrows = arrows.tail;
        }
        new FGArrow(block, 0, null, this);
    }

    public void removeAndShunt() {
        if (this.flow == null || this.flow.tail != null) {
            TapEnv.toolWarning(-1, "Removing a Block with more than one flow arrow");
        } else {
            FGArrow flowArrow = (FGArrow)this.flow.head;
            Block futureDest = flowArrow.destination;
            flowArrow.redirectDestination(null);
            TapList<FGArrow> inBackFlow = this.backFlow;
            while (inBackFlow != null) {
                FGArrow backFlowArrow = (FGArrow)inBackFlow.head;
                backFlowArrow.redirectDestination(futureDest);
                backFlowArrow.inACycle = flowArrow.inACycle;
                backFlowArrow.isAJumpIntoNextCase = flowArrow.isAJumpIntoNextCase;
                inBackFlow = inBackFlow.tail;
            }
        }
    }

    public boolean isALoop() {
        return this.instructions != null && this.instructions.tail == null && ((Instruction)this.instructions.head).tree != null && ((Instruction)this.instructions.head).tree.opCode() == 121 && ((Instruction)this.instructions.head).tree.down(4).opCode() == 138;
    }

    public boolean isADoLoop() {
        return this.enclosing != null && this.isALoop() && ((Instruction)this.instructions.head).tree.down(3).opCode() == 64 && ((LoopBlock)this.enclosing).header() == this;
    }

    public boolean isDoWithIndexUnusedAfterLoop() {
        return this instanceof HeaderBlock && ((HeaderBlock)this).loopIndexUnusedAfterLoop && this.isALoop() && ((Instruction)this.instructions.head).tree.down(3).opCode() == 64;
    }

    public boolean isATimesLoop() {
        return this.enclosing != null && this.isALoop() && ((Instruction)this.instructions.head).tree.down(3).opCode() == 189 && ((LoopBlock)this.enclosing).header() == this;
    }

    public boolean isACleanDoLoop() {
        return this.enclosing != null && this.isALoop() && ((Instruction)this.instructions.head).tree.down(3).opCode() == 64 && ((LoopBlock)this.enclosing).entryBlocks != null && ((LoopBlock)this.enclosing).entryBlocks.tail == null && ((LoopBlock)this.enclosing).entryBlocks.head == this && ((LoopBlock)this.enclosing).exitArrows != null && ((LoopBlock)this.enclosing).exitArrows.tail == null && ((FGArrow)((LoopBlock)this.enclosing).exitArrows.head).origin == this;
    }

    public boolean isControl() {
        return this.flow != null && this.flow.tail != null || this instanceof HeaderBlock || this.isParallelController();
    }

    public boolean isParallelController() {
        return this.instructions != null && ILUtils.isParallelController(((Instruction)this.instructions.head).tree);
    }

    public int lastTest() {
        Instruction lastInstruction = this.lastInstr();
        int code = -1;
        if (lastInstruction != null && lastInstruction.tree != null && (code = lastInstruction.tree.opCode()) != 98 && code != 121 && code != 205 && code != 31 && code != 109 && code != 184 && code != 40 && code != 94 && code != 168) {
            code = -1;
        }
        return code;
    }

    public boolean isAnIf() {
        Instruction lastInstr = this.lastInstr();
        if (lastInstr != null && lastInstr.tree != null && lastInstr.tree.opCode() == 98) {
            Tree b1 = lastInstr.tree.down(2);
            Tree b2 = lastInstr.tree.down(3);
            return !(b1 != null && b1.opCode() != 138 || b2 != null && b2.opCode() != 138 || this.flow == null || this.flow.head == null || ((FGArrow)this.flow.head).test != 20);
        }
        return false;
    }

    public boolean isANameSpace() {
        Instruction lastInstr = this.lastInstr();
        return lastInstr != null && lastInstr.tree != null && lastInstr.tree.opCode() == 136 && ILUtils.isNullOrNone(lastInstr.tree.down(2));
    }

    public boolean containsNoCode() {
        boolean noCode = true;
        TapList<Instruction> inInstructions = this.instructions;
        while (inInstructions != null) {
            if (!((Instruction)inInstructions.head).isANoOp()) {
                noCode = false;
            }
            inInstructions = inInstructions.tail;
        }
        return noCode && this.flow != null && this.flow.tail == null;
    }

    public FGArrow getFGArrowTo(Block nextBlock) {
        TapList<FGArrow> inFlow = this.flow;
        while (inFlow != null && ((FGArrow)inFlow.head).destination != nextBlock) {
            inFlow = inFlow.tail;
        }
        if (inFlow != null) {
            return (FGArrow)inFlow.head;
        }
        return null;
    }

    public FGArrow getFGArrowTestCase(int test, int oneCase) {
        FGArrow thisCaseArrow = null;
        FGArrow defaultCaseArrow = null;
        TapList<FGArrow> arrows = this.flow;
        while (arrows != null && thisCaseArrow == null) {
            FGArrow currentArrow = (FGArrow)arrows.head;
            if (currentArrow.test == test) {
                if (currentArrow.test == 0 || currentArrow.containsCase(oneCase)) {
                    thisCaseArrow = currentArrow;
                } else if (TapIntList.contains(currentArrow.cases, -1)) {
                    defaultCaseArrow = currentArrow;
                }
            }
            arrows = arrows.tail;
        }
        return thisCaseArrow != null ? thisCaseArrow : defaultCaseArrow;
    }

    protected Block enclosingBlock() {
        return this.enclosing;
    }

    protected void setEnclosingBlock(Block enclosingBlock) {
        this.enclosing = enclosingBlock;
    }

    protected void setEnclosingBlockProtected(Block enclosingBlock) {
        if (this.enclosing == null) {
            this.enclosing = enclosingBlock;
        } else {
            Block aboveLoop = enclosingBlock.enclosing;
            while (aboveLoop != this.enclosing && aboveLoop != null) {
                aboveLoop = aboveLoop.enclosing;
            }
            if (aboveLoop != null) {
                this.enclosing = enclosingBlock;
            }
        }
    }

    public TapList<LoopBlock> enclosingLoops() {
        if (this.enclosing == null) {
            return null;
        }
        return new TapList<LoopBlock>((LoopBlock)this.enclosing, this.enclosingLoop().enclosingLoopBlocks());
    }

    public boolean enclosedIn(LoopBlock loopBlock) {
        if (this.enclosing == loopBlock) {
            return true;
        }
        if (this.enclosing == null) {
            return false;
        }
        return this.enclosing.enclosedIn(loopBlock);
    }

    protected void mergeWithSuccessor(Block nextBlock) {
        TapList<FGArrow> arrows;
        if (this.instructions == null) {
            if (this.origLabel == null) {
                this.origLabel = nextBlock.origLabel;
            }
            this.instructions = nextBlock.instructions;
        } else {
            TapList<Instruction> inInstructions = this.instructions;
            while (inInstructions.tail != null) {
                inInstructions = inInstructions.tail;
            }
            inInstructions.tail = nextBlock.instructions;
        }
        nextBlock.instructions = null;
        this.flow = arrows = nextBlock.flow;
        while (arrows != null) {
            ((FGArrow)arrows.head).origin = this;
            arrows = arrows.tail;
        }
        nextBlock.flow = null;
        nextBlock.backFlow = null;
        if (nextBlock.symbolTable != null && nextBlock.symbolTable.declarationsBlock == nextBlock) {
            nextBlock.symbolTable.declarationsBlock = this;
        }
    }

    protected void skipEmpty() {
        if (this.flow == null) {
            while (this.backFlow != null) {
                ((FGArrow)this.backFlow.head).delete();
            }
        } else {
            FGArrow arrow = (FGArrow)this.flow.head;
            boolean inCycle = arrow.inACycle;
            Block nextBlock = arrow.destination;
            arrow.delete();
            while (this.backFlow != null) {
                ((FGArrow)this.backFlow.head).destination = nextBlock;
                if (inCycle) {
                    ((FGArrow)this.backFlow.head).inACycle = inCycle;
                }
                nextBlock.backFlow = new TapList<FGArrow>((FGArrow)this.backFlow.head, nextBlock.backFlow);
                this.backFlow = this.backFlow.tail;
            }
            if (inCycle && nextBlock instanceof HeaderBlock && ((HeaderBlock)nextBlock).origCycleLabel() == null) {
                ((HeaderBlock)nextBlock).setOrigCycleLabel(this.origLabel);
            } else if (nextBlock.origLabel == null) {
                nextBlock.origLabel = this.origLabel;
            }
            if (this.symbolTable != null && this.symbolTable.declarationsBlock == this) {
                this.symbolTable.declarationsBlock = nextBlock;
            }
        }
        this.flow = null;
        this.backFlow = null;
    }

    protected void exchangeFlowArrowsTo(Block dest1, Block dest2) {
        TapList<FGArrow> toDest1 = null;
        TapList<FGArrow> toDest2 = null;
        TapList<FGArrow> inFlow = this.flow;
        while (inFlow != null) {
            if (((FGArrow)inFlow.head).destination == dest1) {
                toDest1 = inFlow;
            } else if (((FGArrow)inFlow.head).destination == dest2) {
                toDest2 = inFlow;
            }
            inFlow = inFlow.tail;
        }
        if (toDest1 != null && toDest2 != null) {
            FGArrow tmpArrow = (FGArrow)toDest1.head;
            toDest1.head = toDest2.head;
            toDest2.head = tmpArrow;
        }
    }

    protected void coherence() {
        TapList<Instruction> inInstructions = this.instructions;
        while (inInstructions != null) {
            ((Instruction)inInstructions.head).block = this;
            inInstructions = inInstructions.tail;
        }
        TapList<FGArrow> inArrows = this.flow;
        while (inArrows != null) {
            ((FGArrow)inArrows.head).origin = this;
            inArrows = inArrows.tail;
        }
        inArrows = this.backFlow;
        while (inArrows != null) {
            ((FGArrow)inArrows.head).destination = this;
            inArrows = inArrows.tail;
        }
    }

    protected void splitInstructions(TapList<Instruction> beforeEntry, TapList<Instruction> beforeCycle) {
        TapList<Object> topNewInstructionsReverse = new TapList<Object>(null, null);
        TapList<Object> topNewDeclarations = new TapList<Object>(null, null);
        SymbolTable declSymbolTable = this.symbolTable;
        ToBool hasBeenSplit = new ToBool(false);
        while (declSymbolTable.declarationsBlock == null || declSymbolTable.declarationsBlock.isALoop()) {
            declSymbolTable = declSymbolTable.basisSymbolTable();
        }
        while (this.instructions != null) {
            Instruction instruction = (Instruction)this.instructions.head;
            TapEnv.get().resultRK = 1;
            TapEnv.get().argRK = 1;
            TapEnv.get().expRK = 1;
            this.splitMaskInWhereInstructionRec(instruction, instruction.whereMask(), topNewInstructionsReverse);
            hasBeenSplit.set(false);
            Tree split = this.splitTree(instruction.tree, topNewInstructionsReverse, topNewDeclarations, beforeEntry, beforeCycle, this.symbolTable, declSymbolTable, instruction, false, false, false, true, hasBeenSplit);
            if (split != null) {
                instruction.setTree(split);
                if (TapEnv.relatedUnit().isFortran() && !ILUtils.isAUnitPlaceHolder(split) && (ILUtils.isADeclaration(split) || split.opCode() == 138) && (split.opCode() != 101 && split.opCode() != 138 || topNewInstructionsReverse.tail == null)) {
                    topNewDeclarations.placdl(instruction);
                } else {
                    topNewInstructionsReverse.placdl(instruction);
                }
            }
            if (hasBeenSplit.get()) {
                instruction.tree.setAnnotation("hasBeenSplit", Boolean.TRUE);
            }
            this.instructions = this.instructions.tail;
        }
        topNewInstructionsReverse = topNewInstructionsReverse.tail;
        while (topNewInstructionsReverse != null) {
            this.instructions = new TapList<Instruction>((Instruction)topNewInstructionsReverse.head, this.instructions);
            topNewInstructionsReverse = topNewInstructionsReverse.tail;
        }
        topNewDeclarations = topNewDeclarations.tail;
        while (topNewDeclarations != null) {
            this.instructions = new TapList<Instruction>((Instruction)topNewDeclarations.head, this.instructions);
            topNewDeclarations = topNewDeclarations.tail;
        }
    }

    private void splitMaskInWhereInstructionRec(Instruction instruction, InstructionMask origInstructionMask, TapList<Instruction> topNewInstructionsReverse) {
        if (origInstructionMask != null) {
            this.splitMaskInWhereInstructionRec(instruction, origInstructionMask.enclosingMask, topNewInstructionsReverse);
            Tree testTree = origInstructionMask.getControlTree();
            if (this.whereTestMustBeSplit(testTree)) {
                WrapperTypeSpec testTypeSpec = this.symbolTable.typeOf(testTree);
                boolean arrayTriplet = false;
                Tree arrayAccessTree = null;
                if (TypeSpec.isA(testTypeSpec, 2) && testTree != null && ILUtils.containsArrayTriplet(testTree)) {
                    arrayTriplet = true;
                    arrayAccessTree = ILUtils.findArrayTriplet(testTree);
                    WrapperTypeSpec arrayTypeSpec = this.symbolTable.typeOf(arrayAccessTree);
                    ((ArrayTypeSpec)arrayTypeSpec.wrappedType).checkDimensions(arrayAccessTree, this.symbolTable);
                    ((ArrayTypeSpec)testTypeSpec.wrappedType).setDimensions(((ArrayTypeSpec)arrayTypeSpec.wrappedType).dimensions());
                }
                String name = TapEnv.disambigNewName("mask");
                NewSymbolHolder symbolHolder = new NewSymbolHolder(name);
                TapList<Object> toDependsOn = new TapList<Object>(null, null);
                SymbolDecl.addUsedSymbolsInExpr(testTree, toDependsOn, this.symbolTable, null, false, true);
                symbolHolder.setDependsOn(toDependsOn);
                String hintNameInIdent = name;
                String hintNameInText = name;
                Tree hintTreeInSize = null;
                if (symbolHolder.hintRootTree != null) {
                    hintNameInIdent = ILUtils.buildNameInIdent(symbolHolder.hintRootTree);
                    hintNameInText = ILUtils.buildNameInText(symbolHolder.hintRootTree);
                }
                if (symbolHolder.hintArrayTreeForCallSize != null) {
                    hintTreeInSize = ILUtils.buildSizeArgument1(symbolHolder.hintArrayTreeForCallSize, this.symbolTable);
                }
                testTypeSpec = testTypeSpec.checkNoneDimensionsOfNewSH(hintNameInText, hintNameInIdent, hintTreeInSize, this.symbolTable, symbolHolder);
                symbolHolder.setAsVariable(testTypeSpec, null);
                Tree newRef = symbolHolder.makeNewRef(this.symbolTable);
                if (arrayTriplet) {
                    newRef = ILUtils.build(9, newRef, ILUtils.keepArrayTriplet(arrayAccessTree.down(2)));
                }
                Tree maskSetTree = ILUtils.build(14, newRef, ILUtils.copy(testTree));
                symbolHolder.declarationLevelMustInclude(this.symbolTable);
                Instruction splitInstruction = this.makeSplitInstruction(maskSetTree, instruction, true);
                splitInstruction.declareIsMaskDefinition();
                symbolHolder.declareUsageInstruction(splitInstruction);
                splitInstruction.setWhereMask(origInstructionMask.enclosingMask);
                topNewInstructionsReverse.placdl(splitInstruction);
                newRef = ILUtils.copy(newRef);
                origInstructionMask.setControlTree(newRef);
                if (instruction.tree.opCode() == 205) {
                    instruction.tree.setChild(newRef, 1);
                }
            }
        }
    }

    private boolean whereTestMustBeSplit(Tree testTree) {
        return TapEnv.modeIsAdjoint() && !ILUtils.isAVarRef(testTree, this.symbolTable);
    }

    private Tree splitTree(Tree tree, TapList<Instruction> topNewInstructionsReverse, TapList<Instruction> topNewDeclarations, TapList<Instruction> beforeEntry, TapList<Instruction> beforeCycle, SymbolTable symbolTable, SymbolTable declSymbolTable, Instruction oldInstruction, boolean inExpr, boolean assigned, boolean nonLinear, boolean withMask, ToBool hasBeenSplit) {
        switch (tree.opCode()) {
            case 14: 
            case 63: 
            case 125: 
            case 150: 
            case 190: {
                this.splitTreeDown(tree, 1, topNewInstructionsReverse, topNewDeclarations, beforeEntry, beforeCycle, symbolTable, oldInstruction, nonLinear, withMask, hasBeenSplit);
                Tree split = this.splitTree(tree.down(2), topNewInstructionsReverse, topNewDeclarations, beforeEntry, beforeCycle, symbolTable, declSymbolTable, oldInstruction, true, true, nonLinear, withMask, hasBeenSplit);
                if (tree.down(2) != split) {
                    tree.setChild(split, 2);
                }
                if (inExpr) {
                    Instruction newInstr = this.makeSplitInstruction(tree, oldInstruction, withMask);
                    this.emitNewSplitInstr(newInstr, topNewInstructionsReverse, beforeEntry, beforeCycle);
                    tree = ILUtils.copy(tree.down(1));
                }
                tree = this.addSizeAndTypeInAllocate(tree);
                return tree;
            }
            case 152: {
                return this.addSizeAndTypeInAllocate(tree);
            }
            case 31: {
                NewSymbolHolder symbolHolder;
                Instruction newDecl;
                Unit calledFunctionUnit = DataFlowAnalyzer.getCalledUnit(tree, symbolTable);
                FunctionTypeSpec functionTypeSpec = (FunctionTypeSpec)tree.getAnnotation("functionTypeSpec");
                if (functionTypeSpec == null && calledFunctionUnit != null) {
                    functionTypeSpec = calledFunctionUnit.functionTypeSpec();
                }
                Tree[] args = ILUtils.getArguments(tree).children();
                boolean isElementalNoChangeDim = calledFunctionUnit != null && calledFunctionUnit.isElemental() && !TapEnv.stringContainedIn(calledFunctionUnit.name().toLowerCase(), new String[]{"sum", "spread", "any"});
                boolean functionMayBeActive = calledFunctionUnit == null || TypeSpec.isDifferentiableType(functionTypeSpec);
                for (int i = 0; i < args.length; ++i) {
                    boolean inNameEq;
                    Tree oldArg = args[i];
                    boolean bl = inNameEq = oldArg.opCode() == 134;
                    if (inNameEq) {
                        oldArg = oldArg.down(2);
                    }
                    Tree newArg = this.splitTree(oldArg, topNewInstructionsReverse, topNewDeclarations, beforeEntry, beforeCycle, symbolTable, declSymbolTable, oldInstruction, true, false, true, withMask, hasBeenSplit);
                    ToBool maskInSum = null;
                    if (i == 1) {
                        maskInSum = new ToBool(false);
                    }
                    if (this.funcArgMustBeSplit(newArg, tree, functionMayBeActive, calledFunctionUnit, nonLinear, symbolTable, maskInSum)) {
                        WrapperTypeSpec argTypeSpec = symbolTable.typeOf(oldArg);
                        if ((argTypeSpec == null || argTypeSpec.wrappedType == null || argTypeSpec.wrappedType.containsUndefinedType() || argTypeSpec.wrappedType.isUndefinedNumeric()) && functionTypeSpec != null && functionTypeSpec.argumentsTypes != null && functionTypeSpec.argumentsTypes.length > i) {
                            argTypeSpec = functionTypeSpec.argumentsTypes[i];
                        }
                        if (argTypeSpec == null || argTypeSpec.wrappedType == null || argTypeSpec.wrappedType.containsUndefinedType()) {
                            TapEnv.fileWarning(15, oldArg, "(TC43) Could not find type of argument " + (i + 1) + " of procedure " + ILUtils.getCalledName(tree) + ", please check");
                        }
                        newDecl = new Instruction();
                        newDecl.block = this.symbolTable.declarationsBlock;
                        symbolHolder = this.findOrBuildHolder(argTypeSpec, TapEnv.disambigNewName("arg" + TapEnv.get().argRK), declSymbolTable, newDecl, topNewDeclarations);
                        ++TapEnv.get().argRK;
                        if (newArg.parent() != null) {
                            newArg = ILUtils.copy(newArg);
                        }
                        hasBeenSplit.set(true);
                        if (TypeSpec.isA(argTypeSpec, 2)) {
                            Tree arrayAccessTree = ILUtils.build(71);
                            assert (argTypeSpec != null);
                            for (int length = ((ArrayTypeSpec)argTypeSpec.wrappedType).dimensions().length; length > 0; --length) {
                                arrayAccessTree.setChild(ILUtils.build(12, ILUtils.build(138), ILUtils.build(138), ILUtils.build(138)), length);
                            }
                            newArg = TapEnv.relatedUnit().isFortran9x() ? ILUtils.build(14, ILUtils.build(9, symbolHolder.makeNewRef(symbolTable), ILUtils.copy(arrayAccessTree)), newArg) : ILUtils.build(14, symbolHolder.makeNewRef(symbolTable), newArg);
                        } else {
                            newArg = ILUtils.build(14, symbolHolder.makeNewRef(symbolTable), newArg);
                        }
                        symbolHolder.declarationLevelMustInclude(declSymbolTable);
                        assert (argTypeSpec != null);
                        Instruction newInstr = this.makeSplitInstruction(newArg, oldInstruction, isElementalNoChangeDim && argTypeSpec.isArray());
                        this.emitNewSplitInstr(newInstr, topNewInstructionsReverse, beforeEntry, beforeCycle);
                        symbolHolder.declareUsageInstruction(newInstr);
                        if (maskInSum != null && maskInSum.get()) {
                            newInstr.setWhereMask(null);
                        }
                        newArg = newArg.down(1);
                    }
                    if (oldArg == newArg) continue;
                    newArg = ILUtils.copy(newArg);
                    if (inNameEq) {
                        ILUtils.getArguments(tree).down(i + 1).setChild(newArg, 2);
                        continue;
                    }
                    ILUtils.getArguments(tree).setChild(newArg, i + 1);
                }
                if (this.funcResultMustBeSplit(tree, inExpr, assigned, functionMayBeActive, calledFunctionUnit, nonLinear, symbolTable)) {
                    WrapperTypeSpec resultTypeSpec = symbolTable.typeOf(tree);
                    if (resultTypeSpec == null || resultTypeSpec.wrappedType == null || resultTypeSpec.wrappedType.containsUndefinedType()) {
                        TapEnv.fileWarning(15, tree, "(TC44) Could not find type of result of function " + ILUtils.toString(ILUtils.getCalledName(tree)) + ", please check");
                    }
                    newDecl = new Instruction();
                    newDecl.block = this.symbolTable.declarationsBlock;
                    symbolHolder = this.findOrBuildHolder(resultTypeSpec, TapEnv.disambigNewName("result" + TapEnv.get().resultRK), declSymbolTable, newDecl, topNewDeclarations);
                    ++TapEnv.get().resultRK;
                    hasBeenSplit.set(true);
                    tree = ILUtils.build(14, symbolHolder.makeNewRef(symbolTable), ILUtils.copy(tree));
                    symbolHolder.declarationLevelMustInclude(declSymbolTable);
                    assert (resultTypeSpec != null);
                    Instruction newInstr = this.makeSplitInstruction(tree, oldInstruction, resultTypeSpec.isArray());
                    this.emitNewSplitInstr(newInstr, topNewInstructionsReverse, beforeEntry, beforeCycle);
                    symbolHolder.declareUsageInstruction(newInstr);
                    tree = symbolHolder.makeNewRef(symbolTable);
                }
                return tree;
            }
            case 47: {
                Tree[] expressions = tree.down(3).children();
                for (int i = 0; i < expressions.length; ++i) {
                    Tree split = this.splitTree(expressions[i], topNewInstructionsReverse, topNewDeclarations, beforeEntry, beforeCycle, symbolTable, declSymbolTable, oldInstruction, true, false, nonLinear, withMask, hasBeenSplit);
                    if (expressions[i] == split) continue;
                    tree.down(3).setChild(split, i + 1);
                }
                return tree;
            }
            case 109: {
                Tree[] expressions = tree.down(3).children();
                for (int i = 0; i < expressions.length; ++i) {
                    Tree split = this.splitTree(expressions[i], topNewInstructionsReverse, topNewDeclarations, beforeEntry, beforeCycle, symbolTable, declSymbolTable, oldInstruction, true, false, nonLinear, withMask, hasBeenSplit);
                    if (expressions[i] == split) continue;
                    tree.down(3).setChild(split, i + 1);
                }
                return tree;
            }
            case 9: {
                Tree[] indexes = tree.down(2).children();
                for (int i = 0; i < indexes.length; ++i) {
                    Tree split = this.splitTree(indexes[i], topNewInstructionsReverse, topNewDeclarations, beforeEntry, beforeCycle, symbolTable, declSymbolTable, oldInstruction, true, false, true, withMask, hasBeenSplit);
                    if (indexes[i] == split) continue;
                    tree.down(2).setChild(split, i + 1);
                }
                return tree;
            }
            case 151: {
                Tree split = this.splitTree(tree.down(2), topNewInstructionsReverse, topNewDeclarations, beforeEntry, beforeCycle, symbolTable, declSymbolTable, oldInstruction, true, false, true, withMask, hasBeenSplit);
                if (tree.down(2) != split) {
                    tree.setChild(split, 2);
                }
                return tree;
            }
            case 10: 
            case 71: 
            case 83: {
                Tree[] expressions = tree.children();
                for (int i = 0; i < expressions.length; ++i) {
                    Tree split = this.splitTree(expressions[i], topNewInstructionsReverse, topNewDeclarations, beforeEntry, beforeCycle, symbolTable, declSymbolTable, oldInstruction, true, false, nonLinear, withMask, hasBeenSplit);
                    if (expressions[i] == split) continue;
                    tree.setChild(split, i + 1);
                }
                return tree;
            }
            case 155: {
                this.splitTreeDown(tree, 1, topNewInstructionsReverse, topNewDeclarations, beforeEntry, beforeCycle, symbolTable, oldInstruction, true, withMask, hasBeenSplit);
                this.splitTreeDown(tree, 2, topNewInstructionsReverse, topNewDeclarations, beforeEntry, beforeCycle, symbolTable, oldInstruction, true, withMask, hasBeenSplit);
                return tree;
            }
            case 3: 
            case 6: 
            case 18: 
            case 22: 
            case 24: 
            case 42: 
            case 43: 
            case 68: 
            case 92: 
            case 95: 
            case 110: 
            case 115: 
            case 116: 
            case 122: 
            case 126: 
            case 137: 
            case 143: 
            case 169: 
            case 182: 
            case 184: 
            case 207: {
                this.splitTreeDown(tree, 1, topNewInstructionsReverse, topNewDeclarations, beforeEntry, beforeCycle, symbolTable, oldInstruction, nonLinear, withMask, hasBeenSplit);
                this.splitTreeDown(tree, 2, topNewInstructionsReverse, topNewDeclarations, beforeEntry, beforeCycle, symbolTable, oldInstruction, nonLinear, withMask, hasBeenSplit);
                return tree;
            }
            case 62: 
            case 133: {
                this.splitTreeDown(tree, 1, topNewInstructionsReverse, topNewDeclarations, beforeEntry, beforeCycle, symbolTable, oldInstruction, true, withMask, hasBeenSplit);
                this.splitTreeDown(tree, 2, topNewInstructionsReverse, topNewDeclarations, beforeEntry, beforeCycle, symbolTable, oldInstruction, true, withMask, hasBeenSplit);
                return tree;
            }
            case 98: 
            case 185: 
            case 205: {
                Tree split = this.splitTree(tree.down(1), topNewInstructionsReverse, topNewDeclarations, beforeEntry, beforeCycle, symbolTable, declSymbolTable, oldInstruction, true, false, nonLinear, withMask, hasBeenSplit);
                if (split == null) {
                    return tree;
                }
                if (tree.down(1) != split) {
                    tree.setChild(split, 1);
                }
                return tree;
            }
            case 4: {
                Tree split = this.splitTree(tree.down(1), topNewInstructionsReverse, topNewDeclarations, beforeEntry, beforeCycle, symbolTable, declSymbolTable, oldInstruction, true, true, nonLinear, withMask, hasBeenSplit);
                if (tree.down(1) != split) {
                    tree.setChild(split, 1);
                }
                return tree;
            }
            case 99: {
                this.splitTreeDown(tree, 1, topNewInstructionsReverse, topNewDeclarations, beforeEntry, beforeCycle, symbolTable, oldInstruction, true, withMask, hasBeenSplit);
                this.splitTreeDown(tree, 2, topNewInstructionsReverse, topNewDeclarations, beforeEntry, beforeCycle, symbolTable, oldInstruction, true, withMask, hasBeenSplit);
                this.splitTreeDown(tree, 3, topNewInstructionsReverse, topNewDeclarations, beforeEntry, beforeCycle, symbolTable, oldInstruction, true, withMask, hasBeenSplit);
                return tree;
            }
            case 75: 
            case 124: 
            case 139: 
            case 186: {
                this.splitTreeDown(tree, 1, topNewInstructionsReverse, topNewDeclarations, beforeEntry, beforeCycle, symbolTable, oldInstruction, nonLinear, withMask, hasBeenSplit);
                return tree;
            }
            case 144: 
            case 145: {
                return tree;
            }
            case 121: {
                this.splitTreeDown(tree, 3, topNewInstructionsReverse, topNewDeclarations, beforeEntry, beforeCycle, symbolTable, oldInstruction, nonLinear, withMask, hasBeenSplit);
                return tree;
            }
            case 64: {
                this.splitTreeDown(tree, 2, topNewInstructionsReverse, topNewDeclarations, beforeEntry, null, symbolTable, oldInstruction, nonLinear, withMask, hasBeenSplit);
                this.splitTreeDown(tree, 3, topNewInstructionsReverse, topNewDeclarations, beforeEntry, null, symbolTable, oldInstruction, nonLinear, withMask, hasBeenSplit);
                this.splitTreeDown(tree, 4, topNewInstructionsReverse, topNewDeclarations, beforeEntry, null, symbolTable, oldInstruction, nonLinear, withMask, hasBeenSplit);
                return tree;
            }
            case 206: {
                this.splitTreeDown(tree, 1, topNewInstructionsReverse, topNewDeclarations, beforeEntry, beforeCycle, symbolTable, oldInstruction, nonLinear, withMask, hasBeenSplit);
                return tree;
            }
            case 196: {
                this.splitTreeDown(tree, 1, topNewInstructionsReverse, topNewDeclarations, null, beforeCycle, symbolTable, oldInstruction, nonLinear, withMask, hasBeenSplit);
                return tree;
            }
            case 189: {
                this.splitTreeDown(tree, 1, topNewInstructionsReverse, topNewDeclarations, beforeEntry, null, symbolTable, oldInstruction, nonLinear, withMask, hasBeenSplit);
                return tree;
            }
            case 79: {
                return tree;
            }
            case 12: 
            case 183: {
                this.splitTreeDown(tree, 1, topNewInstructionsReverse, topNewDeclarations, beforeEntry, beforeCycle, symbolTable, oldInstruction, nonLinear, withMask, hasBeenSplit);
                this.splitTreeDown(tree, 2, topNewInstructionsReverse, topNewDeclarations, beforeEntry, beforeCycle, symbolTable, oldInstruction, nonLinear, withMask, hasBeenSplit);
                this.splitTreeDown(tree, 3, topNewInstructionsReverse, topNewDeclarations, beforeEntry, beforeCycle, symbolTable, oldInstruction, nonLinear, withMask, hasBeenSplit);
                return tree;
            }
            case 80: {
                this.splitTreeDown(tree, 1, topNewInstructionsReverse, topNewDeclarations, beforeEntry, beforeCycle, symbolTable, oldInstruction, nonLinear, withMask, hasBeenSplit);
                this.splitTreeDown(tree, 2, topNewInstructionsReverse, topNewDeclarations, beforeEntry, beforeCycle, symbolTable, oldInstruction, nonLinear, withMask, hasBeenSplit);
                return tree;
            }
            case 81: {
                this.splitTreeDown(tree, 2, topNewInstructionsReverse, topNewDeclarations, beforeEntry, beforeCycle, symbolTable, oldInstruction, nonLinear, withMask, hasBeenSplit);
                return tree;
            }
            case 82: {
                this.splitTreeDown(tree, 2, topNewInstructionsReverse, topNewDeclarations, beforeEntry, beforeCycle, symbolTable, oldInstruction, nonLinear, withMask, hasBeenSplit);
                this.splitTreeDown(tree, 3, topNewInstructionsReverse, topNewDeclarations, beforeEntry, beforeCycle, symbolTable, oldInstruction, nonLinear, withMask, hasBeenSplit);
                this.splitTreeDown(tree, 4, topNewInstructionsReverse, topNewDeclarations, beforeEntry, beforeCycle, symbolTable, oldInstruction, nonLinear, withMask, hasBeenSplit);
                return tree;
            }
            case 32: 
            case 134: 
            case 194: {
                this.splitTreeDown(tree, 2, topNewInstructionsReverse, topNewDeclarations, beforeEntry, beforeCycle, symbolTable, oldInstruction, nonLinear, withMask, hasBeenSplit);
                return tree;
            }
            case 168: {
                Tree split = this.splitTree(tree.down(1), topNewInstructionsReverse, topNewDeclarations, beforeEntry, beforeCycle, symbolTable, declSymbolTable, oldInstruction, true, false, nonLinear, withMask, hasBeenSplit);
                if (tree.down(1) != null && tree.down(1) == split && TapEnv.debugAdMode() != 0 && !TapEnv.modeIsAdjoint() && !ILUtils.isAVarRefOrConstant(split)) {
                    WrapperTypeSpec resultTypeSpec = symbolTable.typeOf(split);
                    if (resultTypeSpec == null || resultTypeSpec.wrappedType == null || resultTypeSpec.wrappedType.containsUndefinedType()) {
                        TapEnv.fileWarning(15, tree, "(TC44) Could not find type of returned value, please check");
                    }
                    Instruction newDecl = new Instruction();
                    newDecl.block = this.symbolTable.declarationsBlock;
                    NewSymbolHolder symbolHolder = this.findOrBuildHolder(resultTypeSpec, TapEnv.disambigNewName("result" + TapEnv.get().resultRK), declSymbolTable, newDecl, topNewDeclarations);
                    ++TapEnv.get().resultRK;
                    hasBeenSplit.set(true);
                    Tree assignTree = ILUtils.build(14, symbolHolder.makeNewRef(symbolTable), ILUtils.copy(split));
                    symbolHolder.declarationLevelMustInclude(declSymbolTable);
                    Instruction newInstr = this.makeSplitInstruction(assignTree, oldInstruction, false);
                    this.emitNewSplitInstr(newInstr, topNewInstructionsReverse, beforeEntry, beforeCycle);
                    symbolHolder.declareUsageInstruction(newInstr);
                    split = symbolHolder.makeNewRef(symbolTable);
                }
                if (tree.down(1) != split) {
                    tree.setChild(split, 1);
                }
                this.splitTreeDown(tree, 2, topNewInstructionsReverse, topNewDeclarations, beforeEntry, beforeCycle, symbolTable, oldInstruction, nonLinear, withMask, hasBeenSplit);
                return tree;
            }
            case 5: 
            case 15: 
            case 17: 
            case 20: 
            case 28: 
            case 30: 
            case 40: 
            case 49: 
            case 52: 
            case 61: 
            case 85: 
            case 94: 
            case 96: 
            case 103: 
            case 111: 
            case 118: 
            case 138: 
            case 140: 
            case 160: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 188: {
                return tree;
            }
            case 199: {
                if (TapEnv.relatedUnit().isFortran() && ILUtils.contains(tree, 14, null) != null && ILUtils.contains(tree, 130, "constant") == null && ILUtils.contains(tree, 171, null) == null || !TapEnv.relatedUnit().isFortran() && ILUtils.contains(tree, 14, null) != null && ILUtils.contains(tree, 130, "constant") == null && ILUtils.contains(tree, 130, "const") == null || (TapEnv.associationByAddress() || TapEnv.relatedUnit().isFortran() && !TapEnv.doTBR()) && ILUtils.contains(tree, 130, "constant") == null) {
                    Tree[] declarators = tree.down(3).children();
                    Tree assign = null;
                    Tree newDecl = null;
                    boolean splitDecls = false;
                    boolean splitNextDecls = false;
                    if (TapEnv.relatedUnit().isFortran()) {
                        topNewDeclarations.placdl(this.makeSplitInstruction(tree, oldInstruction, false));
                    } else {
                        topNewInstructionsReverse.placdl(this.makeSplitInstruction(tree, oldInstruction, false));
                    }
                    TapIntList deleteRanks = null;
                    for (int i = 0; i < declarators.length; ++i) {
                        Tree declarator = declarators[i];
                        if (declarator.opCode() == 14 && ILUtils.isOptPointersIdent(declarator.down(1))) {
                            Tree saveTypeTree;
                            boolean splitInsideInit;
                            Tree copiedAllocateTree = null;
                            boolean bl = splitInsideInit = !TapEnv.relatedUnit().isFortran() && !TapEnv.doTBR();
                            if (i > 0 || TapEnv.get().multiDirDiffMode && !this.unit().hasArrayNotation()) {
                                splitDecls = true;
                            }
                            Tree declaredIdent = declarator.down(1);
                            while (declaredIdent.opCode() == 153) {
                                declaredIdent = declaredIdent.down(1);
                            }
                            Tree splitInit = null;
                            if (!TapEnv.relatedUnit().isModule()) {
                                assign = ILUtils.build(14, ILUtils.copy(declaredIdent), ILUtils.copy(declarator.down(2)));
                                ILUtils.incorporateAnnotations(assign, declarator);
                                if (declarator.down(2).opCode() == 5) {
                                    copiedAllocateTree = assign.down(2);
                                }
                                splitInit = this.splitTree(assign.down(2), topNewInstructionsReverse, topNewDeclarations, beforeEntry, beforeCycle, symbolTable, declSymbolTable, oldInstruction, true, true, nonLinear, withMask, hasBeenSplit);
                            }
                            if (splitInit != null && (!declarator.down(2).equalsTree(assign.down(2)) || !TapEnv.relatedUnit().isFortran() && !TapEnv.modeIsNoDiff() && (splitInit.opCode() == 31 || splitInit.opCode() == 5) || TapEnv.get().multiDirDiffMode && !this.unit().hasArrayNotation() || TapEnv.associationByAddress())) {
                                assign.setChild(ILUtils.copy(splitInit), 2);
                                if (declarator.down(2).opCode() == 5) {
                                    copiedAllocateTree = assign.down(2);
                                }
                                splitInsideInit = true;
                            }
                            if (splitDecls) {
                                saveTypeTree = this.addSaveModifier(tree.down(2), symbolTable, declarators, i);
                                newDecl = ILUtils.build(199, ILUtils.build(130), ILUtils.copy(saveTypeTree), ILUtils.build(54, ILUtils.copy(declarator)));
                                deleteRanks = new TapIntList(i + 1, deleteRanks);
                                if (TapEnv.relatedUnit().isFortran()) {
                                    topNewDeclarations.placdl(this.makeSplitInstruction(newDecl, oldInstruction, false));
                                } else {
                                    topNewInstructionsReverse.placdl(this.makeSplitInstruction(newDecl, oldInstruction, false));
                                }
                                splitNextDecls = true;
                            }
                            if (splitInsideInit) {
                                tree.down(3).setChild(ILUtils.copy(declarator.down(1)), i + 1);
                                if (newDecl != null) {
                                    newDecl.down(3).setChild(ILUtils.copy(declarator.down(1)), 1);
                                }
                                topNewInstructionsReverse.placdl(this.makeSplitInstruction(assign, oldInstruction, false));
                            }
                            if (copiedAllocateTree != null && copiedAllocateTree != declarator.down(2)) {
                                symbolTable.unit.callGraph().replaceInAllocationPoints(declarator.down(2), copiedAllocateTree);
                            }
                            if (i != 0 || symbolTable.unit == null || !symbolTable.unit.isFortran9x() || ILUtils.contains(tree.down(2), 96, "save") != null) continue;
                            saveTypeTree = this.addSaveModifier(tree.down(2), symbolTable, declarators, 0);
                            tree.setChild(ILUtils.copy(saveTypeTree), 2);
                            continue;
                        }
                        if (!splitNextDecls) continue;
                        newDecl = ILUtils.build(199, ILUtils.build(130), ILUtils.copy(tree.down(2)), ILUtils.build(54, ILUtils.copy(declarator)));
                        deleteRanks = new TapIntList(i + 1, deleteRanks);
                        if (TapEnv.relatedUnit().isFortran()) {
                            topNewDeclarations.placdl(this.makeSplitInstruction(newDecl, oldInstruction, false));
                            continue;
                        }
                        topNewInstructionsReverse.placdl(this.makeSplitInstruction(newDecl, oldInstruction, false));
                    }
                    while (deleteRanks != null) {
                        tree.down(3).removeChild(deleteRanks.head);
                        deleteRanks = deleteRanks.tail;
                    }
                    return null;
                }
                return tree;
            }
            case 2: 
            case 29: 
            case 35: 
            case 39: 
            case 41: 
            case 45: 
            case 51: 
            case 67: 
            case 69: 
            case 74: 
            case 78: 
            case 88: 
            case 101: 
            case 104: 
            case 106: 
            case 108: 
            case 129: 
            case 135: 
            case 154: 
            case 161: 
            case 171: 
            case 176: 
            case 192: 
            case 195: 
            case 197: 
            case 202: 
            case 204: {
                return tree;
            }
            case 36: 
            case 46: 
            case 56: 
            case 89: {
                return tree;
            }
        }
        TapEnv.toolWarning(-1, "(Split tree) Unexpected operator: " + tree.opName());
        return tree;
    }

    private void emitNewSplitInstr(Instruction newInstr, TapList<Instruction> toNewInstructions, TapList<Instruction> beforeEntry, TapList<Instruction> beforeCycle) {
        if (beforeEntry == null && beforeCycle == null) {
            toNewInstructions.placdl(newInstr);
        } else {
            Instruction newInstrBis = newInstr;
            if (beforeEntry != null && beforeCycle != null) {
                newInstrBis = new Instruction(newInstr.tree, newInstr.syntaxController, null);
                newInstrBis.preComments = ILUtils.copy(newInstr.preComments);
                newInstrBis.preCommentsBlock = ILUtils.copy(newInstr.preCommentsBlock);
                newInstrBis.setWhereMask(newInstr.whereMask());
                newInstrBis.setFromInclude(newInstr.fromInclude());
            }
            if (beforeEntry != null) {
                beforeEntry.placdl(newInstr);
            }
            if (beforeCycle != null) {
                beforeCycle.placdl(newInstrBis);
            }
        }
    }

    private Tree addSizeAndTypeInAllocate(Tree instrOrExpr) {
        if (TapEnv.relatedLanguageIsFortran() && (instrOrExpr.opCode() == 152 || instrOrExpr.opCode() == 14) && !ILUtils.isNullOrNone(instrOrExpr.down(2)) && instrOrExpr.down(2).opCode() == 5) {
            Tree allocTree;
            WrapperTypeSpec resultType = null;
            if (!ILUtils.isNullOrNone(instrOrExpr.down(1))) {
                resultType = this.symbolTable.typeOf(instrOrExpr.down(1));
            }
            if (TypeSpec.isA(resultType, 6)) {
                assert (resultType != null);
                resultType = ((PointerTypeSpec)resultType.wrappedType).destinationType;
            }
            if (TypeSpec.isA(resultType, 2)) {
                assert (resultType != null);
                resultType = resultType.wrappedType.elementType();
            }
            int typeSize = 0;
            if (resultType != null) {
                typeSize = resultType.size();
            }
            if (ILUtils.isNullOrNone((allocTree = instrOrExpr.down(2)).down(1))) {
                Tree nbElems = ILUtils.build(103, typeSize);
                Tree[] dims = allocTree.down(2).children();
                for (int i = dims.length - 1; i >= 0; --i) {
                    Tree oneDim = dims[i];
                    if (oneDim.opCode() == 59) {
                        oneDim = ILUtils.buildSizeTree(oneDim.down(1), oneDim.down(2), null);
                    } else if (oneDim.opCode() == 12) {
                        oneDim = ILUtils.buildSizeTree(oneDim.down(1), oneDim.down(2), oneDim.down(3));
                    }
                    nbElems = ILUtils.buildSmartMulDiv(nbElems, 1, oneDim);
                }
                allocTree.setChild(nbElems, 1);
            }
            if (ILUtils.isNullOrNone(allocTree.down(3)) && resultType != null && resultType.wrappedType != null) {
                allocTree.setChild(resultType.wrappedType.generateTree(this.symbolTable, null, null, false, null), 3);
            }
        }
        return instrOrExpr;
    }

    private Tree addSaveModifier(Tree tree, SymbolTable symbolTable, Tree[] declarators, int i) {
        String name;
        VariableDecl varDecl;
        Tree typeTree = ILUtils.copy(tree);
        if (symbolTable.unit != null && symbolTable.unit.isFortran9x() && ILUtils.contains(typeTree, 96, "save") == null && !(varDecl = symbolTable.getVariableDecl(name = ILUtils.baseName(declarators[i].isAtom() ? declarators[i] : declarators[i].down(1)))).hasInstructionWithRootOperator(171, null)) {
            if (typeTree.opCode() == 129) {
                typeTree.down(1).addChild(ILUtils.build(96, "save"), typeTree.down(1).length() + 1);
            } else {
                typeTree = ILUtils.build(129, ILUtils.build(130, ILUtils.build(96, "save")), typeTree);
            }
        }
        return typeTree;
    }

    private void splitTreeDown(Tree tree, int rank, TapList<Instruction> topNewInstructionsReverse, TapList<Instruction> topNewDeclarations, TapList<Instruction> beforeEntry, TapList<Instruction> beforeCycle, SymbolTable symbolTable, Instruction oldInstruction, boolean nonLinear, boolean withMask, ToBool hasBeenSplit) {
        SymbolTable declSymbolTable = symbolTable;
        while (declSymbolTable.declarationsBlock == null || declSymbolTable.declarationsBlock.isALoop()) {
            declSymbolTable = declSymbolTable.basisSymbolTable();
        }
        Tree split = this.splitTree(tree.down(rank), topNewInstructionsReverse, topNewDeclarations, beforeEntry, beforeCycle, symbolTable, declSymbolTable, oldInstruction, true, false, nonLinear, withMask, hasBeenSplit);
        if (tree.down(rank) != split) {
            tree.setChild(split, rank);
        }
    }

    private Instruction makeSplitInstruction(Tree newTree, Instruction oldInstruction, boolean withMask) {
        Tree preCommentsForNewTree;
        Instruction newInstruction = new Instruction(newTree, oldInstruction.syntaxController, oldInstruction.block);
        int language = TapEnv.relatedLanguage();
        if (oldInstruction.preComments != null) {
            preCommentsForNewTree = ILUtils.build(37);
            oldInstruction.preComments = this.distributeDirectiveComments(newTree, oldInstruction.preComments, preCommentsForNewTree, language);
            Tree tree = newInstruction.preComments = preCommentsForNewTree.length() == 0 ? null : preCommentsForNewTree;
        }
        if (oldInstruction.preCommentsBlock != null) {
            preCommentsForNewTree = ILUtils.build(37);
            oldInstruction.preCommentsBlock = this.distributeDirectiveComments(newTree, oldInstruction.preCommentsBlock, preCommentsForNewTree, language);
            Tree tree = newInstruction.preCommentsBlock = preCommentsForNewTree.length() == 0 ? null : preCommentsForNewTree;
        }
        if (withMask) {
            newInstruction.setWhereMask(oldInstruction.whereMask());
        }
        newInstruction.setFromInclude(oldInstruction.fromInclude());
        return newInstruction;
    }

    private Tree distributeDirectiveComments(Tree newTree, Tree preComments, Tree preCommentsForNewTree, int language) {
        if (ILUtils.isNullOrNoneOrEmptyList(preComments)) {
            return preComments;
        }
        Tree[] comments = preComments.children();
        TapList<Tree> commentsStaying = null;
        for (int i = comments.length - 1; i >= 0; --i) {
            if (this.commentMustStay(comments[i], newTree, language)) {
                commentsStaying = new TapList<Tree>(comments[i], commentsStaying);
                continue;
            }
            preCommentsForNewTree.addChild(comments[i], 1);
        }
        if (preCommentsForNewTree.length() == 0) {
            return preComments;
        }
        return ILUtils.build(37, commentsStaying);
    }

    private boolean commentMustStay(Tree comment, Tree newTree, int language) {
        String directiveText = Directive.getDirectiveText(comment);
        if (directiveText == null) {
            return false;
        }
        while (directiveText.startsWith(" ")) {
            directiveText = directiveText.substring(1);
        }
        String directiveTextUC = directiveText.toUpperCase();
        if (directiveTextUC.startsWith("CHANNEL ")) {
            Tree callTree = newTree;
            if (callTree.opCode() == 14) {
                callTree = callTree.down(2);
            }
            return callTree.opCode() != 31 || !MPIcallInfo.isMessagePassingFunction(ILUtils.getCallFunctionNameString(callTree), language);
        }
        return false;
    }

    private boolean splitSum(Tree tree, SymbolTable symbolTable, ToBool maskInSum, int maxArray) {
        if (maskInSum != null && ILUtils.getArguments(tree).down(2) != null && symbolTable.typeOf(ILUtils.getArguments(tree).down(2)).isBooleanBase() && this.whereTestMustBeSplit(ILUtils.getArguments(tree).down(2))) {
            maskInSum.set(true);
            return true;
        }
        int nb = 0;
        TopDownTreeWalk i = new TopDownTreeWalk(ILUtils.getArguments(tree).down(1));
        while (!i.atEnd()) {
            VariableDecl varDecl;
            if (i.get().opCode() == 96 && (varDecl = symbolTable.getVariableDecl(i.get().stringValue())) != null && TypeSpec.isA(varDecl.type(), 2)) {
                ++nb;
            }
            i.advance();
        }
        return nb > maxArray;
    }

    private NewSymbolHolder findOrBuildHolder(WrapperTypeSpec type, String name, SymbolTable symbolTable, Instruction newDeclaration, TapList<Instruction> topNewDeclarations) {
        NewSymbolHolder symbolHolder;
        if (type == null) {
            type = new WrapperTypeSpec(null);
        }
        if ((symbolHolder = symbolTable.reuseNewSymbolHolder(name, type, null)) == null) {
            Tree typeTree;
            symbolHolder = new NewSymbolHolder(name);
            type = type.checkNoneDimensionsOfNewSH(name, name, symbolHolder.makeNewRef(symbolTable), symbolTable, symbolHolder);
            symbolHolder.setAsVariable(type, null);
            if (type.wrappedType == null) {
                TapEnv.toolWarning(-1, "(Building intermediate variable) null wrapped type for " + name);
                typeTree = ILUtils.build(96, "UnknownType");
            } else {
                typeTree = type.wrappedType.generateTree(null, null, null, true, null);
            }
            newDeclaration.setTree(ILUtils.build(199, ILUtils.build(130), typeTree, ILUtils.build(54, symbolHolder.makeNewRef(symbolTable))));
            symbolHolder.setInstruction(newDeclaration);
            if (TapEnv.doOpenMP() && this.parallelControls != null) {
                symbolHolder.preparePrivateClause(this, this.unit().privateSymbolTable(), true, false);
                symbolHolder.preparePrivateClause(this, this.unit().privateSymbolTable(), false, false);
            }
        } else {
            VariableDecl shVarDecl = symbolHolder.newVariableDecl();
            if (!(shVarDecl.isVarDeclared(this.unit().publicSymbolTable().declarationsBlock.instructions) || shVarDecl.isVarDeclared(this.symbolTable.declarationsBlock.instructions) || shVarDecl.isVarDeclared(this.instructions) || shVarDecl.isVarDeclared(topNewDeclarations.tail))) {
                newDeclaration.setTree(symbolHolder.instruction((SymbolTable)symbolTable).tree);
            }
        }
        return symbolHolder;
    }

    protected String citeFlowShort() {
        StringBuilder result = new StringBuilder();
        TapList<FGArrow> blocks = this.backFlow;
        while (blocks != null) {
            result.append(':').append(((FGArrow)blocks.head).origin.rank);
            blocks = blocks.tail;
        }
        result.append(">_>");
        blocks = this.flow;
        while (blocks != null) {
            result.append(((FGArrow)blocks.head).destination.rank).append(':');
            blocks = blocks.tail;
        }
        return result.toString();
    }

    public boolean hasStaticIterationSpace() {
        return this.enclosing == null || ((LoopBlock)this.enclosing).staticIterationLength() != null && this.enclosing.hasStaticIterationSpace();
    }

    public TapList<Integer> getStaticIterationSpace() {
        if (this.enclosing == null) {
            return null;
        }
        return new TapList<Integer>(((LoopBlock)this.enclosing).staticIterationLength(), this.enclosing.getStaticIterationSpace());
    }

    public TapList<Tree> getStaticIterationIndices() {
        if (this.enclosing == null) {
            return null;
        }
        return new TapList<Tree>(((LoopBlock)this.enclosing).staticNormalizedIndex(), this.enclosing.getStaticIterationIndices());
    }

    protected int getPosition() {
        int pos = -1;
        TapList<Instruction> blockInstructions = this.instructions;
        while (pos == -1 && blockInstructions != null) {
            Instruction currentInstruction = (Instruction)blockInstructions.head;
            if (currentInstruction != null) {
                pos = currentInstruction.getPosition();
            }
            blockInstructions = blockInstructions.tail;
        }
        return pos;
    }

    private boolean funcArgMustBeSplit(Tree arg, Tree callTree, boolean functionIsActive, Unit calledUnit, boolean nonLinear, SymbolTable symbolTable, ToBool maskInSum) {
        boolean shouldSplitInAdjoint;
        if (!functionIsActive || TapEnv.modeIsNoDiff()) {
            return false;
        }
        if (arg.opCode() == 31 && "%val".equals(ILUtils.getCalledNameString(arg))) {
            return false;
        }
        String functionName = ILUtils.getCallFunctionNameString(callTree);
        boolean functionIsIntrinsic = calledUnit != null && calledUnit.isIntrinsic();
        boolean hasPredefinedDiff = calledUnit != null && calledUnit.diffInfo != null && (!functionName.equals("sum") || !TapEnv.relatedUnit().isFortran9x() || !this.splitSum(callTree, symbolTable, maskInSum, 5));
        int timesUsed = (nonLinear ? 1 : 0) + (this.argIsActive(arg, symbolTable) ? 1 : 0);
        if (TapEnv.get().multiDirDiffMode) {
            timesUsed = 3 * timesUsed;
        }
        if (this.isSqrt(callTree) || this.isArcSinOrCos(callTree)) {
            ++timesUsed;
        }
        int argCost = Block.isDuplicable(arg, symbolTable) ? Block.duplicableCost(arg, symbolTable) : 9999;
        boolean duplicationIsExpensive = ++timesUsed * argCost > timesUsed + argCost + 7;
        boolean argIsSumMask = false;
        if (functionName.equals("sum") && TapEnv.relatedUnit().isFortran9x()) {
            Tree argNumber2 = ILUtils.getArguments(callTree).down(2);
            if (argNumber2 != null && argNumber2.opCode() == 134) {
                argNumber2 = argNumber2.down(2);
            }
            argIsSumMask = arg == argNumber2;
        }
        boolean shouldSplitInTangent = duplicationIsExpensive;
        boolean bl = shouldSplitInAdjoint = !ILUtils.isAVarRefOrConstant(arg) && !hasPredefinedDiff && (duplicationIsExpensive || argIsSumMask);
        return TapEnv.associationByAddress() && !ILUtils.isAVarRefOrConstant(arg) || (!functionIsIntrinsic ? (TapEnv.get().multiDirDiffMode || TapEnv.modeIsAdjoint() || TapEnv.debugAdMode() == -1) && !ILUtils.isAVarRefOrConstant(arg) && !ILUtils.isAStringManipulation(arg) : (TapEnv.debugAdMode() == -1 ? shouldSplitInTangent || shouldSplitInAdjoint : (TapEnv.modeIsTangent() ? shouldSplitInTangent : shouldSplitInAdjoint))) || calledUnit != null && !functionIsIntrinsic && calledUnit.language() != TapEnv.relatedLanguage() && !ILUtils.isAVarRefOrConstant(arg);
    }

    private boolean funcResultMustBeSplit(Tree callTree, boolean inExpr, boolean assigned, boolean functionIsActive, Unit calledUnit, boolean nonLinear, SymbolTable symbolTable) {
        boolean functionIsIntrinsicWithSeparableDiff;
        String functionName = ILUtils.getCallFunctionNameString(callTree);
        boolean bl = functionIsIntrinsicWithSeparableDiff = calledUnit != null && calledUnit.isIntrinsic() && calledUnit.diffInfo != null;
        return !TapEnv.modeIsNoDiff() && !assigned && inExpr && !functionName.equals("allocated") && !functionName.equals("associated") && !functionName.equals("shape") && !functionName.equals("size") && !functionName.equals("trim") && !functionName.equals("lbound") && !functionName.equals("ubound") && (nonLinear && !Block.isDuplicable(callTree, symbolTable) || (TapEnv.debugAdMode() == -1 ? functionIsActive && !functionIsIntrinsicWithSeparableDiff || this.isSqrt(callTree) || this.isArcSinOrCos(callTree) || functionIsActive && (!functionIsIntrinsicWithSeparableDiff || functionName.equals("sum") && TapEnv.relatedUnit().isFortran9x() && this.splitSum(callTree, symbolTable, null, 2)) : (TapEnv.modeIsTangent() ? functionIsActive && !functionIsIntrinsicWithSeparableDiff || this.isSqrt(callTree) || this.isArcSinOrCos(callTree) : functionIsActive && (!functionIsIntrinsicWithSeparableDiff || functionName.equals("sum") && TapEnv.relatedUnit().isFortran9x() && this.splitSum(callTree, symbolTable, null, 2)))));
    }

    private boolean isSqrt(Tree callTree) {
        String functionName = ILUtils.getCallFunctionNameString(callTree);
        assert (functionName != null);
        return functionName.equals("sqrt") || functionName.equals("dsqrt") || functionName.equals("csqrt");
    }

    private boolean isArcSinOrCos(Tree callTree) {
        String functionName = ILUtils.getCallFunctionNameString(callTree);
        return functionName.equals("asin") || functionName.equals("dasin") || functionName.equals("acos") || functionName.equals("dacos");
    }

    private boolean argIsActive(Tree exp, SymbolTable symbolTable) {
        WrapperTypeSpec expType = symbolTable.typeOf(exp);
        return expType == null || TypeSpec.isDifferentiableType(expType.wrappedType);
    }

    public void sortDeclarationsAndOperations() {
        TapList<Object> tlDecls;
        TapList<Object> tlOps = new TapList<Object>(null, null);
        TapList<Object> hdDeclsOps = tlDecls = new TapList<Object>(null, tlOps);
        TapList<Instruction> inInstructions = this.instructions;
        while (inInstructions != null) {
            Instruction instr = (Instruction)inInstructions.head;
            Tree tree = instr.tree;
            if (tree != null && !ILUtils.isAUnitPlaceHolder(tree) && (ILUtils.isADeclaration(tree) || tree.opCode() == 51 || tree.opCode() == 138) && (tree.opCode() != 101 && tree.opCode() != 138 || tlDecls.tail == tlOps)) {
                tlDecls = tlDecls.placdl(instr);
            } else {
                tlOps = tlOps.placdl(instr);
            }
            inInstructions = inInstructions.tail;
        }
        tlDecls.tail = tlDecls.tail.tail;
        this.instructions = hdDeclsOps.tail;
    }

    public boolean isVarDeclaredInBlock(SymbolDecl symbolDecl) {
        return symbolDecl.isVarDeclared(this.instructions);
    }

    public void checkUnusedDeclaration(Unit unit) {
        TapList<Instruction> decls = this.instructions;
        TapList<Instruction> removedDecls = null;
        while (decls != null) {
            Instruction instr = (Instruction)decls.head;
            if (!instr.isDifferentiated && ILUtils.isAVariableOnlyDeclaration(instr.tree)) {
                TapList<SymbolDecl> symbolDecls = instr.declaredSymbolDecls(unit.publicSymbolTable(), unit.privateSymbolTable());
                if (!unit.isCPlusPlus() && symbolDecls == null && (symbolDecls = instr.declaredSymbolDecls(unit.callGraph().globalRootSymbolTable(), null)) == null) {
                    removedDecls = new TapList<Instruction>(instr, removedDecls);
                }
            }
            decls = decls.tail;
        }
        this.instructions = TapList.deleteAll(removedDecls, this.instructions);
    }

    protected void typeCheck(SymbolTable definitionSymbolTable) {
        TapList<Instruction> inInstructions = this.instructions;
        ToBool isBeginning = new ToBool(true);
        while (inInstructions != null) {
            Instruction instr = (Instruction)inInstructions.head;
            if (!instr.isInStdCInclude()) {
                Tree instrOrExpr = ((Instruction)inInstructions.head).tree;
                TapEnv.setTraceIndent(0);
                definitionSymbolTable.typeCheck(instrOrExpr, false, false, false, (Instruction)inInstructions.head, isBeginning, null);
            }
            inInstructions = inInstructions.tail;
        }
    }

    public boolean isOutsideFlow() {
        boolean containsUnits = false;
        TapList<Instruction> inInstructions = this.instructions;
        while (inInstructions != null && !containsUnits) {
            if (((Instruction)inInstructions.head).isUnitDefinitionStub() != null) {
                containsUnits = true;
            }
            inInstructions = inInstructions.tail;
        }
        return containsUnits;
    }

    public TapList<Tree> listOfStatements() {
        TapList<Object> hdResult;
        TapList<Instruction> inInstructions = this.instructions;
        TapList<Object> tlResult = hdResult = new TapList<Object>(null, null);
        while (inInstructions != null) {
            if (inInstructions.head != null && ((Instruction)inInstructions.head).tree != null) {
                tlResult = tlResult.placdl(((Instruction)inInstructions.head).tree);
            }
            inInstructions = inInstructions.tail;
        }
        return hdResult.tail;
    }

    public boolean seesAsShared(String varName) {
        if (this.parallelControls == null) {
            return false;
        }
        boolean seenAsShared = true;
        TapList<Instruction> inParallelControls = this.parallelControls;
        while (inParallelControls != null && seenAsShared) {
            Tree clauses;
            if (ILUtils.isParallelController(((Instruction)inParallelControls.head).tree) && !ILUtils.isNullOrNoneOrEmptyList(clauses = ((Instruction)inParallelControls.head).tree.down(2))) {
                Tree[] allClauses;
                block5: for (Tree allClause : allClauses = clauses.children()) {
                    if (ILUtils.isNullOrNoneOrEmptyList(allClause)) continue;
                    switch (allClause.opCode()) {
                        case 77: 
                        case 114: 
                        case 157: {
                            if (!ILUtils.contains(allClause.down(1), varName, false)) continue block5;
                            seenAsShared = false;
                            continue block5;
                        }
                        case 162: {
                            if (!ILUtils.contains(allClause.down(2), varName, false)) continue block5;
                            seenAsShared = false;
                            continue block5;
                        }
                    }
                }
            }
            inParallelControls = inParallelControls.tail;
        }
        return seenAsShared;
    }

    public void dump(int indent) throws IOException {
        FGArrow arrow;
        if (this instanceof BasicBlock) {
            TapEnv.indentPrint(indent, "BasicBlock number " + this.rank + ':');
        } else if (this instanceof HeaderBlock) {
            TapEnv.indentPrint(indent, "HeaderBlock number " + this.rank + ':');
        } else if (this instanceof EntryBlock) {
            TapEnv.indentPrint(indent, "EntryBlock:");
        } else if (this instanceof InitConstructorBlock) {
            TapEnv.indentPrint(indent, "InitConstructorBlock:");
        } else if (this instanceof ExitBlock) {
            TapEnv.indentPrint(indent, "ExitBlock:");
        } else if (this instanceof LoopBlock) {
            TapEnv.indentPrint(indent, "LoopBlock:");
        } else {
            TapEnv.indentPrint(indent, "untyped Block number " + this.rank + ':');
        }
        if (this.origLabel() != null) {
            TapEnv.print("  (orig label " + this.origLabel() + ')');
        }
        if (this instanceof HeaderBlock && ((HeaderBlock)this).origCycleLabel() != null) {
            TapEnv.print("  (orig cycle label " + ((HeaderBlock)this).origCycleLabel() + ')');
        }
        TapEnv.println();
        TapEnv.indentPrintln(indent, "=====================");
        if (this.testZone != -1) {
            TapEnv.indentPrintln(indent + 2, "Zone of Control: " + this.testZone);
        }
        if (this.controllers != null) {
            TapEnv.indentPrint(indent + 4, "Controlled by: ");
            TapList<Block> controllersList = this.controllers;
            while (controllersList != null) {
                if (controllersList.head != null) {
                    ((Block)controllersList.head).cite();
                }
                controllersList = controllersList.tail;
            }
            TapEnv.println();
        }
        if (this.unit() != null) {
            TapEnv.indentPrintln(indent + 4, "Successor: " + this.unit().blocksFromBitVector(this.successor));
            TapEnv.indentPrintln(indent + 4, "Predecessor: " + this.unit().blocksFromBitVector(this.predecessor));
            TapEnv.indentPrintln(indent + 4, "Dominator: " + this.unit().blocksFromBitVector(this.dominator));
            TapEnv.indentPrintln(indent + 4, "Immediate Dominator: " + this.immediateDominator);
            TapEnv.indentPrintln(indent + 4, "Post dominator: " + this.unit().blocksFromBitVector(this.postDominator));
            TapEnv.indentPrintln(indent + 4, "Immediate PostDominator: " + this.immediatePostDominator);
            TapEnv.indentPrintln(indent + 4, "Reachable(static inference): " + this.reachable);
        }
        TapEnv.indentPrint(indent + 2, "SymbolTable: ");
        if (this.symbolTable == null) {
            TapEnv.println("NULL");
        } else {
            TapEnv.println(this.symbolTable.shortName() + " " + this.symbolTable.addressChain());
        }
        if (this.parallelControls != null) {
            TapEnv.indentPrintln(indent + 2, "Parallel Controls:" + this.parallelControls);
        }
        TapEnv.indentPrintln(indent + 2, "Incoming flow FGArrow's:");
        TapList<FGArrow> objects = this.backFlow;
        while (objects != null) {
            TapEnv.indent(indent + 4);
            arrow = (FGArrow)objects.head;
            if (arrow == null) {
                TapEnv.println("null Arrow!");
            } else {
                if (arrow.inACycle) {
                    TapEnv.print("in cycle arrow ");
                }
                if (arrow.origin == null) {
                    TapEnv.print("null origin!");
                } else {
                    TapEnv.print(arrow.origin.toString());
                }
                TapEnv.print(" ");
                arrow.dumpTestCaseCarry();
            }
            TapEnv.println();
            objects = objects.tail;
        }
        this.dumpInstructions(indent + 2);
        TapEnv.indentPrintln(indent + 2, "Exiting flow FGArrow's:");
        objects = this.flow;
        while (objects != null) {
            TapEnv.indent(indent + 4);
            arrow = (FGArrow)objects.head;
            if (arrow == null) {
                TapEnv.println("null Arrow!");
            } else {
                if (arrow.inACycle) {
                    TapEnv.print("in cycle arrow ");
                }
                arrow.dumpTestCaseCarry();
                TapEnv.print(" ");
                if (arrow.destination == null) {
                    TapEnv.print("null destination!");
                } else {
                    TapEnv.print(arrow.destination.toString());
                }
            }
            TapEnv.println();
            objects = objects.tail;
        }
    }

    protected final void dumpInstructions(int indent) throws IOException {
        if (this.instructions == null) {
            TapEnv.indentPrintln(indent, "Instructions: empty");
        } else {
            TapEnv.indentPrintln(indent, "Instructions:");
            TapList<Instruction> instrs = this.instructions;
            while (instrs != null) {
                TapEnv.indent(indent + 2);
                ((Instruction)instrs.head).dump();
                TapEnv.println();
                instrs = instrs.tail;
            }
        }
    }

    public void cite() throws IOException {
        TapEnv.print("?B(" + this.rank + ')');
    }

    public String toString() {
        return "B" + (this.symbolicRk != null ? "\"" + this.symbolicRk + "\"" : "#" + this.rank);
    }
}

