/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.representation;

import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.utils.TapPair;
import fr.inria.tapenade.utils.TopDownTreeWalk;
import fr.inria.tapenade.utils.Tree;

public final class AtomFuncDerivative {
    public Tree origPattern;
    public TapList<TapPair<Tree, Tree>> origKeyTreeList;
    public Tree factor;
    public TapList<TapPair<Tree, Tree>> factorKeyTreeList;
    public TapPair<Tree, Tree>[] paramVars;
    public Tree[] derivs;
    public TapList<TapPair<Tree, Tree>>[] derivsKeyTreeList;

    public AtomFuncDerivative(Tree origPattern, TapList<TapPair<Tree, Tree>> origKeyTreeList, Tree factor, TapList<TapPair<Tree, Tree>> factorKeyTreeList, TapPair<Tree, Tree>[] paramVars, Tree[] derivs, TapList<TapPair<Tree, Tree>>[] derivsKeyTreeList) {
        this.origPattern = origPattern;
        this.origKeyTreeList = origKeyTreeList;
        this.factor = factor;
        this.factorKeyTreeList = factorKeyTreeList;
        this.paramVars = paramVars;
        this.derivs = derivs;
        this.derivsKeyTreeList = derivsKeyTreeList;
    }

    private static Tree copyReplacingKeyTrees(Tree tree, TapList<TapPair<Tree, Tree>> keyTreeList, TapList<TapPair<Tree, Tree>> modelKeyTreeList) {
        TapList<TapPair<Tree, Tree>> inKeyTreeList = keyTreeList;
        Tree found = null;
        while (inKeyTreeList != null) {
            TapPair keyTree = (TapPair)inKeyTreeList.head;
            TapPair<Tree, Tree> foundPair = TapList.assqTree((Tree)keyTree.first, modelKeyTreeList);
            if (foundPair != null) {
                found = (Tree)foundPair.second;
            }
            keyTree.second = found == null ? ILUtils.build(138) : ILUtils.copy(found);
            inKeyTreeList = inKeyTreeList.tail;
        }
        return (Tree)ILUtils.copyWatchingSubtrees((Tree)tree, keyTreeList).first;
    }

    public static void incorporateNewAtomFunc(Tree defTree, Unit functionUnit) {
        if (functionUnit.isFortran()) {
            Tree funcNameTree = ILUtils.getCalledName(defTree.down(1));
            funcNameTree.setValue(funcNameTree.stringValue().toLowerCase());
        }
        Tree origPattern = defTree.down(1);
        Tree factor = defTree.down(2);
        TapList<TapPair<Tree, Tree>> factorVars = null;
        Tree[] derivatives = defTree.down(3).children();
        if (factor != null && factor.opCode() == 138) {
            factor = null;
        }
        if (factor != null) {
            factorVars = AtomFuncDerivative.getMetavarsFromPattern(factor, null);
        }
        TapList<TapPair<Tree, Tree>> origKeyTreeList = AtomFuncDerivative.getMetavarsFromPattern(origPattern, null);
        origKeyTreeList = new TapList<TapPair<Tree, Tree>>(new TapPair<Tree, Object>(ILUtils.build(123, "TOP_EXPRESSION"), null), origKeyTreeList);
        int nbVars = derivatives.length;
        TapPair[] paramVars = new TapPair[nbVars];
        Tree[] derivs = new Tree[nbVars];
        TapList[] derivsVars = new TapList[nbVars];
        for (int i = 0; i < nbVars; ++i) {
            Tree varTree = derivatives[i].down(1);
            paramVars[i] = TapList.assqTree(varTree, origKeyTreeList);
            derivs[i] = derivatives[i].down(3);
            derivsVars[i] = AtomFuncDerivative.getMetavarsFromPattern(derivs[i], null);
        }
        functionUnit.diffInfo = new AtomFuncDerivative(origPattern, origKeyTreeList, factor, factorVars, paramVars, derivs, derivsVars);
    }

    public static TapList<TapPair<Tree, Tree>> getMetavarsFromPattern(Tree tree, TapList<TapPair<Tree, Tree>> keyTreeList) {
        if (tree.opCode() == 123) {
            return new TapList<TapPair<Tree, Tree>>(new TapPair<Tree, Object>(tree, null), keyTreeList);
        }
        Tree[] subTrees = tree.children();
        if (subTrees != null) {
            for (int i = subTrees.length - 1; i >= 0; --i) {
                keyTreeList = AtomFuncDerivative.getMetavarsFromPattern(subTrees[i], keyTreeList);
            }
        }
        return keyTreeList;
    }

    public void matches(Tree tree) {
        ((TapPair)this.origKeyTreeList.head).second = tree;
        ILUtils.matches(tree, this.origPattern, this.origKeyTreeList);
    }

    public Tree[] getParamExprs() {
        Tree[] paramExprs = new Tree[this.paramVars.length];
        for (int i = this.paramVars.length - 1; i >= 0; --i) {
            paramExprs[i] = (Tree)this.paramVars[i].second;
        }
        return paramExprs;
    }

    public Tree buildPartialDerivative(int i) {
        Tree result = this.buildPartialWithoutFactor(i);
        if (this.factor != null) {
            result = ILUtils.buildSmartMulDiv(this.buildDerivativeFactor(), 1, result);
        }
        return result;
    }

    private Tree buildDerivativeFactor() {
        return AtomFuncDerivative.copyReplacingKeyTrees(this.factor, this.factorKeyTreeList, this.origKeyTreeList);
    }

    private Tree buildPartialWithoutFactor(int i) {
        return AtomFuncDerivative.copyReplacingKeyTrees(this.derivs[i], this.derivsKeyTreeList[i], this.origKeyTreeList);
    }

    public TapList<Tree> getDiffCallNames() {
        TapList<Tree> result = null;
        String functionName = ILUtils.getCalledNameString(this.origPattern);
        Tree[] treeArray = this.derivs;
        int n = treeArray.length;
        for (int i = 0; i < n; ++i) {
            Tree deriv;
            Tree tree = deriv = treeArray[i];
            TopDownTreeWalk i2 = new TopDownTreeWalk(tree);
            while (!i2.atEnd()) {
                Tree currentTree = i2.get();
                if (currentTree.opCode() == 31 && (currentTree = ILUtils.getCalledName(currentTree)).opCode() == 96 && !currentTree.stringValue().equals(functionName)) {
                    result = new TapList<Tree>(ILUtils.copy(currentTree), result);
                }
                i2.advance();
            }
        }
        return result;
    }

    public String toString() {
        String strDerivs = "";
        for (int i = this.derivs.length - 1; i >= 0; --i) {
            strDerivs = ILUtils.toString(this.derivs[i]) + strDerivs;
            if (i == 0) continue;
            strDerivs = " ; " + strDerivs;
        }
        String strParamVars = "";
        for (int i = this.paramVars.length - 1; i >= 0; --i) {
            strParamVars = this.paramVars[i] + strParamVars;
            if (i == 0) continue;
            strParamVars = " ; " + strParamVars;
        }
        return "Jac of " + ILUtils.toString(this.origPattern) + "->" + this.factor + " factor [" + strDerivs + "] [" + strParamVars + ']';
    }
}

