/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.representation;

import fr.inria.tapenade.representation.ArrayDim;
import fr.inria.tapenade.representation.ArrayTypeSpec;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.TypeSpec;
import fr.inria.tapenade.representation.VariableDecl;
import fr.inria.tapenade.representation.WrapperTypeSpec;
import fr.inria.tapenade.representation.ZoneInfoAccessElements;
import fr.inria.tapenade.utils.TapPair;
import fr.inria.tapenade.utils.Tree;

public final class AlignmentBoundary {
    public int offset;
    public boolean infiniteOffset;
    public TapList<VariableDecl> endVars;
    public Tree accessTree;
    protected WrapperTypeSpec nextType = null;
    public WrapperTypeSpec type;
    protected TapList zones;
    public TapList<ZoneInfoAccessElements> startVars;
    private VariableDecl commonVariableDecl;
    protected boolean active = false;

    protected AlignmentBoundary(int offset) {
        this.offset = offset;
    }

    public AlignmentBoundary(int offset, boolean infiniteOffset) {
        this.offset = offset;
        this.infiniteOffset = infiniteOffset;
    }

    public boolean isEqual(int offset2, boolean infiniteOffset2) {
        return infiniteOffset2 ? this.infiniteOffset : !this.infiniteOffset && this.offset == offset2;
    }

    public boolean isEqual(AlignmentBoundary otherBoundary) {
        return otherBoundary.infiniteOffset ? this.infiniteOffset : !this.infiniteOffset && this.offset == otherBoundary.offset;
    }

    public boolean isBefore(int offset2, boolean infiniteOffset2) {
        return !this.infiniteOffset && (infiniteOffset2 || this.offset < offset2);
    }

    public boolean isBefore(AlignmentBoundary otherBoundary) {
        return !this.infiniteOffset && (otherBoundary.infiniteOffset || this.offset < otherBoundary.offset);
    }

    protected static boolean lt(int offset1, boolean infiniteOffset1, int offset2, boolean infiniteOffset2) {
        return !infiniteOffset1 && (infiniteOffset2 || offset1 < offset2);
    }

    protected static boolean le(int offset1, boolean infiniteOffset1, int offset2, boolean infiniteOffset2) {
        if (infiniteOffset1) {
            return infiniteOffset2;
        }
        return infiniteOffset2 || offset1 <= offset2;
    }

    public TapList<VariableDecl> startVarDecls() {
        TapList<VariableDecl> result = null;
        TapList<ZoneInfoAccessElements> stV = this.startVars;
        while (stV != null) {
            result = TapList.addLast(result, (VariableDecl)((ZoneInfoAccessElements)stV.head).symbolDecl);
            stV = stV.tail;
        }
        return result;
    }

    public void setCommonVariableDecl(VariableDecl variableDecl) {
        this.commonVariableDecl = variableDecl;
    }

    public VariableDecl commonVariableDecl() {
        return this.commonVariableDecl;
    }

    public void addStartVar(VariableDecl variableDecl, SymbolTable fromSymbolTable, Tree accessTree) {
        ZoneInfoAccessElements newAccess = new ZoneInfoAccessElements(variableDecl, accessTree, fromSymbolTable);
        this.startVars = new TapList<ZoneInfoAccessElements>(newAccess, this.startVars);
    }

    public void addEndVar(VariableDecl variableDecl, SymbolTable fromSymbolTable) {
        this.endVars = new TapList<VariableDecl>(variableDecl, this.endVars);
    }

    public void removeStartVar(VariableDecl variableDecl) {
        TapList<ZoneInfoAccessElements> toStartVars;
        TapList<ZoneInfoAccessElements> inStartVars = toStartVars = new TapList<ZoneInfoAccessElements>(null, this.startVars);
        boolean found = false;
        while (!found && inStartVars.tail != null) {
            if (((ZoneInfoAccessElements)inStartVars.tail.head).symbolDecl == variableDecl) {
                found = true;
                inStartVars.tail = inStartVars.tail.tail;
                continue;
            }
            inStartVars = inStartVars.tail;
        }
        this.startVars = toStartVars.tail;
    }

    public void removeEndVar(VariableDecl variableDecl) {
        this.endVars = TapList.delete(variableDecl, this.endVars);
    }

    public WrapperTypeSpec buildNextType(int nbBytes) {
        if (this.type == null) {
            return null;
        }
        int totalSize = this.type.size();
        if (nbBytes == -1 || totalSize == nbBytes) {
            this.nextType = this.type;
        } else {
            TapPair<WrapperTypeSpec, ArrayDim[]> baseTypeAndDims = TypeSpec.peelArrayDimsAroundComposite(this.type);
            int baseSize = ((WrapperTypeSpec)baseTypeAndDims.first).size();
            ArrayDim[] dimensions = new ArrayDim[]{new ArrayDim(null, 1, nbBytes / baseSize, null, -1, 0, 0)};
            this.nextType = new WrapperTypeSpec(new ArrayTypeSpec((WrapperTypeSpec)baseTypeAndDims.first, dimensions));
        }
        return this.nextType;
    }

    public String toString() {
        return "(" + (this.infiniteOffset ? "+inf" : Integer.valueOf(this.offset)) + "-" + this.endVars + "+" + this.startVars + (this.active ? " active " : " ") + this.type + ")";
    }
}

