/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.prettyprint;

import fr.inria.tapenade.prettyprint.Printer;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import java.io.IOException;
import java.util.Objects;

public final class HtmlPrinter
extends Printer {
    private static final int LINES_OFFSET = 3;
    private String level0kind;
    private String level1kind;
    private String targetName;
    private String oldTargetName;
    private String targetZone;
    private String oldTargetZone;
    private final String cssDir;
    private TapList<String> nestedAnchorRefs;
    private boolean topAnchorRefActive;
    private StringBuilder[] linesBuilder;
    private int firstLineIndex;
    private int curLineIndex;

    public HtmlPrinter(String fileName, String targetName, String targetZone, String cssDir) throws IOException {
        super(fileName);
        this.targetName = targetName;
        this.targetZone = targetZone;
        this.cssDir = cssDir;
    }

    @Override
    public void initFile(int language) {
        super.initFile(language);
        String cssFile = "";
        switch (language) {
            case 1: 
            case 2: 
            case 3: {
                cssFile = "fortranStyle.css";
                break;
            }
            case 4: 
            case 5: {
                cssFile = "CStyle.css";
                break;
            }
        }
        this.level0kind = "plain";
        this.level1kind = null;
        try {
            this.toFile().write("<!DOCTYPE html>");
            this.toFile().write(System.lineSeparator());
            this.toFile().write("<title>Generated by TAPENADE</title>");
            this.toFile().write(System.lineSeparator());
            this.toFile().write("<link rel=\"stylesheet\" href=\"https://cdn.jsdelivr.net/npm/bootstrap@4.5.3/dist/css/bootstrap.min.css\" integrity=\"sha384-TX8t27EcRE3e/ihU7zmQxVncDAy5uIKz4rEkgIXeMed4M0jlfIDPvg6uqKI2xXr2\" crossorigin=\"anonymous\">");
            this.toFile().write(System.lineSeparator());
            this.toFile().write("<link type=\"text/CSS\" rel=\"stylesheet\" href=\"" + this.cssDir + "tapenade.css\">");
            this.toFile().write(System.lineSeparator());
            this.toFile().write("<link type=\"text/CSS\" rel=\"stylesheet\" href=\"" + this.cssDir + cssFile + "\">");
            this.toFile().write(System.lineSeparator());
            this.toFile().write("<body>");
            this.toFile().write(System.lineSeparator());
            this.toFile().write("<pre>");
        }
        catch (IOException e) {
            TapEnv.systemError("(Decompiler) I-O error " + e.getMessage() + " while initializing output file " + this.toFile());
        }
        this.initLinesBuilder();
        this.initAnchorRefs();
    }

    @Override
    public void closeFile() {
        try {
            this.deactivateKind();
            this.deactivateTopAnchorRef();
            this.flushAllLines();
            this.initAnchorRefs();
            this.toFile().write("</pre>");
            this.toFile().write(System.lineSeparator());
            this.toFile().write("</body>");
            this.toFile().write(System.lineSeparator());
        }
        catch (IOException e) {
            TapEnv.systemError("(Decompiler) I-O error " + e.getMessage() + " while closing output file " + this.toFile());
        }
        super.closeFile();
    }

    @Override
    public void space(int nbSpaces) {
        for (int i = nbSpaces; i > 0; --i) {
            this.writeInBuilder(" ");
        }
    }

    @Override
    public void newLine() throws IOException {
        this.deactivateKind();
        this.deactivateTopAnchorRef();
        this.writeInBuilder(System.lineSeparator());
        this.circulateOneLine();
    }

    @Override
    public void printText(String text, String kind) {
        if (!Objects.equals(this.level1kind, kind)) {
            this.deactivateKind();
        }
        this.activateTopAnchorRef();
        this.activateKind(kind);
        text = this.quoteSpecialCharInString(text, "<", "&lt;");
        text = this.quoteSpecialCharInString(text, ">", "&gt;");
        this.writeInBuilder(text);
    }

    private String quoteSpecialCharInString(String text, String origChar, String quotedChar) {
        int index = text.indexOf(origChar);
        if (index >= 0) {
            String stringBefore = text.substring(0, index);
            String stringAfter = text.substring(index + 1);
            text = stringBefore + quotedChar + stringAfter;
        }
        return text;
    }

    @Override
    public void setTargetNameAndZone(String name, String zone) {
        this.oldTargetName = this.targetName;
        this.targetName = name;
        this.oldTargetZone = this.targetZone;
        this.targetZone = zone;
    }

    @Override
    public void resetTargetNameAndZone() {
        this.targetName = this.oldTargetName;
        this.oldTargetName = "";
        this.targetZone = this.oldTargetZone;
        this.oldTargetZone = "";
    }

    @Override
    public boolean hasAnchors() {
        return true;
    }

    @Override
    public void defineAnchor(String ref) {
        this.writeInOldLine("<a name=\"" + ref + "\"></a>");
    }

    @Override
    public void startAnchorRef(String ref) {
        this.deactivateKind();
        this.deactivateTopAnchorRef();
        this.nestedAnchorRefs = new TapList<String>(ref, this.nestedAnchorRefs);
    }

    @Override
    public void endAnchorRef() {
        this.deactivateKind();
        this.deactivateTopAnchorRef();
        this.nestedAnchorRefs = this.nestedAnchorRefs.tail;
    }

    @Override
    public void messageRef(TapList<String> msgTty, boolean showMsg, int language) throws IOException {
        this.writeInBuilder("<img src=\"" + this.cssDir + "danger.gif\" align=middle border=\"0\" alt=\"\" />");
        if (showMsg) {
            while (msgTty != null) {
                this.printText(TapEnv.commentStart(language) + " TAPENADE: " + (String)msgTty.head, "comment");
                if (msgTty.tail != null) {
                    this.newLine();
                }
                msgTty = msgTty.tail;
            }
        }
    }

    private void initAnchorRefs() {
        this.nestedAnchorRefs = null;
        this.topAnchorRefActive = false;
    }

    private void activateTopAnchorRef() {
        if (this.targetName != null && this.nestedAnchorRefs != null && !this.topAnchorRefActive) {
            this.writeInBuilder("<a href=\"" + this.targetName + "#" + (String)this.nestedAnchorRefs.head + "\" target=\"" + this.targetZone + "\">");
            this.topAnchorRefActive = true;
        }
    }

    private void deactivateTopAnchorRef() {
        if (this.nestedAnchorRefs != null && this.topAnchorRefActive) {
            this.writeInBuilder("</a>");
            this.topAnchorRefActive = false;
        }
    }

    private void activateKind(String kind) {
        if (this.level1kind == null && !Objects.equals(this.level0kind, kind)) {
            this.level1kind = kind;
            this.writeInBuilder("<code class=\"" + this.level1kind + "\">");
        }
    }

    private void deactivateKind() {
        if (this.level1kind != null) {
            this.writeInBuilder("</code>");
            this.level1kind = null;
        }
    }

    private void initLinesBuilder() {
        this.linesBuilder = new StringBuilder[3];
        for (int i = 2; i >= 0; --i) {
            this.linesBuilder[i] = null;
        }
        this.linesBuilder[0] = new StringBuilder(150);
        this.firstLineIndex = 0;
        this.curLineIndex = 0;
    }

    private void writeInBuilder(String str) {
        this.linesBuilder[this.curLineIndex].append(str);
    }

    private void writeInOldLine(String str) {
        this.linesBuilder[this.firstLineIndex].insert(0, str);
    }

    private void circulateOneLine() throws IOException {
        ++this.curLineIndex;
        if (this.curLineIndex == 3) {
            this.curLineIndex = 0;
        }
        if (this.curLineIndex == this.firstLineIndex) {
            this.flushLine(this.firstLineIndex);
        }
        this.linesBuilder[this.curLineIndex] = new StringBuilder(150);
    }

    private void flushAllLines() throws IOException {
        while (this.firstLineIndex != this.curLineIndex) {
            this.flushLine(this.firstLineIndex);
        }
        this.flushLine(this.firstLineIndex);
    }

    private void flushLine(int index) throws IOException {
        this.toFile().write(this.linesBuilder[index].toString());
        ++this.firstLineIndex;
        if (this.firstLineIndex == 3) {
            this.firstLineIndex = 0;
        }
    }
}

