/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.prettyprint;

import fr.inria.tapenade.prettyprint.Decompiler;
import fr.inria.tapenade.prettyprint.Printer;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.utils.TapIntList;
import fr.inria.tapenade.utils.Tree;
import java.io.IOException;

public final class FortranDecompiler
extends Decompiler {
    private static final int LINE_LENGTH_MAX = 128;
    private static final String KWABSTRACT = "ABSTRACT";
    private static final String KWASSIGN = "ASSIGN";
    private static final String KWASSIGNMENT = "ASSIGNMENT";
    private static final String KWBLOCKDATA = "BLOCKDATA";
    private static final String KWCALL = "CALL";
    private static final String KWCASE = "CASE";
    private static final String KWCOMMON = "COMMON";
    private static final String KWCONTAINS = "CONTAINS";
    private static final String KWCONTINUE = "CONTINUE";
    private static final String KWCYCLE = "CYCLE";
    private static final String KWDATA = "DATA";
    private static final String KWDIMENSION = "DIMENSION";
    private static final String KWDEFAULT = "DEFAULT";
    private static final String KWDO = "DO";
    private static final String KWELSE = "ELSE";
    private static final String KWELSEWHERE = "ELSEWHERE";
    private static final String KWEND = "END";
    private static final String KWENDDO = "ENDDO";
    private static final String KWENDFORALL = "END FORALL";
    private static final String KWENDIF = "END IF";
    private static final String KWENDSELECT = "END SELECT";
    private static final String KWENDTYPE = "END TYPE";
    private static final String KWEQUIVALENCE = "EQUIVALENCE";
    private static final String KWEXIT = "EXIT";
    private static final String KWEXTERNAL = "EXTERNAL";
    private static final String KWFORALL = "FORALL";
    private static final String KWFORMAT = "FORMAT";
    private static final String KWFUNCTION = "FUNCTION";
    private static final String KWGOTO = "GOTO";
    private static final String KWIF = "IF";
    private static final String KWIMPLICIT = "IMPLICIT";
    private static final String KWINCLUDE = "INCLUDE";
    private static final String KWINTERFACE = "INTERFACE";
    private static final String KWINTRINSIC = "INTRINSIC";
    private static final String KWMODULE = "MODULE";
    private static final String KWNAMELIST = "NAMELIST";
    private static final String KWNONE = "NONE";
    private static final String KWONLY = "ONLY";
    private static final String KWOPERATOR = "OPERATOR";
    private static final String KWPARAMETER = "PARAMETER";
    private static final String KWPOINTER = "POINTER";
    private static final String KWPROCEDURE = "PROCEDURE";
    private static final String KWPROGRAM = "PROGRAM";
    private static final String KWRESULT = "RESULT";
    private static final String KWRETURN = "RETURN";
    private static final String KWSAVE = "SAVE";
    private static final String KWSELECT = "SELECT";
    private static final String KWSELECTCASE = "SELECT CASE";
    private static final String KWSTOP = "STOP";
    private static final String KWSUBROUTINE = "SUBROUTINE";
    private static final String KWTHEN = "THEN";
    private static final String KWTIMES = "TIMES";
    private static final String KWTO = "TO";
    private static final String KWTYPE = "TYPE";
    private static final String KWUNTIL = "UNTIL";
    private static final String KWUSE = "USE";
    private static final String KWWHERE = "WHERE";
    private static final String KWWHILE = "WHILE";
    private static final String KWNULLIFY = "NULLIFY";
    private static final String KWALLOCATE = "ALLOCATE";
    private static final String KWDEALLOCATE = "DEALLOCATE";
    private static final String KWMOD = "MOD";
    private static final int INCOMMENT_CTX = 1;
    private static final int ISMODIFIER_CTX = 2;
    private static final int ISTYPENAME_CTX = 3;
    private static final int ISVARDECL_CTX = 4;
    private static final int ISFUNCNAME_CTX = 5;
    private static final int ISLABEL_CTX = 6;
    private static final int RESULTEXPECTED_CTX = 7;
    private static final int DEEPEXPR_CTX = 8;
    private static final int INELSEIF_CTX = 9;
    private static final int INELSEWHERE_CTX = 10;
    private static final int ININTERFACE_CTX = 11;
    private static final int INCHARSTAR_CTX = 12;
    private static final int INDATA_CTX = 13;
    private static final int INBINDC_CTX = 14;
    private static final int INUNITBODY_CTX = 15;
    private static final int INOMP_CTX = 16;
    private static final int INBODY_CONTEXT = 32768;
    private static final int INOMP_CONTEXT = 65536;
    private boolean labelWaiting;
    private boolean allUC;
    private boolean allLC;
    private boolean fortranStyle9x;
    private TapIntList expressionPhylum;

    public FortranDecompiler(Printer printer, String htmlMsgFileName) {
        super(printer, htmlMsgFileName);
    }

    @Override
    public void decompileTree(Tree tree, int language, boolean inInclude, boolean dumps) {
        if (tree != null) {
            try {
                this.showMessages = dumps;
                this.language = language;
                this.maxColumn = 72;
                boolean bl = this.fortranStyle9x = this.language == 2 || this.language == 3;
                if (this.fortranStyle9x) {
                    this.maxColumn = TapEnv.get().fortran90OutputLineLength;
                }
                this.commentChar = this.fortranStyle9x ? "!" : "C";
                this.continuationChar = this.fortranStyle9x ? "&" : "+";
                this.eolContinuationChar = this.fortranStyle9x ? "&" : "";
                this.reinitialize();
                this.decompile(tree, 0, 0, inInclude ? 32768 : 0);
            }
            catch (IOException e) {
                TapEnv.systemError("(Decompiler) I-O error " + e.getMessage() + " while writing output file ");
            }
        } else {
            TapEnv.toolWarning(-1, "(Fortran decompiler) null tree");
        }
    }

    private void decompile(Tree tree, int indent, int precedence, int context) throws IOException {
        this.preDecompile(tree, indent);
        switch (tree.opCode()) {
            case 27: 
            case 53: 
            case 76: {
                Tree[] sons = tree.children();
                boolean inFunctions = false;
                for (int i = 0; i < sons.length; ++i) {
                    if (this.hasContext(context, 15) && !inFunctions && sons[i].opCode() == 89) {
                        this.newLine(indent);
                        this.print(KWCONTAINS, this.fortranStyle9x ? indent - 2 : indent, "keyword");
                        this.newLine(indent);
                        inFunctions = true;
                        context = this.contextMinus(context, 15);
                    }
                    this.decompile(sons[i], indent, 0, context);
                    if (i < sons.length - 1) {
                        if (sons[i].opCode() != 138) {
                            this.newLine(indent);
                        }
                        if (this.hasContext(context, 15)) continue;
                        this.newLine(indent);
                        continue;
                    }
                    if (tree.parent() == null || this.hasContext(context, 15)) continue;
                    this.newLine(indent);
                }
                break;
            }
            case 130: {
                Tree[] modifiers;
                for (Tree modifier : modifiers = tree.children()) {
                    this.printAtomValue(modifier, true, indent, "modifier");
                    this.space();
                }
                break;
            }
            case 113: 
            case 120: 
            case 200: {
                Tree[] sons = tree.children();
                for (int i = 0; i < sons.length; ++i) {
                    this.decompile(sons[i], indent, 0, context);
                    if (i >= sons.length - 1) continue;
                    this.print(", ", indent, "plain");
                }
                break;
            }
            case 54: 
            case 201: {
                Tree[] sons = tree.children();
                context = this.contextPlus(context, 8);
                for (int i = 0; i < sons.length; ++i) {
                    this.decompile(sons[i], indent, 0, context);
                    if (i >= sons.length - 1) continue;
                    this.print(", ", indent, "plain");
                }
                break;
            }
            case 60: {
                Tree[] sons = tree.children();
                context = this.contextMinus(context, 3);
                context = this.contextPlus(context, 7);
                context = this.contextPlus(context, 8);
                for (int i = sons.length - 1; i >= 0; --i) {
                    this.decompile(sons[i], indent, 0, context);
                    if (i <= 0) continue;
                    this.print(", ", indent, "plain");
                }
                break;
            }
            case 101: {
                this.print(KWINCLUDE, indent, "keyword");
                this.print(" '", indent + 4, "plain");
                this.print(tree.stringValue(), indent + 4, "funcname");
                this.print("'", indent + 4, "plain");
                break;
            }
            case 71: {
                Tree[] sons = tree.children();
                boolean testNone = false;
                if (tree.parent() != null) {
                    testNone = tree.parent().opCode() == 31;
                }
                for (int i = 0; i < sons.length; ++i) {
                    if (sons[i].opCode() == 111) {
                        this.print("*", indent, "label");
                    }
                    boolean isLast = testNone;
                    if (testNone) {
                        for (int j = i + 1; j < sons.length; ++j) {
                            isLast = isLast && sons[j].opCode() == 138;
                        }
                    }
                    if (testNone) {
                        if (sons[i].opCode() == 138) continue;
                        this.decompile(sons[i], indent, 0, context);
                        if (isLast || i >= sons.length - 1) continue;
                        this.print(", ", indent, "plain");
                        continue;
                    }
                    this.decompile(sons[i], indent, 0, context);
                    if (i >= sons.length - 1 || sons[i + 1].opCode() == 138) continue;
                    this.print(", ", indent, "plain");
                }
                break;
            }
            case 97: {
                Tree[] children = tree.children();
                for (int i = 0; i < children.length; ++i) {
                    this.decompile(children[i], indent, 0, context);
                    if (i >= children.length - 1 || children[i + 1].opCode() == 138) continue;
                    this.print(", ", indent, "plain");
                }
                break;
            }
            case 171: {
                this.print(KWSAVE, indent, "keyword");
                this.space();
                Tree[] children = tree.children();
                for (int i = 0; i < children.length; ++i) {
                    this.decompile(children[i], indent + 4, 0, context);
                    if (i >= children.length - 1) continue;
                    this.print(", ", indent + 4, "plain");
                }
                break;
            }
            case 108: {
                this.print(KWINTRINSIC, indent, "keyword");
                this.space();
                Tree[] sons = tree.children();
                for (int i = 0; i < sons.length; ++i) {
                    this.decompile(sons[i], indent + 4, 0, this.contextPlus(context, 5));
                    if (i >= sons.length - 1) continue;
                    this.print(", ", indent + 4, "plain");
                }
                break;
            }
            case 74: {
                this.print(KWEXTERNAL, indent, "keyword");
                this.space();
                Tree[] sons = tree.children();
                for (int i = 0; i < sons.length; ++i) {
                    this.decompile(sons[i], indent + 4, 0, this.contextPlus(context, 5));
                    if (i >= sons.length - 1) continue;
                    this.print(", ", indent + 4, "plain");
                }
                break;
            }
            case 202: {
                if (tree.length() == 0) break;
                this.print(KWDIMENSION, indent, "keyword");
                this.space();
                context = this.contextMinus(context, 3);
                Tree[] sons = tree.children();
                for (int i = 0; i < sons.length; ++i) {
                    this.decompile(sons[i], indent + 4, 0, this.contextPlus(context, 4));
                    if (i >= sons.length - 1) continue;
                    this.print(", ", indent + 4, "plain");
                }
                break;
            }
            case 69: {
                this.print(KWEQUIVALENCE, indent, "keyword");
                Tree[] sons = tree.children();
                for (int i = 0; i < sons.length; ++i) {
                    this.print(" (", indent + 4, "plain");
                    this.decompile(sons[i], indent + 5, 0, context);
                    this.print(")", indent + 4, "plain");
                    if (i >= sons.length - 1) continue;
                    this.print(", ", indent + 4, "plain");
                }
                break;
            }
            case 100: {
                this.print(KWIMPLICIT, indent, "keyword");
                this.space();
                Tree[] sons = tree.children();
                if (sons.length == 0) {
                    this.print(KWNONE, indent, "keyword");
                    break;
                }
                for (int i = 0; i < sons.length; ++i) {
                    this.decompile(sons[i], indent + 4, 0, context);
                    if (i >= sons.length - 1) continue;
                    this.print(", ", indent + 4, "plain");
                }
                break;
            }
            case 159: {
                this.decompile(tree.down(1), indent, 0, this.contextPlus(context, 2));
                if (ILUtils.isNotNone(tree.down(2)) && (tree.down(2).opCode() != 96 || !tree.down(2).stringValue().startsWith("_main_"))) {
                    this.print(KWPROGRAM, indent, "keyword");
                    this.space();
                    this.printAtomValue(tree.down(2), !this.allLC, indent, "funcname");
                }
                this.newLine(indent);
                if (this.fortranStyle9x) {
                    this.decompile(tree.down(3), indent + 2, 0, 32768);
                    this.decompile(tree.down(4), indent + 2, 0, 32768);
                } else {
                    this.decompile(tree.down(4), indent, 0, 32768);
                }
                if (!this.labelWaiting) {
                    this.newLine(indent);
                } else {
                    this.labelWaiting = false;
                }
                this.print(KWEND, indent, "keyword");
                if (!this.fortranStyle9x || !ILUtils.isNotNone(tree.down(2)) || tree.down(2).opCode() == 96 && tree.down(2).stringValue().equals("_main_")) break;
                this.space();
                this.print(KWPROGRAM, indent, "keyword");
                this.space();
                this.printAtomValue(tree.down(2), !this.allLC, indent, "funcname");
                break;
            }
            case 89: {
                Tree annotBind;
                String kw;
                if (tree.down(1).opCode() != 2) {
                    this.decompile(tree.down(1), indent, 0, this.contextPlus(context, 2));
                }
                if (ILUtils.isNotVoid(tree.down(2))) {
                    if (tree.down(2).opCode() != 138) {
                        this.decompile9xType(tree.down(2), indent, this.contextPlus(context, 3));
                        this.space();
                    }
                    kw = KWFUNCTION;
                } else {
                    kw = this.hasContext(context, 11) ? (tree.down(2).opCode() == 204 ? KWSUBROUTINE : KWFUNCTION) : KWSUBROUTINE;
                }
                this.print(kw, indent, "keyword");
                this.space();
                this.printAtomValue(tree.down(4), !this.allLC, indent, "funcname");
                this.print("(", indent, "plain");
                this.decompile(tree.down(5), this.fortranStyle9x ? indent + 2 : indent, 0, this.contextPlus(context, 4));
                this.print(")", indent, "plain");
                Tree annotExplicitReturn = (Tree)tree.down(4).getAnnotation("explicitReturnVar");
                if (!ILUtils.isNullOrNone(annotExplicitReturn)) {
                    this.space();
                    this.print(KWRESULT, indent, "plain");
                    this.space();
                    this.print("(", indent, "plain");
                    this.printAtomValue(annotExplicitReturn, this.allUC, indent, "plain");
                    this.print(")", indent, "plain");
                }
                if ((annotBind = (Tree)tree.down(4).getAnnotation("bind")) != null && annotBind.opCode() == 2) {
                    this.space();
                    this.decompile(annotBind, indent, 0, this.contextPlus(context, 14));
                }
                if (tree.down(1).opCode() == 2) {
                    this.space();
                    this.decompile(tree.down(1), indent, 0, this.contextPlus(context, 14));
                }
                this.newLine(indent);
                this.decompile(tree.down(6), this.fortranStyle9x ? indent + 2 : indent, 0, 32768);
                if (!this.labelWaiting) {
                    this.newLine(indent);
                } else {
                    this.labelWaiting = false;
                }
                this.print(KWEND, indent, "keyword");
                if (!this.fortranStyle9x) break;
                this.space();
                this.print(kw, indent, "keyword");
                this.space();
                this.printAtomValue(tree.down(4), !this.allLC, indent, "funcname");
                break;
            }
            case 131: {
                String blockDataName;
                boolean isBlockData = false;
                if (tree.down(1).opCode() == 96 && (isBlockData = (blockDataName = tree.down(1).stringValue()).startsWith("_blockdata_"))) {
                    blockDataName = blockDataName.substring(11);
                    tree.down(1).setValue(blockDataName);
                }
                if (isBlockData) {
                    this.print(KWBLOCKDATA, indent, "keyword");
                } else {
                    this.print(KWMODULE, indent, "keyword");
                }
                if (ILUtils.isNotNone(tree.down(1)) && (tree.down(1).opCode() != 96 || !tree.down(1).stringValue().equals("_main_"))) {
                    this.space();
                    this.printAtomValue(tree.down(1), !this.allLC, indent, "funcname");
                }
                this.newLine(indent);
                this.decompile(tree.down(2), indent + 2, 0, 32768);
                if (!this.labelWaiting) {
                    this.newLine(indent);
                } else {
                    this.labelWaiting = false;
                }
                this.print(KWEND, indent, "keyword");
                if (isBlockData) break;
                this.space();
                this.print(KWMODULE, indent, "keyword");
                if (!ILUtils.isNotNone(tree.down(1)) || tree.down(1).opCode() == 96 && tree.down(1).stringValue().equals("_main_")) break;
                this.space();
                this.printAtomValue(tree.down(1), !this.allLC, indent, "funcname");
                break;
            }
            case 129: {
                TapList<Object> modifiersBefore = new TapList<Object>(null, null);
                TapList<Object> typeSuffixes = new TapList<Object>(null, null);
                TapList<Object> modifiersAfter = new TapList<Object>(null, null);
                String basisTypeName = this.sortModifiers(tree, modifiersBefore, typeSuffixes, modifiersAfter);
                modifiersBefore = modifiersBefore.tail;
                while (modifiersBefore != null) {
                    this.decompile((Tree)modifiersBefore.head, indent, 0, this.contextPlus(context, 2));
                    this.space();
                    modifiersBefore = modifiersBefore.tail;
                }
                if (basisTypeName == null) {
                    Tree typeTree = tree.down(2);
                    if (TapList.containsTree(modifiersAfter.tail, ILUtils.build(96, "allocatable")) && typeTree.opCode() == 154) {
                        typeTree = typeTree.down(1);
                    }
                    this.decompile(typeTree, indent, 0, this.contextPlus(context, 3));
                } else {
                    if (!this.allLC) {
                        basisTypeName = basisTypeName.toUpperCase();
                    }
                    this.print(basisTypeName, indent, "typename");
                }
                typeSuffixes = typeSuffixes.tail;
                while (typeSuffixes != null) {
                    if (this.language == 1) {
                        this.print("*", indent, "typename");
                    }
                    this.print("(", indent, "typename");
                    this.decompile((Tree)typeSuffixes.head, indent, 0, this.contextPlus(this.contextPlus(this.contextMinus(context, 3), 2), 7));
                    this.print(")", indent, "typename");
                    typeSuffixes = typeSuffixes.tail;
                }
                if (modifiersAfter.head == null) {
                    modifiersAfter = modifiersAfter.tail;
                }
                while (modifiersAfter != null) {
                    this.print(",", indent, "plain");
                    this.space();
                    Tree modifier = (Tree)modifiersAfter.head;
                    boolean isIntent = false;
                    boolean isDimension = false;
                    if (modifier.opCode() == 96) {
                        String modifText = ILUtils.toString(modifier).toUpperCase();
                        boolean bl = isIntent = modifText.equals("IN") || modifText.equals("OUT") || modifText.equals("INOUT");
                        if (isIntent) {
                            this.print("INTENT(", indent, "typename");
                        }
                    } else if (modifier.opCode() == 60) {
                        isDimension = true;
                        this.print("DIMENSION(", indent, "typename");
                    }
                    this.decompile(modifier, indent, 0, context);
                    if (isIntent || isDimension) {
                        this.print(")", indent, "typename");
                    }
                    modifiersAfter = modifiersAfter.tail;
                }
                break;
            }
            case 199: {
                TapList<Tree> trees;
                if (!this.fortranStyle9x && tree.down(2).opCode() == 13) {
                    Tree baseType = ILUtils.baseTypeTree(tree.down(2));
                    assert (baseType != null);
                    if (baseType.opCode() != 35) {
                        tree = ILUtils.arrayTypeToArrayDeclarator(tree);
                    }
                }
                if ((trees = ILUtils.splitLongDeclaration(tree)) != null) {
                    while (trees != null) {
                        this.decompile((Tree)trees.head, indent, 0, context);
                        if (trees.tail != null) {
                            this.newLine(indent);
                        }
                        trees = trees.tail;
                    }
                    break;
                }
                if (ILUtils.isNotNone(tree.down(2))) {
                    this.decompile9xType(tree.down(2), indent, context);
                    this.space();
                    if (this.fortranStyle9x || ILUtils.hasInitializations(tree.down(3)) || ILUtils.hasFortran90Modifiers(tree.down(2))) {
                        this.print("::", indent, "plain");
                        this.space();
                    }
                }
                this.decompile(tree.down(3), this.fortranStyle9x ? indent : this.posX - 6, 0, this.contextPlus(context, 4));
                break;
            }
            case 192: {
                this.print(KWTYPE, indent, "keyword");
                this.space();
                this.decompile(tree.down(1), indent + 1, 0, this.contextPlus(context, 3));
                this.newLine(indent);
                if (!this.fortranStyle9x) {
                    this.decompile(tree.down(2), indent + 2, 0, this.contextPlus(context, 3));
                    this.print(KWENDTYPE, indent, "keyword");
                } else {
                    this.decompile(tree.down(2), indent + 4, 0, this.contextPlus(context, 3));
                    if (tree.down(2).opCode() != 161) {
                        this.newLine(indent);
                    }
                    this.print(KWEND, indent, "keyword");
                    this.space();
                    this.print(KWTYPE, indent, "keyword");
                    this.space();
                    this.printAtomValue(tree.down(1), !this.allLC, indent, "plain");
                }
                if (tree.down(2).opCode() == 161) break;
                TapEnv.toolWarning(-1, "(Fortran decompiler) undefined type: " + tree.down(1).stringValue());
                break;
            }
            case 161: {
                Tree modifiers = tree.down(2);
                Tree[] sons = tree.down(3).children();
                this.decompile(modifiers, indent, 0, 0);
                if (modifiers.length() > 0) {
                    this.newLine(indent);
                }
                for (Tree son : sons) {
                    this.decompile(son, indent, 0, 32768);
                    this.newLine(indent);
                }
                if (sons.length != 0) break;
                this.print(KWTYPE, indent, "keyword");
                this.print("(", indent, "keyword");
                this.decompile(tree.down(1), indent, 0, this.contextPlus(context, 3));
                this.print(")", indent, "keyword");
                break;
            }
            case 154: {
                if (this.fortranStyle9x) {
                    this.decompile9xType(tree.down(1), indent, context);
                } else {
                    this.decompile(tree.down(1), indent, 0, this.contextPlus(context, 3));
                }
                this.print(",", indent, "plain");
                this.space();
                this.print(KWPOINTER, indent, "modifier");
                break;
            }
            case 175: {
                boolean intValue;
                this.decompile(tree.down(1), indent, 0, this.contextPlus(this.contextPlus(context, 7), 8));
                this.print("*", indent, "plain");
                boolean bl = intValue = tree.down(2).opCode() == 103;
                if (intValue) {
                    this.decompile(tree.down(2), indent, 0, this.contextPlus(this.contextPlus(context, 7), 8));
                    break;
                }
                this.print("(", indent, "plain");
                this.decompile(tree.down(2), indent, 0, this.contextPlus(this.contextPlus(context, 7), 8));
                this.print(")", indent, "plain");
                break;
            }
            case 13: {
                if (this.fortranStyle9x) {
                    this.decompile9xType(tree.down(1), indent, context);
                } else {
                    this.decompile(tree.down(1), indent, 0, this.contextPlus(context, 3));
                }
                if (tree.down(1).opCode() == 35) {
                    if (this.fortranStyle9x) {
                        this.print("(", indent, "plain");
                        if (tree.down(2).down(1).down(2).opCode() != 134 && tree.down(2).down(1).down(2).opCode() != 71) {
                            this.print("len", indent, "keyword");
                            this.print("=", indent, "plain");
                        }
                        context = this.contextMinus(context, 3);
                        this.decompile(tree.down(2), indent, 0, this.contextPlus(context, 12));
                        this.print(")", indent, "plain");
                        break;
                    }
                    this.print("*", indent, "plain");
                    if (tree.down(2).length() == 1 && tree.down(2).down(1).down(1).opCode() == 103 && tree.down(2).down(1).down(1).intValue() == 1 && (tree.down(2).down(1).down(2).opCode() == 138 || tree.down(2).down(1).down(2).opCode() == 177)) {
                        this.print("(*)", indent, "plain");
                        break;
                    }
                    if (tree.down(2).length() == 1 && tree.down(2).down(1).down(1).opCode() == 103 && tree.down(2).down(1).down(1).intValue() == 1 && tree.down(2).down(1).down(2).opCode() == 103) {
                        this.decompile(tree.down(2), indent, 0, this.contextPlus(this.contextPlus(context, 7), 8));
                        break;
                    }
                    this.print("(", indent, "plain");
                    this.decompile(tree.down(2), indent, 0, this.contextPlus(this.contextPlus(context, 7), 8));
                    this.print(")", indent, "plain");
                    break;
                }
                this.print(",", indent, "plain");
                this.space();
                this.print(KWDIMENSION, indent, "plain");
                context = this.contextMinus(context, 3);
                this.print("(", indent, "plain");
                this.decompile(tree.down(2), indent, 0, this.contextPlus(this.contextPlus(context, 7), 8));
                this.print(")", indent, "plain");
                break;
            }
            case 11: {
                this.decompile(tree.down(1), indent, 0, this.contextPlus(this.contextPlus(context, 7), 8));
                this.print("(", indent, "plain");
                this.decompile(tree.down(2), indent, 0, this.contextPlus(this.contextPlus(context, 7), 8));
                this.print(")", indent, "plain");
                break;
            }
            case 59: {
                if (ILUtils.isNotNone(tree.down(1)) && !ILUtils.evalsToOne(tree.down(1))) {
                    this.decompile(tree.down(1), indent, 0, context);
                    this.print(":", indent, "plain");
                }
                if (ILUtils.isNotNone(tree.down(2))) {
                    this.decompile(tree.down(2), indent, 0, context);
                    break;
                }
                if (ILUtils.isNotNone(tree.down(1)) && !ILUtils.evalsToOne(tree.down(1))) break;
                if (!(this.hasContext(context, 12) || this.language != 2 && this.language != 3)) {
                    this.print(":", indent, "plain");
                    break;
                }
                this.print("*", indent, "plain");
                break;
            }
            case 112: {
                if (tree.down(1).opCode() == 113) {
                    this.printLabel(tree.down(1).down(1).stringValue());
                } else {
                    this.printLabel(tree.down(1).stringValue());
                }
                if (tree.down(2).opCode() == 138) {
                    this.labelWaiting = true;
                    break;
                }
                if (tree.down(2).opCode() == 30) {
                    this.print(KWCONTINUE, indent, "keyword");
                    break;
                }
                this.decompile(tree.down(2), indent, 0, 32768);
                break;
            }
            case 98: {
                Tree simpleExpr;
                this.print(KWIF, indent, "keyword");
                this.print(" (", indent, "plain");
                this.decompile(tree.down(1), indent + 4, 0, this.contextPlus(context, 7));
                this.print(") ", indent, "plain");
                if (ILUtils.isNullOrNoneOrEmptyList(tree.down(3)) && (simpleExpr = this.isSimpleExpr(tree.down(2))) != null && !this.hasContext(context, 9)) {
                    this.decompile(simpleExpr, indent + 2, 0, 0);
                    break;
                }
                this.print(KWTHEN, indent, "keyword");
                this.newLine(indent);
                this.decompile(tree.down(2), indent + 2, 0, 32768);
                if (!ILUtils.isNullOrNoneOrEmptyList(tree.down(3))) {
                    this.newLine(indent);
                    this.print(KWELSE, indent, "keyword");
                    if (this.isSingleMergeableIf(tree.down(3))) {
                        this.space();
                        this.decompile(tree.down(3), indent, 0, this.contextPlus(context, 9));
                    } else {
                        this.newLine(indent);
                        this.decompile(tree.down(3), indent + 2, 0, 32768);
                    }
                }
                if (this.hasContext(context, 9)) break;
                if (!this.labelWaiting) {
                    this.newLine(indent);
                } else {
                    this.labelWaiting = false;
                }
                if (!this.fortranStyle9x) {
                    this.print(KWENDIF, indent, "keyword");
                    break;
                }
                this.print(KWEND, indent, "keyword");
                this.space();
                this.print(KWIF, indent, "keyword");
                break;
            }
            case 205: {
                Tree simpleExpr;
                String optId = null;
                int optIdIndent = indent;
                if (!ILUtils.isNullOrNone(tree.down(4)) && (optIdIndent = indent - (optId = tree.down(4).stringValue()).length() - 1) < 0) {
                    optIdIndent = 0;
                }
                if (!this.hasContext(context, 10)) {
                    if (optId != null) {
                        this.print(optId + ":", optIdIndent, "label");
                    }
                    this.print(KWWHERE, indent, "keyword");
                    this.space();
                }
                this.print("(", indent, "plain");
                this.decompile(tree.down(1), indent + 4, 0, this.contextPlus(context, 7));
                this.print(") ", indent, "plain");
                if (optId != null && this.hasContext(context, 10)) {
                    this.print(optId, optIdIndent, "label");
                }
                if (ILUtils.isNullOrNoneOrEmptyList(tree.down(3)) && (simpleExpr = this.isSimpleExpr(tree.down(2))) != null && !this.hasContext(context, 10)) {
                    this.decompile(simpleExpr, indent + 2, 0, context);
                    break;
                }
                this.newLine(indent);
                this.decompile(tree.down(2), indent + 2, 0, this.contextMinus(context, 10));
                if (!ILUtils.isNullOrNoneOrEmptyList(tree.down(3))) {
                    this.newLine(indent);
                    this.print(KWELSEWHERE, indent, "keyword");
                    if (this.isSingleMergeableWhere(tree.down(3))) {
                        this.space();
                        this.decompile(tree.down(3), indent, 0, this.contextPlus(context, 10));
                    } else {
                        this.newLine(indent);
                        this.decompile(tree.down(3), indent + 2, 0, this.contextMinus(context, 10));
                    }
                }
                if (this.hasContext(context, 10)) break;
                if (!this.labelWaiting) {
                    this.newLine(indent);
                } else {
                    this.labelWaiting = false;
                }
                this.print(KWEND, indent, "keyword");
                this.space();
                this.print(KWWHERE, indent, "keyword");
                if (optId == null) break;
                this.space();
                this.print(optId, optIdIndent, "label");
                break;
            }
            case 186: {
                Tree[] sons = tree.children();
                for (int i = 0; i < sons.length; ++i) {
                    this.decompile(sons[i], indent, 0, context);
                    if (i >= sons.length - 1 || sons[i + 1].down(2) == null || sons[i + 1].down(2).length() == 0) continue;
                    this.newLine(indent);
                }
                break;
            }
            case 121: {
                int ctrOpCode = tree.down(3).opCode();
                String optId = null;
                int optIdIndent = indent;
                if (ILUtils.isNotNone(tree.down(1)) && (optIdIndent = indent - (optId = tree.down(1).stringValue()).length() - 1) < 0) {
                    optIdIndent = 0;
                }
                if (optId != null && !ILUtils.isNotNone(tree.down(2))) {
                    this.print(optId + ":", optIdIndent, "label");
                }
                if (ctrOpCode == 80) {
                    this.print(KWFORALL, indent, "keyword");
                    this.space();
                } else {
                    this.print(KWDO, indent, "keyword");
                    this.space();
                    if (ILUtils.isNotNone(tree.down(2))) {
                        this.printAtomValue(tree.down(2), this.allUC, indent, "label");
                        this.space();
                    }
                }
                this.decompile(tree.down(3), indent + 3, 0, 0);
                Tree simpleExpr = this.isSimpleExpr(tree.down(4));
                if (ctrOpCode == 80 && simpleExpr != null) {
                    this.space();
                    this.decompile(simpleExpr, indent + 2, 0, 32768);
                    break;
                }
                this.newLine(indent);
                this.decompile(tree.down(4), indent + 2, 0, 32768);
                if (!this.labelWaiting) {
                    this.newLine(indent);
                } else {
                    this.labelWaiting = false;
                }
                if (ctrOpCode == 80) {
                    this.print(KWENDFORALL, indent, "keyword");
                } else if (ILUtils.isNotNone(tree.down(2))) {
                    this.printLabel(tree.down(2).stringValue());
                    this.print(KWCONTINUE, indent, "keyword");
                } else if (!this.fortranStyle9x) {
                    this.print(KWENDDO, indent, "keyword");
                } else {
                    this.print(KWEND, indent, "keyword");
                    this.space();
                    this.print(KWDO, indent, "keyword");
                }
                if (optId == null || ILUtils.isNotNone(tree.down(2))) break;
                this.space();
                this.print(optId, optIdIndent, "label");
                break;
            }
            case 64: {
                this.printAtomValue(tree.down(1), this.allUC, indent, "plain");
                context = this.contextPlus(this.contextPlus(context, 7), 8);
                this.print("=", indent, "plain");
                this.decompile(tree.down(2), indent + 1, 0, context);
                this.print(",", indent, "plain");
                this.decompile(tree.down(3), indent + 1, 0, context);
                if (!ILUtils.isNotNone(tree.down(4))) break;
                this.print(",", indent, "plain");
                this.decompile(tree.down(4), indent + 1, 0, context);
                break;
            }
            case 79: {
                if (ILUtils.mayBeTransformed2Do(tree)) {
                    this.decompile(ILUtils.transformFor2Do(tree), indent, precedence, context);
                    break;
                }
                TapEnv.toolWarning(-1, "(Fortran decompiler) cannot rewrite this C-style \"for\" into a \"do\": " + ILUtils.toString(tree));
                break;
            }
            case 189: {
                if (this.fortranStyle9x) {
                    this.print(KWTIMES, indent, "keyword");
                    this.space();
                }
                this.print("(", indent, "plain");
                if (this.fortranStyle9x) {
                    this.decompile(tree.down(1), indent + 7, 0, this.contextPlus(context, 7));
                } else {
                    this.decompile(tree.down(1), indent + 1, 0, this.contextPlus(context, 7));
                }
                this.print(") ", indent, "plain");
                if (!this.fortranStyle9x) {
                    this.print(KWTIMES, indent, "keyword");
                    break;
                }
                this.space();
                break;
            }
            case 206: {
                this.print(KWWHILE, indent, "keyword");
                this.print(" (", indent, "plain");
                this.decompile(tree.down(1), indent + 7, 0, this.contextPlus(context, 7));
                this.print(")", indent, "plain");
                break;
            }
            case 196: {
                this.print(KWUNTIL, indent, "keyword");
                this.print(" (", indent, "plain");
                this.decompile(tree.down(1), indent + 7, 0, this.contextPlus(context, 7));
                this.print(")", indent, "plain");
                break;
            }
            case 80: {
                this.print("(", indent, "plain");
                Tree[] ranges = tree.down(1).children();
                for (int i = 0; i < ranges.length; ++i) {
                    this.decompile(ranges[i], indent, 0, context);
                    if (i >= ranges.length - 1) continue;
                    this.print(", ", indent, "plain");
                }
                if (ILUtils.isNotNone(tree.down(2))) {
                    this.print(",", indent, "plain");
                    this.decompile(tree.down(2), indent + 1, 0, context);
                }
                this.print(") ", indent, "plain");
                break;
            }
            case 82: {
                this.printAtomValue(tree.down(1), this.allUC, indent, "plain");
                int context2 = this.contextPlus(this.contextPlus(context, 7), 8);
                this.print("=", indent, "plain");
                this.decompile(tree.down(2), indent + 1, 0, context2);
                this.print(":", indent, "plain");
                this.decompile(tree.down(3), indent + 1, 0, context2);
                if (!ILUtils.isNotNone(tree.down(4))) break;
                this.print(":", indent, "plain");
                this.decompile(tree.down(4), indent + 1, 0, context2);
                break;
            }
            case 49: {
                this.print(KWCONTINUE, indent, "keyword");
                break;
            }
            case 179: {
                this.print(KWSTOP, indent, "keyword");
                break;
            }
            case 93: {
                this.print(KWGOTO, indent, "keyword");
                this.space();
                this.printAtomValue(tree.down(1), this.allUC, indent + 1, "label");
                break;
            }
            case 40: {
                this.print(KWGOTO, indent, "keyword");
                this.print(" (", indent, "plain");
                this.decompile(tree.down(1), indent + 6, 0, this.contextPlus(context, 6));
                this.print(") ", indent, "plain");
                this.decompile(tree.down(2), indent + 4, 0, this.contextPlus(context, 7));
                break;
            }
            case 94: {
                this.print(KWGOTO, indent, "keyword");
                this.space();
                this.printAtomValue(tree.down(1), this.allUC, indent + 1, "plain");
                if (ILUtils.isNullOrNoneOrEmptyList(tree.down(2))) break;
                this.print(" (", indent, "plain");
                this.decompile(tree.down(2), indent + 7, 0, this.contextPlus(context, 6));
                this.print(")", indent, "plain");
                break;
            }
            case 15: {
                this.print(KWASSIGN, indent, "keyword");
                this.space();
                this.decompile(tree.down(1), indent + 7, 0, this.contextPlus(context, 7));
                this.space();
                this.print(KWTO, indent + 4, "keyword");
                this.space();
                this.printAtomValue(tree.down(2), this.allUC, indent + 8, "label");
                break;
            }
            case 31: {
                Tree annot = (Tree)tree.getAnnotation("sourcetree");
                if (annot != null) {
                    if (annot.opCode() == 17) {
                        String opStr = annot.down(2).stringValue();
                        if (opStr.equals("add")) {
                            opStr = "+";
                        } else if (opStr.equals("sub")) {
                            opStr = "-";
                        } else if (opStr.equals("mul")) {
                            opStr = "*";
                        } else if (opStr.equals("div")) {
                            opStr = "/";
                        } else if (opStr.equals("assign")) {
                            opStr = "=";
                        } else if (opStr.equals("ge")) {
                            opStr = ".GE.";
                        } else if (opStr.equals("gt")) {
                            opStr = ".GT.";
                        } else if (opStr.equals("le")) {
                            opStr = ".LE.";
                        } else if (opStr.equals("lt")) {
                            opStr = ".LT.";
                        } else if (this.allUC) {
                            opStr = opStr.toUpperCase();
                        }
                        this.decompileBinaryExpr(ILUtils.getArguments(tree).down(1), ILUtils.getArguments(tree).down(2), indent, precedence, context, opStr, 1, 1, 1);
                        break;
                    }
                    if (annot.opCode() == 194) {
                        String opStr = annot.down(1).stringValue();
                        opStr = opStr.equals("sub") ? "-" : (this.allUC ? opStr.toUpperCase() + " " : opStr + " ");
                        this.decompileUnaryExpr(ILUtils.getArguments(tree).down(1), indent, precedence, context, opStr, 1, 1);
                        break;
                    }
                    Tree annot2 = (Tree)tree.getAnnotation("optionaltree");
                    if (annot2 != null) {
                        ILUtils.reBuildNameEqArgs(tree, annot2);
                        annot = annot2;
                    } else {
                        tree.removeAnnotation("sourcetree");
                        annot = tree;
                    }
                    this.decompile(annot, indent, precedence, context);
                    break;
                }
                if (!this.hasContext(context, 7)) {
                    this.print(KWCALL, indent, "keyword");
                    this.space();
                }
                this.decompile(ILUtils.getCalledName(tree), indent, 0, this.contextPlus(context, 5));
                if (!this.hasContext(context, 7)) {
                    indent = this.posX - 6;
                }
                this.print("(", indent, "plain");
                this.decompile(ILUtils.getArguments(tree), this.hasContext(context, 7) ? indent : indent + 1, 0, this.contextPlus(context, 7));
                this.print(")", indent, "plain");
                break;
            }
            case 47: {
                this.decompile(tree.down(1), indent, 0, this.contextPlus(context, 3));
                this.print("(", indent, "plain");
                this.decompile(tree.down(3), indent, 0, this.contextPlus(context, 7));
                this.print(")", indent, "plain");
                break;
            }
            case 45: {
                if (!this.fortranStyle9x) {
                    Tree declarator;
                    int i;
                    Tree[] declarators;
                    if (ILUtils.isNotNoneNorVoid(tree.down(1))) {
                        this.decompile(tree.down(1), indent, 0, this.contextPlus(context, 3));
                        this.space();
                        declarators = tree.down(2).children();
                        for (i = 0; i < declarators.length; ++i) {
                            declarator = declarators[i];
                            if (declarator.opCode() == 14) {
                                declarator = declarator.down(1);
                            }
                            this.decompile(declarator, indent + 2, 0, this.contextPlus(context, 4));
                            if (i >= declarators.length - 1) continue;
                            this.print(", ", indent + 4, "plain");
                        }
                        this.newLine(indent);
                    }
                    this.print(KWPARAMETER, indent, "keyword");
                    this.print(" (", indent + 3, "plain");
                    declarators = tree.down(2).children();
                    for (i = 0; i < declarators.length; ++i) {
                        declarator = declarators[i];
                        Tree initTree = null;
                        if (declarator.opCode() == 14) {
                            initTree = declarator.down(2);
                            declarator = declarator.down(1);
                        }
                        if (declarator.opCode() == 11 || declarator.opCode() == 175) {
                            declarator = declarator.down(1);
                        }
                        this.decompile(declarator, indent + 3, 0, this.contextPlus(context, 4));
                        if (initTree != null) {
                            this.print("=", indent + 3, "plain");
                            if (initTree.opCode() == 71) {
                                this.print("(", indent, "plain");
                            }
                            this.decompile(initTree, indent + 3, 0, this.contextPlus(this.contextPlus(context, 7), 8));
                            if (initTree.opCode() == 71) {
                                this.print(")", indent, "plain");
                            }
                        }
                        if (i >= declarators.length - 1) continue;
                        this.print(", ", indent + 3, "plain");
                    }
                    this.print(")", indent + 4, "plain");
                    break;
                }
                if (ILUtils.isNotNone(tree.down(1))) {
                    this.decompile9xType(tree.down(1), indent, context);
                    this.space();
                    this.print("::", indent, "plain");
                    this.space();
                    this.decompile(tree.down(2), indent, 0, this.contextPlus(context, 4));
                    break;
                }
                this.print(KWPARAMETER, indent, "keyword");
                this.print(" (", indent + 3, "plain");
                this.decompile(tree.down(2), indent, 0, this.contextPlus(context, 4));
                this.print(")", indent + 4, "plain");
                break;
            }
            case 168: {
                this.print(KWRETURN, indent, "keyword");
                if (!ILUtils.isNotNone(tree.down(2))) break;
                this.space();
                this.decompile(tree.down(2), indent, 0, this.contextPlus(context, 7));
                break;
            }
            case 39: {
                this.print(KWCOMMON, indent, "keyword");
                this.space();
                if (ILUtils.isNotNone(tree.down(1))) {
                    this.printAtomValue(tree.down(1), this.allUC, indent, "vardecl");
                } else {
                    this.print("//", indent, "vardecl");
                }
                this.space();
                this.decompile(tree.down(2), indent, 0, this.contextPlus(context, 4));
                break;
            }
            case 109: {
                boolean parenthesis;
                this.printAtomValue(tree.down(1), !this.allLC, indent, "keyword");
                if (tree.down(1).opCode() == 96 && tree.down(1).stringValue().equals("pause")) {
                    this.space();
                }
                indent = this.posX - 6;
                Tree ioSpecs = tree.down(2);
                boolean bl = parenthesis = tree.down(1).opCode() != 96 || !tree.down(1).stringValue().equals("pause");
                if (ioSpecs.opCode() == 71 && ioSpecs.length() == 2 && ioSpecs.down(1).opCode() == 138) {
                    ioSpecs = ioSpecs.down(2);
                }
                if (ioSpecs.opCode() == 71) {
                    Tree[] sons = ioSpecs.children();
                    if (parenthesis) {
                        this.print("(", indent, "plain");
                    }
                    for (int i = 0; i < sons.length; ++i) {
                        this.decompileIOSpec(sons[i], i + 1, indent + 1, 0);
                        if (i >= sons.length - 1) continue;
                        this.print(", ", indent + 1, "plain");
                    }
                    if (parenthesis) {
                        this.print(")", indent, "plain");
                    }
                } else {
                    if (ioSpecs.opCode() != 177) {
                        this.print(" ", indent, "plain");
                    }
                    this.decompileIOSpec(ioSpecs, 2, indent, 0);
                    if (!ILUtils.isNullOrNoneOrEmptyList(tree.down(3))) {
                        this.print(",", indent, "plain");
                    }
                }
                this.space();
                this.decompile(tree.down(3), indent + 1, 0, this.contextPlus(context, 7));
                break;
            }
            case 134: {
                this.decompileIOSpec(tree, 0, indent, context);
                break;
            }
            case 9: {
                this.decompile(tree.down(1), indent, 0, context);
                this.print("(", indent, "plain");
                Tree[] expressions = tree.down(2).children();
                for (int i = expressions.length - 1; i >= 0; --i) {
                    this.decompile(expressions[i], indent, 0, this.contextPlus(this.contextPlus(context, 7), 8));
                    if (i <= 0) continue;
                    this.print(", ", indent, "plain");
                }
                this.print(")", indent, "plain");
                break;
            }
            case 96: {
                if (this.hasContext(context, 5) || this.isMarkedAsFunctionName(tree)) {
                    this.printAtomValue(tree, !this.allLC, indent, "funcname");
                    break;
                }
                if (this.hasContext(context, 3)) {
                    this.printAtomValueTypeName(tree, !this.allLC, indent);
                    break;
                }
                if (this.hasContext(context, 2)) {
                    this.printAtomValue(tree, this.allUC, indent, "modifier");
                    break;
                }
                if (this.hasContext(context, 4)) {
                    this.printAtomValue(tree, this.allUC, indent, "vardecl");
                    break;
                }
                if (this.hasContext(context, 6)) {
                    this.printAtomValue(tree, this.allUC, indent, "label");
                    break;
                }
                this.printAtomValue(tree, this.allUC, indent, "plain");
                break;
            }
            case 123: {
                this.print("METAVAR:", indent, "plain");
                this.printAtomValue(tree, false, indent, "label");
                break;
            }
            case 181: {
                Tree[] sons = tree.children();
                this.print("'", indent, "string");
                for (Tree son : sons) {
                    if (son.opCode() == 180) {
                        this.print(this.quote(son.stringValue()), 0, "string");
                        continue;
                    }
                    TapEnv.toolWarning(-1, "(Fortran decompiler) unexpected operator in strings " + son.opName());
                }
                this.print("'", indent, "string");
                break;
            }
            case 180: {
                if (this.hasContext(context, 1)) {
                    this.printComment(tree.stringValue());
                    break;
                }
                this.print("'" + this.quote(tree.stringValue()) + "'", indent, "string");
                break;
            }
            case 103: {
                int localPrecedence;
                if (this.hasContext(context, 6)) {
                    this.printAtomValue(tree, this.allUC, indent, "label");
                    break;
                }
                int n = localPrecedence = tree.intValue() < 0 ? 6 : 10;
                if (precedence > localPrecedence) {
                    this.print("(", indent, "plain");
                }
                this.printAtomValue(tree, this.allUC, indent, "constant");
                if (precedence <= localPrecedence) break;
                this.print(")", indent, "plain");
                break;
            }
            case 28: {
                this.printString("." + tree.stringValue() + ".", this.allUC, indent, "constant");
                break;
            }
            case 20: {
                this.printString(tree.stringValue(), this.allUC, indent, "constant");
                break;
            }
            case 160: {
                int localPrecedence;
                int n = localPrecedence = tree.stringValue().charAt(0) == '-' ? 6 : 10;
                if (precedence > localPrecedence) {
                    this.print("(", indent, "plain");
                }
                this.printAtomValue(tree, this.allUC, indent, "constant");
                if (precedence <= localPrecedence) break;
                this.print(")", indent, "plain");
                break;
            }
            case 85: {
                this.printAtomValue(tree, this.allUC, indent, "constant");
                break;
            }
            case 177: {
                this.print("*", indent, "keyword");
                break;
            }
            case 14: {
                if (precedence > 1) {
                    this.print("(", indent, "plain");
                }
                this.decompile(tree.down(1), indent, 2, this.contextPlus(context, 7));
                this.print(this.hasContext(context, 8) ? "=" : " = ", indent, "plain");
                if (tree.down(2).opCode() == 5) {
                    this.print("ALLOCATION_FORBIDDEN_HERE", indent, "plain");
                } else {
                    if (tree.down(2).opCode() == 71) {
                        this.print("(", indent + 1, "plain");
                    }
                    if (this.hasContext(context, 4)) {
                        context = this.contextPlus(context, 8);
                    }
                    this.decompile(tree.down(2), indent + 2, 1, this.contextPlus(context, 7));
                    if (tree.down(2).opCode() == 71) {
                        this.print(")", indent + 1, "plain");
                    }
                }
                if (precedence <= 1) break;
                this.print(")", indent, "plain");
                break;
            }
            case 152: {
                if (tree.down(2).opCode() == 5) {
                    this.print(KWALLOCATE, indent, "keyword");
                    this.print("(", indent, "keyword");
                    context = this.contextPlus(this.contextPlus(context, 8), 7);
                    this.decompile(tree.down(1), indent, 2, context);
                    if (!ILUtils.isNullOrNoneOrEmptyList(tree.down(2).down(2))) {
                        this.print("(", indent, "keyword");
                        this.decompile(ILUtils.reverseArrayComponentOrder(tree.down(2).down(2)), indent, 0, context);
                        this.print(")", indent, "keyword");
                    }
                    if (!ILUtils.isNullOrNone(tree.down(2).down(4))) {
                        this.print(", ", indent, "plain");
                        this.decompile(tree.down(2).down(4), indent, 0, context);
                    }
                    this.print(")", indent, "keyword");
                    break;
                }
                if (precedence > 1) {
                    this.print("(", indent, "plain");
                }
                this.decompile(tree.down(1), indent, 2, context);
                this.print(" => ", 0, "plain");
                this.decompile(tree.down(2), indent + 2, 1, this.contextPlus(context, 7));
                if (precedence <= 1) break;
                this.print(")", indent, "plain");
                break;
            }
            case 3: {
                this.decompileBinaryExpr(tree.down(1), tree.down(2), indent, precedence, context, "+", 7, 7, 8);
                break;
            }
            case 182: {
                this.decompileBinaryExpr(tree.down(1), tree.down(2), indent, precedence, context, "-", 7, 7, 8);
                break;
            }
            case 133: 
            case 167: {
                this.decompileBinaryExpr(tree.down(1), tree.down(2), indent, precedence, context, "*", 8, 8, 9);
                break;
            }
            case 62: {
                this.decompileBinaryExpr(tree.down(1), tree.down(2), indent, precedence, context, "/", 8, 8, 9);
                break;
            }
            case 155: {
                this.decompileBinaryExpr(tree.down(1), tree.down(2), indent, precedence, context, "**", 9, 10, 9);
                break;
            }
            case 68: {
                if (tree.getAnnotation("boolean") != null) {
                    this.decompileBinaryExpr(tree.down(1), tree.down(2), indent, precedence, context, ".EQV.", 3, 6, 7);
                    break;
                }
                this.decompileBinaryExpr(tree.down(1), tree.down(2), indent, precedence, context, ".EQ.", 6, 6, 7);
                break;
            }
            case 137: {
                if (tree.getAnnotation("boolean") != null) {
                    this.decompileBinaryExpr(tree.down(1), tree.down(2), indent, precedence, context, ".NEQV.", 3, 6, 7);
                    break;
                }
                this.decompileBinaryExpr(tree.down(1), tree.down(2), indent, precedence, context, ".NE.", 6, 6, 7);
                break;
            }
            case 92: {
                this.decompileBinaryExpr(tree.down(1), tree.down(2), indent, precedence, context, ".GE.", 6, 6, 7);
                break;
            }
            case 115: {
                this.decompileBinaryExpr(tree.down(1), tree.down(2), indent, precedence, context, ".LE.", 6, 6, 7);
                break;
            }
            case 95: {
                this.decompileBinaryExpr(tree.down(1), tree.down(2), indent, precedence, context, ".GT.", 6, 6, 7);
                break;
            }
            case 122: {
                this.decompileBinaryExpr(tree.down(1), tree.down(2), indent, precedence, context, ".LT.", 6, 6, 7);
                break;
            }
            case 6: {
                this.decompileBinaryExpr(tree.down(1), tree.down(2), indent, precedence, context, ".AND.", 4, 4, 5);
                break;
            }
            case 143: {
                this.decompileBinaryExpr(tree.down(1), tree.down(2), indent, precedence, context, ".OR.", 3, 5, 5);
                break;
            }
            case 207: {
                this.decompileBinaryExpr(tree.down(1), tree.down(2), indent, precedence, context, ".XOR.", 2, 5, 5);
                break;
            }
            case 43: {
                this.decompileBinaryExpr(tree.down(1), tree.down(2), indent, precedence, context, "//", 8, 8, 9);
                break;
            }
            case 44: {
                this.decompileBinaryExpr(tree.down(1), tree.down(2), indent, precedence, context, "", 8, 8, 9);
                break;
            }
            case 124: {
                if (tree.down(1).opCode() == 124) {
                    this.decompile(tree.down(1).down(1), indent, precedence, context);
                    break;
                }
                this.decompileUnaryExpr(tree.down(1), indent, precedence, context, "-", 7, 10);
                break;
            }
            case 139: {
                if (tree.down(1).opCode() == 139) {
                    this.decompile(tree.down(1).down(1), indent, precedence, context);
                    break;
                }
                this.decompileUnaryExpr(tree.down(1), indent, precedence, context, ".NOT.", 4, 5);
                break;
            }
            case 42: {
                this.print("(", indent, "plain");
                this.decompile(tree.down(1), indent, 0, context);
                this.print(",", indent, "plain");
                this.decompile(tree.down(2), indent, 0, context);
                this.print(")", indent, "plain");
                break;
            }
            case 10: {
                this.print("(/", indent, "plain");
                Tree[] sons = tree.children();
                for (int i = 0; i < sons.length; ++i) {
                    this.decompile(sons[i], indent, 0, this.contextPlus(this.contextPlus(context, 7), 8));
                    if (i >= sons.length - 1) continue;
                    this.print(", ", indent, "plain");
                }
                this.print("/)", indent, "plain");
                break;
            }
            case 12: {
                this.decompile(tree.down(1), indent, 0, this.contextPlus(this.contextPlus(context, 7), 8));
                this.print(":", indent, "plain");
                this.decompile(tree.down(2), indent, 0, this.contextPlus(this.contextPlus(context, 7), 8));
                if (!ILUtils.isNotNone(tree.down(3))) break;
                this.print(":", indent, "plain");
                this.decompile(tree.down(3), indent + 1, 0, context);
                break;
            }
            case 194: {
                String opStr = tree.down(1).stringValue();
                opStr = opStr + " ";
                if (this.allUC) {
                    opStr = opStr.toUpperCase();
                }
                if (tree.down(2).opCode() == 138) {
                    this.print(KWOPERATOR, indent, "keyword");
                    this.print("(", indent, "plain");
                    this.printString(opStr, true, indent, "plain");
                    this.print(")", indent, "plain");
                    break;
                }
                this.decompileUnaryExpr(tree.down(2), indent, precedence, context, opStr, 1, 1);
                break;
            }
            case 17: {
                String opStr = tree.down(2).stringValue();
                if (opStr.equals("add")) {
                    opStr = "+";
                } else if (opStr.equals("sub")) {
                    opStr = "-";
                } else if (opStr.equals("mul")) {
                    opStr = "*";
                } else if (opStr.equals("div")) {
                    opStr = "/";
                } else if (opStr.equals("assign")) {
                    opStr = "=";
                } else if (opStr.equals("ge")) {
                    opStr = ".GE.";
                } else if (opStr.equals("gt")) {
                    opStr = ".GT.";
                } else if (opStr.equals("le")) {
                    opStr = ".LE.";
                } else if (opStr.equals("lt")) {
                    opStr = ".LT.";
                } else if (this.allUC) {
                    opStr = opStr.toUpperCase();
                }
                if (tree.down(1).opCode() == 138 && tree.down(3).opCode() == 138) {
                    this.print(KWOPERATOR, indent, "keyword");
                    this.print("(", indent, "plain");
                    this.printString(opStr, true, indent, "plain");
                    this.print(")", indent, "plain");
                    break;
                }
                this.decompileBinaryExpr(tree.down(1), tree.down(3), indent, precedence, context, opStr, 1, 1, 1);
                break;
            }
            case 50: {
                this.print(KWCYCLE, indent, "keyword");
                if (!ILUtils.isNotNone(tree.down(1))) break;
                this.space();
                this.printAtomValue(tree.down(1), this.allUC, indent, "label");
                break;
            }
            case 70: {
                this.print(KWEXIT, indent, "keyword");
                if (!ILUtils.isNotNone(tree.down(1))) break;
                this.space();
                this.printAtomValue(tree.down(1), this.allUC, indent, "label");
                break;
            }
            case 51: {
                this.print(KWDATA, indent, "keyword");
                this.space();
                this.decompile(tree.down(1), indent + 4, 0, 0);
                this.print(" /", indent + 3, "plain");
                this.decompile(tree.down(2), indent + 5, 0, this.contextPlus(this.contextPlus(this.contextPlus(context, 7), 13), 8));
                this.print("/", indent + 4, "plain");
                break;
            }
            case 135: {
                this.print(KWNAMELIST, indent, "keyword");
                this.space();
                this.print("/", indent + 3, "plain");
                this.decompile(tree.down(1), indent + 4, 0, 0);
                this.print("/ ", indent + 5, "plain");
                this.decompile(tree.down(2), indent + 4, 0, this.contextPlus(this.contextPlus(context, 7), 8));
                break;
            }
            case 75: {
                this.decompile(tree.down(1), indent, 0, context);
                this.print("%", indent, "plain");
                this.printAtomValue(tree.down(2), this.allUC, indent, "plain");
                break;
            }
            case 151: {
                this.decompile(tree.down(1), indent, precedence, context);
                break;
            }
            case 84: {
                Tree[] sons = tree.down(2).children();
                this.printLabel(tree.down(1).stringValue());
                this.print(KWFORMAT, indent, "keyword");
                this.print("(", indent, "plain");
                for (int i = 0; i < sons.length; ++i) {
                    if (i > 0 && sons[i - 1].opCode() != 85 && sons[i].opCode() != 85) {
                        this.print(" ", indent, "plain");
                    }
                    this.decompile(sons[i], indent + 7, 0, 0);
                }
                this.print(")", indent + 6, "plain");
                break;
            }
            case 193: {
                this.decompile(tree.down(1), indent, 0, this.contextPlus(context, 3));
                this.print(" (", indent, "plain");
                this.decompile(tree.down(2), indent, 0, 0);
                this.print(")", indent, "plain");
                break;
            }
            case 119: {
                this.printAtomValue(tree.down(1), this.allUC, indent, "plain");
                this.print("-", indent, "plain");
                this.printAtomValue(tree.down(2), this.allUC, indent, "plain");
                break;
            }
            case 118: {
                this.printAtomValue(tree, this.allUC, indent, "plain");
                break;
            }
            case 110: {
                this.print("(", indent, "plain");
                this.decompile(tree.down(1), indent, 0, this.contextPlus(this.contextPlus(context, 7), 8));
                this.print(", ", indent, "plain");
                this.decompile(tree.down(2), indent, 0, 0);
                this.print(")", indent, "plain");
                break;
            }
            case 111: {
                this.printAtomValue(tree, this.allUC, indent, "label");
                break;
            }
            case 178: {
                this.decompile(tree.down(1), indent, 0, this.contextPlus(this.contextPlus(context, 5), 7));
                this.print(" = ", 0, "plain");
                this.decompile(tree.down(2), indent + 2, 0, this.contextPlus(context, 7));
                break;
            }
            case 183: {
                this.decompile(tree.down(1), indent, 0, context);
                this.print("(", indent, "plain");
                this.decompile(tree.down(2), indent, 0, this.contextPlus(this.contextPlus(context, 7), 8));
                this.print(":", indent, "plain");
                this.decompile(tree.down(2), indent, 0, this.contextPlus(this.contextPlus(context, 7), 8));
                this.print(")", indent, "plain");
                break;
            }
            case 138: {
                break;
            }
            case 16: {
                boolean isOmp = ILUtils.isIdent(tree.down(1), "omp", false);
                String oldContinuationChar = null;
                this.printComment("$");
                this.posX += this.commentChar.length() + 1;
                this.decompile(tree.down(1), this.posX - 6, 0, 0);
                this.printer.space(1);
                ++this.posX;
                if (isOmp) {
                    oldContinuationChar = this.continuationChar;
                    this.continuationChar = this.commentChar + "$OMP" + this.continuationChar;
                }
                this.print("ATOMIC", indent, "comment");
                this.printer.space(1);
                this.decompile(tree.down(2), this.posX - 11, 0, 65536);
                this.newLine(indent);
                if (isOmp) {
                    this.continuationChar = oldContinuationChar;
                }
                this.decompile(tree.down(3), indent, 0, context);
                break;
            }
            case 145: {
                boolean isOmp = ILUtils.isIdent(tree.down(1), "omp", false);
                Tree uniqueParallelLoopInside = this.getSimpleParallelLoop(tree.down(3));
                String oldContinuationChar = null;
                if (uniqueParallelLoopInside != null) {
                    this.printComment("$");
                    this.posX += this.commentChar.length() + 1;
                    this.decompile(tree.down(1), this.posX - 6, 0, 0);
                    this.printer.space(1);
                    ++this.posX;
                    if (isOmp) {
                        oldContinuationChar = this.continuationChar;
                        this.continuationChar = this.commentChar + "$OMP" + this.continuationChar;
                    }
                    this.print("PARALLEL DO", indent, "comment");
                    this.printer.space(1);
                    this.decompile(tree.down(2), this.posX - 15, 0, isOmp ? 65536 : 0);
                    if (!ILUtils.isNullOrNoneOrEmptyList(uniqueParallelLoopInside.down(2))) {
                        if (!ILUtils.isNullOrNoneOrEmptyList(tree.down(2))) {
                            this.print(",", indent, "plain");
                            this.printer.space(1);
                        }
                        this.decompile(uniqueParallelLoopInside.down(2), this.posX - 15, 0, isOmp ? 65536 : 0);
                    }
                    this.newLine(indent);
                    if (isOmp) {
                        this.continuationChar = oldContinuationChar;
                    }
                    this.decompile(uniqueParallelLoopInside.down(3), indent, 0, context);
                    break;
                }
                this.printComment("$");
                this.posX += this.commentChar.length() + 1;
                this.decompile(tree.down(1), this.posX - 6, 0, 0);
                this.printer.space(1);
                ++this.posX;
                if (isOmp) {
                    oldContinuationChar = this.continuationChar;
                    this.continuationChar = this.commentChar + "$OMP" + this.continuationChar;
                }
                this.print("PARALLEL", indent, "comment");
                this.printer.space(1);
                this.decompile(tree.down(2), this.posX - 11, 0, 65536);
                this.newLine(indent);
                if (isOmp) {
                    this.continuationChar = oldContinuationChar;
                }
                this.decompile(tree.down(3), indent, 0, context);
                this.newLine(indent);
                this.printComment("$");
                this.posX += this.commentChar.length() + 1;
                this.decompile(tree.down(1), this.posX - 6, 0, 0);
                this.printer.space(1);
                ++this.posX;
                this.print("END PARALLEL", indent, "comment");
                break;
            }
            case 144: {
                boolean isOmp = ILUtils.isIdent(tree.down(1), "omp", false);
                this.printComment("$");
                this.posX += this.commentChar.length() + 1;
                this.decompile(tree.down(1), this.posX - 6, 0, 0);
                this.printer.space(1);
                ++this.posX;
                String oldContinuationChar = null;
                if (isOmp) {
                    oldContinuationChar = this.continuationChar;
                    this.continuationChar = this.commentChar + "$OMP" + this.continuationChar;
                }
                this.print(KWDO, indent, "comment");
                this.printer.space(1);
                this.decompile(tree.down(2), this.posX - 11, 0, isOmp ? 65536 : 0);
                this.newLine(indent);
                if (isOmp) {
                    this.continuationChar = oldContinuationChar;
                }
                this.decompile(tree.down(3), indent, 0, context);
                break;
            }
            case 61: {
                this.printComment("$");
                this.posX += this.commentChar.length() + 1;
                this.decompile(tree.down(1), this.posX - 6, 0, 0);
                boolean isOmp = ILUtils.isIdent(tree.down(1), "omp", false);
                this.printer.space(1);
                ++this.posX;
                String oldContinuationChar = null;
                if (isOmp) {
                    oldContinuationChar = this.continuationChar;
                    this.continuationChar = this.commentChar + "$OMP" + this.continuationChar;
                }
                this.decompile(tree.down(2), this.posX - 11, 0, isOmp ? 65536 : 0);
                if (!isOmp) break;
                this.continuationChar = oldContinuationChar;
                break;
            }
            case 184: {
                if (this.fortranStyle9x) {
                    this.print(KWSELECT, indent, "keyword");
                    this.space();
                    this.print(KWCASE, indent, "keyword");
                    this.space();
                } else {
                    this.print(KWSELECTCASE, indent, "keyword");
                }
                this.print(" (", indent, "plain");
                this.decompile(tree.down(1), indent, 0, this.contextPlus(context, 7));
                this.print(") ", indent, "plain");
                this.newLine(indent);
                this.decompile(tree.down(2), indent, 0, this.contextPlus(context, 7));
                this.newLine(indent);
                if (this.fortranStyle9x) {
                    this.print(KWEND, indent, "keyword");
                    this.space();
                    this.print(KWSELECT, indent, "keyword");
                    break;
                }
                this.print(KWENDSELECT, indent, "keyword");
                break;
            }
            case 185: {
                if (tree.down(2).length() == 0 && tree.down(1).length() == 0) break;
                if (tree.down(2).length() == 0 && tree.rankInParent() != 1) {
                    this.newLine(indent);
                }
                this.print(KWCASE, indent, "keyword");
                this.space();
                if (tree.down(1).length() != 0) {
                    this.print("(", indent, "plain");
                    this.decompile(tree.down(1), indent, 0, this.contextPlus(context, 7));
                    this.print(") ", indent, "plain");
                } else {
                    this.print(KWDEFAULT, indent, "keyword");
                }
                this.newLine(indent);
                this.decompile(tree.down(2), indent + 2, 0, 32768);
                break;
            }
            case 153: {
                this.decompile(tree.down(1), indent, 0, context);
                break;
            }
            case 4: {
                this.print("C_LOC(", indent, "plain");
                this.decompile(tree.down(1), indent, precedence, context);
                this.print(")", indent, "plain");
                break;
            }
            case 197: {
                this.print(KWUSE, indent, "keyword");
                this.space();
                this.decompile(tree.down(1), indent, precedence, this.contextPlus(context, 5));
                if (ILUtils.isNullOrNone(tree.down(2)) || tree.down(2).opCode() != 142 && tree.down(2).length() == 0) break;
                this.print(",", indent, "plain");
                this.space();
                this.decompile(tree.down(2), indent, precedence, context);
                break;
            }
            case 166: {
                Tree[] sons = tree.children();
                for (int i = 0; i < sons.length; ++i) {
                    this.decompile(sons[i], indent, 0, context);
                    if (i >= sons.length - 1) continue;
                    this.print(",", indent, "plain");
                    this.space();
                }
                break;
            }
            case 165: {
                boolean isOperatorDef = ILUtils.isAFortranOverloadedOperator(tree.down(1));
                if (isOperatorDef) {
                    this.print(KWOPERATOR, indent, "keyword");
                    this.print("(", indent, "plain");
                }
                this.decompile(tree.down(1), indent, precedence, context);
                if (isOperatorDef) {
                    this.print(")", indent, "plain");
                }
                this.space();
                this.print("=>", indent, "plain");
                this.space();
                if (isOperatorDef) {
                    this.print(KWOPERATOR, indent, "keyword");
                    this.print("(", indent, "plain");
                }
                this.decompile(tree.down(2), indent, precedence, context);
                if (!isOperatorDef) break;
                this.print(")", indent, "plain");
                break;
            }
            case 142: {
                Tree[] sons = tree.children();
                this.print(KWONLY, indent, "keyword");
                this.space();
                this.print(":", indent, "plain");
                this.space();
                for (int i = 0; i < sons.length; ++i) {
                    boolean isOperatorDefI = ILUtils.isAFortranOverloadedOperator(sons[i]);
                    if (isOperatorDefI) {
                        if (sons[i].opCode() == 14) {
                            this.print(KWASSIGNMENT, indent, "keyword");
                        } else {
                            this.print(KWOPERATOR, indent, "keyword");
                        }
                        this.print("(", indent, "plain");
                    }
                    this.decompile(sons[i], indent, 0, context);
                    if (isOperatorDefI) {
                        this.print(")", indent, "plain");
                    }
                    if (i >= sons.length - 1) continue;
                    this.print(",", indent, "plain");
                    this.space();
                }
                break;
            }
            case 106: {
                boolean hasAbstractMark;
                boolean bl = hasAbstractMark = ILUtils.isNotNone(tree.down(1)) && tree.down(1).opCode() == 1;
                if (hasAbstractMark) {
                    this.print(KWABSTRACT, indent, "keyword");
                    this.space();
                }
                this.print(KWINTERFACE, indent, "keyword");
                this.space();
                if (ILUtils.isNotNone(tree.down(1)) && !hasAbstractMark) {
                    if (tree.down(1).isAtom()) {
                        this.printAtomValue(tree.down(1), !this.allLC, indent, "funcname");
                    } else if (tree.down(1).opCode() == 14) {
                        this.print(KWASSIGNMENT, indent, "keyword");
                        this.print("(", indent, "keyword");
                        this.print("=", indent, "keyword");
                        this.print(")", indent, "keyword");
                    } else {
                        boolean isAOp = ILUtils.isAFortranOverloadedOperator(tree.down(1));
                        if (isAOp) {
                            this.print(KWOPERATOR, indent, "keyword");
                            this.print("(", indent, "keyword");
                        }
                        this.decompile(tree.down(1), indent, precedence, context);
                        if (isAOp) {
                            this.print(")", indent, "keyword");
                        }
                    }
                }
                this.newLine(indent);
                this.decompile(tree.down(2), indent + 4, precedence, context);
                this.newLine(indent);
                this.print(KWEND, indent, "keyword");
                this.space();
                this.print(KWINTERFACE, indent, "keyword");
                if (ILUtils.isNotNone(tree.down(3))) {
                    this.space();
                    if (tree.down(3).isAtom()) {
                        this.printAtomValue(tree.down(3), !this.allLC, indent, "funcname");
                    }
                }
                this.newLine(indent);
                break;
            }
            case 107: {
                Tree[] sons = tree.children();
                for (int i = 0; i < sons.length; ++i) {
                    this.decompile(sons[i], indent, 0, context);
                    if (i >= sons.length - 1) continue;
                    this.newLine(indent);
                }
                break;
            }
            case 132: {
                Tree[] sons = tree.children();
                this.print(KWMODULE, indent, "keyword");
                this.space();
                this.print(KWPROCEDURE, indent, "keyword");
                this.space();
                for (int i = 0; i < sons.length; ++i) {
                    this.decompile(sons[i], indent, 0, this.contextPlus(context, 5));
                    if (i >= sons.length - 1) continue;
                    this.print(",", indent, "plain");
                    this.space();
                }
                break;
            }
            case 105: {
                this.decompile(tree.down(1), indent, precedence, this.contextPlus(context, 11));
                break;
            }
            case 2: {
                String modifier;
                if (tree.down(1).opCode() == 2 && tree.down(2).opCode() != 192) {
                    this.decompile(tree.down(1), indent, 0, context);
                    this.space();
                    this.print("::", indent, "plain");
                    this.space();
                    this.decompile(tree.down(2), indent + 2, 0, context);
                    break;
                }
                if (tree.down(2).opCode() == 192) {
                    this.print(KWTYPE, indent, "keyword");
                    this.print(",", indent, "plain");
                    this.space();
                    if (tree.down(1).opCode() == 2) {
                        this.decompile(tree.down(1), indent, 0, context);
                    } else {
                        String modifierText = tree.down(1).stringValue();
                        if (!this.allLC) {
                            modifierText = modifierText.toUpperCase();
                        }
                        this.printString(modifierText, true, indent, "plain");
                    }
                    this.space();
                    this.print("::", indent, "plain");
                    this.space();
                    tree = tree.down(2);
                    this.decompile(tree.down(1), indent + 1, 0, this.contextPlus(context, 3));
                    this.newLine(indent);
                    if (!this.fortranStyle9x) {
                        this.decompile(tree.down(2), indent + 2, 0, this.contextPlus(context, 3));
                        this.print(KWENDTYPE, indent, "keyword");
                    } else {
                        this.decompile(tree.down(2), indent + 4, 0, this.contextPlus(context, 3));
                        if (tree.down(2).opCode() != 161) {
                            this.newLine(indent);
                        }
                        this.print(KWEND, indent, "keyword");
                        this.space();
                        this.print(KWTYPE, indent, "keyword");
                        this.space();
                        this.printAtomValue(tree.down(1), !this.allLC, indent, "plain");
                    }
                    if (tree.down(2).opCode() == 161) break;
                    TapEnv.toolWarning(-1, "(Fortran decompiler) undefined type: " + tree.down(1).stringValue());
                    break;
                }
                String modifierText = modifier = tree.down(1).stringValue();
                if (modifier.equals("in") || modifier.equals("out") || modifier.equals("inout")) {
                    if (!this.allLC) {
                        modifierText = modifier.toUpperCase();
                    }
                    modifierText = "INTENT(" + modifierText + ')';
                }
                this.printString(modifierText, true, indent, "plain");
                Tree[] sons = tree.down(2).children();
                if (modifier.equals("bind")) {
                    this.print("(", indent, "plain");
                    context = this.contextPlus(context, 14);
                } else {
                    this.space();
                    if (sons.length != 0) {
                        this.print("::", indent, "plain");
                        this.space();
                    }
                }
                for (int i = 0; i < sons.length; ++i) {
                    boolean hasAnnot;
                    boolean bl = hasAnnot = sons[i].opCode() != 138 && sons[i].opCode() != 17 && !sons[i].isAtom() && sons[i].down(1).opCode() == 138;
                    if (hasAnnot) {
                        if (sons[i].opCode() == 14) {
                            this.print(KWASSIGNMENT, indent, "keyword");
                        } else {
                            this.print(KWOPERATOR, indent, "keyword");
                        }
                        this.print("(", indent, "plain");
                    }
                    this.decompile(sons[i], indent, 0, this.contextPlus(context, 8));
                    if (hasAnnot) {
                        this.print(")", indent, "plain");
                    }
                    if (i >= sons.length - 1) continue;
                    this.print(", ", indent, "plain");
                }
                if (!modifier.equals("bind")) break;
                this.print(")", indent, "plain");
                context = this.contextMinus(context, 14);
                break;
            }
            case 140: {
                this.print(KWNULLIFY, indent, "keyword");
                this.print("(", indent, "keyword");
                this.decompile(tree.down(1), indent, 2, context);
                this.print(")", indent, "keyword");
                break;
            }
            case 52: {
                this.print(KWDEALLOCATE, indent, "keyword");
                this.print("(", indent, "keyword");
                context = this.contextPlus(context, 7);
                this.decompile(tree.down(1), indent, 2, context);
                if (tree.down(2).opCode() != 138) {
                    this.print(", ", indent + 1, "plain");
                    this.decompile(tree.down(2), indent, 2, context);
                }
                this.print(")", indent, "keyword");
                break;
            }
            case 126: {
                this.print(KWMOD, indent, "keyword");
                this.print("(", indent, "keyword");
                this.decompile(tree.down(1), indent, 2, context);
                this.print(", ", indent + 1, "plain");
                this.decompile(tree.down(2), indent, 2, context);
                this.print(")", indent, "keyword");
                break;
            }
            case 90: 
            case 91: {
                this.decompile(tree.down(1), indent, 2, context);
                break;
            }
            case 30: {
                this.print(KWEXIT, indent, "keyword");
                break;
            }
            case 104: {
                this.print(this.allLC ? "integer" : "INTEGER", indent, "typename");
                break;
            }
            case 78: {
                this.print(this.allLC ? "real" : "REAL", indent, "typename");
                break;
            }
            case 41: {
                this.print(this.allLC ? "complex" : "COMPLEX", indent, "typename");
                break;
            }
            case 29: {
                this.print(this.allLC ? "logical" : "LOGICAL", indent, "typename");
                break;
            }
            case 35: {
                this.print(this.allLC ? "character" : "CHARACTER", indent, "typename");
                break;
            }
            case 141: {
                this.print(this.allLC ? "num_threads" : "NUM_THREADS", indent, "comment");
                this.print("(", indent, "comment");
                this.decompile(tree.down(1), indent, 2, context);
                this.print(")", indent, "comment");
                break;
            }
            case 172: {
                this.print(this.allLC ? "schedule" : "SCHEDULE", indent, "comment");
                this.print("(", indent, "comment");
                this.decompile(tree.down(1), indent, 2, context);
                this.print(")", indent, "comment");
                break;
            }
            case 174: {
                this.print(this.allLC ? "shared" : "SHARED", indent, "comment");
                this.print("(", indent, "comment");
                this.decompile(tree.down(1), indent, 2, context);
                this.print(")", indent, "comment");
                break;
            }
            case 157: {
                this.print(this.allLC ? "private" : "PRIVATE", indent, "comment");
                this.print("(", indent, "comment");
                this.decompile(tree.down(1), indent, 2, context);
                this.print(")", indent, "comment");
                break;
            }
            case 77: {
                this.print(this.allLC ? "firstprivate" : "FIRSTPRIVATE", indent, "comment");
                this.print("(", indent, "comment");
                this.decompile(tree.down(1), indent, 2, context);
                this.print(")", indent, "comment");
                break;
            }
            case 114: {
                this.print(this.allLC ? "lastprivate" : "LASTPRIVATE", indent, "comment");
                this.print("(", indent, "comment");
                this.decompile(tree.down(1), indent, 2, context);
                this.print(")", indent, "comment");
                break;
            }
            case 162: {
                this.print(this.allLC ? "reduction" : "REDUCTION", indent, "comment");
                this.print("(", indent, "comment");
                this.decompile(tree.down(1), indent, 2, context);
                this.print(":", indent, "comment");
                this.decompile(tree.down(2), indent, 2, context);
                this.print(")", indent, "comment");
                break;
            }
            default: {
                TapEnv.toolWarning(-1, "(Fortran decompiler) unexpected operator: " + tree.opName() + " IN " + tree.parent());
                Tree[] subTrees = tree.children();
                this.print(" [UNEXPECTED:" + tree.opName(), indent, "keyword");
                if (subTrees != null && tree.length() != 0) {
                    for (Tree subTree : subTrees) {
                        this.print(" | ", indent, "keyword");
                        this.decompile(subTree, indent, 0, context);
                    }
                }
                this.print("] ", indent, "keyword");
                break;
            }
        }
        this.postDecompile(tree, indent);
    }

    private void decompile9xType(Tree tree, int indent, int context) throws IOException {
        boolean nonPrimitive;
        boolean bl = nonPrimitive = tree.opCode() == 96;
        if (nonPrimitive) {
            this.print("TYPE(", indent, "keyword");
        }
        this.decompile(tree, indent, 0, this.contextPlus(context, 3));
        if (nonPrimitive) {
            this.print(")", indent, "keyword");
        }
    }

    private void decompileBinaryExpr(Tree leftTree, Tree rightTree, int indent, int curPrecedence, int context, String op, int maxPrecedence, int leftPrecedence, int rightPrecedence) throws IOException {
        if (curPrecedence >= 8 || maxPrecedence >= 8) {
            context = this.contextPlus(context, 8);
        }
        context = this.contextPlus(context, 7);
        if (curPrecedence > maxPrecedence) {
            this.print("(", indent, "plain");
        }
        this.decompile(leftTree, indent, leftPrecedence, context);
        if (!this.hasContext(context, 8) && leftTree.opCode() != 138) {
            this.space();
        }
        this.print(op, indent, "plain");
        if (!this.hasContext(context, 8) && rightTree.opCode() != 138) {
            this.space();
        }
        this.decompile(rightTree, indent, rightPrecedence, context);
        if (curPrecedence > maxPrecedence) {
            this.print(")", indent, "plain");
        }
    }

    private void decompileUnaryExpr(Tree subTree, int indent, int curPrecedence, int context, String op, int maxPrecedence, int sonPrecedence) throws IOException {
        if (curPrecedence >= 8 || maxPrecedence >= 8) {
            context = this.contextPlus(context, 8);
        }
        context = this.contextPlus(context, 7);
        boolean inDataCtx = this.hasContext(context, 13);
        if (curPrecedence > maxPrecedence && !inDataCtx) {
            this.print("(", indent, "plain");
        }
        this.print(op, indent, "plain");
        this.decompile(subTree, indent, sonPrecedence, context);
        if (curPrecedence > maxPrecedence && !inDataCtx) {
            this.print(")", indent, "plain");
        }
    }

    private void decompileIOSpec(Tree ioSpec, int rank, int indent, int context) throws IOException {
        if (rank == 2) {
            context = this.contextPlus(context, 6);
        }
        if (ioSpec.opCode() == 134) {
            boolean inBindCCtx;
            String key = ioSpec.down(1).stringValue();
            this.print(key, indent, "keyword");
            this.print("=", indent, "plain");
            context = key.equals("err") || key.equals("end") || key.equals("fmt") ? this.contextPlus(context, 6) : this.contextPlus(context, 7);
            ioSpec = ioSpec.down(2);
            if (ioSpec.opCode() == 96 && (inBindCCtx = this.hasContext(context, 14))) {
                ioSpec = ILUtils.build(180, ioSpec.stringValue());
                context = this.contextMinus(context, 14);
            }
        }
        if (ioSpec.opCode() == 71 && this.allStringCst(ioSpec.children())) {
            Tree[] strings = ioSpec.children();
            for (int i = 0; i < strings.length; ++i) {
                String oneString = this.quote(strings[i].stringValue());
                if (i == 0) {
                    oneString = "'" + oneString;
                }
                if (i == strings.length - 1) {
                    oneString = oneString + "'";
                }
                this.print(oneString, indent, "string");
            }
        } else {
            this.decompile(ioSpec, indent, 0, this.contextPlus(context, 8));
        }
    }

    private boolean allStringCst(Tree[] strings) {
        boolean ok = true;
        for (int i = strings.length - 1; ok && i >= 0; --i) {
            ok = strings[i].opCode() == 180;
        }
        return ok;
    }

    private boolean isSingleMergeableIf(Tree tree) {
        int opCode = tree.opCode();
        if (opCode == 27) {
            return tree.length() == 1 && this.isSingleMergeableIf(tree.down(1));
        }
        return opCode == 98;
    }

    private boolean isSingleMergeableWhere(Tree tree) {
        boolean result;
        int opCode = tree.opCode();
        if (opCode == 27) {
            result = tree.length() == 1 && this.isSingleMergeableWhere(tree.down(1));
        } else {
            boolean bl = result = opCode == 205;
            if (result && !ILUtils.isNullOrNone(tree.down(4))) {
                Tree upperWhere = this.findUpperWhereWithSameLabel(tree, tree.down(4).stringValue());
                result = upperWhere != null;
            }
        }
        return result;
    }

    private Tree findUpperWhereWithSameLabel(Tree tree, String label) {
        Tree result = null;
        for (Tree father = tree.parent(); father != null && result == null; father = father.parent()) {
            if (father.opCode() != 205 || ILUtils.isNullOrNone(father.down(4)) || !father.down(4).stringValue().equals(label)) continue;
            result = father;
        }
        return result;
    }

    private boolean isMarkedAsFunctionName(Tree tree) {
        Boolean isFunctionNameAnnot = (Boolean)tree.getAnnotation("isFunctionName");
        return isFunctionNameAnnot != null && isFunctionNameAnnot != false;
    }

    private Tree isSimpleExpr(Tree tree) {
        while (tree.opCode() == 27 && tree.length() == 1 && this.hasNoAttachedComments(tree)) {
            tree = tree.down(1);
        }
        int opCode = tree.opCode();
        if (opCode != 138 && this.hasNoAttachedComments(tree) && (TapIntList.contains(this.expressionPhylum, tree.opCode()) || opCode == 14 || opCode == 31 || opCode == 30 || opCode == 49 || opCode == 168 || opCode == 188 || opCode == 70 || opCode == 50 || opCode == 179 || opCode == 93 || opCode == 94 || opCode == 15 || opCode == 40 || opCode == 109)) {
            return tree;
        }
        return null;
    }

    private Tree getSimpleParallelLoop(Tree tree) {
        if (tree != null && tree.opCode() == 27) {
            if (tree.length() != 1) {
                return null;
            }
            tree = tree.down(1);
        }
        if (tree != null && tree.opCode() == 144) {
            return tree;
        }
        return null;
    }

    private boolean hasNoAttachedComments(Tree tree) {
        return tree.getAnnotation("preComments") == null && tree.getAnnotation("preCommentsBlock") == null && tree.getAnnotation("postComments") == null && tree.getAnnotation("postCommentsBlock") == null;
    }

    private String sortModifiers(Tree tree, TapList<Tree> modifiersBefore, TapList<Tree> typeSuffixes, TapList<Tree> modifiersAfter) {
        String basisTypeName;
        switch (tree.down(2).opCode()) {
            case 104: {
                basisTypeName = "integer";
                break;
            }
            case 78: {
                basisTypeName = "real";
                break;
            }
            case 41: {
                basisTypeName = "complex";
                break;
            }
            case 29: {
                basisTypeName = "logical";
                break;
            }
            case 35: {
                basisTypeName = "character";
                break;
            }
            case 96: {
                basisTypeName = tree.down(2).stringValue();
                if (basisTypeName == null) {
                    basisTypeName = "UNKNOWNTYPE";
                    break;
                }
                if (!this.fortranStyle9x) break;
                basisTypeName = "TYPE(" + basisTypeName + ')';
                break;
            }
            default: {
                basisTypeName = null;
            }
        }
        Tree[] modifiers = tree.down(1).children();
        block13: for (int i = modifiers.length - 1; i >= 0; --i) {
            Tree modifierTree = modifiers[i];
            switch (modifierTree.opCode()) {
                case 60: {
                    modifiersAfter.head = modifierTree;
                    continue block13;
                }
                case 177: {
                    typeSuffixes.placdl(modifierTree);
                    continue block13;
                }
                case 103: {
                    assert (basisTypeName != null);
                    if (basisTypeName.equals("integer") || basisTypeName.equals("real") || basisTypeName.equals("complex") || basisTypeName.equals("character")) {
                        basisTypeName = basisTypeName + "*" + modifierTree.stringValue();
                        continue block13;
                    }
                    typeSuffixes.placdl(modifierTree);
                    continue block13;
                }
                default: {
                    String modifierText = ILUtils.toString(modifierTree);
                    if (modifierText == null || modifierText.isEmpty()) continue block13;
                    if (modifierText.equals("constant")) {
                        modifierText = "parameter";
                        modifierTree = ILUtils.build(96, modifierText);
                    }
                    if (this.fortranStyle9x && (modifierText.equals("external") || modifierText.equals("extern") || modifierText.equals("intrinsic") || modifierText.equals("save")) || modifierText.equals("parameter") || modifierText.equals("target") || modifierText.equals("pointer") || modifierText.equalsIgnoreCase("public") || modifierText.equalsIgnoreCase("private") || modifierText.equals("allocatable") || modifierText.equals("optional") || modifierText.equals("in") || modifierText.equals("out") || modifierText.equals("inout") || modifierText.equals("value") || modifierText.equals("volatile") || modifierText.equals("contiguous") || modifierText.startsWith("bind")) {
                        modifiersAfter.placdl(modifierTree);
                        continue block13;
                    }
                    if (basisTypeName != null && basisTypeName.equals("real") && modifierText.equals("double")) {
                        basisTypeName = "double precision";
                        continue block13;
                    }
                    if (basisTypeName != null && basisTypeName.equals("complex") && modifierText.equals("double")) {
                        basisTypeName = "double complex";
                        continue block13;
                    }
                    if (!(modifierTree.opCode() == 96 && (this.fortranStyle9x && (modifierText.equals("signed") || modifierText.equals("unsigned") || modifierText.equals("short") || modifierText.equals("long") || modifierText.equals("double") || modifierText.equals("const") || modifierText.equals("auto") || modifierText.equals("sequence")) || this.language == 1 && (modifierText.equals("double") || modifierText.equals("external") || modifierText.equals("extern"))))) {
                        typeSuffixes.placdl(modifierTree);
                        continue block13;
                    }
                    if (!this.fortranStyle9x) {
                        if (modifierTree.opCode() != 96) continue block13;
                        modifiersBefore.placdl(modifierTree);
                        continue block13;
                    }
                    TapEnv.toolWarning(-1, "(Fortran decompiler) dropped modifier: " + modifierTree);
                }
            }
        }
        return basisTypeName;
    }

    private void printAtomValueTypeName(Tree atomTree, boolean forceUpperCase, int indent) throws IOException {
        String atomValueString = atomTree.stringValue();
        if (atomValueString == null) {
            atomValueString = "UNKNOWNTYPE";
        }
        if (forceUpperCase) {
            this.print(atomValueString.toUpperCase(), indent, "typename");
        } else {
            this.print(atomValueString, indent, "typename");
        }
    }

    @Override
    protected void tryFlushComments(int indent, boolean prefix) throws IOException {
        if (this.posX == 0) {
            while (this.waitingComments != null) {
                this.printComment((String)this.waitingComments.head);
                this.printer.newLine();
                this.posX = 0;
                ++this.posY;
                this.waitingComments = this.waitingComments.tail;
            }
        }
    }

    private void printComment(String text) throws IOException {
        int length = text.length();
        if (length > 128) {
            this.printOneCommentLine(text.substring(0, 128));
            this.printer.newLine();
            this.printComment(text.substring(128));
        } else {
            this.printOneCommentLine(text);
        }
    }

    private void printOneCommentLine(String text) throws IOException {
        this.printer.printText(this.commentChar, "comment");
        this.printer.printText(text, "comment");
    }

    private void printLabel(String label) throws IOException {
        if (label.length() >= 5) {
            this.printer.printText(label, "label");
            this.posX = label.length();
        } else {
            this.printer.space(1);
            this.printer.printText(label, "label");
            this.posX = label.length() + 1;
        }
        if (this.fortranStyle9x) {
            this.space();
        }
    }

    private String quote(String str) {
        StringBuilder strBuf = new StringBuilder(str);
        for (int i = 0; i < strBuf.length(); ++i) {
            if (strBuf.charAt(i) != '\'') continue;
            strBuf.insert(i + 1, '\'');
            ++i;
        }
        return strBuf.toString();
    }

    private void printAtomValue(Tree atomTree, boolean forceUpperCase, int indent, String kind) throws IOException {
        String atomValueString = atomTree.stringValue();
        this.printString(atomValueString, forceUpperCase, indent, kind);
    }

    private void printString(String atomValueString, boolean forceUpperCase, int indent, String kind) throws IOException {
        if (atomValueString != null) {
            if (forceUpperCase) {
                this.print(atomValueString.toUpperCase(), indent, kind);
            } else {
                this.print(atomValueString, indent, kind);
            }
        } else {
            this.print("Error:nullTree", indent, kind);
        }
    }
}

