/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.prettyprint;

import fr.inria.tapenade.prettyprint.Decompiler;
import fr.inria.tapenade.prettyprint.Printer;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.utils.Tree;
import java.io.IOException;
import java.util.HashMap;

public final class DotDecompiler
extends Decompiler {
    private final HashMap<Tree, Integer> map = new HashMap();
    private int lastID = 0;

    public DotDecompiler(Printer printer, String htmlMsgName) {
        super(printer, htmlMsgName);
    }

    private void decompile(Tree tree) {
        if (tree != null) {
            try {
                this.print("digraph IL {", "init");
                this.newLine();
                this.decompileSons(tree);
                this.print("}", "init");
                this.newLine();
            }
            catch (IOException e) {
                TapEnv.systemError("(Decompiler) I-O error " + e.getMessage() + " while writing output file");
            }
        } else {
            TapEnv.toolWarning(-1, "(Decompiler) empty tree!");
        }
    }

    private void decompileSons(Tree tree) throws IOException {
        this.printNode(tree);
        Tree[] sons = tree.children();
        if (sons == null) {
            return;
        }
        for (Tree son : sons) {
            this.decompile(son);
            this.printEdge(tree, son);
        }
    }

    private void print(String word, String kind) throws IOException {
        this.printer.printText(word, kind);
    }

    private void printNode(Tree t) throws IOException {
        int id = this.getNodeId(t);
        String str = t.opName();
        if (t.isStringAtom()) {
            str = str + ":" + t.stringValue();
        } else if (t.isIntAtom()) {
            str = str + ":" + t.intValue();
        }
        this.print("  " + id + " [label=\"" + str + "\"];", "node");
        this.newLine();
    }

    private void printEdge(Tree t1, Tree t2) throws IOException {
        this.print(" " + this.getNodeId(t1) + " -> " + this.getNodeId(t2), "edge");
        this.newLine();
    }

    private void newLine() throws IOException {
        this.printer.newLine();
    }

    private synchronized int getNodeId(Tree n) {
        if (this.map.get(n) == null) {
            this.map.put(n, ++this.lastID);
        }
        return this.map.get(n);
    }
}

