/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.prettyprint;

import fr.inria.tapenade.prettyprint.Printer;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.utils.TapPair;
import fr.inria.tapenade.utils.Tree;
import java.io.IOException;

public class Decompiler {
    protected static final int EMPTY_CONTEXT = 0;
    protected final Printer printer;
    private final String messageFileName;
    private final int[] elementaryContexts;
    protected int language = 1;
    protected boolean showMessages;
    protected int posX;
    protected int posY;
    protected TapList<String> waitingComments;
    protected TapList<String> waitingCommentsBlock;
    protected String commentChar = "!!";
    protected String eolContinuationChar = "";
    protected String continuationChar = "";
    protected int maxColumn = 256;
    private Tree endLineComment;
    private TapList<Tree> seenTreesStack;
    private TapList<TapList<String>> waitingMessages;
    private String hereAnchorPrefix = "";
    private String otherAnchorPrefix = "";
    private String messageAnchorPrefix = "";
    private String otherMessageAnchorPrefix = "";
    private boolean inContinuation;

    protected Decompiler(Printer printer, String msgFileName) {
        this.printer = printer;
        this.messageFileName = msgFileName;
        this.elementaryContexts = new int[32];
        for (int i = 0; i < 32; ++i) {
            this.elementaryContexts[i] = 1 << i;
        }
    }

    protected void reinitialize() {
        this.posY = 0;
        this.posX = 0;
        this.waitingComments = null;
        this.waitingCommentsBlock = null;
        this.waitingMessages = null;
        this.seenTreesStack = null;
        this.endLineComment = null;
    }

    protected int contextPlus(int context, int newContextRk) {
        return context | this.elementaryContexts[newContextRk];
    }

    protected int contextMinus(int context, int newContextRk) {
        return context & ~this.elementaryContexts[newContextRk];
    }

    protected boolean hasContext(int context, int newContextRk) {
        return (context & this.elementaryContexts[newContextRk]) != 0;
    }

    public void decompileTree(Tree tree, int language, boolean inInclude, boolean dumps) {
    }

    protected void preDecompile(Tree tree, int indent) throws IOException {
        if (this.seenTreesStack == null || this.seenTreesStack.head != tree) {
            boolean isUnit;
            TapPair toOtherTags = (TapPair)tree.getAnnotation("toOtherTags");
            TapPair toMessageTags = (TapPair)tree.getAnnotation("toMessageTags");
            boolean bl = isUnit = tree.opCode() == 89 || tree.opCode() == 159;
            if (this.printer.hasAnchors()) {
                if (toOtherTags != null && toOtherTags.first != null) {
                    if (isUnit) {
                        this.hereAnchorPrefix = (String)toOtherTags.first;
                        this.printer.defineAnchor(this.hereAnchorPrefix);
                    } else {
                        this.printer.defineAnchor(this.hereAnchorPrefix + (String)toOtherTags.first);
                    }
                }
                if (toOtherTags != null && toOtherTags.second != null) {
                    if (isUnit) {
                        this.otherAnchorPrefix = (String)toOtherTags.second;
                        this.printer.startAnchorRef(this.otherAnchorPrefix);
                    } else {
                        this.printer.startAnchorRef(this.otherAnchorPrefix + (String)toOtherTags.second);
                    }
                }
                if (toMessageTags != null && toMessageTags.first != null) {
                    if (isUnit) {
                        this.messageAnchorPrefix = (String)toMessageTags.first;
                        this.printer.defineAnchor(this.messageAnchorPrefix);
                    } else {
                        this.printer.defineAnchor(this.messageAnchorPrefix + (String)toMessageTags.first);
                    }
                }
                if (toMessageTags != null && toMessageTags.second != null) {
                    this.printer.setTargetNameAndZone(this.messageFileName, "msg");
                    if (isUnit) {
                        this.otherMessageAnchorPrefix = (String)toMessageTags.second;
                        this.printer.startAnchorRef(this.otherMessageAnchorPrefix);
                    } else {
                        this.printer.startAnchorRef(this.otherMessageAnchorPrefix + (String)toMessageTags.second);
                    }
                    this.print("", indent, "comment");
                    this.printer.messageRef(null, this.showMessages, this.language);
                    this.printer.resetTargetNameAndZone();
                }
                if (toMessageTags != null && toMessageTags.second != null) {
                    if (isUnit) {
                        this.printer.endAnchorRef();
                        this.otherMessageAnchorPrefix = "";
                    } else {
                        this.printer.endAnchorRef();
                    }
                }
            }
            TapList msgTty = (TapList)tree.getAnnotation("message");
            tree.setAnnotation("message", null);
            if (msgTty != null && this.showMessages) {
                this.accumulateMessages(msgTty);
            }
            this.waitingComments = this.accumulateComments((Tree)tree.getAnnotation("preComments"), this.waitingComments);
            this.waitingCommentsBlock = this.accumulateComments((Tree)tree.getAnnotation("preCommentsBlock"), this.waitingCommentsBlock);
            if (!this.inContinuation) {
                this.tryFlushMessages();
                this.tryFlushCommentsBlock(indent, true);
                this.tryFlushComments(indent, true);
            }
        }
        this.seenTreesStack = new TapList<Tree>(tree, this.seenTreesStack);
    }

    protected void postDecompile(Tree tree, int indent) throws IOException {
        this.seenTreesStack = this.seenTreesStack.tail;
        if (this.seenTreesStack == null || this.seenTreesStack.head != tree) {
            Tree newEndLineComment = (Tree)tree.getAnnotation("endLineComment");
            if (newEndLineComment != null && ILUtils.isNotNoneNorEmpty(newEndLineComment)) {
                this.endLineComment = newEndLineComment;
            }
            this.waitingComments = this.accumulateComments((Tree)tree.getAnnotation("postComments"), this.waitingComments);
            this.waitingCommentsBlock = this.accumulateComments((Tree)tree.getAnnotation("postCommentsBlock"), this.waitingCommentsBlock);
            if (!this.inContinuation) {
                this.tryFlushCommentsBlock(indent, false);
                this.tryFlushComments(indent, false);
                this.tryFlushMessages();
            }
            if (this.printer.hasAnchors()) {
                boolean isUnit;
                TapPair toOtherTags = (TapPair)tree.getAnnotation("toOtherTags");
                boolean bl = isUnit = tree.opCode() == 89 || tree.opCode() == 159;
                if (toOtherTags != null && toOtherTags.second != null) {
                    if (isUnit) {
                        this.printer.endAnchorRef();
                        this.otherAnchorPrefix = "";
                    } else {
                        this.printer.endAnchorRef();
                    }
                }
            }
        }
    }

    protected void tryFlushComments(int indent, boolean prefix) throws IOException {
    }

    protected void tryFlushCommentsBlock(int indent, boolean prefix) throws IOException {
    }

    private TapList<String> accumulateComments(Tree comments, TapList<String> waitingComms) {
        if (comments != null && ILUtils.isNotNoneNorEmpty(comments)) {
            TapList<String> toWaitingcomms = new TapList<String>(null, waitingComms);
            TapList<String> tlWaitingcomms = toWaitingcomms;
            while (tlWaitingcomms.tail != null) {
                tlWaitingcomms = tlWaitingcomms.tail;
            }
            if (comments.opCode() == 37 || comments.opCode() == 38) {
                Tree[] sons;
                for (Tree son : sons = comments.children()) {
                    if (son == null || son.opCode() != 180) continue;
                    tlWaitingcomms = tlWaitingcomms.placdl(son.stringValue());
                }
            } else if (comments.opCode() == 180) {
                tlWaitingcomms = tlWaitingcomms.placdl(comments.stringValue());
            }
            return toWaitingcomms.tail;
        }
        return waitingComms;
    }

    private void accumulateMessages(TapList<String> msgs) {
        TapList<TapList<String>> toWaitingMessages;
        TapList<TapList<String>> tlWaitingMessages = toWaitingMessages = new TapList<TapList<String>>(null, this.waitingMessages);
        while (tlWaitingMessages.tail != null) {
            tlWaitingMessages = tlWaitingMessages.tail;
        }
        tlWaitingMessages = tlWaitingMessages.placdl(msgs);
        this.waitingMessages = toWaitingMessages.tail;
    }

    private void tryFlushMessages() throws IOException {
        if (this.showMessages && this.posX == 0) {
            while (this.waitingMessages != null) {
                this.printer.messageRef((TapList)this.waitingMessages.head, this.showMessages, this.language);
                this.printer.newLine();
                this.posX = 0;
                ++this.posY;
                this.waitingMessages = this.waitingMessages.tail;
            }
        }
    }

    private void flushEndLineComment() throws IOException {
        if (this.endLineComment != null) {
            if (this.language == 1) {
                this.printer.newLine();
                this.posX = 0;
                ++this.posY;
            } else {
                this.space();
            }
            this.printer.printText(this.commentChar, "comment");
            this.space();
            this.printer.printText(this.endLineComment.stringValue(), "comment");
            this.endLineComment = null;
        }
    }

    public void newLine(int indent) throws IOException {
        this.flushEndLineComment();
        if (this.inContinuation) {
            this.printer.space(1);
            this.printer.printText(this.commentChar, "comment");
            this.printer.printText(".", "plain");
        }
        this.printer.newLine();
        this.posX = 0;
        ++this.posY;
        if (!this.inContinuation) {
            this.tryFlushCommentsBlock(indent, true);
            this.tryFlushComments(indent, true);
            this.tryFlushMessages();
        }
    }

    protected void space() throws IOException {
        boolean alreadySpace = this.checkForIndentAndLineTooLong(1, 0);
        if (!alreadySpace) {
            this.printer.space(1);
            ++this.posX;
        }
    }

    protected void print(String word, int indent, String kind) throws IOException {
        this.checkForIndentAndLineTooLong(word.length(), indent);
        if (!TapEnv.isC(this.language) || !"include".equals(kind)) {
            while (this.posX + word.length() > this.maxColumn) {
                this.printer.printText(word.substring(0, this.maxColumn - this.posX), kind);
                word = word.substring(this.maxColumn - this.posX);
                this.continuationLine(indent, true);
            }
        }
        this.printer.printText(word, kind);
        this.inContinuation = false;
        this.posX += word.length();
    }

    protected void printString(String word) throws IOException {
        this.printer.printText(word, "string");
        this.posX += word.length();
    }

    private boolean checkForIndentAndLineTooLong(int nextStringLength, int indent) throws IOException {
        boolean lengthFits;
        int minIndent = this.language == 1 ? 6 : 0;
        int minStart = Math.max(this.posX, minIndent);
        boolean bl = lengthFits = minStart + nextStringLength <= this.maxColumn;
        if (lengthFits || minIndent + nextStringLength > this.maxColumn) {
            int targetX = minIndent + indent;
            if (targetX > this.maxColumn - nextStringLength) {
                targetX = this.maxColumn - nextStringLength;
            }
            if (targetX > this.posX) {
                this.indent(targetX);
                return true;
            }
            return false;
        }
        int maxIndent = this.maxColumn - nextStringLength - minIndent;
        this.continuationLine(Math.min(indent, maxIndent), false);
        return true;
    }

    private void indent(int indentValue) throws IOException {
        this.printer.space(indentValue - this.posX);
        this.posX = indentValue;
    }

    private void continuationLine(int indent, boolean inIdent) throws IOException {
        int minIndent;
        int n = minIndent = this.language == 1 ? 6 : 0;
        if (this.language == 2 || this.language == 3) {
            this.printer.printText(this.eolContinuationChar, "label");
        }
        this.inContinuation = true;
        this.printer.newLine();
        ++this.posY;
        int targetX = minIndent + indent;
        int afterContinuationX = this.continuationChar.length();
        if (minIndent > afterContinuationX) {
            this.printer.space(minIndent - afterContinuationX);
            afterContinuationX = minIndent;
        }
        this.printer.printText(this.continuationChar, "label");
        if (inIdent) {
            this.posX = afterContinuationX;
        } else if (afterContinuationX >= targetX) {
            this.posX = afterContinuationX;
        } else {
            this.printer.space(targetX - afterContinuationX);
            this.posX = targetX;
        }
    }
}

