/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.prettyprint;

import fr.inria.tapenade.prettyprint.CallGraphPrinter;
import fr.inria.tapenade.representation.CallArrow;
import fr.inria.tapenade.representation.CallGraph;
import fr.inria.tapenade.representation.MPIcallInfo;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.utils.TapIntList;
import java.io.IOException;

public final class CallGraphDisplayer {
    private final CallGraph cg;
    private final CallGraphPrinter printer;
    private TapList<Unit> alreadyDisplayed;
    private final boolean existsGlobalDeclarations;
    private final String uniqueProgramFileName;
    private final String suffixForDiffMode;
    private String outputHtmlDirectory;
    private final String initialOutputHtmlDirectory;
    private final String callGraphTitle;
    private final String targetZone;

    public CallGraphDisplayer(CallGraph cg, String htmlFileName, boolean existsGlobalDecls, String uniqueProgramFileName, String outputHtmlDirectory, String suffixForDiffMode, String callGraphTitle, String targetZone) throws IOException {
        this.cg = cg;
        this.printer = new CallGraphPrinter(htmlFileName);
        this.existsGlobalDeclarations = existsGlobalDecls;
        this.uniqueProgramFileName = uniqueProgramFileName;
        this.outputHtmlDirectory = outputHtmlDirectory;
        this.suffixForDiffMode = suffixForDiffMode;
        this.initialOutputHtmlDirectory = outputHtmlDirectory;
        this.callGraphTitle = callGraphTitle;
        this.targetZone = targetZone;
    }

    public void display() throws IOException {
        if (this.cg != null) {
            Unit unit;
            this.printer.printText("<!DOCTYPE html>", null);
            this.printer.printText("<link rel=\"stylesheet\" href=\"https://cdn.jsdelivr.net/npm/bootstrap@4.5.3/dist/css/bootstrap.min.css\" integrity=\"sha384-TX8t27EcRE3e/ihU7zmQxVncDAy5uIKz4rEkgIXeMed4M0jlfIDPvg6uqKI2xXr2\" crossorigin=\"anonymous\">", null);
            this.printer.printText("<link type=\"text/CSS\" rel=\"stylesheet\" href=\"tapenade.css\">", null);
            this.printer.printText("<title>" + this.callGraphTitle + "</title>", null);
            this.printer.printText("<body>", null);
            this.printer.newLine();
            this.printer.printText("<h3>" + this.callGraphTitle + "</h3>", null);
            this.printer.newLine();
            if (this.existsGlobalDeclarations) {
                this.printer.bullet();
                String globalDeclsIncludeName = TapEnv.extendStringWithSuffix("GlobalDeclarations", this.suffixForDiffMode);
                this.addItem(globalDeclsIncludeName, globalDeclsIncludeName, null);
            }
            this.printer.printText("FILES:<br>", null);
            this.printer.newLine();
            this.printer.openList();
            if (this.uniqueProgramFileName != null) {
                TapIntList outputLanguages = null;
                for (int i = 0; i < this.cg.nbUnits(); ++i) {
                    unit = this.cg.sortedUnit(i);
                    assert (unit != null);
                    if (!unit.isTranslationUnit() || unit.name().endsWith("iso_c_bindingf.f90") || TapIntList.contains(outputLanguages, unit.language())) continue;
                    outputLanguages = new TapIntList(unit.language(), outputLanguages);
                }
                while (outputLanguages != null) {
                    this.printer.bullet();
                    String uniqueFileName = TapEnv.extendStringWithSuffix(this.uniqueProgramFileName, this.suffixForDiffMode) + TapEnv.outputExtension(outputLanguages.head);
                    String displayFileName = "_p".equals(this.suffixForDiffMode) ? this.uniqueProgramFileName + TapEnv.outputExtension(outputLanguages.head) : uniqueFileName;
                    this.addItem(displayFileName, uniqueFileName + ".html", null);
                    outputLanguages = outputLanguages.tail;
                }
            } else {
                for (int i = 0; i < this.cg.nbUnits(); ++i) {
                    unit = this.cg.sortedUnit(i);
                    assert (unit != null);
                    if (!unit.isTranslationUnit() || unit.name().endsWith("iso_c_bindingf.f90")) continue;
                    this.displayTranslationUnit(unit);
                }
            }
            this.printer.closeList();
            this.printer.printText("UNITS:<br>", null);
            this.printer.newLine();
            this.alreadyDisplayed = null;
            this.printer.openList();
            for (int i = 0; i < this.cg.nbUnits(); ++i) {
                unit = this.cg.sortedUnit(i);
                if (unit.isExternal() || unit.isIntrinsic() && !unit.hasSource() || TapList.contains(this.alreadyDisplayed, unit)) continue;
                this.displayUnit(unit, null);
            }
            this.printer.closeList();
        } else {
            this.printer.printText("<link type=\"text/CSS\" rel=\"stylesheet\" href=\"tapenade.css\">", null);
            this.printer.printText("<center><i>" + this.callGraphTitle + " is empty!</i></center>", null);
        }
        this.printer.printText("</body>", null);
        this.alreadyDisplayed = null;
        this.printer.newLine();
        this.printer.closeFile();
    }

    private void displayUnit(Unit unit, CallArrow callArrow) throws IOException {
        boolean oneFile;
        boolean bl = oneFile = this.uniqueProgramFileName != null;
        if (!(unit.name().isEmpty() || unit.isInterface() || unit.isTranslationUnit() || unit.isIntrinsic() || MPIcallInfo.isMessagePassingFunction(unit.name(), unit.language()) || unit.inStdCIncludeFile() || unit.name().startsWith("iso_c_binding") || !unit.isTopInFile() && unit.upperLevelUnit().name().startsWith("iso_c_binding"))) {
            Unit upperLevelUnit = unit;
            while (!upperLevelUnit.isTopInFile()) {
                upperLevelUnit = upperLevelUnit.upperLevelUnit();
            }
            while (upperLevelUnit.enclosingUnitOfInterface != null) {
                upperLevelUnit = upperLevelUnit.enclosingUnitOfInterface;
            }
            String upperLevelUnitName = upperLevelUnit.name();
            if (!oneFile) {
                if (upperLevelUnit.translationUnitSymbolTable() != null) {
                    upperLevelUnitName = TapEnv.stripPath(upperLevelUnit.translationUnitSymbolTable().containerFileName);
                }
                String suffix = "";
                if (this.cg == TapEnv.get().origCallGraph()) {
                    suffix = TapEnv.get().preprocessFileSuffix;
                }
                String unitSuffix = suffix;
                upperLevelUnitName = upperLevelUnitName + unitSuffix;
            }
            String htmlTargetFileName = null;
            if (!(unit.isExternal() || unit.isUndefined() || unit.isVarFunction())) {
                if (this.uniqueProgramFileName != null) {
                    htmlTargetFileName = this.uniqueProgramFileName;
                } else {
                    Unit fileUnit;
                    for (fileUnit = unit; fileUnit != null && !fileUnit.isTranslationUnit(); fileUnit = fileUnit.upperLevelUnit()) {
                    }
                    assert (fileUnit != null);
                    htmlTargetFileName = TapEnv.stripLanguageExtension(TapEnv.stripPath(fileUnit.name()));
                }
                htmlTargetFileName = TapEnv.extendStringWithSuffix(htmlTargetFileName, this.suffixForDiffMode) + TapEnv.outputExtension(unit.language()) + ".html";
            }
            this.printer.bullet();
            if (callArrow != null) {
                if (callArrow.isImport()) {
                    this.printer.printText("Uses ", null);
                } else if (callArrow.isCall()) {
                    this.printer.printText("Calls ", null);
                } else if (callArrow.isContain()) {
                    this.printer.printText("Contains ", null);
                }
            }
            if (unit.isModule()) {
                this.printer.printText("Module ", null);
            } else if (unit.isIntrinsic()) {
                this.printer.printText("Intrinsic ", null);
            } else if (unit.isExternal()) {
                this.printer.printText("External ", null);
            }
            if (unit.isIntrinsic() || unit.isExternal() || unit.isStandard()) {
                if (unit.isAFunction()) {
                    this.printer.printText("function ", null);
                } else if (unit.isFortran()) {
                    this.printer.printText("subroutine ", null);
                } else {
                    this.printer.printText("procedure ", null);
                }
            }
            String unitName = unit.name();
            String displayedUnitName = unit.name();
            if (unit.isFortran()) {
                displayedUnitName = displayedUnitName.toUpperCase();
            }
            this.changeLanguageSuffix(unit.language());
            if (callArrow != null && callArrow.srcCallName() != null) {
                this.printer.printText(callArrow.srcCallName() + " i.e. ", null);
            }
            if (!TapList.contains(this.alreadyDisplayed, unit)) {
                this.alreadyDisplayed = new TapList<Unit>(unit, this.alreadyDisplayed);
                this.addItem(displayedUnitName, htmlTargetFileName, unitName);
                TapList<CallArrow> callArrows = TapList.reverse(unit.callees());
                boolean listOpen = false;
                if (callArrows != null) {
                    this.printer.openList();
                    listOpen = true;
                }
                while (callArrows != null) {
                    Unit calledUnit = ((CallArrow)callArrows.head).destination;
                    if (!calledUnit.isInterface() && !calledUnit.isIntrinsic() && calledUnit.rank() != -1) {
                        this.displayUnit(calledUnit, (CallArrow)callArrows.head);
                    }
                    callArrows = callArrows.tail;
                }
                if (listOpen) {
                    this.printer.closeList();
                }
            } else if (unit.callees() == null) {
                this.addItem(displayedUnitName, htmlTargetFileName, unitName);
            } else {
                this.addItem(displayedUnitName + " ...", htmlTargetFileName, unitName);
            }
        }
    }

    private void changeLanguageSuffix(int lang) {
        if (this.outputHtmlDirectory != null && this.outputHtmlDirectory.endsWith(".html")) {
            String rootOutputHtmlDirectory = this.initialOutputHtmlDirectory.substring(0, this.initialOutputHtmlDirectory.length() - 5);
            this.outputHtmlDirectory = rootOutputHtmlDirectory + TapEnv.outputExtension(lang) + ".html";
        }
    }

    private void displayTranslationUnit(Unit unit) throws IOException {
        String fileName = TapEnv.stripLanguageExtension(TapEnv.stripPath(unit.name()));
        String displayFileName = "_p".equals(this.suffixForDiffMode) ? fileName + TapEnv.outputExtension(unit.language()) : TapEnv.extendStringWithSuffix(fileName, this.suffixForDiffMode) + TapEnv.outputExtension(unit.language());
        String htmlTargetFileName = TapEnv.extendStringWithSuffix(fileName, this.suffixForDiffMode) + TapEnv.outputExtension(unit.language()) + ".html";
        this.printer.bullet();
        this.addItem(displayFileName, htmlTargetFileName, null);
    }

    private void addItem(String displayName, String targetFileName, String targetAnchor) throws IOException {
        if (targetFileName != null) {
            String targetFullFileName = (this.outputHtmlDirectory == null ? "" : this.outputHtmlDirectory) + targetFileName;
            this.printer.printText("<a href=\"" + targetFullFileName + (targetAnchor == null ? "" : "#" + targetAnchor) + "\" target=\"" + this.targetZone + "\">", null);
            this.printer.printText("<code class=\"funcname\">" + displayName + "</code></a> <br>", null);
            this.printer.newLine();
        } else {
            this.printer.printText("<code class=\"external\">" + displayName + "</code> <br>", null);
            this.printer.newLine();
        }
    }
}

