/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.prettyprint;

import fr.inria.tapenade.prettyprint.Decompiler;
import fr.inria.tapenade.prettyprint.Printer;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.TypeSpec;
import fr.inria.tapenade.utils.Tree;
import java.io.IOException;

public final class CDecompiler
extends Decompiler {
    private static final int INDENT_STEP = 4;
    private static final int PREC_UNARY = 35;
    private static final int PREC_BINARY = 33;
    private static final int LPREC_BINARY = 33;
    private static final int RPREC_BINARY = 34;
    private static final int PREC_FIELD = 31;
    private static final int LPREC_FIELD = 31;
    private static final int RPREC_FIELD = 32;
    private static final int PREC_SUBSCRIPT = 31;
    private static final int LPREC_SUBSCRIPT = 31;
    private static final int PREC_FCALL = 31;
    private static final int LPREC_FCALL = 31;
    private static final int RPREC_FCALL = 32;
    private static final int PREC_POSTDECR = 31;
    private static final int PREC_POSTINCR = 31;
    private static final int PREC_SIZEOF = 29;
    private static final int PREC_PREDECR = 29;
    private static final int PREC_PREINCR = 29;
    private static final int PREC_BNOT = 29;
    private static final int PREC_NOT = 29;
    private static final int PREC_MINUS = 29;
    private static final int PREC_PLUS = 29;
    private static final int PREC_ADDROF = 29;
    private static final int PREC_PTRDEREF = 30;
    private static final int PREC_CAST = 29;
    private static final int PREC_MUL = 25;
    private static final int LPREC_MUL = 25;
    private static final int RPREC_MUL = 26;
    private static final int PREC_DIV = 25;
    private static final int LPREC_DIV = 25;
    private static final int RPREC_DIV = 26;
    private static final int PREC_MOD = 25;
    private static final int LPREC_MOD = 25;
    private static final int RPREC_MOD = 26;
    private static final int PREC_ADD = 23;
    private static final int LPREC_ADD = 23;
    private static final int RPREC_ADD = 24;
    private static final int PREC_SUB = 23;
    private static final int LPREC_SUB = 23;
    private static final int RPREC_SUB = 24;
    private static final int PREC_LSHIFT = 21;
    private static final int LPREC_LSHIFT = 21;
    private static final int RPREC_LSHIFT = 22;
    private static final int PREC_RSHIFT = 21;
    private static final int LPREC_RSHIFT = 21;
    private static final int RPREC_RSHIFT = 22;
    private static final int PREC_GE = 19;
    private static final int LPREC_GE = 19;
    private static final int RPREC_GE = 20;
    private static final int PREC_GT = 19;
    private static final int LPREC_GT = 19;
    private static final int RPREC_GT = 20;
    private static final int PREC_LE = 19;
    private static final int LPREC_LE = 19;
    private static final int RPREC_LE = 20;
    private static final int PREC_LT = 19;
    private static final int LPREC_LT = 19;
    private static final int RPREC_LT = 20;
    private static final int PREC_EQ = 17;
    private static final int LPREC_EQ = 17;
    private static final int RPREC_EQ = 17;
    private static final int PREC_NEQ = 17;
    private static final int LPREC_NEQ = 17;
    private static final int RPREC_NEQ = 17;
    private static final int PREC_BAND = 15;
    private static final int LPREC_BAND = 15;
    private static final int RPREC_BAND = 16;
    private static final int PREC_BXOR = 13;
    private static final int LPREC_BXOR = 13;
    private static final int RPREC_BXOR = 14;
    private static final int PREC_BOR = 11;
    private static final int LPREC_BOR = 11;
    private static final int RPREC_BOR = 12;
    private static final int PREC_AND = 9;
    private static final int LPREC_AND = 9;
    private static final int RPREC_AND = 10;
    private static final int PREC_OR = 7;
    private static final int LPREC_OR = 7;
    private static final int RPREC_OR = 8;
    private static final int PREC_CONDEXP = 5;
    private static final int PREC_ASSIGN = 3;
    private static final int LPREC_ASSIGN = 3;
    private static final int RPREC_ASSIGN = 4;
    private static final int INPARAMSLIS = 5;
    private static final int INBRACES_CTX = 6;
    private static final int RESULTEXPECTED_CTX = 7;
    private static final int DEEPEXPR_CTX = 8;
    private static final int ISVARDECL_CTX = 9;
    private static final int ISFUNCNAME_CTX = 10;
    private static final int INUNITBODY_CTX = 15;
    private static final int INBODY_CONTEXT = 32768;
    private static final int TYPE_TREE = 0;
    private static final int DECL_TREE = 1;
    private boolean endOfUnit;
    private Tree parallelSpreadSizes = null;

    public CDecompiler(Printer printer, String htmlMsgFileName) {
        super(printer, htmlMsgFileName);
    }

    private static boolean hasDeclsOrIsLongOrIsEmpty(Tree tree, boolean orIsLong) {
        Tree[] contents = new Tree[]{tree};
        while (contents.length == 1 && contents[0].opCode() == 27) {
            contents = contents[0].children();
        }
        if (orIsLong && contents.length != 1) {
            return true;
        }
        boolean hasDecls = false;
        for (int i = 0; !hasDecls && i < contents.length; ++i) {
            hasDecls = contents[i] != null && ILUtils.isADeclaration(contents[i]);
        }
        return hasDecls;
    }

    private static Tree singleInstructionIn(Tree tree) {
        Tree[] contents = new Tree[]{tree};
        while (contents.length == 1 && contents[0].opCode() == 27) {
            contents = contents[0].children();
        }
        if (contents.length == 0) {
            return null;
        }
        return contents[0];
    }

    private static boolean hasSingleIfNoElse(Tree tree) {
        Tree[] contents = new Tree[]{tree};
        while (contents.length == 1 && contents[0].opCode() == 27) {
            contents = contents[0].children();
        }
        if (contents.length == 1 && contents[0].opCode() == 98) {
            Tree elsePart = contents[0].down(3);
            return elsePart == null || elsePart.opCode() == 138 || !elsePart.isAtom() && elsePart.length() == 0;
        }
        return false;
    }

    @Override
    public void decompileTree(Tree tree, int lang, boolean inInclude, boolean showMsgs) {
        if (tree != null) {
            try {
                this.showMessages = showMsgs;
                this.language = lang;
                this.maxColumn = 78;
                this.commentChar = "//";
                this.reinitialize();
                this.decompile(tree, 0, 0, this.contextPlus(inInclude ? 32768 : 0, 6));
            }
            catch (IOException e) {
                TapEnv.systemError("(C decompiler) I-O error " + e.getMessage() + " while writing output file " + this.printer.toFile());
            }
        } else {
            TapEnv.toolWarning(-1, "(C decompiler) empty tree");
        }
    }

    private void decompile(Tree tree, int indent, int precedence, int context) throws IOException {
        this.preDecompile(tree, indent);
        switch (tree.opCode()) {
            case 27: 
            case 76: {
                Tree[] elements;
                boolean braces = !this.hasContext(context, 6) && CDecompiler.hasDeclsOrIsLongOrIsEmpty(tree, false);
                int indent2 = indent;
                if (braces) {
                    this.print("{", indent, "plain");
                    context = this.contextPlus(context, 6);
                    this.newLine(indent);
                    indent2 = indent + 2;
                }
                if ((elements = tree.children()).length > 1) {
                    context = this.contextMinus(context, 6);
                }
                for (int i = 0; i < elements.length; ++i) {
                    this.decompile(elements[i], indent2, precedence, context);
                    if (i + 1 < elements.length) {
                        if (!(elements[i + 1].opCode() == 89 && this.isAFunctionPrototype(elements[i + 1]) || elements[i + 1].opCode() == 49 || elements[i + 1].opCode() == 138)) {
                            this.newLine(indent2);
                        }
                        if (elements[i].opCode() != 89 && elements[i].opCode() != 159 && elements[i].opCode() != 36 && elements[i].opCode() != 136 && elements[i + 1].opCode() != 89 && elements[i + 1].opCode() != 159 && elements[i + 1].opCode() != 36 && elements[i + 1].opCode() != 136) continue;
                        this.newLine(indent2);
                        continue;
                    }
                    this.endOfUnit = true;
                }
                if (!braces) break;
                this.newLine(indent);
                this.print("}", indent, "plain");
                break;
            }
            case 136: {
                this.print("namespace", indent, "plain");
                this.space();
                this.printThingName(tree.down(1), indent, "plain");
                this.space();
                this.print("{", indent, "plain");
                this.newLine(indent);
                this.decompile(tree.down(2), indent + 4, precedence, this.contextPlus(context, 6));
                this.newLine(indent);
                this.print("}", indent, "plain");
                break;
            }
            case 36: {
                this.decompileModifiers(tree.down(1), indent, context);
                if (tree.down(1).length() > 0) {
                    this.space();
                }
                this.print("class", indent, "plain");
                this.space();
                this.printThingName(tree.down(2), indent, "plain");
                this.space();
                if (!ILUtils.isNullOrNoneOrEmptyList(tree.down(3))) {
                    this.print(":", indent, "plain");
                    this.space();
                    this.decompile(tree.down(3), indent + 4 + 4, precedence, this.contextPlus(context, 5));
                    this.space();
                }
                this.print("{", indent, "plain");
                if (!ILUtils.isNullOrNoneOrEmptyList(tree.down(4))) {
                    this.newLine(indent);
                    this.decompile(tree.down(4), indent + 4, precedence, this.contextPlus(context, 6));
                    this.newLine(indent);
                }
                this.print("}", indent, "plain");
                this.print(";", indent, "plain");
                break;
            }
            case 89: {
                if (tree.down(4).opCode() != 96 && tree.down(4).opCode() != 173) {
                    TapEnv.toolWarning(-1, "(C decompiler) [Function] Unexpected function name " + tree.down(4).opName());
                    break;
                }
                this.decompileModifiers(tree.down(1), indent, context);
                if (tree.down(1).length() > 0) {
                    this.space();
                }
                this.decompileTypeSpec(tree.down(2), indent, precedence, context);
                this.space();
                this.printThingName(tree.down(4), indent, "plain");
                this.print("(", indent, "plain");
                int indentForParams = indent + 4 + 4;
                if (indentForParams > this.posX) {
                    indentForParams = this.posX;
                }
                this.decompile(tree.down(5), indentForParams, precedence, this.contextPlus(context, 5));
                this.print(")", indent, "plain");
                if (this.isAFunctionPrototype(tree)) {
                    this.print(";", indent, "plain");
                } else {
                    this.space();
                    this.print("{", indent, "plain");
                    if (!ILUtils.isNullOrNoneOrEmptyList(tree.down(6))) {
                        context = this.contextPlus(context, 6);
                        this.newLine(indent);
                        this.decompile(tree.down(6), indent + 4, precedence, context);
                        this.newLine(indent);
                    }
                    this.print("}", indent, "plain");
                }
                this.endOfUnit = true;
                break;
            }
            case 159: {
                boolean braces;
                if (tree.down(2).opCode() != 96 && tree.down(2).opCode() != 173) {
                    TapEnv.toolWarning(-1, "(C decompiler) [Function] Unexpected program name " + tree.down(2).opName());
                    break;
                }
                this.decompileModifiers(tree.down(1), indent, context);
                if (tree.down(1).length() > 0) {
                    this.space();
                }
                this.printThingName(tree.down(2), indent, "plain");
                this.print("(", indent, "plain");
                this.decompile(tree.down(3), indent, precedence, this.contextPlus(context, 5));
                this.print(")", indent, "plain");
                boolean bl = braces = tree.down(4).opCode() != 138;
                if (braces) {
                    this.space();
                    this.print("{", indent, "plain");
                    context = this.contextPlus(context, 6);
                    this.newLine(indent);
                }
                this.decompile(tree.down(4), indent + 4, precedence, context);
                if (braces) {
                    this.newLine(indent);
                    this.print("}", indent, "plain");
                }
                this.endOfUnit = true;
                break;
            }
            case 46: {
                boolean braces;
                this.decompileModifiers(tree.down(1), indent, context);
                if (tree.down(1).length() > 0) {
                    this.space();
                }
                this.printThingName(tree.down(2), indent, "plain");
                this.print("(", indent, "plain");
                this.decompile(tree.down(3), indent, precedence, this.contextPlus(context, 5));
                this.print(")", indent, "plain");
                this.decompileExpression(tree.down(4), indent, precedence, context);
                boolean bl = braces = tree.down(5).opCode() != 138;
                if (braces) {
                    this.space();
                    this.print("{", indent, "plain");
                    context = this.contextPlus(context, 6);
                    this.newLine(indent);
                }
                this.decompile(tree.down(5), indent + 4, precedence, context);
                if (braces) {
                    this.newLine(indent);
                    this.print("}", indent, "plain");
                }
                this.endOfUnit = true;
                break;
            }
            case 56: {
                boolean braces;
                this.decompileModifiers(tree.down(1), indent, context);
                if (tree.down(1).length() > 0) {
                    this.space();
                }
                this.printThingName(tree.down(2), indent, "plain");
                this.print("()", indent, "plain");
                boolean bl = braces = tree.down(3).opCode() != 138;
                if (braces) {
                    this.space();
                    this.print("{", indent, "plain");
                    context = this.contextPlus(context, 6);
                    this.newLine(indent);
                }
                this.decompile(tree.down(3), indent + 4, precedence, context);
                if (braces) {
                    this.newLine(indent);
                    this.print("}", indent, "plain");
                }
                this.endOfUnit = true;
                break;
            }
            case 53: 
            case 148: 
            case 200: {
                Tree[] elements = tree.children();
                for (int i = 0; i < elements.length; ++i) {
                    this.decompile(elements[i], indent, precedence, context);
                    if (i >= elements.length - 1) continue;
                    if (this.hasContext(context, 5)) {
                        this.print(",", indent, "plain");
                        this.space();
                        continue;
                    }
                    this.newLine(indent);
                }
                break;
            }
            case 147: {
                this.decompileModifiers(tree.down(1), indent, context);
                this.space();
                this.decompile(tree.down(2), indent, precedence, context);
                break;
            }
            case 199: {
                Tree type = tree.down(2);
                if (type.opCode() == 91) {
                    Tree[] pair2 = this.buildDeclaratorFromType(type, ILUtils.build(138));
                    this.decompileTypeSpec(pair2[0], indent, precedence, context);
                    this.space();
                    boolean paren = false;
                    if (tree.down(3).length() != 0) {
                        paren = true;
                    }
                    if (paren) {
                        this.print("(", indent, "plain");
                    }
                    this.decompileDeclarator(tree.down(3), indent, precedence, context);
                    if (paren) {
                        this.print(")", indent, "plain");
                    }
                    this.decompileDeclarator(pair2[1], indent, precedence, context);
                    break;
                }
                if (type.opCode() == 154 || type.opCode() == 13 || type.opCode() == 129 && (type.down(2).opCode() == 154 || type.down(2).opCode() == 13)) {
                    int length = tree.down(3).length();
                    if (length > 0) {
                        Tree[] pair = this.buildDeclaratorFromType(type, tree.down(3).down(1));
                        this.decompileTypeSpec(pair[0], indent, precedence, context);
                        this.space();
                        this.decompileDeclarator(pair[1], indent, precedence, context);
                        if (!this.hasContext(context, 5) && 1 != length) {
                            this.print(",", indent, "plain");
                            this.space();
                        }
                        for (int i = 2; i <= length; ++i) {
                            Tree[] pair2 = this.buildDeclaratorFromType(type, tree.down(3).down(i));
                            this.decompileDeclarator(pair2[1], indent, precedence, context);
                            if (this.hasContext(context, 5) || i == length) continue;
                            this.print(",", indent, "plain");
                            this.space();
                        }
                    } else {
                        if (type.opCode() != 138) {
                            this.decompileTypeSpec(type, indent, precedence, context);
                            if (tree.down(3).length() > 0) {
                                this.space();
                            }
                        }
                        this.decompileDeclarator(tree.down(3), indent, precedence, context);
                    }
                    if (this.hasContext(context, 5)) break;
                    this.print(";", indent, "plain");
                    break;
                }
                if (ILUtils.isNullOrNone(type) || tree.down(3).length() != 1) {
                    if (type.opCode() != 138) {
                        this.decompileTypeSpec(type, indent, precedence, context);
                        if (tree.down(3).length() > 0) {
                            this.space();
                        }
                    }
                    this.decompileDeclarator(tree.down(3), indent, precedence, context);
                } else {
                    Tree[] pair = this.buildDeclaratorFromType(type, tree.down(3).down(1));
                    this.decompileTypeSpec(pair[0], indent, precedence, context);
                    this.space();
                    this.decompileDeclarator(pair[1], indent, precedence, context);
                }
                if (this.hasContext(context, 5)) break;
                this.print(";", indent, "plain");
                break;
            }
            case 45: {
                this.print("const", indent, "plain");
                this.space();
                if (tree.down(1).opCode() == 154 || tree.down(1).opCode() == 13 || tree.down(1).opCode() == 129 && (tree.down(1).down(2).opCode() == 154 || tree.down(1).down(2).opCode() == 13)) {
                    int length = tree.down(2).length();
                    if (length > 0) {
                        Tree[] pair = this.buildDeclaratorFromType(tree.down(1), tree.down(2).down(1));
                        this.decompileTypeSpec(pair[0], indent, precedence, context);
                        this.space();
                        this.decompileDeclarator(pair[1], indent, precedence, context);
                        if (!this.hasContext(context, 5) && 1 != length) {
                            this.print(",", indent, "plain");
                            this.space();
                        }
                        for (int i = 2; i <= length; ++i) {
                            Tree[] pair2 = this.buildDeclaratorFromType(tree.down(1), tree.down(2).down(i));
                            this.decompileDeclarator(pair2[1], indent, precedence, context);
                            if (this.hasContext(context, 5) || i == length) continue;
                            this.print(",", indent, "plain");
                            this.space();
                        }
                        if (this.hasContext(context, 5)) break;
                        this.print(";", indent, "plain");
                        break;
                    }
                    if (tree.down(1).opCode() != 138) {
                        this.decompileTypeSpec(tree.down(1), indent, precedence, context);
                        if (tree.down(2).length() > 0) {
                            this.space();
                        }
                    }
                    this.decompileDeclarator(tree.down(2), indent, precedence, context);
                    if (this.hasContext(context, 5)) break;
                    this.print(";", indent, "plain");
                    break;
                }
                if (tree.down(1).opCode() != 138) {
                    this.decompileTypeSpec(tree.down(1), indent, precedence, context);
                    if (tree.down(2).length() > 0) {
                        this.space();
                    }
                }
                this.decompileDeclarator(tree.down(2), indent, precedence, context);
                if (this.hasContext(context, 5)) break;
                this.print(";", indent, "plain");
                break;
            }
            case 203: {
                this.print("...", indent, "plain");
                if (this.hasContext(context, 5)) break;
                this.print(";", indent, "plain");
                break;
            }
            case 192: {
                Tree decl = tree.down(1);
                if (decl.opCode() == 96) {
                    if (tree.down(2).opCode() == 161 && decl.stringValue().startsWith("struct ")) {
                        decl = ILUtils.build(138);
                    } else if (tree.down(2).opCode() == 195 && decl.stringValue().startsWith("union ")) {
                        decl = ILUtils.build(138);
                    } else if (tree.down(2).opCode() == 67 && decl.stringValue().startsWith("enum ")) {
                        decl = ILUtils.build(138);
                    }
                }
                Tree type = tree.down(2);
                if (decl.opCode() != 96 && decl.opCode() != 138 && decl.opCode() != 173) {
                    TapEnv.toolWarning(-1, "(C decompiler) [typeDeclaration] Bad TypeName " + decl.opName());
                } else {
                    boolean defFunction;
                    boolean trueTypedef = false;
                    boolean bl = defFunction = type.opCode() == 91 || type.opCode() == 13 || type.opCode() == 154 && type.down(1).opCode() == 91;
                    if (decl.opCode() == 96) {
                        trueTypedef = true;
                    }
                    Tree[] pair = this.buildDeclaratorFromType(type, decl);
                    if (trueTypedef) {
                        this.print("typedef", indent, "keyword");
                        this.space();
                    }
                    if (defFunction) {
                        this.decompileTypeSpec(pair[0], indent, precedence, context);
                    } else {
                        this.decompileTypeSpec(type, indent, precedence, context);
                    }
                    if (trueTypedef) {
                        this.space();
                        if (defFunction) {
                            this.decompileDeclarator(pair[1], indent, precedence, context);
                        } else {
                            this.decompileDeclarator(decl, indent, precedence, context);
                        }
                    }
                }
                this.print(";", indent, "plain");
                break;
            }
            case 101: {
                this.print("#include " + tree.stringValue(), indent, "include");
                break;
            }
            case 112: {
                this.decompileExpression(tree.down(1), indent - 2, 0, context);
                this.print(":", indent, "plain");
                this.newLine(indent);
                this.decompile(tree.down(2), indent, precedence, context);
                if (tree.down(2).opCode() != 138) break;
                this.print(";", indent, "plain");
                break;
            }
            case 98: {
                boolean hasElse;
                this.print("if", indent, "keyword");
                this.space();
                this.print("(", indent, "plain");
                this.decompileExpression(tree.down(1), indent, precedence, context);
                this.print(")", indent, "plain");
                boolean braces = CDecompiler.hasDeclsOrIsLongOrIsEmpty(tree.down(2), true);
                boolean bl = hasElse = !ILUtils.isNullOrNoneOrEmptyList(tree.down(3));
                if (hasElse && !braces && CDecompiler.hasSingleIfNoElse(tree.down(2))) {
                    braces = true;
                }
                int context2 = context = this.contextMinus(context, 6);
                if (braces) {
                    this.space();
                    this.print("{", indent, "plain");
                    context2 = this.contextPlus(context, 6);
                }
                this.newLine(indent);
                this.decompile(tree.down(2), indent + 4, precedence, context2);
                if (braces) {
                    this.newLine(indent + 4);
                    this.print("}", indent, "plain");
                }
                if (!hasElse) break;
                if (braces) {
                    this.space();
                } else {
                    this.newLine(indent);
                }
                context2 = context;
                this.print("else", indent, "keyword");
                braces = CDecompiler.hasDeclsOrIsLongOrIsEmpty(tree.down(3), true);
                Tree singleElse = null;
                if (!braces) {
                    singleElse = CDecompiler.singleInstructionIn(tree.down(3));
                }
                if (singleElse != null && singleElse.opCode() == 98) {
                    this.space();
                    this.decompile(singleElse, indent, precedence, context2);
                    break;
                }
                if (braces) {
                    this.space();
                    this.print("{", indent, "plain");
                    context2 = this.contextPlus(context, 6);
                }
                this.newLine(indent);
                this.decompile(tree.down(3), indent + 4, precedence, context2);
                if (!braces) break;
                this.newLine(indent);
                this.print("}", indent, "plain");
                break;
            }
            case 184: {
                this.print("switch", indent, "keyword");
                this.space();
                this.print("(", indent, "plain");
                this.decompileExpression(tree.down(1), indent, precedence, context);
                this.print(")", indent, "plain");
                this.space();
                this.print("{", indent, "plain");
                this.newLine(indent);
                Tree[] cases = tree.down(2).children();
                context = this.contextMinus(context, 6);
                for (Tree aCase : cases) {
                    this.decompile(aCase, indent, precedence, context);
                    this.newLine(indent);
                }
                this.print("}", indent, "plain");
                break;
            }
            case 185: {
                Tree[] subCases = tree.down(1).children();
                if (subCases.length == 0) {
                    this.print("default", indent, "keyword");
                    this.space();
                    this.print(":", indent, "plain");
                } else {
                    for (int i = 0; i < subCases.length; ++i) {
                        this.print("case", indent, "keyword");
                        this.space();
                        this.decompileExpression(subCases[i], indent, precedence, context);
                        this.space();
                        this.print(":", indent, "plain");
                        if (i >= subCases.length - 1) continue;
                        this.newLine(indent);
                    }
                }
                if (tree.down(2).length() == 0) break;
                boolean braces = CDecompiler.hasDeclsOrIsLongOrIsEmpty(tree.down(2), false);
                if (braces) {
                    this.space();
                    this.print("{", indent, "plain");
                    context = this.contextPlus(context, 6);
                }
                this.newLine(indent);
                this.decompile(tree.down(2), indent + 4, precedence, context);
                if (!braces) break;
                this.newLine(indent);
                this.print("}", indent, "plain");
                break;
            }
            case 121: {
                this.decompileLoop(tree, indent, precedence, context);
                break;
            }
            case 81: {
                this.decompile(tree.down(1), indent, precedence, this.contextPlus(context, 5));
                this.space();
                this.print(":", indent, "keyword");
                this.space();
                this.decompileExpression(tree.down(2), indent, precedence, context);
                break;
            }
            case 191: {
                this.print("try", indent, "keyword");
                this.space();
                this.print("{", indent, "plain");
                this.newLine(indent);
                this.decompile(tree.down(1), indent + 4, precedence, this.contextPlus(context, 6));
                this.newLine(indent);
                this.print("}", indent, "plain");
                this.space();
                this.decompile(tree.down(2), indent, precedence, context);
                break;
            }
            case 34: {
                Tree[] catches;
                for (Tree aCatch : catches = tree.children()) {
                    this.decompile(aCatch, indent, precedence, context);
                }
                break;
            }
            case 33: {
                this.space();
                this.print("catch", indent, "keyword");
                this.space();
                this.print("(", indent, "plain");
                this.decompile(tree.down(1), indent, precedence, context);
                this.print(") {", indent, "plain");
                this.newLine(indent);
                this.decompile(tree.down(2), indent + 4, precedence, this.contextPlus(context, 6));
                this.newLine(indent);
                this.print("}", indent, "plain");
                this.space();
                break;
            }
            case 188: {
                this.print("throw", indent, "keyword");
                this.space();
                this.decompile(tree.down(1), indent, precedence, context);
                this.print(";", indent, "plain");
                break;
            }
            case 30: 
            case 70: {
                this.print("break", indent, "keyword");
                this.print(";", indent, "plain");
                break;
            }
            case 49: {
                break;
            }
            case 138: {
                break;
            }
            case 50: {
                this.print("continue", indent, "keyword");
                this.print(";", indent, "plain");
                break;
            }
            case 168: {
                this.print("return", indent, "keyword");
                if (tree.down(1).opCode() != 138) {
                    this.space();
                    this.decompileExpression(tree.down(1), indent, precedence, context);
                }
                this.print(";", indent, "plain");
                break;
            }
            case 93: {
                this.print("goto", indent, "keyword");
                this.space();
                this.printLabel(tree.down(1), indent);
                this.print(";", indent, "plain");
                break;
            }
            case 100: {
                break;
            }
            case 2: {
                this.decompileExpression(tree.down(1), indent - 2, precedence, context);
                this.space();
                this.print(":", indent, "plain");
                break;
            }
            case 88: {
                if (ILUtils.isNullOrNoneOrEmptyList(tree)) break;
                Tree[] friendsList = tree.children();
                this.print("friend", indent, "keyword");
                for (Tree value : friendsList) {
                    this.space();
                    this.decompileExpression(value, indent + 2, precedence, context);
                }
                this.print(";", indent, "plain");
                break;
            }
            default: {
                this.decompileExpression(tree, indent, precedence, context);
                if (this.hasContext(context, 5)) break;
                this.print(";", indent, "plain");
            }
        }
        this.postDecompile(tree, indent);
    }

    private boolean isAFunctionPrototype(Tree tree) {
        return tree.down(6).opCode() == 138;
    }

    private void decompileTypeSpec(Tree tree, int indent, int precedence, int context) throws IOException {
        this.preDecompile(tree, indent);
        if (tree.opCode() == 129 && tree.down(1).length() != 0 && tree.down(1).down(1).opCode() == 96 && (tree.down(1).down(1).stringValue().equals("restrict") || tree.down(1).down(1).stringValue().equals("__restrict")) && tree.down(2).opCode() == 154) {
            if (tree.down(1).length() > 1) {
                Tree otherModifiers = ILUtils.copy(tree.down(1));
                assert (otherModifiers != null);
                otherModifiers.removeChild(1);
                this.decompileModifiers(otherModifiers, indent, context);
                this.space();
            }
            this.decompileTypeSpec(tree.down(2), indent, precedence, context);
            this.space();
            this.print(tree.down(1).down(1).stringValue(), indent, "modifier");
        } else {
            switch (tree.opCode()) {
                case 204: {
                    this.print("void", indent, "typename");
                    break;
                }
                case 104: {
                    this.print("int", indent, "typename");
                    break;
                }
                case 78: {
                    this.print("float", indent, "typename");
                    break;
                }
                case 41: {
                    this.print("complex", indent, "typename");
                    break;
                }
                case 29: {
                    if (this.language == 5) {
                        this.print("bool", indent, "typename");
                        break;
                    }
                    this.print("_Bool", indent, "typename");
                    break;
                }
                case 35: {
                    this.print("char", indent, "typename");
                    break;
                }
                case 96: {
                    this.printAtomValue(tree, indent, "typename");
                    break;
                }
                case 129: {
                    if (tree.down(1).length() != 0 && (ILUtils.isIdent(tree.down(1).down(1), "restrict", true) || ILUtils.isIdent(tree.down(1).down(1), "__restrict", true)) && tree.down(2).opCode() == 154) {
                        this.decompileTypeSpec(tree.down(2), indent, precedence, context);
                        this.space();
                        this.print(tree.down(1).down(1).stringValue(), indent, "modifier");
                        break;
                    }
                    if (tree.down(2).opCode() == 154) {
                        Tree[] pair1 = this.buildDeclaratorFromType(tree, ILUtils.build(138));
                        this.decompileTypeSpec(pair1[0], indent, precedence, context);
                        this.space();
                        this.decompileDeclarator(pair1[1], indent, precedence, context);
                        break;
                    }
                    if ((this.modifiersContains(tree.down(1), "8") != -1 || this.modifiersContains(tree.down(1), "c_double") != -1) && tree.down(2).opCode() == 78) {
                        this.print("double", indent, "typename");
                        break;
                    }
                    if (this.modifiersContains(tree.down(1), "c_int") != -1 && tree.down(2).opCode() == 104) {
                        this.print("int", indent, "typename");
                        break;
                    }
                    if (this.modifiersContains(tree.down(1), "float") != -1 && tree.down(2).opCode() == 78) {
                        this.decompileTypeSpec(tree.down(2), indent, precedence, context);
                        break;
                    }
                    this.decompileModifiers(tree.down(1), indent, context);
                    if ((this.modifiersContains(tree.down(1), "double") != -1 || this.modifiersContains(tree.down(1), "long double") != -1) && tree.down(2).opCode() == 78) break;
                    if (!ILUtils.isNullOrNoneOrEmptyList(tree.down(1))) {
                        this.space();
                    }
                    this.decompileTypeSpec(tree.down(2), indent, precedence, context);
                    break;
                }
                case 13: 
                case 91: 
                case 154: {
                    Tree[] pair2 = this.buildDeclaratorFromType(tree, ILUtils.build(138));
                    this.decompileTypeSpec(pair2[0], indent, precedence, context);
                    this.space();
                    this.decompileDeclarator(pair2[1], indent, precedence, context);
                    break;
                }
                case 161: {
                    boolean emptyVarDecl;
                    boolean bl = emptyVarDecl = tree.down(3).opCode() == 138 || tree.down(3).opCode() == 200 && tree.down(3).length() == 0;
                    if (tree.down(1).opCode() == 96) {
                        if (!tree.down(1).stringValue().startsWith("struct ")) {
                            this.print("struct", indent, "keyword");
                            this.space();
                        }
                        this.printThingName(tree.down(1), indent, "typename");
                        if (!emptyVarDecl) {
                            this.space();
                        }
                    } else {
                        this.print("struct", indent, "keyword");
                        this.space();
                    }
                    if (emptyVarDecl) break;
                    this.print("{", indent, "plain");
                    this.newLine(indent);
                    this.decompile(tree.down(3), indent + 4, 0, context);
                    this.newLine(indent);
                    this.print("}", indent, "plain");
                    break;
                }
                case 195: {
                    boolean emptyVarDecl;
                    boolean bl = emptyVarDecl = tree.down(2).opCode() == 138 || tree.down(2).opCode() == 200 && tree.down(2).length() == 0;
                    if (tree.down(1).opCode() == 96) {
                        if (!tree.down(1).stringValue().startsWith("union ")) {
                            this.print("union", indent, "keyword");
                            this.space();
                        }
                        this.printThingName(tree.down(1), indent, "typename");
                        if (!emptyVarDecl) {
                            this.space();
                        }
                    } else {
                        this.print("union", indent, "keyword");
                        this.space();
                    }
                    if (emptyVarDecl) break;
                    this.print("{", indent, "plain");
                    this.newLine(indent);
                    this.decompile(tree.down(2), indent + 4, 0, context);
                    this.newLine(indent);
                    this.print("}", indent, "plain");
                    break;
                }
                case 67: {
                    if (tree.down(1).opCode() == 96) {
                        if (!tree.down(1).stringValue().startsWith("enum ")) {
                            this.print("enum", indent, "keyword");
                            this.space();
                        }
                        this.printThingName(tree.down(1), indent, "typename");
                        this.space();
                    } else {
                        this.print("enum", indent, "keyword");
                        this.space();
                    }
                    if (tree.down(2).opCode() != 54) break;
                    this.print("{", indent, "plain");
                    this.decompileDeclarator(tree.down(2), indent, precedence, context);
                    this.print("}", indent, "plain");
                    break;
                }
                case 164: {
                    this.decompileTypeSpec(tree.down(1), indent, precedence, context);
                    this.print("&", indent, "plain");
                    break;
                }
                case 173: {
                    this.decompileTypeSpec(tree.down(1), indent, precedence, context);
                    this.print("::", indent, "plain");
                    this.decompileTypeSpec(tree.down(2), indent, precedence, context);
                    break;
                }
                case 138: {
                    break;
                }
                default: {
                    TapEnv.toolWarning(-1, "(C decompiler) [WrapperTypeSpec] Unexpected operator " + tree.opName());
                }
            }
        }
        this.postDecompile(tree, indent);
    }

    private void decompileModifiers(Tree tree, int indent, int context) throws IOException {
        switch (tree.opCode()) {
            case 130: {
                Tree[] elements = tree.children();
                TapList<Tree> sortedModifiers = this.sortModifiers(elements);
                while (sortedModifiers != null) {
                    this.decompileModifiers((Tree)sortedModifiers.head, indent, context);
                    if (sortedModifiers.tail != null) {
                        this.space();
                    }
                    sortedModifiers = sortedModifiers.tail;
                }
                break;
            }
            case 96: {
                String modifierText = tree.stringValue();
                if (modifierText == null) break;
                if (modifierText.equals("private") || modifierText.equals("save")) {
                    this.print("static", indent, "modifier");
                    break;
                }
                if (modifierText.equals("external")) {
                    this.print("extern", indent, "modifier");
                    break;
                }
                this.print(modifierText, indent, "modifier");
                break;
            }
            case 103: 
            case 138: {
                break;
            }
            default: {
                TapEnv.toolWarning(-1, "(C decompiler) [Modifier] Unexpected operator " + tree.opName());
            }
        }
    }

    private void decompileExpression(Tree tree, int indent, int precedence, int context) throws IOException {
        this.preDecompile(tree, indent);
        block0 : switch (tree.opCode()) {
            case 194: {
                String opStr;
                switch (opStr = tree.down(1).stringValue()) {
                    case "++prefix": {
                        this.decompileUnaryExprPrefix(tree.down(2), indent, precedence, context, "++", 29, 29);
                        break block0;
                    }
                    case "--prefix": {
                        this.decompileUnaryExprPrefix(tree.down(2), indent, precedence, context, "--", 29, 29);
                        break block0;
                    }
                    case "++postfix": {
                        this.decompileUnaryExprPostfix(tree.down(2), indent, precedence, context, "++", 31, 31);
                        break block0;
                    }
                    case "--postfix": {
                        this.decompileUnaryExprPostfix(tree.down(2), indent, precedence, context, "--", 31, 31);
                        break block0;
                    }
                    case "~": {
                        this.decompileUnaryExprPrefix(tree.down(2), indent, precedence, context, "~", 29, 29);
                        break block0;
                    }
                    case "+": {
                        this.decompileUnaryExprPrefix(tree.down(2), indent, precedence, context, "+", 29, 29);
                        break block0;
                    }
                }
                this.decompileUnaryExprPrefix(tree.down(2), indent, precedence, context, opStr, 35, 35);
                break;
            }
            case 124: {
                this.decompileUnaryExprPrefix(tree.down(1), indent, precedence, context, "-", 29, 29);
                break;
            }
            case 139: {
                this.decompileUnaryExprPrefix(tree.down(1), indent, precedence, context, "!", 29, 29);
                break;
            }
            case 21: {
                this.decompileUnaryExprPrefix(tree.down(1), indent, precedence, context, "~", 29, 29);
                break;
            }
            case 17: {
                int rightPrecedence;
                int leftPrecedence;
                int maxPrecedence;
                String opStr;
                switch (opStr = tree.down(1).stringValue()) {
                    case "|": {
                        maxPrecedence = 11;
                        leftPrecedence = 11;
                        rightPrecedence = 12;
                        break;
                    }
                    case "&": {
                        maxPrecedence = 15;
                        leftPrecedence = 15;
                        rightPrecedence = 16;
                        break;
                    }
                    case "^": {
                        maxPrecedence = 13;
                        leftPrecedence = 13;
                        rightPrecedence = 14;
                        break;
                    }
                    default: {
                        maxPrecedence = 33;
                        leftPrecedence = 33;
                        rightPrecedence = 34;
                    }
                }
                this.decompileBinaryExpr(tree.down(2), tree.down(3), indent, precedence, context, tree.opCode(), opStr, maxPrecedence, leftPrecedence, rightPrecedence);
                break;
            }
            case 3: {
                this.decompileBinaryExpr(tree.down(1), tree.down(2), indent, precedence, context, tree.opCode(), "+", 23, 23, 24);
                break;
            }
            case 182: {
                this.decompileBinaryExpr(tree.down(1), tree.down(2), indent, precedence, context, tree.opCode(), "-", 23, 23, 24);
                break;
            }
            case 133: {
                this.decompileBinaryExpr(tree.down(1), tree.down(2), indent, precedence, context, tree.opCode(), "*", 25, 25, 26);
                break;
            }
            case 62: {
                this.decompileBinaryExpr(tree.down(1), tree.down(2), indent, precedence, context, tree.opCode(), "/", 25, 25, 26);
                break;
            }
            case 155: {
                boolean power2;
                boolean bl = power2 = tree.down(2).opCode() == 103 && tree.down(2).intValue() == 2;
                if (power2) {
                    this.decompileBinaryExpr(tree.down(1), tree.down(1), indent, precedence, context, tree.opCode(), "*", 25, 25, 26);
                    break;
                }
                this.print("pow(", indent, "plain");
                this.decompileExpression(tree.down(1), indent, 32, context);
                this.print(",", indent, "plain");
                this.space();
                this.decompileExpression(tree.down(2), indent, 32, context);
                this.print(")", indent, "plain");
                break;
            }
            case 116: {
                this.decompileBinaryExpr(tree.down(1), tree.down(2), indent, precedence, context, tree.opCode(), "<<", 21, 21, 22);
                break;
            }
            case 169: {
                this.decompileBinaryExpr(tree.down(1), tree.down(2), indent, precedence, context, tree.opCode(), ">>", 21, 21, 22);
                break;
            }
            case 126: {
                this.decompileBinaryExpr(tree.down(1), tree.down(2), indent, precedence, context, tree.opCode(), "%", 25, 25, 26);
                break;
            }
            case 68: {
                this.decompileBinaryExpr(tree.down(1), tree.down(2), indent, precedence, context, tree.opCode(), "==", 17, 17, 17);
                break;
            }
            case 137: {
                this.decompileBinaryExpr(tree.down(1), tree.down(2), indent, precedence, context, tree.opCode(), "!=", 17, 17, 17);
                break;
            }
            case 92: {
                this.decompileBinaryExpr(tree.down(1), tree.down(2), indent, precedence, context, tree.opCode(), ">=", 19, 19, 20);
                break;
            }
            case 95: {
                this.decompileBinaryExpr(tree.down(1), tree.down(2), indent, precedence, context, tree.opCode(), ">", 19, 19, 20);
                break;
            }
            case 115: {
                this.decompileBinaryExpr(tree.down(1), tree.down(2), indent, precedence, context, tree.opCode(), "<=", 19, 19, 20);
                break;
            }
            case 122: {
                this.decompileBinaryExpr(tree.down(1), tree.down(2), indent, precedence, context, tree.opCode(), "<", 19, 19, 20);
                break;
            }
            case 6: {
                this.decompileBinaryExpr(tree.down(1), tree.down(2), indent, precedence, context, tree.opCode(), "&&", 9, 9, 10);
                break;
            }
            case 18: {
                this.decompileBinaryExpr(tree.down(1), tree.down(2), indent, precedence, context, tree.opCode(), "&", 9, 9, 10);
                break;
            }
            case 143: {
                this.decompileBinaryExpr(tree.down(1), tree.down(2), indent, precedence, context, tree.opCode(), "||", 7, 7, 8);
                break;
            }
            case 22: {
                this.decompileBinaryExpr(tree.down(1), tree.down(2), indent, precedence, context, tree.opCode(), "|", 7, 7, 8);
                break;
            }
            case 24: {
                this.decompileBinaryExpr(tree.down(1), tree.down(2), indent, precedence, context, tree.opCode(), "^", 13, 13, 14);
                break;
            }
            case 96: {
                this.printAtomValue(tree, indent, "plain");
                break;
            }
            case 44: {
                this.decompileBinaryExpr(tree.down(1), tree.down(2), indent, precedence, context, tree.opCode(), "", 8, 8, 9);
                break;
            }
            case 173: {
                this.decompileBinaryExpr(tree.down(1), tree.down(2), indent, precedence, context, tree.opCode(), "::", 32, 32, 33);
                break;
            }
            case 9: {
                this.decompileExpression(tree.down(1), indent, 31, context);
                Tree[] dims = tree.down(2).children();
                for (int i = dims.length - 1; i >= 0; --i) {
                    this.print("[", indent, "keyword");
                    this.decompileExpression(dims[i], indent, 0, context);
                    this.print("]", indent, "keyword");
                }
                break;
            }
            case 75: {
                if (this.isAStarPointerAccess(tree.down(1))) {
                    boolean paren = this.isAStarPointerAccess(tree.down(1).down(1));
                    if (paren) {
                        this.print("(", indent, "plain");
                    }
                    this.decompileExpression(tree.down(1).down(1), indent, 0, context);
                    if (paren) {
                        this.print(")", indent, "plain");
                    }
                    this.print("->", indent, "keyword");
                } else {
                    this.decompileExpression(tree.down(1), indent, 31, context);
                    this.print(".", indent, "keyword");
                }
                this.decompileExpression(tree.down(2), indent, 32, context);
                break;
            }
            case 151: {
                boolean paren;
                if (ILUtils.isNullOrNone(tree.down(2))) {
                    this.print("*", indent, "keyword");
                    this.decompileExpression(tree.down(1), indent, 30, context);
                    break;
                }
                boolean bl = paren = tree.down(1).opCode() == 151 && !ILUtils.isNullOrNone(tree.down(2)) && ILUtils.isNullOrNone(tree.down(1).down(2));
                if (paren) {
                    this.print("(", indent, "plain");
                }
                this.decompileExpression(tree.down(1), indent, 30, context);
                if (paren) {
                    this.print(")", indent, "plain");
                }
                this.print("[", indent, "keyword");
                this.decompileExpression(tree.down(2), indent, 0, context);
                this.print("]", indent, "keyword");
                break;
            }
            case 47: {
                this.decompileExpression(tree.down(1), indent, 0, context);
                this.print("(", indent, "plain");
                this.decompileExpression(tree.down(3), this.hasContext(context, 7) ? indent : indent + 1, 0, this.contextPlus(context, 7));
                this.print(")", indent, "plain");
                break;
            }
            case 145: {
                this.parallelSpreadSizes = tree.down(2);
                this.decompileExpression(tree.down(3), indent, 0, context);
                this.parallelSpreadSizes = null;
                break;
            }
            case 31: {
                String calledString = ILUtils.getCalledNameString(tree);
                if (!ILUtils.isNullOrNone(ILUtils.getObject(tree))) {
                    this.decompileExpression(ILUtils.getObject(tree), indent, 0, context);
                    this.print(".", indent, "plain");
                    this.decompileExpression(ILUtils.getCalledName(tree), indent, 0, context);
                    if (this.parallelSpreadSizes != null) {
                        this.print("<<<", indent, "plain");
                        this.decompileExpression(this.parallelSpreadSizes, indent, 0, context);
                        this.print(">>>", indent, "plain");
                    }
                    if (!this.hasContext(context, 7)) {
                        indent = this.posX;
                    }
                    this.print("(", indent, "plain");
                    this.decompileExpression(ILUtils.getArguments(tree), this.hasContext(context, 7) ? indent : indent + 1, 0, this.contextPlus(context, 7));
                    this.print(")", indent, "plain");
                    break;
                }
                if ("ifExpression".equals(calledString)) {
                    Tree arguments = ILUtils.getArguments(tree);
                    this.print("(", indent, "plain");
                    this.decompileExpression(arguments.down(1), indent, 5, context);
                    this.space();
                    this.print("?", indent, "plain");
                    this.space();
                    this.decompileExpression(arguments.down(2), indent, 5, context);
                    this.space();
                    this.print(":", indent, "plain");
                    this.space();
                    this.decompileExpression(arguments.down(3), indent, 5, context);
                    this.print(")", indent, "plain");
                    break;
                }
                if ("operator()".equals(calledString)) {
                    Tree[] arguments = ILUtils.getArguments(tree).children();
                    this.decompileExpression(arguments[0], indent, 0, context);
                    if (!this.hasContext(context, 7)) {
                        indent = this.posX;
                    }
                    this.print("(", indent, "plain");
                    for (int i = 1; i < arguments.length; ++i) {
                        if (i != 1) {
                            this.print(",", indent, "plain");
                            this.space();
                        }
                        this.decompileExpression(arguments[i], indent, 0, context);
                    }
                    this.print(")", indent, "plain");
                    break;
                }
                if (calledString != null && calledString.startsWith("operator") && ILUtils.getArguments(tree).length() == 2) {
                    Tree arguments = ILUtils.getArguments(tree);
                    switch (calledString) {
                        case "operator=": {
                            if (precedence > 3) {
                                this.print("(", indent, "plain");
                            }
                            this.decompileExpression(arguments.down(1), indent, 3, context);
                            this.space();
                            this.print("=", indent, "keyword");
                            this.space();
                            this.decompileExpression(arguments.down(2), indent + 4, 4, context);
                            if (precedence <= 3) break;
                            this.print(")", indent, "plain");
                            break;
                        }
                        case "operator&=": {
                            if (precedence > 3) {
                                this.print("(", indent, "plain");
                            }
                            this.decompileExpression(arguments.down(1), indent, 3, context);
                            this.space();
                            this.print("&=", indent, "keyword");
                            this.space();
                            this.decompileExpression(arguments.down(2), indent + 4, 4, context);
                            if (precedence <= 3) break;
                            this.print(")", indent, "plain");
                            break;
                        }
                        case "operator/=": {
                            if (precedence > 3) {
                                this.print("(", indent, "plain");
                            }
                            this.decompileExpression(arguments.down(1), indent, 3, context);
                            this.space();
                            this.print("/=", indent, "keyword");
                            this.space();
                            this.decompileExpression(arguments.down(2), indent + 4, 4, context);
                            if (precedence <= 3) break;
                            this.print(")", indent, "plain");
                            break;
                        }
                        case "operator|=": {
                            if (precedence > 3) {
                                this.print("(", indent, "plain");
                            }
                            this.decompileExpression(arguments.down(1), indent, 3, context);
                            this.space();
                            this.print("|=", indent, "keyword");
                            this.space();
                            this.decompileExpression(arguments.down(2), indent + 4, 4, context);
                            if (precedence <= 3) break;
                            this.print(")", indent, "plain");
                            break;
                        }
                        case "operator<<=": {
                            if (precedence > 3) {
                                this.print("(", indent, "plain");
                            }
                            this.decompileExpression(arguments.down(1), indent, 3, context);
                            this.space();
                            this.print("<<=", indent, "keyword");
                            this.space();
                            this.decompileExpression(arguments.down(2), indent + 4, 4, context);
                            if (precedence <= 3) break;
                            this.print(")", indent, "plain");
                            break;
                        }
                        case "operator-=": {
                            if (precedence > 3) {
                                this.print("(", indent, "plain");
                            }
                            this.decompileExpression(arguments.down(1), indent, 3, context);
                            this.space();
                            this.print("-=", indent, "keyword");
                            this.space();
                            this.decompileExpression(arguments.down(2), indent + 4, 4, context);
                            if (precedence <= 3) break;
                            this.print(")", indent, "plain");
                            break;
                        }
                        case "operator%=": {
                            if (precedence > 3) {
                                this.print("(", indent, "plain");
                            }
                            this.decompileExpression(arguments.down(1), indent, 3, context);
                            this.space();
                            this.print("%=", indent, "keyword");
                            this.space();
                            this.decompileExpression(arguments.down(2), indent + 4, 4, context);
                            if (precedence <= 3) break;
                            this.print(")", indent, "plain");
                            break;
                        }
                        case "operator+=": {
                            if (precedence > 3) {
                                this.print("(", indent, "plain");
                            }
                            this.decompileExpression(arguments.down(1), indent, 3, context);
                            this.space();
                            this.print("+=", indent, "keyword");
                            this.space();
                            this.decompileExpression(arguments.down(2), indent + 4, 4, context);
                            if (precedence <= 3) break;
                            this.print(")", indent, "plain");
                            break;
                        }
                        case "operator*=": {
                            if (precedence > 3) {
                                this.print("(", indent, "plain");
                            }
                            this.decompileExpression(arguments.down(1), indent, 3, context);
                            this.space();
                            this.print("*=", indent, "keyword");
                            this.space();
                            this.decompileExpression(arguments.down(2), indent + 4, 4, context);
                            if (precedence <= 3) break;
                            this.print(")", indent, "plain");
                            break;
                        }
                        case "operator^=": {
                            if (precedence > 3) {
                                this.print("(", indent, "plain");
                            }
                            this.decompileExpression(arguments.down(1), indent, 3, context);
                            this.space();
                            this.print("^=", indent, "keyword");
                            this.space();
                            this.decompileExpression(arguments.down(2), indent + 4, 4, context);
                            if (precedence <= 3) break;
                            this.print(")", indent, "plain");
                            break;
                        }
                        case "operator>>=": {
                            if (precedence > 3) {
                                this.print("(", indent, "plain");
                            }
                            this.decompileExpression(arguments.down(1), indent, 3, context);
                            this.space();
                            this.print(">>=", indent, "keyword");
                            this.space();
                            this.decompileExpression(arguments.down(2), indent + 4, 4, context);
                            if (precedence <= 3) break;
                            this.print(")", indent, "plain");
                            break;
                        }
                        case "operator[]": {
                            boolean paren;
                            boolean bl = paren = arguments.down(1).opCode() == 151 && !ILUtils.isNullOrNone(arguments.down(2)) && ILUtils.isNullOrNone(arguments.down(1).down(2));
                            if (paren) {
                                this.print("(", indent, "plain");
                            }
                            this.decompileExpression(arguments.down(1), indent, 30, context);
                            if (paren) {
                                this.print(")", indent, "plain");
                            }
                            this.print("[", indent, "keyword");
                            this.decompileExpression(arguments.down(2), indent, 0, context);
                            this.print("]", indent, "keyword");
                            break;
                        }
                        case "operator->": {
                            this.decompileBinaryExpr(arguments.down(1), arguments.down(2), indent, precedence, context, -1, "->", 31, 31, 32);
                            break;
                        }
                        case "operator<<": {
                            this.decompileBinaryExpr(arguments.down(1), arguments.down(2), indent, precedence, context, -1, "<<", 21, 21, 22);
                            break;
                        }
                        case "operator>>": {
                            this.decompileBinaryExpr(arguments.down(1), arguments.down(2), indent, precedence, context, -1, ">>", 21, 21, 22);
                            break;
                        }
                        case "operator==": {
                            this.decompileBinaryExpr(arguments.down(1), arguments.down(2), indent, precedence, context, -1, "==", 17, 17, 17);
                            break;
                        }
                        case "operator!=": {
                            this.decompileBinaryExpr(arguments.down(1), arguments.down(2), indent, precedence, context, -1, "!=", 17, 17, 17);
                            break;
                        }
                        case "operator>=": {
                            this.decompileBinaryExpr(arguments.down(1), arguments.down(2), indent, precedence, context, -1, ">=", 19, 19, 20);
                            break;
                        }
                        case "operator>": {
                            this.decompileBinaryExpr(arguments.down(1), arguments.down(2), indent, precedence, context, -1, ">", 19, 19, 20);
                            break;
                        }
                        case "operator<=": {
                            this.decompileBinaryExpr(arguments.down(1), arguments.down(2), indent, precedence, context, -1, "<=", 19, 19, 20);
                            break;
                        }
                        case "operator<": {
                            this.decompileBinaryExpr(arguments.down(1), arguments.down(2), indent, precedence, context, -1, "<", 19, 19, 20);
                            break;
                        }
                        case "operator%": {
                            this.decompileBinaryExpr(arguments.down(1), arguments.down(2), indent, precedence, context, -1, "%", 25, 25, 26);
                            break;
                        }
                        case "operator+": {
                            this.decompileBinaryExpr(arguments.down(1), arguments.down(2), indent, precedence, context, -1, "+", 23, 23, 24);
                            break;
                        }
                        case "operator-": {
                            this.decompileBinaryExpr(arguments.down(1), arguments.down(2), indent, precedence, context, -1, "-", 23, 23, 24);
                            break;
                        }
                        case "operator*": {
                            this.decompileBinaryExpr(arguments.down(1), arguments.down(2), indent, precedence, context, -1, "*", 25, 25, 26);
                            break;
                        }
                        case "operator/": {
                            this.decompileBinaryExpr(arguments.down(1), arguments.down(2), indent, precedence, context, -1, "/", 25, 25, 26);
                            break;
                        }
                        case "operator&": {
                            this.decompileBinaryExpr(arguments.down(1), arguments.down(2), indent, precedence, context, -1, "&", 9, 9, 10);
                            break;
                        }
                        case "operator|": {
                            this.decompileBinaryExpr(arguments.down(1), arguments.down(2), indent, precedence, context, -1, "|", 7, 7, 8);
                            break;
                        }
                    }
                    break;
                }
                Tree annot = (Tree)tree.getAnnotation("sourcetree");
                if (annot != null) {
                    if (annot.opCode() == 194) {
                        String opStr;
                        switch (opStr = annot.down(1).stringValue()) {
                            case "++prefix": {
                                this.decompileUnaryExprPrefix(annot.down(2), indent, precedence, context, "++", 29, 29);
                                break block0;
                            }
                            case "--prefix": {
                                this.decompileUnaryExprPrefix(annot.down(2), indent, precedence, context, "--", 29, 29);
                                break block0;
                            }
                            case "++postfix": {
                                this.decompileUnaryExprPostfix(annot.down(2), indent, precedence, context, "++", 31, 31);
                                break block0;
                            }
                            case "--postfix": {
                                this.decompileUnaryExprPostfix(annot.down(2), indent, precedence, context, "--", 31, 31);
                                break block0;
                            }
                            case "~": {
                                this.decompileUnaryExprPrefix(annot.down(2), indent, precedence, context, "~", 29, 29);
                                break block0;
                            }
                            case "+": {
                                this.decompileUnaryExprPrefix(annot.down(2), indent, precedence, context, "+", 29, 29);
                                break block0;
                            }
                        }
                        this.decompileUnaryExprPrefix(annot.down(2), indent, precedence, context, opStr, 35, 35);
                        break;
                    }
                    if (annot.opCode() == 17) {
                        this.decompileExpression(annot, indent, precedence, context);
                        break;
                    }
                    this.decompileExpression(annot, indent, precedence, context);
                    break;
                }
                boolean paren = false;
                if (this.isAStarPointerAccess(ILUtils.getCalledName(tree))) {
                    paren = true;
                }
                if (paren) {
                    this.print("(", indent, "plain");
                }
                this.decompileExpression(ILUtils.getCalledName(tree), indent, 0, context);
                if (paren) {
                    this.print(")", indent, "plain");
                }
                if (!this.hasContext(context, 7)) {
                    indent = this.posX;
                }
                if (this.parallelSpreadSizes != null) {
                    this.print("<<<", indent, "plain");
                    this.decompileExpression(this.parallelSpreadSizes, indent, 0, context);
                    this.print(">>>", indent, "plain");
                }
                this.print("(", indent, "plain");
                this.decompileExpression(ILUtils.getArguments(tree), this.hasContext(context, 7) ? indent : indent + 1, 0, this.contextPlus(context, 7));
                this.print(")", indent, "plain");
                break;
            }
            case 109: {
                this.decompileExpression(tree.down(1), indent, 31, context);
                this.print("(", indent, "plain");
                indent = this.posX;
                this.decompileExpression(tree.down(3), indent, 0, context);
                this.print(")", indent, "plain");
                break;
            }
            case 4: {
                boolean paren;
                boolean paren0;
                boolean bl = paren0 = precedence > 29;
                if (paren0) {
                    this.print("(", indent, "plain");
                }
                this.print("&", indent, "keyword");
                boolean bl2 = paren = tree.down(1).opCode() != 96;
                if (paren) {
                    this.print("(", indent, "plain");
                }
                this.decompileExpression(tree.down(1), indent, 29, context);
                if (paren) {
                    this.print(")", indent, "plain");
                }
                if (!paren0) break;
                this.print(")", indent, "plain");
                break;
            }
            case 32: {
                this.print("(", indent, "plain");
                this.decompileTypeSpec(tree.down(1), indent, 0, context);
                this.print(")", indent, "plain");
                this.decompileExpression(tree.down(2), indent, 29, context);
                break;
            }
            case 176: {
                this.print("sizeof(", indent, "operator");
                if (this.isTypeSpec(tree.down(1))) {
                    this.decompileTypeSpec(tree.down(1), indent, 29, context);
                } else {
                    this.decompileExpression(tree.down(1), indent, 29, context);
                }
                this.print(")", indent, "operator");
                break;
            }
            case 14: {
                Tree annot = (Tree)tree.getAnnotation("sourcetree");
                if (annot != null) {
                    this.decompileExpression(annot, indent, precedence, context);
                    break;
                }
                if (precedence > 3) {
                    this.print("(", indent, "plain");
                }
                this.decompileExpression(tree.down(1), indent, 3, context);
                this.space();
                this.print("=", indent, "plain");
                this.space();
                this.decompileExpression(tree.down(2), indent + 4, 4, context);
                if (precedence <= 3) break;
                this.print(")", indent, "plain");
                break;
            }
            case 19: {
                this.decompileExpression(tree.down(1), indent, 3, context);
                this.space();
                this.print("&=", indent, "keyword");
                this.space();
                this.decompileExpression(tree.down(2), indent, 4, context);
                break;
            }
            case 63: {
                this.decompileExpression(tree.down(1), indent, 3, context);
                this.space();
                this.print("/=", indent, "keyword");
                this.space();
                this.decompileExpression(tree.down(2), indent, 4, context);
                break;
            }
            case 23: {
                this.decompileExpression(tree.down(1), indent, 3, context);
                this.space();
                this.print("|=", indent, "keyword");
                this.space();
                this.decompileExpression(tree.down(2), indent, 4, context);
                break;
            }
            case 117: {
                this.decompileExpression(tree.down(1), indent, 3, context);
                this.space();
                this.print("<<=", indent, "keyword");
                this.space();
                this.decompileExpression(tree.down(2), indent, 4, context);
                break;
            }
            case 125: {
                this.decompileExpression(tree.down(1), indent, 3, context);
                this.space();
                this.print("-=", indent, "keyword");
                this.space();
                this.decompileExpression(tree.down(2), indent, 4, context);
                break;
            }
            case 127: {
                this.decompileExpression(tree.down(1), indent, 3, context);
                this.space();
                this.print("%=", indent, "keyword");
                this.space();
                this.decompileExpression(tree.down(2), indent, 4, context);
                break;
            }
            case 150: {
                this.decompileExpression(tree.down(1), indent, 3, context);
                this.space();
                this.print("+=", indent, "keyword");
                this.space();
                this.decompileExpression(tree.down(2), indent, 4, context);
                break;
            }
            case 190: {
                this.decompileExpression(tree.down(1), indent, 3, context);
                this.space();
                this.print("*=", indent, "keyword");
                this.space();
                this.decompileExpression(tree.down(2), indent, 4, context);
                break;
            }
            case 25: {
                this.decompileExpression(tree.down(1), indent, 3, context);
                this.space();
                this.print("^=", indent, "keyword");
                this.space();
                this.decompileExpression(tree.down(2), indent, 4, context);
                break;
            }
            case 170: {
                this.decompileExpression(tree.down(1), indent, 3, context);
                this.space();
                this.print(">>=", indent, "keyword");
                this.space();
                this.decompileExpression(tree.down(2), indent, 4, context);
                break;
            }
            case 10: {
                this.print("{", indent, "plain");
                Tree[] elements = tree.children();
                for (int i = 0; i < elements.length; ++i) {
                    if (i > 0) {
                        this.print(",", indent + 4, "plain");
                        this.space();
                    }
                    this.decompileExpression(elements[i], indent + 4, 0, context);
                }
                this.print("}", indent, "plain");
                break;
            }
            case 180: {
                this.printString("\"" + tree.stringValue() + "\"");
                break;
            }
            case 20: 
            case 103: 
            case 160: {
                this.printAtomValue(tree, indent, "constant");
                break;
            }
            case 42: {
                if (ILUtils.isZero(tree.down(2))) {
                    this.decompileExpression(tree.down(1), indent, 23, context);
                    break;
                }
                if (ILUtils.isZero(tree.down(1))) {
                    this.decompileExpression(tree.down(2), indent, 25, context);
                    this.print("*", indent, "plain");
                    this.print("1.0iF", indent, "constant");
                    break;
                }
                this.print("(", indent, "plain");
                this.decompileExpression(tree.down(1), indent, 23, context);
                this.print("+", indent, "plain");
                this.decompileExpression(tree.down(2), indent, 25, context);
                this.print("*", indent, "plain");
                this.print("1.0iF", indent, "constant");
                this.print(")", indent, "plain");
                break;
            }
            case 118: {
                this.print("'" + tree.stringValue() + "'", indent, "plain");
                break;
            }
            case 111: {
                this.printLabel(tree, indent);
                break;
            }
            case 74: 
            case 100: 
            case 138: {
                break;
            }
            case 27: 
            case 71: {
                Tree[] sons = tree.children();
                for (int i = 0; i < sons.length; ++i) {
                    if (sons[i].opCode() == 199) {
                        this.decompile(sons[i], indent, precedence, this.contextPlus(context, 5));
                    } else {
                        this.decompileExpression(sons[i], indent, precedence, context);
                    }
                    if (i + 1 >= sons.length) continue;
                    this.print(",", indent, "plain");
                    this.space();
                }
                break;
            }
            case 181: {
                Tree[] sons = tree.children();
                for (int i = 0; i < sons.length; ++i) {
                    if (sons[i].opCode() == 180) {
                        this.decompileExpression(sons[i], indent, precedence, context);
                        if (i + 1 >= sons.length) continue;
                        this.space();
                        continue;
                    }
                    TapEnv.toolWarning(-1, "(C decompiler) Unexpected operator in strings " + sons[i].opName());
                }
                break;
            }
            case 99: {
                this.print("(", indent, "plain");
                this.decompileExpression(tree.down(1), indent, 5, context);
                this.space();
                this.print("?", indent, "plain");
                this.space();
                this.decompileExpression(tree.down(2), indent, 5, context);
                this.space();
                this.print(":", indent, "plain");
                this.space();
                this.decompileExpression(tree.down(3), indent, 5, context);
                this.print(")", indent, "plain");
                break;
            }
            case 59: {
                if (tree.down(2).opCode() == 138 || tree.down(1).opCode() != 138 && !ILUtils.evalsToZero(tree.down(1))) break;
                this.decompileExpression(ILUtils.addTree(ILUtils.copy(tree.down(2)), ILUtils.build(103, 1)), indent, 0, context);
                break;
            }
            case 28: {
                this.print(tree.stringValue(), indent, "constant");
                break;
            }
            case 39: {
                this.print("common", indent, "keyword");
                this.space();
                if (ILUtils.isNotNone(tree.down(1))) {
                    this.print(tree.down(1).stringValue(), indent, "vardecl");
                } else {
                    this.print("//", indent, "vardecl");
                }
                this.space();
                this.decompile(tree.down(2), indent, 0, this.contextPlus(context, 9));
                break;
            }
            case 51: {
                this.print("data", indent, "keyword");
                this.space();
                this.decompile(tree.down(1), indent + 4, 0, 0);
                this.space();
                this.print("/", indent + 3, "plain");
                this.decompile(tree.down(2), indent + 5, 0, this.contextPlus(this.contextPlus(context, 7), 8));
                this.print("/", indent + 4, "plain");
                break;
            }
            case 69: {
                this.print("equivalence", indent, "keyword");
                Tree[] sons = tree.children();
                for (int i = 0; i < sons.length; ++i) {
                    this.space();
                    this.print("(", indent + 4, "plain");
                    this.decompile(sons[i], indent + 5, 0, context);
                    this.print(")", indent + 4, "plain");
                    if (i >= sons.length - 1) continue;
                    this.print(",", indent + 4, "plain");
                    this.space();
                }
                break;
            }
            case 108: {
                this.print("intrinsic", indent, "keyword");
                this.space();
                Tree[] sons = tree.children();
                for (int i = 0; i < sons.length; ++i) {
                    this.decompile(sons[i], indent + 4, 0, this.contextPlus(context, 10));
                    if (i >= sons.length - 1) continue;
                    this.print(",", indent + 4, "plain");
                    this.space();
                }
                break;
            }
            case 171: {
                this.print("save", indent, "keyword");
                this.space();
                Tree[] sons = tree.children();
                for (int i = 0; i < sons.length; ++i) {
                    this.decompile(sons[i], indent + 4, 0, context);
                    if (i >= sons.length - 1) continue;
                    this.print(",", indent + 4, "plain");
                    this.space();
                }
                break;
            }
            case 177: {
                this.print("*", indent, "keyword");
                break;
            }
            case 179: {
                this.print("stop", indent, "keyword");
                break;
            }
            case 26: 
            case 90: 
            case 128: 
            case 153: {
                this.decompileDeclarator(tree, indent, precedence, context);
                break;
            }
            case 198: {
                this.print("using", indent, "keyword");
                this.space();
                this.decompileExpression(tree.down(1), indent, precedence, context);
                this.print("::", indent, "keyword");
                this.decompileExpression(tree.down(2), indent, precedence, context);
                break;
            }
            case 87: {
                this.decompileExpression(tree.down(1), indent, precedence, context);
                break;
            }
            default: {
                if (this.isTypeSpec(tree)) {
                    this.decompileTypeSpec(tree, indent, precedence, context);
                    break;
                }
                TapEnv.toolWarning(-1, "(C decompiler) [Expression] Unexpected operator " + tree.opName());
            }
        }
        this.postDecompile(tree, indent);
    }

    private void decompileUnaryExprPrefix(Tree subTree, int indent, int curPrecedence, int context, String op, int maxPrecedence, int sonPrecedence) throws IOException {
        if (curPrecedence >= 25 || maxPrecedence >= 25) {
            context = this.contextPlus(context, 8);
        }
        if (curPrecedence > maxPrecedence) {
            this.print("(", indent, "plain");
        }
        if (op != null) {
            this.print(op, indent, "plain");
        }
        this.decompileExpression(subTree, indent, sonPrecedence, this.contextPlus(context, 7));
        if (curPrecedence > maxPrecedence) {
            this.print(")", indent, "plain");
        }
    }

    private void decompileUnaryExprPostfix(Tree subTree, int indent, int curPrecedence, int context, String op, int maxPrecedence, int sonPrecedence) throws IOException {
        if (curPrecedence >= 25 || maxPrecedence >= 25) {
            context = this.contextPlus(context, 8);
        }
        if (curPrecedence > maxPrecedence) {
            this.print("(", indent, "plain");
        }
        this.decompileExpression(subTree, indent, sonPrecedence, this.contextPlus(context, 7));
        if (op != null) {
            this.print(op, indent, "plain");
        }
        if (curPrecedence > maxPrecedence) {
            this.print(")", indent, "plain");
        }
    }

    private void decompileBinaryExpr(Tree leftTree, Tree rightTree, int indent, int curPrecedence, int context, int operator, String op, int maxPrecedence, int leftPrecedence, int rightPrecedence) throws IOException {
        boolean rightParen;
        boolean leftParen = operator == 133 && this.isAStarPointerAccess(leftTree);
        boolean bl = rightParen = (operator == 133 || operator == 62) && this.isAStarPointerAccess(rightTree);
        if (curPrecedence >= 25 || maxPrecedence >= 25) {
            context = this.contextPlus(context, 8);
        }
        if (curPrecedence > maxPrecedence) {
            this.print("(", indent, "plain");
        }
        if (leftParen) {
            this.print("(", indent, "plain");
        }
        this.decompileExpression(leftTree, indent, leftPrecedence, this.contextPlus(context, 7));
        if (leftParen) {
            this.print(")", indent, "plain");
        }
        if (!this.hasContext(context, 8) && leftTree.opCode() != 138) {
            this.space();
        }
        this.print(op, indent, "plain");
        if (!this.hasContext(context, 8) && rightTree.opCode() != 138) {
            this.space();
        }
        if (rightParen) {
            this.print("(", indent, "plain");
        }
        this.decompileExpression(rightTree, indent, rightPrecedence, this.contextPlus(context, 7));
        if (rightParen) {
            this.print(")", indent, "plain");
        }
        if (curPrecedence > maxPrecedence) {
            this.print(")", indent, "plain");
        }
    }

    private void decompileDeclarator(Tree tree, int indent, int precedence, int context) throws IOException {
        this.preDecompile(tree, indent);
        switch (tree.opCode()) {
            case 54: {
                Tree[] sons = tree.children();
                for (int i = 0; i < sons.length; ++i) {
                    this.decompileDeclarator(sons[i], indent, precedence, context);
                    if (i + 1 >= sons.length) continue;
                    this.print(",", indent, "plain");
                    this.space();
                }
                break;
            }
            case 14: {
                this.decompileDeclarator(tree.down(1), indent, 3, context);
                this.space();
                this.print("=", indent, "plain");
                this.space();
                if (tree.down(2).opCode() == 71) {
                    this.print("{", indent, "plain");
                }
                this.decompileExpression(tree.down(2), indent, 4, context);
                if (tree.down(2).opCode() != 71) break;
                this.print("}", indent, "plain");
                break;
            }
            case 11: {
                if (precedence > 31) {
                    this.print("(", indent, "plain");
                }
                this.decompileDeclarator(tree.down(1), indent, 31, context);
                this.decompileDeclarator(tree.down(2), indent, precedence, context);
                if (precedence <= 31) break;
                this.print(")", indent, "plain");
                break;
            }
            case 60: {
                Tree[] sons;
                for (Tree son : sons = tree.children()) {
                    this.decompileDeclarator(son, indent, precedence, context);
                }
                break;
            }
            case 59: {
                if (tree.down(2).opCode() == 138) {
                    this.print("[]", indent, "plain");
                    break;
                }
                this.print("[", indent, "plain");
                if (tree.down(1).opCode() != 138 && !ILUtils.evalsToZero(tree.down(1))) {
                    if (tree.down(2).opCode() != 177) {
                        this.decompileExpression(ILUtils.subTree(ILUtils.copy(tree.down(2)), ILUtils.copy(tree.down(1))), indent, 0, context);
                    }
                } else {
                    this.decompileExpression(ILUtils.addTree(ILUtils.copy(tree.down(2)), ILUtils.build(103, 1)), indent, 0, context);
                }
                this.print("]", indent, "plain");
                break;
            }
            case 96: {
                this.printAtomValue(tree, indent, "plain");
                break;
            }
            case 153: {
                if (precedence > 30) {
                    this.print("(", indent, "plain");
                }
                this.print("*", indent, "keyword");
                this.decompileDeclarator(tree.down(1), indent, 30, context);
                if (precedence <= 30) break;
                this.print(")", indent, "plain");
                break;
            }
            case 128: {
                this.decompileModifiers(tree.down(1), indent, context);
                this.space();
                this.decompileDeclarator(tree.down(2), indent, precedence, context);
                break;
            }
            case 26: {
                this.decompileDeclarator(tree.down(1), indent, precedence, context);
                this.print(":", indent, "plain");
                this.decompileExpression(tree.down(2), indent, precedence, context);
                break;
            }
            case 90: {
                if (precedence > 31) {
                    this.print("(", indent, "plain");
                }
                this.decompileDeclarator(tree.down(1), indent, 31, context);
                if (tree.down(2).opCode() == 138) {
                    this.print("()", indent, "plain");
                } else {
                    this.print("(", indent + 4, "plain");
                    this.decompileDeclarator(tree.down(2), indent + 4, 0, context);
                    this.print(")", indent + 4, "plain");
                }
                if (precedence <= 31) break;
                this.print(")", indent, "plain");
                break;
            }
            case 163: {
                this.print("&", indent, "plain");
                this.decompileDeclarator(tree.down(1), indent, precedence, context);
                break;
            }
            case 8: {
                Tree[] sons = tree.children();
                if (sons.length == 0) {
                    this.print("void", indent, "plain");
                    break;
                }
                for (int i = 0; i < sons.length; ++i) {
                    if (this.isTypeSpec(sons[i])) {
                        this.decompileTypeSpec(sons[i], indent, precedence, context);
                    } else {
                        this.decompileDeclarator(sons[i], indent, precedence, context);
                    }
                    if (i >= sons.length - 1) continue;
                    this.print(",", indent, "plain");
                    this.space();
                }
                break;
            }
            case 199: {
                this.decompile(tree, indent, precedence, this.contextPlus(context, 5));
                break;
            }
            case 203: {
                this.print("...", indent, "plain");
                break;
            }
            case 138: {
                break;
            }
            default: {
                TapEnv.toolWarning(-1, "(C decompiler) [SimpleDeclarator] Unexpected operator " + tree.opName());
            }
        }
        this.postDecompile(tree, indent);
    }

    private void decompileLoop(Tree tree, int indent, int precedence, int context) throws IOException {
        this.preDecompile(tree, indent);
        Tree control = tree.down(3);
        Tree body = tree.down(4);
        Tree label = tree.down(2);
        context = this.contextMinus(context, 6);
        switch (control.opCode()) {
            case 206: {
                boolean braces;
                this.print("while", indent, "keyword");
                this.print("(", indent, "plain");
                this.decompileExpression(control.down(1), indent, precedence, context);
                this.print(")", indent, "plain");
                boolean bl = braces = CDecompiler.hasDeclsOrIsLongOrIsEmpty(body, true) || label.opCode() != 138;
                if (braces) {
                    this.space();
                    this.print("{", indent, "plain");
                    context = this.contextPlus(context, 6);
                }
                this.newLine(indent);
                this.decompile(body, indent + 4, precedence, context);
                if (label.opCode() != 138) {
                    this.newLine(indent);
                    this.decompileExpression(label, indent - 2, 0, context);
                    this.print(": ;", indent, "plain");
                    this.newLine(indent);
                }
                if (!braces) break;
                this.newLine(indent);
                this.print("}", indent, "plain");
                break;
            }
            case 196: {
                this.print("do", indent, "keyword");
                boolean braces = CDecompiler.hasDeclsOrIsLongOrIsEmpty(body, true) || label.opCode() != 138;
                int context2 = context;
                if (braces) {
                    this.space();
                    this.print("{", indent, "plain");
                    context2 = this.contextPlus(context, 6);
                }
                this.newLine(indent);
                this.decompile(body, indent + 4, precedence, context2);
                if (label.opCode() != 138) {
                    this.newLine(indent);
                    this.decompileExpression(label, indent - 2, 0, context);
                    this.print(": ;", indent, "plain");
                }
                this.newLine(indent);
                if (braces) {
                    this.print("}", indent, "plain");
                    this.space();
                }
                this.print("while", indent, "keyword");
                this.print("(", indent, "plain");
                this.decompileExpression(control.down(1), indent, precedence, context);
                this.print(");", indent, "plain");
                break;
            }
            case 79: {
                boolean braces;
                boolean multiForBounds = control.down(1) != null && control.down(1).opCode() == 27 || control.down(2) != null && control.down(2).opCode() == 27 || control.down(3) != null && control.down(3).opCode() == 27;
                this.print("for", indent, "keyword");
                this.space();
                this.print("(", indent + 3, "plain");
                if (control.down(1).opCode() == 199) {
                    this.decompile(control.down(1), indent + 5, precedence, this.contextPlus(context, 5));
                } else {
                    this.decompileExpression(control.down(1), indent + 5, precedence, context);
                }
                this.print(";", indent + 5, "plain");
                this.space();
                if (multiForBounds) {
                    this.newLine(indent + 5);
                }
                if (control.down(2).opCode() == 199) {
                    this.decompile(control.down(2), indent + 5, precedence, this.contextPlus(context, 5));
                } else {
                    this.decompileExpression(control.down(2), indent + 5, precedence, context);
                }
                this.print(";", indent + 5, "plain");
                this.space();
                if (multiForBounds) {
                    this.newLine(indent + 5);
                }
                this.decompileExpression(control.down(3), indent + 5, precedence, context);
                this.print(")", indent + 3, "plain");
                boolean bl = braces = CDecompiler.hasDeclsOrIsLongOrIsEmpty(body, true) || label.opCode() != 138;
                if (braces) {
                    this.space();
                    this.print("{", indent + 2, "plain");
                    context = this.contextPlus(context, 6);
                }
                this.newLine(indent);
                this.decompile(body, indent + 4, precedence, context);
                if (label.opCode() != 138) {
                    this.newLine(indent);
                    this.decompileExpression(label, indent - 2, 0, context);
                    this.print(": ;", indent, "plain");
                }
                if (!braces) break;
                this.newLine(indent);
                this.print("}", indent, "plain");
                break;
            }
            case 80: {
                this.print("for", indent, "keyword");
                this.space();
                this.print("(", indent + 3, "plain");
                Tree[] ranges = control.down(1).children();
                for (int i = 0; i < ranges.length; ++i) {
                    this.decompile(ranges[i], indent + 5, precedence, context);
                    if (i >= ranges.length - 1) continue;
                    this.print(",", indent + 5, "plain");
                    this.space();
                }
                this.print(")", indent + 3, "plain");
                boolean braces = CDecompiler.hasDeclsOrIsLongOrIsEmpty(body, true);
                if (braces) {
                    this.space();
                    this.print("{", indent + 2, "plain");
                    context = this.contextPlus(context, 6);
                }
                this.newLine(indent);
                this.decompile(body, indent + 4, precedence, context);
                if (!braces) break;
                this.newLine(indent);
                this.print("}", indent, "plain");
                break;
            }
            case 64: {
                boolean braces;
                Tree nextctvar;
                Tree stride = control.down(4);
                if (ILUtils.isNullOrNone(stride)) {
                    stride = ILUtils.build(103, 1);
                }
                String test = "<=";
                if (!ILUtils.evalsToGTZero(stride)) {
                    if (ILUtils.evalsToLTZero(stride)) {
                        test = ">=";
                    } else {
                        TapEnv.toolWarning(-1, "(C decompiler) Can't choose loop exit test in " + ILUtils.toString(control));
                    }
                }
                Tree ctvar = control.down(1);
                Tree cttype = null;
                if (ctvar.opCode() == 199) {
                    cttype = ctvar.down(2);
                    ctvar = ctvar.down(3).down(1);
                }
                Tree toTree = control.down(3);
                if (ILUtils.evalsToOne(stride)) {
                    nextctvar = ILUtils.build(194, ILUtils.build(96, "++prefix"), ILUtils.copy(ctvar));
                    toTree = ILUtils.addTree(toTree, stride);
                    test = "<";
                } else if (ILUtils.evalsToMinusOne(stride)) {
                    nextctvar = ILUtils.build(194, ILUtils.build(96, "--prefix"), ILUtils.copy(ctvar));
                    toTree = ILUtils.addTree(toTree, stride);
                    test = ">";
                } else {
                    nextctvar = ILUtils.isExpressionIntConstant(stride) && ILUtils.intConstantValue(stride) < 0 ? ILUtils.build(125, ILUtils.copy(ctvar), ILUtils.build(103, -ILUtils.intConstantValue(stride))) : ILUtils.build(150, ILUtils.copy(ctvar), ILUtils.copy(stride));
                }
                int context2 = this.contextPlus(context, 8);
                this.print("for", indent, "keyword");
                this.space();
                this.print("(", indent, "plain");
                if (cttype != null) {
                    this.decompileTypeSpec(cttype, indent, precedence, context2);
                    this.space();
                }
                this.decompileExpression(ctvar, indent, precedence, context2);
                this.space();
                this.print("=", indent, "plain");
                this.space();
                this.decompileExpression(control.down(2), indent, precedence, context2);
                this.print(";", indent, "plain");
                this.space();
                this.decompileExpression(ctvar, indent, precedence, context2);
                this.space();
                this.print(test, indent, "plain");
                this.space();
                this.decompileExpression(toTree, indent, precedence, context2);
                this.print(";", indent, "plain");
                this.space();
                this.decompileExpression(nextctvar, indent, precedence, context2);
                this.print(")", indent, "plain");
                boolean bl = braces = CDecompiler.hasDeclsOrIsLongOrIsEmpty(body, true) || label.opCode() != 138;
                if (braces) {
                    this.space();
                    this.print("{", indent, "plain");
                    context = this.contextPlus(context, 6);
                }
                this.newLine(indent);
                this.decompile(body, indent + 4, precedence, context);
                if (label.opCode() != 138) {
                    this.newLine(indent);
                    this.decompileExpression(label, indent - 2, 0, context);
                    this.print(": ;", indent, "plain");
                }
                if (!braces) break;
                this.newLine(indent);
                this.print("}", indent, "plain");
                break;
            }
            default: {
                TapEnv.toolWarning(-1, "(C decompiler) [Loop] Unexpected control operator " + tree.opName());
            }
        }
        this.postDecompile(tree, indent);
    }

    private boolean isTypeSpec(Tree tree) {
        switch (tree.opCode()) {
            case 13: 
            case 29: 
            case 35: 
            case 41: 
            case 67: 
            case 78: 
            case 91: 
            case 96: 
            case 104: 
            case 129: 
            case 138: 
            case 154: 
            case 161: 
            case 195: 
            case 204: {
                return true;
            }
        }
        return false;
    }

    private boolean isAStarPointerAccess(Tree tree) {
        return tree.opCode() == 151 && (ILUtils.isNullOrNone(tree.down(2)) || this.isAStarPointerAccess(tree.down(1)));
    }

    private TapList<Tree> sortModifiers(Tree[] modifiers) {
        TapList<Object> toResult;
        TapList<Object> result = toResult = new TapList<Object>(null, null);
        TapList<Tree> first = null;
        TapList<Tree> second = null;
        for (int i = modifiers.length - 1; i >= 0; --i) {
            if (modifiers[i].opCode() == 96) {
                String modifierText = modifiers[i].stringValue();
                if (modifierText.equals("private") || modifierText.equals("save") || modifierText.equals("unsigned")) {
                    first = new TapList<Tree>(modifiers[i], first);
                    continue;
                }
                if (modifierText.equals("const")) {
                    second = new TapList<Tree>(modifiers[i], second);
                    continue;
                }
                result.placdl(modifiers[i]);
                continue;
            }
            if (modifiers[i].opCode() == 138) continue;
            result.placdl(modifiers[i]);
        }
        return TapList.append(first, TapList.append(second, toResult.tail));
    }

    private int modifiersContains(Tree tree, String m) {
        int rank = -1;
        if (tree.opCode() == 130) {
            Tree[] sons = tree.children();
            for (int i = 0; i < sons.length; ++i) {
                Tree s = sons[i];
                if (s.opCode() != 96 && s.opCode() != 103 || !s.stringValue().equals(m)) continue;
                rank = i + 1;
            }
        }
        return rank;
    }

    private Tree[] buildDeclaratorFromType(Tree type, Tree decl) {
        boolean assign;
        Tree newType = ILUtils.copy(type);
        Tree newDecl = ILUtils.copy(decl);
        Tree value = null;
        boolean changed = true;
        boolean bl = assign = decl.opCode() == 14;
        if (assign) {
            newDecl = ILUtils.copy(decl.down(1));
            value = ILUtils.copy(decl.down(2));
        }
        block6: while (changed) {
            changed = false;
            assert (newType != null);
            switch (newType.opCode()) {
                case 154: {
                    newDecl = ILUtils.build(153, newDecl);
                    newType = newType.down(1);
                    changed = true;
                    continue block6;
                }
                case 13: {
                    newDecl = ILUtils.build(11, newDecl, ILUtils.copy(newType.down(2)));
                    newType = newType.down(1);
                    changed = true;
                    continue block6;
                }
                case 91: {
                    newDecl = ILUtils.build(90, newDecl, ILUtils.copy(newType.down(2)));
                    newType = newType.down(1);
                    changed = true;
                    continue block6;
                }
                case 129: {
                    if (this.modifiersContains(newType.down(1), "restrict") != -1 || this.modifiersContains(newType.down(1), "__restrict") != -1) {
                        changed = false;
                        continue block6;
                    }
                    int rankd = this.modifiersContains(newType.down(1), "double");
                    int rankld = this.modifiersContains(newType.down(1), "long double");
                    if ((rankd != -1 || rankld != -1) && newType.down(2).opCode() == 78) {
                        if (newType.down(1).length() == 1) {
                            newType = ILUtils.build(96, rankd == -1 ? "long double" : "double");
                        } else {
                            newType.setChild(ILUtils.build(96, rankd == -1 ? "long double" : "double"), 2);
                            newType.down(1).removeChild(rankd == -1 ? rankld : rankd);
                        }
                        changed = true;
                        continue block6;
                    }
                    Tree subTypeSpec = newType.down(2);
                    if (subTypeSpec.opCode() == 96) continue block6;
                    Tree[] pair = this.buildDeclaratorFromType(subTypeSpec, newDecl);
                    newType = ILUtils.build(129, ILUtils.copy(newType.down(1)), ILUtils.copy(pair[0]));
                    newDecl = pair[1];
                    changed = newType.equalsTree(pair[0]);
                    continue block6;
                }
            }
            changed = false;
        }
        if (ILUtils.isAConstModified(newDecl)) {
            newType = TypeSpec.addTypeModifiers(newType, new TapList<Tree>(ILUtils.copy(newDecl.down(1).down(1)), null));
            newDecl = newDecl.down(2);
        } else {
            assert (newDecl != null);
            if (newDecl.opCode() == 11 && ILUtils.isAConstModified(newDecl.down(1))) {
                newType = TypeSpec.addTypeModifiers(newType, new TapList<Tree>(ILUtils.copy(newDecl.down(1).down(1).down(1)), null));
                newDecl = ILUtils.build(11, ILUtils.copy(newDecl.down(1).down(2)), ILUtils.copy(newDecl.down(2)));
            }
        }
        Tree[] pair = new Tree[2];
        newType.copyAnnotations(type);
        pair[0] = newType;
        if (assign) {
            newDecl = ILUtils.build(14, ILUtils.copy(newDecl), value);
        }
        newDecl.copyAnnotations(decl);
        pair[1] = newDecl;
        return pair;
    }

    @Override
    protected void tryFlushComments(int indent, boolean prefix) throws IOException {
        if ((this.posX == 0 || this.endOfUnit) && this.waitingComments != null) {
            if (this.endOfUnit && this.posX != 0) {
                this.printer.newLine();
                this.posX = 0;
                ++this.posY;
            }
            while (this.waitingComments != null) {
                this.printOneCommentLine(this.commentChar + (String)this.waitingComments.head, indent);
                if (this.waitingComments.tail != null || prefix) {
                    this.printer.newLine();
                }
                this.posX = 0;
                ++this.posY;
                this.waitingComments = this.waitingComments.tail;
            }
            this.endOfUnit = false;
        }
    }

    @Override
    protected void tryFlushCommentsBlock(int indent, boolean prefix) throws IOException {
        if ((this.posX == 0 || this.endOfUnit) && this.waitingCommentsBlock != null) {
            if (this.endOfUnit && this.posX != 0) {
                this.printer.newLine();
                this.posX = 0;
                ++this.posY;
            }
            this.print("/*", indent, "comment");
            while (this.waitingCommentsBlock != null) {
                this.printString((String)this.waitingCommentsBlock.head);
                if (this.waitingCommentsBlock.tail == null) {
                    this.print("*/", indent, "comment");
                }
                if (this.waitingCommentsBlock.tail != null || prefix) {
                    this.printer.newLine();
                }
                this.posX = 0;
                ++this.posY;
                this.waitingCommentsBlock = this.waitingCommentsBlock.tail;
            }
            this.endOfUnit = false;
        }
    }

    private void printThingName(Tree tree, int indent, String kind) throws IOException {
        if (tree.opCode() == 173) {
            this.printThingName(tree.down(1), indent, "typename");
            tree = tree.down(2);
            this.print("::", indent, "keyword");
        }
        this.printAtomValue(tree, indent, kind);
    }

    private void printAtomValue(Tree atomTree, int indent, String kind) throws IOException {
        String atomValueString = atomTree.stringValue();
        if (atomTree.isIntAtom()) {
            atomValueString = Integer.toString(atomTree.intValue());
        }
        this.print(atomValueString != null ? atomValueString : "Error:nullTree", indent, kind);
    }

    private void printLabel(Tree tree, int indent) throws IOException {
        String labelStr = tree.stringValue();
        if (labelStr == null || '0' <= labelStr.charAt(0) && labelStr.charAt(0) <= '9') {
            labelStr = "label" + labelStr;
        }
        this.print(labelStr, indent, "label");
    }

    private void printOneCommentLine(String text, int indent) throws IOException {
        this.printer.space(indent);
        this.printer.printText(text, "comment");
    }
}

