/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.ir2tree;

import fr.inria.tapenade.ir2tree.DeclStruct;
import fr.inria.tapenade.representation.ArrayDim;
import fr.inria.tapenade.representation.ArrayTypeSpec;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.Instruction;
import fr.inria.tapenade.representation.ModifiedTypeSpec;
import fr.inria.tapenade.representation.PointerTypeSpec;
import fr.inria.tapenade.representation.SymbolDecl;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.TypeSpec;
import fr.inria.tapenade.representation.VariableDecl;
import fr.inria.tapenade.representation.WrapperTypeSpec;
import fr.inria.tapenade.utils.Tree;

public final class VariableDeclStruct
extends DeclStruct {
    private final Tree generatedTree;
    private final TapList<VariableDecl> variableDecls;
    private WrapperTypeSpec sharedType;

    protected VariableDeclStruct(VariableDecl variableDecl, Tree tree) {
        this.generatedTree = tree;
        this.symbolDecl = variableDecl;
        this.variableDecls = new TapList<VariableDecl>(variableDecl, null);
        this.sharedType = variableDecl.type();
        if (this.sharedType != null && this.sharedType.wrappedType != null) {
            if (!(!TypeSpec.isA(this.sharedType, 2) || this.containsNameEq(this.sharedType) || TapEnv.relatedLanguageIsFortran() && this.sharedType.wrappedType.elementType() != null && this.sharedType.wrappedType.elementType().isPrimitiveTypeCharacter() || this.sharedType.getAllDimensions() == null)) {
                this.sharedType = this.sharedType.wrappedType.elementType();
                while (TypeSpec.isA(this.sharedType, 2)) {
                    this.sharedType = this.sharedType.wrappedType.elementType();
                }
            } else if (!TapEnv.relatedLanguageIsFortran() && TypeSpec.isA(this.sharedType, 5) && TypeSpec.isA(this.sharedType.wrappedType.elementType(), 2)) {
                ModifiedTypeSpec modTypeSpec = (ModifiedTypeSpec)this.sharedType.wrappedType;
                this.sharedType = new WrapperTypeSpec(new ModifiedTypeSpec(modTypeSpec.elementType().wrappedType.elementType(), modTypeSpec));
            }
            if (TypeSpec.isA(this.sharedType, 6) && !TapEnv.relatedLanguageIsFortran()) {
                if (((PointerTypeSpec)this.sharedType.wrappedType).offsetLength == null) {
                    this.sharedType = ((PointerTypeSpec)this.sharedType.wrappedType).destinationType;
                } else {
                    while (TypeSpec.isA(this.sharedType, 6) && ((PointerTypeSpec)this.sharedType.wrappedType).offsetLength != null) {
                        this.sharedType = ((PointerTypeSpec)this.sharedType.wrappedType).destinationType;
                    }
                }
            }
        }
        this.usedNames = variableDecl.dependsOn();
        this.kind = variableDecl.isA(5) ? 2 : 3;
        this.symbolDecl = variableDecl;
    }

    private boolean containsNameEq(WrapperTypeSpec typeSpec) {
        boolean result = false;
        ArrayDim[] arrayDim = ((ArrayTypeSpec)typeSpec.wrappedType).dimensions();
        for (int i = 0; i < arrayDim.length && !result; ++i) {
            if (arrayDim[i].tree() == null || arrayDim[i].tree().opCode() != 59) continue;
            result = arrayDim[i].tree().down(2).opCode() == 134;
        }
        return result;
    }

    @Override
    public Tree generateTree(TapList<SymbolDecl> declaredTypes, SymbolTable symbolTable) {
        TapList<Object> hdDeclarators;
        TapList<Object> tlDeclarators = hdDeclarators = new TapList<Object>(null, null);
        TapList<VariableDecl> inVariableDecls = this.variableDecls;
        Tree result = null;
        while (inVariableDecls != null) {
            VariableDecl variableDecl = (VariableDecl)inVariableDecls.head;
            if (!variableDecl.symbol.equals("true") && !variableDecl.symbol.equals("false") || symbolTable.basisSymbolTable() != null) {
                Tree declarator = this.generateDeclarator(variableDecl, this.sharedType, declaredTypes, symbolTable);
                if (variableDecl.isFunctionName) {
                    declarator.setAnnotation("isFunctionName", Boolean.TRUE);
                }
                tlDeclarators = tlDeclarators.placdl(declarator);
            }
            inVariableDecls = inVariableDecls.tail;
        }
        if (this.sharedType == null) {
            result = ILUtils.build(this.kind == 2 ? 45 : 199);
        } else if (hdDeclarators.tail != null) {
            if (((Tree)hdDeclarators.tail.head).opCode() != 199) {
                Tree sharedTypeTree = this.sharedType.generateTree(null, ((VariableDecl)this.variableDecls.head).dependsOn(), declaredTypes, true, null);
                if (this.symbolDecl.extraInfo() != null) {
                    sharedTypeTree = ILUtils.build(129, ILUtils.build(130, ILUtils.buildListIdents(this.symbolDecl.extraInfo())), sharedTypeTree);
                }
                result = this.kind == 2 ? ILUtils.build(45, sharedTypeTree, ILUtils.build(54, hdDeclarators.tail)) : ILUtils.build(199, ILUtils.build(130), sharedTypeTree, ILUtils.build(54, hdDeclarators.tail));
            } else {
                result = (Tree)hdDeclarators.tail.head;
            }
        }
        return result;
    }

    private Tree generateDeclarator(VariableDecl variableDecl, WrapperTypeSpec sharedTypeSpec, TapList<SymbolDecl> declaredTypes, SymbolTable symbolTable) {
        Tree declarator;
        WrapperTypeSpec typeSpec = variableDecl.type();
        Instruction instr = null;
        if (symbolTable.declarationsBlock != null) {
            instr = symbolTable.declarationsBlock.getOperatorDeclarationInstruction(variableDecl, 199, null);
        }
        Tree tree = declarator = this.generatedTree != null ? this.generatedTree : ILUtils.build(96, variableDecl.symbol);
        if (variableDecl.isReference()) {
            declarator = ILUtils.build(163, declarator);
        }
        declarator = TypeSpec.addDeclaratorModifiers(declarator, variableDecl.accessInfo);
        if (variableDecl.hasInstructionWithRootOperator(138, null) || instr == null) {
            declarator = TypeSpec.generateDeclaratorTree(sharedTypeSpec, declaredTypes, declarator, typeSpec);
            if (variableDecl.initializationTree() != null) {
                Tree initTree = ILUtils.copy(variableDecl.generateInitializationTree());
                initTree.setChild(declarator, 1);
                declarator = initTree;
            }
        } else if (!TapEnv.relatedLanguageIsFortran()) {
            Tree origDecl = instr.tree;
            declarator = ILUtils.copy(origDecl);
            int rankOfDeclVar = 0;
            if (origDecl.opCode() == 199 && origDecl.down(3).length() > 1) {
                int rank;
                boolean found = false;
                for (rank = 1; !found && rank <= origDecl.down(3).length(); ++rank) {
                    found = variableDecl.symbol.equals(ILUtils.baseName(origDecl.down(3).down(rank)));
                    if (!found) continue;
                    rankOfDeclVar = rank;
                }
                rank = rankOfDeclVar + 1;
                while (rank <= declarator.down(3).length()) {
                    declarator.down(3).removeChild(rank);
                }
                for (rank = rankOfDeclVar - 1; rank >= 1; --rank) {
                    declarator.down(3).removeChild(rank);
                }
                origDecl.down(3).removeChild(rankOfDeclVar);
            } else {
                instr.tree = null;
                variableDecl.setNoneInstruction();
            }
        }
        return declarator;
    }

    protected VariableDecl getFirstVariableDecl() {
        return (VariableDecl)this.variableDecls.head;
    }

    @Override
    public String toString() {
        StringBuilder names = new StringBuilder();
        TapList<VariableDecl> inVariableDecls = this.variableDecls;
        while (inVariableDecls != null) {
            names.append(',').append(((VariableDecl)inVariableDecls.head).symbol);
            inVariableDecls = inVariableDecls.tail;
        }
        return "declaration of " + this.sharedType + " variables " + names;
    }
}

